\ 4tH library - PARSING - Copyright 2009 J.L. Bezemer
\ You can redistribute this file and/or modify it under
\ the terms of the GNU General Public License

[UNDEFINED] "parse" [IF]
\ Perform a normal parse, but take quoted fields into account
: "parse"                              ( c -- a n)
  dup parse over c@ [char] " =         \ is the first character a quote
  if                                   \ is the last character a quote
    2dup 1- chars + c@ [char] " =      \ if so, parse again for delimiter
    if chop 1- else drop char+ swap parse 1- chars + over - exit then
  then rot drop                        \ else drop the delimiter
;

\ perform a user defined parse, but leave a false flag when EOL is detected
: (parse?) >in @ >r execute >in @ r> > ;
: parse? :noname parse ; (parse?) ;    ( c -- a n f)
: "parse"? ['] "parse" (parse?) ;      ( c -- a n f)
[THEN]
