/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Assembler instructions and directives.
*
****************************************************************************/


#ifdef MKOPCODE

#define ins(tok,op1,byte1_info,op2,op3,op_dir,rm_info,opcode,rm_byte,cpu,prefix) tok,

#if defined( _STANDALONE_ )
    #define insa(tok,op1,byte1_info,op2,op3,op_dir,rm_info,opcode,rm_byte,cpu,prefix) tok,
#else
    #define insa(tok,op1,byte1_info,op2,op3,op_dir,rm_info,opcode,rm_byte,cpu,prefix)
#endif

const unsigned short AsmOpTable[] = {

#else

#define ins(tok,op1,byte1_info,op2,op3,op_dir,rm_info,opcode,rm_byte,cpu,prefix) \
                {tok,prefix,byte1_info,rm_info,op3,op_dir,cpu,{op1,op2},opcode,rm_byte},

#if defined( _STANDALONE_ )
    #define insa(tok,op1,byte1_info,op2,op3,op_dir,rm_info,opcode,rm_byte,cpu,prefix) \
                ins(tok,op1,byte1_info,op2,op3,op_dir,rm_info,opcode,rm_byte,cpu,prefix)
#else
    #define insa(tok,op1,byte1_info,op2,op3,op_dir,rm_info,opcode,rm_byte,cpu,prefix)
#endif

const struct asm_ins ASMFAR AsmOpTable[] = {

#endif

/*   tok                op1          b1_info op2           op3   op_dir rm_info opcode     rm_byte                   cpu     prefix  */

ins (T_DOT_186,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_286,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_286C,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_286P,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_287,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_386,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_386P,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_387,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_486,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_486P,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_586,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_586P,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_686,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_686P,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_8086,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_8087,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ALPHA,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_BREAK,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_CODE,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_CONST,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_CONTINUE,    OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_CREF,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_DATA,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_DATA_UN,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_DOSSEG,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_ELSE,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_ENDIF,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_ENDW,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_ERR,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRB,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRDEF,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRDIF,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRDIFI,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRE,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRIDN,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRIDNI,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRNB,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRNDEF,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_ERRNZ,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_EXIT,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_FARDATA,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_FARDATA_UN,  OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_IF,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_DOT_K3D,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_586,       0)
insa(T_DOT_LFCOND,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_LIST,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_LISTALL,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_LISTIF,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_LISTMACRO,   OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_LISTMACROALL,OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_DOT_MMX,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_586,       0)
insa(T_DOT_MODEL,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_DOT_NO87,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_DOT_NOCREF,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_NOLIST,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_RADIX,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_REPEAT,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_SALL,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_SEQ,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_SFCOND,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_STACK,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_STARTUP,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_TFCOND,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_UNTIL,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_WHILE,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_XCREF,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_DOT_XLIST,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_DOT_XMM,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_686,       0)
ins (T_DOT_XMM2,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_686,       0)
ins (T_DOT_XMM3,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_686,       0)
ins (T_AAA,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x37,     0x00,                     P_86,        0)
ins (T_AAD,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD5,     0x0A,                     P_86,        0)
ins (T_AAM,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD4,     0x0A,                     P_86,        0)
ins (T_AAS,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x3F,     0x00,                     P_86,        0)
ins (T_ADC,             OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x10,                     P_86,        0)
ins (T_ADC,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x12,     0x00,                     P_86,        0)
ins (T_ADC,             OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x12,     0x00,                     P_86,        0)
ins (T_ADC,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x14,     0x00,                     P_86,        0)
ins (T_ADC,             OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x10,                     P_86,        0)
ins (T_ADC,             OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x10,                     P_386,       LOCK)
ins (T_ADC,             OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x10,                     P_86,        LOCK)
ins (T_ADC,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x10,     0x00,                     P_86,        LOCK)
ins (T_ADC,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x10,                     P_86,        LOCK)
ins (T_ADD,             OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x00,                     P_86,        0)
ins (T_ADD,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x02,     0x00,                     P_86,        0)
ins (T_ADD,             OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x02,     0x00,                     P_86,        0)
ins (T_ADD,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x04,     0x00,                     P_86,        0)
ins (T_ADD,             OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x00,                     P_86,        0)
ins (T_ADD,             OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x00,                     P_386,       LOCK)
ins (T_ADD,             OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x00,                     P_86,        LOCK)
ins (T_ADD,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x00,     0x00,                     P_86,        LOCK)
ins (T_ADD,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x00,                     P_86,        LOCK)
ins (T_ADDPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x58,     0x00,                     P_686|P_SSE2,0)
ins (T_ADDPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x58,     0x00,                     P_686|P_SSE, 0)
insa(T_ADDR,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_ADDSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x58,     0x00,                     P_686|P_SSE2,0)
ins (T_ADDSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x58,     0x00,                     P_686|P_SSE, 0)
ins (T_ADDSUBPD,        OP_XMM,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xD0,     0x00,                     P_686|P_SSE3,0)
ins (T_ADDSUBPS,        OP_XMM,      F_F20F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xD0,     0x00,                     P_686|P_SSE3,0)
ins (T_AH,              OP_SPECIAL,  0,      OP_R8,         0,       0,  0,      4,        OP_REGISTER,              P_86,        0)
ins (T_AL,              OP_SPECIAL,  0,      OP_AL,         0,       0,  0,      0,        OP_REGISTER,              P_86,        0)
insa(T_ALIAS,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ALIGN,           OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_AND,             OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x20,                     P_86,        0)
ins (T_AND,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x22,     0x00,                     P_86,        0)
ins (T_AND,             OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x22,     0x00,                     P_86,        0)
ins (T_AND,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x24,     0x00,                     P_86,        0)
ins (T_AND,             OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x20,                     P_86,        0)
ins (T_AND,             OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x20,                     P_386,       LOCK)
ins (T_AND,             OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x20,                     P_86,        LOCK)
ins (T_AND,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x20,     0x00,                     P_86,        LOCK)
ins (T_AND,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x20,                     P_86,        LOCK)
ins (T_ANDNPD,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x55,     0x00,                     P_686|P_SSE2,0)
ins (T_ANDNPS,          OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x55,     0x00,                     P_686|P_SSE, 0)
ins (T_ANDPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x54,     0x00,                     P_686|P_SSE2,0)
ins (T_ANDPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x54,     0x00,                     P_686|P_SSE, 0)
insa(T_ARG,             OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_ARPL,            OP_R16,      0,      OP_R16,        OP3_NONE,0,  no_WDS, 0x63,     0x00,                     P_286,       0)
ins (T_ARPL,            OP_M16,      0,      OP_R16,        OP3_NONE,0,  no_WDS, 0x63,     0x00,                     P_286,       0)
insa(T_ASSUME,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_AX,              OP_SPECIAL,  0,      OP_AX,         0,       0,  0,      0,        OP_REGISTER,              P_86,        0)
ins (T_BH,              OP_SPECIAL,  0,      OP_R8,         0,       0,  0,      7,        OP_REGISTER,              P_86,        0)
ins (T_BL,              OP_SPECIAL,  0,      OP_R8,         0,       0,  0,      3,        OP_REGISTER,              P_86,        0)
ins (T_BOUND,           OP_R1632,    0,      OP_M,          OP3_NONE,1,  no_WDS, 0x62,     0x00,                     P_186,       0)
ins (T_BP,              OP_SPECIAL,  0,      OP_R16,        0,       0,  0,      5,        OP_REGISTER,              P_86,        IREG)
ins (T_BSF,             OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,1,  no_WDS, 0xBC,     0x00,                     P_386,       0)
ins (T_BSF,             OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xBC,     0x00,                     P_386,       0)
ins (T_BSR,             OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,1,  no_WDS, 0xBD,     0x00,                     P_386,       0)
ins (T_BSR,             OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xBD,     0x00,                     P_386,       0)
ins (T_BSWAP,           OP_R32,      F_0F,   OP_NONE,       OP3_NONE,0,  R_in_OP,0xC8,     0x00,                     P_486,       0)
ins (T_BT,              OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xA3,     0x00,                     P_386,       0)
ins (T_BT,              OP_R1632,    F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x20,                     P_386,       0)
ins (T_BT,              OP_M,        F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xA3,     0x00,                     P_386,       0)
ins (T_BT,              OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x20,                     P_386,       0)
ins (T_BTC,             OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xBB,     0x00,                     P_386,       0)
ins (T_BTC,             OP_R1632,    F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x38,                     P_386,       0)
ins (T_BTC,             OP_M,        F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xBB,     0x00,                     P_386,       LOCK)
ins (T_BTC,             OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x38,                     P_386,       LOCK)
ins (T_BTR,             OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xB3,     0x00,                     P_386,       0)
ins (T_BTR,             OP_R1632,    F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x30,                     P_386,       0)
ins (T_BTR,             OP_M,        F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xB3,     0x00,                     P_386,       LOCK)
ins (T_BTR,             OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x30,                     P_386,       LOCK)
ins (T_BTS,             OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xAB,     0x00,                     P_386,       0)
ins (T_BTS,             OP_R1632,    F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x28,                     P_386,       0)
ins (T_BTS,             OP_M,        F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xAB,     0x00,                     P_386,       LOCK)
ins (T_BTS,             OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x28,                     P_386,       LOCK)
ins (T_BX,              OP_SPECIAL,  0,      OP_R16,        0,       0,  0,      3,        OP_REGISTER,              P_86,        IREG)
ins (T_BYTE,            OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_CALL,            OP_R1632,    0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x10,                     P_86,        0)
ins (T_CALL,            OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE8,     0x00,                     P_86,        0)
ins (T_CALL,            OP_I32,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE8,     0x00,                     P_386,       0)
ins (T_CALL,            OP_J32,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9A,     0x00,                     P_86,        0)
ins (T_CALL,            OP_J48,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9A,     0x00,                     P_386,       0)
ins (T_CALL,            OP_M_FW,     F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x18,                     P_386,       0)
ins (T_CALL,            OP_M_W,      F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x10,                     P_86,        0)
ins (T_CALL,            OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x10,                     P_86,        0)
ins (T_CALLF,           OP_I,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x9A,     0x00,                     P_86,        0)
ins (T_CALLF,           OP_J32,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9A,     0x00,                     P_86,        0)
ins (T_CALLF,           OP_J48,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9A,     0x00,                     P_386,       0)
ins (T_CALLF,           OP_M_DW,     F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x18,                     P_86,        0)
ins (T_CALLF,           OP_M_FW,     F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x18,                     P_386,       0)
insa(T_CASEMAP,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_CATSTR,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_CBW,             OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x98,     0x00,                     P_86,        0)
ins (T_CDQ,             OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x99,     0x00,                     P_386,       0)
ins (T_CH,              OP_SPECIAL,  0,      OP_R8,         0,       0,  0,      5,        OP_REGISTER,              P_86,        0)
ins (T_CL,              OP_SPECIAL,  0,      OP_CL,         0,       0,  0,      1,        OP_REGISTER,              P_86,        0)
ins (T_CLC,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF8,     0x00,                     P_86,        0)
ins (T_CLD,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFC,     0x00,                     P_86,        0)
ins (T_CLFLUSH,         OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x38,                     P_686|P_SSE2,0)
ins (T_CLI,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFA,     0x00,                     P_86,        0)
ins (T_CLTS,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0x0F,     0x06,                     P_286p,      0)
ins (T_CMC,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF5,     0x00,                     P_86,        0)

#define cmov( cond, code )      \
ins (T_CMOV##cond,      OP_R,        F_0F,   OP_R,          OP3_NONE,1,  no_WDS, 0x40+code,0x00,                     P_686,       0) \
ins (T_CMOV##cond,      OP_R,        F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x40+code,0x00,                     P_686,       0)

cmov( A,   0x7 )
cmov( AE,  0x3 )
cmov( B,   0x2 )
cmov( BE,  0x6 )
cmov( C,   0x2 )
cmov( E,   0x4 )
cmov( G,   0xf )
cmov( GE,  0xd )
cmov( L,   0xc )
cmov( LE,  0xe )
cmov( NA,  0x6 )
cmov( NAE, 0x2 )
cmov( NB,  0x3 )
cmov( NBE, 0x7 )
cmov( NC,  0x3 )
cmov( NE,  0x5 )
cmov( NG,  0xe )
cmov( NGE, 0xc )
cmov( NL,  0xd )
cmov( NLE, 0xf )
cmov( NO,  0x1 )
cmov( NP,  0xb )
cmov( NS,  0x9 )
cmov( NZ,  0x5 )
cmov( O,   0x0 )
cmov( P,   0xa )
cmov( PE,  0xa )
cmov( PO,  0xb )
cmov( S,   0x8 )
cmov( Z,   0x4 )

ins (T_CMP,             OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x38,                     P_86,        0)
ins (T_CMP,             OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x3A,     0x00,                     P_86,        0)
ins (T_CMP,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x3A,     0x00,                     P_86,        0)
ins (T_CMP,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x3C,     0x00,                     P_86,        0)
ins (T_CMP,             OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x38,                     P_86,        0)
ins (T_CMP,             OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x38,                     P_386,       0)
ins (T_CMP,             OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x38,                     P_86,        0)
ins (T_CMP,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x38,     0x00,                     P_86,        0)
ins (T_CMP,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x38,                     P_86,        0)
ins (T_CMPEQPD,         OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|0,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPEQPS,         OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|0,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPEQSD,         OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|0,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPEQSS,         OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|0,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPLEPD,         OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|2,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPLEPS,         OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|2,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPLESD,         OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|2,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPLESS,         OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|2,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPLTPD,         OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|1,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPLTPS,         OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|1,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPLTSD,         OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|1,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPLTSS,         OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|1,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPNEQPD,        OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|4,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPNEQPS,        OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|4,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPNEQSD,        OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|4,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPNEQSS,        OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|4,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPNLEPD,        OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|6,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPNLEPS,        OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|6,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPNLESD,        OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|6,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPNLESS,        OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|6,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPNLTPD,        OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|5,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPNLTPS,        OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|5,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPNLTSD,        OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|5,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPNLTSS,        OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|5,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPORDPD,        OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|7,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPORDPS,        OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|7,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPORDSD,        OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|7,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPORDSS,        OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|7,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE ,0)
ins (T_CMPPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE, 0)
ins (T_CMPS,            OP_M,        0,      OP_M,          OP3_NONE,0,  no_RM,  0xA6,     0x00,                     P_86,        REPxx)
ins (T_CMPSB,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xA6,     0x00,                     P_86,        REPxx)
ins (T_CMPSD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA7,     0x00,                     P_386,       REPxx)
ins (T_CMPSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE, 0)
ins (T_CMPSW,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,1,  no_RM,  0xA7,     0x00,                     P_86,        REPxx)
ins (T_CMPUNORDPD,      OP_XMM,      F_660F, OP_XMM|OP_M,  OP3_HID|3,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPUNORDPS,      OP_XMM,      F_0F,   OP_XMM|OP_M,  OP3_HID|3,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE, 0)
ins (T_CMPUNORDSD,      OP_XMM,      F_F20F, OP_XMM|OP_M,  OP3_HID|3,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE2,0)
ins (T_CMPUNORDSS,      OP_XMM,      F_F30F, OP_XMM|OP_M32,OP3_HID|3,1,  no_WDS, 0xC2,     0x00,                     P_686|P_SSE, 0)
ins (T_CMPXCHG,         OP_R,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xB0,     0x00,                     P_486,       0)
ins (T_CMPXCHG,         OP_M,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xB0,     0x00,                     P_486,       LOCK)
ins (T_CMPXCHG8B,       OP_M_QW|OP_M,F_0F,   OP_NONE,       OP3_NONE,0,  0,      0xC7,     0x08,                     P_586,       LOCK)
insa(T_CODESEG,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
ins (T_COMISD,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2F,     0x00,                     P_686|P_SSE2,0)
ins (T_COMISS,          OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2F,     0x00,                     P_686|P_SSE, 0)
insa(T_COMM,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_COMMENT,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_CONST,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
ins (T_CPUID,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0x0F,     0xA2,                     P_586,       0)
ins (T_CR0,             OP_SPECIAL,  0,      OP_CR,         0,       0,  0,      0,        OP_REGISTER,              P_386,       0)
ins (T_CR2,             OP_SPECIAL,  0,      OP_CR,         0,       0,  0,      2,        OP_REGISTER,              P_386,       0)
ins (T_CR3,             OP_SPECIAL,  0,      OP_CR,         0,       0,  0,      3,        OP_REGISTER,              P_386,       0)
ins (T_CR4,             OP_SPECIAL,  0,      OP_CR,         0,       0,  0,      4,        OP_REGISTER,              P_586,       0)
ins (T_CS,              OP_SPECIAL,  0,      OP_SR2,        0,       0,  0,      PREFIX_CS,OP_REGISTER,              P_86,        IREG)
ins (T_CVTDQ2PD,        OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE6,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTDQ2PS,        OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5B,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTPD2DQ,        OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE6,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTPD2PI,        OP_MMX,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2D,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTPD2PS,        OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5A,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTPI2PD,        OP_XMM,      F_660F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x2A,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTPI2PS,        OP_XMM,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x2A,     0x00,                     P_686|P_SSE, 0)
ins (T_CVTPS2DQ,        OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5B,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTPS2PD,        OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5A,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTPS2PI,        OP_MMX,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2D,     0x00,                     P_686|P_SSE, 0)
ins (T_CVTSD2SI,        OP_R32,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2D,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTSD2SS,        OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5A,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTSI2SD,        OP_XMM,      F_F20F, OP_R32,        OP3_NONE,1,  no_WDS, 0x2A,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTSI2SD,        OP_XMM,      F_F20F, OP_M,          OP3_NONE,1,  no_WDS, 0x2A,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTSI2SS,        OP_XMM,      F_F30F, OP_R32,        OP3_NONE,1,  no_WDS, 0x2A,     0x00,                     P_686|P_SSE, 0)
ins (T_CVTSI2SS,        OP_XMM,      F_F30F, OP_M,          OP3_NONE,1,  no_WDS, 0x2A,     0x00,                     P_686|P_SSE, 0)
ins (T_CVTSS2SD,        OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5A,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTSS2SI,        OP_R32,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2D,     0x00,                     P_686|P_SSE, 0)
ins (T_CVTTPD2DQ,       OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE6,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTTPD2PI,       OP_MMX,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2C,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTTPS2DQ,       OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5B,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTTPS2PI,       OP_MMX,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2C,     0x00,                     P_686|P_SSE, 0)
ins (T_CVTTSD2SI,       OP_R32,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2C,     0x00,                     P_686|P_SSE2,0)
ins (T_CVTTSS2SI,       OP_R32,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2C,     0x00,                     P_686|P_SSE, 0)
ins (T_CWD,             OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x99,     0x00,                     P_86,        0)
ins (T_CWDE,            OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x98,     0x00,                     P_386,       0)
ins (T_CX,              OP_SPECIAL,  0,      OP_R16,        0,       0,  0,      1,        OP_REGISTER,              P_86,        0)
ins (T_DAA,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x27,     0x00,                     P_86,        0)
ins (T_DAS,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x2F,     0x00,                     P_86,        0)
insa(T_DATASEG,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
ins (T_DB,              OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_DD,              OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_DEC,             OP_R1632,    0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x48,     0x00,                     P_86,        0)
ins (T_DEC,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x08,                     P_86,        0)
ins (T_DEC,             OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x08,                     P_86,        LOCK)
ins (T_DEC,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x08,                     P_386,       LOCK)
ins (T_DEC,             OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x08,                     P_86,        LOCK)
ins (T_DF,              OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_DH,              OP_SPECIAL,  0,      OP_R8,         0,       0,  0,      6,        OP_REGISTER,              P_86,        0)
ins (T_DI,              OP_SPECIAL,  0,      OP_R16,        0,       0,  0,      7,        OP_REGISTER,              P_86,        IREG)
ins (T_DIV,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x30,                     P_86,        0)
ins (T_DIV,             OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x30,                     P_86,        0)
ins (T_DIV,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x30,                     P_386,       0)
ins (T_DIV,             OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x30,                     P_86,        0)
ins (T_DIV,             OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x30,                     P_86,        0)
ins (T_DIVPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5E,     0x00,                     P_686|P_SSE2,0)
ins (T_DIVPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5E,     0x00,                     P_686|P_SSE, 0)
ins (T_DIVSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5E,     0x00,                     P_686|P_SSE2,0)
ins (T_DIVSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5E,     0x00,                     P_686|P_SSE, 0)
ins (T_DL,              OP_SPECIAL,  0,      OP_R8,         0,       0,  0,      2,        OP_REGISTER,              P_86,        0)
insa(T_DOSSEG,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_DP,              OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
insa(T_DQ,              OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_DR0,             OP_SPECIAL,  0,      OP_DR,         0,       0,  0,      0,        OP_REGISTER,              P_386,       0)
ins (T_DR1,             OP_SPECIAL,  0,      OP_DR,         0,       0,  0,      1,        OP_REGISTER,              P_386,       0)
ins (T_DR2,             OP_SPECIAL,  0,      OP_DR,         0,       0,  0,      2,        OP_REGISTER,              P_386,       0)
ins (T_DR3,             OP_SPECIAL,  0,      OP_DR,         0,       0,  0,      3,        OP_REGISTER,              P_386,       0)
ins (T_DR6,             OP_SPECIAL,  0,      OP_DR,         0,       0,  0,      6,        OP_REGISTER,              P_386,       0)
ins (T_DR7,             OP_SPECIAL,  0,      OP_DR,         0,       0,  0,      7,        OP_REGISTER,              P_386,       0)
ins (T_DS,              OP_SPECIAL,  0,      OP_SR2,        0,       0,  0,      PREFIX_DS,OP_REGISTER,              P_86,        0)
insa(T_DT,              OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_DUP,             OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_DW,              OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_DWORD,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_DX,              OP_SPECIAL,  0,      OP_DX,         0,       0,  0,      2,        OP_REGISTER,              P_86,        0)
ins (T_EAX,             OP_SPECIAL,  0,      OP_EAX,        0,       0,  0,      0,        OP_REGISTER,              P_386,       IREG)
ins (T_EBP,             OP_SPECIAL,  0,      OP_R32,        0,       0,  0,      5,        OP_REGISTER,              P_386,       IREG)
ins (T_EBX,             OP_SPECIAL,  0,      OP_R32,        0,       0,  0,      3,        OP_REGISTER,              P_386,       IREG)
insa(T_ECHO,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_ECX,             OP_SPECIAL,  0,      OP_R32,        0,       0,  0,      1,        OP_REGISTER,              P_386,       IREG)
ins (T_EDI,             OP_SPECIAL,  0,      OP_R32,        0,       0,  0,      7,        OP_REGISTER,              P_386,       IREG)
ins (T_EDX,             OP_SPECIAL,  0,      OP_R32,        0,       0,  0,      2,        OP_REGISTER,              P_386,       IREG)
insa(T_ELSE,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIF,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIF1,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIF2,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFB,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFDEF,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFDIF,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFDIFI,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFE,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFIDN,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFIDNI,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFNB,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ELSEIFNDEF,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_EMMS,            OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x77,     0x00,                     P_586|P_MMX, 0)
insa(T_END,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECT_EXPR,           0,           0)
insa(T_ENDIF,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_ENDM,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_ENDP,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_ENDS,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_ENTER,           OP_I16,      0,      OP_I8_U,       OP3_NONE,0,  no_RM,  0xC8,     0x00,                     P_186,       0)
insa(T_ENUM,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_EQ,              OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_ARITHOP,               P_86,        0)
insa(T_EQU,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_EQU2,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_ERR,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFB,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFDEF,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFDIF,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFDIFI,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFE,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFIDN,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFIDNI,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFNB,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_ERRIFNDEF,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
ins (T_ES,              OP_SPECIAL,  0,      OP_SR2,        0,       0,  0,      PREFIX_ES,OP_REGISTER,              P_86,        0)
ins (T_ESI,             OP_SPECIAL,  0,      OP_R32,        0,       0,  0,      6,        OP_REGISTER,              P_386,       IREG)
ins (T_ESP,             OP_SPECIAL,  0,      OP_R32,        0,       0,  0,      4,        OP_REGISTER,              P_386,       IREG)
insa(T_EVEN,            OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_EXITCODE,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
insa(T_EXITM,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_EXTERN,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_EXTERNDEF,       OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_EXTRN,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_F2XM1,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF0,                     P_87,        0)
ins (T_FABS,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE1,                     P_87,        0)
ins (T_FADD,            OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xC0,                     P_87,        0)
ins (T_FADD,            OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xC0,                     P_87,        0)
ins (T_FADD,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x00,                     P_87,        0)
ins (T_FADD,            OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x00,                     P_87,        0)
ins (T_FADD,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xC1,                     P_87,        0)
ins (T_FADDP,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xC0,                     P_87,        0)
ins (T_FAR,             OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
insa(T_FARDATA,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
ins (T_FBLD,            OP_M_TB,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x20,                     P_87,        0)
ins (T_FBSTP,           OP_M_TB,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x30,                     P_87,        0)
ins (T_FCHS,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE0,                     P_87,        0)
ins (T_FCLEX,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE2,                     P_87,        FWAIT)
ins (T_FCMOVB,          OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xC0,                     P_686,       0)
ins (T_FCMOVBE,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xD0,                     P_686,       0)
ins (T_FCMOVE,          OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xC8,                     P_686,       0)
ins (T_FCMOVNB,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xC0,                     P_686,       0)
ins (T_FCMOVNBE,        OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xD0,                     P_686,       0)
ins (T_FCMOVNE,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xC8,                     P_686,       0)
ins (T_FCMOVNU,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xD8,                     P_686,       0)
ins (T_FCMOVU,          OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xD8,                     P_686,       0)
ins (T_FCOM,            OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD0,                     P_87,        0)
ins (T_FCOM,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x10,                     P_87,        0)
ins (T_FCOM,            OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x10,                     P_87,        0)
ins (T_FCOM,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD1,                     P_87,        0)
ins (T_FCOMI,           OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xF0,                     P_686,       0)
ins (T_FCOMIP,          OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDF,     0xF0,                     P_686,       0)
ins (T_FCOMP,           OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD8,                     P_87,        0)
ins (T_FCOMP,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x18,                     P_87,        0)
ins (T_FCOMP,           OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x18,                     P_87,        0)
ins (T_FCOMP,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD9,                     P_87,        0)
ins (T_FCOMPP,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xD9,                     P_87,        0)
ins (T_FCOS,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFF,                     P_387,       0)
ins (T_FDECSTP,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF6,                     P_87,        0)
ins (T_FDISI,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE1,                     P_87,        FWAIT)
ins (T_FDIV,            OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xF8,                     P_87,        0)
ins (T_FDIV,            OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xF0,                     P_87,        0)
ins (T_FDIV,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x30,                     P_87,        0)
ins (T_FDIV,            OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x30,                     P_87,        0)
ins (T_FDIV,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xF9,                     P_87,        0)
ins (T_FDIVP,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xF8,                     P_87,        0)
ins (T_FDIVR,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xF0,                     P_87,        0)
ins (T_FDIVR,           OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xF8,                     P_87,        0)
ins (T_FDIVR,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x38,                     P_87,        0)
ins (T_FDIVR,           OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x38,                     P_87,        0)
ins (T_FDIVR,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xF1,                     P_87,        0)
ins (T_FDIVRP,          OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xF0,                     P_87,        0)
ins (T_FEMMS,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x0E,     0x00,                     P_586|P_K3D, 0)
ins (T_FENI,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE0,                     P_87,        FWAIT)
ins (T_FFREE,           OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xC0,                     P_87,        0)
ins (T_FIADD,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x00,                     P_87,        0)
ins (T_FIADD,           OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x00,                     P_87,        0)
ins (T_FICOM,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x10,                     P_87,        0)
ins (T_FICOM,           OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x10,                     P_87,        0)
ins (T_FICOMP,          OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x18,                     P_87,        0)
ins (T_FICOMP,          OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x18,                     P_87,        0)
ins (T_FIDIV,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x30,                     P_87,        0)
ins (T_FIDIV,           OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x30,                     P_87,        0)
ins (T_FIDIVR,          OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x38,                     P_87,        0)
ins (T_FIDIVR,          OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x38,                     P_87,        0)
ins (T_FILD,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x00,                     P_87,        0)
ins (T_FILD,            OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x28,                     P_87,        0)
ins (T_FILD,            OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x00,                     P_87,        0)
ins (T_FIMUL,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x08,                     P_87,        0)
ins (T_FIMUL,           OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x08,                     P_87,        0)
ins (T_FINCSTP,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF7,                     P_87,        0)
ins (T_FINIT,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE3,                     P_87,        FWAIT)
ins (T_FIST,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x10,                     P_87,        0)
ins (T_FIST,            OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x10,                     P_87,        0)
ins (T_FISTP,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x18,                     P_87,        0)
ins (T_FISTP,           OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x38,                     P_87,        0)
ins (T_FISTP,           OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x18,                     P_87,        0)
ins (T_FISTTP,          OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDB,     0x08,                     P_686|P_SSE3,0)
ins (T_FISTTP,          OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDD,     0x08,                     P_686|P_SSE3,0)
ins (T_FISTTP,          OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDF,     0x08,                     P_686|P_SSE3,0)
ins (T_FISUB,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x20,                     P_87,        0)
ins (T_FISUB,           OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x20,                     P_87,        0)
ins (T_FISUBR,          OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x28,                     P_87,        0)
ins (T_FISUBR,          OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x28,                     P_87,        0)
insa(T_FLAT,            OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_FLD,             OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xC0,                     P_87,        0)
ins (T_FLD,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x00,                     P_87,        0)
ins (T_FLD,             OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x00,                     P_87,        0)
ins (T_FLD,             OP_M_TB,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x28,                     P_87,        0)
ins (T_FLD1,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE8,                     P_87,        0)
ins (T_FLDCW,           OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x28,                     P_87,        0)
ins (T_FLDENV,          OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x20,                     P_87,        0)
ins (T_FLDENVD,         OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x20,                     P_387,       0)
ins (T_FLDENVW,         OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x20,                     P_387,       0)
ins (T_FLDL2E,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEA,                     P_87,        0)
ins (T_FLDL2T,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE9,                     P_87,        0)
ins (T_FLDLG2,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEC,                     P_87,        0)
ins (T_FLDLN2,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xED,                     P_87,        0)
ins (T_FLDPI,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEB,                     P_87,        0)
ins (T_FLDZ,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEE,                     P_87,        0)
//insa(T_FLOAT,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_FMUL,            OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xC8,                     P_87,        0)
ins (T_FMUL,            OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xC8,                     P_87,        0)
ins (T_FMUL,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x08,                     P_87,        0)
ins (T_FMUL,            OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x08,                     P_87,        0)
ins (T_FMUL,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xC9,                     P_87,        0)
ins (T_FMULP,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xC8,                     P_87,        0)
ins (T_FNCLEX,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE2,                     P_87,        NO_FWAIT)
ins (T_FNDISI,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE1,                     P_87,        NO_FWAIT)
ins (T_FNENI,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE0,                     P_87,        NO_FWAIT)
ins (T_FNINIT,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE3,                     P_87,        NO_FWAIT)
ins (T_FNOP,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xD0,                     P_87,        0)
ins (T_FNRSTOR,         OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,                     P_87,        NO_FWAIT)
ins (T_FNRSTORD,        OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,                     P_387,       NO_FWAIT)
ins (T_FNRSTORW,        OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,                     P_387,       NO_FWAIT)
ins (T_FNSAVE,          OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,                     P_87,        NO_FWAIT)
ins (T_FNSAVED,         OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,                     P_387,       NO_FWAIT)
ins (T_FNSAVEW,         OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,                     P_387,       NO_FWAIT)
ins (T_FNSTCW,          OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x38,                     P_87,        NO_FWAIT)
ins (T_FNSTENV,         OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,                     P_87,        NO_FWAIT)
ins (T_FNSTENVD,        OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,                     P_387,       NO_FWAIT)
ins (T_FNSTENVW,        OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,                     P_387,       NO_FWAIT)
ins (T_FNSTSW,          OP_AX,       0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDF,     0xE0,                     P_287,       NO_FWAIT)
ins (T_FNSTSW,          OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x38,                     P_87,        NO_FWAIT)
insa(T_FOR,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_FORC,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_FPATAN,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF3,                     P_87,        0)
ins (T_FPREM,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF8,                     P_87,        0)
ins (T_FPREM1,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF5,                     P_387,       0)
ins (T_FPTAN,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF2,                     P_87,        0)
ins (T_FRNDINT,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFC,                     P_87,        0)
ins (T_FRSTOR,          OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,                     P_87,        0)
ins (T_FRSTORD,         OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,                     P_387,       0)
ins (T_FRSTORW,         OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,                     P_387,       0)
ins (T_FS,              OP_SPECIAL,  0,      OP_SR3,        0,       0,  0,      PREFIX_FS,OP_REGISTER,              P_386,       0)
ins (T_FSAVE,           OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,                     P_87,        FWAIT)
ins (T_FSAVED,          OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,                     P_387,       FWAIT)
ins (T_FSAVEW,          OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,                     P_387,       FWAIT)
ins (T_FSCALE,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFD,                     P_87,        0)
ins (T_FSETPM,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE4,                     P_287,       0)
ins (T_FSIN,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFE,                     P_387,       0)
ins (T_FSINCOS,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFB,                     P_387,       0)
ins (T_FSQRT,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFA,                     P_87,        0)
ins (T_FST,             OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xD0,                     P_87,        0)
ins (T_FST,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x10,                     P_87,        0)
ins (T_FST,             OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x10,                     P_87,        0)
ins (T_FSTCW,           OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x38,                     P_87,        FWAIT)
ins (T_FSTENV,          OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,                     P_87,        FWAIT)
ins (T_FSTENVD,         OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,                     P_387,       FWAIT)
ins (T_FSTENVW,         OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,                     P_387,       FWAIT)
ins (T_FSTP,            OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xD8,                     P_87,        0)
ins (T_FSTP,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x18,                     P_87,        0)
ins (T_FSTP,            OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x18,                     P_87,        0)
ins (T_FSTP,            OP_M_TB,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x38,                     P_87,        0)
ins (T_FSTSW,           OP_AX,       0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDF,     0xE0,                     P_287,       FWAIT)
ins (T_FSTSW,           OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x38,                     P_87,        FWAIT)
ins (T_FSUB,            OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xE8,                     P_87,        0)
ins (T_FSUB,            OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xE0,                     P_87,        0)
ins (T_FSUB,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x20,                     P_87,        0)
ins (T_FSUB,            OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x20,                     P_87,        0)
ins (T_FSUB,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xE9,                     P_87,        0)
ins (T_FSUBP,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xE8,                     P_87,        0)
ins (T_FSUBR,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xE0,                     P_87,        0)
ins (T_FSUBR,           OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xE8,                     P_87,        0)
ins (T_FSUBR,           OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x28,                     P_87,        0)
ins (T_FSUBR,           OP_M_QW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x28,                     P_87,        0)
ins (T_FSUBR,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xE1,                     P_87,        0)
ins (T_FSUBRP,          OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xE0,                     P_87,        0)
ins (T_FTST,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE4,                     P_87,        0)
ins (T_FUCOM,           OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE0,                     P_387,       0)
ins (T_FUCOM,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE1,                     P_387,       0)
ins (T_FUCOMI,          OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xE8,                     P_686,       0)
ins (T_FUCOMIP,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDF,     0xE8,                     P_686,       0)
ins (T_FUCOMP,          OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE8,                     P_387,       0)
ins (T_FUCOMP,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE9,                     P_387,       0)
ins (T_FUCOMPP,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0xE9,                     P_387,       0)
ins (T_FWAIT,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9B,     0x00,                     P_87,        0)
ins (T_FWORD,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_FXAM,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE5,                     P_87,        0)
ins (T_FXCH,            OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xC8,                     P_87,        0)
ins (T_FXCH,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xC9,                     P_87,        0)
ins (T_FXRSTOR,         OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x08,                     P_686|P_SSE, 0)
ins (T_FXSAVE,          OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x00,                     P_686|P_SSE, 0)
ins (T_FXTRACT,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF4,                     P_87,        0)
ins (T_FYL2X,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF1,                     P_87,        0)
ins (T_FYL2XP1,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF9,                     P_87,        0)
insa(T_GE,              OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_ARITHOP,               P_86,        0)
insa(T_GLOBAL,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_GROUP,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_GS,              OP_SPECIAL,  0,      OP_SR3,        0,       0,  0,      PREFIX_GS,OP_REGISTER,              P_386,       0)
insa(T_GT,              OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_ARITHOP,               P_86,        0)
ins (T_HADDPD,          OP_XMM,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7C,     0x00,                     P_686|P_SSE3,0)
ins (T_HADDPS,          OP_XMM,      F_F20F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7C,     0x00,                     P_686|P_SSE3,0)
insa(T_HIGH,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_HIGHWORD,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_HLT,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF4,     0x00,                     P_86,        0)
ins (T_HSUBPD,          OP_XMM,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7D,     0x00,                     P_686|P_SSE3,0)
ins (T_HSUBPS,          OP_XMM,      F_F20F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7D,     0x00,                     P_686|P_SSE3,0)
insa(T_IDEAL,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_IDIV,            OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x38,                     P_86,        0)
ins (T_IDIV,            OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x38,                     P_86,        0)
ins (T_IDIV,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x38,                     P_386,       0)
ins (T_IDIV,            OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x38,                     P_86,        0)
insa(T_IF,              OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IF1,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IF2,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFB,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFDEF,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFDIF,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFDIFI,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFE,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFIDN,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFIDNI,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFNB,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_IFNDEF,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_IMUL,            OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x28,                     P_86,        0)
ins (T_IMUL,            OP_R,        F_0F,   OP_R,          OP3_NONE,1,  no_WDS, 0xAF,     0x00,                     P_386,       0)
ins (T_IMUL,            OP_R,        F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xAF,     0x00,                     P_386,       0)
ins (T_IMUL,            OP_R,        0,      OP_I8,         OP3_NONE,1,  no_WDS, 0x6B,     0x00,                     P_186,       0)
ins (T_IMUL,            OP_R,        0,      OP_I,          OP3_NONE,1,  no_WDS, 0x69,     0x00,                     P_186,       0)
ins (T_IMUL,            OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x28,                     P_86,        0)
ins (T_IMUL,            OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x28,                     P_386,       0)
ins (T_IMUL,            OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x28,                     P_86,        0)
ins (T_IMUL,            OP_M,        0,      OP_I8,         OP3_NONE,1,  no_WDS, 0x6B,     0x00,                     P_186,       0)
ins (T_IMUL,            OP_M,        0,      OP_I,          OP3_NONE,1,  no_WDS, 0x69,     0x00,                     P_186,       0)
ins (T_IN,              OP_A,        0,      OP_DX,         OP3_NONE,0,  no_RM,  0xEC,     0x00,                     P_86,        0)
ins (T_IN,              OP_A,        0,      OP_I8_U,       OP3_NONE,0,  no_RM,  0xE4,     0x00,                     P_86,        0)
ins (T_INC,             OP_R1632,    0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x40,     0x00,                     P_86,        0)
ins (T_INC,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x00,                     P_86,        0)
ins (T_INC,             OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x00,                     P_86,        LOCK)
ins (T_INC,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x00,                     P_386,       LOCK)
ins (T_INC,             OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x00,                     P_86,        LOCK)
insa(T_INCLUDE,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_INCLUDELIB,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_INS,             OP_M,        0,      OP_DX,         OP3_NONE,0,  no_RM,  0x6C,     0x00,                     P_186,       REP)
ins (T_INSB,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x6C,     0x00,                     P_186,       REP)
ins (T_INSD,            OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6D,     0x00,                     P_386,       REP)
ins (T_INSW,            OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6D,     0x00,                     P_186,       REP)
ins (T_INT,             OP_I_3,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCC,     0x00,                     P_86,        0)
ins (T_INT,             OP_I8_U,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCD,     0x00,                     P_86,        0)
ins (T_INTO,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCE,     0x00,                     P_86,        0)
ins (T_INVD,            OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x08,     0x00,                     P_486,       0)
ins (T_INVLPG,          OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x38,                     P_486,       0)
insa(T_INVOKE,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_IRET,            OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,                     P_86,        0)
ins (T_IRETD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,                     P_386,       0)
ins (T_IRETDF,          OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,                     P_386,       0)
ins (T_IRETF,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,                     P_86,        0)
insa(T_IRP,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_IRPC,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_JA,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x77,     0x00,                     P_86,        0)
ins (T_JA,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x87,     0x00,                     P_386,       0)
ins (T_JAE,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x73,     0x00,                     P_86,        0)
ins (T_JAE,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x83,     0x00,                     P_386,       0)
ins (T_JB,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x72,     0x00,                     P_86,        0)
ins (T_JB,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x82,     0x00,                     P_386,       0)
ins (T_JBE,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x76,     0x00,                     P_86,        0)
ins (T_JBE,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x86,     0x00,                     P_386,       0)
ins (T_JC,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x72,     0x00,                     P_86,        0)
ins (T_JC,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x82,     0x00,                     P_386,       0)
ins (T_JCXZ,            OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE3,     0x00,                     P_86,        0)
ins (T_JE,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x74,     0x00,                     P_86,        0)
ins (T_JE,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x84,     0x00,                     P_386,       0)
ins (T_JECXZ,           OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE3,     0x00,                     P_386,       0)
ins (T_JG,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7F,     0x00,                     P_86,        0)
ins (T_JG,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8F,     0x00,                     P_386,       0)
ins (T_JGE,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7D,     0x00,                     P_86,        0)
ins (T_JGE,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8D,     0x00,                     P_386,       0)
ins (T_JL,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7C,     0x00,                     P_86,        0)
ins (T_JL,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8C,     0x00,                     P_386,       0)
ins (T_JLE,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7E,     0x00,                     P_86,        0)
ins (T_JLE,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8E,     0x00,                     P_386,       0)
ins (T_JMP,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xEB,     0x00,                     P_86,        0)
ins (T_JMP,             OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE9,     0x00,                     P_86,        0)
ins (T_JMP,             OP_I32,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE9,     0x00,                     P_386,       0)
ins (T_JMP,             OP_J32,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xEA,     0x00,                     P_86,        0)
ins (T_JMP,             OP_J48,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xEA,     0x00,                     P_386,       0)
ins (T_JMP,             OP_R1632,    0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x20,                     P_86,        0)
ins (T_JMP,             OP_M_FW,     F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x28,                     P_386,       0)
ins (T_JMP,             OP_M_W,      F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x20,                     P_86,        0)
ins (T_JMP,             OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x20,                     P_86,        0)
ins (T_JMPF,            OP_I,        0,      OP_I,          OP3_NONE,0,  no_RM,  0xEA,     0x00,                     P_86,        0)
ins (T_JMPF,            OP_J32,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xEA,     0x00,                     P_86,        0)
ins (T_JMPF,            OP_J48,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xEA,     0x00,                     P_386,       0)
ins (T_JMPF,            OP_M_DW,     F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x28,                     P_86,        0)
ins (T_JMPF,            OP_M_FW,     F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x28,                     P_386,       0)
ins (T_JNA,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x76,     0x00,                     P_86,        0)
ins (T_JNA,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x86,     0x00,                     P_386,       0)
ins (T_JNAE,            OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x72,     0x00,                     P_86,        0)
ins (T_JNAE,            OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x82,     0x00,                     P_386,       0)
ins (T_JNB,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x73,     0x00,                     P_86,        0)
ins (T_JNB,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x83,     0x00,                     P_386,       0)
ins (T_JNBE,            OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x77,     0x00,                     P_86,        0)
ins (T_JNBE,            OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x87,     0x00,                     P_386,       0)
ins (T_JNC,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x73,     0x00,                     P_86,        0)
ins (T_JNC,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x83,     0x00,                     P_386,       0)
ins (T_JNE,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x75,     0x00,                     P_86,        0)
ins (T_JNE,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x85,     0x00,                     P_386,       0)
ins (T_JNG,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7E,     0x00,                     P_86,        0)
ins (T_JNG,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8E,     0x00,                     P_386,       0)
ins (T_JNGE,            OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7C,     0x00,                     P_86,        0)
ins (T_JNGE,            OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8C,     0x00,                     P_386,       0)
ins (T_JNL,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7D,     0x00,                     P_86,        0)
ins (T_JNL,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8D,     0x00,                     P_386,       0)
ins (T_JNLE,            OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7F,     0x00,                     P_86,        0)
ins (T_JNLE,            OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8F,     0x00,                     P_386,       0)
ins (T_JNO,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x71,     0x00,                     P_86,        0)
ins (T_JNO,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x81,     0x00,                     P_386,       0)
ins (T_JNP,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7B,     0x00,                     P_86,        0)
ins (T_JNP,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8B,     0x00,                     P_386,       0)
ins (T_JNS,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x79,     0x00,                     P_86,        0)
ins (T_JNS,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x89,     0x00,                     P_386,       0)
ins (T_JNZ,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x75,     0x00,                     P_86,        0)
ins (T_JNZ,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x85,     0x00,                     P_386,       0)
ins (T_JO,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x70,     0x00,                     P_86,        0)
ins (T_JO,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x80,     0x00,                     P_386,       0)
ins (T_JP,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7A,     0x00,                     P_86,        0)
ins (T_JP,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8A,     0x00,                     P_386,       0)
ins (T_JPE,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7A,     0x00,                     P_86,        0)
ins (T_JPE,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8A,     0x00,                     P_386,       0)
ins (T_JPO,             OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x7B,     0x00,                     P_86,        0)
ins (T_JPO,             OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x8B,     0x00,                     P_386,       0)
ins (T_JS,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x78,     0x00,                     P_86,        0)
ins (T_JS,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x88,     0x00,                     P_386,       0)
ins (T_JZ,              OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x74,     0x00,                     P_86,        0)
ins (T_JZ,              OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x84,     0x00,                     P_386,       0)
insa(T_LABEL,           OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_LAHF,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9F,     0x00,                     P_86,        0)
ins (T_LAR,             OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,1,  no_WDS, 0x02,     0x00,                     P_286,       0)
ins (T_LAR,             OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x02,     0x00,                     P_286,       0)
ins (T_LDDQU,           OP_XMM,      F_F20F, OP_M,          OP3_NONE,1,  no_WDS, 0xF0,     0x00,                     P_686|P_SSE3,0)
ins (T_LDMXCSR,         OP_M32,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x10,                     P_686|P_SSE, 0)
ins (T_LDS,             OP_R1632,    0,      OP_M,          OP3_NONE,1,  no_WDS, 0xC5,     0x00,                     P_86,        0)
insa(T_LE,              OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_ARITHOP,               P_86,        0)
ins (T_LEA,             OP_R1632,    0,      OP_M,          OP3_NONE,1,  no_WDS, 0x8D,     0x00,                     P_86,        0)
ins (T_LEAVE,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC9,     0x00,                     P_186,       0)
insa(T_LENGTH,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_UNARY_OPERATOR,        0,           0)
insa(T_LENGTHOF,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_UNARY_OPERATOR,        0,           0)
ins (T_LES,             OP_R1632,    0,      OP_M,          OP3_NONE,1,  no_WDS, 0xC4,     0x00,                     P_86,        0)
ins (T_LFENCE,          OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0xE8,                     P_686|P_SSE2,0)
ins (T_LFS,             OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xB4,     0x00,                     P_386,       0)
ins (T_LGDT,            OP_M_FW,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x10,                     P_286p,      0)
ins (T_LGS,             OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xB5,     0x00,                     P_386,       0)
ins (T_LIDT,            OP_M_FW,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x18,                     P_286p,      0)
ins (T_LLDT,            OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x10,                     P_286p,      0)
ins (T_LLDT,            OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x10,                     P_286p,      0)
ins (T_LMSW,            OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x30,                     P_286p,      0)
ins (T_LMSW,            OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x30,                     P_286p,      0)
insa(T_LOCAL,           OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_LOCALS,          OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_LOCK,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF0,     0x00,                     P_86,        0)
ins (T_LODS,            OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAC,     0x00,                     P_86,        REP)
ins (T_LODSB,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAC,     0x00,                     P_86,        REP)
ins (T_LODSD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,                     P_386,       REP)
ins (T_LODSW,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,                     P_86,        REP)
ins (T_LOOP,            OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE2,     0x00,                     P_86,        0)
ins (T_LOOPD,           OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE2,     0x00,                     P_86,        0)
ins (T_LOOPE,           OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,                     P_86,        0)
ins (T_LOOPED,          OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,                     P_86,        0)
ins (T_LOOPEW,          OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,                     P_86,        0)
ins (T_LOOPNE,          OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,                     P_86,        0)
ins (T_LOOPNED,         OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,                     P_86,        0)
ins (T_LOOPNEW,         OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,                     P_86,        0)
ins (T_LOOPNZ,          OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,                     P_86,        0)
ins (T_LOOPNZD,         OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,                     P_86,        0)
ins (T_LOOPNZW,         OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,                     P_86,        0)
ins (T_LOOPW,           OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE2,     0x00,                     P_86,        0)
ins (T_LOOPZ,           OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,                     P_86,        0)
ins (T_LOOPZD,          OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,                     P_86,        0)
ins (T_LOOPZW,          OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,                     P_86,        0)
insa(T_LOW,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_LOWWORD,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_LROFFSET,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_LSL,             OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,1,  no_WDS, 0x03,     0x00,                     P_286,       0)
ins (T_LSL,             OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x03,     0x00,                     P_286,       0)
ins (T_LSS,             OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xB2,     0x00,                     P_386,       0)
insa(T_LT,              OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_ARITHOP,               P_86,        0)
ins (T_LTR,             OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x18,                     P_286p,      0)
ins (T_LTR,             OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x18,                     P_286p,      0)
insa(T_MACRO,           OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_MASK,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_MASKMOVDQU,      OP_XMM,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xF7,     0x00,                     P_686|P_SSE2,0)
ins (T_MASKMOVQ,        OP_MMX,      F_0F,   OP_MMX,        OP3_NONE,1,  no_WDS, 0xF7,     0x00,                     P_686|P_SSE, 0)
insa(T_MASM,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_MAXPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5F,     0x00,                     P_686|P_SSE2,0)
ins (T_MAXPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5F,     0x00,                     P_686|P_SSE, 0)
ins (T_MAXSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5F,     0x00,                     P_686|P_SSE2,0)
ins (T_MAXSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5F,     0x00,                     P_686|P_SSE, 0)
ins (T_MFENCE,          OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0xF0,                     P_686|P_SSE2,0)
ins (T_MINPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5D,     0x00,                     P_686|P_SSE2,0)
ins (T_MINPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5D,     0x00,                     P_686|P_SSE, 0)
ins (T_MINSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5D,     0x00,                     P_686|P_SSE2,0)
ins (T_MINSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5D,     0x00,                     P_686|P_SSE, 0)
ins (T_MM0,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      0,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MM1,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      1,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MM2,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      2,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MM3,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      3,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MM4,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      4,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MM5,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      5,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MM6,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      6,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MM7,             OP_SPECIAL,  0,      OP_MMX,        0,       0,  0,      7,        OP_REGISTER,              P_586|P_MMX, 0)
ins (T_MOD,             OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_ARITHOP,               P_86,        0)
insa(T_MODEL,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
ins (T_MONITOR,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  0,      0x01,     0xC8,                     P_686|P_SSE3,0)
ins (T_MOV,             OP_CR,       F_0F,   OP_R32,        OP3_NONE,1,  no_WDS, 0x22,     0xC0,                     P_386,       0)
ins (T_MOV,             OP_DR,       F_0F,   OP_R32,        OP3_NONE,1,  no_WDS, 0x23,     0xC0,                     P_386,       0)
ins (T_MOV,             OP_TR,       F_0F,   OP_R32,        OP3_NONE,1,  no_WDS, 0x26,     0xC0,                     P_386,       0)
ins (T_MOV,             OP_R32,      F_0F,   OP_CR,         OP3_NONE,0,  no_WDS, 0x20,     0xC0,                     P_386,       0)
ins (T_MOV,             OP_R32,      F_0F,   OP_DR,         OP3_NONE,0,  no_WDS, 0x21,     0xC0,                     P_386,       0)
ins (T_MOV,             OP_R32,      F_0F,   OP_TR,         OP3_NONE,0,  no_WDS, 0x24,     0xC0,                     P_386,       0)
ins (T_MOV,             OP_SR,       0,      OP_R1632,      OP3_NONE,1,  no_WDS, 0x8E,     0xC0,                     P_86,        0)
ins (T_MOV,             OP_R1632,    0,      OP_SR,         OP3_NONE,0,  no_WDS, 0x8C,     0xC0,                     P_86,        0)
ins (T_MOV,             OP_SR,       0,      OP_M,          OP3_NONE,1,  no_WDS, 0x8E,     0x00,                     P_86,        0)
ins (T_MOV,             OP_A,        0,      OP_M,          OP3_NONE,1,  no_RM,  0xA0,     0x00,                     P_86,        0)
ins (T_MOV,             OP_R1632,    0,      OP_I,          OP3_NONE,0,  R_in_OP,0xB8,     0x00,                     P_86,        0)
ins (T_MOV,             OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x8A,     0x00,                     P_86,        0)
ins (T_MOV,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x8A,     0x00,                     P_86,        0)
ins (T_MOV,             OP_R,        0,      OP_I,          OP3_NONE,0,  R_in_OP,0xB0,     0x00,                     P_86,        0)
ins (T_MOV,             OP_M,        0,      OP_SR,         OP3_NONE,0,  no_WDS, 0x8C,     0x00,                     P_86,        0)
ins (T_MOV,             OP_M,        0,      OP_A,          OP3_NONE,0,  no_RM,  0xA2,     0x00,                     P_86,        0)
ins (T_MOV,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x88,     0x00,                     P_86,        0)
ins (T_MOV,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0xC6,     0x00,                     P_86,        0)
ins (T_MOVAPD,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x28,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVAPD,          OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x29,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVAPS,          OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x28,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVAPS,          OP_M,        F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x29,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVD,            OP_MMX,      F_0F,   OP_R32,        OP3_NONE,1,  no_WDS, 0x6E,     0x00,                     P_586|P_MMX, 0)
ins (T_MOVD,            OP_MMX,      F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x6E,     0x00,                     P_586|P_MMX, 0)
ins (T_MOVD,            OP_XMM,      F_660F, OP_R32,        OP3_NONE,1,  no_WDS, 0x6E,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVD,            OP_XMM,      F_660F, OP_M,          OP3_NONE,1,  no_WDS, 0x6E,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVD,            OP_R32,      F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,                     P_586|P_MMX, 0)
ins (T_MOVD,            OP_R32,      F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVD,            OP_M,        F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,                     P_586|P_MMX, 0)
ins (T_MOVD,            OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVDDUP,         OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x12,     0x00,                     P_686|P_SSE3,0)
ins (T_MOVDQ2Q,         OP_MMX,      F_F20F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xD6,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVDQA,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x6F,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVDQA,          OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7F,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVDQU,          OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x6F,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVDQU,          OP_M,        F_F30F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7F,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVHLPS,         OP_XMM,      F_0F,   OP_XMM,        OP3_NONE,1,  no_WDS, 0x12,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVHPD,          OP_XMM,      F_660F, OP_M,          OP3_NONE,1,  no_WDS, 0x16,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVHPD,          OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x17,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVHPS,          OP_XMM,      F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x16,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVHPS,          OP_M,        F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x17,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVLHPS,         OP_XMM,      F_0F,   OP_XMM,        OP3_NONE,1,  no_WDS, 0x16,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVLPD,          OP_XMM,      F_660F, OP_M,          OP3_NONE,1,  no_WDS, 0x12,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVLPD,          OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x13,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVLPS,          OP_XMM,      F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x12,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVLPS,          OP_M,        F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x13,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVMSKPD,        OP_R32,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x50,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVMSKPS,        OP_R32,      F_0F,   OP_XMM,        OP3_NONE,1,  no_WDS, 0x50,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVNTDQ,         OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0xE7,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVNTI,          OP_M,        F_0F,   OP_R32,        OP3_NONE,0,  no_WDS, 0xC3,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVNTPD,         OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x2B,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVNTPS,         OP_M,        F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x2B,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVNTQ,          OP_M,        F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0xE7,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVQ,            OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x6F,     0x00,                     P_586|P_MMX, 0)
ins (T_MOVQ,            OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x7E,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVQ,            OP_M,        F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0x7F,     0x00,                     P_586|P_MMX, 0)
ins (T_MOVQ,            OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0xD6,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVQ2DQ,         OP_XMM,      F_F30F, OP_MMX,        OP3_NONE,1,  no_WDS, 0xD6,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVS,            OP_M,        0,      OP_M,          OP3_NONE,0,  no_RM,  0xA4,     0x00,                     P_86,        REP)
ins (T_MOVSB,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xA4,     0x00,                     P_86,        REP)
ins (T_MOVSD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA5,     0x00,                     P_386,       REP)
ins (T_MOVSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x10,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVSD,           OP_M,        F_F20F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVSHDUP,        OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x16,     0x00,                     P_686|P_SSE3,0)
ins (T_MOVSLDUP,        OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x12,     0x00,                     P_686|P_SSE3,0)
ins (T_MOVSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x10,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVSS,           OP_M,        F_F30F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVSW,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA5,     0x00,                     P_86,        REP)
ins (T_MOVSX,           OP_R1632,    F_0F,   OP_R,          OP3_NONE,1,  0,      0xBE,     0x00,                     P_386,       0)
ins (T_MOVSX,           OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  0,      0xBE,     0x00,                     P_386,       0)
ins (T_MOVUPD,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x10,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVUPD,          OP_M,        F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,                     P_686|P_SSE2,0)
ins (T_MOVUPS,          OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x10,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVUPS,          OP_M,        F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,                     P_686|P_SSE, 0)
ins (T_MOVZX,           OP_R1632,    F_0F,   OP_R,          OP3_NONE,1,  0,      0xB6,     0x00,                     P_386,       0)
ins (T_MOVZX,           OP_R1632,    F_0F,   OP_M,          OP3_NONE,1,  0,      0xB6,     0x00,                     P_386,       0)
ins (T_MUL,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x20,                     P_86,        0)
ins (T_MUL,             OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x20,                     P_86,        0)
ins (T_MUL,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x20,                     P_386,       0)
ins (T_MUL,             OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x20,                     P_86,        0)
ins (T_MUL,             OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x20,                     P_86,        0)
ins (T_MULPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x59,     0x00,                     P_686|P_SSE2,0)
ins (T_MULPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x59,     0x00,                     P_686|P_SSE, 0)
ins (T_MULSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x59,     0x00,                     P_686|P_SSE2,0)
ins (T_MULSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x59,     0x00,                     P_686|P_SSE, 0)
ins (T_MWAIT,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  0,      0x01,     0xC9,                     P_686|P_SSE3,0)
insa(T_NAME,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
insa(T_NE,              OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_ARITHOP,               P_86,        0)
ins (T_NEAR,            OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_NEG,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x18,                     P_86,        0)
ins (T_NEG,             OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x18,                     P_86,        LOCK)
ins (T_NEG,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x18,                     P_386,       LOCK)
ins (T_NEG,             OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x18,                     P_86,        LOCK)
insa(T_NOLOCALS,        OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_NOP,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x90,     0x00,                     P_86,        0)
ins (T_NOT,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x10,                     P_86,        0)
ins (T_NOT,             OP_M_B,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x10,                     P_86,        LOCK)
ins (T_NOT,             OP_M_DW,     0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x10,                     P_386,       LOCK)
ins (T_NOT,             OP_M_W,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x10,                     P_86,        LOCK)
insa(T_NOWARN,          OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
ins (T_OFFSET,          OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_UNARY_OPERATOR,        0,           0)
insa(T_OPATTR,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_OPTION,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_OR,              OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x08,                     P_86,        0)
ins (T_OR,              OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x0A,     0x00,                     P_86,        0)
ins (T_OR,              OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x0A,     0x00,                     P_86,        0)
ins (T_OR,              OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x0C,     0x00,                     P_86,        0)
ins (T_OR,              OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x08,                     P_86,        0)
ins (T_OR,              OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x08,                     P_386,       LOCK)
ins (T_OR,              OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x08,                     P_86,        LOCK)
ins (T_OR,              OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x08,     0x00,                     P_86,        LOCK)
ins (T_OR,              OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x08,                     P_86,        LOCK)
insa(T_ORG,             OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_ORPD,            OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x56,     0x00,                     P_686|P_SSE2,0)
ins (T_ORPS,            OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x56,     0x00,                     P_686|P_SSE, 0)
ins (T_OUT,             OP_DX,       0,      OP_A,          OP3_NONE,0,  no_RM,  0xEE,     0x00,                     P_86,        0)
ins (T_OUT,             OP_I8_U,     0,      OP_A,          OP3_NONE,0,  no_RM,  0xE6,     0x00,                     P_86,        0)
ins (T_OUTS,            OP_DX,       0,      OP_M,          OP3_NONE,0,  no_RM,  0x6E,     0x00,                     P_186,       REP)
ins (T_OUTSB,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x6E,     0x00,                     P_186,       REP)
ins (T_OUTSD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6F,     0x00,                     P_386,       REP)
ins (T_OUTSW,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6F,     0x00,                     P_186,       REP)
ins (T_OWORD,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
insa(T_P186,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P286,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P286N,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P286P,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P287,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P386,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P386P,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P387,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P486,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P486P,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P586,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P586P,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P686,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P686P,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P8086,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
insa(T_P8087,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_86,        0)
ins (T_PACKSSDW,        OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x6B,     0x00,                     P_586|P_MMX, 0)
ins (T_PACKSSDW,        OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x6B,     0x00,                     P_686|P_SSE2,0)
ins (T_PACKSSWB,        OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x63,     0x00,                     P_586|P_MMX, 0)
ins (T_PACKSSWB,        OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x63,     0x00,                     P_686|P_SSE2,0)
ins (T_PACKUSWB,        OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x67,     0x00,                     P_586|P_MMX, 0)
ins (T_PACKUSWB,        OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x67,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDB,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xFC,     0x00,                     P_586|P_MMX, 0)
ins (T_PADDB,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xFC,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDD,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xFE,     0x00,                     P_586|P_MMX, 0)
ins (T_PADDD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xFE,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDQ,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xD4,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDQ,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xD4,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDSB,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xEC,     0x00,                     P_586|P_MMX, 0)
ins (T_PADDSB,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xEC,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDSW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xED,     0x00,                     P_586|P_MMX, 0)
ins (T_PADDSW,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xED,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDUSB,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xDC,     0x00,                     P_586|P_MMX, 0)
ins (T_PADDUSB,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xDC,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDUSW,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xDD,     0x00,                     P_586|P_MMX, 0)
ins (T_PADDUSW,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xDD,     0x00,                     P_686|P_SSE2,0)
ins (T_PADDW,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xFD,     0x00,                     P_586|P_MMX, 0)
ins (T_PADDW,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xFD,     0x00,                     P_686|P_SSE2,0)
insa(T_PAGE,            OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_PAND,            OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xDB,     0x00,                     P_586|P_MMX, 0)
ins (T_PAND,            OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xDB,     0x00,                     P_686|P_SSE2,0)
ins (T_PANDN,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xDF,     0x00,                     P_586|P_MMX, 0)
ins (T_PANDN,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xDF,     0x00,                     P_686|P_SSE2,0)
ins (T_PAUSE,           OP_NONE,     F_F3,   OP_NONE,       OP3_NONE,0,  no_RM,  0x90,     0x00,                     P_686|P_SSE2,0)
ins (T_PAVGB,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE0,     0x00,                     P_686|P_SSE, 0)
ins (T_PAVGB,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE0,     0x00,                     P_686|P_SSE2,0)
ins (T_PAVGUSB,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xBF,     0x00,                     P_586|P_K3D, 0)
ins (T_PAVGW,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE3,     0x00,                     P_686|P_SSE, 0)
ins (T_PAVGW,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE3,     0x00,                     P_686|P_SSE2,0)
ins (T_PCMPEQB,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x74,     0x00,                     P_586|P_MMX, 0)
ins (T_PCMPEQB,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x74,     0x00,                     P_686|P_SSE2,0)
ins (T_PCMPEQD,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x76,     0x00,                     P_586|P_MMX, 0)
ins (T_PCMPEQD,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x76,     0x00,                     P_686|P_SSE2,0)
ins (T_PCMPEQW,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x75,     0x00,                     P_586|P_MMX, 0)
ins (T_PCMPEQW,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x75,     0x00,                     P_686|P_SSE2,0)
ins (T_PCMPGTB,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x64,     0x00,                     P_586|P_MMX, 0)
ins (T_PCMPGTB,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x64,     0x00,                     P_686|P_SSE2,0)
ins (T_PCMPGTD,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x66,     0x00,                     P_586|P_MMX, 0)
ins (T_PCMPGTD,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x66,     0x00,                     P_686|P_SSE2,0)
ins (T_PCMPGTW,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x65,     0x00,                     P_586|P_MMX, 0)
ins (T_PCMPGTW,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x65,     0x00,                     P_686|P_SSE2,0)
ins (T_PEXTRW,          OP_R32,      F_0F,   OP_MMX,        OP3_I8_U,1,  no_WDS, 0xC5,     0x00,                     P_686|P_SSE, 0)
ins (T_PEXTRW,          OP_R32,      F_660F, OP_XMM,        OP3_I8_U,1,  no_WDS, 0xC5,     0x00,                     P_686|P_SSE, 0)
ins (T_PF2ID,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x1D,     0x00,                     P_586|P_K3D, 0)
ins (T_PF2IW,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x1C,     0x00,                     P_586|P_K3D, 0)
ins (T_PFACC,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xAE,     0x00,                     P_586|P_K3D, 0)
ins (T_PFADD,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x9E,     0x00,                     P_586|P_K3D, 0)
ins (T_PFCMPEQ,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB0,     0x00,                     P_586|P_K3D, 0)
ins (T_PFCMPGE,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x90,     0x00,                     P_586|P_K3D, 0)
ins (T_PFCMPGT,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA0,     0x00,                     P_586|P_K3D, 0)
ins (T_PFMAX,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA4,     0x00,                     P_586|P_K3D, 0)
ins (T_PFMIN,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x94,     0x00,                     P_586|P_K3D, 0)
ins (T_PFMUL,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB4,     0x00,                     P_586|P_K3D, 0)
ins (T_PFNACC,          OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x8A,     0x00,                     P_586|P_K3D, 0)
ins (T_PFPNACC,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x8E,     0x00,                     P_586|P_K3D, 0)
ins (T_PFRCP,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x96,     0x00,                     P_586|P_K3D, 0)
ins (T_PFRCPIT1,        OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA6,     0x00,                     P_586|P_K3D, 0)
ins (T_PFRCPIT2,        OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB6,     0x00,                     P_586|P_K3D, 0)
ins (T_PFRSQIT1,        OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA7,     0x00,                     P_586|P_K3D, 0)
ins (T_PFRSQRT,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x97,     0x00,                     P_586|P_K3D, 0)
ins (T_PFSUB,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x9A,     0x00,                     P_586|P_K3D, 0)
ins (T_PFSUBR,          OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xAA,     0x00,                     P_586|P_K3D, 0)
ins (T_PI2FD,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x0D,     0x00,                     P_586|P_K3D, 0)
ins (T_PI2FW,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x0C,     0x00,                     P_586|P_K3D, 0)
ins (T_PINSRW,          OP_MMX,      F_0F,   OP_R32,        OP3_I8_U,1,  no_WDS, 0xC4,     0x00,                     P_686|P_SSE, 0)
ins (T_PINSRW,          OP_MMX,      F_0F,   OP_M,          OP3_I8_U,1,  no_WDS, 0xC4,     0x00,                     P_686|P_SSE, 0)
ins (T_PINSRW,          OP_XMM,      F_660F, OP_R32,        OP3_I8_U,1,  no_WDS, 0xC4,     0x00,                     P_686|P_SSE, 0)
ins (T_PINSRW,          OP_XMM,      F_660F, OP_M,          OP3_I8_U,1,  no_WDS, 0xC4,     0x00,                     P_686|P_SSE, 0)
insa(T_PK3D,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_586,       0)
ins (T_PMADDWD,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF5,     0x00,                     P_586|P_MMX, 0)
ins (T_PMADDWD,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF5,     0x00,                     P_686|P_SSE2,0)
ins (T_PMAXSW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xEE,     0x00,                     P_686|P_SSE, 0)
ins (T_PMAXSW,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xEE,     0x00,                     P_686|P_SSE2,0)
ins (T_PMAXUB,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xDE,     0x00,                     P_686|P_SSE, 0)
ins (T_PMAXUB,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xDE,     0x00,                     P_686|P_SSE2,0)
ins (T_PMINSW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xEA,     0x00,                     P_686|P_SSE, 0)
ins (T_PMINSW,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xEA,     0x00,                     P_686|P_SSE2,0)
ins (T_PMINUB,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xDA,     0x00,                     P_686|P_SSE, 0)
ins (T_PMINUB,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xDA,     0x00,                     P_686|P_SSE2,0)
insa(T_PMMX,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_586,       0)
ins (T_PMOVMSKB,        OP_R32,      F_0F,   OP_MMX,        OP3_NONE,1,  no_WDS, 0xD7,     0x00,                     P_686|P_SSE, 0)
ins (T_PMOVMSKB,        OP_R32,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xD7,     0x00,                     P_686|P_SSE2,0)
ins (T_PMULHRW,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB7,     0x00,                     P_586|P_K3D, 0)
ins (T_PMULHUW,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE4,     0x00,                     P_586|P_SSE, 0)
ins (T_PMULHUW,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE4,     0x00,                     P_686|P_SSE2,0)
ins (T_PMULHW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE5,     0x00,                     P_586|P_MMX, 0)
ins (T_PMULHW,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE5,     0x00,                     P_686|P_SSE2,0)
ins (T_PMULLW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xD5,     0x00,                     P_586|P_MMX, 0)
ins (T_PMULLW,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xD5,     0x00,                     P_686|P_SSE2,0)
ins (T_PMULUDQ,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF4,     0x00,                     P_686|P_SSE2,0)
ins (T_PMULUDQ,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF4,     0x00,                     P_686|P_SSE2,0)
ins (T_POP,             OP_R1632,    0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x58,     0x00,                     P_86,        0)
ins (T_POP,             OP_SR2,      0,      OP_NONE,       OP3_NONE,1,  R_in_OP,0x07,     0x00,                     P_86,        0)
ins (T_POP,             OP_SR,       F_0F,   OP_NONE,       OP3_NONE,1,  R_in_OP,0x81,     0x00,                     P_386,       0)
ins (T_POP,             OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0x8F,     0x00,                     P_86,        0)
ins (T_POPA,            OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x61,     0x00,                     P_186,       0)
ins (T_POPAD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x61,     0x00,                     P_386,       0)
insa(T_POPCONTEXT,      OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_POPF,            OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9D,     0x00,                     P_86,        0)
ins (T_POPFD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9D,     0x00,                     P_386,       0)
ins (T_POR,             OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xEB,     0x00,                     P_586|P_MMX, 0)
ins (T_POR,             OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xEB,     0x00,                     P_686|P_SSE2,0)
ins (T_PREFETCH,        OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x0D,     0x00,                     P_586|P_K3D, 0)
ins (T_PREFETCHNTA,     OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x00,                     P_686|P_SSE, 0)
ins (T_PREFETCHT0,      OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x08,                     P_686|P_SSE, 0)
ins (T_PREFETCHT1,      OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x10,                     P_686|P_SSE, 0)
ins (T_PREFETCHT2,      OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x18,                     P_686|P_SSE, 0)
ins (T_PREFETCHW,       OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x0D,     0x08,                     P_586|P_K3D, 0)
insa(T_PROC,            OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_PROTO,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_PSADBW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF6,     0x00,                     P_686|P_SSE, 0)
ins (T_PSADBW,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF6,     0x00,                     P_686|P_SSE2,0)
ins (T_PSHUFD,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0x70,     0x00,                     P_686|P_SSE2,0)
ins (T_PSHUFHW,         OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0x70,     0x00,                     P_686|P_SSE2,0)
ins (T_PSHUFLW,         OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0x70,     0x00,                     P_686|P_SSE2,0)
ins (T_PSHUFW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_I8_U,1,  no_WDS, 0x70,     0x00,                     P_686|P_SSE, 0)
ins (T_PSLLD,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF2,     0x00,                     P_586|P_MMX, 0)
ins (T_PSLLD,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x30,                     P_586|P_MMX, 0)
ins (T_PSLLD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF2,     0x00,                     P_686|P_SSE2,0)
ins (T_PSLLD,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x30,                     P_686|P_SSE2,0)
ins (T_PSLLDQ,          OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x38,                     P_686|P_SSE2,0)
ins (T_PSLLQ,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF3,     0x00,                     P_586|P_MMX, 0)
ins (T_PSLLQ,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x30,                     P_586|P_MMX, 0)
ins (T_PSLLQ,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF3,     0x00,                     P_686|P_SSE2,0)
ins (T_PSLLQ,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x30,                     P_686|P_SSE2,0)
ins (T_PSLLW,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF1,     0x00,                     P_586|P_MMX, 0)
ins (T_PSLLW,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x30,                     P_586|P_MMX, 0)
ins (T_PSLLW,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF1,     0x00,                     P_686|P_SSE2,0)
ins (T_PSLLW,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x30,                     P_686|P_SSE2,0)
ins (T_PSRAD,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE2,     0x00,                     P_586|P_MMX, 0)
ins (T_PSRAD,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x20,                     P_586|P_MMX, 0)
ins (T_PSRAD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE2,     0x00,                     P_686|P_SSE2,0)
ins (T_PSRAD,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x20,                     P_686|P_SSE2,0)
ins (T_PSRAW,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE1,     0x00,                     P_586|P_MMX, 0)
ins (T_PSRAW,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x20,                     P_586|P_MMX, 0)
ins (T_PSRAW,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE1,     0x00,                     P_586|P_SSE2,0)
ins (T_PSRAW,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x20,                     P_686|P_SSE2,0)
ins (T_PSRLD,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xD2,     0x00,                     P_586|P_MMX, 0)
ins (T_PSRLD,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x10,                     P_586|P_MMX, 0)
ins (T_PSRLD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xD2,     0x00,                     P_686|P_SSE2,0)
ins (T_PSRLD,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x10,                     P_686|P_SSE2,0)
ins (T_PSRLDQ,          OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x18,                     P_686|P_SSE2,0)
ins (T_PSRLQ,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xD3,     0x00,                     P_586|P_MMX, 0)
ins (T_PSRLQ,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x10,                     P_586|P_MMX, 0)
ins (T_PSRLQ,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xD3,     0x00,                     P_686|P_SSE2,0)
ins (T_PSRLQ,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x10,                     P_686|P_SSE2,0)
ins (T_PSRLW,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xD1,     0x00,                     P_586|P_MMX, 0)
ins (T_PSRLW,           OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x10,                     P_586|P_MMX, 0)
ins (T_PSRLW,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xD1,     0x00,                     P_686|P_SSE2,0)
ins (T_PSRLW,           OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x10,                     P_686|P_SSE2,0)
ins (T_PSUBB,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF8,     0x00,                     P_586|P_MMX, 0)
ins (T_PSUBB,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF8,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBD,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xFA,     0x00,                     P_586|P_MMX, 0)
ins (T_PSUBD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xFA,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBQ,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xFB,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBQ,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xFB,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBSB,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE8,     0x00,                     P_586|P_MMX, 0)
ins (T_PSUBSB,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE8,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBSW,          OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xE9,     0x00,                     P_586|P_MMX, 0)
ins (T_PSUBSW,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xE9,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBUSB,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xD8,     0x00,                     P_586|P_MMX, 0)
ins (T_PSUBUSB,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xD8,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBUSW,         OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xD9,     0x00,                     P_586|P_MMX, 0)
ins (T_PSUBUSW,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xD9,     0x00,                     P_686|P_SSE2,0)
ins (T_PSUBW,           OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xF9,     0x00,                     P_586|P_MMX, 0)
ins (T_PSUBW,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xF9,     0x00,                     P_686|P_SSE2,0)
ins (T_PSWAPD,          OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xBB,     0x00,                     P_586|P_K3D, 0)
ins (T_PTR,             OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
insa(T_PUBLIC,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_PUNPCKHBW,       OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x68,     0x00,                     P_586|P_MMX, 0)
ins (T_PUNPCKHBW,       OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x68,     0x00,                     P_686|P_SSE2,0)
ins (T_PUNPCKHDQ,       OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x6A,     0x00,                     P_586|P_MMX, 0)
ins (T_PUNPCKHDQ,       OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x6A,     0x00,                     P_686|P_SSE2,0)
ins (T_PUNPCKHQDQ,      OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x6D,     0x00,                     P_686|P_SSE2,0)
ins (T_PUNPCKHWD,       OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x69,     0x00,                     P_586|P_MMX, 0)
ins (T_PUNPCKHWD,       OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x69,     0x00,                     P_686|P_SSE2,0)
ins (T_PUNPCKLBW,       OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x60,     0x00,                     P_586|P_MMX, 0)
ins (T_PUNPCKLBW,       OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x60,     0x00,                     P_686|P_SSE2,0)
ins (T_PUNPCKLDQ,       OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x62,     0x00,                     P_586|P_MMX, 0)
ins (T_PUNPCKLDQ,       OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x62,     0x00,                     P_686|P_SSE2,0)
ins (T_PUNPCKLQDQ,      OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x6C,     0x00,                     P_686|P_SSE2,0)
ins (T_PUNPCKLWD,       OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x61,     0x00,                     P_586|P_MMX, 0)
ins (T_PUNPCKLWD,       OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x61,     0x00,                     P_686|P_SSE2,0)
insa(T_PURGE,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_PUSH,            OP_R1632,    0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x50,     0x00,                     P_86,        0)
ins (T_PUSH,            OP_SR2,      0,      OP_NONE,       OP3_NONE,1,  R_in_OP,0x06,     0x00,                     P_86,        0)
ins (T_PUSH,            OP_SR,       F_0F,   OP_NONE,       OP3_NONE,1,  R_in_OP,0x80,     0x00,                     P_386,       0)
ins (T_PUSH,            OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x30,                     P_86,        0)
ins (T_PUSH,            OP_I8,       0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x6A,     0x00,                     P_186,       0)
ins (T_PUSH,            OP_I,        0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x68,     0x00,                     P_186,       0)
ins (T_PUSHA,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x60,     0x00,                     P_186,       0)
ins (T_PUSHAD,          OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x60,     0x00,                     P_386,       0)
insa(T_PUSHCONTEXT,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_PUSHD,           OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x6A,     0x00,                     P_386,       0)
ins (T_PUSHD,           OP_I32,      F_32,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x68,     0x00,                     P_386,       0)
ins (T_PUSHF,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9C,     0x00,                     P_86,        0)
ins (T_PUSHFD,          OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9C,     0x00,                     P_386,       0)
ins (T_PUSHW,           OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x6A,     0x00,                     P_186,       0)
ins (T_PUSHW,           OP_I16,      F_16,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x68,     0x00,                     P_186,       0)
ins (T_PWORD,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
insa(T_PXMM,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_686,       0)
insa(T_PXMM2,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_686,       0)
insa(T_PXMM3,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    P_686,       0)
ins (T_PXOR,            OP_MMX,      F_0F,   OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xEF,     0x00,                     P_586|P_MMX, 0)
ins (T_PXOR,            OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0xEF,     0x00,                     P_686|P_SSE2,0)
ins (T_QWORD,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_RCL,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x10,                     P_86,        0)
ins (T_RCL,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x10,                     P_86,        0)
ins (T_RCL,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x10,                     P_186,       0)
ins (T_RCL,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x10,                     P_86,        0)
ins (T_RCL,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x10,                     P_86,        0)
ins (T_RCL,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x10,                     P_186,       0)
ins (T_RCL,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x10,                     P_386,       0)
ins (T_RCL,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x10,                     P_386,       0)
ins (T_RCL,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x10,                     P_386,       0)
ins (T_RCL,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x10,                     P_86,        0)
ins (T_RCL,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x10,                     P_86,        0)
ins (T_RCL,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x10,                     P_186,       0)
ins (T_RCPPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x53,     0x00,                     P_686|P_SSE, 0)
ins (T_RCPSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x53,     0x00,                     P_686|P_SSE, 0)
ins (T_RCR,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x18,                     P_86,        0)
ins (T_RCR,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x18,                     P_86,        0)
ins (T_RCR,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x18,                     P_186,       0)
ins (T_RCR,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x18,                     P_86,        0)
ins (T_RCR,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x18,                     P_86,        0)
ins (T_RCR,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x18,                     P_186,       0)
ins (T_RCR,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x18,                     P_386,       0)
ins (T_RCR,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x18,                     P_386,       0)
ins (T_RCR,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x18,                     P_386,       0)
ins (T_RCR,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x18,                     P_86,        0)
ins (T_RCR,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x18,                     P_86,        0)
ins (T_RCR,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x18,                     P_186,       0)
ins (T_RDMSR,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x32,     0x00,                     P_586,       0)
ins (T_RDPMC,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x33,     0x00,                     P_686,       0)
ins (T_RDTSC,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x31,     0x00,                     P_586,       0)
insa(T_RECORD,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_REP,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF3,     0x00,                     P_86,        0)
ins (T_REPE,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF3,     0x00,                     P_86,        0)
insa(T_REPEAT,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_REPNE,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF2,     0x00,                     P_86,        0)
ins (T_REPNZ,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF2,     0x00,                     P_86,        0)
insa(T_REPT,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_REPZ,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF3,     0x00,                     P_86,        0)
ins (T_RET,             OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC2,     0x00,                     P_86,        0)
ins (T_RET,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC3,     0x00,                     P_86,        0)
ins (T_RETD,            OP_I16,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCA,     0x00,                     P_386,       0)
ins (T_RETD,            OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCB,     0x00,                     P_386,       0)
ins (T_RETF,            OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCA,     0x00,                     P_86,        0)
ins (T_RETF,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCB,     0x00,                     P_86,        0)
ins (T_RETFD,           OP_I16,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCA,     0x00,                     P_386,       0)
ins (T_RETFD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCB,     0x00,                     P_386,       0)
ins (T_RETN,            OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC2,     0x00,                     P_86,        0)
ins (T_RETN,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC3,     0x00,                     P_86,        0)
ins (T_ROL,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x00,                     P_86,        0)
ins (T_ROL,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x00,                     P_86,        0)
ins (T_ROL,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x00,                     P_186,       0)
ins (T_ROL,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x00,                     P_86,        0)
ins (T_ROL,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x00,                     P_86,        0)
ins (T_ROL,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x00,                     P_186,       0)
ins (T_ROL,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x00,                     P_386,       0)
ins (T_ROL,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x00,                     P_386,       0)
ins (T_ROL,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x00,                     P_386,       0)
ins (T_ROL,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x00,                     P_86,        0)
ins (T_ROL,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x00,                     P_86,        0)
ins (T_ROL,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x00,                     P_186,       0)
ins (T_ROR,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x08,                     P_86,        0)
ins (T_ROR,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x08,                     P_86,        0)
ins (T_ROR,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x08,                     P_186,       0)
ins (T_ROR,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x08,                     P_86,        0)
ins (T_ROR,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x08,                     P_86,        0)
ins (T_ROR,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x08,                     P_186,       0)
ins (T_ROR,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x08,                     P_386,       0)
ins (T_ROR,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x08,                     P_386,       0)
ins (T_ROR,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x08,                     P_386,       0)
ins (T_ROR,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x08,                     P_86,        0)
ins (T_ROR,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x08,                     P_86,        0)
ins (T_ROR,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x08,                     P_186,       0)
ins (T_RSM,             OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAA,     0x00,                     P_586,       0)
ins (T_RSQRTPS,         OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x52,     0x00,                     P_686|P_SSE, 0)
ins (T_RSQRTSS,         OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x52,     0x00,                     P_686|P_SSE, 0)
ins (T_SAHF,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9E,     0x00,                     P_86,        0)
ins (T_SAL,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x20,                     P_86,        0)
ins (T_SAL,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x20,                     P_86,        0)
ins (T_SAL,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x20,                     P_186,       0)
ins (T_SAL,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x20,                     P_86,        0)
ins (T_SAL,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x20,                     P_86,        0)
ins (T_SAL,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x20,                     P_186,       0)
ins (T_SAL,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x20,                     P_386,       0)
ins (T_SAL,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x20,                     P_386,       0)
ins (T_SAL,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x20,                     P_386,       0)
ins (T_SAL,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x20,                     P_86,        0)
ins (T_SAL,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x20,                     P_86,        0)
ins (T_SAL,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x20,                     P_186,       0)
ins (T_SAR,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x38,                     P_86,        0)
ins (T_SAR,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x38,                     P_86,        0)
ins (T_SAR,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x38,                     P_186,       0)
ins (T_SAR,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x38,                     P_86,        0)
ins (T_SAR,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x38,                     P_86,        0)
ins (T_SAR,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x38,                     P_186,       0)
ins (T_SAR,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x38,                     P_386,       0)
ins (T_SAR,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x38,                     P_386,       0)
ins (T_SAR,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x38,                     P_386,       0)
ins (T_SAR,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x38,                     P_86,        0)
ins (T_SAR,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x38,                     P_86,        0)
ins (T_SAR,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x38,                     P_186,       0)
ins (T_SBB,             OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x18,                     P_86,        0)
ins (T_SBB,             OP_R,        0,      OP_R,          OP3_NONE,0,  0,      0x18,     0x00,                     P_86,        0)
ins (T_SBB,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x1A,     0x00,                     P_86,        0)
ins (T_SBB,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x1C,     0x00,                     P_86,        0)
ins (T_SBB,             OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x18,                     P_86,        0)
ins (T_SBB,             OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x18,                     P_386,       LOCK)
ins (T_SBB,             OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x18,                     P_86,        LOCK)
ins (T_SBB,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x18,     0x00,                     P_86,        LOCK)
ins (T_SBB,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x18,                     P_86,        LOCK)
insa(T_SBYTE,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_SCAS,            OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAE,     0x00,                     P_86,        REPxx)
ins (T_SCASB,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAE,     0x00,                     P_86,        REPxx)
ins (T_SCASD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,                     P_386,       REPxx)
ins (T_SCASW,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,                     P_86,        REPxx)
insa(T_SDWORD,          OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_SEG,             OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_UNARY_OPERATOR,        0,           0)
insa(T_SEGMENT,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             P_86,        0)
ins (T_SETA,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x97,     0x00,                     P_386,       0)
ins (T_SETAE,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x93,     0x00,                     P_386,       0)
ins (T_SETB,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x92,     0x00,                     P_386,       0)
ins (T_SETBE,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x96,     0x00,                     P_386,       0)
ins (T_SETC,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x92,     0x00,                     P_386,       0)
ins (T_SETE,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x94,     0x00,                     P_386,       0)
ins (T_SETG,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9F,     0x00,                     P_386,       0)
ins (T_SETGE,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9D,     0x00,                     P_386,       0)
ins (T_SETL,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9C,     0x00,                     P_386,       0)
ins (T_SETLE,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9E,     0x00,                     P_386,       0)
ins (T_SETNA,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x96,     0x00,                     P_386,       0)
ins (T_SETNAE,          OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x92,     0x00,                     P_386,       0)
ins (T_SETNB,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x93,     0x00,                     P_386,       0)
ins (T_SETNBE,          OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x97,     0x00,                     P_386,       0)
ins (T_SETNC,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x93,     0x00,                     P_386,       0)
ins (T_SETNE,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x95,     0x00,                     P_386,       0)
ins (T_SETNG,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9E,     0x00,                     P_386,       0)
ins (T_SETNGE,          OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9C,     0x00,                     P_386,       0)
ins (T_SETNL,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9D,     0x00,                     P_386,       0)
ins (T_SETNLE,          OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9F,     0x00,                     P_386,       0)
ins (T_SETNO,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x91,     0x00,                     P_386,       0)
ins (T_SETNP,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9B,     0x00,                     P_386,       0)
ins (T_SETNS,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x99,     0x00,                     P_386,       0)
ins (T_SETNZ,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x95,     0x00,                     P_386,       0)
ins (T_SETO,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x90,     0x00,                     P_386,       0)
ins (T_SETP,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9A,     0x00,                     P_386,       0)
ins (T_SETPE,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9A,     0x00,                     P_386,       0)
ins (T_SETPO,           OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9B,     0x00,                     P_386,       0)
ins (T_SETS,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x98,     0x00,                     P_386,       0)
ins (T_SETZ,            OP_M8_R8,    F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x94,     0x00,                     P_386,       0)
ins (T_SFENCE,          OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0xF8,                     P_686|P_SSE, 0)
ins (T_SGDT,            OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x00,                     P_286,       0)
ins (T_SHL,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x20,                     P_86,        0)
ins (T_SHL,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x20,                     P_86,        0)
ins (T_SHL,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x20,                     P_186,       0)
ins (T_SHL,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x20,                     P_86,        0)
ins (T_SHL,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x20,                     P_86,        0)
ins (T_SHL,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x20,                     P_186,       0)
ins (T_SHL,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x20,                     P_386,       0)
ins (T_SHL,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x20,                     P_386,       0)
ins (T_SHL,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x20,                     P_386,       0)
ins (T_SHL,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x20,                     P_86,        0)
ins (T_SHL,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x20,                     P_86,        0)
ins (T_SHL,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x20,                     P_186,       0)
ins (T_SHLD,            OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xA5,     0x00,                     P_386,       0)
ins (T_SHLD,            OP_R1632,    F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xA4,     0x00,                     P_386,       0)
ins (T_SHLD,            OP_M,        F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xA5,     0x00,                     P_386,       0)
ins (T_SHLD,            OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xA4,     0x00,                     P_386,       0)
ins (T_SHORT,           OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_RES_ID,                0,           0)
ins (T_SHR,             OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x28,                     P_86,        0)
ins (T_SHR,             OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x28,                     P_86,        0)
ins (T_SHR,             OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x28,                     P_186,       0)
ins (T_SHR,             OP_M_B,      0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     0x28,                     P_86,        0)
ins (T_SHR,             OP_M_B,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     0x28,                     P_86,        0)
ins (T_SHR,             OP_M_B,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     0x28,                     P_186,       0)
ins (T_SHR,             OP_M_DW,     0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x28,                     P_386,       0)
ins (T_SHR,             OP_M_DW,     0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x28,                     P_386,       0)
ins (T_SHR,             OP_M_DW,     0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x28,                     P_386,       0)
ins (T_SHR,             OP_M_W,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     0x28,                     P_86,        0)
ins (T_SHR,             OP_M_W,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     0x28,                     P_86,        0)
ins (T_SHR,             OP_M_W,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     0x28,                     P_186,       0)
ins (T_SHRD,            OP_R1632,    F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xAD,     0x00,                     P_386,       0)
ins (T_SHRD,            OP_R1632,    F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xAC,     0x00,                     P_386,       0)
ins (T_SHRD,            OP_M,        F_0F,   OP_R1632,      OP3_NONE,0,  no_WDS, 0xAD,     0x00,                     P_386,       0)
ins (T_SHRD,            OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xAC,     0x00,                     P_386,       0)
ins (T_SHUFPD,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0xC6,     0x00,                     P_686|P_SSE2,0)
ins (T_SHUFPS,          OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_I8_U,1,  no_WDS, 0xC6,     0x00,                     P_686|P_SSE, 0)
ins (T_SI,              OP_SPECIAL,  0,      OP_R16,        0,       0,  0,      6,        OP_REGISTER,              P_86,        IREG)
ins (T_SIDT,            OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x08,                     P_286,       0)
insa(T_SIZE,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_UNARY_OPERATOR,        0,           0)
insa(T_SIZEOF,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_UNARY_OPERATOR,        0,           0)
ins (T_SLDT,            OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x00,                     P_286,       0)
ins (T_SLDT,            OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x00,                     P_286,       0)
ins (T_SMSW,            OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x20,                     P_286,       0)
ins (T_SMSW,            OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x20,                     P_286,       0)
ins (T_SP,              OP_SPECIAL,  0,      OP_R16,        0,       0,  0,      4,        OP_REGISTER,              P_86,        0)
ins (T_SQRTPD,          OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x51,     0x00,                     P_686|P_SSE2,0)
ins (T_SQRTPS,          OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x51,     0x00,                     P_686|P_SSE, 0)
ins (T_SQRTSD,          OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x51,     0x00,                     P_686|P_SSE2,0)
ins (T_SQRTSS,          OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x51,     0x00,                     P_686|P_SSE, 0)
ins (T_SS,              OP_SPECIAL,  0,      OP_SR2,        0,       0,  0,      PREFIX_SS,OP_REGISTER,              P_86,        0)
ins (T_ST,              OP_SPECIAL,  0,      OP_ST,         0,       0,  0,      0,        OP_REGISTER,              P_87,        0)
insa(T_STACK,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
insa(T_STARTUPCODE,     OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
ins (T_STC,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF9,     0x00,                     P_86,        0)
ins (T_STD,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFD,     0x00,                     P_86,        0)
ins (T_STI,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFB,     0x00,                     P_86,        0)
ins (T_STMXCSR,         OP_M32,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x18,                     P_686|P_SSE, 0)
ins (T_STOS,            OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAA,     0x00,                     P_86,        REP)
ins (T_STOSB,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAA,     0x00,                     P_86,        REP)
ins (T_STOSD,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,                     P_386,       REP)
ins (T_STOSW,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,                     P_86,        REP)
ins (T_STR,             OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x08,                     P_286,       0)
ins (T_STR,             OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x08,                     P_286,       0)
insa(T_STRUC,           OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_STRUCT,          OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_SUB,             OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x28,                     P_86,        0)
ins (T_SUB,             OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x2A,     0x00,                     P_86,        0)
ins (T_SUB,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x2A,     0x00,                     P_86,        0)
ins (T_SUB,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x2C,     0x00,                     P_86,        0)
ins (T_SUB,             OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x28,                     P_86,        0)
ins (T_SUB,             OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x28,                     P_386,       LOCK)
ins (T_SUB,             OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x28,                     P_86,        LOCK)
ins (T_SUB,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x28,     0x00,                     P_86,        LOCK)
ins (T_SUB,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x28,                     P_86,        LOCK)
ins (T_SUBPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5C,     0x00,                     P_686|P_SSE2,0)
ins (T_SUBPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5C,     0x00,                     P_686|P_SSE, 0)
ins (T_SUBSD,           OP_XMM,      F_F20F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5C,     0x00,                     P_686|P_SSE2,0)
ins (T_SUBSS,           OP_XMM,      F_F30F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x5C,     0x00,                     P_686|P_SSE, 0)
insa(T_SUBTITLE,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_SUBTTL,          OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_SWORD,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_SYSENTER,        OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x34,     0x00,                     P_686p,      0)
ins (T_SYSEXIT,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x35,     0x00,                     P_686p,      0)
ins (T_TBYTE,           OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_TEST,            OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0xA8,     0x00,                     P_86,        0)
ins (T_TEST,            OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x84,     0x00,                     P_86,        0)
ins (T_TEST,            OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x84,     0x00,                     P_86,        0)
ins (T_TEST,            OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0xF6,     0x00,                     P_86,        0)
ins (T_TEST,            OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x84,     0x00,                     P_86,        0)
ins (T_TEST,            OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0xF6,     0x00,                     P_86,        0)
insa(T_TEXTEQU,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_THIS,            OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
insa(T_TITLE,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_TR3,             OP_SPECIAL,  0,      OP_TR,         0,       0,  0,      3,        OP_REGISTER,              P_486,       0)
ins (T_TR4,             OP_SPECIAL,  0,      OP_TR,         0,       0,  0,      4,        OP_REGISTER,              P_486,       0)
ins (T_TR5,             OP_SPECIAL,  0,      OP_TR,         0,       0,  0,      5,        OP_REGISTER,              P_486,       0)
ins (T_TR6,             OP_SPECIAL,  0,      OP_TR,         0,       0,  0,      6,        OP_REGISTER,              P_486,       0)
ins (T_TR7,             OP_SPECIAL,  0,      OP_TR,         0,       0,  0,      7,        OP_REGISTER,              P_386,       0)
insa(T_TYPEDEF,         OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_UCOMISD,         OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2E,     0x00,                     P_686|P_SSE2,0)
ins (T_UCOMISS,         OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x2E,     0x00,                     P_686|P_SSE, 0)
insa(T_UDATASEG,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
insa(T_UFARDATA,        OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
insa(T_UNION,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_UNPCKHPD,        OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x15,     0x00,                     P_686|P_SSE2,0)
ins (T_UNPCKHPS,        OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x15,     0x00,                     P_686|P_SSE, 0)
ins (T_UNPCKLPD,        OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x14,     0x00,                     P_686|P_SSE2,0)
ins (T_UNPCKLPS,        OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x14,     0x00,                     P_686|P_SSE, 0)
insa(T_USES,            OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_VERR,            OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x20,                     P_286,       0)
ins (T_VERR,            OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x20,                     P_286,       0)
ins (T_VERW,            OP_R16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x28,                     P_286,       0)
ins (T_VERW,            OP_M16,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x00,     0x28,                     P_286,       0)
ins (T_WAIT,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9B,     0x00,                     P_86,        0)
insa(T_WARN,            OP_SPECIAL,  0,      0,             0,       0,  0,      0,        OP_DIRECTIVE|OP_IDEAL,    0,           0)
ins (T_WBINVD,          OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x09,     0x00,                     P_486,       0)
insa(T_WIDTH,           OP_SPECIAL,  0,      OP_NONE,       0,       0,  0,      0,        OP_DIRECTIVE,             0,           0)
ins (T_WORD,            OP_SPECIAL,  0,      OP_SPECIAL,    0,       0,  0,      0,        OP_RES_ID|OP_PTR_MODIFIER,0,           0)
ins (T_WRMSR,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x30,     0x00,                     P_586,       0)
ins (T_XADD,            OP_R,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xC0,     0x00,                     P_486,       0)
ins (T_XADD,            OP_M,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xC0,     0x00,                     P_486,       LOCK)
ins (T_XCHG,            OP_A,        0,      OP_R1632,      OP3_NONE,0,  R_in_OP,0x90,     0x00,                     P_86,        0)
ins (T_XCHG,            OP_R1632,    0,      OP_A,          OP3_NONE,0,  R_in_OP,0x90,     0x00,                     P_86,        0)
ins (T_XCHG,            OP_R,        0,      OP_R,          OP3_NONE,0,  0,      0x86,     0x00,                     P_86,        0)
ins (T_XCHG,            OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x86,     0x00,                     P_86,        LOCK)
ins (T_XCHG,            OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x86,     0x00,                     P_86,        LOCK)
ins (T_XLAT,            OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,                     P_86,        0)
ins (T_XLAT,            OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,                     P_86,        0)
ins (T_XLATB,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,                     P_86,        0)
ins (T_XLATB,           OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,                     P_86,        0)
ins (T_XMM0,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      0,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XMM1,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      1,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XMM2,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      2,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XMM3,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      3,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XMM4,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      4,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XMM5,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      5,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XMM6,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      6,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XMM7,            OP_SPECIAL,  0,      OP_XMM,        0,       0,  0,      7,        OP_REGISTER,              P_686|P_SSE, 0)
ins (T_XOR,             OP_R1632,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x30,                     P_86,        0)
ins (T_XOR,             OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x32,     0x00,                     P_86,        0)
ins (T_XOR,             OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x32,     0x00,                     P_86,        0)
ins (T_XOR,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x34,     0x00,                     P_86,        0)
ins (T_XOR,             OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x30,                     P_86,        0)
ins (T_XOR,             OP_M_DW,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x30,                     P_386,       LOCK)
ins (T_XOR,             OP_M_W,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     0x30,                     P_86,        LOCK)
ins (T_XOR,             OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x30,     0x00,                     P_86,        LOCK)
ins (T_XOR,             OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     0x30,                     P_86,        LOCK)
ins (T_XORPD,           OP_XMM,      F_660F, OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x57,     0x00,                     P_686|P_SSE2,0)
ins (T_XORPS,           OP_XMM,      F_0F,   OP_XMM|OP_M,   OP3_NONE,1,  no_WDS, 0x57,     0x00,                     P_686|P_SSE, 0)
};
