/***************************************************************************
*
*                            Open Watcom Project
*
*  Copyright (c) 2004-2008 The Open Watcom Contributors. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
*  Description: Implementation of the dxguid.lib library.
*
**************************************************************************/

#include <windows.h>

/* d3d.h */
EXTERN_C const IID  IID_IDirect3D =
    { 0x3BBA0080, 0x2421, 0x11CF, { 0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56 } };
EXTERN_C const IID  IID_IDirect3DDevice =
    { 0x64108800, 0x957D, 0x11D0, { 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29 } };
EXTERN_C const IID  IID_IDirect3DTexture =
    { 0x2CDCD9E0, 0x25A0, 0x11CF, { 0xA3, 0x1A, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56 } };
EXTERN_C const IID  IID_IDirect3DLight =
    { 0x4417C142, 0x33AD, 0x11CF, { 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E } };
EXTERN_C const IID  IID_IDirect3DMaterial =
    { 0x4417C144, 0x33AD, 0x11CF, { 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E } };
EXTERN_C const IID  IID_IDirect3DExecuteBuffer =
    { 0x4417C145, 0x33AD, 0x11CF, { 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E } };
EXTERN_C const IID  IID_IDirect3DViewport =
    { 0x4417C146, 0x33AD, 0x11CF, { 0x81, 0x6F, 0x00, 0x00, 0xC0, 0x20, 0x15, 0x6E } };
EXTERN_C const IID  IID_IDirect3D2 =
    { 0x6AAE1EC1, 0x622A, 0x11D0, { 0x88, 0x9D, 0x00, 0xAA, 0x00, 0xBB, 0xB7, 0x6A } };
EXTERN_C const IID  IID_IDirect3DDevice2 =
    { 0x93281501, 0x8CF8, 0x11D0, { 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29 } };
EXTERN_C const IID  IID_IDirect3DTexture2 =
    { 0x93281502, 0x8CF8, 0x11D0, { 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29 } };
EXTERN_C const IID  IID_IDirect3DMaterial2 =
    { 0x93281503, 0x8CF8, 0x11D0, { 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29 } };
EXTERN_C const IID  IID_IDirect3DViewport2 =
    { 0x93281500, 0x8CF8, 0x11D0, { 0x89, 0xAB, 0x00, 0xA0, 0xC9, 0x05, 0x41, 0x29 } };
EXTERN_C const IID  IID_IDirect3D3 =
    { 0xBB223240, 0xE72B, 0x11D0, { 0xA9, 0xB4, 0x00, 0xAA, 0x00, 0xC0, 0x99, 0x3E } };
EXTERN_C const IID  IID_IDirect3DDevice3 =
    { 0xB0AB3B60, 0x33D7, 0x11D1, { 0xA9, 0x81, 0x00, 0xC0, 0x4F, 0xD7, 0xB1, 0x74 } };
EXTERN_C const IID  IID_IDirect3DMaterial3 =
    { 0xCA9C46F4, 0xD3C5, 0x11D1, { 0xB7, 0x5A, 0x00, 0x60, 0x08, 0x52, 0xB3, 0x12 } };
EXTERN_C const IID  IID_IDirect3DViewport3 =
    { 0xB0AB3B61, 0x33D7, 0x11D1, { 0xA9, 0x81, 0x00, 0xC0, 0x4F, 0xD7, 0xB1, 0x74 } };
EXTERN_C const IID  IID_IDirect3DVertexBuffer =
    { 0x7A503555, 0x4A83, 0x11D1, { 0xA5, 0xDB, 0x00, 0xA0, 0xC9, 0x03, 0x67, 0xF8 } };
EXTERN_C const IID  IID_IDirect3D7 =
    { 0xF5049E77, 0x4861, 0x11D2, { 0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8 } };
EXTERN_C const IID  IID_IDirect3DDevice7 =
    { 0xF5049E79, 0x4861, 0x11D2, { 0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8 } };
EXTERN_C const IID  IID_IDirect3DVertexBuffer7 =
    { 0xF5049E7D, 0x4861, 0x11D2, { 0xA4, 0x07, 0x00, 0xA0, 0xC9, 0x06, 0x29, 0xA8 } };

/* d3drmobj.h */
EXTERN_C const IID      IID_IDirect3DRMObject =
    { 0xEB16CB00, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMObject2 =
    { 0x4516EC7C, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMVisual =
    { 0xEB16CB04, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMDevice =
    { 0xE9E19280, 0x6E05, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMDevice2 =
    { 0x4516EC78, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMDevice3 =
    { 0x549F498B, 0xBFEB, 0x11D1, { 0x8E, 0xD8, 0x00, 0xA0, 0xC9, 0x67, 0xA4, 0x82 } };
EXTERN_C const IID      IID_IDirect3DRMViewport =
    { 0xEB16CB02, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMViewport2 =
    { 0x4A1B1BE6, 0xBFED, 0x11D1, { 0x8E, 0xD8, 0x00, 0xA0, 0xC9, 0x67, 0xA4, 0x82 } };
EXTERN_C const IID      IID_IDirect3DRMFrame =
    { 0xEB16CB03, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMFrame2 =
    { 0xC3DFBD60, 0x3988, 0x11D0, { 0x9E, 0xC2, 0x00, 0x00, 0xC0, 0x29, 0x1A, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMFrame3 =
    { 0xFF6B7F70, 0xA40E, 0x11D1, { 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66 } };
EXTERN_C const IID      IID_IDirect3DRMMesh =
    { 0xA3A80D01, 0x6E12, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMProgressiveMesh =
    { 0x4516EC79, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMShadow =
    { 0xAF359780, 0x6BA3, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMShadow2 =
    { 0x86B44E25, 0x9C82, 0x11D1, { 0xBB, 0x0B, 0x00, 0xA0, 0xC9, 0x81, 0xA0, 0xA6 } };
EXTERN_C const IID      IID_IDirect3DRMFace =
    { 0xEB16CB07, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMFace2 =
    { 0x4516EC81, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMMeshBuilder =
    { 0xA3A80D02, 0x6E12, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMMeshBuilder2 =
    { 0x4516EC77, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMMeshBuilder3 =
    { 0x4516EC82, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMLight =
    { 0xEB16CB08, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMTexture =
    { 0xEB16CB09, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMTexture2 =
    { 0x120F30C0, 0x1629, 0x11D0, { 0x94, 0x1C, 0x00, 0x80, 0xC8, 0x0C, 0xFA, 0x7B } };
EXTERN_C const IID      IID_IDirect3DRMTexture3 =
    { 0xFF6B7F73, 0xA40E, 0x11D1, { 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66 } };
EXTERN_C const IID      IID_IDirect3DRMWrap =
    { 0xEB16CB0A, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMMaterial =
    { 0xEB16CB0B, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMMaterial2 =
    { 0xFF6B7F75, 0xA40E, 0x11D1, { 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66 } };
EXTERN_C const IID      IID_IDirect3DRMAnimation =
    { 0xEB16CB0D, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMAnimation2 =
    { 0xFF6B7F77, 0xA40E, 0x11D1, { 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66 } };
EXTERN_C const IID      IID_IDirect3DRMAnimationSet =
    { 0xEB16CB0E, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMAnimationSet2 =
    { 0xFF6B7F79, 0xA40E, 0x11D1, { 0x91, 0xF9, 0x00, 0x00, 0xF8, 0x75, 0x8E, 0x66 } };
EXTERN_C const IID      IID_IDirect3DRMUserVisual =
    { 0x59163DE0, 0x6D43, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMObjectArray =
    { 0x242F6BC2, 0x3849, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMDeviceArray =
    { 0xEB16CB10, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMFrameArray =
    { 0xEB16CB12, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMViewportArray =
    { 0xEB16CB11, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMVisualArray =
    { 0xEB16CB13, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMAnimationArray =
    { 0xD5F1CAE0, 0x4BD7, 0x11D1, { 0xB9, 0x74, 0x00, 0x60, 0x08, 0x3E, 0x45, 0xF3 } };
EXTERN_C const IID      IID_IDirect3DRMPickedArray =
    { 0xEB16CB16, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } }; 
EXTERN_C const IID      IID_IDirect3DRMLightArray =
    { 0xEB16CB14, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMFaceArray =
    { 0xEB16CB17, 0xD271, 0x11CE, { 0xAC, 0x48, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRMPicked2Array =
    { 0x4516EC7B, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMInterpolator =
    { 0x242F6BC1, 0x3849, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRMClippedVisual =
    { 0x5434E733, 0x6D66, 0x11D1, { 0xBB, 0x0B, 0x00, 0x00, 0xF8, 0x75, 0x86, 0x5A } };
EXTERN_C const CLSID    CLSID_CDirect3DRMDevice =
    { 0x4FA3568E, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMViewport =
    { 0x4FA3568F, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMFrame =
    { 0x4FA35690, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMMesh =
    { 0x4FA35691, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMMeshBuilder =
    { 0x4FA35692, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMFace =
    { 0x4FA35693, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMLight =
    { 0x4FA35694, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMTexture =
    { 0x4FA35695, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMWrap =
    { 0x4FA35696, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMMaterial =
    { 0x4FA35697, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMAnimation =
    { 0x4FA35698, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMAnimationSet =
    { 0x4FA35699, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMUserVisual =
    { 0x4FA3669A, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMShadow =
    { 0x4FA3669B, 0x623F, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMViewportInterpolator =
    { 0x0DE9EAA1, 0x3B84, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMFrameInterpolator =
    { 0x0DE9EAA2, 0x3B84, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMMeshInterpolator =
    { 0x0DE9EAA3, 0x3B84, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMLightInterpolator =
    { 0x0DE9EAA6, 0x3B84, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMMaterialInterpolator =
    { 0x0DE9EAA7, 0x3B84, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMTextureInterpolator =
    { 0x0DE9EAA8, 0x3B84, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMProgressiveMesh =
    { 0x4516EC40, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRMClippedVisual =
    { 0x5434E72D, 0x6D66, 0x11D1, { 0xBB, 0x0B, 0x00, 0x00, 0xF8, 0x75, 0x86, 0x5A } };

/* d3drm.h */
EXTERN_C const IID      IID_IDirect3DRM =
    { 0x2BC49361, 0x8327, 0x11CF, { 0xAC, 0x4A, 0x00, 0x00, 0xC0, 0x38, 0x25, 0xA1 } };
EXTERN_C const IID      IID_IDirect3DRM2 =
    { 0x4516ECC8, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const IID      IID_IDirect3DRM3 =
    { 0x4516EC83, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };
EXTERN_C const CLSID    CLSID_CDirect3DRM =
    { 0x4516EC41, 0x8F20, 0x11D0, { 0x9B, 0x6D, 0x00, 0x00, 0xC0, 0x78, 0x1B, 0xC3 } };

/* d3d9.h */
EXTERN_C const IID  IID_IDirect3D9 =
    { 0x81BDCBCA, 0x64D4, 0x426D, { 0xAE, 0x8D, 0xAD, 0x01, 0x47, 0xF4, 0x27, 0x5C } };
EXTERN_C const IID  IID_IDirect3DDevice9 =
    { 0xD0223B96, 0xBF7A, 0x43FD, { 0x92, 0xBD, 0xA4, 0x3B, 0x0D, 0x82, 0xB9, 0xEB } };
EXTERN_C const IID  IID_IDirect3DStateBlock9 =
    { 0xB07C4FE5, 0x310D, 0x4BA8, { 0xA2, 0x3C, 0x4F, 0x0F, 0x20, 0x6F, 0x21, 0x8B } };
EXTERN_C const IID  IID_IDirect3DResource9 =
    { 0x05EEC05D, 0x8F7D, 0x4362, { 0xB9, 0x99, 0xD1, 0xBA, 0xF3, 0x57, 0xC7, 0x04 } };
EXTERN_C const IID  IID_IDirect3DVertexDeclaration9 =
    { 0xDD13C59C, 0x36FA, 0x4098, { 0xA8, 0xFB, 0xC7, 0xED, 0x39, 0xDC, 0x85, 0x46 } };
EXTERN_C const IID  IID_IDirect3DVertexShader9 =
    { 0xEFC5557E, 0x6265, 0x4613, { 0x8A, 0x94, 0x43, 0x85, 0x78, 0x89, 0xEB, 0x36 } };
EXTERN_C const IID  IID_IDirect3DPixelShader9 =
    { 0x6D3BDBDC, 0x5B02, 0x4415, { 0xB8, 0x52, 0xCE, 0x5E, 0x8B, 0xCC, 0xB2, 0x89 } };
EXTERN_C const IID  IID_IDirect3DBaseTexture9 =
    { 0x580CA87E, 0x1D3C, 0x4D54, { 0x99, 0x1D, 0xB7, 0xD3, 0xE3, 0xC2, 0x98, 0xCE } };
EXTERN_C const IID  IID_IDirect3DTexture9 =
    { 0x85C31227, 0x3DE5, 0x4F00, { 0x9B, 0x3A, 0xF1, 0x1A, 0xC3, 0x8C, 0x18, 0xB5 } };
EXTERN_C const IID  IID_IDirect3DVolumeTexture9 =
    { 0x2518526C, 0xE789, 0x4111, { 0xA7, 0xB9, 0x47, 0xEF, 0x32, 0x8D, 0x13, 0xE6 } };
EXTERN_C const IID  IID_IDirect3DCubeTexture9 =
    { 0xFFF32F81, 0xD953, 0x473A, { 0x92, 0x23, 0x93, 0xD6, 0x52, 0xAB, 0xA9, 0x3F } };
EXTERN_C const IID  IID_IDirect3DVertexBuffer9 =
    { 0xB64BB1B5, 0xFD70, 0x4DF6, { 0xBF, 0x91, 0x19, 0xD0, 0xA1, 0x24, 0x55, 0xE3 } };
EXTERN_C const IID  IID_IDirect3DIndexBuffer9 =
    { 0x7C9DD65E, 0xD3F7, 0x4529, { 0xAC, 0xEE, 0x78, 0x58, 0x30, 0xAC, 0xDE, 0x35 } };
EXTERN_C const IID  IID_IDirect3DSurface9 =
    { 0x0CFBAF3A, 0x9FF6, 0x429A, { 0x99, 0xB3, 0xA2, 0x79, 0x6A, 0xF8, 0xB8, 0x9B } };
EXTERN_C const IID  IID_IDirect3DVolume9 =
    { 0x24F416E6, 0x1F67, 0x4AA7, { 0xB8, 0x8E, 0xD3, 0x3F, 0x6F, 0x31, 0x28, 0xA1 } };
EXTERN_C const IID  IID_IDirect3DSwapChain9 =
    { 0x794950F2, 0xADFC, 0x458A, { 0x90, 0x5E, 0x10, 0xA1, 0x0B, 0x0B, 0x50, 0x3B } };
EXTERN_C const IID  IID_IDirect3DQuery9 =
    { 0xD9771460, 0xA695, 0x4F26, { 0xBB, 0xD3, 0x27, 0xB8, 0x40, 0xB5, 0x41, 0xCC } };
EXTERN_C const IID  IID_IDirect3D9Ex =
    { 0x02177241, 0x69FC, 0x400C, { 0x8F, 0xF1, 0x93, 0xA4, 0x4D, 0xF6, 0x86, 0x1D } };
EXTERN_C const IID  IID_IDirect3DDevice9Ex =
    { 0xB18B10CE, 0x2649, 0x405A, { 0x87, 0x0F, 0x95, 0xF7, 0x77, 0xD4, 0x31, 0x3A } };
EXTERN_C const IID  IID_IDirect3DSwapChain9Ex =
    { 0x91886CAF, 0x1C3D, 0x4D2E, { 0xA0, 0xAB, 0x3E, 0x4C, 0x7D, 0x8D, 0x33, 0x03 } };
EXTERN_C const IID  IID_IDirect3D9ExOverlayExtension =
    { 0x187AEB13, 0xAAF5, 0x4C59, { 0x87, 0x6D, 0xE0, 0x59, 0x08, 0x8C, 0x0D, 0xF8 } };
EXTERN_C const IID  IID_IDirect3DDevice9Video =
    { 0x26DC4561, 0xA1EE, 0x4AE7, { 0x96, 0xDA, 0x11, 0x8A, 0x36, 0xC0, 0xEC, 0x95 } };
EXTERN_C const IID  IID_IDirect3DAuthenticatedChannel9 =
    { 0xFF24BEEE, 0xDA21, 0x4BEB, { 0x98, 0xB5, 0xD2, 0xF8, 0x99, 0xF9, 0x8A, 0xF9 } };
EXTERN_C const IID  IID_IDirect3DCryptoSession9 =
    { 0xFA0AB799, 0x7A9C, 0x48CA, { 0x8C, 0x5B, 0x23, 0x7E, 0x71, 0xA5, 0x44, 0x34 } };

/* d3d9caps.h */
EXTERN_C const GUID D3DCRYPTOTYPE_AES128_CTR =
    { 0x9B6BD711, 0x4F74, 0x41C9, { 0x9E, 0x7B, 0x0B, 0xE2, 0xD7, 0xD9, 0x3B, 0x4F } };
EXTERN_C const GUID D3DCRYPTOTYPE_PROPRIETARY =
    { 0xAB4E9AFD, 0x1D1C, 0x46E6, { 0xA7, 0x2F, 0x08, 0x69, 0x91, 0x7B, 0x0D, 0xE8 } };
EXTERN_C const GUID D3DKEYEXCHANGE_RSAES_OAEP =
    { 0xC1949895, 0xD72A, 0x4A1D, { 0x8E, 0x5D, 0xED, 0x85, 0x7D, 0x17, 0x15, 0x20 } };
EXTERN_C const GUID D3DKEYEXCHANGE_DXVA =
    { 0x43D3775C, 0x38E5, 0x4924, { 0x8D, 0x86, 0xD3, 0xFC, 0xCF, 0x15, 0x3E, 0x9B } };

/* d3d9type.h / d3d9types.h */
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_PROTECTION =
    { 0xA84EB584, 0xC495, 0x48AA, { 0xB9, 0x4D, 0x8B, 0xD2, 0xD6, 0xFB, 0xCE, 0x05 } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_CHANNELTYPE =
    { 0xBC1B18A5, 0xB1FB, 0x42AB, { 0xBD, 0x94, 0xB5, 0x82, 0x8B, 0x4B, 0xF7, 0xBE } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_DEVICEHANDLE =
    { 0xEC1C539D, 0x8CFF, 0x4E2A, { 0xBC, 0xC4, 0xF5, 0x69, 0x2F, 0x99, 0xF4, 0x80 } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_CRYPTOSESSION =
    { 0x2634499E, 0xD018, 0x4D74, { 0xAC, 0x17, 0x7F, 0x72, 0x40, 0x59, 0x52, 0x8D } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_RESTRICTEDSHAREDRESOURCEPROCESSCOUNT =
    { 0x0DB207B3, 0x9450, 0x46A6, { 0x82, 0xDE, 0x1B, 0x96, 0xD4, 0x4F, 0x9C, 0xF2 } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_RESTRICTEDSHAREDRESOURCEPROCESS =
    { 0x649BBADB, 0xF0F4, 0x4639, { 0xA1, 0x5B, 0x24, 0x39, 0x3F, 0xC3, 0xAB, 0xAC } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_UNRESTRICTEDPROTECTEDSHAREDRESOURCECOUNT =
    { 0x012F0BD6, 0xE662, 0x4474, { 0xBE, 0xFD, 0xAA, 0x53, 0xE5, 0x14, 0x3C, 0x6D } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_OUTPUTIDCOUNT =
    { 0x2C042B5E, 0x8C07, 0x46D5, { 0xAA, 0xBE, 0x8F, 0x75, 0xCB, 0xAD, 0x4C, 0x31 } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_OUTPUTID =
    { 0x839DDCA3, 0x9B4E, 0x41E4, { 0xB0, 0x53, 0x89, 0x2B, 0xD2, 0xA1, 0x1E, 0xE7 } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_ACCESSIBILITYATTRIBUTES =
    { 0x6214D9D2, 0x432C, 0x4ABB, { 0x9F, 0xCE, 0x21, 0x6E, 0xEA, 0x26, 0x9E, 0x3B } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_ENCRYPTIONWHENACCESSIBLEGUIDCOUNT =
    { 0xB30F7066, 0x203C, 0x4B07, { 0x93, 0xFC, 0xCE, 0xAA, 0xFD, 0x61, 0x24, 0x1E } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_ENCRYPTIONWHENACCESSIBLEGUID =
    { 0xF83A5958, 0xE986, 0x4BDA, { 0xBE, 0xB0, 0x41, 0x1F, 0x6A, 0x7a, 0x01, 0xB7 } };
EXTERN_C const GUID D3DAUTHENTICATEDQUERY_CURRENTENCRYPTIONWHENACCESSIBLE =
    { 0xEC1791C7, 0xDAD3, 0x4F15, { 0x9E, 0xC3, 0xFA, 0xA9, 0x3D, 0x60, 0xD4, 0xF0 } };
EXTERN_C const GUID D3DAUTHENTICATEDCONFIGURE_INITIALIZE =
    { 0x06114BDB, 0x3523, 0x470A, { 0x8D, 0xCA, 0xFB, 0xC2, 0x84, 0x51, 0x54, 0xF0 } };
EXTERN_C const GUID D3DAUTHENTICATEDCONFIGURE_PROTECTION =
    { 0x50455658, 0x3F47, 0x4362, { 0xBF, 0x99, 0xBF, 0xDF, 0xCD, 0xE9, 0xED, 0x29 } };
EXTERN_C const GUID D3DAUTHENTICATEDCONFIGURE_CRYPTOSESSION =
    { 0x6346CC54, 0x2CFC, 0x4AD4, { 0x82, 0x24, 0xD1, 0x58, 0x37, 0xDE, 0x77, 0x00 } };
EXTERN_C const GUID D3DAUTHENTICATEDCONFIGURE_SHAREDRESOURCE =
    { 0x0772D047, 0x1B40, 0x48E8, { 0x9C, 0xA6, 0xB5, 0xF5, 0x10, 0xDE, 0x9F, 0x01 } };
EXTERN_C const GUID D3DAUTHENTICATEDCONFIGURE_ENCRYPTIONWHENACCESSIBLE =
    { 0x41FFF286, 0x6AE0, 0x4D43, { 0x9D, 0x55, 0xA4, 0x6E, 0x9E, 0xFD, 0x15, 0x8A } };

/* dvp.h */
EXTERN_C const IID  IID_IDDVideoPortContainer =
    { 0x6C142760, 0xA733, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID  IID_IDirectDrawVideoPort =
    { 0xB36D93E0, 0x2B43, 0x11CF, { 0xA2, 0xDE, 0x00, 0xAA, 0x00, 0xB9, 0x33, 0x56 } };
EXTERN_C const IID  IID_IDirectDrawVideoPortNotify =
    { 0xA655FB94, 0x0589, 0x4E57, { 0xB3, 0x33, 0x56, 0x7A, 0x89, 0x46, 0x8C, 0x88 } };

/* dsound.h */
EXTERN_C const CLSID    CLSID_DirectSound =
    { 0x47D4D946, 0x62E8, 0x11CF, { 0x93, 0xBC, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const CLSID    CLSID_DirectSound8 =
    { 0x3901CC3F, 0x84B5, 0x4FA4, { 0xBA, 0x35, 0xAA, 0x81, 0x72, 0xB8, 0xA0, 0x9B } };
EXTERN_C const CLSID    CLSID_DirectSoundCapture =
    { 0xB0210780, 0x89CD, 0x11D0, { 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16 } };
EXTERN_C const CLSID    CLSID_DirectSoundCapture8 =
    { 0xE4BCAC13, 0x7F99, 0x4908, { 0x9A, 0x8E, 0x74, 0xE3, 0xBF, 0x24, 0xB6, 0xE1 } };
EXTERN_C const CLSID    CLSID_DirectSoundFullDuplex =
    { 0xFEA4300C, 0x7959, 0x4147, { 0xB2, 0x6A, 0x23, 0x77, 0xB9, 0xE7, 0xA9, 0x1D } };
EXTERN_C const GUID     DSDEVID_DefaultPlayback =
    { 0xDEF00000, 0x9C6D, 0x47ED, { 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03 } };
EXTERN_C const GUID     DSDEVID_DefaultCapture =
    { 0xDEF00001, 0x9C6D, 0x47ED, { 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03 } };
EXTERN_C const GUID     DSDEVID_DefaultVoicePlayback =
    { 0xDEF00002, 0x9C6D, 0x47ED, { 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03 } };
EXTERN_C const GUID     DSDEVID_DefaultVoiceCapture =
    { 0xDEF00003, 0x9C6D, 0x47ED, { 0xAA, 0xF1, 0x4D, 0xDA, 0x8F, 0x2B, 0x5C, 0x03 } };
EXTERN_C const IID      IID_IDirectSound =
    { 0x279AFA83, 0x4981, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectSound8 =
    { 0xC50A7E93, 0xF395, 0x4834, { 0x9E, 0xF6, 0x7F, 0xA9, 0x9D, 0xE5, 0x09, 0x66 } };
EXTERN_C const IID      IID_IDirectSoundBuffer =
    { 0x279AFA85, 0x4981, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectSoundBuffer8 =
    { 0x6825A449, 0x7524, 0x4D82, { 0x92, 0x0F, 0x50, 0xE3, 0x6A, 0xB3, 0xAB, 0x1E } };
EXTERN_C const IID      IID_IDirectSound3DListener =
    { 0x279AFA84, 0x4981, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectSound3DBuffer =
    { 0x279AFA86, 0x4981, 0x11CE, { 0xA5, 0x21, 0x00, 0x20, 0xAF, 0x0B, 0xE5, 0x60 } };
EXTERN_C const IID      IID_IDirectSoundCapture =
    { 0xB0210781, 0x89CD, 0x11D0, { 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16 } };
EXTERN_C const IID      IID_IDirectSoundCaptureBuffer =
    { 0xB0210782, 0x89CD, 0x11D0, { 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16 } };
EXTERN_C const IID      IID_IDirectSoundCaptureBuffer8 =
    { 0x00990DF4, 0x0DBB, 0x4872, { 0x83, 0x3E, 0x6D, 0x30, 0x3E, 0x80, 0xAE, 0xB6 } };
EXTERN_C const IID      IID_IDirectSoundNotify =
    { 0xB0210783, 0x89CD, 0x11D0, { 0xAF, 0x08, 0x00, 0xA0, 0xC9, 0x25, 0xCD, 0x16 } };
EXTERN_C const IID      IID_IDirectSoundFXGargle =
    { 0xD616F352, 0xD622, 0x11CE, { 0xAA, 0xC5, 0x00, 0x20, 0xAF, 0x0B, 0x99, 0xA3 } };
EXTERN_C const IID      IID_IDirectSoundFXChorus =
    { 0x880842E3, 0x145F, 0x43E6, { 0xA9, 0x34, 0xA7, 0x18, 0x06, 0xE5, 0x05, 0x47 } };
EXTERN_C const IID      IID_IDirectSoundFXFlanger =
    { 0x903E9878, 0x2C92, 0x4072, { 0x9B, 0x2C, 0xEA, 0x68, 0xF5, 0x39, 0x67, 0x83 } };
EXTERN_C const IID      IID_IDirectSoundFXEcho =
    { 0x8BD28EDF, 0x50DB, 0x4E92, { 0xA2, 0xBD, 0x44, 0x54, 0x88, 0xD1, 0xED, 0x42 } };
EXTERN_C const IID      IID_IDirectSoundFXDistortion =
    { 0x8ECF4326, 0x455F, 0x4D8B, { 0xBD, 0xA9, 0x8D, 0x5D, 0x3E, 0x9E, 0x3E, 0x0B } };
EXTERN_C const IID      IID_IDirectSoundFXCompressor =
    { 0x4BBD1154, 0x62F6, 0x4E2C, { 0xA1, 0x5C, 0xD3, 0xB6, 0xC4, 0x17, 0xF7, 0xA0 } };
EXTERN_C const IID      IID_IDirectSoundFXParamEq =
    { 0xC03CA9FE, 0xFE90, 0x4204, { 0x80, 0x78, 0x82, 0x33, 0x4C, 0xD1, 0x77, 0xDA } };
EXTERN_C const IID      IID_IDirectSoundFXI3DL2Reverb =
    { 0x4B166A6A, 0x0D66, 0x43F3, { 0x80, 0xE3, 0xEE, 0x62, 0x80, 0xDE, 0xE1, 0xA4 } };
EXTERN_C const IID      IID_IDirectSoundFXWavesReverb =
    { 0x46858C3A, 0x0DC6, 0x45E3, { 0xB7, 0x60, 0xD4, 0xEE, 0xF1, 0x6C, 0xB3, 0x25 } };
EXTERN_C const IID      IID_IDirectSoundCaptureFXAec =
    { 0xAD74143D, 0x903D, 0x4AB7, { 0x80, 0x66, 0x28, 0xD3, 0x63, 0x03, 0x6D, 0x65 } };
EXTERN_C const IID      IID_IDirectSoundCaptureFXNoiseSuppress =
    { 0xED311E41, 0xFBAE, 0x4175, { 0x96, 0x25, 0xCD, 0x08, 0x54, 0xF6, 0x93, 0xCA } };
EXTERN_C const IID      IID_IDirectSoundFullDuplex =
    { 0xEDCB4C7A, 0xDAAB, 0x4216, { 0xA4, 0x2E, 0x6C, 0x50, 0x59, 0x6D, 0xDC, 0x1D } };
EXTERN_C const GUID     DS3DALG_NO_VIRTUALIZATION =
    { 0xC241333F, 0x1C1B, 0x11D2, { 0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA } };
EXTERN_C const GUID     DS3DALG_HRTF_FULL =
    { 0xC2413340, 0x1C1B, 0x11D2, { 0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA } };
EXTERN_C const GUID     DS3DALG_HRTF_LIGHT =
    { 0xC2413342, 0x1C1B, 0x11D2, { 0x94, 0xF5, 0x00, 0xC0, 0x4F, 0xC2, 0x8A, 0xCA } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_GARGLE =
    { 0xDAFD8210, 0x5711, 0x4B91, { 0x9F, 0xE3, 0xF7, 0x5B, 0x7A, 0xE2, 0x79, 0xBF } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_CHORUS =
    { 0xEFE6629C, 0x81F7, 0x4281, { 0xBD, 0x91, 0xC9, 0xD6, 0x04, 0xA9, 0x5A, 0xF6 } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_FLANGER =
    { 0xEFCA3D92, 0xDFD8, 0x4672, { 0xA6, 0x03, 0x74, 0x20, 0x89, 0x4B, 0xAD, 0x98 } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_ECHO =
    { 0xEF3E932C, 0xD40B, 0x4F51, { 0x8C, 0xCF, 0x3F, 0x98, 0xF1, 0xB2, 0x9D, 0x5D } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_DISTORTION =
    { 0xEF114C90, 0xCD1D, 0x484E, { 0x96, 0xE5, 0x09, 0xCF, 0xAF, 0x91, 0x2A, 0x21 } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_COMPRESSOR =
    { 0xEF011F79, 0x4000, 0x406D, { 0x87, 0xAF, 0xBF, 0xFB, 0x3F, 0xC3, 0x9D, 0x57 } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_PARAMEQ =
    { 0x120CED89, 0x3BF4, 0x4173, { 0xA1, 0x32, 0x3C, 0xB4, 0x06, 0xCF, 0x32, 0x31 } };
EXTERN_C const GUID     GUID_DSFX_STANDARD_I3DL2REVERB =
    { 0xEF985E71, 0xD5C7, 0x42D4, { 0xBA, 0x4D, 0x2D, 0x07, 0x3E, 0x2E, 0x96, 0xF4 } };
EXTERN_C const GUID     GUID_DSFX_WAVES_REVERB =
    { 0x87FC0268, 0x9A55, 0x4360, { 0x95, 0xAA, 0x00, 0x4A, 0x1D, 0x9D, 0xE2, 0x6C } };
EXTERN_C const GUID     GUID_DSCFX_CLASS_AEC =
    { 0xBF963D80, 0xC559, 0x11D0, { 0x8A, 0x2B, 0x00, 0xA0, 0xC9, 0x25, 0x5A, 0xC1 } };
EXTERN_C const GUID     GUID_DSCFX_MS_AEC =
    { 0xCDEBB919, 0x379A, 0x488A, { 0x87, 0x65, 0xF5, 0x3C, 0xFD, 0x36, 0xDE, 0x40 } };
EXTERN_C const GUID     GUID_DSCFX_SYSTEM_AEC =
    { 0x1C22C56D, 0x9879, 0x4F5B, { 0xA3, 0x89, 0x27, 0x99, 0x6D, 0xDC, 0x28, 0x10 } };
EXTERN_C const GUID     GUID_DSCFX_CLASS_NS =
    { 0xE07F903F, 0x62FD, 0x4E60, { 0x8C, 0xDD, 0xDE, 0xA7, 0x23, 0x66, 0x65, 0xB5 } };
EXTERN_C const GUID     GUID_DSCFX_MS_NS =
    { 0x11C5C73B, 0x66E9, 0x4BA1, { 0xA0, 0xBA, 0xE8, 0x14, 0xC6, 0xEE, 0xD9, 0x2D } };
EXTERN_C const GUID     GUID_DSCFX_SYSTEM_NS =
    { 0x5AB0882E, 0x7274, 0x4516, { 0x87, 0x7D, 0x4E, 0xEE, 0x99, 0xBA, 0x4F, 0xD0 } };

/* dinput.h */
EXTERN_C const CLSID    CLSID_DirectInput =
    { 0x25E609E0, 0xB259, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const CLSID    CLSID_DirectInputDevice =
    { 0x25E609E1, 0xB259, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const CLSID    CLSID_DirectInput8 =
    { 0x25E609E4, 0xB259, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const CLSID    CLSID_DirectInputDevice8 =
    { 0x25E609E5, 0xB259, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInputA =
    { 0x89521360, 0xAA8A, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInputW =
    { 0x89521361, 0xAA8A, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInput2A =
    { 0x5944E662, 0xAA8A, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInput2W =
    { 0x5944E663, 0xAA8A, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInput7A =
    { 0x9A4CB684, 0x236D, 0x11D3, { 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE } };
EXTERN_C const IID      IID_IDirectInput7W =
    { 0x9A4CB685, 0x236D, 0x11D3, { 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE } };
EXTERN_C const IID      IID_IDirectInput8A =
    { 0xBF798030, 0x483A, 0x4DA2, { 0xAA, 0x99, 0x5D, 0x64, 0xED, 0x36, 0x97, 0x00 } };
EXTERN_C const IID      IID_IDirectInput8W =
    { 0xBF798031, 0x483A, 0x4DA2, { 0xAA, 0x99, 0x5D, 0x64, 0xED, 0x36, 0x97, 0x00 } };
EXTERN_C const IID      IID_IDirectInputDeviceA =
    { 0x5944E680, 0xC92E, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInputDeviceW =
    { 0x5944E681, 0xC92E, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInputDevice2A =
    { 0x5944E682, 0xC92E, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInputDevice2W =
    { 0x5944E683, 0xC92E, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const IID      IID_IDirectInputDevice7A =
    { 0x57D7C6BC, 0x2356, 0x11D3, { 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE } };
EXTERN_C const IID      IID_IDirectInputDevice7W =
    { 0x57D7C6BD, 0x2356, 0x11D3, { 0x8E, 0x9D, 0x00, 0xC0, 0x4F, 0x68, 0x44, 0xAE } };
EXTERN_C const IID      IID_IDirectInputDevice8A =
    { 0x54D41080, 0xDC15, 0x4833, { 0xA4, 0x1B, 0x74, 0x8F, 0x73, 0xA3, 0x81, 0x79 } };
EXTERN_C const IID      IID_IDirectInputDevice8W =
    { 0x54D41081, 0xDC15, 0x4833, { 0xA4, 0x1B, 0x74, 0x8F, 0x73, 0xA3, 0x81, 0x79 } };
EXTERN_C const IID      IID_IDirectInputEffect =
    { 0xE7E1F7C0, 0x88D2, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_XAxis =
    { 0xA36D02E0, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_YAxis =
    { 0xA36D02E1, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_ZAxis =
    { 0xA36D02E2, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_RxAxis =
    { 0xA36D02F4, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_RyAxis =
    { 0xA36D02F5, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_RzAxis =
    { 0xA36D02E3, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_Slider =
    { 0xA36D02E4, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_Button =
    { 0xA36D02F0, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_Key =
    { 0x55728220, 0xD33C, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_POV =
    { 0xA36D02F2, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_Unknown =
    { 0xA36D02F3, 0xC9F3, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_SysMouse =
    { 0x6F1D2B60, 0xD5A0, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_SysKeyboard =
    { 0x6F1D2B61, 0xD5A0, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_Joystick =
    { 0x6F1D2B70, 0xD5A0, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_SysMouseEm =
    { 0x6F1D2B80, 0xD5A0, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_SysMouseEm2 =
    { 0x6F1D2B81, 0xD5A0, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_SysKeyboardEm =
    { 0x6F1D2B82, 0xD5A0, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_SysKeyboardEm2 =
    { 0x6F1D2B83, 0xD5A0, 0x11CF, { 0xBF, 0xC7, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00 } };
EXTERN_C const GUID     GUID_ConstantForce =
    { 0x13541C20, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_RampForce =
    { 0x13541C21, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_Square =
    { 0x13541C22, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_Sine =
    { 0x13541C23, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_Triangle =
    { 0x13541C24, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_SawtoothUp =
    { 0x13541C25, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_SawtoothDown =
    { 0x13541C26, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_Spring =
    { 0x13541C27, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_Damper =
    { 0x13541C28, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_Inertia =
    { 0x13541C29, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_Friction =
    { 0x13541C2A, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
EXTERN_C const GUID     GUID_CustomForce =
    { 0x13541C2B, 0x8E33, 0x11D0, { 0x9A, 0xD0, 0x00, 0xA0, 0xC9, 0xA0, 0x6E, 0x35 } };
