/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  VI events definition
*
****************************************************************************/


// add another chunk of 128 - to support       foreign characters
// 0x0081-0x00ff - characters
// 0x0100-0x017f - function keys etc.

/*                                                            non-modeless                          non-modeless bits                   modeless bits (events MISC & INS   */
/*          enum                 modeless             insert             command                    (no restrictions)                   ONLY unless matches non-ml event)  */
/*       /------------\       /------------------\ /--------------------------------------------\ /---------------------------------\ /----------------------------------\ */
/*            enum                  modeless             insert               command                   nm_bits                             bits                           */
vi_pick( VI_KEY( NULL ),         InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_A ),       SelectAll,           InvalidKey,           LineInfo,                BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_B ),       InvalidKey,          InvalidKey,           MovePageUp,              BITS(EVENT_MISC,     0, 0, 0, 0, 1, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_C ),       AddSelRgnToSavebuf,  InvalidKey,           AddSelRgnToSavebuf,      BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_D ),       DoUndoUndo,          IMTabs,               MoveHalfPageDown,        BITS(EVENT_MISC,     0, 0, 0, 0, 1, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_E ),       InvalidKey,          IMCursorKey,          MoveScreenDown,          BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F ),       FancyDoFindMisc,     InvalidKey,           MovePageDown,            BITS(EVENT_MISC,     0, 0, 0, 0, 1, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_G ),       InvalidKey,          InvalidKey,           DisplayFileStatus,       BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_H ),       InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_I ),       InvalidKey,          IMTabs,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_J ),       InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_K ),       FancyProcessCommandLine, InvalidKey,       FancyProcessCommandLine, BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_L ),       ReDisplayScreen,     InvalidKey,           ReDisplayScreen,         BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_M ),       InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_N ),       DoNextFindForwardMisc, InvalidKey,         MoveDown,                BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_O ),       DoMatching,          InvalidKey,           DoMatching,              BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_P ),       InvalidKey,          InvalidKey,           MoveUp,                  BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_Q ),       InvalidKey,          IMEscapeNextChar,     InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_R ),       FancyDoReplace,      IMCursorKey,          ReselectRegion,          BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_S ),       DoKeyboardSave,      IMMenuKey,            DoKeyboardSave,          BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_T ),       InvalidKey,          IMTabs,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_U ),       DoNextFindBackwardsMisc, InvalidKey,       MoveHalfPageUp,          BITS(EVENT_MISC,     0, 0, 0, 0, 1, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_V ),       InsertSavebufBefore2,IMEscapeNextChar,     DoVersion,               BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_W ),       InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_X ),       AddSelRgnToSavebufAndDelete, InvalidKey,   PrintHexValue,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_Y ),       InvalidKey,          IMCursorKey,          MoveScreenUp,            BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_Z ),       DoUndo,              InvalidKey,           DoVersion,               BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_OSB ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 28 ),           InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_CSB ),     InvalidKey,          InvalidKey,           GetCurrentTag,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 30 ),           InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 31 ),           InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SPACE ),        IMSpace,             IMSpace,              MoveRight,               BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 1, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( EXCLAMATION ),  IMChar,              IMChar,               Filter,                  BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( DQUOTE ),       IMChar,              IMChar,               DoSavebufNumber,         BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( HASH ),         IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( DOLLAR ),       IMChar,              IMChar,               MoveLineEnd,             BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( PERCENT ),      IMChar,              IMChar,               DoMatching,              BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( AMPERSAND ),    IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( QUOTE ),        IMChar,              IMChar,               GoMarkLine,              BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( OPARENTH ),     IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CPARENTH ),     IMCloseBracket,      IMCloseBracket,       InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( STAR ),         IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( PLUS ),         IMChar,              IMChar,               MoveStartNextLine,       BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( COMMA ),        IMChar,              IMChar,               MoveToLastCharFindRev,   BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( MINUS ),        IMChar,              IMChar,               MoveStartPrevLine,       BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( DOT ),          IMChar,              IMChar,               DoDotMode,               BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SLASH ),        IMChar,              IMChar,               DoFindForward,           BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 0 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 1 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 2 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 3 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 4 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 5 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 6 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 7 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 8 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 9 ),            IMChar,              IMChar,               DoDigit,                 BITS(EVENT_MISC,     0, 1, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( COLON ),        IMChar,              IMChar,               ProcessCommandLine,      BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SEMICOLON ),    IMChar,              IMChar,               MoveToLastCharFind,      BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( LESS ),         IMChar,              IMChar,               StartSuck,               BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( EQUALS ),       IMChar,              IMChar,               DoAltDotMode,            BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( GREATER ),      IMChar,              IMChar,               StartShove,              BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( QUESTIONMARK ), IMChar,              IMChar,               DoFindBackwards,         BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( AT ),           IMChar,              IMChar,               ExecuteBuffer,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( A ),            IMChar,              IMChar,               InsertTextAtLineEnd,     BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( B ),            IMChar,              IMChar,               MoveBackwardsBigWord,    BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( C ),            IMChar,              IMChar,               DoChangeLineEnd,         BITS(EVENT_OP,       0, 0, 0, 1, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( D ),            IMChar,              IMChar,               DoDeleteLineEnd,         BITS(EVENT_OP,       0, 0, 0, 1, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( E ),            IMChar,              IMChar,               MoveForwardBigWordEnd,   BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F ),            IMChar,              IMChar,               MoveBackToChar,          BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( G ),            IMChar,              IMChar,               DoGo,                    BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( H ),            IMChar,              IMChar,               MovePageTop,             BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( I ),            IMChar,              IMChar,               InsertTextAtLineStart,   BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( J ),            IMChar,              IMChar,               JoinCurrentLineToNext,   BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( K ),            IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( L ),            IMChar,              IMChar,               MovePageBottom,          BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( M ),            IMChar,              IMChar,               MovePageMiddle,          BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( N ),            IMChar,              IMChar,               DoNextFindBackwards,     BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( O ),            IMChar,              IMChar,               InsertTextOnPreviousLine,BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( P ),            IMChar,              IMChar,               InsertSavebufBefore,     BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
#ifdef __WIN__
vi_pick( VI_KEY( Q ),            IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
#else
vi_pick( VI_KEY( Q ),            IMChar,              IMChar,               EnterExMode,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
#endif
vi_pick( VI_KEY( R ),            IMChar,              IMChar,               DoReplaceText,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( S ),            IMChar,              IMChar,               DoLineSubstitute,        BITS(EVENT_OP,       0, 0, 0, 1, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( T ),            IMChar,              IMChar,               MoveBackToAfterChar,     BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( U ),            IMChar,              IMChar,               DoUndoUndo,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( V ),            IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( W ),            IMChar,              IMChar,               MoveForwardBigWord,      BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( X ),            IMChar,              IMChar,               DoDeleteCharBeforeCursor,BITS(EVENT_OP,       1, 0, 0, 1, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( Y ),            IMChar,              IMChar,               YankLines,               BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( Z ),            IMChar,              IMChar,               StartSaveExit,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( OSBRACKET ),    IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( BACKSLASH ),    IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CSBRACKET ),    IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CARET ),        IMChar,              IMChar,               MoveStartOfLine,         BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( _ ),            IMChar,              IMChar,               DoSelectSelectionPopMenu,BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( GRAVE ),        IMChar,              IMChar,               GoMark,                  BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( a ),            IMChar,              IMChar,               InsertTextAfterCursor,   BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( b ),            IMChar,              IMChar,               MoveBackwardsWord,       BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( c ),            IMChar,              IMChar,               Change,                  BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( d ),            IMChar,              IMChar,               Delete,                  BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( e ),            IMChar,              IMChar,               MoveForwardWordEnd,      BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( f ),            IMChar,              IMChar,               MoveUpToChar,            BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( g ),            IMChar,              IMChar,               InsertLikeLast,          BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( h ),            IMChar,              IMChar,               MoveLeft,                BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 1, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( i ),            IMChar,              IMChar,               InsertTextAtCursor,      BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( j ),            IMChar,              IMChar,               MoveDown,                BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 1, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( k ),            IMChar,              IMChar,               MoveUp,                  BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 1, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( l ),            IMChar,              IMChar,               MoveRight,               BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 1, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( m ),            IMChar,              IMChar,               SetMark,                 BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( n ),            IMChar,              IMChar,               DoNextFindForward,       BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( o ),            IMChar,              IMChar,               InsertTextOnNextLine,    BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( p ),            IMChar,              IMChar,               InsertSavebufAfter,      BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( q ),            IMChar,              IMChar,               SetSelectedRegion,       BITS(EVENT_OP,       1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( r ),            IMChar,              IMChar,               ReplaceChar,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( s ),            IMChar,              IMChar,               DoSubstitute,            BITS(EVENT_OP,       0, 0, 0, 1, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( t ),            IMChar,              IMChar,               MoveUpToBeforeChar,      BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( u ),            IMChar,              IMChar,               DoUndo,                  BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( v ),            IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( w ),            IMChar,              IMChar,               MoveForwardWord,         BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( x ),            IMChar,              IMChar,               DoDeleteCharAtCursor,    BITS(EVENT_OP,       1, 0, 0, 1, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( y ),            IMChar,              IMChar,               Yank,                    BITS(EVENT_OP,       1, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( z ),            IMChar,              IMChar,               MovePosition,            BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( OCBRACKET ),    IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( VBAR ),         IMChar,              IMChar,               MoveToColumn,            BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CCBRACKET ),    IMCloseBrace,        IMCloseBrace,         InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( TILDE ),        IMChar,              IMChar,               ChangeCase,              BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 127 ),          IMChar,              InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )

/*
 *  0x80 - 0xFF  extended (foreign) characters
 */
vi_pick( VI_KEY( 128 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 129 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 130 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 131 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 132 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 133 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 134 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 135 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 136 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 137 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 138 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 139 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 140 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 141 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 142 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 143 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 144 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 145 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 146 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 147 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 148 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 149 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 150 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 151 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 152 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 153 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 154 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 155 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 156 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 157 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 158 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 159 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 160 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 161 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 162 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 163 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 164 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 165 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 166 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 167 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 168 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 169 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 170 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 171 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 172 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 173 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 174 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 175 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 176 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 177 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 178 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 179 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 180 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 181 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 182 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 183 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 184 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 185 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 186 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 187 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 188 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 189 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 190 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 191 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 192 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 193 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 194 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 195 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 196 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 197 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 198 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 199 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 200 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 201 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 202 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 203 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 204 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 205 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 206 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 207 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 208 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 209 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 210 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 211 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 212 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 213 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 214 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 215 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 216 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 217 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 218 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 219 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 220 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 221 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 222 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 223 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 224 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 225 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 226 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 227 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 228 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 229 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 230 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 231 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 232 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 233 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 234 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 235 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 236 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 237 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 238 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 239 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 240 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 241 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 242 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 243 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 244 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 245 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 246 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 247 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 248 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 249 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 250 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 251 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 252 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 253 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 254 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( 255 ),          IMChar,              IMChar,               InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )

/*
 * now the special function keys
 */
#ifdef __WIN__
vi_pick( VI_KEY( F1 ),           DoHelpOnContext,     InvalidKey,           DoHelpOnContext,         BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#else
vi_pick( VI_KEY( F1 ),           DoHelpOnContext,     InvalidKey,           RotateFileForward,       BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#endif
vi_pick( VI_KEY( F2 ),           RotateFileBackwards, InvalidKey,           RotateFileBackwards,     BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F3 ),           DoNextFindForwardMisc, InvalidKey,         InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F4 ),           InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F5 ),           FancyGotoLine,       InvalidKey,           FancyGotoLine,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F6 ),           RotateFileForward,   InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#ifdef __WIN__    // hotkeys
vi_pick( VI_KEY( F7 ),           ToggleColorbar,      InvalidKey,           ToggleColorbar,          BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F8 ),           ToggleFontbar,       InvalidKey,           ToggleFontbar,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F9 ),           ToggleSSbar,         InvalidKey,           ToggleSSbar,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#else
vi_pick( VI_KEY( F7 ),           InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F8 ),           InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F9 ),           InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#endif           // end hotkeys
vi_pick( VI_KEY( F10 ),          InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( UP ),           MoveUp,              IMCursorKey,          MoveUp,                  BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 1, 0), BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( DOWN ),         MoveDown,            IMCursorKey,          MoveDown,                BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 1, 0), BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( LEFT ),         MoveLeft,            IMCursorKey,          MoveLeft,                BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 1, 0), BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0) )
vi_pick( VI_KEY( RIGHT ),        MoveRight,           IMCursorKey,          MoveRight,               BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 1, 0), BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0) )
vi_pick( VI_KEY( PAGEUP ),       MovePageUp,          IMCursorKey,          MovePageUp,              BITS(EVENT_MISC,     0, 0, 0, 0, 1, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( PAGEDOWN ),     MovePageDown,        IMCursorKey,          MovePageDown,            BITS(EVENT_MISC,     0, 0, 0, 0, 1, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( INS ),          IMInsert,            IMInsert,             InsertTextAtCursor,      BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( DEL ),          IMDeleteML,          IMDelete,             DoDeleteCharAtCursor,    BITS(EVENT_OP,       1, 0, 0, 1, 0, 1), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( BS ),           IMBackSpaceML,       IMBackSpace,          MoveLeft,                BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_TAB ),    IMTabs,              IMTabs,               MoveShiftTab,            BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ENTER ),        IMEnter,             IMEnter,              MoveStartNextLine,       BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( TAB ),          IMTabs,              IMTabs,               MoveTab,                 BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_INS,      1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( HOME ),         MoveLineBegin,       IMCursorKey,          MoveLineBegin,           BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( END ),          MoveLineEnd,         IMCursorKey,          MoveLineEnd,             BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_REL_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ESC ),          InvalidKey,          IMEsc,                NullResponse,            BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F1 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#ifdef __WIN__
vi_pick( VI_KEY( SHIFT_F2 ),     ToggleToolbar,       InvalidKey,           ToggleToolbar,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F3 ),     ToggleStatusbar,     InvalidKey,           ToggleStatusbar,         BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F4 ),     FancyDoReplace,      InvalidKey,           FancyDoReplace,          BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F5 ),     DoNextFindForwardMisc, InvalidKey,         DoNextFindForwardMisc,   BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F6 ),     RotateFileBackwards, InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F7 ),     DoNextFindBackwardsMisc, InvalidKey,       DoNextFindBackwardsMisc, BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#else
vi_pick( VI_KEY( SHIFT_F2 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F3 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F4 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F5 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F6 ),     RotateFileBackwards, InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F7 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#endif
vi_pick( VI_KEY( SHIFT_F8 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F9 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F10 ),    InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F1 ),       InvalidKey,          InvalidKey,           Change,                  BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F2 ),       InvalidKey,          InvalidKey,           Delete,                  BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#ifdef __WIN__
vi_pick( VI_KEY( CS_LEFT ),      SelectBackwardsWord, InvalidKey,           SelectBackwardsWord,     BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CS_RIGHT ),     SelectForwardWord,   InvalidKey,           SelectForwardWord,       BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CS_UP ),        InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CS_DOWN ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CS_PAGEUP ),    SelectTopOfPage,     InvalidKey,           SelectTopOfPage,         BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CS_PAGEDOWN ),  SelectBottomOfPage,  InvalidKey,           SelectBottomOfPage,      BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CS_HOME ),      SelectStartOfFile,   InvalidKey,           SelectStartOfFile,       BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CS_END ),       SelectEndOfFile,     InvalidKey,           SelectEndOfFile,         BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0) )
#else
vi_pick( VI_KEY( ALT_F3 ),       InvalidKey,          InvalidKey,           Yank,                    BITS(EVENT_OP,       1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F4 ),       InvalidKey,          InvalidKey,           ChangeCase,              BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F5 ),       InvalidKey,          InvalidKey,           Filter,                  BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F6 ),       InvalidKey,          InvalidKey,           StartSuck,               BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F7 ),       InvalidKey,          InvalidKey,           StartShove,              BITS(EVENT_OP,       1, 0, 0, 0, 0, 1), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F8 ),       InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F9 ),       InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F10 ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#endif
vi_pick( VI_KEY( CTRL_F1 ),      InvalidKey,          InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#ifdef __WIN__
vi_pick( VI_KEY( CTRL_F2 ),      DoFindForward,       InvalidKey,           DoFindForward,           BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0) )
#else
vi_pick( VI_KEY( CTRL_F2 ),      DoFindForward,       InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 1, 0, 0, 0, 0, 0) )
#endif
vi_pick( VI_KEY( CTRL_F3 ),      InvalidKey,          InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F4 ),      CurFileExitOptionSaveChanges,InvalidKey,   SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F5 ),      InvalidKey,          InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F6 ),      RotateFileForward,   InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F7 ),      InvalidKey,          InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#ifdef __WIN__
vi_pick( VI_KEY( CTRL_F8 ),      FancySetGen,         InvalidKey,           FancySetGen,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F9 ),      FancySetScr,         InvalidKey,           FancySetScr,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F10 ),     FancySetFS,          InvalidKey,           FancySetFS,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#else
vi_pick( VI_KEY( CTRL_F8 ),      FancySetGen,         InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F9 ),      FancySetScr,         InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F10 ),     FancySetFS,          InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
#endif
vi_pick( VI_KEY( ALT_A ),        InvalidKey,          IMMenuKey,            HeapCheck,               BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_B ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_C ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_D ),        InvalidKey,          IMMenuKey,            FcbThreadDump,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_E ),        InvalidKey,          IMMenuKey,            FcbDump,                 BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_G ),        DoWindowGadgetMenu,  IMMenuKey,            DoWindowGadgetMenu,      BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_H ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_I ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_J ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_K ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_L ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_M ),        InvalidKey,          IMMenuKey,            DumpMemory,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_N ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_O ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_P ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_Q ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_R ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_S ),        InvalidKey,          IMMenuKey,            SanityCheck,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_T ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_U ),        InvalidKey,          IMMenuKey,            WalkUndo,                BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_V ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_W ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_X ),        InvalidKey,          IMMenuKey,            EnterHexKey,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_Y ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_Z ),        InvalidKey,          IMMenuKey,            InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F11 ),          InvalidKey,          InvalidKey,           PushFileStackAndMsg,     BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( F12 ),          InvalidKey,          InvalidKey,           PopFileStack,            BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F11 ),    InvalidKey,          InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_F12 ),    InvalidKey,          InvalidKey,           SwitchSavebuf,           BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F11 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_F12 ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F11 ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_F12 ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_END ),     MoveEndOfFile,       InvalidKey,           MoveEndOfFile,           BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_DEL ),     DeleteLines,         IMCursorKey,          DeleteLines,             BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_INS ),     AddSelRgnToSavebuf,  IMCursorKey,          AddSelRgnToSavebuf,      BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_HOME ),    MoveStartOfFile,     InvalidKey,           MoveStartOfFile,         BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_PAGEUP ),  MoveTopOfPage,       IMCursorKey,          MoveTopOfPage,           BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_PAGEDOWN ),MoveBottomOfPage,    IMCursorKey,          MoveBottomOfPage,        BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0), BITS(EVENT_ABS_MOVE, 0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_LEFT ),    MoveBackwardsWord,   InvalidKey,           MoveBackwardsWord,       BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0), BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_RIGHT ),   MoveForwardWord,     InvalidKey,           MoveForwardWord,         BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0), BITS(EVENT_REL_MOVE, 0, 0, 1, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_UP ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_DOWN ),    InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_END ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_DEL ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_INS ),      DoUndoUndo,          IMChar,               DoUndoUndo,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_HOME ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_PAGEUP ),   InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_PAGEDOWN ), InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_LEFT ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_RIGHT ),    InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_UP ),       InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_DOWN ),     InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_TAB ),     RotateFileForward,   InvalidKey,           RotateFileForward,       BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_TAB ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( MOUSEEVENT ),   HandleMouseEvent,    IMMouseEvent,         HandleMouseEvent,        BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_UP ),     SelectUp,            IMCursorKey,          SelectUp,                BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_DOWN ),   SelectDown,          IMCursorKey,          SelectDown,              BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_LEFT ),   SelectLeft,          IMCursorKey,          SelectLeft,              BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_RIGHT ),  SelectRight,         IMCursorKey,          SelectRight,             BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0), BITS(EVENT_REL_MOVE, 1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_DEL ),    DoDeleteRegion,      InvalidKey,           DoDeleteRegion,          BITS(EVENT_OP,       1, 0, 0, 1, 0, 1), BITS(EVENT_OP,       1, 0, 0, 1, 0, 1) )
vi_pick( VI_KEY( SHIFT_INS ),    InsertSavebufBefore2,InvalidKey,           InsertSavebufBefore2,    BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_HOME ),   SelectHome,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_END ),    SelectEnd,           InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_PAGEUP ), SelectPageUp,        InvalidKey,           SelectPageUp,            BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( SHIFT_PAGEDOWN ),SelectPageDown,     InvalidKey,           SelectPageDown,          BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( FAKEMOUSE ),    InvalidKey,          InvalidKey,           AbsoluteNullResponse,    BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( IDLE ),         InvalidKey,          AbsoluteNullResponse, AbsoluteNullResponse,    BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     1, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_BS ),       DoUndo,              IMChar,               DoUndo,                  BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( CTRL_BS ),      InvalidKey,          InvalidKey,           InvalidKey,              BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( ALT_HYPHEN ),   DoWindowGadgetMenu,  IMMenuKey,            DoWindowGadgetMenu,      BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
vi_pick( VI_KEY( DUMMY ),        AbsoluteNullResponse,AbsoluteNullResponse, AbsoluteNullResponse,    BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0), BITS(EVENT_MISC,     0, 0, 0, 0, 0, 0) )
