/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#include <windows.h>
#include "wdeglbl.h"
#include "wdemain.h"
#include "wdewait.h"

/****************************************************************************/
/* macro definitions                                                        */
/****************************************************************************/

/****************************************************************************/
/* type definitions                                                         */
/****************************************************************************/

/****************************************************************************/
/* external function prototypes                                             */
/****************************************************************************/

/****************************************************************************/
/* static function prototypes                                               */
/****************************************************************************/

/****************************************************************************/
/* static variables                                                         */
/****************************************************************************/

void WdeSetWaitCursor ( Bool on )
{
    static int      ref_count   = 0;
    static HCURSOR  wait_cursor = NULL;
    static HCURSOR  save_cursor = NULL;
    HWND            main;

    if ( wait_cursor == (HCURSOR) NULL ) {
        wait_cursor = LoadCursor ( (HWND)NULL, IDC_WAIT );
    }

    main = WdeGetMainWindowHandle();

    if ( on && !ref_count ) {
        SetCapture ( main );
        save_cursor = SetCursor ( wait_cursor );
    } else if ( on ) {
        SetCapture ( main );
        SetCursor ( wait_cursor );
    } else if ( !on && ( ref_count == 1 ) ) {
        SetCursor ( save_cursor );
        ReleaseCapture ();
    }

    if ( on ) {
        ref_count++;
    } else {
        if ( ref_count ) {
            ref_count--;
        }
    }
}

