.* Pictures follow this informal code for naming:
.*
.*  BR<name>
.*  ^
.*  |
.*  |
.*  +---- 2 letter constant meaning Browser
.*
:set symbol='wbrname'   value='Open Watcom Browser'
:set symbol='brname'    value='browser'
:set symbol='wbrcmd'    value='wbr'
:set symbol='wbrcmdup'  value='WBR'
:set symbol='wbrwarnd'  value='-w'
:set symbol='wbrfile'   value='.WBR file'
:set symbol='mbrfile'   value='.MBR file'
.*
:set symbol='vmakenm' value='Open Watcom Visual Make'
.*
:set symbol='compname'  value='Open Watcom C/C++ Compiler'
:set symbol='compcmd'   value='wcc'
:set symbol='compcmdup' value='WCC'
:set symbol='genbrflag' value='-B??'
.*
:set symbol='edname'    value='Open Watcom Editor'
:set symbol='edcmd' value='vi'
:set symbol='edcmdup'   value='VI'
.*
.chap The &wbrname
.*
.section Introduction
.*
.np
In the course of developing software, a programmer will typically define and
use thousands of symbols representing variables, functions, and types. spread
amongst many source files.  Given this situation, the &wbrname has two
overlapping purposes:
.*
.begbull
.bull
To speed up a developer's navigation through symbol definitions and usage.
.bull
To assist a developer in understanding the structure of the software.
.endbull
.*
.np
The &brname cooperates with the &edname, the &compname, and the &vmakenm to
achieve these goals.  For example, a programmer editing a file can highlight a
word in the text, and the &brname will create a detail window describing that
symbol. The detail window can be used as a starting point to find out more
about the symbol, or the browser can direct the editor to load and position a
file to the point at which the symbol is defined and/or referenced.
Alternatively, the developer can work with the &brname directly; various
filters and pattern matching tools can be used to build queries for finding
symbols and creating reports on an application-wide basis.
.*
.np
To further assist the developer, the &brname can display class hierarchies,
function call trees, and nested structure types.  Hypertext style symbol
information simplifies the investigation relationships between symbols; any
time the browser displays the name of a user defined symbol, that name can be
used as the starting point for another query. Fast access to project
information can be set up easily, since any information that the &brname
displays can be kept on-screen or minimized for reference.
.*
.section General Concepts
.*
.np
&wbrname is a source code browser.  This means that all of its information is
generated by the compiler as it processes source code.  Although this
information has much in common with debugging information, it is structured
to support navigation through source files, without the presence of an
executable program. While this static view provides much useful
information, dynamic information that would be available to a debugger is
beyond this product's scope.  Information not available includes:
.*
.begbull
.bull
the current execution point of a running program, and the path that was
taken to get there.
.bull
the values of variables
.endbull
.*
Information that is available includes:
.*
.begbull
.bull
all variables, types, macros, functions, labels defined or declared in an application.
.bull
the source file location of the definition and declaration of those symbols.
.bull
the type of any function or variable.
.bull
all calls of any function (except where the call is through a function pointer).
.bull
all variables that are of a given type (including function parameters).
.bull
all symbols visible in a given scope.
.bull
all structures that contain a given type.
.bull
all functions that use a given variable, macro, or function.
.bull
all goto points for a given label.
.bull
all catches (exception handlers) that have been defined for a given type (or for it's base types).
(not implemented)
.bull
all throws (exception raisers) that may throw an exception of a given type.
(not implemented)
.bull
all data members, member functions, friends, base classes and derived
classes of a given class/struct/union
.bull
the recursive decomposition of any derived type into its component types
.bull
the possible values that have been defined for an enumeration type.
.bull
the definition of a given macro.
.bull
the relationship between class and function templates and their instantiations.
(not implemented)
.endbull
.*
.np
The database of symbol information to support these facilities is generated
by the &compname as it compiles the source and headers into object files.
These module browse files can be loaded and unloaded  from a browse session.
This allows for browsing symbols that are not currently part of the project
(such as an external class library), and for the disabling of modules in the
project that are not currently of interest.
.*
.np
The collection of module browse files for a given browse session may be saved
in a '.wbr' (Watcom BRowse) project file.  This file contains a
references to each of the pertinent '.mbr' (Module BRowse) files.  Project
browse files may be used to create different sub-views of the project, each
composed of a different set of modules.
.*
.section Operating System Considerations
.*
.np
Release 1.0 of &wbrname is supported only under Microsoft Windows version 3.1 or
later. However, any &compname can produce the appropriate format of
data for browsing by the Windows hosted browser.  Future versions are planned
for all environments that these compilers support.
.*
.*
.section &brname Command Line Format
.*
.np
:I1.&brname command line:I2.format
The formal &brname command line syntax is shown below.
:I1.&wbrcmdup command line:I2.invoking &wbrcmdup
:I1.command line format:I2.&wbrcmdup
.mbigbox
&wbrcmdup [options] [file]
.embigbox
.begpoint
.point options
is a list of valid &brname options, each preceded by a slash
("/") or a dash ("&minus."). Options may be specified in any order.
Currently, only one option has been defined:
.*
.begpoint $break $compact
:opt name='&wbrwarnd'.=<duplicate_warning>
enable warning messages regarding duplicate definitions of global symbols.
This comes into affect when loading symbols from a &mbrfile, and definitions
are encounter for symbols that already have definitions.  The new definitions
are discarded regardless of the state of this flag.
.*
.endpoint
.*
.*
.point file
is the path and name of the '.wbr' project browse file.
.endpoint
.*
.section Getting Started
.*
.np
&wbrname release 1.0 must be initiated from within Microsoft Windows 3.x.
.*
.np
Startup can be be done in two ways, resulting in two different operating
modes.  One alternative is to start and configure the browser directly.  The
other alternative is to rely upon &vmakenm to start and configure the &brname for
the current project target.
.*
.np
In either mode, &brname will present itself in the upper left of the screen as
shown in
:figref refid='brstart'..
See section(File/Modules) for a
description of loading manually generated modules into the browser session.

:fig id='brstart' frame=box place=inline.
:graphic depth='0.5i'
    file='brstart.eps'
:figcap.&brname Startup Screen
:efig.
.*
.*
.beglevel
.section Standalone Mode
.*
.np
In this mode, the developer must use the &compname directly to build browse
files for modules of interest, and must use browser menus to explicitly load
them into the browser's list of modules.
.*
.np
In order to browse a piece of source code, it must first be compiled by the
&compname, using the &genbrflag (generate browse info) flag:
.*
.millust begin
&compcmdup &genbrflag [<browse_file>] [<other flags>] <source_file>
.millust end
.*
.np
This will result in the compiler generating a &mbrfile containing all of
the symbols encountered in the source file and in its included files.  It
will have the name of the <browse_file> argument, if supplied;
otherwise, it will have the same base name as the target object file, with an
".mbr" suffix.
.*
.np
Any number of modules may compiled this way for future browsing. However, be
aware that the browser acts like a linker, in that it will discard any
conflicting or redundant definitions of global symbols. Normally this is not
an issue, since the modules of an application must meet this condition
anyway.  It may be a problem if &mbrfiles are generated from some external
source that contains conflicting global symbol names.  In this case, only the
first version of the symbol definition loaded into the browser will be kept
(see section(Command Line Format)).
.*
.np
Once the desired '.mbr' files have been generated, they must be loaded into an
active browse session.
.*
.np
&brname may be started up with no command line arguments (see section(Command
Line Format)). For convenient access within windowed environments, &brname
should be set up as a window manager icon. (Refer to the documentation for
your window system, Eg: Microsoft Window Manager.).
.*
.np
Once the browser is running, the compiler-generated &mbrfile.s must be loaded
into the browse session, using the 'edit project' dialog, accessed from the
file/modules menu item (see section(File/Modules) for more details).
.*
.np
.bi Note:
In standalone mode, &brname will attempt to start up the &edname to display
source file definitions of symbols. In order for this to succeed, the &edname
must be in the current search path.
.*
.section Slave Mode
.*
.np
In this mode, &vmakenm automatically compiles modules with the proper flag for
generating &mbrfile.s as it attempts to build a target (see chapter
(&vmakenm.(?))). When a browse query originates from &vmakenm or from one of
it's slave editor sessions, &vmakenm will start &brname (if it is not
already running as a slave) and load it with the list of the &mbrfile.s for
the current target, then finally passing on the query.
.*
.np
For further details on the use of &vmakenm and its relationship the with
the compiler, editor and browser, see chapter (&vmakenm.(?))

.*
.np
When &brname is first started up by &vmakenm, it will be minimized.  Although
the results of &edname queries will be displayed in independent windows, the
&wbrname icon must first be restored if access to the menu bar is desired.
.*
.endlevel
.*
.section General Interaction
.*
.np
&brname follows the conventions of the Common User Access(?) specification for
user interactions.  However, it has a few unusual features that tend to
recur within its user interface.  These features are generally intended to
facilitate arbitrary browse paths and quick reference, while co-existing
with an integrated development environment.
.*
.beglevel
.section Popup Children Windows
.*
.np
The most obvious of these features is that all of the &brname windows are free
floating windows, not contained within a parent window. This allows arbitrary
details of project symbol data to be displayed where convenient, or to be
minimized for fast access.
.*
.np
The main window and its menu bar will always be present (though it may be
minimized).  All other windows generated in the course of a browse session
may be sized, minimized, maximized, and moved independently of the main
window, with the following considerations:
.*
.begbull
.bull
all &brname windows will always appear in front of the main window.
.bull
all &brname windows (apart from the main window) are peers of each other, and
may appear in front or behind of each other, depending on order of creation
and current focus.
.bull
if the main window is minimized, all windows created while it was displayed
will also be minimized.  If any of these windows are already minimized, its
icon will disappear until the main window icon is restored.
.bull
editor queries may result in the creation of &brname windows while the main
window is already minimized.
.endbull
.*
.section PushPin Windows
.*
.np
Many of the &brname windows are pushpin windows.  These may be recognized by the
pushpin button visible on the left end of the window's title bar.  The
purpose of the push pin is to provide some degree of window-to-window
coordination, to avoid the disorganization that might otherwise occur with
many independent windows.
.*
.np
A pushpin window is either 'pinned' to another window, or it is unattached.
This is indicated by the icon on the pushpin button;  see
:figref refid='pushicon'..
.*
.np
If a window is pinned to another window, it may be considered 'owned' by
 that other window.  In this state:
.begbull
.bull
if the owner is closed, the pushpin window will also close.
.bull
if the owner is minimized, the pushpin window will be minimized (into the
owner's icon); when the owner is restored, the pushpin window will also be
restored
.bull
if the owner is moved, the pushpin window will follow it
.bull
if the owner is resized on a side adjacent to the pushpin window, the
pushpin window will follow that side
.bull
the pushpin window may be moved independently of its owner.  The pushpin
window will still follow it's owner from its new relative location (FIXME -
currently, a pushpin window does not follow if it is broken away)
.bull
if the pushpin window is brought to within a few pixels of the right or
lower side of the owner, it will snap up against the owner's side.
.bull
if the pushpin window provides the detail view of the currently selected
item in a list box of the owner, its contents will change as the list box
selection changes. (It's layout may also change to accomodate the type
of item currently selected.)
.endbull
.*
.np
If the pushpin button on the owned pushpin window is pressed, the appearance
of the button will change as shown in
:figref refid='pushicon'.,
and the pushpin
window becomes an independent pushpin window.  This will also happen if the
pushpin window is minimized directly through its minimize control.  As an
additional visual cue, the pushpin window will move slightly away from its
previous owner.
.*
:fig id='pushicon' frame=box place=inline.
:graphic depth='0.5i'
    file='pushicon.eps'
:figcap.PushPin Button States
:efig.
.*
.np
As an independent pushpin window, it will no longer track any other window.
However, it may be moved over top of another window, and 'pinned' with its
pushpin button to the new window, establishing a new tracking relationship.
.*
.np
Frequently, a pushpin window is created through the activation of a checkbox
control.  In these cases, the association between the pushpin window and the
control is maintained:
.begbull
.bull
The checkbox will be unchecked if the pushpin window is closed while it is
still pinned to the checkbox's window.
.bull
If the pushpin window is unpinned from the checkbox's window, the checkbox
will either be unchecked, or a new pinned pushpin window will be created and
pinned to the checkbox's window.
.endbull

.np
If the escape key is pressed while a pushpin window has the focus, that
window will close.
.*
.section Symbol Detail Views
.*
.np
Anytime more information than the name of a symbol is needed, that information
will be displayed in a symbol detail view.  There are various detail
views, but they all have a few attributes in common. Specialized detail views
build upon that base, adding on information and controls in order to give
a complete picture of a particular symbol type.
.*
.np
The next section describes the characteristics that all symbol detail views
have in common; that is followed by descriptions of the extended detail views.
.*
.beglevel
.section Basic Detail View
.*
.np
The basic detail view is used "as is" to display information for variables,
labels, and typedefs (see
:figref refid='viewsym'.).
.*
:fig id='viewsym' frame=box place=inline.
:graphic depth='2.0i'
    file='viewsym.eps'
:figcap.Basic Detail View
:efig.
.*
.np
All Detail Views are pushpin windows, exhibiting standard pushpin
behavior.
.*
.np
Since there are many routes to arrive at the detail view for a given
symbol, there might be a risk of creating many redundant windows.  Too avoid
this, all existing unattached views are searched any time there is a need for
a detail view of a given symbol. If one exists, it will be brought to the top
of the window stack (first restoring from minimized state if necessary).  Only
if no unattached views exist for that symbol will a new one be created.
.*
.np
Many of them also have checkboxes that enable/disable the display of further
details. Since a delay may be inherent in the filling out of some of these
further details, it may be desirable to disable them for early browsing.  For
example, if the detail view is pinned to a query dialog, delays in cursoring
through the list may be experienced if the references checkbox (see below)
is enabled.
.*
.np
List boxes appear in all Symbol Detail Views.  Items appearing in these
list boxes may be double clicked for more information; this will usually
result in the creation of a new Detail View or an &edname session, depending on
the meaning of the list box.
.*
.np
Additionally, all symbol detail views share the following features:
.*
.beglevel
.section Title Bar
.*
.np
The title bar contains the symbol's complete scoped name (it may be
truncated to fit).  It also contains minimize and maximize buttons, and a
pushpin button.
.*
.section Symbol Description
.*
.np
The symbol description appears at the top of the view, and will include the
symbols complete declaration.  This will include type information in the case
of functions and variables, and function argument types, if
appropriate.
.*
.np
If any of the names used to describe the symbol (except for the symbol's own
name) are also user defined symbols, those names will be displayed on a
pushbutton embedded in the symbol's description (see foo? in the description
in
:figref refid=viewsym.).
This is a cue that more information is available for
that name.  If the button is pushed, another Detail View of the appropriate
type will appear to display information on that name.
.*
.section Edit Source Button
.*
.np
Pressing this button will resulting in a message being sent to the &edname (it
will be started up if necessary).  The &edname will be requested to open up the
file in which the Detail View's symbol is defined, and to position it at the
row and column in the file at with the definition occurs.  (FIXME - &brname
should check the timestamp of the file vs timestamp of the &mbrfile to raise
warnings if source changed.)
.*
.np
The new editor session might also be used as a starting point for further
queries (see section (Editor Interaction)), or to edit the symbol's
definition.  (Note that changes to source may put the source out of sync with
the &mbrfile that the compiler generated from the previous version of the
source.  If these changes are large, it may be necessary to recompile the
source, and unload/reload the module.
.*
.section References CheckBox
.*
.np
If this checkbox is clicked on, a listbox will appear below the checkbox; if
any other controls are arranged below the checkbox, they will be shifted
downwards.  The new listbox will contain the names of all other symbols that
'reference' the Detail View's symbol in one of the following senses:
.*
.begbull
.bull
variables and functions reference their types
.bull
derived types reference their base types
.bull
functions reference local and global variables (only those which may be
determined at compile time are listed)
.bull
functions reference functions
.bull
classes/structs/unions reference their members
.bull
class member functions may reference base class members implicitly (Eg: call
of base class destructor)
.bull
macros are referenced at their point of expansion (not yet implemented by
compiler)
.bull
function and class template instantiations reference their templates
.endbull
.*
.np
Each line specifies the name of the referencing symbol, and the
file name and file position at which the reference occurs.  If one of these
listbox items is double clicked, or if it is selected and then <enter> is
pressed, an &edname session will be positioned to the source location at which
the reference occurs.
.*
.np
Unchecking the References checkbox naturally causes the References list to
disappear.  If any other controls are arranged below it, they will be moved
up to close the gap.  The window's height will also be reduced accordingly.
.*
.endlevel
.*
.np
The next few sections describes other types of detail views that are
specialized for particular symbol types.
.*
.section Function Detail Views
.*
.np
Function Detail Views are used to handle local, global, inline, and member
functions, as well as function templates instantiations (not implemented).
.*
.np
Function Detail Views add two new detail controls to the basic Symbol Detail
View:
.*
.beglevel
.section Locals Checkbox
.*
.np
This controls the display of a list of variables local to the function.
Double click or enter on an item in the list will cause a detail view for that
variable to be created.
.*
.section Call Graph Checkbox
.*
.np
Enabling the Call Graph Checkbox causes a popup window to appear, displaying
the part of the call graph adjacent to the function that this window is
detailing (direct calls to and from this function).  The new window is a
pushpin window, pinned to this detail view.
.*
.np
The form of the display depends on the current setting of the call graph
format option (see section(Options)).(FIXME- currently no such menu
item)
.*
.np
In either the text format or the graphical format, a left to right
connection between nodes indicates a direct function call.
.*
.np
See section(Graph Displays) for a detailed description of the call graph and
its interaction mechanism.
.*
.np
Note that function calls made from a function pointer are not reflected
in the call graph.
.*
.endlevel
.*
.section Class Detail Views
.*
.np
The Class query also encompasses structs and unions, as these may be considered
restricted cases of the class construct.
.*
.np
Class Detail Views add two new detail controls to the basic Symbol Detail View:
.*
.beglevel
.section Data Members
.*
.np
The Data Members checkbox controls the display of a list of the names of
the data members of this class (as opposed to member functions).  As with all
Detail View list boxes, a double click on an item in the list will cause
a Detail View of that item to appear.
.*
.np
By default, the list box will show all data members of all types, including all
access levels (private/protected/public), and both static and non-static types.
Inherited data members are not shown.  However, these defaults can be changed
using the data member Filter button (see next section).
.*
.section Data Members Filter Button
.*
.np
This control creates a dialog box that allows setting the criteria that
determines which data members get displayed in the data members list
box (see
:figref refid=dmfltdlg.).
Changes made do not take effect unless the Ok
button is pressed, and they only affect the current Class Detail View.
.*
:fig id='dmfltdlg' frame=box place=inline.
:graphic depth='2.0i'
    file='dmfltdlg.eps'
:figcap.Data Members Filter Dialog
:efig.
.*
.section Member Functions
.*
.np
.np
The Member Functions checkbox controls the display of a list of the names of
the member functions of this class.  As with all
Detail View list boxes, a double click on an item in the list will cause
a Detail View of that item to appear.
.*
.np
By default, the list box will show all member functions of all types, including
all access levels (private/protected/public), both static and non-static
functions, and both virtual and non-virtual functions. Inherited member
functions are not shown.  However, these defaults can
be changed using the member functions Filter button (see next section).
.*
.section Member Functions Filter Button
.*
.np
This control creates a dialog box that allows setting the criterial that
determines which member functions get displayed in the member functions list
box (see
:figref refid=mffltdlg.).
Changes made do not take effect unless the Ok
button is pressed, and they only affect the current Class Detail View.
.*
:fig id='mffltdlg' frame=box place=inline.
:graphic depth='2.0i'
    file='mffltdlg.eps'
:figcap.Member Function Filter Dialog
:efig.
.*
.section Inheritance Tree
.*
.np
Enabling the Inheritance Tree checkbox causes a popup window to appear,
displaying the part of the inheritance tree adjacent to the class that this
window is detailing (direct base and derived classes).  The popup window is
a pushpin window, pinned to this detail view.
.*
.np
The form of the display depends on the current setting of the inheritance
tree format option (see section(Options)).(FIXME- currently no such menu
item)
.*
.np
In either the text format or the graphical format, a left to right
connection between nodes indicates a direct inheritance relationhip.
.*
.np
See section(Graph Displays) for a detailed description of the inheritance
tree display and its interaction mechanism.
.*
.section Decomposition
.*
.np
The Decomposition checkbox controls the display of a pushpin window for selective
viewing of the composition of the data fields of a structure.
.*
.np
When it first appears, the decomposition window shows the name of the structure,
followed by an indented list of all of its data members (see
:figref refid=decomp.).
.*
:fig id='decomp' frame=box place=inline.
:graphic depth='2.0i'
    file='decomp.eps'
:figcap.Structure Decomposition
:efig.
.*
.np
If a displayed item has a '+' symbol in the extreme left column,
this indicates that the item is itself a structure type. Double clicking on
the item will cause an indented expansion of the structure in place.
.*
.np
If a displayed item has a '*' symbol in the extreme left column,
this indicates that the item is a pointer to some type.
Double clicking on the entries will 'follow the pointer'; the entry will
be replaced by the type that was pointed to, with its name preceded by a '*'
to indicate that it has been dereferenced.  The extreme left  column of the
starting item will now contain either a '-' to indicate that the item cannot be
expanded further, or a '*' to indicate that the dereferenced type is also a
pointer, which may be followed further.
.*
.np
If a displayed item has a '-' symbol in the extreme left column,
this indicates that the item has been expanded (this symbol does not appear
for pointer types until the end of chain of pointers has been reached.).
Clicking on the item will cause the expansion to collapse.  For example,
clicking on the top row (the root type of this decomposition) while collapse
the view to a single line holding the name of the root structure, preceded by
a '+'.
.*
.np
Double clicking on an item will create a Detail View of the item.
.*
.endlevel
.*
.section Macro Detail Views
.*
.np
Macro Detail Views simply add a Definition checkbox to the basic Symbol Detail
View.  This controls the display of a text box holding the definition of the
macro.
.*
.np
Note that the definition is simply the first encountered definition for that
macro;  if the macro is defined more than once, the contents of the
definition text box will not be correct for some scopes.
.*
.endlevel
.*
.section Graph Displays
.*
.np
&brname provides information on three types of graphs:
.begbull
.bull
Function Call Graphs
.bull
Class Inheritance Tree
.bull
Structure Decomposition
.endbull
.*
.np
Structure Decomposition is described in the section(Class Detail
Views/Decomposition). Call graphs and inheritance trees are handled
identically , so they will both be described here.
.*
.np
Either of these graphs can be displayed in a text or graphical format; while
the graphical format is be easier to use and interpret, it takes longer to
display and update than the text format.
.*
.np
The form that newly created graph windows will take depends up the current
setting of the appropriate item under the main Options menu (existing graph
windows are not affected by setting changes).
.*
.np
The following description uses the function call graph for illustration.
However, if the concepts 'function call', 'calling function', and 'called
function' are replaced with 'derivation', 'base class', and 'derived class',
this same description may be applied to a class inheritance tree.
.*
.beglevel
.section Text Format Graph Display
.*
.np
In text form, the call graph is represented as three columns (see
:figref refid=funtxttr.) .
.*
:fig id='funtxttr' frame=box place=inline.
:graphic depth='1.5i'
    file='funtxttr.eps'
:figcap.Text Format Function Call Graph
:efig.
.*
.np
The center column lists a number of functions, starting with the detail view's
function, in an indented format.  Read from top to bottom, this list indicates
path that has been followed in browsing up and down the call graph.  If an item
is indented further than an adjacent item, it is called by that item (and
vice versa).
.*
.np
One of the items in the center column will always be highlighted, indicating
the current position in the call graph. The left column lists direct callers
of the highlighted function in the center column, and the right column lists
functions that are directly called by it.
.*
.np
Movement to a new point in the call graph can be done by selecting an item
from any of the three columns to be the new focal point.  This selection may
be done with a mouse click in any column.  In the center column, up
and down cursor movement will dynamically change the focal point. (FIXME -
need to test performance of this; may need to use enter key to force refresh)
In either side column, a press of the enter key is needed to indicate a new
selection.
.*
.np
Selection of a new focal point will cause a refresh of the two outer columns
to indicate the direct calls to and from the new focal point.  The new focal
point will be highlighted in the center column.


If the new focal point was already on the existing browse path, that item on
the center column's path will just be highlighted. If the new focal point
represents an extension to the previous browse path, the new function will be
added to the end of the path in the center column. Otherwise, the new focal
point represents a fork off of an item in the existing browse path;  the path
below that item will be cleared, and the new focal point will be added to the
bottom of the path.
.*
.np
If a node is double clicked, a Detail View for the node will appear.
.*
.section Graphical Format Graph Display
.*
.np
In graphical form, the call graph is represented as two trees, fanning out
to the left and the right of the detail view's function (see
:figref refid=fungrptr.) .
Connections between nodes indicate direct function calls, calling from left
to right.  Dotted connection lines indicate functions that directly connect to
this function which are not shown.
.*
:fig id='fungrptr' frame=box place=inline.
:graphic depth='2.5i'
    file='fungrptr.eps'
:figcap.Graphical Format Function Call Graph
:efig.
.*
.np
The trees may be expanded outwards from the focal point, and selectively
collapsed back inwards, using mouse clicks on the connection lines, or using
pop-up menus on the tree nodes.
.*
.np
If the mouse is clicked on a solid connection, the nodes that that tree
branch connect to will be hidden, and the connection will change from a
solid line to a dotted line.  If the mouse is clicked on a dotted connection,
the next level of functions will be displayed.
.*
.np
The same operations may be performed with the pop-up menu on a given node,
activated with a right mouse click (FIXME - need hot key for keyboard)
(see
:figref refid=treemenu.) .
.*
:fig id='treemenu' frame=box place=inline.
:graphic depth='2.5i'
    file='treemenu.eps'
:figcap.Graph Node Popup Menu
:efig.
.np
The menu items work as follows:
.*
.begnote
.note Hide
hides this node, and any branches originating from it
.note Hide Children
hides any branches originating from the node
.note Show Children
shows any hidden branches originating from the node
.note Show Details
creates a Detail View of the node
.endnote
.*
.np
If a node is doubleClicked, a Detail View for the node will appear.
.*
.endlevel
.section Menu Versus Editor Interaction
.*
.np
The &brname presents a two major entry points for navigating an
application.
.*
.np
The menu bar in the main &brname window represents one of two methods for
navigating an application; this is the preferred way to get an overview of
a development project.
.*
.np
The other method for browsing an application begins with an &edname session
running as a slave to &vmakenm.  In this mode, a particular word in the file can
be selected, and the editor can direct a query on that word to the &brname.
.*
.np
The information presented is identical in both cases, with the difference
that editor queries must originate with a piece of text in a file and may
only follow the symbol relationship paths from that point, while the main
&brname menu bar allows arbitrary queries of all the symbols in the
application.  In addition, the &brname menus provide some overviews and
reports not available through the editor interface.
.*
.np
In either mode, the &edname is used as the means of displaying and changing
symbol definitions, and any editor session opened to display a symbol
definition may be used as the source of further queries.
.*
.np
The next two major sections cover menu bar and editor interaction, respectively.
.*
.endlevel
.*
.section The Menu Bar
.*
.np
The menu bar appears on the main &brname window. This window is initially in
the upper left of the screen, or it may be minimized if the &brname has been
started as a slave to &vmakenm.
.*
.np
The contents of the menu bar are described in the following
sections.
.*
.beglevel
.section File
.*
.np
File groups together those actions that load, save, and change '.wbr' project
files, as well as providing for exit from the application.
.*
:fig id='filemenu' frame=box place=inline.
:graphic depth='1.3i'
    file='filemenu.eps'
:figcap.File Menu Items
:efig.
.*
.beglevel
.section Open
.*
.np
Open allows the selection of a &wbrfile for loading into the browser.  This
is done through a standard Windows file selection dialog, as in
:figref refid=opendlg. .
.*
:fig id='opendlg' frame=box place=inline.
:graphic depth='2.2i'
    file='opendlg.eps'
:figcap.Open File Dialog
:efig.
.*
.np
Selection of 'Cancel' will leave the current browse project (if any)
unchanged.
.*
.np
If a valid .wbr is selected and 'Ok' pressed, the current project (if any)
will be unloaded.  If the current project has been changed since loading, a
'Save? YES/NO' dialog will appear.  Finally the new .wbr will be loaded.
While it is loading, all browsing operations are disabled, and a loading
progress indicator is displayed.
.*
.np
A sample &wbrfile is available in the (SAMPLES?) directory, called
'test.wbr'.  This is the project that was used for generating the screens
that are seen throughout this text.
.*
.section New
.*
.np
New creates a new browse project with no name, though it can be saved under
any name, using Save or SaveAs.  If a project is currently loaded and it has
unsaved changes, a 'Save? YES/NO' dialog will allow it to be saved before the
project is replaced with the new one.
.*
.np
The new, empty project must be populated with at least one &mbrfile (see
section(File/Modules) below) before anything useful can be done.
.*
.section Save
.*
.np
Save will write the current project configuration to the current &wbrfile..
If the project has no name yet, selection of this item will result in the
same file selection dialog box used by SaveAs, described in the next
section.
.*
.np
The Save menu item will be enabled only if the current project has unsaved
changes; otherwise it will appear shaded.
.*
.section SaveAs
.*
.np
SaveAs allows the selection of any valid file destination for saving the
project.  This effectively saves a copy of the current state of the project.
It does not rename the current project, unless the project is unnamed.
.*
.np
SaveAs might be used to create a few &wbrfile.s for a given project, each
support browsing of a different part or view of the project.  This has two
benefits: query processing will be faster due to fewer symbols, and the results
of queries will be more focussed
.*
.np
If the destination file already exists, a "File exists. Overwrite?" dialog
appears, to avoid accidental data loss.
.*
:fig id='savasdlg' frame=box place=inline.
:graphic depth='2.2i'
    file='savasdlg.eps'
:figcap.File SaveAs Dialog
:efig.
.*
.section Modules
.*
.np
The Modules menu item is the entry point for adding and removing modules from
the browse session.  These changes are also reflected in the state of
the &wbrfile if it is subsequently saved.
.*
.np
Changes to the set of modules are handled by an Edit Project dialog window,
as in
:figref refid=editproj..
FIXME - need to review dialog to fill in details.
.*
:fig id='editproj' frame=box place=inline.
:graphic depth='2.0i'
    file='editproj.eps'
:figcap.Edit Project Dialog
:efig.
.*
.begbull
.bull
addition of module (check for duplicates)
.bull
relative or absolute paths
.bull
deletion of module
.bull
no changes actually made until ok; cancel kills
.endbull
.*
.section Exit
.*
.np
Exit, as you might expect, terminates the application.
.*
.np
If the project has changes that have not been saved, a 'Save Changes?' dialog
will first appear.  If the project has no name, and the 'Yes' choice is
selected, a SaveAs file dialog will request a file name specification for the
new file.
.*
.endlevel
.*
.section Locate Symbols
.*
.np
The term 'symbol', in the context of the &brname, encompasses the following:
.*
.begbull
.bull
user defined types
.bull
labels
.bull
functions
.bull
variables
.bull
function parameters
.bull
class/structure/union members
.bull
macros
.bull
class/function templates and their instantiations
.bull
filenames (not implemented)
.endbull
.*
.np
.bi Note:
Unnamed types appear only embedded in the descriptions of named variables and
types.
.*
.np
The sub-items in the Symbol menu all result in the same query dialog (see
:figref refid=picksym.),
except that each is pre-loaded with a particular symbol
type filter.
.*
:fig id='loctmenu' frame=box place=inline.
:graphic depth='1.2i'
    file='loctmenu.eps'
:figcap.Locate Symbols Menu Items
:efig.
.*
:fig id='picksym' frame=box place=inline.
:graphic depth='2.5i'
    file='picksym.eps'
:figcap.Locate Symbols Query Dialog
:efig.
.*
.np
Any number of these query dialogs may be open at any given time.  This allows
the results of various queries to be kept on hand (perhaps in a minimized
icon) for fast reference.
.*
.np
Regardless of entry point, all symbol query dialogs contain the following
elements:
.*
.beglevel
.section Filter Edit Line
.*
.np
The Filter Edit Line accepts the following syntax for creating general or
specific queries (the same syntax is used by Open Watcom's WD debugger):
.*
.millust begin
[FileName[.ext]@][ClassName::][FuncName.][SymbolName]

('[]' indicates optional fields)
.millust end
.*
.np
FileName may be the name of a main source file or an included file.  If an
extension is not provided, it is assumed to be the name of a module.
Specification of this field will constrain the results of the query to
symbols visible somewhere in the scopes of the file (or module).
.*
.np
ClassName constrains the search to symbols visible in the scope of the named
class/struct/union, including class data members and member functions, and
those of base classes of the named class.
.*
.np
FuncName constrains the search to symbols visible in the scope of the named
 class, particularly local symbols.  If ClassName was specified, and the named
 function is a member of the class, symbols will also include symbols in the
 class scope. If the named function is not a member of a named class, no
 matching symbols will be found. This name does not include parentheses and
 parameters.
.*
.np
SymbolName constrains the search to symbols that match the specified name.  In
the case of functions, this name does not include parentheses and
parameters.
.*
.section Symbol Type Selection
.*
.np
This combo box is preloaded with a particular symbol type (or 'All'),
depending on the Symbol menu item that created the query dialog. For example,
the Function menu item creates a query dialog with 'Functions' preselected.
.*
.np
However, the setting of the symbol type filter can always be changed.  This
means that a query dialog that originated with the Function menu item could
be transformed into a Class query dialog, for example.  The current symbol
type setting is always reflected in the query dialog's title bar.
.*
.np
As might be expected, a value of 'All' applies no restrictions to the symbol
types matching the query.
.*
.section Locate Button
.*
.np
The Locate Button initiates a query that incorporates the current settings of
the Symbol Type and the Filter Edit Line.  Changes to the two filter controls
do not result in changes to the Matches listbox until the Find button is
pressed.
.*
.np
Symbols that match the constraints of the filters will be loaded into the
Matches Listbox (see below).  If there are no matching
symbols found, a 'No Symbols Found' dialog box will appear.
.*
.section Matches ListBox
.*
.np
Symbols that match the filter constraints display their names in the results
list box.  The syntax used for the symbol names is the same scoped format
that is used for the Filter Edit Line.
.*
.np
Excess symbols may be scrolled into view.  Also, the whole query dialog may
be resized to see more information in the list box.
.*
.section Show Details Checkbox
.*
.np
The names that appear in the Matches Listbox may be used as a starting point
for a whole chain of investigation.  If the Show Details control is checked,
a Symbol Detail View will appear, pinned to the right of the query dialog
(see section(PushPin Windows)).  That Detail View will show information on of the
symbol currently selected in the results listbox.
.*
.np
If the checkbox is unchecked, the detail view will disappear (if it has not
been unpinned).
.*
.np
If the detail view is unpinned, and a new item is selected in the list box
while the checkbox is still on, a new pinned Detail View will be created.
.*
.np
As a new item is selected in the listbox (using the keyboard or the mouse)
the contents of the pinned Detail View will change to show the new symbol.
If the new symbol is of a different type than the previous one, the layout of
the Detail View may change to show information applicable to the new symbol
type.
.*
.np
The various Detail Views are described in detail in the section(Symbol
Detail Views).
.*
.endlevel
.*
.*
.section Diagrams
.*
.np
Currently, the only diagram supported is the project-wide inheritance tree.
.*
:fig id='diagmenu' frame=box place=inline.
:graphic depth='0.8i'
    file='diagmenu.eps'
:figcap.Diagrams Menu Items
:efig.
.*
.beglevel
.section Inheritance
.*
.np
This menu item generates a project wide inheritance tree, in the graphical
format.  This tree is identical to that described in section (Graph Displays),
except that there is no left hand side of the tree.  All nodes in the tree
grow out from the left edge, and the focal node is a hidden logical 'base of
all bases'.  Initially, the whole inheritance tree is displayed.
.*
.section Call Tree
.np
(not supported)
This menu item generates a project wide call graph, in the graphical
format.  This tree is identical to that described in section (Graph Displays),
except that there is no left hand side of the tree.  All nodes in the tree
grow out from the left edge, and the focal node is the startup function.
Initially, the whole call graph is displayed.
.*
.endlevel
.*
.section Reports
(not supported)
.*
.section Options
.*
.np
Options allows modification to certain preference settings on a session wide
basis.
.*
.beglevel
.section Call Graph Format
.*
.np
This item allows a selection between text and graphical format for call graph
displays . This will have no affect on existing graph displays.
.*
.section Inheritance Format
.*
.np
This item allows a selection between text and graphical format for inheritance
tree displays. This will have no affect on existing graph displays.
.*
.endlevel
.*
.section Help
.*
.np
The Help menu provides online access to the contents of this document, in a
hypertext format.  (FIXME - this could use more meat.)
.*
:fig id='helpmenu' frame=box place=inline.
:graphic depth='1.3i'
    file='helpmenu.eps'
:figcap.Help Menu Items
:efig.
.*
.endlevel
.*
.*
.section The Editor Interface
.*
.np
Whether &brname is in standalone or &vmakenm slave mode, an &edname will likely
be available (In standalone mode, the Edit Source button on any Symbol Detail
will pop up the editor.).  Provided the &edname is positioned on a file that
is part of the &brname project, the &brname can quickly provide details on any user-defined
symbol that appears in the text.
.*
.np
In order to find out about a symbol, the whole word must first be highlighted.
(?more info to be filled in here)
This will result in a query being sent to &brname (either directly or via &vmakenm)
containing the symbol name, the file name, and the source location.
.*
.np
The result of the query will be all symbols that have that name that are
in scope at that scope in that file.
.*
.np
If only a single symbol is found, a Detail View for that symbol will be created,
unattached to any window.  This Detail View is identical in all regards to
those resulting from the &brname menu interaction, except that it will not be
minimized if the &brname main window is minimized.
.*
.np
If more than one symbol is found with that name in that scope (Eg: a local
variable and a global variable may have the same name), a symbol selection
dialog will appear, with a detail view of the currently selected symbol pinned
to it. As items in the list are selected, the pinned window will refresh to
reflect the current item.
.*
.np
If the 'Ok' button is pressed, the dialog will close, leaving behind an
unpinned detail view for the most recently selected symbol.  If the cancel
button is pressed, the dialog and the detail view are both closed.
.*
.np
If the detail view is unpinned from the dialog, and another symbol in the
dialog is selected,  a new pinned one will be created.  Be repeating this,
detail views for several of the matching symbols can be unpinned for saving
after the dialog disappears.
.*
