/*
 *  strings.h POSIX string manipulation routines
 *
 *                          Open Watcom Project
 *
 *    Copyright (c) 2002-2008 Open Watcom Contributors. All Rights Reserved.
 *    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _STRINGS_H_INCLUDED
#define _STRINGS_H_INCLUDED

#if !defined(_ENABLE_AUTODEPEND)
  #pragma read_only_file;
#endif


#ifndef _COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
  #ifndef _STDSIZE_T_DEFINED
    #define _STDSIZE_T_DEFINED
    namespace std {
      typedef unsigned size_t;
    }
    typedef std::size_t _w_size_t;
  #endif
  #ifndef _SIZE_T_DEFINED
    #define _SIZE_T_DEFINED
    #define _SIZE_T_DEFINED_
    using std::size_t;
  #endif
#else
  #ifndef _SIZE_T_DEFINED
    #define _SIZE_T_DEFINED
    #define _SIZE_T_DEFINED_
    typedef unsigned size_t;
    typedef size_t   _w_size_t;
  #endif
#endif /* __cplusplus */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Legacy functions */

_WCRTLINK extern int    bcmp( const void *__s1, const void *__s2, _w_size_t __n );
_WCRTLINK extern void   bcopy( const void *__s1, void *__s2, _w_size_t __n );
_WCRTLINK extern void   bzero( void *__s, _w_size_t __n );

/* Non-legacy functions */

_WCRTLINK extern int    ffs( int __i );
_WCRTLINK extern int    strcasecmp( const char *__s1, const char *__s2 );
_WCRTLINK extern int    strncasecmp( const char *__s1, const char *__s2, _w_size_t __n );

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
