/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Table of x86 opcodes and corresponding decode routines.
*                without extension 3DNow!, MMX, SSE, SSE2 and SSE3
*
****************************************************************************/

/*
 * It must be processed as first instruction table before any others
 * It is opcode map with full prefix processing.
 *
 */

/*
      Idx,              Name,           Opcode,         Mask,           Handler
*/

// PREFIXES
inspick( opnd_pr,       "opnd",         0X00000066,     0x000000ff,     X86PrefixOpnd )
inspick( addr_pr,       "addr",         0X00000067,     0x000000ff,     X86PrefixAddr )
inspick( repe_pr,       "repe",         0x000000f3,     0x000000ff,     X86PrefixRepe )
inspick( rep_pr,        "rep",          0x00000000,     0x00000000,     NULL )
inspick( repne_pr,      "repne",        0x000000f2,     0x000000ff,     X86PrefixRepne )
inspick( cs_pr,         "cs",           0x0000002e,     0x000000ff,     X86PrefixCS )
inspick( ss_pr,         "ss",           0x00000036,     0x000000ff,     X86PrefixSS )
inspick( ds_pr,         "ds",           0x0000003e,     0x000000ff,     X86PrefixDS )
inspick( es_pr,         "es",           0x00000026,     0x000000ff,     X86PrefixES )
inspick( fs_pr,         "fs",           0x00000064,     0x000000ff,     X86PrefixFS )
inspick( gs_pr,         "gs",           0x00000065,     0x000000ff,     X86PrefixGS )
inspick( lock_pr,       "lock",         0x000000f0,     0x000000ff,     X86PrefixLock )
inspick( fwait,         "fwait",        0x0000009b,     0x000000ff,     X86PrefixFwait )
// Instructions
inspick( aaa,           "aaa",          0x00000037,     0x000000ff,     X86NoOp_8)
inspick( aad,           "aad",          0x00000ad5,     0x0000ffff,     X86NoOp_16)
inspick( aam,           "aam",          0x00000ad4,     0x0000ffff,     X86NoOp_16)
inspick( aas,           "aas",          0x0000003f,     0x000000ff,     X86NoOp_8)
inspick( adc,           "adc",          0x00000010,     0x000000fc,     X86RegModRM_16)
inspick( adc2,          "adc",          0x00000014,     0x000000fe,     X86ImmAcc_8)
inspick( adc3,          "adc",          0x00001080,     0x000038fc,     X86ModRMImm_16)
inspick( add,           "add",          0x00000000,     0x000000fc,     X86RegModRM_16)
inspick( add2,          "add",          0x00000004,     0x000000fe,     X86ImmAcc_8)
inspick( add3,          "add",          0x00000080,     0x000038fc,     X86ModRMImm_16)
inspick( and,           "and",          0x00000020,     0x000000fc,     X86RegModRM_16)
inspick( and2,          "and",          0x00000024,     0x000000fe,     X86ImmAcc_8)
inspick( and3,          "and",          0x00002080,     0x000038fc,     X86ModRMImm_16)
inspick( arpl,          "arpl",         0x00000063,     0x000000ff,     X86RegModRM_16B)
inspick( bound,         "bound",        0x00000062,     0x000000ff,     X86RegModRM_bound)
inspick( bsf,           "bsf",          0x0000bc0f,     0x0000ffff,     X86RegModRM_24B)
inspick( bsr,           "bsr",          0x0000bd0f,     0x0000ffff,     X86RegModRM_24B)
inspick( bswap,         "bswap",        0x0000c80f,     0x0000f8ff,     X86Reg_16)
inspick( bt,            "bt",           0x0000a30f,     0x0000ffff,     X86RegModRM_24B)
inspick( bt2,           "bt",           0x0020ba0f,     0x0038ffff,     X86ModRMImm_24)
inspick( btc,           "btc",          0x0000bb0f,     0x0000ffff,     X86RegModRM_24B)
inspick( btc2,          "btc",          0x0038ba0f,     0x0038ffff,     X86ModRMImm_24)
inspick( btr,           "btr",          0x0000b30f,     0x0000ffff,     X86RegModRM_24B)
inspick( btr2,          "btr",          0x0030ba0f,     0x0038ffff,     X86ModRMImm_24)
inspick( bts,           "bts",          0x0000ab0f,     0x0000ffff,     X86RegModRM_24B)
inspick( bts2,          "bts",          0x0028ba0f,     0x0038ffff,     X86ModRMImm_24)
inspick( call,          "call",         0x000000e8,     0x000000ff,     X86Rel_8)
inspick( call2,         "call",         0x000010ff,     0x000038ff,     X86ModRM_16)
inspick( call3,         "call",         0x0000009a,     0x000000ff,     X86Abs_8)
inspick( call4,         "call",         0x000018ff,     0x000038ff,     X86ModRM_16)
inspick( cbw,           "cbw",          0x00000098,     0x000000ff,     X86NoOp_8)
// Same as cwd
inspick( cdq,           "cdq",          0x00000000,     0x00000000,     NULL)
inspick( clc,           "clc",          0x000000f8,     0x000000ff,     X86NoOp_8)
inspick( cld,           "cld",          0x000000fc,     0x000000ff,     X86NoOp_8)
inspick( cli,           "cli",          0x000000fa,     0x000000ff,     X86NoOp_8)
inspick( clts,          "clts",         0x0000060f,     0x0000ffff,     X86NoOp_16)
inspick( cmc,           "cmc",          0x000000f5,     0x000000ff,     X86NoOp_8)
inspick( cmp,           "cmp",          0x00000038,     0x000000fc,     X86RegModRM_16)
inspick( cmp2,          "cmp",          0x0000003c,     0x000000fe,     X86ImmAcc_8)
inspick( cmp3,          "cmp",          0x00003880,     0x000038fc,     X86ModRMImm_16)
inspick( cmps,          "cmps",         0x000000a6,     0x000000fe,     X86String_8)
inspick( cmpxchg,       "cmpxchg",      0x0000b00f,     0x0000feff,     X86RegModRM_24)
inspick( cmpxchg8b,     "cmpxchg8b",    0x0008c70f,     0x0038ffff,     X86ModRM_24)
inspick( cmovo,         "cmovo",        0x0000400f,     0x0000ffff,     X86MovCC_24)
inspick( cmovno,        "cmovno",       0x0000410f,     0x0000ffff,     X86MovCC_24)
inspick( cmovb,         "cmovb",        0x0000420f,     0x0000ffff,     X86MovCC_24)
inspick( cmovae,        "cmovae",       0x0000430f,     0x0000ffff,     X86MovCC_24)
inspick( cmove,         "cmove",        0x0000440f,     0x0000ffff,     X86MovCC_24)
inspick( cmovne,        "cmovne",       0x0000450f,     0x0000ffff,     X86MovCC_24)
inspick( cmovbe,        "cmovbe",       0x0000460f,     0x0000ffff,     X86MovCC_24)
inspick( cmova,         "cmova",        0x0000470f,     0x0000ffff,     X86MovCC_24)
inspick( cmovs,         "cmovs",        0x0000480f,     0x0000ffff,     X86MovCC_24)
inspick( cmovns,        "cmovns",       0x0000490f,     0x0000ffff,     X86MovCC_24)
inspick( cmovp,         "cmovp",        0x00004a0f,     0x0000ffff,     X86MovCC_24)
inspick( cmovpo,        "cmovpo",       0x00004b0f,     0x0000ffff,     X86MovCC_24)
inspick( cmovl,         "cmovl",        0x00004c0f,     0x0000ffff,     X86MovCC_24)
inspick( cmovge,        "cmovge",       0x00004d0f,     0x0000ffff,     X86MovCC_24)
inspick( cmovle,        "cmovle",       0x00004e0f,     0x0000ffff,     X86MovCC_24)
inspick( cmovg,         "cmovg",        0x00004f0f,     0x0000ffff,     X86MovCC_24)
inspick( cpuid,         "cpuid",        0x0000a20f,     0x0000ffff,     X86NoOp_16)
inspick( cwd,           "cwd",          0x00000099,     0x000000ff,     X86NoOp_8)
// Same as cbw
inspick( cwde,          "cwde",         0x00000000,     0x00000000,     NULL)
inspick( daa,           "daa",          0x00000027,     0x000000ff,     X86NoOp_8)
inspick( das,           "das",          0x0000002f,     0x000000ff,     X86NoOp_8)
inspick( dec,           "dec",          0x000008fe,     0x000038fe,     X86ModRM_16)
inspick( dec2,          "dec",          0X00000048,     0x000000f8,     X86Reg_8)
inspick( div,           "div",          0X000030f6,     0x000038fe,     X86ModRM_16)
inspick( enter,         "enter",        0X000000c8,     0x000000ff,     X86ImmImm_8)
inspick( halt,          "hlt",          0x000000f4,     0x000000ff,     X86NoOp_8)
inspick( idiv,          "idiv",         0X000038f6,     0x000038fe,     X86ModRM_16)
inspick( imul,          "imul",         0X000028f6,     0x000038fe,     X86ModRM_16)
inspick( imul2,         "imul",         0X0000af0f,     0x0000ffff,     X86RegModRM_24B)
inspick( imul3,         "imul",         0X00000069,     0x000000fd,     X86RegModRM_16B)
inspick( in,            "in",           0X000000e4,     0x000000fe,     X86ImmAcc_8)
inspick( in2,           "in",           0X000000ec,     0x000000fe,     X86AccAcc_8)
inspick( inc,           "inc",          0x000000fe,     0x000038fe,     X86ModRM_16)
inspick( inc2,          "inc",          0X00000040,     0x000000f8,     X86Reg_8)
inspick( ins,           "ins",          0x0000006c,     0x000000fe,     X86String_8)
inspick( int,           "int",          0x000000cc,     0x000000fe,     X86Imm_8)
inspick( into,          "into",         0x000000ce,     0x000000ff,     X86NoOp_8)
inspick( invd,          "invd",         0x0000080f,     0x0000ffff,     X86NoOp_16)
inspick( invlpg,        "invlpg",       0x0038010f,     0x0038ffff,     X86ModRM_24)
inspick( iret,          "iret",         0x000000cf,     0x000000ff,     X86NoOp_8)
inspick( iretd,         "iretd",        0x00000000,     0x00000000,     NULL)
inspick( jo,            "jo",           0x00000070,     0x000000ff,     X86JmpCC_8)
inspick( jno,           "jno",          0x00000071,     0x000000ff,     X86JmpCC_8)
inspick( jb,            "jb",           0x00000072,     0x000000ff,     X86JmpCC_8)
inspick( jae,           "jae",          0x00000073,     0x000000ff,     X86JmpCC_8)
inspick( je,            "je",           0x00000074,     0x000000ff,     X86JmpCC_8)
inspick( jne,           "jne",          0x00000075,     0x000000ff,     X86JmpCC_8)
inspick( jbe,           "jbe",          0x00000076,     0x000000ff,     X86JmpCC_8)
inspick( ja,            "ja",           0x00000077,     0x000000ff,     X86JmpCC_8)
inspick( js,            "js",           0x00000078,     0x000000ff,     X86JmpCC_8)
inspick( jns,           "jns",          0x00000079,     0x000000ff,     X86JmpCC_8)
inspick( jp,            "jp",           0x0000007a,     0x000000ff,     X86JmpCC_8)
inspick( jpo,           "jpo",          0x0000007b,     0x000000ff,     X86JmpCC_8)
inspick( jl,            "jl",           0x0000007c,     0x000000ff,     X86JmpCC_8)
inspick( jge,           "jge",          0x0000007d,     0x000000ff,     X86JmpCC_8)
inspick( jle,           "jle",          0x0000007e,     0x000000ff,     X86JmpCC_8)
inspick( jg,            "jg",           0x0000007f,     0x000000ff,     X86JmpCC_8)
inspick( jo2,           "jo",           0x0000800f,     0x0000ffff,     X86JmpCC_16)
inspick( jno2,          "jno",          0x0000810f,     0x0000ffff,     X86JmpCC_16)
inspick( jb2,           "jb",           0x0000820f,     0x0000ffff,     X86JmpCC_16)
inspick( jae2,          "jae",          0x0000830f,     0x0000ffff,     X86JmpCC_16)
inspick( je2,           "je",           0x0000840f,     0x0000ffff,     X86JmpCC_16)
inspick( jne2,          "jne",          0x0000850f,     0x0000ffff,     X86JmpCC_16)
inspick( jbe2,          "jbe",          0x0000860f,     0x0000ffff,     X86JmpCC_16)
inspick( ja2,           "ja",           0x0000870f,     0x0000ffff,     X86JmpCC_16)
inspick( js2,           "js",           0x0000880f,     0x0000ffff,     X86JmpCC_16)
inspick( jns2,          "jns",          0x0000890f,     0x0000ffff,     X86JmpCC_16)
inspick( jp2,           "jp",           0x00008a0f,     0x0000ffff,     X86JmpCC_16)
inspick( jpo2,          "jpo",          0x00008b0f,     0x0000ffff,     X86JmpCC_16)
inspick( jl2,           "jl",           0x00008c0f,     0x0000ffff,     X86JmpCC_16)
inspick( jge2,          "jge",          0x00008d0f,     0x0000ffff,     X86JmpCC_16)
inspick( jle2,          "jle",          0x00008e0f,     0x0000ffff,     X86JmpCC_16)
inspick( jg2,           "jg",           0x00008f0f,     0x0000ffff,     X86JmpCC_16)
inspick( jcxz,          "jcxz",         0x000000e3,     0x000000ff,     X86JmpCC_8)
inspick( jecxz,         "jecxz",        0x00000000,     0x00000000,     NULL)
inspick( jmp,           "jmp",          0x000000eb,     0x000000ff,     X86JmpCC_8)
inspick( jmp1,          "jmp",          0x000000e9,     0x000000ff,     X86Rel_8)
inspick( jmp2,          "jmp",          0x000020ff,     0x000038ff,     X86ModRM_16)
inspick( jmp3,          "jmp",          0x000000ea,     0x000000ff,     X86Abs_8)
inspick( jmp4,          "jmp",          0x000028ff,     0x000038ff,     X86ModRM_16)
inspick( lahf,          "lahf",         0x0000009f,     0x000000ff,     X86NoOp_8)
inspick( lar,           "lar",          0x0000020f,     0x0000ffff,     X86RegModRM_24B)
inspick( lds,           "lds",          0x000000c5,     0x000000ff,     X86RegModRM_16B)
inspick( les,           "les",          0x000000c4,     0x000000ff,     X86RegModRM_16B)
inspick( lfs,           "lfs",          0x0000b40f,     0x0000ffff,     X86RegModRM_24B)
inspick( lgs,           "lgs",          0x0000b50f,     0x0000ffff,     X86RegModRM_24B)
inspick( lss,           "lss",          0x0000b20f,     0x0000ffff,     X86RegModRM_24B)
inspick( lea,           "lea",          0x0000008d,     0x000000ff,     X86RegModRM_16B)
inspick( leave,         "leave",        0x000000c9,     0x000000ff,     X86NoOp_8)
inspick( lgdt,          "lgdt",         0x0010010f,     0x0038ffff,     X86ModRM_24)
inspick( lidt,          "lidt",         0x0018010f,     0x0038ffff,     X86ModRM_24)
inspick( lldt,          "lldt",         0x0010000f,     0x0038ffff,     X86ModRM_24)
inspick( lmsw,          "lmsw",         0x0030010f,     0x0038ffff,     X86ModRM_24)
inspick( lods,          "lods",         0x000000ac,     0x000000fe,     X86String_8)
inspick( loop,          "loop",         0x000000e2,     0x000000ff,     X86JmpCC_8)
inspick( loopw,         "loopw",        0x00000000,     0x00000000,     NULL)
inspick( loopd,         "loopd",        0x00000000,     0x00000000,     NULL)
inspick( loopz,         "loopz",        0x000000e1,     0x000000ff,     X86JmpCC_8)
inspick( loopzw,        "loopzw",       0x00000000,     0x00000000,     NULL)
inspick( loopzd,        "loopzd",       0x00000000,     0x00000000,     NULL)
inspick( loopnz,        "loopnz",       0x000000e0,     0x000000ff,     X86JmpCC_8)
inspick( loopnzw,       "loopnzw",      0x00000000,     0x00000000,     NULL)
inspick( loopnzd,       "loopnzd",      0x00000000,     0x00000000,     NULL)
inspick( ltr,           "ltr",          0x0018000f,     0x0038ffff,     X86ModRM_24)
inspick( lsl,           "lsl",          0x0000030f,     0x0000ffff,     X86RegModRM_24B)
inspick( mov,           "mov",          0x00000088,     0x000000fc,     X86RegModRM_16)
inspick( mov2,          "mov",          0x000000c6,     0x000038fe,     X86ModRMImm_16)
inspick( mov3,          "mov",          0x000000b0,     0x000000f0,     X86ImmReg_8)
inspick( mov4,          "mov",          0x000000a0,     0x000000fc,     X86MemAbsAcc_8)
inspick( mov5,          "mov",          0x0000200f,     0x0000fdff,     X86CRegReg_24)
inspick( mov6,          "mov",          0x0000210f,     0x0000fdff,     X86DRegReg_24)
inspick( mov7,          "mov",          0x0000008c,     0x000000fd,     X86SRegModRM_16)
inspick( mov8,          "mov",          0x0000240f,     0x0000fdff,     X86TRegReg_24)
inspick( movs,          "movs",         0x000000a4,     0x000000fe,     X86String_8)
inspick( movsx,         "movsx",        0x0000be0f,     0x0000feff,     X86RegModRM_24C)
inspick( movzx,         "movzx",        0x0000b60f,     0x0000feff,     X86RegModRM_24C)
inspick( mul,           "mul",          0X000020f6,     0x000038fe,     X86ModRM_16)
inspick( neg,           "neg",          0X000018f6,     0x000038fe,     X86ModRM_16)
inspick( not,           "not",          0X000010f6,     0x000038fe,     X86ModRM_16)
inspick( or,            "or",           0x00000008,     0x000000fc,     X86RegModRM_16)
inspick( or2,           "or",           0x0000000c,     0x000000fe,     X86ImmAcc_8)
inspick( or3,           "or",           0x00000880,     0x000038fc,     X86ModRMImm_16)
inspick( out,           "out",          0X000000e6,     0x000000fe,     X86ImmAcc_8)
inspick( out2,          "out",          0X000000ee,     0x000000fe,     X86AccAcc_8)
inspick( outs,          "outs",         0x0000006e,     0x000000fe,     X86String_8)
inspick( pop,           "pop",          0x0000008f,     0x000038ff,     X86ModRM_16)
inspick( pop2,          "pop",          0x00000058,     0x000000f8,     X86Reg_8)
inspick( pop3d,         "pop",          0x00000007,     0x000000ff,     X86SReg_8)
inspick( pop3e,         "pop",          0x00000017,     0x000000ff,     X86SReg_8)
inspick( pop3s,         "pop",          0x0000001f,     0x000000ff,     X86SReg_8)
inspick( pop4f,         "pop",          0x0000a10f,     0x0000ffff,     X86SReg_16)
inspick( pop4g,         "pop",          0x0000a90f,     0x0000ffff,     X86SReg_16)
inspick( push,          "push",         0x000030ff,     0x000038ff,     X86ModRM_16)
inspick( pushw,         "pushw",        0x00000000,     0x00000000,     NULL)
inspick( pushd,         "pushd",        0x00000000,     0x00000000,     NULL)
inspick( push2,         "push",         0x00000050,     0x000000f8,     X86Reg_8)
inspick( push3,         "push",         0x00000006,     0x000000e7,     X86SReg_8)
inspick( push4f,        "push",         0x0000a00f,     0x0000ffff,     X86SReg_16)
inspick( push4g,        "push",         0x0000a80f,     0x0000ffff,     X86SReg_16)
inspick( push5,         "push",         0x00000068,     0x000000fd,     X86Imm_8)
inspick( popa,          "popa",         0x00000061,     0x000000ff,     X86NoOp_8)
inspick( popad,         "popad",        0x00000000,     0x00000000,     NULL)
inspick( popf,          "popf",         0x0000009d,     0x000000ff,     X86NoOp_8)
inspick( popfd,         "popfd",        0x00000000,     0x00000000,     NULL)
inspick( pusha,         "pusha",        0x00000060,     0x000000ff,     X86NoOp_8)
inspick( pushad,        "pushad",       0x00000000,     0x00000000,     NULL)
inspick( pushf,         "pushf",        0x0000009c,     0x000000ff,     X86NoOp_8)
inspick( pushfd,        "pushfd",       0x00000000,     0x00000000,     NULL)
inspick( rcl,           "rcl",          0x000010d0,     0x000038fc,     X86Shift_16)
inspick( rcl2,          "rcl",          0x000010c0,     0x000038fe,     X86ModRMImm_16)
inspick( rcr,           "rcr",          0x000018d0,     0x000038fc,     X86Shift_16)
inspick( rcr2,          "rcr",          0x000018c0,     0x000038fe,     X86ModRMImm_16)
inspick( rdmsr,         "rdmsr",        0x0000320f,     0x0000ffff,     X86NoOp_16)
inspick( rdpmc,         "rdpmc",        0x0000330f,     0x0000ffff,     X86NoOp_16)
inspick( rdtsc,         "rdtsc",        0x0000310f,     0x0000ffff,     X86NoOp_16)
inspick( ret,           "ret",          0x000000c3,     0x000000ff,     X86NoOp_8)
inspick( ret2,          "ret",          0x000000c2,     0x000000ff,     X86Imm_8)
inspick( retf,          "retf",         0x000000cb,     0x000000ff,     X86NoOp_8)
inspick( retf2,         "retf",         0x000000ca,     0x000000ff,     X86Imm_8)
inspick( ror,           "ror",          0x000008d0,     0x000038fc,     X86Shift_16)
inspick( ror2,          "ror",          0x000008c0,     0x000038fe,     X86ModRMImm_16)
inspick( rol,           "rol",          0x000000d0,     0x000038fc,     X86Shift_16)
inspick( rol2,          "rol",          0x000000c0,     0x000038fe,     X86ModRMImm_16)
inspick( rsm,           "rsm",          0x0000aa0f,     0x0000ffff,     X86NoOp_16)
inspick( sahf,          "sahf",         0x0000009e,     0x000000ff,     X86NoOp_8)
inspick( sbb,           "sbb",          0x00000018,     0x000000fc,     X86RegModRM_16)
inspick( sbb2,          "sbb",          0x0000001c,     0x000000fe,     X86ImmAcc_8)
inspick( sbb3,          "sbb",          0x00001880,     0x000038fc,     X86ModRMImm_16)
inspick( scas,          "scas",         0x000000ae,     0x000000fe,     X86String_8)
inspick( seto,          "seto",         0x0000900f,     0x0038ffff,     X86SetCC)
inspick( setno,         "setno",        0x0000910f,     0x0038ffff,     X86SetCC)
inspick( setb,          "setb",         0x0000920f,     0x0038ffff,     X86SetCC)
inspick( setae,         "setae",        0x0000930f,     0x0038ffff,     X86SetCC)
inspick( sete,          "sete",         0x0000940f,     0x0038ffff,     X86SetCC)
inspick( setne,         "setne",        0x0000950f,     0x0038ffff,     X86SetCC)
inspick( setbe,         "setbe",        0x0000960f,     0x0038ffff,     X86SetCC)
inspick( seta,          "seta",         0x0000970f,     0x0038ffff,     X86SetCC)
inspick( sets,          "sets",         0x0000980f,     0x0038ffff,     X86SetCC)
inspick( setns,         "setns",        0x0000990f,     0x0038ffff,     X86SetCC)
inspick( setp,          "setp",         0x00009a0f,     0x0038ffff,     X86SetCC)
inspick( setpo,         "setpo",        0x00009b0f,     0x0038ffff,     X86SetCC)
inspick( setl,          "setl",         0x00009c0f,     0x0038ffff,     X86SetCC)
inspick( setge,         "setge",        0x00009d0f,     0x0038ffff,     X86SetCC)
inspick( setle,         "setle",        0x00009e0f,     0x0038ffff,     X86SetCC)
inspick( setg,          "setg",         0x00009f0f,     0x0038ffff,     X86SetCC)
inspick( shl,           "shl",          0x000020d0,     0x000038fc,     X86Shift_16)
inspick( shl2,          "shl",          0x000020c0,     0x000038fe,     X86ModRMImm_16)
inspick( shr,           "shr",          0x000028d0,     0x000038fc,     X86Shift_16)
inspick( shr2,          "shr",          0x000028c0,     0x000038fe,     X86ModRMImm_16)
inspick( sar,           "sar",          0x000038d0,     0x000038fc,     X86Shift_16)
inspick( sar2,          "sar",          0x000038c0,     0x000038fe,     X86ModRMImm_16)
inspick( sgdt,          "sgdt",         0x0000010f,     0x0038ffff,     X86ModRM_24)
inspick( sidt00,        "sidt",         0x0008010f,     0x00f8ffff,     X86ModRM_24)
inspick( sidt01,        "sidt",         0x0048010f,     0x00f8ffff,     X86ModRM_24)
inspick( sidt10,        "sidt",         0x0088010f,     0x00f8ffff,     X86ModRM_24)
inspick( sldt,          "sldt",         0x0000000f,     0x0038ffff,     X86ModRM_24)
inspick( shld,          "shld",         0x0000a50f,     0x0000ffff,     X86RegModRM_24B)
inspick( shld2,         "shld",         0x0000a40f,     0x0000ffff,     X86RegModRM_24B)
inspick( shrd,          "shrd",         0x0000ad0f,     0x0000ffff,     X86RegModRM_24B)
inspick( shrd2,         "shrd",         0x0000ac0f,     0x0000ffff,     X86RegModRM_24B)
inspick( smsw,          "smsw",         0x0020010f,     0x0038ffff,     X86ModRM_24)
inspick( stc,           "stc",          0x000000f9,     0x000000ff,     X86NoOp_8)
inspick( std,           "std",          0x000000fd,     0x000000ff,     X86NoOp_8)
inspick( sti,           "sti",          0x000000fb,     0x000000ff,     X86NoOp_8)
inspick( stos,          "stos",         0x000000aa,     0x000000fe,     X86String_8)
inspick( str,           "str",          0x0008000f,     0x0038ffff,     X86ModRM_24)
inspick( sub,           "sub",          0x00000028,     0x000000fc,     X86RegModRM_16)
inspick( sub2,          "sub",          0x0000002c,     0x000000fe,     X86ImmAcc_8)
inspick( sub3,          "sub",          0x00002880,     0x000038fc,     X86ModRMImm_16)
inspick( sysenter,      "sysenter",     0x0000340f,     0x0000ffff,     X86NoOp_16)
inspick( sysexit,       "sysexit",      0x0000350f,     0x0000ffff,     X86NoOp_16)
inspick( test,          "test",         0x00000084,     0x000000fe,     X86RegModRM_test)
inspick( test2,         "test",         0x000000a8,     0x000000fe,     X86ImmAcc_8)
inspick( test3,         "test",         0x000000f6,     0x000038fe,     X86ModRMImm_16)
inspick( ud1,           "ud1",          0x0000b90f,     0x0000ffff,     X86NoOp_16)
inspick( ud2,           "ud2",          0x00000b0f,     0x0000ffff,     X86NoOp_16)
inspick( verr,          "verr",         0x0020000f,     0x0038ffff,     X86ModRM_24)
inspick( verw,          "verw",         0x0028000f,     0x0038ffff,     X86ModRM_24)
//inspick( wait,          "wait",         0x0000009b,     0x000000ff,     X86NoOp_8)
inspick( wbinvd,        "wbinvd",       0x0000090f,     0x0000ffff,     X86NoOp_16)
inspick( wrmsr,         "wrmsr",        0x0000300f,     0x0000ffff,     X86NoOp_16)
inspick( xadd,          "xadd",         0x0000c00f,     0x0000feff,     X86RegModRM_24)
inspick( xchg,          "xchg",         0x00000086,     0x000000fe,     X86RegModRM_test)
inspick( xchg2,         "xchg",         0x00000090,     0x000000f8,     X86Reg_8)
inspick( xlat,          "xlat",         0x000000d7,     0x000000ff,     X86NoOp_8)
inspick( xor,           "xor",          0x00000030,     0x000000fc,     X86RegModRM_16)
inspick( xor2,          "xor",          0x00000034,     0x000000fe,     X86ImmAcc_8)
inspick( xor3,          "xor",          0x00003080,     0x000038fc,     X86ModRMImm_16)
// Part of xchg
inspick( nop,           "nop",          0x00000090,     0x00000000,     NULL)

// Floating Point Instructions

inspick( f2xm1,         "f2xm1",        0x0000f0d9,     0x0000ffff,     X86FType4)
inspick( fabs,          "fabs",         0x0000e1d9,     0x0000ffff,     X86FType4)
inspick( fadd00,        "fadd",         0x000000d8,     0x0000f8fb,     X86FType2)
inspick( fadd01,        "fadd",         0x000040d8,     0x0000f8fb,     X86FType2)
inspick( fadd10,        "fadd",         0x000080d8,     0x0000f8fb,     X86FType2)
inspick( fadd11,        "fadd",         0x0000c0d8,     0x0000f8fb,     X86FType3)
inspick( fiadd00,       "fiadd",        0x000000da,     0x0000f8fb,     X86FType2)
inspick( fiadd01,       "fiadd",        0x000040da,     0x0000f8fb,     X86FType2)
inspick( fiadd10,       "fiadd",        0x000080da,     0x0000f8fb,     X86FType2)
inspick( faddp,         "faddp",        0x0000c0de,     0x0000f8ff,     X86FType3)
inspick( fbld00,        "fbld",         0x000020df,     0x0000f8ff,     X86FType1)
inspick( fbld01,        "fbld",         0x000060df,     0x0000f8ff,     X86FType1)
inspick( fbld10,        "fbld",         0x0000a0df,     0x0000f8ff,     X86FType1)
inspick( fbstp00,       "fbstp",        0x000030df,     0x0000f8ff,     X86FType1)
inspick( fbstp01,       "fbstp",        0x000070df,     0x0000f8ff,     X86FType1)
inspick( fbstp10,       "fbstp",        0x0000b0df,     0x0000f8ff,     X86FType1)
inspick( fchs,          "fchs",         0x0000e0d9,     0x0000ffff,     X86FType4)
inspick( fnclex,        "fnclex",       0x0000e2db,     0x0000ffff,     X86FType4)
inspick( fclex,         "fclex",        0x00000000,     0x00000000,     NULL)
inspick( fcom00,        "fcom",         0x000010d8,     0x0000f8fb,     X86FType2)
inspick( fcom01,        "fcom",         0x000050d8,     0x0000f8fb,     X86FType2)
inspick( fcom10,        "fcom",         0x000090d8,     0x0000f8fb,     X86FType2)
inspick( fcom11,        "fcom",         0x0000d0d8,     0x0000f8ff,     X86FType3B)
inspick( fcomp00,       "fcomp",        0x000018d8,     0x0000f8fb,     X86FType2)
inspick( fcomp01,       "fcomp",        0x000058d8,     0x0000f8fb,     X86FType2)
inspick( fcomp10,       "fcomp",        0x000098d8,     0x0000f8fb,     X86FType2)
inspick( fcomp11,       "fcomp",        0x0000d8d8,     0x0000f8ff,     X86FType3B)
inspick( ficom00,       "ficom",        0x000010da,     0x0000f8fb,     X86FType2)
inspick( ficom01,       "ficom",        0x000050da,     0x0000f8fb,     X86FType2)
inspick( ficom10,       "ficom",        0x000090da,     0x0000f8fb,     X86FType2)
inspick( ficomp00,      "ficomp",       0x000018da,     0x0000f8fb,     X86FType2)
inspick( ficomp01,      "ficomp",       0x000058da,     0x0000f8fb,     X86FType2)
inspick( ficomp10,      "ficomp",       0x000098da,     0x0000f8fb,     X86FType2)
inspick( fcompp,        "fcompp",       0x0000d9de,     0x0000ffff,     X86FType4)
inspick( fcos,          "fcos",         0x0000ffd9,     0x0000ffff,     X86FType4)
inspick( fdecstp,       "fdecstp",      0x0000f6d9,     0x0000ffff,     X86FType4)
inspick( fdiv00,        "fdiv",         0x000030d8,     0x0000f8fb,     X86FType2)
inspick( fdiv01,        "fdiv",         0x000070d8,     0x0000f8fb,     X86FType2)
inspick( fdiv10,        "fdiv",         0x0000b0d8,     0x0000f8fb,     X86FType2)
inspick( fdiv11,        "fdiv",         0x0000f0d8,     0x0000f8fb,     X86FType3)
inspick( fidiv00,       "fidiv",        0x000030da,     0x0000f8fb,     X86FType2)
inspick( fidiv01,       "fidiv",        0x000070da,     0x0000f8fb,     X86FType2)
inspick( fidiv10,       "fidiv",        0x0000b0da,     0x0000f8fb,     X86FType2)
inspick( fdivp,         "fdivp",        0x0000f8de,     0x0000f8ff,     X86FType3)
inspick( fdivr00,       "fdivr",        0x000038d8,     0x0000f8fb,     X86FType2)
inspick( fdivr01,       "fdivr",        0x000078d8,     0x0000f8fb,     X86FType2)
inspick( fdivr10,       "fdivr",        0x0000b8d8,     0x0000f8fb,     X86FType2)
inspick( fdivr11,       "fdivr",        0x0000f8d8,     0x0000f8fb,     X86FType3)
inspick( fidivr00,      "fidivr",       0x000038da,     0x0000f8fb,     X86FType2)
inspick( fidivr01,      "fidivr",       0x000078da,     0x0000f8fb,     X86FType2)
inspick( fidivr10,      "fidivr",       0x0000b8da,     0x0000f8fb,     X86FType2)
inspick( fdivrp,        "fdivrp",       0x0000f0de,     0x0000f8ff,     X86FType3)
inspick( fndisi,        "fndisi",       0x0000e1db,     0x0000ffff,     X86FType4)
inspick( fdisi,         "fdisi",        0x00000000,     0x00000000,     NULL)
inspick( fneni,         "fneni",        0x0000e0db,     0x0000ffff,     X86FType4)
inspick( feni,          "feni",         0x00000000,     0x00000000,     NULL)
inspick( ffree,         "ffree",        0x0000c0dd,     0x0000f8ff,     X86FType3B)
inspick( fld00,         "fld",          0x000000d9,     0x0000f8fb,     X86FType2)
inspick( fld01,         "fld",          0x000040d9,     0x0000f8fb,     X86FType2)
inspick( fld10,         "fld",          0x000080d9,     0x0000f8fb,     X86FType2)
inspick( fld11,         "fld",          0x0000c0d9,     0x0000f8ff,     X86FType3B)
inspick( fld8000,       "fld",          0x000028db,     0x0000f8ff,     X86FType1)
inspick( fld8001,       "fld",          0x000068db,     0x0000f8ff,     X86FType1)
inspick( fld8010,       "fld",          0x0000a8db,     0x0000f8ff,     X86FType1)
inspick( fild00,        "fild",         0x000000db,     0x0000f8fb,     X86FType2)
inspick( fild01,        "fild",         0x000040db,     0x0000f8fb,     X86FType2)
inspick( fild10,        "fild",         0x000080db,     0x0000f8fb,     X86FType2)
inspick( fild6400,      "fild",         0x000028df,     0x0000f8ff,     X86FType1)
inspick( fild6401,      "fild",         0x000068df,     0x0000f8ff,     X86FType1)
inspick( fild6410,      "fild",         0x0000a8df,     0x0000f8ff,     X86FType1)
inspick( fincstp,       "fincstp",      0x0000f7d9,     0x0000ffff,     X86FType4)
inspick( fninit,        "fninit",       0x0000e3db,     0x0000ffff,     X86FType4)
inspick( finit,         "finit",        0x00000000,     0x00000000,     NULL)
inspick( fmul00,        "fmul",         0x000008d8,     0x0000f8fb,     X86FType2)
inspick( fmul01,        "fmul",         0x000048d8,     0x0000f8fb,     X86FType2)
inspick( fmul10,        "fmul",         0x000088d8,     0x0000f8fb,     X86FType2)
inspick( fmul11,        "fmul",         0x0000c8d8,     0x0000f8fb,     X86FType3)
inspick( fimul00,       "fimul",        0x000008da,     0x0000f8fb,     X86FType2)
inspick( fimul01,       "fimul",        0x000048da,     0x0000f8fb,     X86FType2)
inspick( fimul10,       "fimul",        0x000088da,     0x0000f8fb,     X86FType2)
inspick( fmulp,         "fmulp",        0x0000c8de,     0x0000f8ff,     X86FType3)
inspick( fsetpm,        "fsetpm",       0x0000e4db,     0x0000ffff,     X86FType4)
inspick( fst00,         "fst",          0x000010d9,     0x0000f8fb,     X86FType2)
inspick( fst01,         "fst",          0x000050d9,     0x0000f8fb,     X86FType2)
inspick( fst10,         "fst",          0x000090d9,     0x0000f8fb,     X86FType2)
inspick( fst11,         "fst",          0x0000d0dd,     0x0000f8ff,     X86FType3B)
inspick( fstp00,        "fstp",         0x000018d9,     0x0000f8fb,     X86FType2)
inspick( fstp01,        "fstp",         0x000058d9,     0x0000f8fb,     X86FType2)
inspick( fstp10,        "fstp",         0x000098d9,     0x0000f8fb,     X86FType2)
inspick( fstp11,        "fstp",         0x0000d8dd,     0x0000f8ff,     X86FType3B)
inspick( fstp8000,      "fstp",         0x000038db,     0x0000f8ff,     X86FType1)
inspick( fstp8001,      "fstp",         0x000078db,     0x0000f8ff,     X86FType1)
inspick( fstp8010,      "fstp",         0x0000b8db,     0x0000f8ff,     X86FType1)
inspick( fist00,        "fist",         0x000010db,     0x0000f8fb,     X86FType2)
inspick( fist01,        "fist",         0x000050db,     0x0000f8fb,     X86FType2)
inspick( fist10,        "fist",         0x000090db,     0x0000f8fb,     X86FType2)
inspick( fistp00,       "fistp",        0x000018db,     0x0000f8fb,     X86FType2)
inspick( fistp01,       "fistp",        0x000058db,     0x0000f8fb,     X86FType2)
inspick( fistp10,       "fistp",        0x000098db,     0x0000f8fb,     X86FType2)
inspick( fistp6400,     "fistp",        0x000038df,     0x0000f8ff,     X86FType1)
inspick( fistp6401,     "fistp",        0x000078df,     0x0000f8ff,     X86FType1)
inspick( fistp6410,     "fistp",        0x0000b8df,     0x0000f8ff,     X86FType1)
inspick( fisttp00,      "fisttp",       0x000008db,     0x0000f8fb,     X86FType2) // SSE3
inspick( fisttp01,      "fisttp",       0x000048db,     0x0000f8fb,     X86FType2) // SSE3
inspick( fisttp10,      "fisttp",       0x000088db,     0x0000f8fb,     X86FType2) // SSE3
inspick( fisttp6400,    "fisttp",       0x000008dd,     0x0000f8ff,     X86FType1) // SSE3
inspick( fisttp6401,    "fisttp",       0x000048dd,     0x0000f8ff,     X86FType1) // SSE3
inspick( fisttp6410,    "fisttp",       0x000088dd,     0x0000f8ff,     X86FType1) // SSE3
inspick( fsub00,        "fsub",         0x000020d8,     0x0000f8fb,     X86FType2)
inspick( fsub01,        "fsub",         0x000060d8,     0x0000f8fb,     X86FType2)
inspick( fsub10,        "fsub",         0x0000a0d8,     0x0000f8fb,     X86FType2)
inspick( fsub11,        "fsub",         0x0000e0d8,     0x0000f8fb,     X86FType3)
inspick( fisub00,       "fisub",        0x000020da,     0x0000f8fb,     X86FType2)
inspick( fisub01,       "fisub",        0x000060da,     0x0000f8fb,     X86FType2)
inspick( fisub10,       "fisub",        0x0000a0da,     0x0000f8fb,     X86FType2)
inspick( fsubp,         "fsubp",        0x0000e8de,     0x0000f8ff,     X86FType3)
inspick( fsubr00,       "fsubr",        0x000028d8,     0x0000f8fb,     X86FType2)
inspick( fsubr01,       "fsubr",        0x000068d8,     0x0000f8fb,     X86FType2)
inspick( fsubr10,       "fsubr",        0x0000a8d8,     0x0000f8fb,     X86FType2)
inspick( fsubr11,       "fsubr",        0x0000e8d8,     0x0000f8fb,     X86FType3)
inspick( fisubr00,      "fisubr",       0x000028da,     0x0000f8fb,     X86FType2)
inspick( fisubr01,      "fisubr",       0x000068da,     0x0000f8fb,     X86FType2)
inspick( fisubr10,      "fisubr",       0x0000a8da,     0x0000f8fb,     X86FType2)
inspick( fsubrp,        "fsubrp",       0x0000e0de,     0x0000f8ff,     X86FType3)
inspick( fld1,          "fld1",         0x0000e8d9,     0x0000ffff,     X86FType4)
inspick( fldcw00,       "fldcw",        0x000028d9,     0x0000f8ff,     X86FType1)
inspick( fldcw01,       "fldcw",        0x000068d9,     0x0000f8ff,     X86FType1)
inspick( fldcw10,       "fldcw",        0x0000a8d9,     0x0000f8ff,     X86FType1)
inspick( fldenv00,      "fldenv",       0x000020d9,     0x0000f8ff,     X86FTypeEnv)
inspick( fldenv01,      "fldenv",       0x000060d9,     0x0000f8ff,     X86FTypeEnv)
inspick( fldenv10,      "fldenv",       0x0000a0d9,     0x0000f8ff,     X86FTypeEnv)
inspick( fldenvw,       "fldenvw",      0x00000000,     0x00000000,     NULL)
inspick( fldenvd,       "fldenvd",      0x00000000,     0x00000000,     NULL)
inspick( fldl2t,        "fldl2t",       0x0000e9d9,     0x0000ffff,     X86FType4)
inspick( fldl2e,        "fldl2e",       0x0000ead9,     0x0000ffff,     X86FType4)
inspick( fldpi,         "fldpi",        0x0000ebd9,     0x0000ffff,     X86FType4)
inspick( fldlg2,        "fldlg2",       0x0000ecd9,     0x0000ffff,     X86FType4)
inspick( fldln2,        "fldln2",       0x0000edd9,     0x0000ffff,     X86FType4)
inspick( fldz,          "fldz",         0x0000eed9,     0x0000ffff,     X86FType4)
inspick( fnop,          "fnop",         0x0000d0d9,     0x0000ffff,     X86FType4)
inspick( fptan,         "fptan",        0x0000f2d9,     0x0000ffff,     X86FType4)
inspick( fpatan,        "fpatan",       0x0000f3d9,     0x0000ffff,     X86FType4)
inspick( fprem1,        "fprem1",       0x0000f5d9,     0x0000ffff,     X86FType4)
inspick( fprem,         "fprem",        0x0000f8d9,     0x0000ffff,     X86FType4)
inspick( frndint,       "frndint",      0x0000fcd9,     0x0000ffff,     X86FType4)
inspick( frstor00,      "frstor",       0x000020dd,     0x0000f8ff,     X86FTypeEnv)
inspick( frstor01,      "frstor",       0x000060dd,     0x0000f8ff,     X86FTypeEnv)
inspick( frstor10,      "frstor",       0x0000a0dd,     0x0000f8ff,     X86FTypeEnv)
inspick( frstorw,       "frstorw",      0x00000000,     0x00000000,     NULL)
inspick( frstord,       "frstord",      0x00000000,     0x00000000,     NULL)
inspick( fnsave00,      "fnsave",       0x000030dd,     0x0000f8ff,     X86FTypeEnv)
inspick( fnsave01,      "fnsave",       0x000070dd,     0x0000f8ff,     X86FTypeEnv)
inspick( fnsave10,      "fnsave",       0x0000b0dd,     0x0000f8ff,     X86FTypeEnv)
inspick( fnsavew,       "fnsavew",      0x00000000,     0x00000000,     NULL)
inspick( fnsaved,       "fnsaved",      0x00000000,     0x00000000,     NULL)
inspick( fsave,         "fsave",        0x00000000,     0x00000000,     NULL)
inspick( fsavew,        "fsavew",       0x00000000,     0x00000000,     NULL)
inspick( fsaved,        "fsaved",       0x00000000,     0x00000000,     NULL)
inspick( fcmovb,        "fcmovb",       0x0000c0da,     0x0000f8ff,     X86FTypeCond)
inspick( fcmovnb,       "fcmovnb",      0x0000c0db,     0x0000f8ff,     X86FTypeCond)
inspick( fcmove,        "fcmove",       0x0000c8da,     0x0000f8ff,     X86FTypeCond)
inspick( fcmovne,       "fcmovne",      0x0000c8db,     0x0000f8ff,     X86FTypeCond)
inspick( fcmovbe,       "fcmovbe",      0x0000d0da,     0x0000f8ff,     X86FTypeCond)
inspick( fcmovnbe,      "fcmovnbe",     0x0000d0db,     0x0000f8ff,     X86FTypeCond)
inspick( fcmovu,        "fcmovu",       0x0000d8da,     0x0000f8ff,     X86FTypeCond)
inspick( fcmovnu,       "fcmovnu",      0x0000d8db,     0x0000f8ff,     X86FTypeCond)
inspick( fsqrt,         "fsqrt",        0x0000fad9,     0x0000ffff,     X86FType4)
inspick( fsincos,       "fsincos",      0x0000fbd9,     0x0000ffff,     X86FType4)
inspick( fscale,        "fscale",       0x0000fdd9,     0x0000ffff,     X86FType4)
inspick( fsin,          "fsin",         0x0000fed9,     0x0000ffff,     X86FType4)
inspick( fnstcw00,      "fnstcw",       0x000038d9,     0x0000f8ff,     X86FType1)
inspick( fnstcw01,      "fnstcw",       0x000078d9,     0x0000f8ff,     X86FType1)
inspick( fnstcw10,      "fnstcw",       0x0000b8d9,     0x0000f8ff,     X86FType1)
inspick( fstcw,         "fstcw",        0x00000000,     0x00000000,     NULL)
inspick( fnstenv00,     "fnstenv",      0x000030d9,     0x0000f8ff,     X86FTypeEnv)
inspick( fnstenv01,     "fnstenv",      0x000070d9,     0x0000f8ff,     X86FTypeEnv)
inspick( fnstenv10,     "fnstenv",      0x0000b0d9,     0x0000f8ff,     X86FTypeEnv)
inspick( fnstenvw,      "fnstenvw",     0x00000000,     0x00000000,     NULL)
inspick( fnstenvd,      "fnstenvd",     0x00000000,     0x00000000,     NULL)
inspick( fstenv,        "fstenv",       0x00000000,     0x00000000,     NULL)
inspick( fstenvw,       "fstenvw",      0x00000000,     0x00000000,     NULL)
inspick( fstenvd,       "fstenvd",      0x00000000,     0x00000000,     NULL)
inspick( fnstsw00,      "fnstsw",       0x000038dd,     0x0000f8ff,     X86FType1)
inspick( fnstsw01,      "fnstsw",       0x000078dd,     0x0000f8ff,     X86FType1)
inspick( fnstsw10,      "fnstsw",       0x0000b8dd,     0x0000f8ff,     X86FType1)
inspick( fstsw,         "fstsw",        0x00000000,     0x00000000,     NULL)
inspick( fnstsw2,       "fnstsw",       0x0000e0df,     0x0000ffff,     X86FTypeFSTSWAX)
inspick( fstsw2,        "fstsw",        0x00000000,     0x00000000,     NULL)
inspick( ftst,          "ftst",         0x0000e4d9,     0x0000ffff,     X86FType4)
inspick( fucom,         "fucom",        0x0000e0dd,     0x0000f8ff,     X86FType3B)
inspick( fucomp,        "fucomp",       0x0000e8dd,     0x0000f8ff,     X86FType3B)
inspick( fucompp,       "fucompp",      0x0000e9da,     0x0000ffff,     X86FType4)
inspick( fxam,          "fxam",         0x0000e5d9,     0x0000ffff,     X86FType4)
inspick( fxch,          "fxch",         0x0000c8d9,     0x0000f8ff,     X86FType3B)
inspick( fxrstor00,     "fxrstor",      0x0008ae0f,     0x00f8ffff,     X86ModRM_24) // MMX,SSEx
inspick( fxrstor01,     "fxrstor",      0x0048ae0f,     0x00f8ffff,     X86ModRM_24) // MMX,SSEx
inspick( fxrstor10,     "fxrstor",      0x0088ae0f,     0x00f8ffff,     X86ModRM_24) // MMX,SSEx
inspick( fxsave00,      "fxsave",       0x0000ae0f,     0x00f8ffff,     X86ModRM_24) // MMX,SSEx
inspick( fxsave01,      "fxsave",       0x0040ae0f,     0x00f8ffff,     X86ModRM_24) // MMX,SSEx
inspick( fxsave10,      "fxsave",       0x0080ae0f,     0x00f8ffff,     X86ModRM_24) // MMX,SSEx
inspick( fxtract,       "fxtract",      0x0000f4d9,     0x0000ffff,     X86FType4)
inspick( fyl2x,         "fyl2x",        0x0000f1d9,     0x0000ffff,     X86FType4)
inspick( fyl2xp1,       "fyl2xp1",      0x0000f9d9,     0x0000ffff,     X86FType4)
inspick( fcomi,         "fcomi",        0x0000f0db,     0x0000f8ff,     X86FType3C)
inspick( fcomip,        "fcomip",       0x0000f0df,     0x0000f8ff,     X86FType3C)
inspick( fucomi,        "fucomi",       0x0000e8db,     0x0000f8ff,     X86FType3C)
inspick( fucomip,       "fucomip",      0x0000e8df,     0x0000f8ff,     X86FType3C)

// AMD 3DNow! Instructions

inspick( femms,         "femms",        0x00000e0f,     0x0000ffff,     X86NoOp_16)
inspick( prefetch,      "prefetch",     0x00000d0f,     0x0018ffff,     X86ModRM_24)
inspick( prefetchw,     "prefetchw",    0x00080d0f,     0x0018ffff,     X86ModRM_24)

// AMD 3DNow! Instructions with suffix

inspick( prefix3dnow,   "3dnow",        0x00000f0f,     0x0000ffff,     X86_3DNow)
inspick( pavgusb,       "pavgusb",      0x000000bf,     0x00000000,     NULL)
inspick( pf2id,         "pf2id",        0x0000001d,     0x00000000,     NULL)
inspick( pf2iw,         "pf2iw",        0x0000001c,     0x00000000,     NULL)
inspick( pfacc,         "pfacc",        0x000000ae,     0x00000000,     NULL)
inspick( pfadd,         "pfadd",        0x0000009e,     0x00000000,     NULL)
inspick( pfcmpeq,       "pfcmpeq",      0x000000b0,     0x00000000,     NULL)
inspick( pfcmpge,       "pfcmpge",      0x00000090,     0x00000000,     NULL)
inspick( pfcmpgt,       "pfcmpgt",      0x000000a0,     0x00000000,     NULL)
inspick( pfmax,         "pfmax",        0x000000a4,     0x00000000,     NULL)
inspick( pfmin,         "pfmin",        0x00000094,     0x00000000,     NULL)
inspick( pfmul,         "pfmul",        0x000000b4,     0x00000000,     NULL)
inspick( pfnacc,        "pfnacc",       0x0000008a,     0x00000000,     NULL)
inspick( pfpnacc,       "pfpnacc",      0x0000008e,     0x00000000,     NULL)
inspick( pfrcp,         "pfrcp",        0x00000096,     0x00000000,     NULL)
inspick( pfrcpit1,      "pfrcpit1",     0x000000a6,     0x00000000,     NULL)
inspick( pfrcpit2,      "pfrcpit2",     0x000000b6,     0x00000000,     NULL)
inspick( pfrsqit1,      "pfrsqit1",     0x000000a7,     0x00000000,     NULL)
inspick( pfrsqrt,       "pfrsqrt",      0x00000097,     0x00000000,     NULL)
inspick( pfsub,         "pfsub",        0x0000009a,     0x00000000,     NULL)
inspick( pfsubr,        "pfsubr",       0x000000aa,     0x00000000,     NULL)
inspick( pi2fd,         "pi2fd",        0x0000000d,     0x00000000,     NULL)
inspick( pi2fw,         "pi2fw",        0x0000000c,     0x00000000,     NULL)
inspick( pmulhrw,       "pmulhrw",      0x000000b7,     0x00000000,     NULL)
inspick( pswapd,        "pswapd",       0x000000bb,     0x00000000,     NULL)
