/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


//
// RCAT : character concatenation routines
//

#include "ftnstd.h"
#include "rtenv.h"

#include <stdarg.h>
#include <string.h>


void    Cat( int num_args, string *dest, ... ) {
//==============================================

// Perform character concatenation.

    int         dest_len;
    int         src_len;
    char        *dest_ptr;
    string      *src;
    va_list     parminfo;

    dest_len = dest->len;
    dest_ptr = dest->strptr;
    va_start( parminfo, dest );
    for( ;; ) {
        if( dest_len == 0 ) break;
        if( num_args == 0 ) {
            memset( dest_ptr, ' ', dest_len );
            break;
        }
        src = va_arg( parminfo, string * );
        src_len = src->len;
        if( dest_len < src_len ) {
            src_len = dest_len;
        }
        memcpy( dest_ptr, src->strptr, src_len );
        dest_len -= src_len;
        dest_ptr += src_len;
        --num_args;
    }
    va_end( parminfo );
}
