:cmt
:cmt GML Macros used:
:cmt
:cmt    :chain. <char> <usage>                  options that start with <char>
:cmt                                            can be chained together i.e.,
:cmt                                            -oa -ox -ot => -oaxt
:cmt    :option. <option> <synonym> ...         define an option
:cmt    :target. <arch1> <arch2> ...            valid for these architectures
:cmt    :ntarget. <arch1> <arch2> ...           not valid for these architectures
:cmt    :immediate. <fn>                        <fn> is called when option parsed
:cmt    :code. <source-code>                    <source-code> is executed when option parsed
:cmt    :enumerate. <field> [<value>]           option is one value in <name> enumeration
:cmt    :number. [<fn>] [<default>]             =<n> allowed; call <fn> to check
:cmt    :id. [<fn>]                             =<id> req'd; call <fn> to check
:cmt    :char.[<fn>]                            =<char> req'd; call <fn> to check
:cmt    :file.                                  =<file> req'd
:cmt    :path.                                  =<path> req'd
:cmt    :special. <fn> [<arg_usage_text>]       call <fn> to parse option
:cmt    :optional.                              value is optional
:cmt    :noequal.                               args can't have option '='
:cmt    :argequal. <char>                       args use <char> instead of '='
:cmt    :internal.                              option is undocumented
:cmt    :prefix.                                prefix of a :special. option
:cmt    :usage. <text>                          English usage text
:cmt    :jusage. <text>                         Japanese usage text
:cmt    :title.                                 English title usage text
:cmt    :jtitle.                                Japanese title usage text
:cmt    :page.                                  text for paging usage message
:cmt    :nochain.                               option isn't chained with other options
:cmt    :timestamp.                             kludge to record "when" an option
:cmt                                            is set so that dependencies
:cmt                                            between options can be simulated

:cmt    where:
:cmt        <arch>:     i86, 386, axp, any, dbg, qnx, ppc, linux, sparc

:cmt    Translations are required for the :jtitle. and :jusage. tags
:cmt    if there is no text associated with the tag.

:title. Usage: wpp [options] file [options]
:jtitle. gp@: wpp [options] file [options]
:target. i86
:title. Usage: wpp386 [options] file [options]
:jtitle. gp@: wpp386 [options] file [options]
:target. 386
:title. Usage: wppaxp [options] file [options]
:jtitle. gp@: wppaxp [options] file [options]
:target. axp
:title. Usage: wppppc [options] file [options]
:jtitle. gp@: wppppc [options] file [options]
:target. ppc
:title. Options:
:jtitle. IvV:
:target. any
:title. \t    ( /option is also accepted )
:jtitle. \t    ( /optiongpł܂ )
:target. i86 386 axp ppc
:ntarget. qnx linux
:title. \t    ( '=' is always optional, i.e., -w4 -zp4 )
:jtitle. \t    ( '='͏ɏȗ\łB܂ -w4 -zp4 )
:target. any

:page. (Press return to continue)
:jusage. (s邽߂ɉL[ĉ)

:chain. p preprocess source file
:jusage. p \[Xt@CO܂
:chain. o optimization
:jusage. o œK

:option. 0
:target. i86
:enumerate. arch_i86
:usage. 8086 instructions
:jusage. 8086 

:option. 1
:target. i86
:enumerate. arch_i86
:usage. 186 instructions
:jusage. 186 

:option. 2
:target. i86
:enumerate. arch_i86
:usage. 286 instructions
:jusage. 286 

:option. 3
:target. i86
:enumerate. arch_i86
:usage. 386 instructions
:jusage. 386 

:option. 4
:target. i86
:enumerate. arch_i86
:usage. 386 instructions, optimize for 486
:jusage. 386 , 486pœK

:option. 5
:target. i86
:enumerate. arch_i86
:usage. 386 instructions, optimize for Pentium
:jusage. 386 , PentiumpœK

:option. 6
:target. i86
:enumerate. arch_i86
:usage. 386 instructions, optimize for Pentium Pro
:jusage. 386 , Pentium PropœK

:option. 3r 3
:target. 386
:enumerate. arch_386
:usage. 386 register calling conventions
:jusage. 386 WX^ĂяoK

:option. 3s
:target. 386
:enumerate. arch_386
:usage. 386 stack calling conventions
:jusage. 386 X^bNĂяoK

:option. 4r 4
:target. 386
:enumerate. arch_386
:usage. 486 register calling conventions
:jusage. 486 WX^ĂяoK

:option. 4s
:target. 386
:enumerate. arch_386
:usage. 486 stack calling conventions
:jusage. 486 X^bNĂяoK

:option. 5r 5
:target. 386
:enumerate. arch_386
:usage. Pentium register calling conventions
:jusage. Pentium WX^ĂяoK

:option. 5s
:target. 386
:enumerate. arch_386
:usage. Pentium stack calling conventions
:jusage. Pentium X^bNĂяoK

:option. 6r 6
:target. 386
:enumerate. arch_386
:usage. Pentium Pro register calling conventions
:jusage. Pentium Pro WX^ĂяoK

:option. 6s
:target. 386
:enumerate. arch_386
:usage. Pentium Pro stack calling conventions
:jusage. Pentium Pro X^bNĂяoK

:option. as
:target. axp
:usage. assume short integers are aligned
:jusage. short 񂵂ĂƉ肵܂

:option. bc
:target. any
:usage. build target is a console application
:jusage. \z^[Qbg̓R\[AvP[Vł

:option. bd
:target. any
:usage. build target is a dynamic link library (DLL)
:jusage. \z^[Qbg̓_Ci~bNNCuł(DLL)

:option. bg
:target. any
:usage. build target is a GUI application
:jusage. \z^[QbgGUIAvP[Vł

:option. bm
:target. any
:usage. build target is a multi-thread environment
:jusage. \z^[Qbg̓}`Xbhł

:option. br
:target. 386 axp ppc
:usage. build target uses DLL version of C/C++ run-time library
:jusage. \z^[QbgDLLłC/C++sCugp܂

:option. bw
:target. any
:usage. build target is a default windowing application
:jusage. \z^[Qbg̓ftHgEBhEAvP[Vł

:option. bt
:target. any
:id.
:optional.
:usage. build target is operating system <id>
:jusage. \z^[Qbg̓Iy[eBOVXe <id>

:option. d0
:target. any
:enumerate. debug_info
:timestamp.
:usage. no debugging information
:jusage. fobO͂܂

:option. d1
:target. any
:enumerate. debug_info
:timestamp.
:usage. line number debugging information
:jusage. sԍfobO

:option. d2
:target. any
:enumerate. debug_info
:timestamp.
:usage. symbolic debugging information
:jusage. SV{fobO

:option. d2i
:target. any
:enumerate. debug_info
:timestamp.
:usage. -d2 and debug inlines; emit inlines as COMDATs
:jusage. CC֐̓WJȂ-d2;CC֐COMDATƂďo

:option. d2s
:target. any
:enumerate. debug_info
:timestamp.
:usage. -d2 and debug inlines; emit inlines as statics
:jusage. CC֐̓WJȂ-d2;CC֐staticƂďo

:option. d2t d2~
:target. any
:enumerate. debug_info
:timestamp.
:usage. -d2 but without type names
:jusage. ^Ȃ̊SV{fobO

:option. d3
:target. any
:enumerate. debug_info
:timestamp.
:usage. symbolic debugging information with unreferenced type names
:jusage. QƂĂȂ^܂ފSV{fobO

:option. d3i
:target. any
:enumerate. debug_info
:timestamp.
:usage. -d3 and debug inlines; emit inlines as COMDATs
:jusage. CC֐̓WJȂ-d3;CC֐COMDATƂďo

:option. d3s
:target. any
:enumerate. debug_info
:timestamp.
:usage. -d3 and debug inlines; emit inlines as statics
:jusage. CC֐̓WJȂ-d3;CC֐staticƂďo

:option. d+
:target. any
:special. scanDefinePlus
:usage. allow extended -d macro definitions
:jusage. gꂽ -d }N`܂

:option. db
:target. any
:prefix.
:usage. generate browsing information
:jusage. uEY𐶐܂

:option. d
:target. any
:special. scanDefine <name>[=text]
:usage. same as #define name [text] before compilation
:jusage. RpCO #define name [text] Ɠ

:option. ecc
:target. i86 386
:enumerate. intel_call_conv
:usage. set default calling convention to __cdecl
:jusage.

:option. ecd
:target. i86 386
:enumerate. intel_call_conv
:usage. set default calling convention to __stdcall
:jusage.

:option. ecf
:target. i86 386
:enumerate. intel_call_conv
:usage. set default calling convention to __fastcall
:jusage.

:option. eco
:target. dbg
:ntarget. axp qnx ppc linux sparc
:enumerate. intel_call_conv
:usage. set default calling convention to _Optlink
:jusage.

:option. ecp
:target. i86 386
:enumerate. intel_call_conv
:usage. set default calling convention to __pascal
:jusage.

:option. ecr
:target. i86 386
:enumerate. intel_call_conv
:usage. set default calling convention to __fortran
:jusage.

:option. ecs
:target. i86 386
:enumerate. intel_call_conv
:usage. set default calling convention to __syscall
:jusage.

:option. ecw
:target. i86 386
:enumerate. intel_call_conv
:usage. set default calling convention to __watcall (default)
:jusage.

:option. ee
:target. any
:usage. call epilogue hook routine
:jusage. Gs[OtbN[`Ăяo܂

:option. ef
:target. any
:usage. use full path names in error messages
:jusage. G[bZ[WɊSpXgp܂

:option. ei
:target. any
:enumerate. enum_size
:usage. force enum base type to use at least an int
:jusage. enum^̃x[X^Ƃint^ȏ̑傫gp܂

:option. em
:target. any
:enumerate. enum_size
:usage. force enum base type to use minimum integral type
:jusage. enum^̃x[X^Ƃčŏ̐^gp܂

:option. en
:target. any
:usage. emit routine names in the code segment
:jusage. [`R[hZOgɏo͂܂

:option. ep
:target. any
:number. checkPrologSize 0
:usage. call prologue hook routine with <num> stack bytes available
:jusage. <num>oCg̃X^bNgpv[OtbN[`Ăяo܂

:option. eq
:target. any
:immediate. handleOptionEQ
:usage. do not display error messages (but still write to .err file)
:jusage. G[bZ[W\܂(.errt@Cɂ͏݂܂)

:option. er
:target. any
:usage. do not recover from undefined symbol errors
:jusage. `V{G[񕜂܂

:option. et
:target. 386
:usage. emit Pentium profiling code
:jusage. Pentiumvt@COR[h𐶐܂

:option. et0
:target. 386
:usage. emit Pentium-CTR0 profiling code
:jusage. Pentium-CTR0vt@COR[h𐶐܂

:option. etp
:target. 386
:internal.
:usage. emit Timing for Profiler
:jusage. vt@C̃^C~Oo͂܂

:option. esp
:target. 386
:internal.
:usage. emit Statement counting for Profiler
:jusage. vt@CpXe[ggJEeBOo͂܂

:option. ew
:target. any
:immediate. handleOptionEW
:usage. alternate error message formatting
:jusage. ʂ̃G[bZ[W`gp܂

:option. ez
:target. 386
:usage. generate PharLap EZ-OMF object files
:jusage. PharLap EZ-OMFIuWFNgt@C𐶐܂

:option. e
:target. any
:number. checkErrorLimit
:usage. set limit on number of error messages
:jusage. G[bZ[W̐ݒ肵܂

:option. fbi
:target. any
:special. scanFBI
:internal.
:usage. generate browsing information
:jusage. uEY𐶐܂

:option. fbx
:target. any
:special. scanFBX
:internal.
:usage. do not generate browsing information
:jusage. uEY𐶐܂

:option. fc
:target. any
:file.
:immediate. handleOptionFC
:usage. specify file of command lines to be batch processed
:jusage. ob`R}hC̃t@Cw肵܂

:option. fh
:target. any
:file.
:optional.
:timestamp.
:usage. use pre-compiled header (PCH) file
:jusage. vRpCwb_[(PCH)gp܂

:option. fhd
:target. any
:usage. store debug info for PCH once (DWARF only)
:jusage. PCHpfobO1xi[܂(DWARF̂)

:option. fhq
:target. any
:file.
:optional.
:timestamp.
:usage. do not display PCH activity warnings
:jusage. PCHgpbZ[W\܂

:option. fhw
:target. any
:usage. force compiler to write PCH (will never read)
:jusage. PCH݂ɋ܂ (ǂ݂܂)

:option. fhwe
:target. any
:usage. don't count PCH activity warnings (see -we option)
:jusage. PCHgpbZ[WG[ƂĈ܂(-weIvVQ)

:option. fhr
:target. any
:usage. force compiler to read PCH (will never write)
:jusage. PCHǂݍ݂ɋ܂ (܂)

:option. fhr!
:target. any
:usage. compiler will read PCH without checking include files
:jusage. RpC̓CN[ht@C`FbN邱ƂȂAPCHǂݍ݂܂
:internal.

:option. fi
:target. any
:file.
:usage. force <file> to be included
:jusage. I<file>CN[h܂

:option. fo
:target. any
:file.
:optional.
:usage. set object or preprocessor output file name
:jusage. IuWFNg܂̓vvZbT̏o̓t@Cݒ肵܂

:option. fr
:target. any
:file.
:optional.
:usage. set error file name
:jusage. G[t@Cݒ肵܂

:option. ft
:target. any
:enumerate. file_83
:usage. check for truncated versions of file names
:jusage. ؂l߂t@C`FbN܂

:option. fx
:target. any
:enumerate. file_83
:usage. do not check for truncated versions of file names
:jusage. ؂l߂t@C`FbN܂

:option. fzh
:target. any
:usage. do not automatically postfix include file names
:jusage. do not automatically postfix include file names

:option. fzs
:target. any
:usage. do not automatically postfix source file names
:jusage. do not automatically postfix source file names

:option. 87d
:target. i86 386
:number. CmdX86CheckStack87 0
:enumerate. intel_fpu_model
:internal.
:usage. inline 80x87 instructions with specified depth
:jusage. w肵[̃CC80x87

:option. fpc
:target. i86 386
:enumerate. intel_fpu_model
:usage. calls to floating-point library
:jusage. _CuĂяo܂

:option. fpi
:target. i86 386
:enumerate. intel_fpu_model
:usage. inline 80x87 instructions with emulation
:jusage. G~[VtCC80x87

:option. fpi87
:target. i86 386
:enumerate. intel_fpu_model
:usage. inline 80x87 instructions
:jusage. CC80x87

:option. fp2 fp287
:target. i86 386
:enumerate. intel_fpu_level
:usage. generate 287 floating-point code
:jusage. 287_R[h𐶐܂

:option. fp3 fp387
:target. i86 386
:enumerate. intel_fpu_level
:usage. generate 387 floating-point code
:jusage. 387_R[h𐶐܂

:option. fp5
:target. i86 386
:enumerate. intel_fpu_level
:usage. optimize floating-point for Pentium
:jusage. Pentiump_œK܂

:option. fp6
:target. i86 386
:enumerate. intel_fpu_level
:usage. optimize floating-point for Pentium Pro
:jusage. Pentium Prop_œK܂

:option. fpr
:target. i86 386
:usage. generate backward compatible 80x87 code
:jusage. o[W9.0ȑOƌ݊80x87R[h𐶐܂

:option. fpd
:target. i86 386
:usage. enable Pentium FDIV check
:jusage. Pentium FDIV`FbN܂

:option. g
:target. i86 386
:id.
:usage. set code group name
:jusage. R[hO[vݒ肵܂

:option. hw
:target. i86 386 
:enumerate. dbg_output
:usage. generate Watcom debugging information
:jusage. WatcomfobO𐶐܂

:option. hd
:target. i86 386 axp ppc
:enumerate. dbg_output
:usage. generate DWARF debugging information
:jusage. DWARFfobO𐶐܂

:option. hda
:target. i86 386 axp ppc
:enumerate. dbg_output
:usage. generate DWARF debugging information
:jusage. DWARFfobO𐶐܂
:internal.

:option. hc
:target. i86 386 axp ppc
:enumerate. dbg_output
:usage. generate Codeview debugging information
:jusage. CodeviewfobO𐶐܂

:option. i
:target. any
:path.
:usage. add another include path
:jusage. CN[hpXǉ܂

:option. j
:target. any
:usage. change char default from unsigned to signed
:jusage. char^̃ftHgunsignedsignedɕύX܂

:option. jw
:target. any
:usage. warn about default char promotion to int
:jusage.
:internal.

:option. k
:target. any
:usage. continue processing files (ignore errors)
:jusage. t@C𑱍s܂(G[𖳎܂)

:option. la
:target. axp
:usage. output Alpha assembly listing
:jusage. AlphaAZuXgo͂܂
:internal.

:option. lo
:target. axp
:usage. output OWL listing
:jusage. OWLXgo͂܂
:internal.

:option. mc
:target. i86 386
:enumerate. mem_model
:usage. compact memory model (small code/large data)
:jusage. RpNgf(X[R[h/[Wf[^)

:option. mf
:target. 386
:enumerate. mem_model
:usage. flat memory model (small code/small data assuming CS=DS=SS=ES)
:jusage. tbgf(X[R[h/CS=DS=SS=ES肵X[f[^)

:option. mfi
:target. 386
:enumerate. mem_model
:usage. flat memory model (interrupt functions will assume flat model)
:jusage. t;g?(荞݊֐t;g?łƉ肷)

:option. mh
:target. i86
:enumerate. mem_model
:usage. huge memory model (large code/huge data)
:jusage. q[Wf([WR[h/q[Wf[^)

:option. ml
:target. i86 386
:enumerate. mem_model
:usage. large memory model (large code/large data)
:jusage. [Wf([WR[h/[Wf[^)

:option. mm
:target. i86 386
:enumerate. mem_model
:usage. medium memory model (large code/small data)
:jusage. ~fBAf([WR[h/X[f[^)

:option. ms
:target. i86 386
:enumerate. mem_model
:usage. small memory model (small code/small data)
:jusage. X[f(X[R[h/X[f[^)

:option. na
:target. any
:usage. disable automatic inclusion of _ialias.h
:jusage. X[f(X[R[h/X[f[^)

:option. nc
:target. i86 386
:id.
:usage. set code class name
:jusage. R[hNXݒ肵܂

:option. nd
:target. i86 386
:id.
:usage. set data segment name
:jusage. f[^ZOgݒ肵܂

:option. nm
:target. i86 386 axp ppc
:file.
:usage. set module name
:jusage. W[ݒ肵܂

:option. nt
:target. i86 386
:id.
:usage. set name of text segment
:jusage. eLXgZOgݒ肵܂

:option. oa
:target. any
:usage. relax aliasing constraints
:jusage. GCAX̐ɘa܂

:option. ob
:target. any
:usage. enable branch prediction
:jusage. \ɂR[h𐶐܂

:option. oc
:target. i86 386 axp ppc
:usage. disable <call followed by return> to <jump> optimization
:jusage. <call followed by return><jump>̍œK𖳌ɂ܂

:option. od
:target. any
:enumerate. opt_level
:timestamp.
:usage. disable all optimizations
:jusage. ׂĂ̍œK𖳌ɂ܂

:option. oe
:target. any
:number. checkOENumber 100
:usage. expand user functions inline (<num> controls max size)
:jusage. [U֐CCWJ܂(<num>͍ő廲ނ𐧌䂵܂)

:option. of
:target. i86 386
:usage. generate traceable stack frames as needed
:jusage. Kvɉăg[X\ȃX^bNt[𐶐܂

:option. of+
:target. i86 386
:usage. always generate traceable stack frames
:jusage. Ƀg[X\ȃX^bNt[𐶐܂

:option. oh
:target. any
:usage. enable repeated optimizations (longer compiles)
:jusage. œKJԂ܂(RpCȂ܂)

:option. oi
:target. any
:usage. expand intrinsic functions inline
:jusage. g݊֐CCWJ܂

:option. oi+
:target. any
:usage. enable maximum inlining depth
:jusage. CCWJ̐[őɂ܂

:option. ok
:target. any
:usage. enable control flow prologues and epilogues
:jusage. v[OƃGs[Ot[\ɂ܂

:option. ol
:target. any
:usage. enable loop optimizations
:jusage. [vœK\ɂ܂

:option. ol+
:target. any
:usage. enable loop unrolling optimizations
:jusage. [vEA[OŃ[vœK\ɂ܂

:option. om
:target. i86 386 axp ppc
:usage. generate inline code for math functions
:jusage. Zp֐CC80x87R[hœWJĐ܂

:option. on
:target. any
:usage. allow numerically unstable optimizations
:jusage. lIɂsmɂȂ邪荂ȍœK\ɂ܂

:option. oo
:target. any
:usage. continue compilation if low on memory
:jusage. ȂȂĂRpCp܂

:option. op
:target. any
:usage. generate consistent floating-point results
:jusage. т_vŽʂ𐶐܂

:option. or
:target. any
:usage. reorder instructions for best pipeline usage
:jusage. œKȃpCvCgp邽߂ɖ߂בւ܂

:option. os
:target. any
:enumerate. opt_size_time
:timestamp.
:usage. favor code size over execution time in optimizations
:jusage. sԂR[hTCY̍œKD悵܂

:option. ot
:target. any
:enumerate. opt_size_time
:timestamp.
:usage. favor execution time over code size in optimizations
:jusage. R[hTCYsԂ̍œKD悵܂

:option. ou
:target. any
:usage. all functions must have unique addresses
:jusage. ׂĂ̊֐͂ꂼŗL̃AhXK܂

:option. ox
:target. any
:enumerate. opt_level
:timestamp.
:usage. equivalent to -obmiler -s
:jusage. -obmiler -sƓ

:option. oz
:target. any
:usage. NULL points to valid memory in the target environment
:jusage. NULĹA^[Qbg̗Lȃw܂

:option. ad
:target. any
:file.
:optional.
:usage. generate makefile style auto depend file
:jusage. generate makefile style auto depend file

:option. adbs
:target. any
:usage. force slashes to back-slashes in auto dep file
:jusage. force slashes to back-slashes in auto dep file

:option. adfs
:target. any
:usage. force slashes to fore-slashes in auto dep file
:jusage. force slashes to fore-slashes in auto dep file

:option. add
:target. any
:file.
:optional.
:usage. specify first dependancy in make-style auto depend file
:jusage. specify first dependancy in make-style auto depend file

:option. adhp
:target. any
:file.
:optional.
:usage. specify path for headers with none.
:jusage. specify path for headers with none.

:option. adt
:target. any
:file.
:optional.
:usage. specify target in make-style auto depend file
:jusage. specify target in make-style auto depend file

:option. pil
:target. any
:nochain.
:usage. preprocessor ignores #line directives
:jusage. preprocessor ignores #line directives

:option. p
:target. any
:usage.
:jusage.

:option. pe
:target. any
:usage. encrypt identifiers
:jusage. ʎqÍ܂

:option. pl
:target. any
:usage. insert #line directives
:jusage. #line[߂}܂

:option. pj
:target. any
:internal.
:usage. insert // #line comments
:jusage. // #line[߂}܂

:option. pc
:target. any
:usage. preserve comments
:jusage. Rgc܂

:option. pw
:target. any
:number. checkPPWidth
:usage. wrap output lines at <num> columns. Zero means no wrap.
:jusage. o͍s<num>Ő܂Ԃ܂. 0͐܂Ԃ܂.

:option. p#
:target. any
:char.
:internal.
:usage. set preprocessor delimiter to something other than '#'
:jusage. vvZbT̋؂L'#'ȊỎɐݒ肵܂

:option. q
:target. any
:usage. operate quietly (display only error messages)
:jusage. bZ[W[hœ삵܂(G[bZ[Ŵݕ\܂)

:option. r
:target. i86 386
:usage. save/restore segment registers across calls
:jusage. ֐ĂяȏOŃZOgWX^ޔ/XgA܂

:option. re
:target. 386
:internal.
:usage. special Neutrino R/W data access code generation
:jusage.

:option. ri
:target. i86 386
:usage. return chars and shorts as ints
:jusage. SĂ̊֐̈Ɩ߂lint^ɕϊ܂

:option. rod
:target. any
:path.
:internal.
:usage. specified <path> contains read-only files
:jusage. w肳ꂽ<path>ɂ͓ǂݍݐpt@C܂܂Ă܂

:option. s
:target. any
:usage. remove stack overflow checks
:jusage. X^bNI[ot[E`FbN폜܂

:option. sg
:target. i86 386
:usage. generate calls to grow the stack
:jusage. X^bN𑝉Ăяo𐶐܂

:option. si
:target. axp
:usage. generate calls to initialize local storage
:jusage. [JĂяo𐶐܂

:option. st
:target. i86 386
:usage. touch stack through SS first
:jusage. ܂ŏSSʂăX^bNE^b`܂

:option. t
:target. any
:number. checkTabWidth
:usage. set number of spaces in a tab stop
:jusage. ^uXgbvɑΉ󔒂̐ݒ肵܂

:option. tp
:target. dbg
:id.
:usage. set #pragma on( <id> )
:jusage. #pragma on( <id> )ݒ肵܂

:option. u
:target. any
:special. scanUndefine [=<name>]
:usage. undefine macro name
:jusage. }N𖢒`ɂ܂

:option. v
:target. any
:usage. output function declarations to .def file
:jusage. .deft@CɊ֐錾o͂܂

:option. vcap
:target. 386 axp
:usage. VC++ compatibility: alloca allowed in argument lists
:jusage. VC++ ݊: Xg̒allocagpł܂

:option. w
:target. any
:enumerate. warn_level
:number. checkWarnLevel
:usage. set warning level number
:jusage. xxԍݒ肵܂

:option. wcd
:target. any
:number.
:multiple.
:usage. warning control: disable warning message <num>
:jusage. x: xbZ[W<num>֎~܂

:option. wce
:target. any
:number.
:multiple.
:usage. warning control: enable warning message <num>
:jusage. x: xbZ[W <num> ̕\܂

:option. we
:target. any
:usage. treat all warnings as errors
:jusage. ׂĂ̌xG[ƂĈ܂

:option. wx
:target. any
:enumerate. warn_level
:usage. set warning level to maximum setting
:jusage. xxőݒɂ܂

:option. xbnm
:target. any
:internal.
:usage. use latest (incompatible) name mangling algorithms
:jusage. 

:option. xbsa
:target. any
:internal.
:usage. do not align segments if at all possible
:jusage. 

:option. xbov1
:target. any
:internal.
:usage. WP 13.3.3.2 change
:jusage. 

:option. xcmb
:target. any
:internal.
:usage. bind modifiers during template instantiation
:jusage. ev[gCX^XԂɏCqoCh܂

:option. xcpi
:target. any
:internal.
:usage. instantiate template functions if a prototype is visible
:jusage. vg^Cv΁Aev[g֐CX^X܂

:option. xd
:target. any
:enumerate. exc_level
:usage. disable exception handling (default) 
:jusage. Ogpsɂ܂(ftHg) 

:option. xds
:target. any
:enumerate. exc_level
:usage. disable exception handling (table-driven destructors)
:jusage. Ogpsɂ܂(e[uhũfXgN^)

:option. xdt
:target. any
:enumerate. exc_level
:usage. disable exception handling (same as -xd)
:jusage. Ogpsɂ܂(-xdƓ)

:option. xr
:target. any
:usage. enable RTTI
:jusage. RTTIgp\ɂ܂

:option. xs
:target. any
:enumerate. exc_level
:usage. enable exception handling 
:jusage. Ogp\ɂ܂

:option. xss
:target. any
:enumerate. exc_level
:usage. enable exception handling (table-driven destructors)
:jusage. Ogp\ɂ܂(e[uhũfXgN^)

:option. xst
:target. any
:enumerate. exc_level
:usage. enable exception handling (direct calls for destruction)
:jusage. Ogp\ɂ܂(fXgN^ւ̒ڌďo)

:option. xgls
:target. i86
:internal.
:usage. only check seg of i86 far pointers when checking NULL equality
:jusage.

:option. xgv
:target. 386
:internal.
:usage. indexed global variables
:jusage. CfbNXtO[oϐ

:option. xto
:target. any
:internal.
:usage. obfuscate type signature names
:jusage.

:option. za
:target. any
:enumerate. iso
:usage. disable extensions (i.e., accept only ISO/ANSI C++)
:jusage. g@\gpsɂ܂(܂, ISO/ANSI C++̂ݎ󂯕t܂)

:option. za0x
:target. any
:usage. enable some features of the upcoming ISO C++0x standard
:jusage.

:option. zat
:target. any
:usage. disable alternative tokens (e.g. and, or, not)
:jusage.

:option. zc
:target. i86 386
:usage. place const data into the code segment
:jusage. eR[hZOgɓ܂

:option. zdf
:target. i86 386
:enumerate. ds_peg
:usage. DS floats (i.e. not fixed to DGROUP)
:jusage. DS𕂓ɂ܂(܂DGROUPɌŒ肵܂)

:option. zdp
:target. i86 386
:enumerate. ds_peg
:usage. DS is pegged to DGROUP
:jusage. DSDGROUPɌŒ肵܂

:option. zdl
:target. 386
:usage. load DS directly from DGROUP
:jusage. DGROUPDSɒڃ[h܂

:option. ze
:target. any
:enumerate. iso
:usage. enable extensions (i.e., near, far, export, etc.)
:jusage. g@\gp\ɂ܂(܂, near, far, export, .)

:option. zf
:target. any
:usage. scope of for loop initializer extends beyond loop
:jusage. FIX ME

:option. zfw
:target. i86
:usage. generate FWAIT instructions on 386 and later
:jusage.

:option. zfw
:target. 386
:usage. generate FWAIT instructions
:jusage.

:option. zff
:target. i86 386
:enumerate. fs_peg
:usage. FS floats (i.e. not fixed to a segment)
:jusage. FS𕂓ɂ܂(܂, 1̃ZOgɌŒ肵܂)

:option. zfp
:target. i86 386
:enumerate. fs_peg
:usage. FS is pegged to a segment
:jusage. FS1̃ZOgɌŒ肵܂

:option. zg
:target. any
:usage. generate function prototypes using base types
:jusage. {^gp֐vg^Cv𐶐܂

:option. zgf
:target. i86 386
:enumerate. gs_peg
:usage. GS floats (i.e. not fixed to a segment)
:jusage. GS𕂓ɂ܂(܂, 1̃ZOgɌŒ肵܂)

:option. zgp
:target. i86 386
:enumerate. gs_peg
:usage. GS is pegged to a segment
:jusage. GS1̃ZOgɌŒ肵܂

:option. zi
:target. dbg
:usage. dump informational statistics to stdout
:jusage. Ƃēvlstdoutɏo͂܂

:option. zk0 zk
:target. any
:enumerate. char_set
:usage. double-byte character support: Kanji
:jusage. 2oCgT|[g: {

:option. zk1
:target. any
:enumerate. char_set
:usage. double-byte character support: Chinese/Taiwanese
:jusage. 2oCgT|[g: /p

:option. zk2
:target. any
:enumerate. char_set
:usage. double-byte character support: Korean
:jusage. 2oCgT|[g: ؍

:option. zk0u
:target. any
:enumerate. char_set
:usage. translate double-byte Kanji to Unicode
:jusage. 2oCgUnicodeɕϊ܂

:option. zkl
:target. any
:enumerate. char_set
:usage. double-byte character support: local installed language
:jusage. 2oCgT|[g: [JɃCXg[ꂽ

:option. zku
:target. any
:enumerate. char_set
:number.
:usage. load Unicode translate table for specified code page
:jusage. w肵R[hy[WUnicodeϊe[u[h܂

:option. zl
:target. any
:usage. remove default library information
:jusage. ftHgCu폜܂

:option. zld
:target. any
:usage. remove file dependency information
:jusage. t@Cˑ폜܂

:option. zlf
:target. any
:usage. always generate default library information
:jusage. ftHgCuɐ܂

:option. zls
:target. any
:usage. remove automatically inserted symbols
:jusage. remove automatically inserted symbols

:option. zm
:target. i86 386
:usage. emit functions in separate segments
:jusage. e֐ʂ̃ZOgɓ܂

:option. zm
:target. axp
:usage. emit functions in separate sections
:jusage. e֐ʂ̃ZOgɓ܂

:option. zmf
:target. i86 386
:usage. emit functions in separate segments (near functions allowed)
:jusage. e֐ʂ̃ZOgɓ܂(near֐\ł)

:option. zo
:target. 386
:usage. use exception-handling for a specific operating system
:jusage. w肳ꂽIy[eBOVXep̗Ogp܂

:option. zp
:target. any
:number. checkPacking
:usage. pack structure members with alignment {1,2,4,8,16}
:jusage. \̃o[{1,2,4,8,16}ɐ񂵂ăpbN܂

:option. zpw
:target. any
:usage. output warning when padding is added in a class
:jusage. NXɃpfBOǉꂽƂɌx܂

:option. zq
:target. any
:usage. operate quietly (display only error messages)
:jusage. bZ[W[hœ삵܂(G[bZ[Ŵݕ\܂)

:option. zro
:target. any
:usage. omit floating point rounding calls (non ANSI)
:jusage. omit floating point rounding calls (non ANSI)

:option. zri
:target. 386
:usage. inline floating point rounding calls
:jusage. inline floating point rounding calls

:option. zs
:target. any
:usage. syntax check only
:jusage. \`FbN݂̂s܂

:option. zt
:target. i86 386
:number. CmdX86CheckThreshold 256
:usage. far data threshold (i.e., larger objects go in far memory)
:jusage. farf[^~l(܂, ~l傫IuWFNgfarɒu܂)

:option. zu
:target. i86 386
:usage. SS != DGROUP (i.e., do not assume stack is in data segment)
:jusage. SS != DGROUP (܂, X^bNf[^ZOgɂƉ肵܂)

:option. zv
:target. any
:usage. enable virtual function removal optimization
:jusage. z֐폜œKs܂

:option. zw
:target. i86 386
:enumerate. win
:usage. generate code for Microsoft Windows
:jusage. Microsoft Windowsp̃R[h𐶐܂

:option. zws
:target. i86
:enumerate. win
:usage. generate code for Microsoft Windows with smart callbacks
:jusage. X}[gR[obNMicrosoft WindowspR[h𐶐܂

:option. z\W
:target. i86
:enumerate. win
:usage. more efficient Microsoft Windows entry sequences
:jusage. ʓIMicrosoft WindowsGgR[h𐶐܂

:option. z\Ws
:target. i86
:enumerate. win
:usage. generate code for Microsoft Windows with smart callbacks
:jusage. X}[gR[obNMicrosoft WindowspR[h𐶐܂

:option. zx
:target. i86 386
:usage. assume functions will modify FPU registers
:jusage. ֐FPUWX^ύXƉ肵܂
:internal.

:option. zz
:target. 386
:usage. remove "@size" from __stdcall function names (10.0 compatible)
:jusage. "@size"__stdcall֐폜܂(10.0Ƃ̌݊)
