.\" Converted with mdoc2man 0.2
.\" from NiH: zip_close.mdoc,v 1.14 2005/06/09 21:14:54 wiz Exp 
.\" $NiH: zip_close.man,v 1.10 2005/06/17 12:59:05 wiz Exp $
.\"
.\" zip_close.mdoc \-- close zip archive
.\" Copyright (C) 2003, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <nih@giga.or.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_CLOSE 3 "June 9, 2005" NiH
.SH "NAME"
zip_close \- close zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
.In zip.h
.Ft int
.Fn zip_close "struct zip *archive"
.SH "DESCRIPTION"
The
.Fn zip_close
function closes
\fBarchive\fR
and frees the memory allocated for it.
If any files within were changed, those changes are written to disk
first.
If writing changes fails,
.Fn zip_close
fails and
\fBarchive\fR
is left unchanged.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
.Fn zip_close
will fail if:
.RS
.TP 4
Bq Er ZIP_ER_EOF
Unexpected end-of-file found while reading from a file.
.TP 4
Bq Er ZIP_ER_INTERNAL
The callback function of an added or replaced file returned an
error but failed to report which.
.TP 4
Bq Er ZIP_ER_INVAL
The
\fBpath\fR
argument is
\fBNULL.\fR
.TP 4
Bq Er ZIP_ER_MEMORY
Required memory could not be allocated.
.TP 4
Bq Er ZIP_ER_NOZIP
File is not a zip archive.
.TP 4
Bq Er ZIP_ER_READ
A file read failed.
.TP 4
Bq Er ZIP_ER_RENAME
A temporary file could not be renamed to its final name.
.TP 4
Bq Er ZIP_ER_SEEK
A file seek failed.
.TP 4
Bq Er ZIP_ER_TMPOPEN
A temporary file could not be created.
.TP 4
Bq Er ZIP_ER_WRITE
A file write failed.
.TP 4
Bq Er ZIP_ER_ZLIB
An error occurred while (de)compressing a stream with
zlib(3).
.RE
Additionally, any errors returned by the callback function
for added or replaced files will be passed back.
.SH "SEE ALSO"
libzip(3),
zip_error_get(3),
zip_open(3),
zip_strerror(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
