/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#include <dos.h>

#include "dosequip.h"

static  unsigned long far *BiosTime;

char *InitSys()
{
    BiosTime = MK_FP( 0x40, 0x6c );
    return( 0 );
}

void FiniSys()
{
}

/* value of Ticks is incremented approx every 1/10 th of a second */

unsigned long Ticks()
{
    return( *BiosTime >> 1 );
}


int NumPrinters()
{
    return( Equipment().num_printers );
}


unsigned PrnAddress( int printer )
{
    return( *(unsigned far *) MK_FP( BIOS_SEG, PRINTER_BASE + printer*2 ) );
}

#pragma off(unreferenced);
void FreePorts( unsigned first, unsigned last )
#pragma on(unreferenced);
{
}

#pragma off(unreferenced);
unsigned AccessPorts( unsigned first, unsigned last )
#pragma on(unreferenced);
{
    return( 1 );
}
