/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Table of Alpha AXP opcodes and corresponding decode routines.
*
****************************************************************************/


#define o( p, c )       ((p##ul<<26)+(c##ul<<5))
/*
      Idx,              Name,           Opcode,         Mask,           Handler
*/
inspick( CALL_PAL,      "call_pal",     0x00000000,     0xfc000000,     AXPPal )
inspick( PAL19,         "pal19",        0x64000000,     0xfc000000,     AXPPal )
inspick( PAL1B,         "pal1b",        0x6c000000,     0xfc000000,     AXPPal )
inspick( PAL1D,         "pal1d",        0x74000000,     0xfc000000,     AXPPal )
inspick( PAL1E,         "pal1e",        0x78000000,     0xfc000000,     AXPPal )
inspick( PAL1F,         "pal1f",        0x7c000000,     0xfc000000,     AXPPal )
inspick( LDA,           "lda",          0x20000000,     0xFC000000,     AXPMemoryLA )
inspick( LDAH,          "ldah",         0x24000000,     0xFC000000,     AXPMemoryLA )
inspick( LDL,           "ldl",          0xa0000000,     0xFC000000,     AXPMemory )
inspick( LDL_L,         "ldl_l",        0xa8000000,     0xFC000000,     AXPMemory )
inspick( LDQ,           "ldq",          0xa4000000,     0xFC000000,     AXPMemory )
inspick( LDQ_L,         "ldq_l",        0xac000000,     0xFC000000,     AXPMemory )
inspick( LDQ_U,         "ldq_u",        0x2c000000,     0xFC000000,     AXPMemory )
inspick( LDS,           "lds",          0x88000000,     0xFC000000,     AXPFPMemory )
inspick( LDT,           "ldt",          0x8c000000,     0xFC000000,     AXPFPMemory )
inspick( STL,           "stl",          0xb0000000,     0xFC000000,     AXPMemory )
inspick( STL_C,         "stl_c",        0xb8000000,     0xFC000000,     AXPMemory )
inspick( STQ,           "stq",          0xb4000000,     0xFC000000,     AXPMemory )
inspick( STQ_C,         "stq_c",        0xbc000000,     0xFC000000,     AXPMemory )
inspick( STQ_U,         "stq_u",        0x3c000000,     0xFC000000,     AXPMemory )
inspick( STS,           "sts",          0x98000000,     0xFC000000,     AXPFPMemory )
inspick( STT,           "stt",          0x9c000000,     0xFC000000,     AXPFPMemory )
inspick( FETCH,         "fetch",        0x60008000,     0xFC00FFFF,     AXPMemoryFC )
inspick( FETCH_M,       "fetch_m",      0x6000a000,     0xFC00FFFF,     AXPMemoryFC )
inspick( MB,            "mb",           0x60004000,     0xFC00FFFF,     AXPMemoryFC )
inspick( RC,            "rc",           0x6000e000,     0xFC00FFFF,     AXPMemoryFC )
inspick( RPCC,          "rpcc",         0x6000c000,     0xFC00FFFF,     AXPMemoryFC )
inspick( RS,            "rs",           0x6000f000,     0xFC00FFFF,     AXPMemoryFC )
inspick( TRAPB,         "trapb",        0x60000000,     0xFC00FFFF,     AXPMemoryFC )
inspick( WMB,           "wmb",          0x60004400,     0xFC00FFFF,     AXPMemoryFC )
inspick( EXCB,          "excb",         0x60000400,     0xFC00FFFF,     AXPMemoryFC )
inspick( JMP,           "jmp",          0x68000000,     0xFC00C000,     AXPJump )
inspick( JSR,           "jsr",          0x68004000,     0xFC00C000,     AXPJump )
inspick( RET,           "ret",          0x68008000,     0xFC00C000,     AXPJump )
inspick( JSR_CORTN,     "jsr_coroutine",0x6800c000,     0xFC00C000,     AXPJump )
inspick( BR,            "br",           0xc0000000,     0xFC000000,     AXPBranch )
inspick( FBEQ,          "fbeq",         0xc4000000,     0xFC000000,     AXPFPBranch )
inspick( FBLT,          "fblt",         0xc8000000,     0xFC000000,     AXPFPBranch )
inspick( FBLE,          "fble",         0xcc000000,     0xFC000000,     AXPFPBranch )
inspick( BSR,           "bsr",          0xd0000000,     0xFC000000,     AXPBranch )
inspick( FBNE,          "fbne",         0xd4000000,     0xFC000000,     AXPFPBranch )
inspick( FBGE,          "fbge",         0xd8000000,     0xFC000000,     AXPFPBranch )
inspick( FBGT,          "fbgt",         0xdc000000,     0xFC000000,     AXPFPBranch )
inspick( BLBC,          "blbc",         0xe0000000,     0xFC000000,     AXPBranch )
inspick( BEQ,           "beq",          0xe4000000,     0xFC000000,     AXPBranch )
inspick( BLT,           "blt",          0xe8000000,     0xFC000000,     AXPBranch )
inspick( BLE,           "ble",          0xec000000,     0xFC000000,     AXPBranch )
inspick( BLBS,          "blbs",         0xf0000000,     0xFC000000,     AXPBranch )
inspick( BNE,           "bne",          0xf4000000,     0xFC000000,     AXPBranch )
inspick( BGE,           "bge",          0xf8000000,     0xFC000000,     AXPBranch )
inspick( BGT,           "bgt",          0xfc000000,     0xFC000000,     AXPBranch )
inspick( ADDL,          "addl",         o(0x10,0x00),   0xFC0007E0,     AXPOperateV )
inspick( ADDQ,          "addq",         o(0x10,0x20),   0xFC0007E0,     AXPOperateV )
inspick( CMPBGE,        "cmpbge",       o(0x10,0x0f),   0xFC000FE0,     AXPOperate )
inspick( CMPEQ,         "cmpeq",        o(0x10,0x2d),   0xFC000FE0,     AXPOperate )
inspick( CMPLE,         "cmple",        o(0x10,0x6d),   0xFC000FE0,     AXPOperate )
inspick( CMPLT,         "cmplt",        o(0x10,0x4d),   0xFC000FE0,     AXPOperate )
inspick( CMPULE,        "cmpule",       o(0x10,0x3d),   0xFC000FE0,     AXPOperate )
inspick( CMPULT,        "cmpult",       o(0x10,0x1d),   0xFC000FE0,     AXPOperate )
inspick( SUBL,          "subl",         o(0x10,0x09),   0xFC0007E0,     AXPOperateV )
inspick( SUBQ,          "subq",         o(0x10,0x29),   0xFC0007E0,     AXPOperateV )
inspick( S4ADDL,        "s4addl",       o(0x10,0x02),   0xFC000FE0,     AXPOperate )
inspick( S4ADDQ,        "s4addq",       o(0x10,0x22),   0xFC000FE0,     AXPOperate )
inspick( S4SUBL,        "s4subl",       o(0x10,0x0b),   0xFC000FE0,     AXPOperate )
inspick( S4SUBQ,        "s4subq",       o(0x10,0x2b),   0xFC000FE0,     AXPOperate )
inspick( S8ADDL,        "s8addl",       o(0x10,0x12),   0xFC000FE0,     AXPOperate )
inspick( S8ADDQ,        "s8addq",       o(0x10,0x32),   0xFC000FE0,     AXPOperate )
inspick( S8SUBL,        "s8subl",       o(0x10,0x1b),   0xFC000FE0,     AXPOperate )
inspick( S8SUBQ,        "s8subq",       o(0x10,0x3b),   0xFC000FE0,     AXPOperate )
inspick( AND,           "and",          o(0x11,0x00),   0xFC000FE0,     AXPOperate )
inspick( BIC,           "bic",          o(0x11,0x08),   0xFC000FE0,     AXPOperate )
inspick( BIS,           "bis",          o(0x11,0x20),   0xFC000FE0,     AXPOperate )
inspick( CMOVEQ,        "cmoveq",       o(0x11,0x24),   0xFC000FE0,     AXPOperate )
inspick( CMOVLBC,       "cmovlbc",      o(0x11,0x16),   0xFC000FE0,     AXPOperate )
inspick( CMOVLBS,       "cmovlbs",      o(0x11,0x14),   0xFC000FE0,     AXPOperate )
inspick( CMOVGE,        "cmovge",       o(0x11,0x46),   0xFC000FE0,     AXPOperate )
inspick( CMOVGT,        "cmovgt",       o(0x11,0x66),   0xFC000FE0,     AXPOperate )
inspick( CMOVLE,        "cmovle",       o(0x11,0x64),   0xFC000FE0,     AXPOperate )
inspick( CMOVLT,        "cmovlt",       o(0x11,0x44),   0xFC000FE0,     AXPOperate )
inspick( CMOVNE,        "cmovne",       o(0x11,0x26),   0xFC000FE0,     AXPOperate )
inspick( EQV,           "eqv",          o(0x11,0x48),   0xFC000FE0,     AXPOperate )
inspick( ORNOT,         "ornot",        o(0x11,0x28),   0xFC000FE0,     AXPOperate )
inspick( XOR,           "xor",          o(0x11,0x40),   0xFC000FE0,     AXPOperate )
inspick( EXTBL,         "extbl",        o(0x12,0x06),   0xFC000FE0,     AXPOperate )
inspick( EXTLH,         "extlh",        o(0x12,0x6a),   0xFC000FE0,     AXPOperate )
inspick( EXTLL,         "extll",        o(0x12,0x26),   0xFC000FE0,     AXPOperate )
inspick( EXTQH,         "extqh",        o(0x12,0x7a),   0xFC000FE0,     AXPOperate )
inspick( EXTQL,         "extql",        o(0x12,0x36),   0xFC000FE0,     AXPOperate )
inspick( EXTWH,         "extwh",        o(0x12,0x5a),   0xFC000FE0,     AXPOperate )
inspick( EXTWL,         "extwl",        o(0x12,0x16),   0xFC000FE0,     AXPOperate )
inspick( INSBL,         "insbl",        o(0x12,0x0b),   0xFC000FE0,     AXPOperate )
inspick( INSLH,         "inslh",        o(0x12,0x67),   0xFC000FE0,     AXPOperate )
inspick( INSLL,         "insll",        o(0x12,0x2b),   0xFC000FE0,     AXPOperate )
inspick( INSQH,         "insqh",        o(0x12,0x77),   0xFC000FE0,     AXPOperate )
inspick( INSQL,         "insql",        o(0x12,0x3b),   0xFC000FE0,     AXPOperate )
inspick( INSWH,         "inswh",        o(0x12,0x57),   0xFC000FE0,     AXPOperate )
inspick( INSWL,         "inswl",        o(0x12,0x1b),   0xFC000FE0,     AXPOperate )
inspick( MSKBL,         "mskbl",        o(0x12,0x02),   0xFC000FE0,     AXPOperate )
inspick( MSKLH,         "msklh",        o(0x12,0x62),   0xFC000FE0,     AXPOperate )
inspick( MSKLL,         "mskll",        o(0x12,0x22),   0xFC000FE0,     AXPOperate )
inspick( MSKQH,         "mskqh",        o(0x12,0x72),   0xFC000FE0,     AXPOperate )
inspick( MSKQL,         "mskql",        o(0x12,0x32),   0xFC000FE0,     AXPOperate )
inspick( MSKWH,         "mskwh",        o(0x12,0x52),   0xFC000FE0,     AXPOperate )
inspick( MSKWL,         "mskwl",        o(0x12,0x12),   0xFC000FE0,     AXPOperate )
inspick( SLL,           "sll",          o(0x12,0x39),   0xFC000FE0,     AXPOperate )
inspick( SRA,           "sra",          o(0x12,0x3c),   0xFC000FE0,     AXPOperate )
inspick( SRL,           "srl",          o(0x12,0x34),   0xFC000FE0,     AXPOperate )
inspick( ZAP,           "zap",          o(0x12,0x30),   0xFC000FE0,     AXPOperate )
inspick( ZAPNOT,        "zapnot",       o(0x12,0x31),   0xFC000FE0,     AXPOperate )
inspick( MULL,          "mull",         o(0x13,0x00),   0xFC0007E0,     AXPOperateV )
inspick( MULQ,          "mulq",         o(0x13,0x20),   0xFC0007E0,     AXPOperateV )
inspick( UMULH,         "umulh",        o(0x13,0x30),   0xFC000FE0,     AXPOperate )
inspick( CPYS,          "cpys",         o(0x17,0x020),  0xFC00FFE0,     AXPFPOperate )
inspick( CPYSE,         "cpyse",        o(0x17,0x022),  0xFC00FFE0,     AXPFPOperate )
inspick( CPYSN,         "cpysn",        o(0x17,0x021),  0xFC00FFE0,     AXPFPOperate )
inspick( CVTLQ,         "cvtlq",        o(0x17,0x010),  0xFC001FE0,     AXPFPConvert )
inspick( CVTQL,         "cvtql",        o(0x17,0x030),  0xFC001FE0,     AXPFPConvert )
inspick( FCMOVEQ,       "fcmoveq",      o(0x17,0x02a),  0xFC00FFE0,     AXPFPOperate )
inspick( FCMOVGE,       "fcmovge",      o(0x17,0x02d),  0xFC00FFE0,     AXPFPOperate )
inspick( FCMOVGT,       "fcmovgt",      o(0x17,0x02f),  0xFC00FFE0,     AXPFPOperate )
inspick( FCMOVLE,       "fcmovle",      o(0x17,0x02e),  0xFC00FFE0,     AXPFPOperate )
inspick( FCMOVLT,       "fcmovlt",      o(0x17,0x02c),  0xFC00FFE0,     AXPFPOperate )
inspick( FCMOVNE,       "fcmovne",      o(0x17,0x02b),  0xFC00FFE0,     AXPFPOperate )
inspick( MF_FPCR,       "mf_fpcr",      o(0x17,0x025),  0xFC00FFE0,     AXPFPOperate )
inspick( MT_FPCR,       "mt_fpcr",      o(0x17,0x024),  0xFC00FFE0,     AXPFPOperate )
inspick( ADDS,          "adds",         o(0x16,0x000),  0xFC0007E0,     AXPIEEEOperate )
inspick( ADDT,          "addt",         o(0x16,0x020),  0xFC0007E0,     AXPIEEEOperate )
inspick( CMPTEQ,        "cmpteq",       o(0x16,0x0a5),  0xFC00ffE0,     AXPIEEECompare )
inspick( CMPTLT,        "cmptlt",       o(0x16,0x0a6),  0xFC00ffE0,     AXPIEEECompare )
inspick( CMPTLE,        "cmptle",       o(0x16,0x0a7),  0xFC00ffE0,     AXPIEEECompare )
inspick( CMPTUN,        "cmptun",       o(0x16,0x0a4),  0xFC00ffE0,     AXPIEEECompare )
inspick( CVTQS,         "cvtqs",        o(0x16,0x03c),  0xFC0007E0,     AXPIEEEConvert )
inspick( CVTQT,         "cvtqt",        o(0x16,0x03e),  0xFC0007E0,     AXPIEEEConvert )
inspick( CVTTS,         "cvtts",        o(0x16,0x02c),  0xFC0007E0,     AXPIEEEConvert )
inspick( DIVS,          "divs",         o(0x16,0x003),  0xFC0007E0,     AXPIEEEOperate )
inspick( DIVT,          "divt",         o(0x16,0x023),  0xFC0007E0,     AXPIEEEOperate )
inspick( MULS,          "muls",         o(0x16,0x002),  0xFC0007E0,     AXPIEEEOperate )
inspick( MULT,          "mult",         o(0x16,0x022),  0xFC0007E0,     AXPIEEEOperate )
inspick( SUBS,          "subs",         o(0x16,0x001),  0xFC0007E0,     AXPIEEEOperate )
inspick( SUBT,          "subt",         o(0x16,0x021),  0xFC0007E0,     AXPIEEEOperate )
inspick( CVTTQ,         "cvttq",        o(0x16,0x02f),  0xFC0007E0,     AXPIEEEConvert )
inspick( ADDF,          "addf",         o(0x15,0x000),  0xFC004fE0,     AXPVAXOperate )
inspick( CVTDG,         "cvtdg",        o(0x15,0x01e),  0xFC004fE0,     AXPVAXOperate )
inspick( ADDG,          "addg",         o(0x15,0x020),  0xFC004fE0,     AXPVAXOperate )
inspick( CMPGEQ,        "cmpgeq",       o(0x15,0x0a5),  0xFC004fE0,     AXPVAXOperate )
inspick( CMPGLT,        "cmpglt",       o(0x15,0x0a6),  0xFC004fE0,     AXPVAXOperate )
inspick( CMPGLE,        "cmpgle",       o(0x15,0x0a7),  0xFC004fE0,     AXPVAXOperate )
inspick( CVTGF,         "cvtgf",        o(0x15,0x02c),  0xFC004fE0,     AXPVAXOperate )
inspick( CVTGD,         "cvtgd",        o(0x15,0x02d),  0xFC004fE0,     AXPVAXOperate )
inspick( CVTQF,         "cvtqf",        o(0x15,0x03c),  0xFC004fE0,     AXPVAXOperate )
inspick( CVTQG,         "cvtqg",        o(0x15,0x03e),  0xFC004fE0,     AXPVAXOperate )
inspick( DIVF,          "divf",         o(0x15,0x003),  0xFC004fE0,     AXPVAXOperate )
inspick( DIVG,          "divg",         o(0x15,0x023),  0xFC004fE0,     AXPVAXOperate )
inspick( MULF,          "mulf",         o(0x15,0x002),  0xFC004fE0,     AXPVAXOperate )
inspick( MULG,          "mulg",         o(0x15,0x022),  0xFC004fE0,     AXPVAXOperate )
inspick( SUBF,          "subf",         o(0x15,0x001),  0xFC004fE0,     AXPVAXOperate )
inspick( SUBG,          "subg",         o(0x15,0x021),  0xFC004fE0,     AXPVAXOperate )
inspick( CVTGQ,         "cvtgq",        o(0x15,0x02f),  0xFC004fE0,     AXPVAXConvert )
#undef o
