.*
.*
.dirctv OVERLAY
.*
.np
The "OVERLAY" directive allows you to specify the class of segments
which are to be overlayed.
The format of the "OVERLAY" directive (short form "OV") is as follows.
.mbigbox
    OVERLAY class{,class}
.embigbox
.synote
.mnote class
is the class name of the segments to be overlayed.
.esynote
.np
.ix 'overlay classes'
The "FILE" directive is used to specify the object files that belong
to the overlay structure.
Each object file defines segments that contain code or data.
Segments are assigned a class name by the compiler.
.ix 'class name'
A class is essentially a collection of segments with common
attributes.
For example, compilers assign class names to segments so that segments
containing code belong to one class(es) and segments containing data
belong to another class(es).
When an overlay structure is defined, only segments belonging to
certain classes are allowed in the overlay structure.
By default, the &lnkname overlays all segments whose class name ends
with "CODE".
These segments usually contain the executable code for a program.
.np
It is also possible to overlay other classes.
This is done using the "OVERLAY" directive.
For example,
.millust begin
overlay code, far_data
.millust end
.ix 'overlaying segments in "FAR_DATA" class'
.pc
places all segments belonging to the classes "CODE" and "FAR_DATA" in
the overlay structure.
Segments belonging to the class "FAR_DATA" contain only data.
The above "OVERLAY" directive causes code and data to be overlayed.
Therefore, for any module that contains segments in both classes, data
in segments with class "FAR_DATA" will be in memory only when code in
segments with class "CODE" are in memory.
This results in a more efficient use of memory.
Of course the data must be referenced only by code in the overlay and
it must not be modified.
.warn
Care must be taken when overlaying data.
.ix 'overlaying data'
If a routine modifies data in an overlayed data segment,
it should not assume it contains that value if it is invoked again.
The data may have been overwritten by another overlay.
.ewarn
.autonote Notes:
.note
You should not specify a class in an "OVERLAY" directive that belongs
to the group "DGROUP".
These classes are "BEGDATA", "DATA", "BSS" and "STACK".
.endnote
.np
If you are linking object files generated by a compiler that uses a
class name that does not end with "CODE" for segments containing
executable code, the "OVERLAY" directive can be used to identify the
classes that belong to the overlay structure.
Consider the following example.
.exam begin
overlay code1, code2
.exam end
.pc
Any segment belonging to the class called "CODE1" or "CODE2" is placed
in the overlay structure.
Segments belonging to a class whose name ends with "CODE" will no
longer be placed in the overlay structure.
