.chap The &company Image Editor
.*
.if &e'&dohelp eq 0 .do begin
.section Introduction to the Image Editor
.do end
.*
.np
If you want to design visual resources such as bitmaps, icons, or
cursors and add sizzle to your application's interface, the image
editor can help.
.np
.ix 'Image Editor'
The Image Editor is a visually oriented drawing tool with the power to
draw all the visual resources you want &mdash. exactly the way you
picture them. This way, you can design effective bitmaps, meaningful
icons, and communicative cursors.
.np
Of course, the Image Editor can help bring to life your new artistic
achievements. But it can also copy visual images from anything else
you can see on your computer screen. For example, if you would like to
incorporate a favorite bitmap or icon from your desktop or even from
another application, you can use the Image Editor's Screen Select
option to copy that image to your design grid where you can tailor the
image to your exact specifications. Then, when you are happy with your
visual image, you can save it to an executable.
.np
Most of the sections in this chapter apply to all your visuals, but
for more information on the specific type of visual you are creating,
see the sections specific to creating and editing your specific
resource type.
.np
This chapter contains the following:
.begbull $compact
.bull
Opening the Image Editor
.bull
Closing the Image Editor
.bull
The Main Screen
.bull
The Image Editor Menu Bar
.bull
The Image Editor Toolbar
.bull
The Image Editor Toolbox
.bull
The Image Editor &ccolour Palette
.bull
The Image Editor Status Line
.bull
Creating and Editing Bitmaps
.bull
Creating and Editing Cursors
.bull
Creating and Editing Icons
.endbull
.*
.section Opening the Image Editor
.*
.np
.ix 'Image Editor' 'start'
.ix 'start' 'Image Editor'
.onestep To open the Image Editor:
.step Double click on the Image Editor icon
in your windows program manager,
.orstep Select the Image Editor icon and choose Open from the File menu.
.result
The &company Image Editor window appears.
.endstep
.*
.section Closing the Image Editor
.*
.np
.ix 'Image Editor' 'leave'
.ix 'quit' 'Image Editor'
.onestep To close the Image Editor and return to your desktop:
.step Double click on the system menu
in the top, left corner of the screen,
.orstep Choose Exit
from the File menu.
.endstep
.np
When you close the Image Editor, it remembers the size and position of
its main window, as well as the position of the toolbar and &colour
palette. It also remembers whether the toolbar and &colour palette were
hidden or not. This way, when you open the Image Editor again, it is
set up the same way you left it.
.*
.section The Main Screen
.*
.np
.ix 'Image Editor' 'main screen'
Every time you open the Image Editor, the &company Image Editor window
appears. The toolbar, toolbox, and &colour palette you use to edit your
images appear on top of this window.
:CMT. .figure *depth='3.87' *scale=140 *file='IMG1' The &company Image Editor window
.figure *depth='3.20' *scale=51 *file='IMG1' The &company Image Editor window
.np
You cannot draw or copy images onto the screen itself.
Instead, you must first create a design grid, a work area on which you
can design your visuals. You can create an empty design grid and draw
your own visual or you can create a design grid with an
image from your desktop or another application already on it. Once you
have an image on your design grid you can edit it so it looks exactly
the way you want.
.*
.beglevel
.*
.section Creating a Design Grid
.*
.ix 'Image Editor' 'create design grid'
.ix 'design grid'
.begstep To create a design grid:
.step Choose New
from the File menu.
.result
The Image Type dialog box appears.
.step Select the type of image you want to create
by clicking on either Bitmap, Icon, or Cursor.
.step Click on OK.
.result
A dialog box appears where you specify the image size you want to work
with. The Image Editor automatically defaults to the
standard sizes (in pixels) for bitmaps, icons, and cursors.
To create different sized images, simply enter the desired pixel
width and height.
.step Click on OK.
.endstep
.np
For more information on creating and editing a bitmaps, cursors or
icons, see the sections entitled :HDREF refid='credbmp'.,
:HDREF refid='credico'.,
and
:HDREF refid='credcur'..
.*
.endlevel
.*
.section The Image Editor Menu Bar
.*
.np
.ix 'Image Editor' 'menu bar'
The menu bar along the top of the Image Editor window allows you to
access most of the items in the toolbar, the toolbox, and the &colour
palette. It also provides you with other items that you cannot access
anywhere else except on the menu bar.
:CMT. .figure *depth='1.94' *scale=150 *file='IMG2' The &company Image Editor menu bar
.figure *depth='2.53' *scale=40 *file='IMG2' The &company Image Editor menu bar
.np
To see what an item does, position your cursor over the item and hold
the mouse button. A description of the item appears in the status
line. For more information about the status line, see the section
entitled :HDREF refid='statlne'.. This manual assumes that you know
how to use the menus and are familiar with common menu items such as
Save As and Undo.
.np
Some of the menu items have accelerator keys, also called
accelerators, so you can invoke an item without having to pull down
the menu. This means, for example, that you can start a new image in
three ways. You can either:
.begbull
.bull
Select the new image button from the toolbar, or
.bull
Choose New from the File menu, or
.bull
Press F2 (the accelerator for starting a new image).
.endbull
.*
.section The Image Editor Toolbar
.*
.np
.ix 'Image Editor' 'toolbar'
The toolbar allows you quick and easy access to the most used items in
the menus.
:CMT. .figure *depth='1.94' *scale=150 *file='IMG3' The &company Image Editor tool bar
.figure *depth='0.24' *scale=64 *file='IMG3' The &company Image Editor tool bar
.np
To find out what a button does, position your cursor over the
button and hold the mouse button. A description of the button's
function appears in the bottom right corner of your screen. If you
only wish to read what the button will do and not activate it, drag
your cursor onto another part of the window and then release the
mouse button.
.np
Here is a list of the buttons from left to right in the toolbar and
what they do.
.begpoint $break
.point New
Creates a new bitmap, icon, or cursor
.point Open
Opens an existing file
.point Save
Saves the current image
.point Toggle Grid
Allows you to view the exact pixels on your design grid
.point Maximize
Enlarges the appearance of your image and design grid
.point Clear
Deletes everything on your design grid
.point Snap Bitmap
Allows you to select a bitmap image from your desktop or another
application and place that image on your design grid
.point Shift Right
Moves the current image to the right
.point Shift Left
Moves the current image to the left
.point Shift Up
Moves the current image up
.point Shift Down
Moves the current image down
.point Flip Vertically
Mirrors the current image along the X-axis
.point Flip Horizontally
Mirrors the current image along the Y-axis
.point Rotate 90 Clockwise
Rotates the current image 90 degrees clockwise
.point Rotate 90 Counter Clockwise
Rotates the current image 90 degrees counter clockwise
.endpoint
.*
.section The Image Editor Toolbox
.*
.np
.ix 'Image Editor' 'toolbox'
The toolbox allows you to conveniently select and change the tool you
are using to edit your image, without having to hunt through the menus
for the tool you want.
:CMT. .figure *depth='2.06' *scale=150 *file='IMG4' The &company Image Editor toolbox
.figure *depth='1.63' *scale=64 *file='IMG4' The &company Image Editor toolbox
.np
Here is a list of the tools and what they do.
.begpoint $break
.point Pencil
Draws on the grid, pixel by pixel
.point Lines
Draws straight lines on the grid
.point Ellipse Outline
Draws outlines of circles and ellipses
.point Ellipse Fill
Draws filled circles and ellipses
.point Rectangle Outline
Draws outlines of rectangles
.point Rectangle Fill
Draws filled rectangles
.point Brush
Draws on the grid in various brush sizes
.point Select Region
Allows you to select a rectangular region on the grid
.point Select Hot Spot
Allows you to select the cursor hot spot (for cursors only)
.endpoint
.*
.section The Image Editor &ccolour Palette
.*
.np
.ix 'Image Editor' '&colour palette'
.ix '&colour' 'defining in Image Editor'
If you want to draw or fill a new visual in different &colour.s, or
change the &colour.s of an existing bitmap, icon, or cursor, the &colour.
palette allows you to select the &colour.s you want.
:CMT. .figure *depth='1.05' *scale=150 *file='IMG5' The &company Image Editor &colour palette
.figure *depth='1.02' *scale=90 *file='IMG5' The &company Image Editor &colour palette
.begstep To select a &colour:
.step Click either the left or right mouse button on the &colour
in the &colour palette that you wish to assign to that button.
.step Select a drawing tool.
.step Draw or fill
holding down the mouse button assigned to the &colour you
want.
.endstep
.np
For example, if you want to draw a red line:
.autonote
.note
Create a design grid for the resource you want
.note
Select a shade of red from the &colour palette.
.note
Select the line tool from the toolbox.
.note
Drag your cursor across the design grid.
.endnote
.np
When you choose one of the 12 &colour.s on the right of the &colour
palette, the draw &colour will not be the same as the fill &colour..
Don't be alarmed. This is because they are not true VGA &colour.s. The
Image Editor creates them by dithering two or more &colour.s together so
that, while the &colour appears solid in the view window, it is
actually made up of different &colour.ed pixels intermingled with each
other. Since it is impossible to represent a single pixel-unit of a
dithered &colour, the draw &colour always differs from the fill &colour
when you select a dithered &colour..
.*
.beglevel
.*
.section *refid=scrinvc Selecting Screen and Inverse &ccolour.s
.*
.np
Unlike simple bitmaps, visuals such as icons and cursors usually
require transparent or inverse &colour.s. This is so that they don't
entirely obscure everything underneath them and so they can be seen no
matter what &colour they happen to be sitting on.
.np
When you create or edit an icon or cursor, you can choose the screen
and inverse &colour.s from the &colour palette. Then, you can draw
portions of your icon or cursor with those &colour.s, so that these
pixels blend into the background of your application.
.np
Remember, if you want to use a specific &colour in your icon or cursor,
make sure the &colour you want to use is not the screen or inverse
&colour.. Reserve these two &colour.s for drawing only the transparent
portions of your icon or cursor. And use the other 26 &colour.s
available in the &colour palette for regular drawing.
.begstep To choose a screen &colour:
.step Create a design grid
for a cursor or icon.
.step Move your cursor
over the two squares beside the words Screen and Inverse, so that your
cursor changes from a pointer to a hand.
.step Double click on either square.
.result
The Select Screen Color dialog appears.
.step Select the &colour
you want to use as your screen &colour..
.step Click on OK.
.result
The dialog closes and the screen &colour and its inverse are assigned
to the screen and inverse boxes in the &colour palette. These will be
the Screen and Inverse &colour.s you can use to draw the portions of
your icon or cursor that you want to be transparent.
.begnote
.note Note:
When you select a &colour, its inverse is automatically selected for
you. Try to find a screen &colour and inverse &colour that you won't
want to use in the foreground of your icon or cursor. For example, if
you don't intend to use yellow in your icon, select yellow as your
screen &colour.. The inverse &colour, blue, is automatically selected
for you, so if you intend to use blue in your icon, find another
screen &colour that doesn't have blue as its inverse.
.endnote
.endstep
.*
.section Assigning &ccolour.s to Mouse Buttons
.*
.np
When you are drawing and filling in multiple &colour.s, you may find it
useful to assign &colour.s to the left and right mouse buttons. This
way, you can draw in one &colour, and quickly switch to another &colour
simply by pressing the opposite mouse button. For example, if you find
you draw mostly in black and red, assign black to the left mouse
button and red to the right mouse button. To do this,
.begstep
.step Select the black square
by clicking on it with the left mouse button.
.step Select the red square
by clicking on it with the right mouse button.
.result
The &colour.s assigned to the mouse buttons appear in the squares of the
&colour palette marked L (for left) and R (for right).
.endstep
.*
.section Hiding and Showing the &ccolour. Palette
.*
.np
If you generally only draw in one or two &colour.s or temporarily need
more room on your screen, you can hide the &colour palette:
.begbull $compact
.bull
Double click on the system menu icon in the corner of the Color
Palette, or
.bull
Choose Show Color Palette from the Options menu.
.endbull
.np
To reveal the &colour palette again, choose Show Color Palette again
from the Options menu.
.*
.endlevel
.*
.section *refid=statlne The Image Editor Status Line
.*
.np
.ix 'Image Editor' 'status line'
There are five sections in the status line. The first four sections
provide information on the current image. The fifth section displays
hint text for the items in the menus, toolbar, and toolbox when you
position your cursor over an item and hold down the mouse button.
:CMT. .figure *depth='2.93' *scale=140 *file='IMG6' The &company Image Editor status line
.figure *depth='3.96' *scale=63 *file='IMG6' The &company Image Editor status line
:cmt.The status line also lets you know if there is a
:cmt.problem with the Image Editor.
:cmt..np
:cmt.Here is a list of problem messages that you may find in the hint area
:cmt.of the status bar and what to do if you get one:
:cmt..np
:cmt..monoon
:cmt.Memory is low! No undos recorded.
:cmt..monooff
:cmt.If you get this message,...
:cmt. [waiting for message info form Wes.]
.*
.section *refid=credbmp Creating and Editing Bitmaps
.*
.np
.ix 'Image Editor' 'and bitmaps'
.ix 'bitmaps'
If you want your applications to have visual impact, you can create
and edit bitmaps. Bitmaps are graphical images that can be as large as
512 x 512 square pixels representing such things as buttons, brush
patterns, company logos, toolbar items, wallpaper, and graphical
elements in menus.
.np
Using the Image Editor you can create a new bitmap or you can create a
bitmap from any other image on your desktop. You can even copy a
bitmap from another application on your desktop.
.begstep To create a new bitmap:
.step Choose New
from the File menu.
.result
The Image Type dialog appears.
.step Select Bitmap.
.step Click on OK.
.result
The Bitmap Information dialog appears. This dialog prompts you for
information about the dimensions of the bitmap you want to create and
the &colour scheme you want to work with. The Image Editor defaults to
the dimensions most commonly used for creating bitmaps, 32 pixels by
32 pixels. However, if you want to create a different sized bitmap,
enter the pixel width and height you want. The Image Editor also
defaults to a 256-&ccolour &colour scheme.
Other color schemes available are 16-&ccolour VGA and 2-&ccolour
Monochrome.
.endstep
.np
To copy a bitmap from your desktop or from another application on your
desktop:
.begstep
.step Choose New
from the File menu.
.result
The Image Type dialog appears.
.step Select Bitmap.
.step Click on OK.
.result
The Bitmap Information dialog appears.
.step Select the Screen Select button.
.result
This option allows you to choose the size and contents of the newly
created bitmap with images from your desktop or from another
application sitting on your desktop. The Image Editor ignores the
limitations specified in the Bitmap Information dialog and uses the
dimensions you sweep out (up to 512x512 pixels).
.step Position the cursor at the image you want to select.
.step Hold the left mouse button and drag the cursor
across the image you want to copy to your design grid.
.step Release the mouse button.
.result
The image you selected appears on your design grid.
.endstep
.*
.section *refid=credcur Creating and Editing Cursors
.*
.np
.ix 'Image Editor' 'cursors'
.ix 'cursors' 'creating and editing'
You can create and edit cursors that communicate to your users the
mode or state of the application.
.np
You can create a new cursor or you can create an empty
cursor and copy an image from your desktop or another application onto
your design grid. From there you can edit your cursor's appearance and
set its hot spot.
.np
When you edit cursors, the Image Editor provides you with an extra
tool called
.us Set Hotspot
This tool allows you to select the exact pixel to which you want to
assign the hotspot. The default hotspot is 0,0 (at the top left corner
of the design grid).
.figure *depth='1.63' *scale=64 *file='IMG7' The Set Hotspot tool allows you to select the hotspot
.begstep To create a new cursor:
.step Choose New
from the File menu.
.result
The Image Type dialog appears.
.step Select Cursor.
.step Click on OK.
.result
The Cursor Format dialog box appears. Since cursors should be
standardized, you can only choose monochrome cursors 32x32 pixels. You
cannot create a &colour.ed cursor.
.step Click on OK.
.endstep
.np
Cursors (and icons, too) differ from bitmaps in that they almost always
include pixels that blend into the background of your application.
Unless you want a rectangular shaped cursor, you must assign special
screen and inverse &colour.s to the "blending pixels," so that they
don't obscure the areas over which you move the cursor.
.np
Since you can only create black and white cursors, do not use black or
white as your screen or inverse &colour.s. Instead, use one of the
dithered &colour.s as your screen &colour.. The Image Editor automatically
chooses the inverse of the chosen dithered &colour..
.np
For more information on selecting screen and inverse &colour.s, refer to
the section entitled :HDREF refid='scrinvc'..
.*
.section *refid=credico Creating and Editing Icons
.*
.np
.ix 'Image Editor' 'and icons'
.ix 'icons' 'creating and editing'
With the Image Editor, you can create icons that look exactly the way
you want. Icons are usually the user's first exposure to your
application, so you want them to be as professional and meaningful as
possible.
.np
You can create a new icon or you can create an empty icon design grid
and use the Image Editor's Snap Bitmap option to copy an image from
your desktop to your design grid where you can edit it as desired.
.begstep To create a new icon:
.step Choose New
from the File menu.
.result
The Image Type dialog appears.
.step Select Icon.
.step Click on OK.
.result
The Icon Target dialog box appears. You can create the following types
of icons:
.begbull $compact
.bull
16-&colour 32x32
.bull
2-&colour 32x32
.bull
2-&colour 32x16
.bull
16-&colour 16x16
.bull
2-&colour 16x16
.bull
256-&colour 48x48
.bull
16-&colour 48x48
.bull
16-&colour 24x24
.endbull
.np
.step Select the desired icon type.
.step Click on OK.
.result
The Image Editor window displays an empty icon design grid
awaiting your new creation.
.endstep
.np
If you want to copy an image from your desktop or from another
application sitting on your desktop, select the Snap Bitmap option
from the toolbar and drag across the image on your desktop that you
want to copy.
.*
