.\" Converted with mdoc2man 0.2
.\" from NiH: zip_error_to_str.mdoc,v 1.8 2005/06/09 21:14:54 wiz Exp 
.\" $NiH: zip_error_to_str.man,v 1.4 2005/06/17 12:59:05 wiz Exp $
.\"
.\" zip_error_to_str.mdoc \-- get string representation of zip error code
.\" Copyright (C) 2003, 2004, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <nih@giga.or.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_ERROR_TO_STR 3 "November 24, 2004" NiH
.SH "NAME"
zip_error_to_str \- get string representation of zip error
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
.In zip.h
.Ft int
.Fn zip_error_to_str "char *buf" "int len" "int ze" "int se"
.SH "DESCRIPTION"
The
.Fn zip_error_to_str
function stores a string describing the libzip error code
\fBze\fR
in the user-provided buffer
\fBbuf\fR
which has size
\fBlen.\fR
The buffer is always NUL-terminated.
\fBse\fR
should be the value of the global variable
\fBerrno\fR
at the time of the error or the zlib error code, depending on
\fBze.\fR
.PP
.Fn zip_error_to_str
is especially useful if
.Fn zip_open
failed, since then there is no
.Vt struct zip
is available to store the error code; otherwise
.Fn zip_strerror
or
.Fn zip_file_strerror
are more convenient.
.SH "RETURN VALUES"
.Fn zip_error_to_str
returns the number of characters that would have been written to a
sufficiently sized
\fBbuf,\fR
excluding the terminating NUL character.
.SH "SEE ALSO"
libzip(3),
zip_error_get(3),
zip_error_get_sys_type(3),
zip_file_error_get(3),
zip_file_strerror(3),
zip_open(3),
zip_strerror(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
