/*
    OS/2 Multimedia Extensions MIDI include file.
*/

#ifndef __MIDIDLL_H__
#define __MIDIDLL_H__

#ifdef __cplusplus
extern "C" {
#endif

#define MIDI_NAME_LENGTH 32
#define MIDI_SUCCESS 0
#define TIMER_SUCCESS 0
#define MIDI_ENABLE_RECEIVE 1
#define MIDI_ENABLE_SEND 2
#define MIDI_DISABLE_RECEIVE 1
#define MIDI_DISABLE_SEND 2

#define MIDI_START_TIMER 1
#define MIDI_STOP_TIMER 2

#define MIDI_INST_ATTR_CAN_RECV 1
#define MIDI_INST_ATTR_CAN_SEND 2
#define MIDI_INST_ATTR_ENABLE_R 4
#define MIDI_INST_ATTR_ENABLE_S 8

#define MIDICALLBACK_PFN 1
#define MIDICALLBACK_HWND 2
#define MIDICALLBACK_QUEUE 3

#define MIDIDEV_IS_PATCHER 0x00000001
#define MIDIDEV_IS_CONTROLLER 0x00000002
#define MIDIDEV_IS_RECEIVER 0x00000004
#define MIDIDEV_IS_MULTITIMBRAL 0x00000008
#define MIDIDEV_SENDS_MTC 0x00000010
#define MIDIDEV_RECEIVES_MTC 0x00000020
#define MIDIDEV_SENDS_CLOCK 0x00000040
#define MIDIDEV_RECEIVES_CLOCK 0x00000080
#define MIDIDEV_SENDS_SYNC 0x00000100
#define MIDIDEV_RECEIVES_SYNC 0x00000200
#define MIDIDEV_SENDS_MMC 0x00000400
#define MIDIDEV_RECEIVES_MMC 0x00000800

typedef ULONG      MINSTANCE;
typedef MINSTANCE  *PMINSTANCE;
typedef PVOID      TIMEHANDLE;
typedef TIMEHANDLE *PTIMEHANDLE;
typedef PULONG     *PPULONG;

typedef struct {
    ULONG ulSourceInstance;
    ULONG ulTime;
    ULONG ulTrack;
    union {
        ULONG ulMessage;
        struct {
            BYTE bStatus;
            BYTE abData[3];
        } bytes;
        BYTE abData[4];
    } msg;
} MESSAGE, *PMESSAGE;

typedef struct _MIDICLASSINFO {
    ULONG ulStructLength;
    ULONG ulClassNumber;
    CHAR  szmClassName[MIDI_NAME_LENGTH];
    ULONG ulNumSlots;
    ULONG ulAttributes;
} MIDICLASSINFO, *PMIDICLASSINFO;

typedef struct _MIDIINSTANCEINFO {
    ULONG     ulStructLength;
    MINSTANCE minstance;
    ULONG     ulClassNumber;
    CHAR      szmInstanceName[MIDI_NAME_LENGTH];
    ULONG     ulNumLinks;
    ULONG     ulAttributes;
} MIDIINSTANCEINFO, *PMIDIINSTANCEINFO;

typedef (*PFNMIDI_NOTIFYCALLBACK)(ULONG,ULONG);

typedef struct _MIDISETUP {
    ULONG   ulStructLength;
    PULONG  pulMaxRTSysexLength;
    PPULONG ppulMIDICurrentTime;
    ULONG   ulFlags;
    PFNMIDI_NOTIFYCALLBACK pfnMIDI_NotifyCallback;
    HWND    hwndCallback;
    HQUEUE  hqueueCallback;
} MIDISETUP, *PMIDISETUP;

typedef struct _MIDIDEVICEINFO {
    ULONG     ulStructLength;
    MINSTANCE minstance;
    CHAR      szmInstanceName[MIDI_NAME_LENGTH];
    CHAR      szDeviceName[MIDI_NAME_LENGTH];
    CHAR      szManufacturer[MIDI_NAME_LENGTH];
    CHAR      szModelName[MIDI_NAME_LENGTH];
    ULONG     ulFlags;
    ULONG     ulChannels;
} MIDIDEVICEINFO, *PMIDIDEVICEINFO;

typedef struct _MIDILINKINFO {
    ULONG     ulStructLength;
    ULONG     ulSlotNumber;
    MINSTANCE minstance;
} MIDILINKINFO, *PMIDILINKINFO;

ULONG APIENTRY MIDICreateInstance(ULONG,PMINSTANCE,PSZ,ULONG);
ULONG APIENTRY MIDIDeleteInstance(MINSTANCE,ULONG);
ULONG APIENTRY MIDIEnableInstance(MINSTANCE,ULONG);
ULONG APIENTRY MIDIDisableInstance(MINSTANCE,ULONG);
ULONG APIENTRY MIDIAddLink(MINSTANCE,MINSTANCE,ULONG,ULONG);
ULONG APIENTRY MIDIRemoveLink(MINSTANCE,MINSTANCE,ULONG,ULONG);
ULONG APIENTRY MIDISetDefaultHardwareNode(PSZ,ULONG);
ULONG APIENTRY MIDISetInstanceConfiguration(MINSTANCE,PVOID,ULONG,ULONG);
ULONG APIENTRY MIDISimpleOpen(PMINSTANCE,ULONG);
ULONG APIENTRY MIDISimpleClose(MINSTANCE,ULONG);
ULONG APIENTRY MIDIQueryClassList(ULONG,PMIDICLASSINFO,ULONG);
ULONG APIENTRY MIDIQueryDeviceInformation(ULONG,PMIDIDEVICEINFO,ULONG);
ULONG APIENTRY MIDIQueryInstanceConfiguration(ULONG,PVOID,ULONG,ULONG);
ULONG APIENTRY MIDIQueryInstanceLinks(MINSTANCE,PMIDILINKINFO,ULONG,ULONG);
ULONG APIENTRY MIDIQueryInstanceList(ULONG,PMIDIINSTANCEINFO,ULONG);
ULONG APIENTRY MIDIQueryInstanceName(MINSTANCE,PSZ,ULONG);
ULONG APIENTRY MIDIQueryNumClasses(PULONG,ULONG);
ULONG APIENTRY MIDIQueryNumDevices(PULONG,ULONG);
ULONG APIENTRY MIDIQueryNumInstances(PULONG,ULONG);
ULONG APIENTRY MIDIQueryVersion(PULONG);
ULONG APIENTRY MIDISetDeviceInformation(MINSTANCE,PMIDIDEVICEINFO,ULONG);
ULONG APIENTRY MIDISendMessages(PMESSAGE,ULONG,ULONG);
ULONG APIENTRY MIDISendSysexMessage(PMESSAGE,ULONG,ULONG);
ULONG APIENTRY MIDIRetrieveMessages(MINSTANCE,PVOID,PULONG,ULONG);
ULONG APIENTRY MIDISetup(PMIDISETUP,ULONG);
ULONG APIENTRY MIDITimer(ULONG,ULONG);
ULONG APIENTRY TimerSleep(ULONG,ULONG);
ULONG APIENTRY TimerGetPointer(PPULONG,ULONG);

#ifdef __cplusplus
}
#endif

#endif

