/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#include <windows.h>
#include <dos.h>
#include <malloc.h>
#include <stdarg.h>

extern CALLBACKPTR vGetCallbackRoutine( PROCPTR fn, va_list al );
extern void *UserProcs[];

/*
 * DefineUserProc16 - define a user callback
 *                  variable parms are either UPD16_CHAR, UPD16_WORD,
 *                  UPD16_DWORD, or UPD16_ENDLIST
 */
int DefineUserProc16( int entnum, PROCPTR routine, ... )
{
    va_list     al;

    if( entnum > GETPROC_USERDEFINED_32 ) {
        return( -1 );
    }
    entnum -= GETPROC_USERDEFINED_1;
    va_start( al, routine );
    UserProcs[ entnum] = vGetCallbackRoutine( routine, al );
    va_end( al );
    return( 0 );

} /* DefineUserProc16 */
