/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#include "variety.h"
#include <jstring.h>
#include <mbstring.h>

/**
*
*  Name:        jtohira         Ђ炪Ȃɕϊ
*
*  Synopsis:    nc = jtohira( c );
*
*               JMOJI nc;       ϊSp
*               JMOJI c;        ϊSp
*
*  Description: ^ꂽSpϊBjtolower͑啶
*               ɁAjtoupper͏啶ɕϊB
*               jtohira ̓J^JiЂ炪ȂɁAjtokata ͂Ђ炪
*               J^JiɕϊB
*
*  Returns:     ϊs\̏ꍇ͂Ȃɂc ̒lԂB
*
*
*  Name:        jtohira         Convert to Hiragana of 2-byte KANJI code
*
*  Synopsis:    nc = jtohira( c );
*
*               JMOJI nc;       Hiragana of 2-byte KANJI code
*               JMOJI c;        2-byte KANJI code
*
*  Description: Convert to given 2-byte KANJI code. Jtolower converts upper
*               case 2-byte KANJI code to lower case, jtoupper converts lower
*               case 2-byte KANJI code to upper case. Jtohira converts
*               katakana 2-byte KANJI code to hiragana and jtokata hiragana
*               2-byte KANJI code to katakana.
*
*  Returns:     If it is not able to be converted, it returns the value of c.
*
**/

_WCRTLINK unsigned int _mbctohira( unsigned int ch )
{
    return( jtohira( ch ) );
}


_WCRTLINK JMOJI jtohira( JMOJI c )
{
    if( jiskana( c ) && c <= 0x8393 )
        c -= ( c < 0x837f ) ? 0xa1 : 0xa2;
    return( c );
}
