/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#ifndef WDETOOLB_INCLUDED
#define WDETOOLB_INCLUDED

#include "toolbr.h"

/****************************************************************************/
/* macro definitions                                                        */
/****************************************************************************/

/****************************************************************************/
/* type definitions                                                         */
/****************************************************************************/
typedef void *toolbar;

typedef struct {
    TOOLDISPLAYINFO    dinfo;
    TOOLITEMINFO      *items;
    int                num_items;
} WdeToolBarInfo;

typedef struct {
    toolbar            tbar;
    WdeToolBarInfo    *info;
    HWND               parent;
    HWND               win;
    RECT               last_pos;
} WdeToolBar;

/****************************************************************************/
/* function prototypes                                                      */
/****************************************************************************/
extern WdeToolBar     *WdeCreateToolBar       ( WdeToolBarInfo *, HWND );
extern void            WdeDestroyToolBar      ( WdeToolBar * );
extern void            WdeShutdownToolBars    ( void );
extern void            WdeFreeToolBarInfo     ( WdeToolBarInfo * );
extern WdeToolBarInfo *WdeAllocToolBarInfo    ( int );
extern void            WdeSetToolBarItemState ( WdeToolBar *, UINT, UINT );
extern Bool            WdeCloseToolBar        ( WdeToolBar * );
extern void            WdeFreeToolBar         ( WdeToolBar * );
extern void            WdeHandleToolHint      ( WPARAM, BOOL );
extern void            WdeHandleStickyToolPress ( WdeToolBar *,
                                                WPARAM, LPARAM );

#endif
