/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


//
// IFFLAGS   : intrinsic function flags
//

#include "ftnstd.h"
#include "ifflags.h"
#include "symflgs.h"

// Table Bit Map
// +==========+==================+======================+====================+
// |  15  14  |  13  12  11  10  |  09  08  07  06  05  | 04  03  02  01  00 |
// +----------+------------------+----------------------+--------------------+
// | Generic &| Empty            | Function Return type | Parameter Type     |
// | Argument | For future use   | See ifflags.h        | See symflgs.h      |
// | bits     |                  |                      |                    |
// +==========+==================+======================+====================+

const unsigned_16 __FAR IFFlags[] = {
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ABS
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ACOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_REAL      | TY_COMPLEX  , // AIMAG
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // AINT
    IF_NOT_GEN | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ALGAMA
    IF_NOT_GEN | IF_NOT_ARG | IFT_LOGICAL   | IF_NO_TYPE  , // ALLOCATED
    IF_NOT_GEN | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ALOG
    IF_NOT_GEN | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ALOG10
    IF_NOT_GEN | IF_NOT_ARG | IFT_REAL      | TY_INTEGER  , // AMAX0
    IF_NOT_GEN | IF_NOT_ARG | IFT_REAL      | TY_REAL     , // AMAX1
    IF_NOT_GEN | IF_NOT_ARG | IFT_REAL      | TY_INTEGER  , // AMIN0
    IF_NOT_GEN | IF_NOT_ARG | IFT_REAL      | TY_REAL     , // AMIN1
    IF_NOT_GEN | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // AMOD
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ANINT
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ASIN
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ATAN
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ATAN2
    IF_GENERIC | IF_ARG_OK  | IFT_LOGICAL   | TY_INTEGER  , // BTEST
    IF_NOT_GEN | IF_ARG_OK  | IFT_REAL      | TY_COMPLEX  , // CABS
    IF_NOT_GEN | IF_ARG_OK  | IFT_COMPLEX   | TY_COMPLEX  , // CCOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DCOMPLEX , // CDABS
    IF_NOT_GEN | IF_ARG_OK  | IFT_DCOMPLEX  | TY_DCOMPLEX , // CDCOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_DCOMPLEX  | TY_DCOMPLEX , // CDEXP
    IF_NOT_GEN | IF_ARG_OK  | IFT_DCOMPLEX  | TY_DCOMPLEX , // CDLOG
    IF_NOT_GEN | IF_ARG_OK  | IFT_DCOMPLEX  | TY_DCOMPLEX , // CDSIN
    IF_NOT_GEN | IF_ARG_OK  | IFT_DCOMPLEX  | TY_DCOMPLEX , // CDSQRT
    IF_NOT_GEN | IF_ARG_OK  | IFT_COMPLEX   | TY_COMPLEX  , // CEXP
    IF_NOT_GEN | IF_NOT_ARG | IFT_CHAR      | TY_INTEGER  , // CHAR
    IF_NOT_GEN | IF_ARG_OK  | IFT_COMPLEX   | TY_COMPLEX  , // CLOG
    IF_GENERIC | IF_NOT_ARG | IFT_COMPLEX   | IF_NO_TYPE  , // CMPLX
    IF_GENERIC | IF_ARG_OK  | IFT_COMPLEX   | TY_COMPLEX  , // CONJG
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // COS
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // COSH
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // COTAN
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_XCOMPLEX , // CQABS
    IF_NOT_GEN | IF_ARG_OK  | IFT_XCOMPLEX  | TY_XCOMPLEX , // CQCOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_XCOMPLEX  | TY_XCOMPLEX , // CQEXP
    IF_NOT_GEN | IF_ARG_OK  | IFT_XCOMPLEX  | TY_XCOMPLEX , // CQLOG
    IF_NOT_GEN | IF_ARG_OK  | IFT_XCOMPLEX  | TY_XCOMPLEX , // CQSIN
    IF_NOT_GEN | IF_ARG_OK  | IFT_XCOMPLEX  | TY_XCOMPLEX , // CQSQRT
    IF_NOT_GEN | IF_ARG_OK  | IFT_COMPLEX   | TY_COMPLEX  , // CSIN
    IF_NOT_GEN | IF_ARG_OK  | IFT_COMPLEX   | TY_COMPLEX  , // CSQRT
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DABS
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DACOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DASIN
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DATAN
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DATAN2
    IF_GENERIC | IF_NOT_ARG | IFT_DOUBLE    | IF_NO_TYPE  , // DBLE
    IF_GENERIC | IF_NOT_ARG | IFT_DCOMPLEX  | IF_NO_TYPE  , // DCMPLX
    IF_NOT_GEN | IF_ARG_OK  | IFT_DCOMPLEX  | TY_DCOMPLEX , // DCONJG
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DCOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DCOSH
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DCOTAN
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DDIM
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DERF
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DERFC
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DEXP
    IF_NOT_GEN | IF_NOT_ARG | IFT_DOUBLE    | TY_INTEGER  , // DFLOAT
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DGAMMA
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // DIM
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DCOMPLEX , // DIMAG
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DINT
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DLGAMA
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DLOG
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DLOG10
    IF_NOT_GEN | IF_NOT_ARG | IFT_DOUBLE    | TY_DOUBLE   , // DMAX1
    IF_NOT_GEN | IF_NOT_ARG | IFT_DOUBLE    | TY_DOUBLE   , // DMIN1
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DMOD
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DNINT
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_REAL     , // DPROD
    IF_NOT_GEN | IF_NOT_ARG | IFT_DOUBLE    | TY_DCOMPLEX , // DREAL
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DSIGN
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DSIN
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DSINH
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DSQRT
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DTAN
    IF_NOT_GEN | IF_ARG_OK  | IFT_DOUBLE    | TY_DOUBLE   , // DTANH
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ERF
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // ERFC
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // EXP
    IF_NOT_GEN | IF_NOT_ARG | IFT_REAL      | TY_INTEGER  , // FLOAT
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // GAMMA
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_REAL     , // HFIX
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1ABS
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1AND
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1BCHNG
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1BCLR
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1BSET
    IF_NOT_GEN | IF_ARG_OK  | IFT_LOGICAL   | TY_INTEGER_1, // I1BTEST
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1DIM
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1EOR
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1LSHIFT
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER_1 | TY_INTEGER_1, // I1MAX0
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER_1 | TY_INTEGER_1, // I1MIN0
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1MOD
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1NOT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1OR
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1RSHIFT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1SHA
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1SHC
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1SHFT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1SHL
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_1 | TY_INTEGER_1, // I1SIGN
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2ABS
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2AND
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2BCHNG
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2BCLR
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2BSET
    IF_NOT_GEN | IF_ARG_OK  | IFT_LOGICAL   | TY_INTEGER_2, // I2BTEST
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2DIM
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2EOR
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2LSHIFT
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER_2 | TY_INTEGER_2, // I2MAX0
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER_2 | TY_INTEGER_2, // I2MIN0
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2MOD
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2NOT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2OR
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2RSHIFT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2SHA
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2SHC
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2SHFT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2SHL
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER_2 | TY_INTEGER_2, // I2SIGN
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IABS
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IAND
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IBCHNG
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IBCLR
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IBSET
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_CHAR     , // ICHAR
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IDIM
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_DOUBLE   , // IDINT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_DOUBLE   , // IDNINT
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IEOR
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_REAL     , // IFIX
    IF_GENERIC | IF_NOT_ARG | IFT_NOTYPE    | IF_NO_TYPE  , // IMAG
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_CHAR     , // INDEX
    IF_GENERIC | IF_NOT_ARG | IFT_INTEGER   | TY_REAL     , // INT
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // IOR
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_EXTENDED , // IQINT
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_EXTENDED , // IQNINT
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // ISHA
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // ISHC
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // ISHFT
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // ISHL
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // ISIGN
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | IF_NO_TYPE  , // ISIZEOF
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_CHAR     , // LEN
    IF_NOT_GEN | IF_ARG_OK  | IFT_INTEGER   | TY_CHAR     , // LENTRIM
    IF_GENERIC | IF_NOT_ARG | IFT_NOTYPE    | IF_NO_TYPE  , // LGAMMA
    IF_NOT_GEN | IF_NOT_ARG | IFT_LOGICAL   | TY_CHAR     , // LGE
    IF_NOT_GEN | IF_NOT_ARG | IFT_LOGICAL   | TY_CHAR     , // LGT
    IF_NOT_GEN | IF_NOT_ARG | IFT_LOGICAL   | TY_CHAR     , // LLE
    IF_NOT_GEN | IF_NOT_ARG | IFT_LOGICAL   | TY_CHAR     , // LLT
    IF_GENERIC | IF_NOT_ARG | IFT_INTEGER   | IF_NO_TYPE  , // LOC
    IF_GENERIC | IF_NOT_ARG | IFT_NOTYPE    | IF_NO_TYPE  , // LOG
    IF_GENERIC | IF_NOT_ARG | IFT_NOTYPE    | IF_NO_TYPE  , // LOG10
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // LSHIFT
    IF_GENERIC | IF_NOT_ARG | IFT_NOTYPE    | IF_NO_TYPE  , // MAX
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_INTEGER  , // MAX0
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_REAL     , // MAX1
    IF_GENERIC | IF_NOT_ARG | IFT_NOTYPE    | IF_NO_TYPE  , // MIN
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_INTEGER  , // MIN0
    IF_NOT_GEN | IF_NOT_ARG | IFT_INTEGER   | TY_REAL     , // MIN1
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // MOD
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_REAL     , // NINT
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // NOT
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QABS
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QACOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QASIN
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QATAN
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QATAN2
    IF_GENERIC | IF_NOT_ARG | IFT_XCOMPLEX  | IF_NO_TYPE  , // QCMPLX
    IF_NOT_GEN | IF_ARG_OK  | IFT_XCOMPLEX  | TY_XCOMPLEX , // QCONJG
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QCOS
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QCOSH
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QCOTAN
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QDIM
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QERF
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QERFC
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QEXP
    IF_GENERIC | IF_NOT_ARG | IFT_EXTENDED  | IF_NO_TYPE,   // QEXT
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QGAMMA
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_XCOMPLEX , // QIMAG
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QINT
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QLGAMA
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QLOG
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QLOG10
    IF_NOT_GEN | IF_NOT_ARG | IFT_EXTENDED  | TY_EXTENDED , // QMAX1
    IF_NOT_GEN | IF_NOT_ARG | IFT_EXTENDED  | TY_EXTENDED , // QMIN1
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QMOD
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QNINT
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_DOUBLE   , // QPROD
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QSIGN
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QSIN
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QSINH
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QSQRT
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QTAN
    IF_NOT_GEN | IF_ARG_OK  | IFT_EXTENDED  | TY_EXTENDED , // QTANH
    IF_GENERIC | IF_NOT_ARG | IFT_REAL      | TY_INTEGER  , // REAL
    IF_GENERIC | IF_ARG_OK  | IFT_INTEGER   | TY_INTEGER  , // RSHIFT
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // SIGN
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // SIN
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // SINH
    IF_NOT_GEN | IF_NOT_ARG | IFT_REAL      | TY_DOUBLE   , // SNGL
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // SQRT
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // TAN
    IF_GENERIC | IF_ARG_OK  | IFT_REAL      | TY_REAL     , // TANH
    IF_GENERIC | IF_NOT_ARG | IFT_NOTYPE    | TY_NO_TYPE  , // VOLATILE
};
