/*
 * Program to calculate a fibonacci number.
 *
 * This demonstrates a heavily RECURSIVE function.
 *
 * Compile command: cc fibo -fop
 */
#include <stdio.h>

#define MAXFIB	24	/* Largest we can do in 16 bits */

/*
 * Recursive function to calculate a fibonacci number
 */
unsigned fibo(unsigned num)
{
	if(num <= 2)
		return 1;

	return fibo(num-1) + fibo(num-2);
}

/*
 * Main function to call "fibo" in a loop,
 * and display the result.
 */
main()
{
	int i;

	for(i=1; i <= MAXFIB; ++i)
		printf("Fibonacci(%u) = %u\n", i, fibo(i));
}
