
COMMENT ~

Micro-C v3.14 by Dave Dunfield

STARTUP CODE

Reconstructed and modified by Pavel Podvoiski <paulpp@iname.com>

With help of OBJASM version 2.0

Changes, compared to original PC86RL_x.OBJ:

- Pogramm can be loaded in less than 64K (particulary in UMB).

- Now main(int argc, char **argv) can _return_ value 0..255 as ERRORLEVEL.

- Arglist not limited to 80 chars.

- In cmdline any char <= ' ' treated as space.

- Anything in cmdline inbetween quotas (") goes to one argv[]. Quotas 
  NOT included. To include quota in argv[] -- double it ("").

~

; uncomment next line to compile SMALL model or use define in asm cmdline
;__SMALL__	EQU	1


CSEG	SEGMENT	PARA PUBLIC 'CODE'	; code
CSEG	ENDS

DSEG	SEGMENT	PARA PUBLIC 'IDATA'	; initialized data
DSEG	ENDS

BSEG	SEGMENT	BYTE PUBLIC 'UDATA'	; uninitialized data
BSEG	ENDS

MSEG	SEGMENT	BYTE PUBLIC 'UDATA'	; heap
MSEG	ENDS


IFDEF	__SMALL__

SSEG	SEGMENT	WORD STACK 'STACK'
SSEG	ENDS

DGRP	GROUP	DSEG, BSEG, MSEG, SSEG

ELSE

DGRP	GROUP	CSEG, DSEG, BSEG, MSEG

ENDIF


	; used by MCC-generated asm code
	; CX ?op AX result in AX (0 or 1), also Z-flag
	PUBLIC	?eq
	PUBLIC	?ne
	PUBLIC	?lt
	PUBLIC	?le
	PUBLIC	?gt
	PUBLIC	?ge
	PUBLIC	?ult
	PUBLIC	?ule
	PUBLIC	?ugt
	PUBLIC	?uge
	PUBLIC	?not
	PUBLIC	?switch
	PUBLIC	?temp	; also begining of BSEG


	PUBLIC	?heap	; begining of MSEG (used by MCLIB)

	PUBLIC	_stdin
	PUBLIC	_stdout
	PUBLIC	_stderr		;XXX

	PUBLIC	_PSP
	PUBLIC	_ENV
	PUBLIC	_ARGC
	PUBLIC	_ARGV


	EXTRN	_main:NEAR



CSEG	SEGMENT

IFnDEF	__SMALL__
	ORG	100h
ENDIF
	ASSUME	cs:CSEG, ds:DGRP, ss:DGRP

$STARTUP:

	mov	ax,DS:[2Ch]	; env seg
	mov	bx,DS:[02h]	; mem top seg
IFDEF	__SMALL__
	mov	dx,seg DGRP
	mov	ds,dx
ELSE
	mov	dx,ds
ENDIF
	mov	_ENV,ax
	mov	_PSP,es

	add	dx,1000h	; calculate new mem top (64K data seg)
	cmp	dx,bx		; cmp to DOS mem top
	ja	$10		; we have less than 64K, left as is
	mov	bx,dx
$10:
	; BX = new mem top

; init stack BEFORE shrinking memory

	mov	ax,ds
	sub	ax,bx
	neg	ax	; AX = size of dataseg in para
	mov	cl,4
	shl	ax,cl	; calc new SP
	mov	dx,ds

	mov	ss,dx
	mov	sp,ax	; Yes, for 64K it is 0. First push will wrap around.

; resize program's memory block. ES should contain PSP seg

	sub	bx,_PSP
	mov	ah,4Ah
	int	21h

; zeroing uninitialized data

	mov	di,offset DGRP:?temp
	mov	cx,offset DGRP:?heap+2
	sub	cx,di
	push	ds
	pop	es
	xor	al,al
	cld
	rep	stosb

; prepare **argv

	mov	bx,offset DGRP:_ARGV
	mov	si,offset DGRP:$args
	push	_PSP

	; argv[0]

	xor	di,di
	mov	es,_ENV		; ES:DI -> environment

	mov	[bx],si		; set argv[0]
	inc	bx
	inc	bx

	xor	al,al
$20:	scasb			; search for "\0\0"
	jne	$20
	scasb
	jne	$20
	add	di,2		; ES:DI -> *argv[0]

	push	ds		; swap ES:DI <-> DS:SI for copying
	push	es
	pop	ds
	pop	es
	xchg	si,di

	mov	cx,79		; max path length
	rep	movsb
	inc	di		; form ending '\0' for sure

	; argv[1], ...

	pop	ds		; DS = PSP
	mov	si,81h		; DS:SI -> cmdline
	xor	cx,cx
	mov	cl,DS:[80h]	; CX = cmdline length

$40:	jcxz	$70		; EOL
	lodsb
	dec	cx
$42:	cmp	al,' '
	jbe	$40

	mov	ES:[bx],di	; set *argv[i]
	inc	bx
	inc	bx

	cmp	al,'"'
	jne	$60

$50:	jcxz	$70		; process "..."
	lodsb
	dec	cx
	cmp	al,'"'
	jne	$55

	jcxz	$70		; process double quotas ("")
	lodsb
	dec	cx
	cmp	al,'"'
	je	$55

	inc	di
	jmp	short $42

$55:	stosb
	jmp	short $50
	
$60:	stosb			; copy argv[i]
	jcxz	$70
	lodsb
	dec	cx
	cmp	al,' '
	ja	$60
	
	inc	di		; form ending '\0'
	jmp	short $40

$70:	push	es
	pop	ds		; restore DS to DGRP seg

	sub	bx,offset DGRP:_ARGV
	shr	bx,1
	mov	_ARGC,bx

;CALL: int main(int argc, char **argv)

	push	_ARGC
	mov	ax,offset DGRP:_ARGV
	push	ax
	call	_main		; GO!!
	mov	ah,4Ch		; return code in AL (0..255)
	int	21h


; Micro-C required

?eq:	cmp	ax,cx
	jz	?1
	xor	ax,ax
	ret
?ne:	cmp	ax,cx
	jnz	?1
	xor	ax,ax
	ret
?lt:	cmp	ax,cx
	jg	?1
	xor	ax,ax
	ret
?le:	cmp	ax,cx
	jnl	?1
	xor	ax,ax
	ret
?gt:	cmp	ax,cx
	jl	?1
	xor	ax,ax
	ret
?ge:	cmp	ax,cx
	jng	?1
	xor	ax,ax
	ret
?ult:	cmp	ax,cx
	jnbe	?1
	xor	ax,ax
	ret
?ule:	cmp	ax,cx
	jnc	?1
	xor	ax,ax
	ret
?ugt:	cmp	ax,cx
	jc	?1
	xor	ax,ax
	ret
?uge:	cmp	ax,cx
	jbe	?1
 ?0:	xor	ax,ax
	ret
?not:	and	ax,ax
	jnz	?0
 ?1:	mov	ax,0001h
	and	ax,ax
	ret
?switch:
	mov	cx,CS:[bx]
	jcxz	?def
	add	bx,+004h
	cmp	ax,CS:[bx-002h]
	jnz	?switch
	jmp	cx
 ?def:	jmp	CS:[bx+002h]

CSEG	ENDS



DSEG	SEGMENT

$STDI	db	001h	; options
	dw	0	; handle
	dw	25	; iob_size	Buffer size
	dw	0	; io_ptr	Access pointer into buffer
	dw	0	; io_top	Amount of buffer used
	db	'MICRO-C by Dave Dunfield',0	; buffer

$STDO	db	002h
	dw	1
	dw	1
	dw	0
	dw	0
	db	0

_stdin	dw	DGRP:$STDI	; *stdin
_stdout	dw	DGRP:$STDO	; *stdout
_stderr	db	002h	; stderr[]	what so special about stderr?
	dw	2
	dw	1
	dw	1
	dw	0
	dw	0
	db	0

_PSP	dw	?
_ENV	dw	?

DSEG	ENDS


BSEG	SEGMENT

?temp	dw	?		; Micro-C required

_ARGC	dw	?
_ARGV	dw	65 dup(?)	; max possible _ARGC
$args	db	80 dup(?)	; max sizeof(argv[0])
	db	128 dup(?)	; argv[1], ...

BSEG	ENDS


MSEG	SEGMENT
?heap	LABEL	WORD
MSEG	ENDS


IFDEF	__SMALL__

SSEG	SEGMENT
	db	256 dup(?)	; minimal initial stack
SSEG	ENDS

ENDIF

	END	$STARTUP
