/*
 * 16550a FIFO CONTROL - Contributed by Michael Watson
 *
 * Compile command: cc 16550a -fop
 */
#include <stdio.h>

#define	BIOS_SEG		0x40		/* BIOS data segment */
#define	FIFO_OFFSET		0x02		/* Offset to 16550A FIFO ctrl reg. */
#define	ENABLE_FIFO		0x07		/* Ctrl reg. value to enable fifo  */
#define	DISABLE_FIFO	0x00		/* Ctrl reg. value to disable fifo */
#define	FIFO_ENABLED	0xC1		/* Status of enabled fifo */
#define	FIFO_DISABLED	0x01		/* Status of disabled fifo */

int main(int argc, char *argv[])
{
	unsigned port, address, status;
	static char option = '?';
	static char help_text[] = { "\nUse: 16550a <1-4> [Enable|Disable|?]\n" };

	printf("\n16550A UART FIFO CONTROL\n");

	/* Process command line arguments */
	switch(argc) {
		case 3:	option = toupper(*argv[2]);
		case 2:	port = atoi(argv[1]);
			if((port >= 1) && (port <= 4)) 
				break;
		default: abort(help_text); }

	/* Obtain com port address from table at BIOS_SEG:0 */
	/* and offset to the FIFO control register			*/
	address = peekw(BIOS_SEG, (port - 1) * 2) + FIFO_OFFSET;

	/* Enable/Disable FIFO if so specified */
	switch(option) {
		default: abort(help_text);
		case 'E': out(address, ENABLE_FIFO); break;
		case 'D': out(address, DISABLE_FIFO);
		case '?':  }

	/* Retrieve and display FIFO status */
	printf("FIFO COM%u: ", port);
	switch (status = in(address)) {
		case FIFO_DISABLED:	printf("not enabled\n");	break;
		case FIFO_ENABLED:	printf("enabled\n");		break;
		default:	printf("status unknown code %x\n", status); }

	return 0;
}
