/*
 * Program to patch the FREELINK.EXE linker to make it case sensitive.
 * This is necessary for proper linking of C programs.
 *
 * 1) Install MicroC/PC for use with FREELINK   : mcsetup (+ see docs)
 * 2) Go to the CUTIL subdirectory              : cd \mc\examples\cutil
 * 5) Compile the FIXLINK program               : cc fixlink -fop
 * 6) Go to directory where FREELINK is located : cd \mc  (or wherever)
 * 7) Run the FIXLINK program                   : \mc\examples\cutil\fixlink
 * 8) Copy FRECLINK.EXE to replace FREELINK.EXE : copy FRECLINK.EXE FREELINK.EXE
 *    - or -
 * 8a) Make sure you are in Micro-C directory   : cd \mc
 * 8b) Edit CC.C LC.BAT and PC86.IDE to change all FREELINK's to FRECLINK's
 * 8c) Recompile CC.C                           : cc cc -fop
 *
 * Compile command: cc fixlink -fop
 */
#include <stdio.h>

#define	SIZE_HIGH	0x0001		// High size of file
#define	SIZE_LOW	0x46CF		// Low size of file

#define	FIX1_LOW	0x5B45		// Offset for 1st patch
#define	FIX2_LOW	0x6803		// Offset for 2nd patch

#define	PATCH_OLD	0x20		// Old byte to replace
#define	PATCH_NEW	0x00		// New byte to substitute

char message1[] = { "\n\
This program patches the freeware linker FREELINK.EXE to make it case\n\
sensitive to names in the object modules. This is necessary for proper\n\
linking of C programs. This works only on FREELINK.EXE dated 11-08-92,\n\
which is 83663 bytes in size, which must be present in your current\n\
directory.\n\n\
"};

char message2[] = { "\n\
You now have FRECLINK.EXE, which is a version of FREELINK that observes\n\
case sensivity. If you like, you can simply copy this over FREELINK.EXE\n\
to enable case sensitivity in all of your linking. If you prefer, you can\n\
keep both linkers and modify CC.C, LC.BAT and PC86.IDE to use FRECLINK\n\
instead of FREELINK (NOTE: You will have to recompile CC.C after this).\n\
"};

main()
{
	unsigned ph, pl;
	int c;
	FILE *fpi, *fpo;

	fputs(message1, stdout);

	fpi = fopen("FREELINK.EXE", "rvqb");	// Input file
	fpo = fopen("FRECLINK.EXE", "wvqb");	// Output file

	ph = pl = 0;
	while((c = getc(fpi)) >= 0) {
		if(((pl == FIX1_LOW) || (pl == FIX2_LOW)) && !ph) {
			if(c != PATCH_OLD) {
				printf("\7*** Failed: existing byte at %x%04x is %02x, but should be %02x\n\n",
					ph, pl, c, PATCH_OLD);
				goto quit; }
			c = 0x00; }
		putc(c, fpo);
		if(!++pl)
			++ph; }

quit:
	fclose(fpo);
	fclose(fpi);
	printf("%x%04x bytes were written to %s!\n", ph, pl, "FRECLINK.EXE");
	if((ph != SIZE_HIGH) || (pl != SIZE_LOW)) {
		printf("\n\7*** File size incorrect! Should be: %x%04x\n", SIZE_HIGH, SIZE_LOW);
		delete("FRECLINK.EXE");
		printf("\nCorrupt %s has been deleted!\n", "FRECLINK.EXE");
		return; }

	fputs(message2, stdout);
}
