/*
 * $Header: /usr/src/dostools/d2u.c,v 1.3 1994/09/08 08:43:13 patv Exp $
 *
 * d2u:
 *	dos to unix text file converter
 */

/*
 * $Log: d2u.c,v $
 * Revision 1.3  1994/09/08  08:43:13  patv
 * Fixed typo in Copyright
 *
 * Revision 1.2  1994/09/08  08:38:59  patv
 * Added RcsHeader and Copyright strings to identify binary.
 *
 * Revision 1.1  1994/09/08  08:34:07  patv
 * Initial revision
 *
 */

#include <stdio.h>

/* Simple version -- only works as a pipe (for now) */

/* Local defines							*/
/* Conviences for portability and legibility				*/
#ifndef TRUE
# define TRUE (1==1)
#endif
#ifndef FALSE
# define FALSE (0==1)
#endif
/* DOS related definitions						*/
#define CTL_Z	0x1a

/* Identify the current version						*/
char	*RcsHeader = "$Header: /usr/src/dostools/d2u.c,v 1.3 1994/09/08 08:43:13 patv Exp $",
	*Copyright =
		"Copyright (c) 1994\nby Pasquale J. Villani\nAll rights reserved\n";



int main(int nArgc, char *pArgv[])
{
	FILE *pInputFp = stdin;
	FILE *pOutputFp = stdout;
	int wcChar;

	/* Translate the file one character at a time			*/
	while((wcChar = getc(pInputFp)) != EOF)
	{
		int bEof;

		/* Look at the character, and translate it, if 		*/
		/* necessary						*/
		switch(wcChar)
		{
		/* When a control Z (0x1a) is encountered, its a 	*/
		/* dos EOF						*/
		case CTL_Z:
			bEof = TRUE;
			break;

		/* newlines for DOS are CR-LF pairs, so throw out the	*/
		/* CR							*/
		case '\r':
			break;

		default:
			putc(wcChar, pOutputFp);
			break;
		}

		/* now done with char, let's see if its time to end	*/
		/* ran into a DOS control Z				*/
		if(bEof)
			break;
	}
}


