/*
This file is an almost complete machine description file of the MC68000
family for the lburg code generator generator.  What's missing can be
easily filled in for a specific MC68k assembler.  A change must be made to
config.h in order to use this file.  The Xnode struct's kids field must be
enlarged to 4.  A completed version of this file forms the basis for the
MPW version of the lcc compiler targeted for the Apple Macintosh.  The code
emitted by this specification is for the Apple MPW Assembler which has a
syntax similar to Motorola's assembler. A major difference between this
lburg specification and the examples in the lcc distribution is that switch
statement tables are stored in the code segment and are addressed by the pc
relative addressing mode.

Registers A2-A7,D3-D7,FP4-FP7 are preserved across function calls.
Registers D0 and FP0 store function results.  Parameters are passed from
right to left on the stack.  All floating point values are first promoted
to Motorola extended format before being pushed on the stack.

Here are some benchmark results of some compilers available for the Apple
Macintosh.  The programs are similar to those found in the Hennessy suite.
MPW C is the Apple C compiler. Gcc is the MPW port of gcc version
1.37.1r15. SC is the Symantec C compiler (ex-Zortech with m68k backend).
SCG is the Symantec C compiler with all optimizations on.  This compiler
does global optimizations.  LCC is the lcc compiler produced with this
machine description file.  MW is the Metrowerks 68k C compiler from Code
Warrior.  All tests were run on a Macintosh Centris 650 with MC68040 @25MHz
using 020 addressing modes and FPU.

        MPW C   gcc     gcc -O  SC      SCG     LCC     MW opt
Perm     13     13       11     17      19      12        22
Towers   12     15       10     17      16      12        11
Queens    6      7        5     7        8       8         4
Intmm    19     18       16     18      11      19        17
Mm       17     19       16     18      10      20        18
Puzzle   68     86       48     74      35      74        47
Quick     8     10        5     13      11       8        14
Bubble   11     16        7     19      10      12        11
FFT      25     28       16     24      20      25        19

Hopefully this file will prove useful to those wishing to target lcc to
Atari's, Amiga's, Sun's and Next's.  Let me know if you retarget lcc to any
other m68k machines using this file.
Please report any bugs to:

Woodrow Yeung
yeung@reed.edu

*/
enum { D0, D1, D2, D3, D4, D5, D6, D7 };
enum { A0, A1, A2, A3, A4, A5, A6, A7 };
enum { FP0, FP1, FP2, FP3, FP4, FP5, FP6, FP7 };
#define realparamsize 12
#include "c.h"
#define NODEPTR_TYPE Node
#define OP_LABEL(p) ((p)->op)
#define LEFT_CHILD(p) ((p)->kids[0])
#define RIGHT_CHILD(p) ((p)->kids[1])
#define STATE_LABEL(p) ((p)->x.state)
static void address ARGS((Symbol, Symbol, int));
static void blkfetch    ARGS((int, int, int, int));
static void blkloop ARGS((int, int, int, int, int, int[]));
static void blkstore    ARGS((int, int, int, int));
static void defaddress  ARGS((Symbol));
static void defconst    ARGS((int, Value));
static void defstring   ARGS((int, char *));
static void defsymbol   ARGS((Symbol));
static void doarg   ARGS((Node));
static void emit2   ARGS((Node));
static void export  ARGS((Symbol));
static void clobber ARGS((Node));
static void function    ARGS((Symbol, Symbol [], Symbol [], int));
static void global  ARGS((Symbol));
static void import  ARGS((Symbol));
static void local   ARGS((Symbol));
static void progbeg ARGS((int, char **));
static void progend ARGS((void));
static void segment ARGS((int));
static void space   ARGS((int));
static void target  ARGS((Node));

static int sametree ARGS((Node, Node));
static int memop ARGS((Node));

static Symbol ireg[32], *dreg = &ireg[0], areg[32], freg[32];
 
static int cseg;
 
/*
generated at Sun Apr 14 06:43:36 1996
by $Id: lburg.c,v 2.2.1.2 1995/12/20 19:09:53 drh Exp $
*/
static void _kids ARGS((NODEPTR_TYPE, int, NODEPTR_TYPE[]));
static void _label ARGS((NODEPTR_TYPE));
static int _rule ARGS((void*, int));

#define _stmt_NT 1
#define _reg_NT 2
#define _con_NT 3
#define _disp16_NT 4
#define _disp8_NT 5
#define _base_NT 6
#define _basei_NT 7
#define _addr_NT 8
#define _acon_NT 9
#define _table_NT 10
#define _index_NT 11
#define _scf_NT 12
#define _case_NT 13
#define _avar_NT 14
#define _con0_NT 15
#define _con3_NT 16
#define _mem_NT 17
#define _pcrel_NT 18
#define _ri_NT 19
#define _ri3_NT 20
#define _ea0_NT 21
#define _ea1_NT 22
#define _ea3_NT 23

static char *_ntname[] = {
	0,
	"stmt",
	"reg",
	"con",
	"disp16",
	"disp8",
	"base",
	"basei",
	"addr",
	"acon",
	"table",
	"index",
	"scf",
	"case",
	"avar",
	"con0",
	"con3",
	"mem",
	"pcrel",
	"ri",
	"ri3",
	"ea0",
	"ea1",
	"ea3",
	0
};

struct _state {
	short cost[24];
	struct {
		unsigned int _stmt:7;
		unsigned int _reg:7;
		unsigned int _con:3;
		unsigned int _disp16:1;
		unsigned int _disp8:1;
		unsigned int _base:3;
		unsigned int _basei:3;
		unsigned int _addr:2;
		unsigned int _acon:1;
		unsigned int _table:1;
		unsigned int _index:2;
		unsigned int _scf:2;
		unsigned int _case:1;
		unsigned int _avar:2;
		unsigned int _con0:2;
		unsigned int _con3:2;
		unsigned int _mem:3;
		unsigned int _pcrel:1;
		unsigned int _ri:2;
		unsigned int _ri3:2;
		unsigned int _ea0:2;
		unsigned int _ea1:2;
		unsigned int _ea3:2;
	} rule;
};

static short _nts_0[] = { 0 };
static short _nts_1[] = { _reg_NT, 0 };
static short _nts_2[] = { _reg_NT, _disp16_NT, 0 };
static short _nts_3[] = { _basei_NT, 0 };
static short _nts_4[] = { _reg_NT, _disp8_NT, 0 };
static short _nts_5[] = { _reg_NT, _scf_NT, 0 };
static short _nts_6[] = { _base_NT, 0 };
static short _nts_7[] = { _index_NT, _basei_NT, 0 };
static short _nts_8[] = { _index_NT, _table_NT, 0 };
static short _nts_9[] = { _acon_NT, 0 };
static short _nts_10[] = { _addr_NT, 0 };
static short _nts_11[] = { _case_NT, 0 };
static short _nts_12[] = { _con_NT, 0 };
static short _nts_13[] = { _con3_NT, 0 };
static short _nts_14[] = { _mem_NT, 0 };
static short _nts_15[] = { _ri_NT, 0 };
static short _nts_16[] = { _reg_NT, _con3_NT, 0 };
static short _nts_17[] = { _reg_NT, _ea1_NT, 0 };
static short _nts_18[] = { _addr_NT, _mem_NT, _ri_NT, 0 };
static short _nts_19[] = { _reg_NT, _reg_NT, 0 };
static short _nts_20[] = { _addr_NT, _mem_NT, _reg_NT, 0 };
static short _nts_21[] = { _addr_NT, _mem_NT, 0 };
static short _nts_22[] = { _reg_NT, _ri3_NT, 0 };
static short _nts_23[] = { _reg_NT, _ea3_NT, 0 };
static short _nts_24[] = { _ea0_NT, 0 };
static short _nts_25[] = { _addr_NT, _ea1_NT, 0 };
static short _nts_26[] = { _addr_NT, _con0_NT, 0 };
static short _nts_27[] = { _addr_NT, _reg_NT, 0 };
static short _nts_28[] = { _pcrel_NT, 0 };
static short _nts_29[] = { _ea0_NT, _con0_NT, 0 };
static short _nts_30[] = { _avar_NT, 0 };

static short *_nts[] = {
	0,	/* 0 */
	_nts_0,	/* 1 */
	_nts_0,	/* 2 */
	_nts_0,	/* 3 */
	_nts_0,	/* 4 */
	_nts_0,	/* 5 */
	_nts_0,	/* 6 */
	_nts_1,	/* 7 */
	_nts_1,	/* 8 */
	_nts_1,	/* 9 */
	_nts_1,	/* 10 */
	_nts_1,	/* 11 */
	_nts_1,	/* 12 */
	_nts_1,	/* 13 */
	_nts_0,	/* 14 */
	_nts_0,	/* 15 */
	_nts_0,	/* 16 */
	_nts_0,	/* 17 */
	_nts_0,	/* 18 */
	_nts_1,	/* 19 */
	_nts_1,	/* 20 */
	_nts_1,	/* 21 */
	_nts_0,	/* 22 */
	_nts_0,	/* 23 */
	_nts_2,	/* 24 */
	_nts_0,	/* 25 */
	_nts_0,	/* 26 */
	_nts_3,	/* 27 */
	_nts_1,	/* 28 */
	_nts_4,	/* 29 */
	_nts_0,	/* 30 */
	_nts_0,	/* 31 */
	_nts_0,	/* 32 */
	_nts_0,	/* 33 */
	_nts_0,	/* 34 */
	_nts_0,	/* 35 */
	_nts_0,	/* 36 */
	_nts_1,	/* 37 */
	_nts_5,	/* 38 */
	_nts_6,	/* 39 */
	_nts_7,	/* 40 */
	_nts_8,	/* 41 */
	_nts_9,	/* 42 */
	_nts_1,	/* 43 */
	_nts_10,	/* 44 */
	_nts_0,	/* 45 */
	_nts_0,	/* 46 */
	_nts_0,	/* 47 */
	_nts_0,	/* 48 */
	_nts_0,	/* 49 */
	_nts_0,	/* 50 */
	_nts_0,	/* 51 */
	_nts_0,	/* 52 */
	_nts_10,	/* 53 */
	_nts_10,	/* 54 */
	_nts_11,	/* 55 */
	_nts_1,	/* 56 */
	_nts_12,	/* 57 */
	_nts_13,	/* 58 */
	_nts_1,	/* 59 */
	_nts_14,	/* 60 */
	_nts_15,	/* 61 */
	_nts_14,	/* 62 */
	_nts_15,	/* 63 */
	_nts_14,	/* 64 */
	_nts_15,	/* 65 */
	_nts_10,	/* 66 */
	_nts_15,	/* 67 */
	_nts_10,	/* 68 */
	_nts_10,	/* 69 */
	_nts_10,	/* 70 */
	_nts_10,	/* 71 */
	_nts_1,	/* 72 */
	_nts_1,	/* 73 */
	_nts_1,	/* 74 */
	_nts_1,	/* 75 */
	_nts_1,	/* 76 */
	_nts_16,	/* 77 */
	_nts_16,	/* 78 */
	_nts_17,	/* 79 */
	_nts_17,	/* 80 */
	_nts_17,	/* 81 */
	_nts_17,	/* 82 */
	_nts_17,	/* 83 */
	_nts_17,	/* 84 */
	_nts_18,	/* 85 */
	_nts_18,	/* 86 */
	_nts_18,	/* 87 */
	_nts_18,	/* 88 */
	_nts_17,	/* 89 */
	_nts_17,	/* 90 */
	_nts_19,	/* 91 */
	_nts_18,	/* 92 */
	_nts_18,	/* 93 */
	_nts_20,	/* 94 */
	_nts_1,	/* 95 */
	_nts_1,	/* 96 */
	_nts_21,	/* 97 */
	_nts_21,	/* 98 */
	_nts_22,	/* 99 */
	_nts_22,	/* 100 */
	_nts_22,	/* 101 */
	_nts_22,	/* 102 */
	_nts_23,	/* 103 */
	_nts_23,	/* 104 */
	_nts_23,	/* 105 */
	_nts_23,	/* 106 */
	_nts_23,	/* 107 */
	_nts_19,	/* 108 */
	_nts_1,	/* 109 */
	_nts_1,	/* 110 */
	_nts_1,	/* 111 */
	_nts_1,	/* 112 */
	_nts_10,	/* 113 */
	_nts_10,	/* 114 */
	_nts_10,	/* 115 */
	_nts_10,	/* 116 */
	_nts_1,	/* 117 */
	_nts_1,	/* 118 */
	_nts_1,	/* 119 */
	_nts_1,	/* 120 */
	_nts_1,	/* 121 */
	_nts_1,	/* 122 */
	_nts_1,	/* 123 */
	_nts_1,	/* 124 */
	_nts_1,	/* 125 */
	_nts_1,	/* 126 */
	_nts_1,	/* 127 */
	_nts_1,	/* 128 */
	_nts_1,	/* 129 */
	_nts_1,	/* 130 */
	_nts_1,	/* 131 */
	_nts_1,	/* 132 */
	_nts_24,	/* 133 */
	_nts_1,	/* 134 */
	_nts_25,	/* 135 */
	_nts_26,	/* 136 */
	_nts_25,	/* 137 */
	_nts_26,	/* 138 */
	_nts_27,	/* 139 */
	_nts_25,	/* 140 */
	_nts_26,	/* 141 */
	_nts_25,	/* 142 */
	_nts_26,	/* 143 */
	_nts_24,	/* 144 */
	_nts_10,	/* 145 */
	_nts_24,	/* 146 */
	_nts_10,	/* 147 */
	_nts_19,	/* 148 */
	_nts_1,	/* 149 */
	_nts_1,	/* 150 */
	_nts_1,	/* 151 */
	_nts_10,	/* 152 */
	_nts_10,	/* 153 */
	_nts_10,	/* 154 */
	_nts_10,	/* 155 */
	_nts_27,	/* 156 */
	_nts_21,	/* 157 */
	_nts_27,	/* 158 */
	_nts_21,	/* 159 */
	_nts_1,	/* 160 */
	_nts_1,	/* 161 */
	_nts_19,	/* 162 */
	_nts_19,	/* 163 */
	_nts_19,	/* 164 */
	_nts_19,	/* 165 */
	_nts_19,	/* 166 */
	_nts_19,	/* 167 */
	_nts_19,	/* 168 */
	_nts_19,	/* 169 */
	_nts_1,	/* 170 */
	_nts_1,	/* 171 */
	_nts_9,	/* 172 */
	_nts_28,	/* 173 */
	_nts_0,	/* 174 */
	_nts_29,	/* 175 */
	_nts_29,	/* 176 */
	_nts_17,	/* 177 */
	_nts_17,	/* 178 */
	_nts_17,	/* 179 */
	_nts_17,	/* 180 */
	_nts_17,	/* 181 */
	_nts_17,	/* 182 */
	_nts_17,	/* 183 */
	_nts_17,	/* 184 */
	_nts_17,	/* 185 */
	_nts_17,	/* 186 */
	_nts_19,	/* 187 */
	_nts_19,	/* 188 */
	_nts_19,	/* 189 */
	_nts_19,	/* 190 */
	_nts_19,	/* 191 */
	_nts_19,	/* 192 */
	_nts_19,	/* 193 */
	_nts_19,	/* 194 */
	_nts_19,	/* 195 */
	_nts_19,	/* 196 */
	_nts_19,	/* 197 */
	_nts_19,	/* 198 */
	_nts_30,	/* 199 */
	_nts_30,	/* 200 */
	_nts_30,	/* 201 */
	_nts_30,	/* 202 */
	_nts_1,	/* 203 */
	_nts_1,	/* 204 */
	_nts_1,	/* 205 */
};

static char _arity[] = {
	0,	/* 0 */
	0,	/* 1 */
	0,	/* 2 */
	0,	/* 3 */
	0,	/* 4 */
	0,	/* 5 */
	0,	/* 6 */
	0,	/* 7 */
	0,	/* 8 */
	0,	/* 9 */
	0,	/* 10 */
	0,	/* 11 */
	0,	/* 12 */
	0,	/* 13 */
	0,	/* 14 */
	0,	/* 15 */
	0,	/* 16 */
	0,	/* 17=CNSTF */
	0,	/* 18=CNSTD */
	0,	/* 19=CNSTC */
	0,	/* 20=CNSTS */
	0,	/* 21=CNSTI */
	0,	/* 22=CNSTU */
	0,	/* 23=CNSTP */
	0,	/* 24 */
	0,	/* 25 */
	0,	/* 26 */
	0,	/* 27 */
	0,	/* 28 */
	0,	/* 29 */
	0,	/* 30 */
	0,	/* 31 */
	0,	/* 32 */
	1,	/* 33=ARGF */
	1,	/* 34=ARGD */
	0,	/* 35 */
	0,	/* 36 */
	1,	/* 37=ARGI */
	0,	/* 38 */
	1,	/* 39=ARGP */
	0,	/* 40 */
	1,	/* 41=ARGB */
	0,	/* 42 */
	0,	/* 43 */
	0,	/* 44 */
	0,	/* 45 */
	0,	/* 46 */
	0,	/* 47 */
	0,	/* 48 */
	2,	/* 49=ASGNF */
	2,	/* 50=ASGND */
	2,	/* 51=ASGNC */
	2,	/* 52=ASGNS */
	2,	/* 53=ASGNI */
	0,	/* 54=ASGNU */
	2,	/* 55=ASGNP */
	0,	/* 56 */
	2,	/* 57=ASGNB */
	0,	/* 58 */
	0,	/* 59 */
	0,	/* 60 */
	0,	/* 61 */
	0,	/* 62 */
	0,	/* 63 */
	0,	/* 64 */
	1,	/* 65=INDIRF */
	1,	/* 66=INDIRD */
	1,	/* 67=INDIRC */
	1,	/* 68=INDIRS */
	1,	/* 69=INDIRI */
	0,	/* 70 */
	1,	/* 71=INDIRP */
	0,	/* 72 */
	1,	/* 73=INDIRB */
	0,	/* 74 */
	0,	/* 75 */
	0,	/* 76 */
	0,	/* 77 */
	0,	/* 78 */
	0,	/* 79 */
	0,	/* 80 */
	0,	/* 81 */
	0,	/* 82 */
	0,	/* 83 */
	0,	/* 84 */
	1,	/* 85=CVCI */
	1,	/* 86=CVCU */
	0,	/* 87 */
	0,	/* 88 */
	0,	/* 89 */
	0,	/* 90 */
	0,	/* 91 */
	0,	/* 92 */
	0,	/* 93 */
	0,	/* 94 */
	0,	/* 95 */
	0,	/* 96 */
	1,	/* 97=CVDF */
	0,	/* 98 */
	0,	/* 99 */
	0,	/* 100 */
	1,	/* 101=CVDI */
	0,	/* 102 */
	0,	/* 103 */
	0,	/* 104 */
	0,	/* 105 */
	0,	/* 106 */
	0,	/* 107 */
	0,	/* 108 */
	0,	/* 109 */
	0,	/* 110 */
	0,	/* 111 */
	0,	/* 112 */
	0,	/* 113 */
	1,	/* 114=CVFD */
	0,	/* 115 */
	0,	/* 116 */
	0,	/* 117 */
	0,	/* 118 */
	0,	/* 119 */
	0,	/* 120 */
	0,	/* 121 */
	0,	/* 122 */
	0,	/* 123 */
	0,	/* 124 */
	0,	/* 125 */
	0,	/* 126 */
	0,	/* 127 */
	0,	/* 128 */
	0,	/* 129 */
	1,	/* 130=CVID */
	1,	/* 131=CVIC */
	1,	/* 132=CVIS */
	0,	/* 133 */
	1,	/* 134=CVIU */
	0,	/* 135 */
	0,	/* 136 */
	0,	/* 137 */
	0,	/* 138 */
	0,	/* 139 */
	0,	/* 140 */
	0,	/* 141 */
	0,	/* 142 */
	0,	/* 143 */
	0,	/* 144 */
	0,	/* 145 */
	0,	/* 146 */
	0,	/* 147 */
	0,	/* 148 */
	0,	/* 149 */
	1,	/* 150=CVPU */
	0,	/* 151 */
	0,	/* 152 */
	0,	/* 153 */
	0,	/* 154 */
	0,	/* 155 */
	0,	/* 156 */
	0,	/* 157 */
	0,	/* 158 */
	0,	/* 159 */
	0,	/* 160 */
	0,	/* 161 */
	0,	/* 162 */
	0,	/* 163 */
	0,	/* 164 */
	1,	/* 165=CVSI */
	1,	/* 166=CVSU */
	0,	/* 167 */
	0,	/* 168 */
	0,	/* 169 */
	0,	/* 170 */
	0,	/* 171 */
	0,	/* 172 */
	0,	/* 173 */
	0,	/* 174 */
	0,	/* 175 */
	0,	/* 176 */
	0,	/* 177 */
	0,	/* 178 */
	1,	/* 179=CVUC */
	1,	/* 180=CVUS */
	1,	/* 181=CVUI */
	0,	/* 182 */
	1,	/* 183=CVUP */
	0,	/* 184 */
	0,	/* 185 */
	0,	/* 186 */
	0,	/* 187 */
	0,	/* 188 */
	0,	/* 189 */
	0,	/* 190 */
	0,	/* 191 */
	0,	/* 192 */
	1,	/* 193=NEGF */
	1,	/* 194=NEGD */
	0,	/* 195 */
	0,	/* 196 */
	1,	/* 197=NEGI */
	0,	/* 198 */
	0,	/* 199 */
	0,	/* 200 */
	0,	/* 201 */
	0,	/* 202 */
	0,	/* 203 */
	0,	/* 204 */
	0,	/* 205 */
	0,	/* 206 */
	0,	/* 207 */
	0,	/* 208 */
	1,	/* 209=CALLF */
	1,	/* 210=CALLD */
	0,	/* 211 */
	0,	/* 212 */
	1,	/* 213=CALLI */
	0,	/* 214 */
	0,	/* 215 */
	1,	/* 216=CALLV */
	0,	/* 217=CALLB */
	0,	/* 218 */
	0,	/* 219 */
	0,	/* 220 */
	0,	/* 221 */
	0,	/* 222 */
	0,	/* 223 */
	0,	/* 224 */
	1,	/* 225=LOADF */
	1,	/* 226=LOADD */
	1,	/* 227=LOADC */
	1,	/* 228=LOADS */
	1,	/* 229=LOADI */
	1,	/* 230=LOADU */
	1,	/* 231=LOADP */
	0,	/* 232 */
	0,	/* 233=LOADB */
	0,	/* 234 */
	0,	/* 235 */
	0,	/* 236 */
	0,	/* 237 */
	0,	/* 238 */
	0,	/* 239 */
	0,	/* 240 */
	1,	/* 241=RETF */
	1,	/* 242=RETD */
	0,	/* 243 */
	0,	/* 244 */
	1,	/* 245=RETI */
	0,	/* 246 */
	0,	/* 247 */
	0,	/* 248 */
	0,	/* 249 */
	0,	/* 250 */
	0,	/* 251 */
	0,	/* 252 */
	0,	/* 253 */
	0,	/* 254 */
	0,	/* 255 */
	0,	/* 256 */
	0,	/* 257 */
	0,	/* 258 */
	0,	/* 259 */
	0,	/* 260 */
	0,	/* 261 */
	0,	/* 262 */
	0,	/* 263=ADDRGP */
	0,	/* 264 */
	0,	/* 265 */
	0,	/* 266 */
	0,	/* 267 */
	0,	/* 268 */
	0,	/* 269 */
	0,	/* 270 */
	0,	/* 271 */
	0,	/* 272 */
	0,	/* 273 */
	0,	/* 274 */
	0,	/* 275 */
	0,	/* 276 */
	0,	/* 277 */
	0,	/* 278 */
	0,	/* 279=ADDRFP */
	0,	/* 280 */
	0,	/* 281 */
	0,	/* 282 */
	0,	/* 283 */
	0,	/* 284 */
	0,	/* 285 */
	0,	/* 286 */
	0,	/* 287 */
	0,	/* 288 */
	0,	/* 289 */
	0,	/* 290 */
	0,	/* 291 */
	0,	/* 292 */
	0,	/* 293 */
	0,	/* 294 */
	0,	/* 295=ADDRLP */
	0,	/* 296 */
	0,	/* 297 */
	0,	/* 298 */
	0,	/* 299 */
	0,	/* 300 */
	0,	/* 301 */
	0,	/* 302 */
	0,	/* 303 */
	0,	/* 304 */
	2,	/* 305=ADDF */
	2,	/* 306=ADDD */
	0,	/* 307=ADDC */
	0,	/* 308=ADDS */
	2,	/* 309=ADDI */
	2,	/* 310=ADDU */
	2,	/* 311=ADDP */
	0,	/* 312 */
	0,	/* 313 */
	0,	/* 314 */
	0,	/* 315 */
	0,	/* 316 */
	0,	/* 317 */
	0,	/* 318 */
	0,	/* 319 */
	0,	/* 320 */
	2,	/* 321=SUBF */
	2,	/* 322=SUBD */
	0,	/* 323=SUBC */
	0,	/* 324=SUBS */
	2,	/* 325=SUBI */
	2,	/* 326=SUBU */
	2,	/* 327=SUBP */
	0,	/* 328 */
	0,	/* 329 */
	0,	/* 330 */
	0,	/* 331 */
	0,	/* 332 */
	0,	/* 333 */
	0,	/* 334 */
	0,	/* 335 */
	0,	/* 336 */
	0,	/* 337 */
	0,	/* 338 */
	0,	/* 339 */
	0,	/* 340 */
	2,	/* 341=LSHI */
	2,	/* 342=LSHU */
	0,	/* 343 */
	0,	/* 344 */
	0,	/* 345 */
	0,	/* 346 */
	0,	/* 347 */
	0,	/* 348 */
	0,	/* 349 */
	0,	/* 350 */
	0,	/* 351 */
	0,	/* 352 */
	0,	/* 353 */
	0,	/* 354 */
	0,	/* 355 */
	0,	/* 356 */
	2,	/* 357=MODI */
	2,	/* 358=MODU */
	0,	/* 359 */
	0,	/* 360 */
	0,	/* 361 */
	0,	/* 362 */
	0,	/* 363 */
	0,	/* 364 */
	0,	/* 365 */
	0,	/* 366 */
	0,	/* 367 */
	0,	/* 368 */
	0,	/* 369 */
	0,	/* 370 */
	0,	/* 371 */
	0,	/* 372 */
	2,	/* 373=RSHI */
	2,	/* 374=RSHU */
	0,	/* 375 */
	0,	/* 376 */
	0,	/* 377 */
	0,	/* 378 */
	0,	/* 379 */
	0,	/* 380 */
	0,	/* 381 */
	0,	/* 382 */
	0,	/* 383 */
	0,	/* 384 */
	0,	/* 385 */
	0,	/* 386 */
	0,	/* 387 */
	0,	/* 388 */
	0,	/* 389 */
	2,	/* 390=BANDU */
	0,	/* 391 */
	0,	/* 392 */
	0,	/* 393 */
	0,	/* 394 */
	0,	/* 395 */
	0,	/* 396 */
	0,	/* 397 */
	0,	/* 398 */
	0,	/* 399 */
	0,	/* 400 */
	0,	/* 401 */
	0,	/* 402 */
	0,	/* 403 */
	0,	/* 404 */
	0,	/* 405 */
	1,	/* 406=BCOMU */
	0,	/* 407 */
	0,	/* 408 */
	0,	/* 409 */
	0,	/* 410 */
	0,	/* 411 */
	0,	/* 412 */
	0,	/* 413 */
	0,	/* 414 */
	0,	/* 415 */
	0,	/* 416 */
	0,	/* 417 */
	0,	/* 418 */
	0,	/* 419 */
	0,	/* 420 */
	0,	/* 421 */
	2,	/* 422=BORU */
	0,	/* 423 */
	0,	/* 424 */
	0,	/* 425 */
	0,	/* 426 */
	0,	/* 427 */
	0,	/* 428 */
	0,	/* 429 */
	0,	/* 430 */
	0,	/* 431 */
	0,	/* 432 */
	0,	/* 433 */
	0,	/* 434 */
	0,	/* 435 */
	0,	/* 436 */
	0,	/* 437 */
	2,	/* 438=BXORU */
	0,	/* 439 */
	0,	/* 440 */
	0,	/* 441 */
	0,	/* 442 */
	0,	/* 443 */
	0,	/* 444 */
	0,	/* 445 */
	0,	/* 446 */
	0,	/* 447 */
	0,	/* 448 */
	2,	/* 449=DIVF */
	2,	/* 450=DIVD */
	0,	/* 451 */
	0,	/* 452 */
	2,	/* 453=DIVI */
	2,	/* 454=DIVU */
	0,	/* 455 */
	0,	/* 456 */
	0,	/* 457 */
	0,	/* 458 */
	0,	/* 459 */
	0,	/* 460 */
	0,	/* 461 */
	0,	/* 462 */
	0,	/* 463 */
	0,	/* 464 */
	2,	/* 465=MULF */
	2,	/* 466=MULD */
	0,	/* 467 */
	0,	/* 468 */
	2,	/* 469=MULI */
	2,	/* 470=MULU */
	0,	/* 471 */
	0,	/* 472 */
	0,	/* 473 */
	0,	/* 474 */
	0,	/* 475 */
	0,	/* 476 */
	0,	/* 477 */
	0,	/* 478 */
	0,	/* 479 */
	0,	/* 480 */
	2,	/* 481=EQF */
	2,	/* 482=EQD */
	0,	/* 483 */
	0,	/* 484 */
	2,	/* 485=EQI */
	0,	/* 486 */
	0,	/* 487 */
	0,	/* 488 */
	0,	/* 489 */
	0,	/* 490 */
	0,	/* 491 */
	0,	/* 492 */
	0,	/* 493 */
	0,	/* 494 */
	0,	/* 495 */
	0,	/* 496 */
	2,	/* 497=GEF */
	2,	/* 498=GED */
	0,	/* 499 */
	0,	/* 500 */
	2,	/* 501=GEI */
	2,	/* 502=GEU */
	0,	/* 503 */
	0,	/* 504 */
	0,	/* 505 */
	0,	/* 506 */
	0,	/* 507 */
	0,	/* 508 */
	0,	/* 509 */
	0,	/* 510 */
	0,	/* 511 */
	0,	/* 512 */
	2,	/* 513=GTF */
	2,	/* 514=GTD */
	0,	/* 515 */
	0,	/* 516 */
	2,	/* 517=GTI */
	2,	/* 518=GTU */
	0,	/* 519 */
	0,	/* 520 */
	0,	/* 521 */
	0,	/* 522 */
	0,	/* 523 */
	0,	/* 524 */
	0,	/* 525 */
	0,	/* 526 */
	0,	/* 527 */
	0,	/* 528 */
	2,	/* 529=LEF */
	2,	/* 530=LED */
	0,	/* 531 */
	0,	/* 532 */
	2,	/* 533=LEI */
	2,	/* 534=LEU */
	0,	/* 535 */
	0,	/* 536 */
	0,	/* 537 */
	0,	/* 538 */
	0,	/* 539 */
	0,	/* 540 */
	0,	/* 541 */
	0,	/* 542 */
	0,	/* 543 */
	0,	/* 544 */
	2,	/* 545=LTF */
	2,	/* 546=LTD */
	0,	/* 547 */
	0,	/* 548 */
	2,	/* 549=LTI */
	2,	/* 550=LTU */
	0,	/* 551 */
	0,	/* 552 */
	0,	/* 553 */
	0,	/* 554 */
	0,	/* 555 */
	0,	/* 556 */
	0,	/* 557 */
	0,	/* 558 */
	0,	/* 559 */
	0,	/* 560 */
	2,	/* 561=NEF */
	2,	/* 562=NED */
	0,	/* 563 */
	0,	/* 564 */
	2,	/* 565=NEI */
	0,	/* 566 */
	0,	/* 567 */
	0,	/* 568 */
	0,	/* 569 */
	0,	/* 570 */
	0,	/* 571 */
	0,	/* 572 */
	0,	/* 573 */
	0,	/* 574 */
	0,	/* 575 */
	0,	/* 576 */
	0,	/* 577 */
	0,	/* 578 */
	0,	/* 579 */
	0,	/* 580 */
	0,	/* 581 */
	0,	/* 582 */
	0,	/* 583 */
	1,	/* 584=JUMPV */
	0,	/* 585 */
	0,	/* 586 */
	0,	/* 587 */
	0,	/* 588 */
	0,	/* 589 */
	0,	/* 590 */
	0,	/* 591 */
	0,	/* 592 */
	0,	/* 593 */
	0,	/* 594 */
	0,	/* 595 */
	0,	/* 596 */
	0,	/* 597 */
	0,	/* 598 */
	0,	/* 599 */
	0,	/* 600=LABELV */
	0,	/* 601 */
	0,	/* 602 */
	0,	/* 603 */
	0,	/* 604 */
	0,	/* 605 */
	0,	/* 606 */
	0,	/* 607 */
	0,	/* 608 */
	0,	/* 609 */
	0,	/* 610 */
	0,	/* 611 */
	0,	/* 612 */
	0,	/* 613 */
	0,	/* 614 */
	0,	/* 615=VREGP */
};

static char *_opname[] = {
/* 0 */	0,
/* 1 */	0,
/* 2 */	0,
/* 3 */	0,
/* 4 */	0,
/* 5 */	0,
/* 6 */	0,
/* 7 */	0,
/* 8 */	0,
/* 9 */	0,
/* 10 */	0,
/* 11 */	0,
/* 12 */	0,
/* 13 */	0,
/* 14 */	0,
/* 15 */	0,
/* 16 */	0,
/* 17 */	"CNSTF",
/* 18 */	"CNSTD",
/* 19 */	"CNSTC",
/* 20 */	"CNSTS",
/* 21 */	"CNSTI",
/* 22 */	"CNSTU",
/* 23 */	"CNSTP",
/* 24 */	0,
/* 25 */	0,
/* 26 */	0,
/* 27 */	0,
/* 28 */	0,
/* 29 */	0,
/* 30 */	0,
/* 31 */	0,
/* 32 */	0,
/* 33 */	"ARGF",
/* 34 */	"ARGD",
/* 35 */	0,
/* 36 */	0,
/* 37 */	"ARGI",
/* 38 */	0,
/* 39 */	"ARGP",
/* 40 */	0,
/* 41 */	"ARGB",
/* 42 */	0,
/* 43 */	0,
/* 44 */	0,
/* 45 */	0,
/* 46 */	0,
/* 47 */	0,
/* 48 */	0,
/* 49 */	"ASGNF",
/* 50 */	"ASGND",
/* 51 */	"ASGNC",
/* 52 */	"ASGNS",
/* 53 */	"ASGNI",
/* 54 */	"ASGNU",
/* 55 */	"ASGNP",
/* 56 */	0,
/* 57 */	"ASGNB",
/* 58 */	0,
/* 59 */	0,
/* 60 */	0,
/* 61 */	0,
/* 62 */	0,
/* 63 */	0,
/* 64 */	0,
/* 65 */	"INDIRF",
/* 66 */	"INDIRD",
/* 67 */	"INDIRC",
/* 68 */	"INDIRS",
/* 69 */	"INDIRI",
/* 70 */	0,
/* 71 */	"INDIRP",
/* 72 */	0,
/* 73 */	"INDIRB",
/* 74 */	0,
/* 75 */	0,
/* 76 */	0,
/* 77 */	0,
/* 78 */	0,
/* 79 */	0,
/* 80 */	0,
/* 81 */	0,
/* 82 */	0,
/* 83 */	0,
/* 84 */	0,
/* 85 */	"CVCI",
/* 86 */	"CVCU",
/* 87 */	0,
/* 88 */	0,
/* 89 */	0,
/* 90 */	0,
/* 91 */	0,
/* 92 */	0,
/* 93 */	0,
/* 94 */	0,
/* 95 */	0,
/* 96 */	0,
/* 97 */	"CVDF",
/* 98 */	0,
/* 99 */	0,
/* 100 */	0,
/* 101 */	"CVDI",
/* 102 */	0,
/* 103 */	0,
/* 104 */	0,
/* 105 */	0,
/* 106 */	0,
/* 107 */	0,
/* 108 */	0,
/* 109 */	0,
/* 110 */	0,
/* 111 */	0,
/* 112 */	0,
/* 113 */	0,
/* 114 */	"CVFD",
/* 115 */	0,
/* 116 */	0,
/* 117 */	0,
/* 118 */	0,
/* 119 */	0,
/* 120 */	0,
/* 121 */	0,
/* 122 */	0,
/* 123 */	0,
/* 124 */	0,
/* 125 */	0,
/* 126 */	0,
/* 127 */	0,
/* 128 */	0,
/* 129 */	0,
/* 130 */	"CVID",
/* 131 */	"CVIC",
/* 132 */	"CVIS",
/* 133 */	0,
/* 134 */	"CVIU",
/* 135 */	0,
/* 136 */	0,
/* 137 */	0,
/* 138 */	0,
/* 139 */	0,
/* 140 */	0,
/* 141 */	0,
/* 142 */	0,
/* 143 */	0,
/* 144 */	0,
/* 145 */	0,
/* 146 */	0,
/* 147 */	0,
/* 148 */	0,
/* 149 */	0,
/* 150 */	"CVPU",
/* 151 */	0,
/* 152 */	0,
/* 153 */	0,
/* 154 */	0,
/* 155 */	0,
/* 156 */	0,
/* 157 */	0,
/* 158 */	0,
/* 159 */	0,
/* 160 */	0,
/* 161 */	0,
/* 162 */	0,
/* 163 */	0,
/* 164 */	0,
/* 165 */	"CVSI",
/* 166 */	"CVSU",
/* 167 */	0,
/* 168 */	0,
/* 169 */	0,
/* 170 */	0,
/* 171 */	0,
/* 172 */	0,
/* 173 */	0,
/* 174 */	0,
/* 175 */	0,
/* 176 */	0,
/* 177 */	0,
/* 178 */	0,
/* 179 */	"CVUC",
/* 180 */	"CVUS",
/* 181 */	"CVUI",
/* 182 */	0,
/* 183 */	"CVUP",
/* 184 */	0,
/* 185 */	0,
/* 186 */	0,
/* 187 */	0,
/* 188 */	0,
/* 189 */	0,
/* 190 */	0,
/* 191 */	0,
/* 192 */	0,
/* 193 */	"NEGF",
/* 194 */	"NEGD",
/* 195 */	0,
/* 196 */	0,
/* 197 */	"NEGI",
/* 198 */	0,
/* 199 */	0,
/* 200 */	0,
/* 201 */	0,
/* 202 */	0,
/* 203 */	0,
/* 204 */	0,
/* 205 */	0,
/* 206 */	0,
/* 207 */	0,
/* 208 */	0,
/* 209 */	"CALLF",
/* 210 */	"CALLD",
/* 211 */	0,
/* 212 */	0,
/* 213 */	"CALLI",
/* 214 */	0,
/* 215 */	0,
/* 216 */	"CALLV",
/* 217 */	"CALLB",
/* 218 */	0,
/* 219 */	0,
/* 220 */	0,
/* 221 */	0,
/* 222 */	0,
/* 223 */	0,
/* 224 */	0,
/* 225 */	"LOADF",
/* 226 */	"LOADD",
/* 227 */	"LOADC",
/* 228 */	"LOADS",
/* 229 */	"LOADI",
/* 230 */	"LOADU",
/* 231 */	"LOADP",
/* 232 */	0,
/* 233 */	"LOADB",
/* 234 */	0,
/* 235 */	0,
/* 236 */	0,
/* 237 */	0,
/* 238 */	0,
/* 239 */	0,
/* 240 */	0,
/* 241 */	"RETF",
/* 242 */	"RETD",
/* 243 */	0,
/* 244 */	0,
/* 245 */	"RETI",
/* 246 */	0,
/* 247 */	0,
/* 248 */	0,
/* 249 */	0,
/* 250 */	0,
/* 251 */	0,
/* 252 */	0,
/* 253 */	0,
/* 254 */	0,
/* 255 */	0,
/* 256 */	0,
/* 257 */	0,
/* 258 */	0,
/* 259 */	0,
/* 260 */	0,
/* 261 */	0,
/* 262 */	0,
/* 263 */	"ADDRGP",
/* 264 */	0,
/* 265 */	0,
/* 266 */	0,
/* 267 */	0,
/* 268 */	0,
/* 269 */	0,
/* 270 */	0,
/* 271 */	0,
/* 272 */	0,
/* 273 */	0,
/* 274 */	0,
/* 275 */	0,
/* 276 */	0,
/* 277 */	0,
/* 278 */	0,
/* 279 */	"ADDRFP",
/* 280 */	0,
/* 281 */	0,
/* 282 */	0,
/* 283 */	0,
/* 284 */	0,
/* 285 */	0,
/* 286 */	0,
/* 287 */	0,
/* 288 */	0,
/* 289 */	0,
/* 290 */	0,
/* 291 */	0,
/* 292 */	0,
/* 293 */	0,
/* 294 */	0,
/* 295 */	"ADDRLP",
/* 296 */	0,
/* 297 */	0,
/* 298 */	0,
/* 299 */	0,
/* 300 */	0,
/* 301 */	0,
/* 302 */	0,
/* 303 */	0,
/* 304 */	0,
/* 305 */	"ADDF",
/* 306 */	"ADDD",
/* 307 */	"ADDC",
/* 308 */	"ADDS",
/* 309 */	"ADDI",
/* 310 */	"ADDU",
/* 311 */	"ADDP",
/* 312 */	0,
/* 313 */	0,
/* 314 */	0,
/* 315 */	0,
/* 316 */	0,
/* 317 */	0,
/* 318 */	0,
/* 319 */	0,
/* 320 */	0,
/* 321 */	"SUBF",
/* 322 */	"SUBD",
/* 323 */	"SUBC",
/* 324 */	"SUBS",
/* 325 */	"SUBI",
/* 326 */	"SUBU",
/* 327 */	"SUBP",
/* 328 */	0,
/* 329 */	0,
/* 330 */	0,
/* 331 */	0,
/* 332 */	0,
/* 333 */	0,
/* 334 */	0,
/* 335 */	0,
/* 336 */	0,
/* 337 */	0,
/* 338 */	0,
/* 339 */	0,
/* 340 */	0,
/* 341 */	"LSHI",
/* 342 */	"LSHU",
/* 343 */	0,
/* 344 */	0,
/* 345 */	0,
/* 346 */	0,
/* 347 */	0,
/* 348 */	0,
/* 349 */	0,
/* 350 */	0,
/* 351 */	0,
/* 352 */	0,
/* 353 */	0,
/* 354 */	0,
/* 355 */	0,
/* 356 */	0,
/* 357 */	"MODI",
/* 358 */	"MODU",
/* 359 */	0,
/* 360 */	0,
/* 361 */	0,
/* 362 */	0,
/* 363 */	0,
/* 364 */	0,
/* 365 */	0,
/* 366 */	0,
/* 367 */	0,
/* 368 */	0,
/* 369 */	0,
/* 370 */	0,
/* 371 */	0,
/* 372 */	0,
/* 373 */	"RSHI",
/* 374 */	"RSHU",
/* 375 */	0,
/* 376 */	0,
/* 377 */	0,
/* 378 */	0,
/* 379 */	0,
/* 380 */	0,
/* 381 */	0,
/* 382 */	0,
/* 383 */	0,
/* 384 */	0,
/* 385 */	0,
/* 386 */	0,
/* 387 */	0,
/* 388 */	0,
/* 389 */	0,
/* 390 */	"BANDU",
/* 391 */	0,
/* 392 */	0,
/* 393 */	0,
/* 394 */	0,
/* 395 */	0,
/* 396 */	0,
/* 397 */	0,
/* 398 */	0,
/* 399 */	0,
/* 400 */	0,
/* 401 */	0,
/* 402 */	0,
/* 403 */	0,
/* 404 */	0,
/* 405 */	0,
/* 406 */	"BCOMU",
/* 407 */	0,
/* 408 */	0,
/* 409 */	0,
/* 410 */	0,
/* 411 */	0,
/* 412 */	0,
/* 413 */	0,
/* 414 */	0,
/* 415 */	0,
/* 416 */	0,
/* 417 */	0,
/* 418 */	0,
/* 419 */	0,
/* 420 */	0,
/* 421 */	0,
/* 422 */	"BORU",
/* 423 */	0,
/* 424 */	0,
/* 425 */	0,
/* 426 */	0,
/* 427 */	0,
/* 428 */	0,
/* 429 */	0,
/* 430 */	0,
/* 431 */	0,
/* 432 */	0,
/* 433 */	0,
/* 434 */	0,
/* 435 */	0,
/* 436 */	0,
/* 437 */	0,
/* 438 */	"BXORU",
/* 439 */	0,
/* 440 */	0,
/* 441 */	0,
/* 442 */	0,
/* 443 */	0,
/* 444 */	0,
/* 445 */	0,
/* 446 */	0,
/* 447 */	0,
/* 448 */	0,
/* 449 */	"DIVF",
/* 450 */	"DIVD",
/* 451 */	0,
/* 452 */	0,
/* 453 */	"DIVI",
/* 454 */	"DIVU",
/* 455 */	0,
/* 456 */	0,
/* 457 */	0,
/* 458 */	0,
/* 459 */	0,
/* 460 */	0,
/* 461 */	0,
/* 462 */	0,
/* 463 */	0,
/* 464 */	0,
/* 465 */	"MULF",
/* 466 */	"MULD",
/* 467 */	0,
/* 468 */	0,
/* 469 */	"MULI",
/* 470 */	"MULU",
/* 471 */	0,
/* 472 */	0,
/* 473 */	0,
/* 474 */	0,
/* 475 */	0,
/* 476 */	0,
/* 477 */	0,
/* 478 */	0,
/* 479 */	0,
/* 480 */	0,
/* 481 */	"EQF",
/* 482 */	"EQD",
/* 483 */	0,
/* 484 */	0,
/* 485 */	"EQI",
/* 486 */	0,
/* 487 */	0,
/* 488 */	0,
/* 489 */	0,
/* 490 */	0,
/* 491 */	0,
/* 492 */	0,
/* 493 */	0,
/* 494 */	0,
/* 495 */	0,
/* 496 */	0,
/* 497 */	"GEF",
/* 498 */	"GED",
/* 499 */	0,
/* 500 */	0,
/* 501 */	"GEI",
/* 502 */	"GEU",
/* 503 */	0,
/* 504 */	0,
/* 505 */	0,
/* 506 */	0,
/* 507 */	0,
/* 508 */	0,
/* 509 */	0,
/* 510 */	0,
/* 511 */	0,
/* 512 */	0,
/* 513 */	"GTF",
/* 514 */	"GTD",
/* 515 */	0,
/* 516 */	0,
/* 517 */	"GTI",
/* 518 */	"GTU",
/* 519 */	0,
/* 520 */	0,
/* 521 */	0,
/* 522 */	0,
/* 523 */	0,
/* 524 */	0,
/* 525 */	0,
/* 526 */	0,
/* 527 */	0,
/* 528 */	0,
/* 529 */	"LEF",
/* 530 */	"LED",
/* 531 */	0,
/* 532 */	0,
/* 533 */	"LEI",
/* 534 */	"LEU",
/* 535 */	0,
/* 536 */	0,
/* 537 */	0,
/* 538 */	0,
/* 539 */	0,
/* 540 */	0,
/* 541 */	0,
/* 542 */	0,
/* 543 */	0,
/* 544 */	0,
/* 545 */	"LTF",
/* 546 */	"LTD",
/* 547 */	0,
/* 548 */	0,
/* 549 */	"LTI",
/* 550 */	"LTU",
/* 551 */	0,
/* 552 */	0,
/* 553 */	0,
/* 554 */	0,
/* 555 */	0,
/* 556 */	0,
/* 557 */	0,
/* 558 */	0,
/* 559 */	0,
/* 560 */	0,
/* 561 */	"NEF",
/* 562 */	"NED",
/* 563 */	0,
/* 564 */	0,
/* 565 */	"NEI",
/* 566 */	0,
/* 567 */	0,
/* 568 */	0,
/* 569 */	0,
/* 570 */	0,
/* 571 */	0,
/* 572 */	0,
/* 573 */	0,
/* 574 */	0,
/* 575 */	0,
/* 576 */	0,
/* 577 */	0,
/* 578 */	0,
/* 579 */	0,
/* 580 */	0,
/* 581 */	0,
/* 582 */	0,
/* 583 */	0,
/* 584 */	"JUMPV",
/* 585 */	0,
/* 586 */	0,
/* 587 */	0,
/* 588 */	0,
/* 589 */	0,
/* 590 */	0,
/* 591 */	0,
/* 592 */	0,
/* 593 */	0,
/* 594 */	0,
/* 595 */	0,
/* 596 */	0,
/* 597 */	0,
/* 598 */	0,
/* 599 */	0,
/* 600 */	"LABELV",
/* 601 */	0,
/* 602 */	0,
/* 603 */	0,
/* 604 */	0,
/* 605 */	0,
/* 606 */	0,
/* 607 */	0,
/* 608 */	0,
/* 609 */	0,
/* 610 */	0,
/* 611 */	0,
/* 612 */	0,
/* 613 */	0,
/* 614 */	0,
/* 615 */	"VREGP",
};

static char *_templates[] = {
/* 0 */	0,
/* 1 */	"# read register\n",	/* reg: INDIRC(VREGP) */
/* 2 */	"# read register\n",	/* reg: INDIRD(VREGP) */
/* 3 */	"# read register\n",	/* reg: INDIRF(VREGP) */
/* 4 */	"# read register\n",	/* reg: INDIRI(VREGP) */
/* 5 */	"# read register\n",	/* reg: INDIRP(VREGP) */
/* 6 */	"# read register\n",	/* reg: INDIRS(VREGP) */
/* 7 */	"# write register\n",	/* stmt: ASGNC(VREGP,reg) */
/* 8 */	"# write register\n",	/* stmt: ASGND(VREGP,reg) */
/* 9 */	"# write register\n",	/* stmt: ASGNF(VREGP,reg) */
/* 10 */	"# write register\n",	/* stmt: ASGNI(VREGP,reg) */
/* 11 */	"# write register\n",	/* stmt: ASGND(VREGP,reg) */
/* 12 */	"# write register\n",	/* stmt: ASGNP(VREGP,reg) */
/* 13 */	"# write register\n",	/* stmt: ASGNS(VREGP,reg) */
/* 14 */	"%#%a",	/* con: CNSTC */
/* 15 */	"%#%a",	/* con: CNSTI */
/* 16 */	"%#%a",	/* con: CNSTP */
/* 17 */	"%#%a",	/* con: CNSTS */
/* 18 */	"%#%a",	/* con: CNSTU */
/* 19 */	"",	/* stmt: reg */
/* 20 */	"%0",	/* reg: CVIU(reg) */
/* 21 */	"%0",	/* reg: CVUI(reg) */
/* 22 */	"%a",	/* disp16: CNSTI */
/* 23 */	"%a",	/* disp8: CNSTI */
/* 24 */	"%1(%0",	/* base: ADDP(reg,disp16) */
/* 25 */	"%a(A6",	/* base: ADDRFP */
/* 26 */	"%a(A6",	/* base: ADDRLP */
/* 27 */	"%0",	/* base: basei */
/* 28 */	"(%0",	/* basei: reg */
/* 29 */	"%1(%0",	/* basei: ADDP(reg,disp8) */
/* 30 */	"%a(A6",	/* basei: ADDRFP */
/* 31 */	"%a(A6",	/* basei: ADDRLP */
/* 32 */	"(%a,A6",	/* basei: ADDRFP */
/* 33 */	"(%a,A6",	/* basei: ADDRLP */
/* 34 */	"%a(A5)",	/* addr: ADDRGP */
/* 35 */	"%a",	/* acon: ADDRGP */
/* 36 */	"\tLEA %a,%c\n",	/* table: ADDRGP */
/* 37 */	"%0",	/* index: reg */
/* 38 */	"%0*%1",	/* index: LSHI(reg,scf) */
/* 39 */	"%0)",	/* addr: base */
/* 40 */	"%1,%0)",	/* addr: ADDP(index,basei) */
/* 41 */	"(%1,%0)",	/* case: ADDP(index,table) */
/* 42 */	"%0",	/* avar: acon */
/* 43 */	"(%0)",	/* avar: reg */
/* 44 */	"%0",	/* avar: addr */
/* 45 */	"%#0",	/* con0: CNSTI */
/* 46 */	"%#0",	/* con0: CNSTP */
/* 47 */	"%#0",	/* con0: CNSTU */
/* 48 */	"%#%a",	/* con3: CNSTI */
/* 49 */	"%#%a",	/* con3: CNSTP */
/* 50 */	"2",	/* scf: CNSTI */
/* 51 */	"4",	/* scf: CNSTI */
/* 52 */	"8",	/* scf: CNSTI */
/* 53 */	"%0",	/* mem: INDIRI(addr) */
/* 54 */	"%0",	/* mem: INDIRP(addr) */
/* 55 */	"\tMOVE.L %0,%c\n",	/* pcrel: INDIRP(case) */
/* 56 */	"%0",	/* ri: reg */
/* 57 */	"%0",	/* ri: con */
/* 58 */	"%0",	/* ri3: con3 */
/* 59 */	"%0",	/* ri3: reg */
/* 60 */	"%0",	/* ea0: mem */
/* 61 */	"%0",	/* ea0: ri */
/* 62 */	"%0",	/* ea1: mem */
/* 63 */	"%0",	/* ea1: ri */
/* 64 */	"%0",	/* ea3: mem */
/* 65 */	"%0",	/* ea3: ri */
/* 66 */	"\tLEA %0,%c\n",	/* reg: addr */
/* 67 */	"\tMOVE.L %0,%c\n",	/* reg: ri */
/* 68 */	"\tMOVE.B %0,%c\n",	/* reg: INDIRC(addr) */
/* 69 */	"\tMOVE.L %0,%c\n",	/* reg: INDIRI(addr) */
/* 70 */	"\tMOVE.L %0,%c\n",	/* reg: INDIRP(addr) */
/* 71 */	"\tMOVE.W %0,%c\n",	/* reg: INDIRS(addr) */
/* 72 */	"\tMOVE.L %0,%c\n",	/* reg: LOADC(reg) */
/* 73 */	"\tMOVE.L %0,%c\n",	/* reg: LOADI(reg) */
/* 74 */	"\tMOVE.L %0,%c\n",	/* reg: LOADP(reg) */
/* 75 */	"\tMOVE.L %0,%c\n",	/* reg: LOADS(reg) */
/* 76 */	"\tMOVE.L %0,%c\n",	/* reg: LOADU(reg) */
/* 77 */	"?\tMOVE.L %0,%c\n\tADDQ.L %1,%c\n",	/* reg: ADDI(reg,con3) */
/* 78 */	"?\tMOVE.L %0,%c\n\tSUBQ.L %1,%c\n",	/* reg: SUBI(reg,con3) */
/* 79 */	"?\tMOVE.L %0,%c\n\tADD.L %1,%c\n",	/* reg: ADDI(reg,ea1) */
/* 80 */	"?\tMOVE.L %0,%c\n\tADDA.L %1,%c\n",	/* reg: ADDP(reg,ea1) */
/* 81 */	"?\tMOVE.L %0,%c\n\tADD.L %1,%c\n",	/* reg: ADDU(reg,ea1) */
/* 82 */	"?\tMOVE.L %0,%c\n\tSUB.L %1,%c\n",	/* reg: SUBI(reg,ea1) */
/* 83 */	"?\tMOVE.L %0,%c\n\tSUBA.L %1,%c\n",	/* reg: SUBP(reg,ea1) */
/* 84 */	"?\tMOVE.L %0,%c\n\tSUB.L %1,%c\n",	/* reg: SUBU(reg,ea1) */
/* 85 */	"\tADD.L %2,%1\n",	/* stmt: ASGNI(addr,ADDI(mem,ri)) */
/* 86 */	"\tADD.L %2,%1\n",	/* stmt: ASGNI(addr,ADDU(mem,ri)) */
/* 87 */	"\tSUB.L %2,%1\n",	/* stmt: ASGNI(addr,SUBI(mem,ri)) */
/* 88 */	"\tSUB.L %2,%1\n",	/* stmt: ASGNI(addr,SUBU(mem,ri)) */
/* 89 */	"?\tMOVE.L %0,%c\n\tAND.L %1,%c\n",	/* reg: BANDU(reg,ea1) */
/* 90 */	"?\tMOVE.L %0,%c\n\tOR.L %1,%c\n",	/* reg: BORU(reg,ea1) */
/* 91 */	"?\tMOVE.L %0,%c\n\tEOR.L %1,%c\n",	/* reg: BXORU(reg,reg) */
/* 92 */	"\tAND.L %2,%1\n",	/* stmt: ASGNI(addr,BANDU(mem,ri)) */
/* 93 */	"\tOR.L %2,%1\n",	/* stmt: ASGNI(addr,BORU(mem,ri)) */
/* 94 */	"\tEOR.L %2,%1\n",	/* stmt: ASGNI(addr,BXORU(mem,reg)) */
/* 95 */	"?\tMOVE.L %0,%c\n\tNOT.L %c\n",	/* reg: BCOMU(reg) */
/* 96 */	"?\tMOVE.L %0,%c\n\tNEG.L %c\n",	/* reg: NEGI(reg) */
/* 97 */	"\tNOT.L %1\n",	/* stmt: ASGNI(addr,BCOMU(mem)) */
/* 98 */	"\tNEG.L %1\n",	/* stmt: ASGNI(addr,NEGI(mem)) */
/* 99 */	"?\tMOVE.L %0,%c\n\tASL.L %1,%c\n",	/* reg: LSHI(reg,ri3) */
/* 100 */	"?\tMOVE.L %0,%c\n\tLSL.L %1,%c\n",	/* reg: LSHU(reg,ri3) */
/* 101 */	"?\tMOVE.L %0,%c\n\tASR.L %1,%c\n",	/* reg: RSHI(reg,ri3) */
/* 102 */	"?\tMOVE.L %0,%c\n\tLSR.L %1,%c\n",	/* reg: RSHU(reg,ri3) */
/* 103 */	"?\tMOVE.L %0,%c\n\tMULS.L %1,%c\n",	/* reg: MULI(reg,ea3) */
/* 104 */	"?\tMOVE.L %0,%c\n\tMULU.L %1,%c\n",	/* reg: MULU(reg,ea3) */
/* 105 */	"?\tMOVE.L %0,%c\n\tDIVU.L %1,%c\n",	/* reg: DIVU(reg,ea3) */
/* 106 */	"?\tMOVE.L %0,%c\n\tDIVS.L %1,%c\n",	/* reg: DIVI(reg,ea3) */
/* 107 */	"\tMOVE.L %0,D1\n\tCLR.L %c\n\tDIVU.L %1,%c:D1\n",	/* reg: MODU(reg,ea3) */
/* 108 */	"#\tCLR.L %c\n\tDIVS.L %1,%0\n",	/* reg: MODI(reg,reg) */
/* 109 */	"\tMOVE.B %0,%c\n\tEXT.W %c\n\tEXT.L %c\n",	/* reg: CVCI(reg) */
/* 110 */	"\tMOVE.B %0,%c\n\tAND.L #$FF,%0\n",	/* reg: CVCU(reg) */
/* 111 */	"\tMOVE.W %0,%c\n\tEXT.L %c\n",	/* reg: CVSI(reg) */
/* 112 */	"\tMOVE.W %0,%c\n\tAND.L #$FFFF,%0\n",	/* reg: CVSU(reg) */
/* 113 */	"\tMOVE.B %0,%c\n\tEXT.W %c\n\tEXT.L %c\n",	/* reg: CVCI(INDIRC(addr)) */
/* 114 */	"\tCLR.L %c\n\tMOVE.B %0,%c\n",	/* reg: CVCU(INDIRC(addr)) */
/* 115 */	"\tMOVE.W %0,%c\n\tEXT.L %c\n",	/* reg: CVSI(INDIRS(addr)) */
/* 116 */	"\tCLR.L %c\n\tMOVE.W %0,%c\n",	/* reg: CVSU(INDIRS(addr)) */
/* 117 */	"%0",	/* reg: CVIC(reg) */
/* 118 */	"%0",	/* reg: CVIS(reg) */
/* 119 */	"%0",	/* reg: CVUC(reg) */
/* 120 */	"%0",	/* reg: CVUS(reg) */
/* 121 */	"\tMOVE.L %0,%c\n",	/* reg: CVIC(reg) */
/* 122 */	"\tMOVE.L %0,%c\n",	/* reg: CVIS(reg) */
/* 123 */	"\tMOVE.L %0,%c\n",	/* reg: CVIU(reg) */
/* 124 */	"\tMOVE.L %0,%c\n",	/* reg: CVPU(reg) */
/* 125 */	"\tMOVE.L %0,%c\n",	/* reg: CVUC(reg) */
/* 126 */	"\tMOVE.L %0,%c\n",	/* reg: CVUI(reg) */
/* 127 */	"\tMOVE.L %0,%c\n",	/* reg: CVUP(reg) */
/* 128 */	"\tMOVE.L %0,%c\n",	/* reg: CVUS(reg) */
/* 129 */	"%0",	/* reg: CVDF(reg) */
/* 130 */	"%0",	/* reg: CVFD(reg) */
/* 131 */	"\tFMOVE.X %0,%c\n",	/* reg: CVDF(reg) */
/* 132 */	"\tFMOVE.X %0,%c\n",	/* reg: CVFD(reg) */
/* 133 */	"\tFMOVE.L %0,%c\n",	/* reg: CVID(ea0) */
/* 134 */	"\tFMOVE.L %0,%c\n",	/* reg: CVDI(reg) */
/* 135 */	"\tMOVE.B %1,%0\n",	/* stmt: ASGNC(addr,ea1) */
/* 136 */	"\tCLR.L %0\n",	/* stmt: ASGNC(addr,con0) */
/* 137 */	"\tMOVE.L %1,%0\n",	/* stmt: ASGNI(addr,ea1) */
/* 138 */	"\tCLR.L %0\n",	/* stmt: ASGNI(addr,con0) */
/* 139 */	"\tFMOVE.L %1,%0\n",	/* stmt: ASGNI(addr,CVDI(reg)) */
/* 140 */	"\tMOVE.L %1,%0\n",	/* stmt: ASGNP(addr,ea1) */
/* 141 */	"\tCLR.L %0\n",	/* stmt: ASGNP(addr,con0) */
/* 142 */	"\tMOVE.W %1,%0\n",	/* stmt: ASGNS(addr,ea1) */
/* 143 */	"\tCLR.W %0\n",	/* stmt: ASGNS(addr,con0) */
/* 144 */	"\tMOVE.L %0,-(SP)\n",	/* stmt: ARGI(ea0) */
/* 145 */	"\tPEA.L %0\n",	/* stmt: ARGI(addr) */
/* 146 */	"\tMOVE.L %0,-(SP)\n",	/* stmt: ARGP(ea0) */
/* 147 */	"\tPEA.L %0\n",	/* stmt: ARGP(addr) */
/* 148 */	"# MOVE (src)+,(dst)+\n",	/* stmt: ASGNB(reg,INDIRB(reg)) */
/* 149 */	"# Copy to stack\n",	/* stmt: ARGB(INDIRB(reg)) */
/* 150 */	"\tFMOVE.X %0,%c\n",	/* reg: LOADD(reg) */
/* 151 */	"\tFMOVE.X %0,%c\n",	/* reg: LOADF(reg) */
/* 152 */	"\tFMOVE.D %0,%c\n",	/* reg: INDIRD(addr) */
/* 153 */	"\tFMOVE.S %0,%c\n",	/* reg: INDIRF(addr) */
/* 154 */	"%0",	/* mem: INDIRD(addr) */
/* 155 */	"%0",	/* mem: INDIRF(addr) */
/* 156 */	"\tFMOVE.D %1,%0\n",	/* stmt: ASGND(addr,reg) */
/* 157 */	"\tLEA.L %1,A0\n\tLEA.L %0,A1\n\tMOVE.L (A0)+,(A1)+\n\tMOVE.L (A0),(A1)\n",	/* stmt: ASGND(addr,mem) */
/* 158 */	"\tFMOVE.S %1,%0\n",	/* stmt: ASGNF(addr,reg) */
/* 159 */	"\tMOVE.L %1,%0\n",	/* stmt: ASGNF(addr,mem) */
/* 160 */	"\tFMOVE.X %0,-(SP)\n",	/* stmt: ARGD(reg) */
/* 161 */	"\tFMOVE.X %0,-(SP)\n",	/* stmt: ARGF(reg) */
/* 162 */	"?\tFMOVE.X %0,%c\n\tFADD.X %1,%c\n",	/* reg: ADDD(reg,reg) */
/* 163 */	"?\tFMOVE.X %0,%c\n\tFADD.X %1,%c\n",	/* reg: ADDF(reg,reg) */
/* 164 */	"?\tFMOVE.X %0,%c\n\tFSUB.X %1,%c\n",	/* reg: SUBD(reg,reg) */
/* 165 */	"?\tFMOVE.X %0,%c\n\tFSUB.X %1,%c\n",	/* reg: SUBF(reg,reg) */
/* 166 */	"?\tFMOVE.X %0,%c\n\tFMUL.X %1,%c\n",	/* reg: MULD(reg,reg) */
/* 167 */	"?\tFMOVE.X %0,%c\n\tFMUL.X %1,%c\n",	/* reg: MULF(reg,reg) */
/* 168 */	"?\tFMOVE.X %0,%c\n\tFDIV.X %1,%c\n",	/* reg: DIVD(reg,reg) */
/* 169 */	"?\tFMOVE.X %0,%c\n\tFDIV.X %1,%c\n",	/* reg: DIVF(reg,reg) */
/* 170 */	"\tFNEG.X %c\n",	/* reg: NEGD(reg) */
/* 171 */	"\tFNEG.X %c\n",	/* reg: NEGF(reg) */
/* 172 */	"\tBRA %0\n",	/* stmt: JUMPV(acon) */
/* 173 */	"\tJMP (PC,%0)\n",	/* stmt: JUMPV(pcrel) */
/* 174 */	"%a:\n",	/* stmt: LABELV */
/* 175 */	"\tTST.L %0\n\tBEQ %a\n",	/* stmt: EQI(ea0,con0) */
/* 176 */	"\tTST.L %0\n\tBNE %a\n",	/* stmt: NEI(ea0,con0) */
/* 177 */	"\tCMP.L %1,%0\n\tBEQ %a\n",	/* stmt: EQI(reg,ea1) */
/* 178 */	"\tCMP.L %1,%0\n\tBGE %a\n",	/* stmt: GEI(reg,ea1) */
/* 179 */	"\tCMP.L %1,%0\n\tBGT %a\n",	/* stmt: GTI(reg,ea1) */
/* 180 */	"\tCMP.L %1,%0\n\tBLE %a\n",	/* stmt: LEI(reg,ea1) */
/* 181 */	"\tCMP.L %1,%0\n\tBLT %a\n",	/* stmt: LTI(reg,ea1) */
/* 182 */	"\tCMP.L %1,%0\n\tBNE %a\n",	/* stmt: NEI(reg,ea1) */
/* 183 */	"\tCMP.L %1,%0\n\tBHS %a\n",	/* stmt: GEU(reg,ea1) */
/* 184 */	"\tCMP.L %1,%0\n\tBHI %a\n",	/* stmt: GTU(reg,ea1) */
/* 185 */	"\tCMP.L %1,%0\n\tBLS %a\n",	/* stmt: LEU(reg,ea1) */
/* 186 */	"\tCMP.L %1,%0\n\tBLO %a\n",	/* stmt: LTU(reg,ea1) */
/* 187 */	"\tFCMP.X %1,%0\n\tFBEQ.W %a\n",	/* stmt: EQD(reg,reg) */
/* 188 */	"\tFCMP.X %1,%0\n\tFBGE.W %a\n",	/* stmt: GED(reg,reg) */
/* 189 */	"\tFCMP.X %1,%0\n\tFBGT.W %a\n",	/* stmt: GTD(reg,reg) */
/* 190 */	"\tFCMP.X %1,%0\n\tFBLE.W %a\n",	/* stmt: LED(reg,reg) */
/* 191 */	"\tFCMP.X %1,%0\n\tFBLT.W %a\n",	/* stmt: LTD(reg,reg) */
/* 192 */	"\tFCMP.X %1,%0\n\tFBNE.W %a\n",	/* stmt: NED(reg,reg) */
/* 193 */	"\tFCMP.X %1,%0\n\tFBEQ.W %a\n",	/* stmt: EQF(reg,reg) */
/* 194 */	"\tFCMP.X %1,%0\n\tFBGE.W %a\n",	/* stmt: GEF(reg,reg) */
/* 195 */	"\tFCMP.X %1,%0\n\tFBGT.W %a\n",	/* stmt: GTF(reg,reg) */
/* 196 */	"\tFCMP.X %1,%0\n\tFBLE.W %a\n",	/* stmt: LEF(reg,reg) */
/* 197 */	"\tFCMP.X %1,%0\n\tFBLT.W %a\n",	/* stmt: LTF(reg,reg) */
/* 198 */	"\tFCMP.X %1,%0\n\tFBNE.W %a\n",	/* stmt: NEF(reg,reg) */
/* 199 */	"\tJSR %0\n\tADDA.L %#%a,SP\n",	/* reg: CALLI(avar) */
/* 200 */	"\tJSR %0\n\tADDA.L %#%a,SP\n",	/* stmt: CALLV(avar) */
/* 201 */	"\tJSR %0\n\tADDA.L %#%a,SP\n",	/* reg: CALLF(avar) */
/* 202 */	"\tJSR %0\n\tADDA.L %#%a,SP\n",	/* reg: CALLD(avar) */
/* 203 */	"# RTS\n",	/* stmt: RETI(reg) */
/* 204 */	"# RTS\n",	/* stmt: RETF(reg) */
/* 205 */	"# RTS\n",	/* stmt: RETD(reg) */
};

static char _isinstruction[] = {
/* 0 */	0,
/* 1 */	1,	/* # read register\n */
/* 2 */	1,	/* # read register\n */
/* 3 */	1,	/* # read register\n */
/* 4 */	1,	/* # read register\n */
/* 5 */	1,	/* # read register\n */
/* 6 */	1,	/* # read register\n */
/* 7 */	1,	/* # write register\n */
/* 8 */	1,	/* # write register\n */
/* 9 */	1,	/* # write register\n */
/* 10 */	1,	/* # write register\n */
/* 11 */	1,	/* # write register\n */
/* 12 */	1,	/* # write register\n */
/* 13 */	1,	/* # write register\n */
/* 14 */	0,	/* %#%a */
/* 15 */	0,	/* %#%a */
/* 16 */	0,	/* %#%a */
/* 17 */	0,	/* %#%a */
/* 18 */	0,	/* %#%a */
/* 19 */	0,	/*  */
/* 20 */	0,	/* %0 */
/* 21 */	0,	/* %0 */
/* 22 */	0,	/* %a */
/* 23 */	0,	/* %a */
/* 24 */	0,	/* %1(%0 */
/* 25 */	0,	/* %a(A6 */
/* 26 */	0,	/* %a(A6 */
/* 27 */	0,	/* %0 */
/* 28 */	0,	/* (%0 */
/* 29 */	0,	/* %1(%0 */
/* 30 */	0,	/* %a(A6 */
/* 31 */	0,	/* %a(A6 */
/* 32 */	0,	/* (%a,A6 */
/* 33 */	0,	/* (%a,A6 */
/* 34 */	0,	/* %a(A5) */
/* 35 */	0,	/* %a */
/* 36 */	1,	/* \tLEA %a,%c\n */
/* 37 */	0,	/* %0 */
/* 38 */	0,	/* %0*%1 */
/* 39 */	0,	/* %0) */
/* 40 */	0,	/* %1,%0) */
/* 41 */	0,	/* (%1,%0) */
/* 42 */	0,	/* %0 */
/* 43 */	0,	/* (%0) */
/* 44 */	0,	/* %0 */
/* 45 */	0,	/* %#0 */
/* 46 */	0,	/* %#0 */
/* 47 */	0,	/* %#0 */
/* 48 */	0,	/* %#%a */
/* 49 */	0,	/* %#%a */
/* 50 */	0,	/* 2 */
/* 51 */	0,	/* 4 */
/* 52 */	0,	/* 8 */
/* 53 */	0,	/* %0 */
/* 54 */	0,	/* %0 */
/* 55 */	1,	/* \tMOVE.L %0,%c\n */
/* 56 */	0,	/* %0 */
/* 57 */	0,	/* %0 */
/* 58 */	0,	/* %0 */
/* 59 */	0,	/* %0 */
/* 60 */	0,	/* %0 */
/* 61 */	0,	/* %0 */
/* 62 */	0,	/* %0 */
/* 63 */	0,	/* %0 */
/* 64 */	0,	/* %0 */
/* 65 */	0,	/* %0 */
/* 66 */	1,	/* \tLEA %0,%c\n */
/* 67 */	1,	/* \tMOVE.L %0,%c\n */
/* 68 */	1,	/* \tMOVE.B %0,%c\n */
/* 69 */	1,	/* \tMOVE.L %0,%c\n */
/* 70 */	1,	/* \tMOVE.L %0,%c\n */
/* 71 */	1,	/* \tMOVE.W %0,%c\n */
/* 72 */	1,	/* \tMOVE.L %0,%c\n */
/* 73 */	1,	/* \tMOVE.L %0,%c\n */
/* 74 */	1,	/* \tMOVE.L %0,%c\n */
/* 75 */	1,	/* \tMOVE.L %0,%c\n */
/* 76 */	1,	/* \tMOVE.L %0,%c\n */
/* 77 */	1,	/* ?\tMOVE.L %0,%c\n\tADDQ.L %1,%c\n */
/* 78 */	1,	/* ?\tMOVE.L %0,%c\n\tSUBQ.L %1,%c\n */
/* 79 */	1,	/* ?\tMOVE.L %0,%c\n\tADD.L %1,%c\n */
/* 80 */	1,	/* ?\tMOVE.L %0,%c\n\tADDA.L %1,%c\n */
/* 81 */	1,	/* ?\tMOVE.L %0,%c\n\tADD.L %1,%c\n */
/* 82 */	1,	/* ?\tMOVE.L %0,%c\n\tSUB.L %1,%c\n */
/* 83 */	1,	/* ?\tMOVE.L %0,%c\n\tSUBA.L %1,%c\n */
/* 84 */	1,	/* ?\tMOVE.L %0,%c\n\tSUB.L %1,%c\n */
/* 85 */	1,	/* \tADD.L %2,%1\n */
/* 86 */	1,	/* \tADD.L %2,%1\n */
/* 87 */	1,	/* \tSUB.L %2,%1\n */
/* 88 */	1,	/* \tSUB.L %2,%1\n */
/* 89 */	1,	/* ?\tMOVE.L %0,%c\n\tAND.L %1,%c\n */
/* 90 */	1,	/* ?\tMOVE.L %0,%c\n\tOR.L %1,%c\n */
/* 91 */	1,	/* ?\tMOVE.L %0,%c\n\tEOR.L %1,%c\n */
/* 92 */	1,	/* \tAND.L %2,%1\n */
/* 93 */	1,	/* \tOR.L %2,%1\n */
/* 94 */	1,	/* \tEOR.L %2,%1\n */
/* 95 */	1,	/* ?\tMOVE.L %0,%c\n\tNOT.L %c\n */
/* 96 */	1,	/* ?\tMOVE.L %0,%c\n\tNEG.L %c\n */
/* 97 */	1,	/* \tNOT.L %1\n */
/* 98 */	1,	/* \tNEG.L %1\n */
/* 99 */	1,	/* ?\tMOVE.L %0,%c\n\tASL.L %1,%c\n */
/* 100 */	1,	/* ?\tMOVE.L %0,%c\n\tLSL.L %1,%c\n */
/* 101 */	1,	/* ?\tMOVE.L %0,%c\n\tASR.L %1,%c\n */
/* 102 */	1,	/* ?\tMOVE.L %0,%c\n\tLSR.L %1,%c\n */
/* 103 */	1,	/* ?\tMOVE.L %0,%c\n\tMULS.L %1,%c\n */
/* 104 */	1,	/* ?\tMOVE.L %0,%c\n\tMULU.L %1,%c\n */
/* 105 */	1,	/* ?\tMOVE.L %0,%c\n\tDIVU.L %1,%c\n */
/* 106 */	1,	/* ?\tMOVE.L %0,%c\n\tDIVS.L %1,%c\n */
/* 107 */	1,	/* \tMOVE.L %0,D1\n\tCLR.L %c\n\tDIVU.L %1,%c:D1\n */
/* 108 */	1,	/* #\tCLR.L %c\n\tDIVS.L %1,%0\n */
/* 109 */	1,	/* \tMOVE.B %0,%c\n\tEXT.W %c\n\tEXT.L %c\n */
/* 110 */	1,	/* \tMOVE.B %0,%c\n\tAND.L #$FF,%0\n */
/* 111 */	1,	/* \tMOVE.W %0,%c\n\tEXT.L %c\n */
/* 112 */	1,	/* \tMOVE.W %0,%c\n\tAND.L #$FFFF,%0\n */
/* 113 */	1,	/* \tMOVE.B %0,%c\n\tEXT.W %c\n\tEXT.L %c\n */
/* 114 */	1,	/* \tCLR.L %c\n\tMOVE.B %0,%c\n */
/* 115 */	1,	/* \tMOVE.W %0,%c\n\tEXT.L %c\n */
/* 116 */	1,	/* \tCLR.L %c\n\tMOVE.W %0,%c\n */
/* 117 */	0,	/* %0 */
/* 118 */	0,	/* %0 */
/* 119 */	0,	/* %0 */
/* 120 */	0,	/* %0 */
/* 121 */	1,	/* \tMOVE.L %0,%c\n */
/* 122 */	1,	/* \tMOVE.L %0,%c\n */
/* 123 */	1,	/* \tMOVE.L %0,%c\n */
/* 124 */	1,	/* \tMOVE.L %0,%c\n */
/* 125 */	1,	/* \tMOVE.L %0,%c\n */
/* 126 */	1,	/* \tMOVE.L %0,%c\n */
/* 127 */	1,	/* \tMOVE.L %0,%c\n */
/* 128 */	1,	/* \tMOVE.L %0,%c\n */
/* 129 */	0,	/* %0 */
/* 130 */	0,	/* %0 */
/* 131 */	1,	/* \tFMOVE.X %0,%c\n */
/* 132 */	1,	/* \tFMOVE.X %0,%c\n */
/* 133 */	1,	/* \tFMOVE.L %0,%c\n */
/* 134 */	1,	/* \tFMOVE.L %0,%c\n */
/* 135 */	1,	/* \tMOVE.B %1,%0\n */
/* 136 */	1,	/* \tCLR.L %0\n */
/* 137 */	1,	/* \tMOVE.L %1,%0\n */
/* 138 */	1,	/* \tCLR.L %0\n */
/* 139 */	1,	/* \tFMOVE.L %1,%0\n */
/* 140 */	1,	/* \tMOVE.L %1,%0\n */
/* 141 */	1,	/* \tCLR.L %0\n */
/* 142 */	1,	/* \tMOVE.W %1,%0\n */
/* 143 */	1,	/* \tCLR.W %0\n */
/* 144 */	1,	/* \tMOVE.L %0,-(SP)\n */
/* 145 */	1,	/* \tPEA.L %0\n */
/* 146 */	1,	/* \tMOVE.L %0,-(SP)\n */
/* 147 */	1,	/* \tPEA.L %0\n */
/* 148 */	1,	/* # MOVE (src)+,(dst)+\n */
/* 149 */	1,	/* # Copy to stack\n */
/* 150 */	1,	/* \tFMOVE.X %0,%c\n */
/* 151 */	1,	/* \tFMOVE.X %0,%c\n */
/* 152 */	1,	/* \tFMOVE.D %0,%c\n */
/* 153 */	1,	/* \tFMOVE.S %0,%c\n */
/* 154 */	0,	/* %0 */
/* 155 */	0,	/* %0 */
/* 156 */	1,	/* \tFMOVE.D %1,%0\n */
/* 157 */	1,	/* \tLEA.L %1,A0\n\tLEA.L %0,A1\n\tMOVE.L (A0)+,(A1)+\n\tMOVE.L (A0),(A1)\n */
/* 158 */	1,	/* \tFMOVE.S %1,%0\n */
/* 159 */	1,	/* \tMOVE.L %1,%0\n */
/* 160 */	1,	/* \tFMOVE.X %0,-(SP)\n */
/* 161 */	1,	/* \tFMOVE.X %0,-(SP)\n */
/* 162 */	1,	/* ?\tFMOVE.X %0,%c\n\tFADD.X %1,%c\n */
/* 163 */	1,	/* ?\tFMOVE.X %0,%c\n\tFADD.X %1,%c\n */
/* 164 */	1,	/* ?\tFMOVE.X %0,%c\n\tFSUB.X %1,%c\n */
/* 165 */	1,	/* ?\tFMOVE.X %0,%c\n\tFSUB.X %1,%c\n */
/* 166 */	1,	/* ?\tFMOVE.X %0,%c\n\tFMUL.X %1,%c\n */
/* 167 */	1,	/* ?\tFMOVE.X %0,%c\n\tFMUL.X %1,%c\n */
/* 168 */	1,	/* ?\tFMOVE.X %0,%c\n\tFDIV.X %1,%c\n */
/* 169 */	1,	/* ?\tFMOVE.X %0,%c\n\tFDIV.X %1,%c\n */
/* 170 */	1,	/* \tFNEG.X %c\n */
/* 171 */	1,	/* \tFNEG.X %c\n */
/* 172 */	1,	/* \tBRA %0\n */
/* 173 */	1,	/* \tJMP (PC,%0)\n */
/* 174 */	1,	/* %a:\n */
/* 175 */	1,	/* \tTST.L %0\n\tBEQ %a\n */
/* 176 */	1,	/* \tTST.L %0\n\tBNE %a\n */
/* 177 */	1,	/* \tCMP.L %1,%0\n\tBEQ %a\n */
/* 178 */	1,	/* \tCMP.L %1,%0\n\tBGE %a\n */
/* 179 */	1,	/* \tCMP.L %1,%0\n\tBGT %a\n */
/* 180 */	1,	/* \tCMP.L %1,%0\n\tBLE %a\n */
/* 181 */	1,	/* \tCMP.L %1,%0\n\tBLT %a\n */
/* 182 */	1,	/* \tCMP.L %1,%0\n\tBNE %a\n */
/* 183 */	1,	/* \tCMP.L %1,%0\n\tBHS %a\n */
/* 184 */	1,	/* \tCMP.L %1,%0\n\tBHI %a\n */
/* 185 */	1,	/* \tCMP.L %1,%0\n\tBLS %a\n */
/* 186 */	1,	/* \tCMP.L %1,%0\n\tBLO %a\n */
/* 187 */	1,	/* \tFCMP.X %1,%0\n\tFBEQ.W %a\n */
/* 188 */	1,	/* \tFCMP.X %1,%0\n\tFBGE.W %a\n */
/* 189 */	1,	/* \tFCMP.X %1,%0\n\tFBGT.W %a\n */
/* 190 */	1,	/* \tFCMP.X %1,%0\n\tFBLE.W %a\n */
/* 191 */	1,	/* \tFCMP.X %1,%0\n\tFBLT.W %a\n */
/* 192 */	1,	/* \tFCMP.X %1,%0\n\tFBNE.W %a\n */
/* 193 */	1,	/* \tFCMP.X %1,%0\n\tFBEQ.W %a\n */
/* 194 */	1,	/* \tFCMP.X %1,%0\n\tFBGE.W %a\n */
/* 195 */	1,	/* \tFCMP.X %1,%0\n\tFBGT.W %a\n */
/* 196 */	1,	/* \tFCMP.X %1,%0\n\tFBLE.W %a\n */
/* 197 */	1,	/* \tFCMP.X %1,%0\n\tFBLT.W %a\n */
/* 198 */	1,	/* \tFCMP.X %1,%0\n\tFBNE.W %a\n */
/* 199 */	1,	/* \tJSR %0\n\tADDA.L %#%a,SP\n */
/* 200 */	1,	/* \tJSR %0\n\tADDA.L %#%a,SP\n */
/* 201 */	1,	/* \tJSR %0\n\tADDA.L %#%a,SP\n */
/* 202 */	1,	/* \tJSR %0\n\tADDA.L %#%a,SP\n */
/* 203 */	1,	/* # RTS\n */
/* 204 */	1,	/* # RTS\n */
/* 205 */	1,	/* # RTS\n */
};

static char *_string[] = {
/* 0 */	0,
/* 1 */	"reg: INDIRC(VREGP)",
/* 2 */	"reg: INDIRD(VREGP)",
/* 3 */	"reg: INDIRF(VREGP)",
/* 4 */	"reg: INDIRI(VREGP)",
/* 5 */	"reg: INDIRP(VREGP)",
/* 6 */	"reg: INDIRS(VREGP)",
/* 7 */	"stmt: ASGNC(VREGP,reg)",
/* 8 */	"stmt: ASGND(VREGP,reg)",
/* 9 */	"stmt: ASGNF(VREGP,reg)",
/* 10 */	"stmt: ASGNI(VREGP,reg)",
/* 11 */	"stmt: ASGND(VREGP,reg)",
/* 12 */	"stmt: ASGNP(VREGP,reg)",
/* 13 */	"stmt: ASGNS(VREGP,reg)",
/* 14 */	"con: CNSTC",
/* 15 */	"con: CNSTI",
/* 16 */	"con: CNSTP",
/* 17 */	"con: CNSTS",
/* 18 */	"con: CNSTU",
/* 19 */	"stmt: reg",
/* 20 */	"reg: CVIU(reg)",
/* 21 */	"reg: CVUI(reg)",
/* 22 */	"disp16: CNSTI",
/* 23 */	"disp8: CNSTI",
/* 24 */	"base: ADDP(reg,disp16)",
/* 25 */	"base: ADDRFP",
/* 26 */	"base: ADDRLP",
/* 27 */	"base: basei",
/* 28 */	"basei: reg",
/* 29 */	"basei: ADDP(reg,disp8)",
/* 30 */	"basei: ADDRFP",
/* 31 */	"basei: ADDRLP",
/* 32 */	"basei: ADDRFP",
/* 33 */	"basei: ADDRLP",
/* 34 */	"addr: ADDRGP",
/* 35 */	"acon: ADDRGP",
/* 36 */	"table: ADDRGP",
/* 37 */	"index: reg",
/* 38 */	"index: LSHI(reg,scf)",
/* 39 */	"addr: base",
/* 40 */	"addr: ADDP(index,basei)",
/* 41 */	"case: ADDP(index,table)",
/* 42 */	"avar: acon",
/* 43 */	"avar: reg",
/* 44 */	"avar: addr",
/* 45 */	"con0: CNSTI",
/* 46 */	"con0: CNSTP",
/* 47 */	"con0: CNSTU",
/* 48 */	"con3: CNSTI",
/* 49 */	"con3: CNSTP",
/* 50 */	"scf: CNSTI",
/* 51 */	"scf: CNSTI",
/* 52 */	"scf: CNSTI",
/* 53 */	"mem: INDIRI(addr)",
/* 54 */	"mem: INDIRP(addr)",
/* 55 */	"pcrel: INDIRP(case)",
/* 56 */	"ri: reg",
/* 57 */	"ri: con",
/* 58 */	"ri3: con3",
/* 59 */	"ri3: reg",
/* 60 */	"ea0: mem",
/* 61 */	"ea0: ri",
/* 62 */	"ea1: mem",
/* 63 */	"ea1: ri",
/* 64 */	"ea3: mem",
/* 65 */	"ea3: ri",
/* 66 */	"reg: addr",
/* 67 */	"reg: ri",
/* 68 */	"reg: INDIRC(addr)",
/* 69 */	"reg: INDIRI(addr)",
/* 70 */	"reg: INDIRP(addr)",
/* 71 */	"reg: INDIRS(addr)",
/* 72 */	"reg: LOADC(reg)",
/* 73 */	"reg: LOADI(reg)",
/* 74 */	"reg: LOADP(reg)",
/* 75 */	"reg: LOADS(reg)",
/* 76 */	"reg: LOADU(reg)",
/* 77 */	"reg: ADDI(reg,con3)",
/* 78 */	"reg: SUBI(reg,con3)",
/* 79 */	"reg: ADDI(reg,ea1)",
/* 80 */	"reg: ADDP(reg,ea1)",
/* 81 */	"reg: ADDU(reg,ea1)",
/* 82 */	"reg: SUBI(reg,ea1)",
/* 83 */	"reg: SUBP(reg,ea1)",
/* 84 */	"reg: SUBU(reg,ea1)",
/* 85 */	"stmt: ASGNI(addr,ADDI(mem,ri))",
/* 86 */	"stmt: ASGNI(addr,ADDU(mem,ri))",
/* 87 */	"stmt: ASGNI(addr,SUBI(mem,ri))",
/* 88 */	"stmt: ASGNI(addr,SUBU(mem,ri))",
/* 89 */	"reg: BANDU(reg,ea1)",
/* 90 */	"reg: BORU(reg,ea1)",
/* 91 */	"reg: BXORU(reg,reg)",
/* 92 */	"stmt: ASGNI(addr,BANDU(mem,ri))",
/* 93 */	"stmt: ASGNI(addr,BORU(mem,ri))",
/* 94 */	"stmt: ASGNI(addr,BXORU(mem,reg))",
/* 95 */	"reg: BCOMU(reg)",
/* 96 */	"reg: NEGI(reg)",
/* 97 */	"stmt: ASGNI(addr,BCOMU(mem))",
/* 98 */	"stmt: ASGNI(addr,NEGI(mem))",
/* 99 */	"reg: LSHI(reg,ri3)",
/* 100 */	"reg: LSHU(reg,ri3)",
/* 101 */	"reg: RSHI(reg,ri3)",
/* 102 */	"reg: RSHU(reg,ri3)",
/* 103 */	"reg: MULI(reg,ea3)",
/* 104 */	"reg: MULU(reg,ea3)",
/* 105 */	"reg: DIVU(reg,ea3)",
/* 106 */	"reg: DIVI(reg,ea3)",
/* 107 */	"reg: MODU(reg,ea3)",
/* 108 */	"reg: MODI(reg,reg)",
/* 109 */	"reg: CVCI(reg)",
/* 110 */	"reg: CVCU(reg)",
/* 111 */	"reg: CVSI(reg)",
/* 112 */	"reg: CVSU(reg)",
/* 113 */	"reg: CVCI(INDIRC(addr))",
/* 114 */	"reg: CVCU(INDIRC(addr))",
/* 115 */	"reg: CVSI(INDIRS(addr))",
/* 116 */	"reg: CVSU(INDIRS(addr))",
/* 117 */	"reg: CVIC(reg)",
/* 118 */	"reg: CVIS(reg)",
/* 119 */	"reg: CVUC(reg)",
/* 120 */	"reg: CVUS(reg)",
/* 121 */	"reg: CVIC(reg)",
/* 122 */	"reg: CVIS(reg)",
/* 123 */	"reg: CVIU(reg)",
/* 124 */	"reg: CVPU(reg)",
/* 125 */	"reg: CVUC(reg)",
/* 126 */	"reg: CVUI(reg)",
/* 127 */	"reg: CVUP(reg)",
/* 128 */	"reg: CVUS(reg)",
/* 129 */	"reg: CVDF(reg)",
/* 130 */	"reg: CVFD(reg)",
/* 131 */	"reg: CVDF(reg)",
/* 132 */	"reg: CVFD(reg)",
/* 133 */	"reg: CVID(ea0)",
/* 134 */	"reg: CVDI(reg)",
/* 135 */	"stmt: ASGNC(addr,ea1)",
/* 136 */	"stmt: ASGNC(addr,con0)",
/* 137 */	"stmt: ASGNI(addr,ea1)",
/* 138 */	"stmt: ASGNI(addr,con0)",
/* 139 */	"stmt: ASGNI(addr,CVDI(reg))",
/* 140 */	"stmt: ASGNP(addr,ea1)",
/* 141 */	"stmt: ASGNP(addr,con0)",
/* 142 */	"stmt: ASGNS(addr,ea1)",
/* 143 */	"stmt: ASGNS(addr,con0)",
/* 144 */	"stmt: ARGI(ea0)",
/* 145 */	"stmt: ARGI(addr)",
/* 146 */	"stmt: ARGP(ea0)",
/* 147 */	"stmt: ARGP(addr)",
/* 148 */	"stmt: ASGNB(reg,INDIRB(reg))",
/* 149 */	"stmt: ARGB(INDIRB(reg))",
/* 150 */	"reg: LOADD(reg)",
/* 151 */	"reg: LOADF(reg)",
/* 152 */	"reg: INDIRD(addr)",
/* 153 */	"reg: INDIRF(addr)",
/* 154 */	"mem: INDIRD(addr)",
/* 155 */	"mem: INDIRF(addr)",
/* 156 */	"stmt: ASGND(addr,reg)",
/* 157 */	"stmt: ASGND(addr,mem)",
/* 158 */	"stmt: ASGNF(addr,reg)",
/* 159 */	"stmt: ASGNF(addr,mem)",
/* 160 */	"stmt: ARGD(reg)",
/* 161 */	"stmt: ARGF(reg)",
/* 162 */	"reg: ADDD(reg,reg)",
/* 163 */	"reg: ADDF(reg,reg)",
/* 164 */	"reg: SUBD(reg,reg)",
/* 165 */	"reg: SUBF(reg,reg)",
/* 166 */	"reg: MULD(reg,reg)",
/* 167 */	"reg: MULF(reg,reg)",
/* 168 */	"reg: DIVD(reg,reg)",
/* 169 */	"reg: DIVF(reg,reg)",
/* 170 */	"reg: NEGD(reg)",
/* 171 */	"reg: NEGF(reg)",
/* 172 */	"stmt: JUMPV(acon)",
/* 173 */	"stmt: JUMPV(pcrel)",
/* 174 */	"stmt: LABELV",
/* 175 */	"stmt: EQI(ea0,con0)",
/* 176 */	"stmt: NEI(ea0,con0)",
/* 177 */	"stmt: EQI(reg,ea1)",
/* 178 */	"stmt: GEI(reg,ea1)",
/* 179 */	"stmt: GTI(reg,ea1)",
/* 180 */	"stmt: LEI(reg,ea1)",
/* 181 */	"stmt: LTI(reg,ea1)",
/* 182 */	"stmt: NEI(reg,ea1)",
/* 183 */	"stmt: GEU(reg,ea1)",
/* 184 */	"stmt: GTU(reg,ea1)",
/* 185 */	"stmt: LEU(reg,ea1)",
/* 186 */	"stmt: LTU(reg,ea1)",
/* 187 */	"stmt: EQD(reg,reg)",
/* 188 */	"stmt: GED(reg,reg)",
/* 189 */	"stmt: GTD(reg,reg)",
/* 190 */	"stmt: LED(reg,reg)",
/* 191 */	"stmt: LTD(reg,reg)",
/* 192 */	"stmt: NED(reg,reg)",
/* 193 */	"stmt: EQF(reg,reg)",
/* 194 */	"stmt: GEF(reg,reg)",
/* 195 */	"stmt: GTF(reg,reg)",
/* 196 */	"stmt: LEF(reg,reg)",
/* 197 */	"stmt: LTF(reg,reg)",
/* 198 */	"stmt: NEF(reg,reg)",
/* 199 */	"reg: CALLI(avar)",
/* 200 */	"stmt: CALLV(avar)",
/* 201 */	"reg: CALLF(avar)",
/* 202 */	"reg: CALLD(avar)",
/* 203 */	"stmt: RETI(reg)",
/* 204 */	"stmt: RETF(reg)",
/* 205 */	"stmt: RETD(reg)",
};

static short _decode_stmt[] = {
	0,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	19,
	85,
	86,
	87,
	88,
	92,
	93,
	94,
	97,
	98,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	142,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	156,
	157,
	158,
	159,
	160,
	161,
	172,
	173,
	174,
	175,
	176,
	177,
	178,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	197,
	198,
	200,
	203,
	204,
	205,
};

static short _decode_reg[] = {
	0,
	1,
	2,
	3,
	4,
	5,
	6,
	20,
	21,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	82,
	83,
	84,
	89,
	90,
	91,
	95,
	96,
	99,
	100,
	101,
	102,
	103,
	104,
	105,
	106,
	107,
	108,
	109,
	110,
	111,
	112,
	113,
	114,
	115,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
	132,
	133,
	134,
	150,
	151,
	152,
	153,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	199,
	201,
	202,
};

static short _decode_con[] = {
	0,
	14,
	15,
	16,
	17,
	18,
};

static short _decode_disp16[] = {
	0,
	22,
};

static short _decode_disp8[] = {
	0,
	23,
};

static short _decode_base[] = {
	0,
	24,
	25,
	26,
	27,
};

static short _decode_basei[] = {
	0,
	28,
	29,
	30,
	31,
	32,
	33,
};

static short _decode_addr[] = {
	0,
	34,
	39,
	40,
};

static short _decode_acon[] = {
	0,
	35,
};

static short _decode_table[] = {
	0,
	36,
};

static short _decode_index[] = {
	0,
	37,
	38,
};

static short _decode_scf[] = {
	0,
	50,
	51,
	52,
};

static short _decode_case[] = {
	0,
	41,
};

static short _decode_avar[] = {
	0,
	42,
	43,
	44,
};

static short _decode_con0[] = {
	0,
	45,
	46,
	47,
};

static short _decode_con3[] = {
	0,
	48,
	49,
};

static short _decode_mem[] = {
	0,
	53,
	54,
	154,
	155,
};

static short _decode_pcrel[] = {
	0,
	55,
};

static short _decode_ri[] = {
	0,
	56,
	57,
};

static short _decode_ri3[] = {
	0,
	58,
	59,
};

static short _decode_ea0[] = {
	0,
	60,
	61,
};

static short _decode_ea1[] = {
	0,
	62,
	63,
};

static short _decode_ea3[] = {
	0,
	64,
	65,
};

static int _rule(state, goalnt) void *state; int goalnt; {
	if (goalnt < 1 || goalnt > 23)
		fatal("_rule", "Bad goal nonterminal %d\n", goalnt);
	if (!state)
		return 0;
	switch (goalnt) {
	case _stmt_NT:	return _decode_stmt[((struct _state *)state)->rule._stmt];
	case _reg_NT:	return _decode_reg[((struct _state *)state)->rule._reg];
	case _con_NT:	return _decode_con[((struct _state *)state)->rule._con];
	case _disp16_NT:	return _decode_disp16[((struct _state *)state)->rule._disp16];
	case _disp8_NT:	return _decode_disp8[((struct _state *)state)->rule._disp8];
	case _base_NT:	return _decode_base[((struct _state *)state)->rule._base];
	case _basei_NT:	return _decode_basei[((struct _state *)state)->rule._basei];
	case _addr_NT:	return _decode_addr[((struct _state *)state)->rule._addr];
	case _acon_NT:	return _decode_acon[((struct _state *)state)->rule._acon];
	case _table_NT:	return _decode_table[((struct _state *)state)->rule._table];
	case _index_NT:	return _decode_index[((struct _state *)state)->rule._index];
	case _scf_NT:	return _decode_scf[((struct _state *)state)->rule._scf];
	case _case_NT:	return _decode_case[((struct _state *)state)->rule._case];
	case _avar_NT:	return _decode_avar[((struct _state *)state)->rule._avar];
	case _con0_NT:	return _decode_con0[((struct _state *)state)->rule._con0];
	case _con3_NT:	return _decode_con3[((struct _state *)state)->rule._con3];
	case _mem_NT:	return _decode_mem[((struct _state *)state)->rule._mem];
	case _pcrel_NT:	return _decode_pcrel[((struct _state *)state)->rule._pcrel];
	case _ri_NT:	return _decode_ri[((struct _state *)state)->rule._ri];
	case _ri3_NT:	return _decode_ri3[((struct _state *)state)->rule._ri3];
	case _ea0_NT:	return _decode_ea0[((struct _state *)state)->rule._ea0];
	case _ea1_NT:	return _decode_ea1[((struct _state *)state)->rule._ea1];
	case _ea3_NT:	return _decode_ea3[((struct _state *)state)->rule._ea3];
	default:
		fatal("_rule", "Bad goal nonterminal %d\n", goalnt);
		return 0;
	}
}

static void _closure_reg ARGS((NODEPTR_TYPE, int));
static void _closure_con ARGS((NODEPTR_TYPE, int));
static void _closure_base ARGS((NODEPTR_TYPE, int));
static void _closure_basei ARGS((NODEPTR_TYPE, int));
static void _closure_addr ARGS((NODEPTR_TYPE, int));
static void _closure_acon ARGS((NODEPTR_TYPE, int));
static void _closure_con3 ARGS((NODEPTR_TYPE, int));
static void _closure_mem ARGS((NODEPTR_TYPE, int));
static void _closure_ri ARGS((NODEPTR_TYPE, int));

static void _closure_reg(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 0 < p->cost[_ri3_NT]) {
		p->cost[_ri3_NT] = c + 0;
		p->rule._ri3 = 2;
	}
	if (c + 0 < p->cost[_ri_NT]) {
		p->cost[_ri_NT] = c + 0;
		p->rule._ri = 1;
		_closure_ri(a, c + 0);
	}
	if (c + 1 < p->cost[_avar_NT]) {
		p->cost[_avar_NT] = c + 1;
		p->rule._avar = 2;
	}
	if (c + 0 < p->cost[_index_NT]) {
		p->cost[_index_NT] = c + 0;
		p->rule._index = 1;
	}
	if (c + 0 < p->cost[_basei_NT]) {
		p->cost[_basei_NT] = c + 0;
		p->rule._basei = 1;
		_closure_basei(a, c + 0);
	}
	if (c + 0 < p->cost[_stmt_NT]) {
		p->cost[_stmt_NT] = c + 0;
		p->rule._stmt = 8;
	}
}

static void _closure_con(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 0 < p->cost[_ri_NT]) {
		p->cost[_ri_NT] = c + 0;
		p->rule._ri = 2;
		_closure_ri(a, c + 0);
	}
}

static void _closure_base(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 0 < p->cost[_addr_NT]) {
		p->cost[_addr_NT] = c + 0;
		p->rule._addr = 2;
		_closure_addr(a, c + 0);
	}
}

static void _closure_basei(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 0 < p->cost[_base_NT]) {
		p->cost[_base_NT] = c + 0;
		p->rule._base = 4;
		_closure_base(a, c + 0);
	}
}

static void _closure_addr(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 1 < p->cost[_reg_NT]) {
		p->cost[_reg_NT] = c + 1;
		p->rule._reg = 9;
		_closure_reg(a, c + 1);
	}
	if (c + 2 < p->cost[_avar_NT]) {
		p->cost[_avar_NT] = c + 2;
		p->rule._avar = 3;
	}
}

static void _closure_acon(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 0 < p->cost[_avar_NT]) {
		p->cost[_avar_NT] = c + 0;
		p->rule._avar = 1;
	}
}

static void _closure_con3(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 0 < p->cost[_ri3_NT]) {
		p->cost[_ri3_NT] = c + 0;
		p->rule._ri3 = 1;
	}
}

static void _closure_mem(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 3 < p->cost[_ea3_NT]) {
		p->cost[_ea3_NT] = c + 3;
		p->rule._ea3 = 1;
	}
	if (c + 1 < p->cost[_ea1_NT]) {
		p->cost[_ea1_NT] = c + 1;
		p->rule._ea1 = 1;
	}
	if (c + 0 < p->cost[_ea0_NT]) {
		p->cost[_ea0_NT] = c + 0;
		p->rule._ea0 = 1;
	}
}

static void _closure_ri(a, c) NODEPTR_TYPE a; int c; {
	struct _state *p = STATE_LABEL(a);
	if (c + 1 < p->cost[_reg_NT]) {
		p->cost[_reg_NT] = c + 1;
		p->rule._reg = 10;
		_closure_reg(a, c + 1);
	}
	if (c + 0 < p->cost[_ea3_NT]) {
		p->cost[_ea3_NT] = c + 0;
		p->rule._ea3 = 2;
	}
	if (c + 0 < p->cost[_ea1_NT]) {
		p->cost[_ea1_NT] = c + 0;
		p->rule._ea1 = 2;
	}
	if (c + 0 < p->cost[_ea0_NT]) {
		p->cost[_ea0_NT] = c + 0;
		p->rule._ea0 = 2;
	}
}

static void _label(a) NODEPTR_TYPE a; {
	int c;
	struct _state *p;

	if (!a)
		fatal("_label", "Null tree\n", 0);
	STATE_LABEL(a) = p = allocate(sizeof *p, FUNC);
	p->rule._stmt = 0;
	p->cost[1] =
	p->cost[2] =
	p->cost[3] =
	p->cost[4] =
	p->cost[5] =
	p->cost[6] =
	p->cost[7] =
	p->cost[8] =
	p->cost[9] =
	p->cost[10] =
	p->cost[11] =
	p->cost[12] =
	p->cost[13] =
	p->cost[14] =
	p->cost[15] =
	p->cost[16] =
	p->cost[17] =
	p->cost[18] =
	p->cost[19] =
	p->cost[20] =
	p->cost[21] =
	p->cost[22] =
	p->cost[23] =
		0x7fff;
	switch (OP_LABEL(a)) {
	case 17: /* CNSTF */
		break;
	case 18: /* CNSTD */
		break;
	case 19: /* CNSTC */
		/* con: CNSTC */
		if (0 + 0 < p->cost[_con_NT]) {
			p->cost[_con_NT] = 0 + 0;
			p->rule._con = 1;
			_closure_con(a, 0 + 0);
		}
		break;
	case 20: /* CNSTS */
		/* con: CNSTS */
		if (0 + 0 < p->cost[_con_NT]) {
			p->cost[_con_NT] = 0 + 0;
			p->rule._con = 4;
			_closure_con(a, 0 + 0);
		}
		break;
	case 21: /* CNSTI */
		/* con: CNSTI */
		if (0 + 0 < p->cost[_con_NT]) {
			p->cost[_con_NT] = 0 + 0;
			p->rule._con = 2;
			_closure_con(a, 0 + 0);
		}
		/* disp16: CNSTI */
		c = (range(a, -32768, 32767));
		if (c + 0 < p->cost[_disp16_NT]) {
			p->cost[_disp16_NT] = c + 0;
			p->rule._disp16 = 1;
		}
		/* disp8: CNSTI */
		c = (range(a, -128, 127));
		if (c + 0 < p->cost[_disp8_NT]) {
			p->cost[_disp8_NT] = c + 0;
			p->rule._disp8 = 1;
		}
		/* con0: CNSTI */
		c = (range(a, 0, 0));
		if (c + 0 < p->cost[_con0_NT]) {
			p->cost[_con0_NT] = c + 0;
			p->rule._con0 = 1;
		}
		/* con3: CNSTI */
		c = (range(a, 1, 8));
		if (c + 0 < p->cost[_con3_NT]) {
			p->cost[_con3_NT] = c + 0;
			p->rule._con3 = 1;
			_closure_con3(a, c + 0);
		}
		/* scf: CNSTI */
		c = (range(a, 1, 1));
		if (c + 0 < p->cost[_scf_NT]) {
			p->cost[_scf_NT] = c + 0;
			p->rule._scf = 1;
		}
		/* scf: CNSTI */
		c = (range(a, 2, 2));
		if (c + 0 < p->cost[_scf_NT]) {
			p->cost[_scf_NT] = c + 0;
			p->rule._scf = 2;
		}
		/* scf: CNSTI */
		c = (range(a, 3, 3));
		if (c + 0 < p->cost[_scf_NT]) {
			p->cost[_scf_NT] = c + 0;
			p->rule._scf = 3;
		}
		break;
	case 22: /* CNSTU */
		/* con: CNSTU */
		if (0 + 0 < p->cost[_con_NT]) {
			p->cost[_con_NT] = 0 + 0;
			p->rule._con = 5;
			_closure_con(a, 0 + 0);
		}
		/* con0: CNSTU */
		c = (range(a, 0, 0));
		if (c + 0 < p->cost[_con0_NT]) {
			p->cost[_con0_NT] = c + 0;
			p->rule._con0 = 3;
		}
		break;
	case 23: /* CNSTP */
		/* con: CNSTP */
		if (0 + 0 < p->cost[_con_NT]) {
			p->cost[_con_NT] = 0 + 0;
			p->rule._con = 3;
			_closure_con(a, 0 + 0);
		}
		/* con0: CNSTP */
		c = (range(a, 0, 0));
		if (c + 0 < p->cost[_con0_NT]) {
			p->cost[_con0_NT] = c + 0;
			p->rule._con0 = 2;
		}
		/* con3: CNSTP */
		c = (range(a, 1, 8));
		if (c + 0 < p->cost[_con3_NT]) {
			p->cost[_con3_NT] = c + 0;
			p->rule._con3 = 2;
			_closure_con3(a, c + 0);
		}
		break;
	case 33: /* ARGF */
		_label(LEFT_CHILD(a));
		/* stmt: ARGF(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 38;
		}
		break;
	case 34: /* ARGD */
		_label(LEFT_CHILD(a));
		/* stmt: ARGD(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 37;
		}
		break;
	case 37: /* ARGI */
		_label(LEFT_CHILD(a));
		/* stmt: ARGI(ea0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_ea0_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 27;
		}
		/* stmt: ARGI(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 28;
		}
		break;
	case 39: /* ARGP */
		_label(LEFT_CHILD(a));
		/* stmt: ARGP(ea0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_ea0_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 29;
		}
		/* stmt: ARGP(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 30;
		}
		break;
	case 41: /* ARGB */
		_label(LEFT_CHILD(a));
		if (	/* stmt: ARGB(INDIRB(reg)) */
			LEFT_CHILD(a)->op == 73 /* INDIRB */
		) {
			c = ((struct _state *)(LEFT_CHILD(LEFT_CHILD(a))->x.state))->cost[_reg_NT] + 2;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 32;
			}
		}
		break;
	case 49: /* ASGNF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		if (	/* stmt: ASGNF(VREGP,reg) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			c = ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 3;
			}
		}
		/* stmt: ASGNF(addr,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 4;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 35;
		}
		/* stmt: ASGNF(addr,mem) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_mem_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 36;
		}
		break;
	case 50: /* ASGND */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		if (	/* stmt: ASGND(VREGP,reg) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			c = ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 2;
			}
		}
		if (	/* stmt: ASGND(VREGP,reg) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			c = ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 5;
			}
		}
		/* stmt: ASGND(addr,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 4;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 33;
		}
		/* stmt: ASGND(addr,mem) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_mem_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 34;
		}
		break;
	case 51: /* ASGNC */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		if (	/* stmt: ASGNC(VREGP,reg) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			c = ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 1;
			}
		}
		/* stmt: ASGNC(addr,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 18;
		}
		/* stmt: ASGNC(addr,con0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con0_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 19;
		}
		break;
	case 52: /* ASGNS */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		if (	/* stmt: ASGNS(VREGP,reg) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			c = ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 7;
			}
		}
		/* stmt: ASGNS(addr,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 25;
		}
		/* stmt: ASGNS(addr,con0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con0_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 26;
		}
		break;
	case 53: /* ASGNI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		if (	/* stmt: ASGNI(VREGP,reg) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			c = ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 4;
			}
		}
		if (	/* stmt: ASGNI(addr,ADDI(mem,ri)) */
			RIGHT_CHILD(a)->op == 309 /* ADDI */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + ((struct _state *)(RIGHT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_ri_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 9;
			}
		}
		if (	/* stmt: ASGNI(addr,ADDU(mem,ri)) */
			RIGHT_CHILD(a)->op == 310 /* ADDU */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + ((struct _state *)(RIGHT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_ri_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 10;
			}
		}
		if (	/* stmt: ASGNI(addr,SUBI(mem,ri)) */
			RIGHT_CHILD(a)->op == 325 /* SUBI */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + ((struct _state *)(RIGHT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_ri_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 11;
			}
		}
		if (	/* stmt: ASGNI(addr,SUBU(mem,ri)) */
			RIGHT_CHILD(a)->op == 326 /* SUBU */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + ((struct _state *)(RIGHT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_ri_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 12;
			}
		}
		if (	/* stmt: ASGNI(addr,BANDU(mem,ri)) */
			RIGHT_CHILD(a)->op == 390 /* BANDU */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + ((struct _state *)(RIGHT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_ri_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 13;
			}
		}
		if (	/* stmt: ASGNI(addr,BORU(mem,ri)) */
			RIGHT_CHILD(a)->op == 422 /* BORU */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + ((struct _state *)(RIGHT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_ri_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 14;
			}
		}
		if (	/* stmt: ASGNI(addr,BXORU(mem,reg)) */
			RIGHT_CHILD(a)->op == 438 /* BXORU */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + ((struct _state *)(RIGHT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_reg_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 15;
			}
		}
		if (	/* stmt: ASGNI(addr,BCOMU(mem)) */
			RIGHT_CHILD(a)->op == 406 /* BCOMU */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 16;
			}
		}
		if (	/* stmt: ASGNI(addr,NEGI(mem)) */
			RIGHT_CHILD(a)->op == 197 /* NEGI */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_mem_NT] + (memop(a));
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 17;
			}
		}
		/* stmt: ASGNI(addr,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 20;
		}
		/* stmt: ASGNI(addr,con0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con0_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 21;
		}
		if (	/* stmt: ASGNI(addr,CVDI(reg)) */
			RIGHT_CHILD(a)->op == 101 /* CVDI */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 22;
			}
		}
		break;
	case 54: /* ASGNU */
		break;
	case 55: /* ASGNP */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		if (	/* stmt: ASGNP(VREGP,reg) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			c = ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 6;
			}
		}
		/* stmt: ASGNP(addr,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 23;
		}
		/* stmt: ASGNP(addr,con0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con0_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 24;
		}
		break;
	case 57: /* ASGNB */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		if (	/* stmt: ASGNB(reg,INDIRB(reg)) */
			RIGHT_CHILD(a)->op == 73 /* INDIRB */
		) {
			c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(LEFT_CHILD(RIGHT_CHILD(a))->x.state))->cost[_reg_NT] + 2;
			if (c + 0 < p->cost[_stmt_NT]) {
				p->cost[_stmt_NT] = c + 0;
				p->rule._stmt = 31;
			}
		}
		break;
	case 65: /* INDIRF */
		_label(LEFT_CHILD(a));
		if (	/* reg: INDIRF(VREGP) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			if (mayrecalc(a)) {
				struct _state *q = a->syms[RX]->u.t.cse->x.state;
				if (q->cost[_stmt_NT] == 0) {
					p->cost[_stmt_NT] = 0;
					p->rule._stmt = q->rule._stmt;
				}
				if (q->cost[_reg_NT] == 0) {
					p->cost[_reg_NT] = 0;
					p->rule._reg = q->rule._reg;
				}
				if (q->cost[_con_NT] == 0) {
					p->cost[_con_NT] = 0;
					p->rule._con = q->rule._con;
				}
				if (q->cost[_disp16_NT] == 0) {
					p->cost[_disp16_NT] = 0;
					p->rule._disp16 = q->rule._disp16;
				}
				if (q->cost[_disp8_NT] == 0) {
					p->cost[_disp8_NT] = 0;
					p->rule._disp8 = q->rule._disp8;
				}
				if (q->cost[_base_NT] == 0) {
					p->cost[_base_NT] = 0;
					p->rule._base = q->rule._base;
				}
				if (q->cost[_basei_NT] == 0) {
					p->cost[_basei_NT] = 0;
					p->rule._basei = q->rule._basei;
				}
				if (q->cost[_addr_NT] == 0) {
					p->cost[_addr_NT] = 0;
					p->rule._addr = q->rule._addr;
				}
				if (q->cost[_acon_NT] == 0) {
					p->cost[_acon_NT] = 0;
					p->rule._acon = q->rule._acon;
				}
				if (q->cost[_table_NT] == 0) {
					p->cost[_table_NT] = 0;
					p->rule._table = q->rule._table;
				}
				if (q->cost[_index_NT] == 0) {
					p->cost[_index_NT] = 0;
					p->rule._index = q->rule._index;
				}
				if (q->cost[_scf_NT] == 0) {
					p->cost[_scf_NT] = 0;
					p->rule._scf = q->rule._scf;
				}
				if (q->cost[_case_NT] == 0) {
					p->cost[_case_NT] = 0;
					p->rule._case = q->rule._case;
				}
				if (q->cost[_avar_NT] == 0) {
					p->cost[_avar_NT] = 0;
					p->rule._avar = q->rule._avar;
				}
				if (q->cost[_con0_NT] == 0) {
					p->cost[_con0_NT] = 0;
					p->rule._con0 = q->rule._con0;
				}
				if (q->cost[_con3_NT] == 0) {
					p->cost[_con3_NT] = 0;
					p->rule._con3 = q->rule._con3;
				}
				if (q->cost[_mem_NT] == 0) {
					p->cost[_mem_NT] = 0;
					p->rule._mem = q->rule._mem;
				}
				if (q->cost[_pcrel_NT] == 0) {
					p->cost[_pcrel_NT] = 0;
					p->rule._pcrel = q->rule._pcrel;
				}
				if (q->cost[_ri_NT] == 0) {
					p->cost[_ri_NT] = 0;
					p->rule._ri = q->rule._ri;
				}
				if (q->cost[_ri3_NT] == 0) {
					p->cost[_ri3_NT] = 0;
					p->rule._ri3 = q->rule._ri3;
				}
				if (q->cost[_ea0_NT] == 0) {
					p->cost[_ea0_NT] = 0;
					p->rule._ea0 = q->rule._ea0;
				}
				if (q->cost[_ea1_NT] == 0) {
					p->cost[_ea1_NT] = 0;
					p->rule._ea1 = q->rule._ea1;
				}
				if (q->cost[_ea3_NT] == 0) {
					p->cost[_ea3_NT] = 0;
					p->rule._ea3 = q->rule._ea3;
				}
			}
			c = 0;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 3;
				_closure_reg(a, c + 0);
			}
		}
		/* reg: INDIRF(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 3;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 72;
			_closure_reg(a, c + 0);
		}
		/* mem: INDIRF(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 0;
		if (c + 0 < p->cost[_mem_NT]) {
			p->cost[_mem_NT] = c + 0;
			p->rule._mem = 4;
			_closure_mem(a, c + 0);
		}
		break;
	case 66: /* INDIRD */
		_label(LEFT_CHILD(a));
		if (	/* reg: INDIRD(VREGP) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			if (mayrecalc(a)) {
				struct _state *q = a->syms[RX]->u.t.cse->x.state;
				if (q->cost[_stmt_NT] == 0) {
					p->cost[_stmt_NT] = 0;
					p->rule._stmt = q->rule._stmt;
				}
				if (q->cost[_reg_NT] == 0) {
					p->cost[_reg_NT] = 0;
					p->rule._reg = q->rule._reg;
				}
				if (q->cost[_con_NT] == 0) {
					p->cost[_con_NT] = 0;
					p->rule._con = q->rule._con;
				}
				if (q->cost[_disp16_NT] == 0) {
					p->cost[_disp16_NT] = 0;
					p->rule._disp16 = q->rule._disp16;
				}
				if (q->cost[_disp8_NT] == 0) {
					p->cost[_disp8_NT] = 0;
					p->rule._disp8 = q->rule._disp8;
				}
				if (q->cost[_base_NT] == 0) {
					p->cost[_base_NT] = 0;
					p->rule._base = q->rule._base;
				}
				if (q->cost[_basei_NT] == 0) {
					p->cost[_basei_NT] = 0;
					p->rule._basei = q->rule._basei;
				}
				if (q->cost[_addr_NT] == 0) {
					p->cost[_addr_NT] = 0;
					p->rule._addr = q->rule._addr;
				}
				if (q->cost[_acon_NT] == 0) {
					p->cost[_acon_NT] = 0;
					p->rule._acon = q->rule._acon;
				}
				if (q->cost[_table_NT] == 0) {
					p->cost[_table_NT] = 0;
					p->rule._table = q->rule._table;
				}
				if (q->cost[_index_NT] == 0) {
					p->cost[_index_NT] = 0;
					p->rule._index = q->rule._index;
				}
				if (q->cost[_scf_NT] == 0) {
					p->cost[_scf_NT] = 0;
					p->rule._scf = q->rule._scf;
				}
				if (q->cost[_case_NT] == 0) {
					p->cost[_case_NT] = 0;
					p->rule._case = q->rule._case;
				}
				if (q->cost[_avar_NT] == 0) {
					p->cost[_avar_NT] = 0;
					p->rule._avar = q->rule._avar;
				}
				if (q->cost[_con0_NT] == 0) {
					p->cost[_con0_NT] = 0;
					p->rule._con0 = q->rule._con0;
				}
				if (q->cost[_con3_NT] == 0) {
					p->cost[_con3_NT] = 0;
					p->rule._con3 = q->rule._con3;
				}
				if (q->cost[_mem_NT] == 0) {
					p->cost[_mem_NT] = 0;
					p->rule._mem = q->rule._mem;
				}
				if (q->cost[_pcrel_NT] == 0) {
					p->cost[_pcrel_NT] = 0;
					p->rule._pcrel = q->rule._pcrel;
				}
				if (q->cost[_ri_NT] == 0) {
					p->cost[_ri_NT] = 0;
					p->rule._ri = q->rule._ri;
				}
				if (q->cost[_ri3_NT] == 0) {
					p->cost[_ri3_NT] = 0;
					p->rule._ri3 = q->rule._ri3;
				}
				if (q->cost[_ea0_NT] == 0) {
					p->cost[_ea0_NT] = 0;
					p->rule._ea0 = q->rule._ea0;
				}
				if (q->cost[_ea1_NT] == 0) {
					p->cost[_ea1_NT] = 0;
					p->rule._ea1 = q->rule._ea1;
				}
				if (q->cost[_ea3_NT] == 0) {
					p->cost[_ea3_NT] = 0;
					p->rule._ea3 = q->rule._ea3;
				}
			}
			c = 0;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 2;
				_closure_reg(a, c + 0);
			}
		}
		/* reg: INDIRD(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 3;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 71;
			_closure_reg(a, c + 0);
		}
		/* mem: INDIRD(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 0;
		if (c + 0 < p->cost[_mem_NT]) {
			p->cost[_mem_NT] = c + 0;
			p->rule._mem = 3;
			_closure_mem(a, c + 0);
		}
		break;
	case 67: /* INDIRC */
		_label(LEFT_CHILD(a));
		if (	/* reg: INDIRC(VREGP) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			if (mayrecalc(a)) {
				struct _state *q = a->syms[RX]->u.t.cse->x.state;
				if (q->cost[_stmt_NT] == 0) {
					p->cost[_stmt_NT] = 0;
					p->rule._stmt = q->rule._stmt;
				}
				if (q->cost[_reg_NT] == 0) {
					p->cost[_reg_NT] = 0;
					p->rule._reg = q->rule._reg;
				}
				if (q->cost[_con_NT] == 0) {
					p->cost[_con_NT] = 0;
					p->rule._con = q->rule._con;
				}
				if (q->cost[_disp16_NT] == 0) {
					p->cost[_disp16_NT] = 0;
					p->rule._disp16 = q->rule._disp16;
				}
				if (q->cost[_disp8_NT] == 0) {
					p->cost[_disp8_NT] = 0;
					p->rule._disp8 = q->rule._disp8;
				}
				if (q->cost[_base_NT] == 0) {
					p->cost[_base_NT] = 0;
					p->rule._base = q->rule._base;
				}
				if (q->cost[_basei_NT] == 0) {
					p->cost[_basei_NT] = 0;
					p->rule._basei = q->rule._basei;
				}
				if (q->cost[_addr_NT] == 0) {
					p->cost[_addr_NT] = 0;
					p->rule._addr = q->rule._addr;
				}
				if (q->cost[_acon_NT] == 0) {
					p->cost[_acon_NT] = 0;
					p->rule._acon = q->rule._acon;
				}
				if (q->cost[_table_NT] == 0) {
					p->cost[_table_NT] = 0;
					p->rule._table = q->rule._table;
				}
				if (q->cost[_index_NT] == 0) {
					p->cost[_index_NT] = 0;
					p->rule._index = q->rule._index;
				}
				if (q->cost[_scf_NT] == 0) {
					p->cost[_scf_NT] = 0;
					p->rule._scf = q->rule._scf;
				}
				if (q->cost[_case_NT] == 0) {
					p->cost[_case_NT] = 0;
					p->rule._case = q->rule._case;
				}
				if (q->cost[_avar_NT] == 0) {
					p->cost[_avar_NT] = 0;
					p->rule._avar = q->rule._avar;
				}
				if (q->cost[_con0_NT] == 0) {
					p->cost[_con0_NT] = 0;
					p->rule._con0 = q->rule._con0;
				}
				if (q->cost[_con3_NT] == 0) {
					p->cost[_con3_NT] = 0;
					p->rule._con3 = q->rule._con3;
				}
				if (q->cost[_mem_NT] == 0) {
					p->cost[_mem_NT] = 0;
					p->rule._mem = q->rule._mem;
				}
				if (q->cost[_pcrel_NT] == 0) {
					p->cost[_pcrel_NT] = 0;
					p->rule._pcrel = q->rule._pcrel;
				}
				if (q->cost[_ri_NT] == 0) {
					p->cost[_ri_NT] = 0;
					p->rule._ri = q->rule._ri;
				}
				if (q->cost[_ri3_NT] == 0) {
					p->cost[_ri3_NT] = 0;
					p->rule._ri3 = q->rule._ri3;
				}
				if (q->cost[_ea0_NT] == 0) {
					p->cost[_ea0_NT] = 0;
					p->rule._ea0 = q->rule._ea0;
				}
				if (q->cost[_ea1_NT] == 0) {
					p->cost[_ea1_NT] = 0;
					p->rule._ea1 = q->rule._ea1;
				}
				if (q->cost[_ea3_NT] == 0) {
					p->cost[_ea3_NT] = 0;
					p->rule._ea3 = q->rule._ea3;
				}
			}
			c = 0;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 1;
				_closure_reg(a, c + 0);
			}
		}
		/* reg: INDIRC(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 11;
			_closure_reg(a, c + 0);
		}
		break;
	case 68: /* INDIRS */
		_label(LEFT_CHILD(a));
		if (	/* reg: INDIRS(VREGP) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			if (mayrecalc(a)) {
				struct _state *q = a->syms[RX]->u.t.cse->x.state;
				if (q->cost[_stmt_NT] == 0) {
					p->cost[_stmt_NT] = 0;
					p->rule._stmt = q->rule._stmt;
				}
				if (q->cost[_reg_NT] == 0) {
					p->cost[_reg_NT] = 0;
					p->rule._reg = q->rule._reg;
				}
				if (q->cost[_con_NT] == 0) {
					p->cost[_con_NT] = 0;
					p->rule._con = q->rule._con;
				}
				if (q->cost[_disp16_NT] == 0) {
					p->cost[_disp16_NT] = 0;
					p->rule._disp16 = q->rule._disp16;
				}
				if (q->cost[_disp8_NT] == 0) {
					p->cost[_disp8_NT] = 0;
					p->rule._disp8 = q->rule._disp8;
				}
				if (q->cost[_base_NT] == 0) {
					p->cost[_base_NT] = 0;
					p->rule._base = q->rule._base;
				}
				if (q->cost[_basei_NT] == 0) {
					p->cost[_basei_NT] = 0;
					p->rule._basei = q->rule._basei;
				}
				if (q->cost[_addr_NT] == 0) {
					p->cost[_addr_NT] = 0;
					p->rule._addr = q->rule._addr;
				}
				if (q->cost[_acon_NT] == 0) {
					p->cost[_acon_NT] = 0;
					p->rule._acon = q->rule._acon;
				}
				if (q->cost[_table_NT] == 0) {
					p->cost[_table_NT] = 0;
					p->rule._table = q->rule._table;
				}
				if (q->cost[_index_NT] == 0) {
					p->cost[_index_NT] = 0;
					p->rule._index = q->rule._index;
				}
				if (q->cost[_scf_NT] == 0) {
					p->cost[_scf_NT] = 0;
					p->rule._scf = q->rule._scf;
				}
				if (q->cost[_case_NT] == 0) {
					p->cost[_case_NT] = 0;
					p->rule._case = q->rule._case;
				}
				if (q->cost[_avar_NT] == 0) {
					p->cost[_avar_NT] = 0;
					p->rule._avar = q->rule._avar;
				}
				if (q->cost[_con0_NT] == 0) {
					p->cost[_con0_NT] = 0;
					p->rule._con0 = q->rule._con0;
				}
				if (q->cost[_con3_NT] == 0) {
					p->cost[_con3_NT] = 0;
					p->rule._con3 = q->rule._con3;
				}
				if (q->cost[_mem_NT] == 0) {
					p->cost[_mem_NT] = 0;
					p->rule._mem = q->rule._mem;
				}
				if (q->cost[_pcrel_NT] == 0) {
					p->cost[_pcrel_NT] = 0;
					p->rule._pcrel = q->rule._pcrel;
				}
				if (q->cost[_ri_NT] == 0) {
					p->cost[_ri_NT] = 0;
					p->rule._ri = q->rule._ri;
				}
				if (q->cost[_ri3_NT] == 0) {
					p->cost[_ri3_NT] = 0;
					p->rule._ri3 = q->rule._ri3;
				}
				if (q->cost[_ea0_NT] == 0) {
					p->cost[_ea0_NT] = 0;
					p->rule._ea0 = q->rule._ea0;
				}
				if (q->cost[_ea1_NT] == 0) {
					p->cost[_ea1_NT] = 0;
					p->rule._ea1 = q->rule._ea1;
				}
				if (q->cost[_ea3_NT] == 0) {
					p->cost[_ea3_NT] = 0;
					p->rule._ea3 = q->rule._ea3;
				}
			}
			c = 0;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 6;
				_closure_reg(a, c + 0);
			}
		}
		/* reg: INDIRS(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 14;
			_closure_reg(a, c + 0);
		}
		break;
	case 69: /* INDIRI */
		_label(LEFT_CHILD(a));
		if (	/* reg: INDIRI(VREGP) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			if (mayrecalc(a)) {
				struct _state *q = a->syms[RX]->u.t.cse->x.state;
				if (q->cost[_stmt_NT] == 0) {
					p->cost[_stmt_NT] = 0;
					p->rule._stmt = q->rule._stmt;
				}
				if (q->cost[_reg_NT] == 0) {
					p->cost[_reg_NT] = 0;
					p->rule._reg = q->rule._reg;
				}
				if (q->cost[_con_NT] == 0) {
					p->cost[_con_NT] = 0;
					p->rule._con = q->rule._con;
				}
				if (q->cost[_disp16_NT] == 0) {
					p->cost[_disp16_NT] = 0;
					p->rule._disp16 = q->rule._disp16;
				}
				if (q->cost[_disp8_NT] == 0) {
					p->cost[_disp8_NT] = 0;
					p->rule._disp8 = q->rule._disp8;
				}
				if (q->cost[_base_NT] == 0) {
					p->cost[_base_NT] = 0;
					p->rule._base = q->rule._base;
				}
				if (q->cost[_basei_NT] == 0) {
					p->cost[_basei_NT] = 0;
					p->rule._basei = q->rule._basei;
				}
				if (q->cost[_addr_NT] == 0) {
					p->cost[_addr_NT] = 0;
					p->rule._addr = q->rule._addr;
				}
				if (q->cost[_acon_NT] == 0) {
					p->cost[_acon_NT] = 0;
					p->rule._acon = q->rule._acon;
				}
				if (q->cost[_table_NT] == 0) {
					p->cost[_table_NT] = 0;
					p->rule._table = q->rule._table;
				}
				if (q->cost[_index_NT] == 0) {
					p->cost[_index_NT] = 0;
					p->rule._index = q->rule._index;
				}
				if (q->cost[_scf_NT] == 0) {
					p->cost[_scf_NT] = 0;
					p->rule._scf = q->rule._scf;
				}
				if (q->cost[_case_NT] == 0) {
					p->cost[_case_NT] = 0;
					p->rule._case = q->rule._case;
				}
				if (q->cost[_avar_NT] == 0) {
					p->cost[_avar_NT] = 0;
					p->rule._avar = q->rule._avar;
				}
				if (q->cost[_con0_NT] == 0) {
					p->cost[_con0_NT] = 0;
					p->rule._con0 = q->rule._con0;
				}
				if (q->cost[_con3_NT] == 0) {
					p->cost[_con3_NT] = 0;
					p->rule._con3 = q->rule._con3;
				}
				if (q->cost[_mem_NT] == 0) {
					p->cost[_mem_NT] = 0;
					p->rule._mem = q->rule._mem;
				}
				if (q->cost[_pcrel_NT] == 0) {
					p->cost[_pcrel_NT] = 0;
					p->rule._pcrel = q->rule._pcrel;
				}
				if (q->cost[_ri_NT] == 0) {
					p->cost[_ri_NT] = 0;
					p->rule._ri = q->rule._ri;
				}
				if (q->cost[_ri3_NT] == 0) {
					p->cost[_ri3_NT] = 0;
					p->rule._ri3 = q->rule._ri3;
				}
				if (q->cost[_ea0_NT] == 0) {
					p->cost[_ea0_NT] = 0;
					p->rule._ea0 = q->rule._ea0;
				}
				if (q->cost[_ea1_NT] == 0) {
					p->cost[_ea1_NT] = 0;
					p->rule._ea1 = q->rule._ea1;
				}
				if (q->cost[_ea3_NT] == 0) {
					p->cost[_ea3_NT] = 0;
					p->rule._ea3 = q->rule._ea3;
				}
			}
			c = 0;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 4;
				_closure_reg(a, c + 0);
			}
		}
		/* mem: INDIRI(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 0;
		if (c + 0 < p->cost[_mem_NT]) {
			p->cost[_mem_NT] = c + 0;
			p->rule._mem = 1;
			_closure_mem(a, c + 0);
		}
		/* reg: INDIRI(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 12;
			_closure_reg(a, c + 0);
		}
		break;
	case 71: /* INDIRP */
		_label(LEFT_CHILD(a));
		if (	/* reg: INDIRP(VREGP) */
			LEFT_CHILD(a)->op == 615 /* VREGP */
		) {
			if (mayrecalc(a)) {
				struct _state *q = a->syms[RX]->u.t.cse->x.state;
				if (q->cost[_stmt_NT] == 0) {
					p->cost[_stmt_NT] = 0;
					p->rule._stmt = q->rule._stmt;
				}
				if (q->cost[_reg_NT] == 0) {
					p->cost[_reg_NT] = 0;
					p->rule._reg = q->rule._reg;
				}
				if (q->cost[_con_NT] == 0) {
					p->cost[_con_NT] = 0;
					p->rule._con = q->rule._con;
				}
				if (q->cost[_disp16_NT] == 0) {
					p->cost[_disp16_NT] = 0;
					p->rule._disp16 = q->rule._disp16;
				}
				if (q->cost[_disp8_NT] == 0) {
					p->cost[_disp8_NT] = 0;
					p->rule._disp8 = q->rule._disp8;
				}
				if (q->cost[_base_NT] == 0) {
					p->cost[_base_NT] = 0;
					p->rule._base = q->rule._base;
				}
				if (q->cost[_basei_NT] == 0) {
					p->cost[_basei_NT] = 0;
					p->rule._basei = q->rule._basei;
				}
				if (q->cost[_addr_NT] == 0) {
					p->cost[_addr_NT] = 0;
					p->rule._addr = q->rule._addr;
				}
				if (q->cost[_acon_NT] == 0) {
					p->cost[_acon_NT] = 0;
					p->rule._acon = q->rule._acon;
				}
				if (q->cost[_table_NT] == 0) {
					p->cost[_table_NT] = 0;
					p->rule._table = q->rule._table;
				}
				if (q->cost[_index_NT] == 0) {
					p->cost[_index_NT] = 0;
					p->rule._index = q->rule._index;
				}
				if (q->cost[_scf_NT] == 0) {
					p->cost[_scf_NT] = 0;
					p->rule._scf = q->rule._scf;
				}
				if (q->cost[_case_NT] == 0) {
					p->cost[_case_NT] = 0;
					p->rule._case = q->rule._case;
				}
				if (q->cost[_avar_NT] == 0) {
					p->cost[_avar_NT] = 0;
					p->rule._avar = q->rule._avar;
				}
				if (q->cost[_con0_NT] == 0) {
					p->cost[_con0_NT] = 0;
					p->rule._con0 = q->rule._con0;
				}
				if (q->cost[_con3_NT] == 0) {
					p->cost[_con3_NT] = 0;
					p->rule._con3 = q->rule._con3;
				}
				if (q->cost[_mem_NT] == 0) {
					p->cost[_mem_NT] = 0;
					p->rule._mem = q->rule._mem;
				}
				if (q->cost[_pcrel_NT] == 0) {
					p->cost[_pcrel_NT] = 0;
					p->rule._pcrel = q->rule._pcrel;
				}
				if (q->cost[_ri_NT] == 0) {
					p->cost[_ri_NT] = 0;
					p->rule._ri = q->rule._ri;
				}
				if (q->cost[_ri3_NT] == 0) {
					p->cost[_ri3_NT] = 0;
					p->rule._ri3 = q->rule._ri3;
				}
				if (q->cost[_ea0_NT] == 0) {
					p->cost[_ea0_NT] = 0;
					p->rule._ea0 = q->rule._ea0;
				}
				if (q->cost[_ea1_NT] == 0) {
					p->cost[_ea1_NT] = 0;
					p->rule._ea1 = q->rule._ea1;
				}
				if (q->cost[_ea3_NT] == 0) {
					p->cost[_ea3_NT] = 0;
					p->rule._ea3 = q->rule._ea3;
				}
			}
			c = 0;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 5;
				_closure_reg(a, c + 0);
			}
		}
		/* mem: INDIRP(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 0;
		if (c + 0 < p->cost[_mem_NT]) {
			p->cost[_mem_NT] = c + 0;
			p->rule._mem = 2;
			_closure_mem(a, c + 0);
		}
		/* pcrel: INDIRP(case) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_case_NT] + 0;
		if (c + 0 < p->cost[_pcrel_NT]) {
			p->cost[_pcrel_NT] = c + 0;
			p->rule._pcrel = 1;
		}
		/* reg: INDIRP(addr) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_addr_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 13;
			_closure_reg(a, c + 0);
		}
		break;
	case 73: /* INDIRB */
		_label(LEFT_CHILD(a));
		break;
	case 85: /* CVCI */
		_label(LEFT_CHILD(a));
		/* reg: CVCI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 2;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 43;
			_closure_reg(a, c + 0);
		}
		if (	/* reg: CVCI(INDIRC(addr)) */
			LEFT_CHILD(a)->op == 67 /* INDIRC */
		) {
			c = ((struct _state *)(LEFT_CHILD(LEFT_CHILD(a))->x.state))->cost[_addr_NT] + 2;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 47;
				_closure_reg(a, c + 0);
			}
		}
		break;
	case 86: /* CVCU */
		_label(LEFT_CHILD(a));
		/* reg: CVCU(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 3;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 44;
			_closure_reg(a, c + 0);
		}
		if (	/* reg: CVCU(INDIRC(addr)) */
			LEFT_CHILD(a)->op == 67 /* INDIRC */
		) {
			c = ((struct _state *)(LEFT_CHILD(LEFT_CHILD(a))->x.state))->cost[_addr_NT] + 2;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 48;
				_closure_reg(a, c + 0);
			}
		}
		break;
	case 97: /* CVDF */
		_label(LEFT_CHILD(a));
		/* reg: CVDF(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 63;
			_closure_reg(a, c + 0);
		}
		/* reg: CVDF(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 65;
			_closure_reg(a, c + 0);
		}
		break;
	case 101: /* CVDI */
		_label(LEFT_CHILD(a));
		/* reg: CVDI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 68;
			_closure_reg(a, c + 0);
		}
		break;
	case 114: /* CVFD */
		_label(LEFT_CHILD(a));
		/* reg: CVFD(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 64;
			_closure_reg(a, c + 0);
		}
		/* reg: CVFD(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 66;
			_closure_reg(a, c + 0);
		}
		break;
	case 130: /* CVID */
		_label(LEFT_CHILD(a));
		/* reg: CVID(ea0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_ea0_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 67;
			_closure_reg(a, c + 0);
		}
		break;
	case 131: /* CVIC */
		_label(LEFT_CHILD(a));
		/* reg: CVIC(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 51;
			_closure_reg(a, c + 0);
		}
		/* reg: CVIC(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 55;
			_closure_reg(a, c + 0);
		}
		break;
	case 132: /* CVIS */
		_label(LEFT_CHILD(a));
		/* reg: CVIS(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 52;
			_closure_reg(a, c + 0);
		}
		/* reg: CVIS(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 56;
			_closure_reg(a, c + 0);
		}
		break;
	case 134: /* CVIU */
		_label(LEFT_CHILD(a));
		/* reg: CVIU(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 7;
			_closure_reg(a, c + 0);
		}
		/* reg: CVIU(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 57;
			_closure_reg(a, c + 0);
		}
		break;
	case 150: /* CVPU */
		_label(LEFT_CHILD(a));
		/* reg: CVPU(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 58;
			_closure_reg(a, c + 0);
		}
		break;
	case 165: /* CVSI */
		_label(LEFT_CHILD(a));
		/* reg: CVSI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 45;
			_closure_reg(a, c + 0);
		}
		if (	/* reg: CVSI(INDIRS(addr)) */
			LEFT_CHILD(a)->op == 68 /* INDIRS */
		) {
			c = ((struct _state *)(LEFT_CHILD(LEFT_CHILD(a))->x.state))->cost[_addr_NT] + 2;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 49;
				_closure_reg(a, c + 0);
			}
		}
		break;
	case 166: /* CVSU */
		_label(LEFT_CHILD(a));
		/* reg: CVSU(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 3;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 46;
			_closure_reg(a, c + 0);
		}
		if (	/* reg: CVSU(INDIRS(addr)) */
			LEFT_CHILD(a)->op == 68 /* INDIRS */
		) {
			c = ((struct _state *)(LEFT_CHILD(LEFT_CHILD(a))->x.state))->cost[_addr_NT] + 2;
			if (c + 0 < p->cost[_reg_NT]) {
				p->cost[_reg_NT] = c + 0;
				p->rule._reg = 50;
				_closure_reg(a, c + 0);
			}
		}
		break;
	case 179: /* CVUC */
		_label(LEFT_CHILD(a));
		/* reg: CVUC(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 53;
			_closure_reg(a, c + 0);
		}
		/* reg: CVUC(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 59;
			_closure_reg(a, c + 0);
		}
		break;
	case 180: /* CVUS */
		_label(LEFT_CHILD(a));
		/* reg: CVUS(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 54;
			_closure_reg(a, c + 0);
		}
		/* reg: CVUS(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 62;
			_closure_reg(a, c + 0);
		}
		break;
	case 181: /* CVUI */
		_label(LEFT_CHILD(a));
		/* reg: CVUI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (notarget(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 8;
			_closure_reg(a, c + 0);
		}
		/* reg: CVUI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 60;
			_closure_reg(a, c + 0);
		}
		break;
	case 183: /* CVUP */
		_label(LEFT_CHILD(a));
		/* reg: CVUP(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 61;
			_closure_reg(a, c + 0);
		}
		break;
	case 193: /* NEGF */
		_label(LEFT_CHILD(a));
		/* reg: NEGF(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 82;
			_closure_reg(a, c + 0);
		}
		break;
	case 194: /* NEGD */
		_label(LEFT_CHILD(a));
		/* reg: NEGD(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 81;
			_closure_reg(a, c + 0);
		}
		break;
	case 197: /* NEGI */
		_label(LEFT_CHILD(a));
		/* reg: NEGI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 32;
			_closure_reg(a, c + 0);
		}
		break;
	case 209: /* CALLF */
		_label(LEFT_CHILD(a));
		/* reg: CALLF(avar) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_avar_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 84;
			_closure_reg(a, c + 0);
		}
		break;
	case 210: /* CALLD */
		_label(LEFT_CHILD(a));
		/* reg: CALLD(avar) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_avar_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 85;
			_closure_reg(a, c + 0);
		}
		break;
	case 213: /* CALLI */
		_label(LEFT_CHILD(a));
		/* reg: CALLI(avar) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_avar_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 83;
			_closure_reg(a, c + 0);
		}
		break;
	case 216: /* CALLV */
		_label(LEFT_CHILD(a));
		/* stmt: CALLV(avar) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_avar_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 66;
		}
		break;
	case 217: /* CALLB */
		break;
	case 225: /* LOADF */
		_label(LEFT_CHILD(a));
		/* reg: LOADF(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 70;
			_closure_reg(a, c + 0);
		}
		break;
	case 226: /* LOADD */
		_label(LEFT_CHILD(a));
		/* reg: LOADD(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 69;
			_closure_reg(a, c + 0);
		}
		break;
	case 227: /* LOADC */
		_label(LEFT_CHILD(a));
		/* reg: LOADC(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 15;
			_closure_reg(a, c + 0);
		}
		break;
	case 228: /* LOADS */
		_label(LEFT_CHILD(a));
		/* reg: LOADS(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 18;
			_closure_reg(a, c + 0);
		}
		break;
	case 229: /* LOADI */
		_label(LEFT_CHILD(a));
		/* reg: LOADI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 16;
			_closure_reg(a, c + 0);
		}
		break;
	case 230: /* LOADU */
		_label(LEFT_CHILD(a));
		/* reg: LOADU(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 19;
			_closure_reg(a, c + 0);
		}
		break;
	case 231: /* LOADP */
		_label(LEFT_CHILD(a));
		/* reg: LOADP(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + (move(a));
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 17;
			_closure_reg(a, c + 0);
		}
		break;
	case 233: /* LOADB */
		break;
	case 241: /* RETF */
		_label(LEFT_CHILD(a));
		/* stmt: RETF(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 68;
		}
		break;
	case 242: /* RETD */
		_label(LEFT_CHILD(a));
		/* stmt: RETD(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 69;
		}
		break;
	case 245: /* RETI */
		_label(LEFT_CHILD(a));
		/* stmt: RETI(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 67;
		}
		break;
	case 263: /* ADDRGP */
		/* addr: ADDRGP */
		if (0 + 0 < p->cost[_addr_NT]) {
			p->cost[_addr_NT] = 0 + 0;
			p->rule._addr = 1;
			_closure_addr(a, 0 + 0);
		}
		/* acon: ADDRGP */
		if (0 + 0 < p->cost[_acon_NT]) {
			p->cost[_acon_NT] = 0 + 0;
			p->rule._acon = 1;
			_closure_acon(a, 0 + 0);
		}
		/* table: ADDRGP */
		if (0 + 0 < p->cost[_table_NT]) {
			p->cost[_table_NT] = 0 + 0;
			p->rule._table = 1;
		}
		break;
	case 279: /* ADDRFP */
		/* base: ADDRFP */
		c = (range(a, -32768, 32767));
		if (c + 0 < p->cost[_base_NT]) {
			p->cost[_base_NT] = c + 0;
			p->rule._base = 2;
			_closure_base(a, c + 0);
		}
		/* basei: ADDRFP */
		c = (range(a, -128, 127));
		if (c + 0 < p->cost[_basei_NT]) {
			p->cost[_basei_NT] = c + 0;
			p->rule._basei = 3;
			_closure_basei(a, c + 0);
		}
		/* basei: ADDRFP */
		if (1 + 0 < p->cost[_basei_NT]) {
			p->cost[_basei_NT] = 1 + 0;
			p->rule._basei = 5;
			_closure_basei(a, 1 + 0);
		}
		break;
	case 295: /* ADDRLP */
		/* base: ADDRLP */
		c = (range(a, -32768, 32767));
		if (c + 0 < p->cost[_base_NT]) {
			p->cost[_base_NT] = c + 0;
			p->rule._base = 3;
			_closure_base(a, c + 0);
		}
		/* basei: ADDRLP */
		c = (range(a, -128, 127));
		if (c + 0 < p->cost[_basei_NT]) {
			p->cost[_basei_NT] = c + 0;
			p->rule._basei = 4;
			_closure_basei(a, c + 0);
		}
		/* basei: ADDRLP */
		if (1 + 0 < p->cost[_basei_NT]) {
			p->cost[_basei_NT] = 1 + 0;
			p->rule._basei = 6;
			_closure_basei(a, 1 + 0);
		}
		break;
	case 305: /* ADDF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: ADDF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 74;
			_closure_reg(a, c + 0);
		}
		break;
	case 306: /* ADDD */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: ADDD(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 73;
			_closure_reg(a, c + 0);
		}
		break;
	case 307: /* ADDC */
		break;
	case 308: /* ADDS */
		break;
	case 309: /* ADDI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: ADDI(reg,con3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con3_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 20;
			_closure_reg(a, c + 0);
		}
		/* reg: ADDI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 22;
			_closure_reg(a, c + 0);
		}
		break;
	case 310: /* ADDU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: ADDU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 24;
			_closure_reg(a, c + 0);
		}
		break;
	case 311: /* ADDP */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* base: ADDP(reg,disp16) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_disp16_NT] + 0;
		if (c + 0 < p->cost[_base_NT]) {
			p->cost[_base_NT] = c + 0;
			p->rule._base = 1;
			_closure_base(a, c + 0);
		}
		/* basei: ADDP(reg,disp8) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_disp8_NT] + 0;
		if (c + 0 < p->cost[_basei_NT]) {
			p->cost[_basei_NT] = c + 0;
			p->rule._basei = 2;
			_closure_basei(a, c + 0);
		}
		/* addr: ADDP(index,basei) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_index_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_basei_NT] + 0;
		if (c + 0 < p->cost[_addr_NT]) {
			p->cost[_addr_NT] = c + 0;
			p->rule._addr = 3;
			_closure_addr(a, c + 0);
		}
		/* case: ADDP(index,table) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_index_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_table_NT] + 0;
		if (c + 0 < p->cost[_case_NT]) {
			p->cost[_case_NT] = c + 0;
			p->rule._case = 1;
		}
		/* reg: ADDP(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 23;
			_closure_reg(a, c + 0);
		}
		break;
	case 321: /* SUBF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: SUBF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 76;
			_closure_reg(a, c + 0);
		}
		break;
	case 322: /* SUBD */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: SUBD(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 75;
			_closure_reg(a, c + 0);
		}
		break;
	case 323: /* SUBC */
		break;
	case 324: /* SUBS */
		break;
	case 325: /* SUBI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: SUBI(reg,con3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con3_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 21;
			_closure_reg(a, c + 0);
		}
		/* reg: SUBI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 25;
			_closure_reg(a, c + 0);
		}
		break;
	case 326: /* SUBU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: SUBU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 27;
			_closure_reg(a, c + 0);
		}
		break;
	case 327: /* SUBP */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: SUBP(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 26;
			_closure_reg(a, c + 0);
		}
		break;
	case 341: /* LSHI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* index: LSHI(reg,scf) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_scf_NT] + 0;
		if (c + 0 < p->cost[_index_NT]) {
			p->cost[_index_NT] = c + 0;
			p->rule._index = 2;
		}
		/* reg: LSHI(reg,ri3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ri3_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 33;
			_closure_reg(a, c + 0);
		}
		break;
	case 342: /* LSHU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: LSHU(reg,ri3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ri3_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 34;
			_closure_reg(a, c + 0);
		}
		break;
	case 357: /* MODI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: MODI(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 42;
			_closure_reg(a, c + 0);
		}
		break;
	case 358: /* MODU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: MODU(reg,ea3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea3_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 41;
			_closure_reg(a, c + 0);
		}
		break;
	case 373: /* RSHI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: RSHI(reg,ri3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ri3_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 35;
			_closure_reg(a, c + 0);
		}
		break;
	case 374: /* RSHU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: RSHU(reg,ri3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ri3_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 36;
			_closure_reg(a, c + 0);
		}
		break;
	case 390: /* BANDU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: BANDU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 28;
			_closure_reg(a, c + 0);
		}
		break;
	case 406: /* BCOMU */
		_label(LEFT_CHILD(a));
		/* reg: BCOMU(reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 31;
			_closure_reg(a, c + 0);
		}
		break;
	case 422: /* BORU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: BORU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 29;
			_closure_reg(a, c + 0);
		}
		break;
	case 438: /* BXORU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: BXORU(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 1;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 30;
			_closure_reg(a, c + 0);
		}
		break;
	case 449: /* DIVF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: DIVF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 80;
			_closure_reg(a, c + 0);
		}
		break;
	case 450: /* DIVD */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: DIVD(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 79;
			_closure_reg(a, c + 0);
		}
		break;
	case 453: /* DIVI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: DIVI(reg,ea3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea3_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 40;
			_closure_reg(a, c + 0);
		}
		break;
	case 454: /* DIVU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: DIVU(reg,ea3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea3_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 39;
			_closure_reg(a, c + 0);
		}
		break;
	case 465: /* MULF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: MULF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 78;
			_closure_reg(a, c + 0);
		}
		break;
	case 466: /* MULD */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: MULD(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 77;
			_closure_reg(a, c + 0);
		}
		break;
	case 469: /* MULI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: MULI(reg,ea3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea3_NT] + 12;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 37;
			_closure_reg(a, c + 0);
		}
		break;
	case 470: /* MULU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* reg: MULU(reg,ea3) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea3_NT] + 12;
		if (c + 0 < p->cost[_reg_NT]) {
			p->cost[_reg_NT] = c + 0;
			p->rule._reg = 38;
			_closure_reg(a, c + 0);
		}
		break;
	case 481: /* EQF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: EQF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 60;
		}
		break;
	case 482: /* EQD */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: EQD(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 54;
		}
		break;
	case 485: /* EQI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: EQI(ea0,con0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_ea0_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con0_NT] + 2;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 42;
		}
		/* stmt: EQI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 44;
		}
		break;
	case 497: /* GEF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GEF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 61;
		}
		break;
	case 498: /* GED */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GED(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 55;
		}
		break;
	case 501: /* GEI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GEI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 45;
		}
		break;
	case 502: /* GEU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GEU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 50;
		}
		break;
	case 513: /* GTF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GTF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 62;
		}
		break;
	case 514: /* GTD */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GTD(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 56;
		}
		break;
	case 517: /* GTI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GTI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 46;
		}
		break;
	case 518: /* GTU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: GTU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 51;
		}
		break;
	case 529: /* LEF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LEF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 63;
		}
		break;
	case 530: /* LED */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LED(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 57;
		}
		break;
	case 533: /* LEI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LEI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 47;
		}
		break;
	case 534: /* LEU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LEU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 52;
		}
		break;
	case 545: /* LTF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LTF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 64;
		}
		break;
	case 546: /* LTD */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LTD(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 58;
		}
		break;
	case 549: /* LTI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LTI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 48;
		}
		break;
	case 550: /* LTU */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: LTU(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 53;
		}
		break;
	case 561: /* NEF */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: NEF(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 65;
		}
		break;
	case 562: /* NED */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: NED(reg,reg) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_reg_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 59;
		}
		break;
	case 565: /* NEI */
		_label(LEFT_CHILD(a));
		_label(RIGHT_CHILD(a));
		/* stmt: NEI(ea0,con0) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_ea0_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_con0_NT] + 2;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 43;
		}
		/* stmt: NEI(reg,ea1) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_reg_NT] + ((struct _state *)(RIGHT_CHILD(a)->x.state))->cost[_ea1_NT] + 3;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 49;
		}
		break;
	case 584: /* JUMPV */
		_label(LEFT_CHILD(a));
		/* stmt: JUMPV(acon) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_acon_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 39;
		}
		/* stmt: JUMPV(pcrel) */
		c = ((struct _state *)(LEFT_CHILD(a)->x.state))->cost[_pcrel_NT] + 0;
		if (c + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = c + 0;
			p->rule._stmt = 40;
		}
		break;
	case 600: /* LABELV */
		/* stmt: LABELV */
		if (0 + 0 < p->cost[_stmt_NT]) {
			p->cost[_stmt_NT] = 0 + 0;
			p->rule._stmt = 41;
		}
		break;
	case 615: /* VREGP */
		break;
	default:
		fatal("_label", "Bad terminal %d\n", OP_LABEL(a));
	}
}

static void _kids(p, eruleno, kids) NODEPTR_TYPE p, kids[]; int eruleno; {
	if (!p)
		fatal("_kids", "Null tree\n", 0);
	if (!kids)
		fatal("_kids", "Null kids\n", 0);
	switch (eruleno) {
	case 174: /* stmt: LABELV */
	case 52: /* scf: CNSTI */
	case 51: /* scf: CNSTI */
	case 50: /* scf: CNSTI */
	case 49: /* con3: CNSTP */
	case 48: /* con3: CNSTI */
	case 47: /* con0: CNSTU */
	case 46: /* con0: CNSTP */
	case 45: /* con0: CNSTI */
	case 36: /* table: ADDRGP */
	case 35: /* acon: ADDRGP */
	case 34: /* addr: ADDRGP */
	case 33: /* basei: ADDRLP */
	case 32: /* basei: ADDRFP */
	case 31: /* basei: ADDRLP */
	case 30: /* basei: ADDRFP */
	case 26: /* base: ADDRLP */
	case 25: /* base: ADDRFP */
	case 23: /* disp8: CNSTI */
	case 22: /* disp16: CNSTI */
	case 18: /* con: CNSTU */
	case 17: /* con: CNSTS */
	case 16: /* con: CNSTP */
	case 15: /* con: CNSTI */
	case 14: /* con: CNSTC */
	case 6: /* reg: INDIRS(VREGP) */
	case 5: /* reg: INDIRP(VREGP) */
	case 4: /* reg: INDIRI(VREGP) */
	case 3: /* reg: INDIRF(VREGP) */
	case 2: /* reg: INDIRD(VREGP) */
	case 1: /* reg: INDIRC(VREGP) */
		break;
	case 13: /* stmt: ASGNS(VREGP,reg) */
	case 12: /* stmt: ASGNP(VREGP,reg) */
	case 11: /* stmt: ASGND(VREGP,reg) */
	case 10: /* stmt: ASGNI(VREGP,reg) */
	case 9: /* stmt: ASGNF(VREGP,reg) */
	case 8: /* stmt: ASGND(VREGP,reg) */
	case 7: /* stmt: ASGNC(VREGP,reg) */
		kids[0] = RIGHT_CHILD(p);
		break;
	case 67: /* reg: ri */
	case 66: /* reg: addr */
	case 65: /* ea3: ri */
	case 64: /* ea3: mem */
	case 63: /* ea1: ri */
	case 62: /* ea1: mem */
	case 61: /* ea0: ri */
	case 60: /* ea0: mem */
	case 59: /* ri3: reg */
	case 58: /* ri3: con3 */
	case 57: /* ri: con */
	case 56: /* ri: reg */
	case 44: /* avar: addr */
	case 43: /* avar: reg */
	case 42: /* avar: acon */
	case 39: /* addr: base */
	case 37: /* index: reg */
	case 28: /* basei: reg */
	case 27: /* base: basei */
	case 19: /* stmt: reg */
		kids[0] = p;
		break;
	case 205: /* stmt: RETD(reg) */
	case 204: /* stmt: RETF(reg) */
	case 203: /* stmt: RETI(reg) */
	case 202: /* reg: CALLD(avar) */
	case 201: /* reg: CALLF(avar) */
	case 200: /* stmt: CALLV(avar) */
	case 199: /* reg: CALLI(avar) */
	case 173: /* stmt: JUMPV(pcrel) */
	case 172: /* stmt: JUMPV(acon) */
	case 171: /* reg: NEGF(reg) */
	case 170: /* reg: NEGD(reg) */
	case 161: /* stmt: ARGF(reg) */
	case 160: /* stmt: ARGD(reg) */
	case 155: /* mem: INDIRF(addr) */
	case 154: /* mem: INDIRD(addr) */
	case 153: /* reg: INDIRF(addr) */
	case 152: /* reg: INDIRD(addr) */
	case 151: /* reg: LOADF(reg) */
	case 150: /* reg: LOADD(reg) */
	case 147: /* stmt: ARGP(addr) */
	case 146: /* stmt: ARGP(ea0) */
	case 145: /* stmt: ARGI(addr) */
	case 144: /* stmt: ARGI(ea0) */
	case 134: /* reg: CVDI(reg) */
	case 133: /* reg: CVID(ea0) */
	case 132: /* reg: CVFD(reg) */
	case 131: /* reg: CVDF(reg) */
	case 130: /* reg: CVFD(reg) */
	case 129: /* reg: CVDF(reg) */
	case 128: /* reg: CVUS(reg) */
	case 127: /* reg: CVUP(reg) */
	case 126: /* reg: CVUI(reg) */
	case 125: /* reg: CVUC(reg) */
	case 124: /* reg: CVPU(reg) */
	case 123: /* reg: CVIU(reg) */
	case 122: /* reg: CVIS(reg) */
	case 121: /* reg: CVIC(reg) */
	case 120: /* reg: CVUS(reg) */
	case 119: /* reg: CVUC(reg) */
	case 118: /* reg: CVIS(reg) */
	case 117: /* reg: CVIC(reg) */
	case 112: /* reg: CVSU(reg) */
	case 111: /* reg: CVSI(reg) */
	case 110: /* reg: CVCU(reg) */
	case 109: /* reg: CVCI(reg) */
	case 96: /* reg: NEGI(reg) */
	case 95: /* reg: BCOMU(reg) */
	case 76: /* reg: LOADU(reg) */
	case 75: /* reg: LOADS(reg) */
	case 74: /* reg: LOADP(reg) */
	case 73: /* reg: LOADI(reg) */
	case 72: /* reg: LOADC(reg) */
	case 71: /* reg: INDIRS(addr) */
	case 70: /* reg: INDIRP(addr) */
	case 69: /* reg: INDIRI(addr) */
	case 68: /* reg: INDIRC(addr) */
	case 55: /* pcrel: INDIRP(case) */
	case 54: /* mem: INDIRP(addr) */
	case 53: /* mem: INDIRI(addr) */
	case 21: /* reg: CVUI(reg) */
	case 20: /* reg: CVIU(reg) */
		kids[0] = LEFT_CHILD(p);
		break;
	case 198: /* stmt: NEF(reg,reg) */
	case 197: /* stmt: LTF(reg,reg) */
	case 196: /* stmt: LEF(reg,reg) */
	case 195: /* stmt: GTF(reg,reg) */
	case 194: /* stmt: GEF(reg,reg) */
	case 193: /* stmt: EQF(reg,reg) */
	case 192: /* stmt: NED(reg,reg) */
	case 191: /* stmt: LTD(reg,reg) */
	case 190: /* stmt: LED(reg,reg) */
	case 189: /* stmt: GTD(reg,reg) */
	case 188: /* stmt: GED(reg,reg) */
	case 187: /* stmt: EQD(reg,reg) */
	case 186: /* stmt: LTU(reg,ea1) */
	case 185: /* stmt: LEU(reg,ea1) */
	case 184: /* stmt: GTU(reg,ea1) */
	case 183: /* stmt: GEU(reg,ea1) */
	case 182: /* stmt: NEI(reg,ea1) */
	case 181: /* stmt: LTI(reg,ea1) */
	case 180: /* stmt: LEI(reg,ea1) */
	case 179: /* stmt: GTI(reg,ea1) */
	case 178: /* stmt: GEI(reg,ea1) */
	case 177: /* stmt: EQI(reg,ea1) */
	case 176: /* stmt: NEI(ea0,con0) */
	case 175: /* stmt: EQI(ea0,con0) */
	case 169: /* reg: DIVF(reg,reg) */
	case 168: /* reg: DIVD(reg,reg) */
	case 167: /* reg: MULF(reg,reg) */
	case 166: /* reg: MULD(reg,reg) */
	case 165: /* reg: SUBF(reg,reg) */
	case 164: /* reg: SUBD(reg,reg) */
	case 163: /* reg: ADDF(reg,reg) */
	case 162: /* reg: ADDD(reg,reg) */
	case 159: /* stmt: ASGNF(addr,mem) */
	case 158: /* stmt: ASGNF(addr,reg) */
	case 157: /* stmt: ASGND(addr,mem) */
	case 156: /* stmt: ASGND(addr,reg) */
	case 143: /* stmt: ASGNS(addr,con0) */
	case 142: /* stmt: ASGNS(addr,ea1) */
	case 141: /* stmt: ASGNP(addr,con0) */
	case 140: /* stmt: ASGNP(addr,ea1) */
	case 138: /* stmt: ASGNI(addr,con0) */
	case 137: /* stmt: ASGNI(addr,ea1) */
	case 136: /* stmt: ASGNC(addr,con0) */
	case 135: /* stmt: ASGNC(addr,ea1) */
	case 108: /* reg: MODI(reg,reg) */
	case 107: /* reg: MODU(reg,ea3) */
	case 106: /* reg: DIVI(reg,ea3) */
	case 105: /* reg: DIVU(reg,ea3) */
	case 104: /* reg: MULU(reg,ea3) */
	case 103: /* reg: MULI(reg,ea3) */
	case 102: /* reg: RSHU(reg,ri3) */
	case 101: /* reg: RSHI(reg,ri3) */
	case 100: /* reg: LSHU(reg,ri3) */
	case 99: /* reg: LSHI(reg,ri3) */
	case 91: /* reg: BXORU(reg,reg) */
	case 90: /* reg: BORU(reg,ea1) */
	case 89: /* reg: BANDU(reg,ea1) */
	case 84: /* reg: SUBU(reg,ea1) */
	case 83: /* reg: SUBP(reg,ea1) */
	case 82: /* reg: SUBI(reg,ea1) */
	case 81: /* reg: ADDU(reg,ea1) */
	case 80: /* reg: ADDP(reg,ea1) */
	case 79: /* reg: ADDI(reg,ea1) */
	case 78: /* reg: SUBI(reg,con3) */
	case 77: /* reg: ADDI(reg,con3) */
	case 41: /* case: ADDP(index,table) */
	case 40: /* addr: ADDP(index,basei) */
	case 38: /* index: LSHI(reg,scf) */
	case 29: /* basei: ADDP(reg,disp8) */
	case 24: /* base: ADDP(reg,disp16) */
		kids[0] = LEFT_CHILD(p);
		kids[1] = RIGHT_CHILD(p);
		break;
	case 94: /* stmt: ASGNI(addr,BXORU(mem,reg)) */
	case 93: /* stmt: ASGNI(addr,BORU(mem,ri)) */
	case 92: /* stmt: ASGNI(addr,BANDU(mem,ri)) */
	case 88: /* stmt: ASGNI(addr,SUBU(mem,ri)) */
	case 87: /* stmt: ASGNI(addr,SUBI(mem,ri)) */
	case 86: /* stmt: ASGNI(addr,ADDU(mem,ri)) */
	case 85: /* stmt: ASGNI(addr,ADDI(mem,ri)) */
		kids[0] = LEFT_CHILD(p);
		kids[1] = LEFT_CHILD(RIGHT_CHILD(p));
		kids[2] = RIGHT_CHILD(RIGHT_CHILD(p));
		break;
	case 148: /* stmt: ASGNB(reg,INDIRB(reg)) */
	case 139: /* stmt: ASGNI(addr,CVDI(reg)) */
	case 98: /* stmt: ASGNI(addr,NEGI(mem)) */
	case 97: /* stmt: ASGNI(addr,BCOMU(mem)) */
		kids[0] = LEFT_CHILD(p);
		kids[1] = LEFT_CHILD(RIGHT_CHILD(p));
		break;
	case 149: /* stmt: ARGB(INDIRB(reg)) */
	case 116: /* reg: CVSU(INDIRS(addr)) */
	case 115: /* reg: CVSI(INDIRS(addr)) */
	case 114: /* reg: CVCU(INDIRC(addr)) */
	case 113: /* reg: CVCI(INDIRC(addr)) */
		kids[0] = LEFT_CHILD(LEFT_CHILD(p));
		break;
	default:
		fatal("_kids", "Bad rule number %d\n", eruleno);
	}
}

static void progbeg(argc, argv) char *argv[]; {
    int i;
 
    {
        union {
            char c;
            int i;
        } u;
        u.i = 0;
        u.c = 1;
        swap = (u.i == 1) != IR->little_endian;
    }
    parseflags(argc, argv);

    for(i=0;i<argc;++i) {
    }

    for (i = 0; i < 8; i++)
        ireg[i] = mkreg("D%d", i, 1, IREG);
    for (i = A0; i < A7; i++)
        areg[i+8] = mkreg("A%d", i, 0x100, IREG);
    for (i = 0; i < 8; i++)
        freg[i] = mkreg("FP%d", i, 1, FREG);
        
    rmap[C] = rmap[S] = rmap[B] = rmap[U] = rmap[I] = mkwildcard(dreg);
    rmap[P] = mkwildcard(areg);
    rmap[F] = rmap[D] = mkwildcard(freg);
     
    tmask[IREG] =   (1<<D0) | (1<<D1) | (1<<D2) | (1<<D3) |
                    (1<<D4) | (1<<D5) | (1<<D6) | (1<<D7) | /* D0-D7/A0-A4 */
                    (1<<A0+8) | (1<<A1+8) | (1<<A2+8) | (1<<A3+8) | (1<<A4+8);
    /*vmask[IREG] =   (1<<D3) | (1<<D4) | (1<<D5) | 
                    (1<<A2+8) | (1<<A3+8) | (1<<A4+8); */
    tmask[FREG] = (1<<FP0) | (1<<FP1) | (1<<FP2) | (1<<FP3);
    /* vmask[FREG] = (1<<FP4) | (1<<FP5) | (1<<FP6) | (1<<FP7); */
    
    print("\tMACHINE MC68030\n");
    print("\tMC68881\tCOID=1,PRECISION=D\n");
    print("\tCASE\tON\n");
    print("\tSTRING\tASIS\n");
    
    cseg = 0;
}
static void progend() {}
static void segment(n) {}
static void target(p) Node p; {
    assert(p);
    switch (p->op) {
    case ASGNB:
        rtarget(p, 1, areg[A0+8]); /* A0 Source */
        rtarget(p, 0, areg[A1+8]); /* A1 Destination */
        break;
    case ARGB:
            rtarget(p->kids[0], 0, areg[A0+8]); /* A0 Source */
        break;
    case CALLI: case CALLV:
            setreg(p, dreg[D0]);
        break;
    case CALLD: case CALLF:
            setreg(p, freg[FP0]);
            break;
    case RETI:
        rtarget(p, 0, ireg[D0]);
        break;
    case RETF: case RETD:
            rtarget(p, 0, freg[FP0]);
        break;
    }
}
 
static void clobber(p) Node p; {
    assert(p);
    switch (p->op) {
    case MULI: case MULU:
        break;
    case DIVI: case DIVU:
        break;
    case MODI: case MODU:
        spill(1<<D1, IREG, p);
        break;
    case ASGND:
        spill(1<<D0 | 1<<A0+8 | 1<<A1+8, IREG, p);
        break;
    case ASGNB: case ARGB:
        spill(1<<D0 | 1<<A0+8 | 1<<A1+8, IREG, p);
        break;
    case CALLI:
            /* save scratch registers but not return register */
        spill(1<<D1 | 1<<D2 | 1<<A0+8 | 1<<A1+8, IREG, p);
        spill(1<<FP0 | 1<<FP1 | 1<<FP2 | 1<<FP3, FREG, p);
        break;
    case CALLV:
            /* save scratch registers */
        spill(1<<D0 | 1<<D1 | 1<<D2 | 1<<A0+8 | 1<<A1+8, IREG, p);
        spill(1<<FP0 | 1<<FP1 | 1<<FP2 | 1<<FP3, FREG, p);
        break;
            break;
    case CALLD: case CALLF:
            /* save scratch registers but not return register */
        spill(1<<D0 | 1<<D1 | 1<<D2 | 1<<A0+8 | 1<<A1+8, IREG, p);
        spill(1<<FP1 | 1<<FP2 | 1<<FP3, FREG, p);
        break;
    }
}
static int sametree(p, q) Node p, q; {
    return p == 0 && q == 0
    || p && q && p->op == q->op && p->syms[0] == q->syms[0]
        && sametree(p->kids[0], q->kids[0]) && sametree(p->kids[1], q->kids[1]);
}
 
static int memop(p) Node p; {
    assert(p);
    assert(generic(p->op) == ASGN);
    assert(p->kids[0]);
    assert(p->kids[1]);
    if (generic(p->kids[1]->kids[0]->op) == INDIR) {
        assert(p->kids[1]->kids[0]);
        return sametree(p->kids[0], p->kids[1]->kids[0]->kids[0]) ? 2 : SHRT_MAX;
    } else
        return SHRT_MAX;
}

static void emit2(p) Node p; {
    switch(p->op) {
    case ASGNB: {
        int lab1 = genlabel(1), lab2 = genlabel(1);
        int src = getregnum(p->x.kids[1]), dst = getregnum(p->x.kids[0]);
        int size = p->syms[0]->u.c.v.i;
        
        if(size % 2)
            print("\tMOVE.L %#%d,D0\n", size);
        else
            print("\tMOVE.L %#%d,D0\n", size / 2);
        print("\tBRA.S @%d\n", lab2);
        print("@%d:\n", lab1);
        if(size % 2)
            print("\tMOVE.B (A%d)+,(A%d)+\n", src, dst);
        else
            print("\tMOVE.W (A%d)+,(A%d)+\n", src, dst);
        print("@%d:\n", lab2);
        print("\tDBF.W D0,@%d\n", lab1);
        break;
        }
    case ARGB: {
        int lab1 = genlabel(1), lab2 = genlabel(1);
        int size = p->syms[0]->u.c.v.i, src = getregnum(p->x.kids[0]);
        
        if(size % 2) ++size;
        print("\tSUBA.L %#%d,SP\n", size);
        print("\tMOVE.L SP,A1\n");
        print("\tMOVE.L %#%d,D0\n", size / 2);
        print("\tBRA.S @%d\n", lab2);
        print("@%d:\n", lab1);
        print("\tMOVE.W (A%d)+,(A1)+\n", src);
        print("@%d:\n", lab2);
        print("\tDBF.W D0,@%d\n", lab1);
        }
        break;
    case MODI: {
        int lab1 = genlabel(1), lab2 = genlabel(1);
        int rem = getregnum(p), quo = getregnum(p->x.kids[0]);
        int divisor = getregnum(p->x.kids[1]);

        /* use D2 as scratch for testing sign
         use D1 for quotient since dividend gets clobbered */
        print("\tMOVE.L D%d,D%d\n", quo, D1);
        print("\tMOVEQ.L #-1,D%d\n", rem);
        print("\tMOVE.L #31,D%d\n", D2);
        print("\tBTST.L D%d,D%d\n", D2, D1);
        print("\tBNE.S @%d\n", lab1);
        print("\tCLR.L D%d\n", rem);
        print("@%d:\n", lab1);
        print("\tDIVS.L D%d,D%d:D%d\n", divisor, rem, D1);
        break;
        }
    }
}
static void doarg(p) Node p; {
    assert(p && p->syms[0]);
        switch(p->op) {
        case ARGD: case ARGF:
            mkactual(2,realparamsize); /* pass all floats as extended which are 96-bits */
            break;
        default:
        mkactual(2, p->syms[0]->u.c.v.i);
    }
}
static void blkfetch(k, off, reg, tmp) {}
static void blkstore(k, off, reg, tmp) {}
static void blkloop(dreg, doff, sreg, soff, size, tmps)
    int tmps[]; {}
static void local(p) Symbol p; {
    if (askregvar(p, rmap[ttob(p->type)]) == 0)
        mkauto(p);
}
static void function(f, caller, callee, n)
Symbol f, callee[], caller[]; {
    int i, count, acount, inseq;
        char reglist[256];
        char temp[4];

    print("%s\tPROC", f->x.name);
    if(!(f->sclass==STATIC))
        print("\tEXPORT");
    print("\n");
    
    usedmask[0] = usedmask[1] = 0;
    freemask[0] = freemask[1] = ~(unsigned)0;
    offset = 4 + 4; /* FP and return address */
    for (i = 0; callee[i]; i++) {
        Symbol p = callee[i];
        Symbol q = caller[i];
        assert(q);
        p->x.offset = q->x.offset = offset;
        p->x.name = q->x.name = stringf("%d", p->x.offset);
        p->sclass = q->sclass = AUTO;
        if( p->type == floattype || p->type == doubletype)
            offset += roundup(realparamsize, 2);
        else
            offset += roundup(q->type->size, 2);
    }
    assert(caller[i] == 0);
    offset = maxoffset = 0;
    gencode(caller, callee);
    framesize = roundup(maxoffset, 2);
    
    if (framesize > 0)
        print("\tLINK A6,#%d\n", -framesize);
    else
        print("\tLINK A6,#0\n");
        
    /* format save register mask */
    reglist[0]= 0;
    count = acount = inseq = 0;
    for(i=D3;i<=D7;++i) {       
        if(usedmask[IREG] & (1<<i)) {
            if(count==0) {
                reglist[0] = 'D';
                reglist[1] = i + '0';
                reglist[2] = 0;
            } else if(!inseq) {
                temp[0] = '/';
                temp[1] = 'D';
                temp[2] = i + '0';
                temp[3] = 0;
                strcat(reglist,temp);
            }
            inseq++; count++;
        } else {
            if(inseq>1) {
                temp[0] = '-';
                temp[1] = 'D';
                temp[2] = i - 1 + '0';
                temp[3] = 0;
                strcat(reglist,temp);
            }
            inseq = 0;
        }
    }
    if(inseq>1) {
        temp[0] = '-';
        temp[1] = 'D';
        temp[2] = '7';
        temp[3] = 0;
        strcat(reglist,temp);
    }

    if(usedmask[IREG] & ((1<<A2+8) | (1<<A3+8) | (1<<A4+8))) {
        i = 0;
        if(count)
            temp[i++] = '/';
        temp[i] = 0;
        if(i)
            strcat(reglist, temp);

        acount = inseq = 0;
        for(i=A2;i<=A4;++i) {       
            if(usedmask[IREG] & (1<<i+8)) {
                if(acount==0) {
                    temp[0] = 'A';
                    temp[1] = i + '0';
                    temp[2] = 0;
                    strcat(reglist,temp);
                } else if(!inseq) {
                    temp[0] = '/';
                    temp[1] = 'A';
                    temp[2] = i + '0';
                    temp[3] = 0;
                    strcat(reglist,temp);
                }
                inseq++; acount++;
            } else {
                if(inseq>1) {
                    temp[0] = '-';
                    temp[1] = 'A';
                    temp[2] = i - 1 + '0';
                    temp[3] = 0;
                    strcat(reglist,temp);
                }
                inseq = 0;
            }
        }
        if(inseq>1) {
            temp[0] = '-';
            temp[1] = 'A';
            temp[2] = '4';
            temp[3] = 0;
            strcat(reglist,temp);
        }
    }
    
    count += acount;
    if(count > 1)
        print("\tMOVEM.L %s,-(SP)\n", reglist);
    else if(count == 1)
        print("\tMOVE.L %s,-(SP)\n", reglist);

    /* save floating point regs */
    for(i=FP4;i<=FP7;++i)
        if(usedmask[FREG] & (1<<i)) {
            print("\tFMOVE.D FP%d,-(SP)\n", i);
        }

    /* convert extended to declared format; FP1 is scratch register */
    for (i = 0; callee[i]; i++) {
        Symbol p = callee[i];
        if(p->type == floattype) {
        print("\tFMOVE.X %d(A6),FP1\n", p->x.offset);
        print("\tFMOVE.S FP1,%d(A6)\n", p->x.offset);
        }
        else if(p->type == doubletype) {
        print("\tFMOVE.X %d(A6),FP1\n", p->x.offset);
        print("\tFMOVE.D FP1,%d(A6)\n", p->x.offset);
        }
    }

    emitcode();
    
    for(i=FP7;i>=FP4;--i)
        if(usedmask[FREG] & (1<<i)) {
            /* pop saved float regs */
            print("\tFMOVE.D (SP)+,FP%d\n", i);
        }
    if(count > 1)
        print("\tMOVEM.L (SP)+,%s\n", reglist);
    else if(count == 1)
        print("\tMOVE.L (SP)+,%s\n", reglist);

    print("\tUNLK A6\n");
    print("\tRTS\n");
}
static void defsymbol(p) Symbol p; {
    if (p->scope >= LOCAL && p->sclass == STATIC)
        p->x.name = stringf("L%d", genlabel(1));
    else if (p->generated)
        p->x.name = stringf("L%s", p->name);
    else if (p->scope == GLOBAL || p->sclass == EXTERN)
        p->x.name = stringf("%s", p->name); /* no leading underscore */
    else if (p->scope == CONSTANTS
    && (isint(p->type) || isptr(p->type))
    && p->name[0] == '0' && p->name[1] == 'x')
        p->x.name = stringf("$%s", &p->name[2]); /* hex */
    else
        p->x.name = p->name;
}
static void address(q, p, n) Symbol q, p; int n; {
    if (p->scope == GLOBAL
    || p->sclass == STATIC || p->sclass == EXTERN)
        q->x.name = stringf("%s%s%d",
            p->x.name, n >= 0 ? "+" : "", n);
    else {
        q->x.offset = p->x.offset + n;
        q->x.name = stringd(q->x.offset);
    }
}
static void defconst(ty, v) Value v; {
    switch (ty) {
        case C: print("\tDC.B %d\n",    v.uc); return;
        case S: print("\tDC.W %d\n",    v.ss); return;
        case I: print("\tDC.L %d\n",   v.i ); return;
        case U: print("\tDC.L $%x\n", v.u ); return;
        case P: print("\tDC.L $%x\n", v.p ); return;
        case F:
            print("\tDC.L $%x\n", *(unsigned *)&v.f);
            return;
	case D: {
            unsigned *p = (unsigned *)&v.d;
            print("\tDC.L $%x, $%x\n", p[swap], p[1 - swap]);
            return;
            }
    }
    assert(0);
}

static void defstring (int i, char *s)
{
}

static void defaddress(p) Symbol p; {}
static void export(p) Symbol p; {}
static void import(p) Symbol p; {}
static void global(p) Symbol p; {}
static void space(n) {}

Interface m68kIR = {
    1, 1, 0,    /* char */
    2, 2, 0,    /* short */
    4, 2, 0,    /* int */
    4, 2, 1,    /* float */
    8, 2, 1,    /* double */
    4, 2, 0,    /* T * */
    0, 2, 0,    /* struct so that ARGB keeps stack aligned */
    0,      /* little_endian */
    0,      /* mulops_calls */
    0,      /* wants_callb */
    1,      /* wants_argb */
    0,      /* left_to_right */
    0,      /* wants_dag */
    address,
    blockbeg,
    blockend,
    defaddress,
    defconst,
    defstring,
    defsymbol,
    emit,
    export,
    function,
    gen,
    global,
    import,
    local,
    progbeg,
    progend,
    segment,
    space,
    0, 0, 0, 0, 0, 0, 0,
    {1, blkfetch, blkstore, blkloop,
        _label,
        _rule,
        _nts,
        _kids,
        _opname,
        _arity,
        _string,
        _templates,
        _isinstruction,
        _ntname,
        emit2,
        doarg,
        target,
        clobber,
         }
};
