/* linux.c -- lcc driver definitions for Linux.
 *
 * original version from Thorsten.Ohl@Physik.TH-Darmstadt.de
 * modified for ELF by Ken.Yap@syd.dit.csiro.au
 */

#include <string.h>
char *cpp[] = {"/lib/cpp",
	"-undef", "-nostdinc", "-lang-c", "-U__GNUC__",
	"-D_POSIX_SOURCE", "-D__STDC__", "-D__STRICT_ANSI__",
	"-Dunix", "-Di386", "-Dlinux",
	"-D__unix__", "-D__i386__", "-D__linux__",
	"-D__ELF__", "-D__signed__=signed",
	"$1", "$2", "$3", 0};

char *include[] = {"-I/usr/local/include/ansi",
	"-I/usr/local/include",
	"-I/usr/i486-linux/include",
	"-I/usr/lib/gcc-lib/i486-linux/2.7.0/include",
	"-I/usr/include", 0};

char *com[] = {"/usr/local/lib/rcc", "-target=x86-linux",
	"$1", "$2", "$3", 0};

char *as[] = {"/usr/bin/as", "-o", "$3", "$1", "$2", 0};

char *ld[] = {"/usr/bin/ld", "-m", "elf_i386",
	"-dynamic-linker", "/lib/ld-linux.so.1", "-o", "$3",
	"/usr/lib/crt1.o", "/usr/lib/crti.o", "/usr/lib/crtbegin.o",
	"$1", "$2", "",
	"-L/usr/lib/gcc-lib/i486-linux/2.7.0", "-L/usr/i486-linux/lib",
	"-lgcc", "", "-lc", "-lm",
	"/usr/lib/crtend.o", "/usr/lib/crtn.o",
	0};

int 
option(arg)
	char *arg;
{
	if (strcmp(arg, "-g") == 0)
		;
	/* -g doesn't seem to require any ld args to change */
	else if (strcmp(arg, "-p") == 0) {
		ld[7] = "/usr/lib/gcrt1.o";
		ld[16] = "-lgmon";
	} else if (strcmp(arg, "-b") == 0 && access("/usr/local/lib/bbexit.o", 4) == 0)
		ld[12] = "/usr/local/lib/bbexit.o";
	else
		return 0;
	return 1;
}
