;
;
; PMODE/W Assembly Startup for CC386.EXE (c) Kirill Jo$$ :-)
;
;
;

PROGRAM_STACK EQU 256	; Stack size

;	This is equ copy from C0DOS.ASM :-)

%macro GDTENTRY 3
	dw	%2 & 0ffffh
	dw	%1 & 0ffffh
	db	(%1 >> 16) & 0ffh
	dw	%3 | ((%2 >> 8) & 0f00h)
	db	%1 >> 24
%endmacro

segment _TEXT class=CODE align=16 use32
TextStart:
[extern __argv]
[extern __argc]
[extern __environ]
[extern _main]
[extern __stklen]
segment cstartup class=INITDATA align=4 use32
InitStart:
segment _STARTUPEND_ class=INITDATA align=4 use32
InitEnd:
segment crundown class=EXITDATA align=4 use32
ExitStart:
segment _RUNDOWNEND_ class=EXITDATA align=4 use32
ExitEnd:
segment cppinit class=CPPINIT align=4 use32
CppStart:
		dd	cpproutine,130
segment _CPPEND_ class=CPPINIT align=4 use32
CppEnd:
segment cppexit class=CPPEXIT align=4 use32
CpprStart:
		dd	cpproutine,130
segment _CPPREND_ class=CPPEXIT align=4 use32
CpprEnd:
segment _DATA class=DATA align=4 use32
segment _BSS class=BSS align=4 use32
BssStart:
segment _BSSEND class=BSS align=4 use32
BssEnd:
segment _STACK class=STACK align=16 stack use32
		times PROGRAM_STACK resb 1
stack_offset:
                ENDS


group DGROUP _TEXT cstartup _STARTUPEND_ crundown _RUNDOWNEND_ cppinit _CPPEND_ _DATA _BSS _BSSEND _STACK

[global __rexit]
[global __rexita]
[global __stacktop]
[global __linear]
[global __rmseg]
[global __pmodew]
[global __isDLL]
[global __envseg]
[global __pspseg]
segment _DATA
;%include "..\..\copyrght.asm"
        db " (i386/DOS PMODE/W)"
banner  db 'Startup for DOS/4GW & PMODE/W (c) Kirill Joss. 1997-2004',10,13,36
nomem	db	'no memory for stack$'
	[global ____xceptionhandle]
____xceptionhandle  db  0
	align 4
__linear	dd	0
__stacktop	dd	0
stackpos	resb	6
stackhandhi	dd	0
stackhandlo	dd	0
__rmseg		dw	0
__envseg        dw      0
__pspseg        dw      0
__pmodew  dd  0
__isDLL         dd      0

fsbase          dw      0       ; FS selector as we set it
unalignesp		dd		0		; esp before we align it
          align 4
adesc2   EQU $
	GDTENTRY	0,0fffffh,0c092H	; 386 data

defaultxcept    dd      0
                dd      0
destructorcnt   dd      0
xceptdata       dd      0       ; C++ xception data

threaddata      EQU $
fsdata          dd      defaultxcept         ; windows xception data
                dd      threaddata

segment _TEXT

..start:
        jmp short real_start
;
;	You can delete 'WATCOM', 
;		but it NOT work with Watcom Debbuger & DOS/4G or DOS/4GW :)
;
		db 'WATCOM', 0 	; The "WATCOM" string is needed in
				; order to run under DOS/4G and WatcomDebug.

;
; CODE
;
lrterr	db	0
lockregion:
    mov cx,bx
    shr ebx,16
    mov di,si
    shr edi,16
    mov ax,600h
    int 0x31
	jnc	lrt
	mov byte [lrterr], 1
lrt:
    ret
unlockregion:
    mov cx,bx
    shr ebx,16
    mov di,si
    shr esi,16
    mov ax,601h
    int 0x31
    ret
;
; Entry To ASM Code (_main)
; In:
;   CS - Code Selector    Base: 00000000h - Limit: 4G
;   DS - Data Selector    Base: 00000000h - Limit: 4G
;   ES - PSP Selector     Base: PSP Seg   - Limit: 100h
;   FS - ?
;   GS - ?
;   SS - Data Selector    Base: 00000000h - Limit: 4G
;   ESP -> STACK segment
;   Direction Flag - ?
;   Interrupt Flag - ?
;   All Other Registers Are Undefined!
;
real_start:
    	mov	[__stacktop],esp
        sti                             ; Set The Interrupt Flag
        cld                             ; Clear The Direction Flag
%if 1
;--- HX's PE loader needs a DPMI host with DOS extension
;--- else it aborts quickly. So we can safely assume here
;--- that the host supports the int 21h API.
		mov ah,51h
        int 21h
        mov es,ebx	
%endif        
        mov [__pspseg],es
        mov ax,[es:02ch]
        mov [__envseg],ax

        cli        
	mov 	eax,ds
	mov	es,eax
	mov 	fs,eax
	mov	gs,eax
        sti
;
; lock region
;
    mov ecx,TextStart
    mov esi,BssEnd
    sub esi,ecx
    call lockregion

;
; initialize FS to point to a windows-style thread struct
; they can reuse it if they don't want to do C++
;
                mov     bx,ds           ; get sel base
                mov     ax,6
                int     31h
                push    ecx
                push    edx

                mov     cx,1            ; allocate a selector
                sub     ax,ax
                int     31h
                mov     fs,ax
                mov     [fsbase],ax

                mov     ax,0bh          ; get descriptor
                mov     bx,ds
                mov     edi,adesc2
                int     31h

                mov     ax,0ch          ; initialize descriptor
                mov     bx,fs
                mov     edi,adesc2
                int     31h 

                pop     edx
                pop     ecx
                shl     ecx,16
                mov     cx,dx
                add     ecx,fsdata
                mov     dx,cx
                shr     ecx,16
                mov     bx,fs           ; set base
                mov     ax,7
                int     31h
; switch stacks
;
%ifdef XXXXX
		mov	ebx,[__stklen]
		cmp	ebx,40*1024
		jnc	okstack
		mov	ebx,40*1024
okstack:
		push ebx
		mov	ecx,ebx
		shr	ebx,16
		mov	ax,501h
		int	31h
		jnc	gotstack
		mov	edx,nomem
		mov	ah,9
		int	21h
		mov	ah,4ch
		int	21h
gotstack:
		mov	[stackhandhi],si
		mov	[stackhandlo],di
		pop		esi
		push	ebx		; lock the region
		push	ecx
		mov	edi,esi
		shr	esi,16
		mov	ax,600h		; lock the region
		int	31h
		pop	ecx
		pop	ebx
		shl	ebx,16
		mov	bx,cx
		sub	ebx,[__linear]
		add	ebx,[__stklen]
;
; initialize stack
;
		mov dword [stackpos],esp	; save old stack for later
		mov word [stackpos+4],ss
		and ebx,0fffffffch		;
		sub ebx,4
		mov esp,ebx			;
		mov	[__stacktop],ebx
%endif
%ifdef COPYRIGHT			; JOS
	mov edx,banner
	mov ah,9
	int 21h
%endif
;
; Clear BSS
;
	mov	edi,BssStart
	mov	ecx,BssEnd
	sub	ecx,edi
	sub	eax,eax
	cld
	rep	stosb
;
; Execute startup routines
;
	push 	ds			; reset es to ds
	pop 	es
	mov	ecx,InitStart
	mov	edx,InitEnd
	call	sexproc			; good name : SEXproc
	cld
;
; Execute C++ class initializers
;
	mov	ecx,CppStart
	mov	edx,CppEnd
	call	sexproc			; good name : SEXproc
	cld
;
;
; Call main
;
	mov fs,[fsbase]
	mov		[unalignesp],esp
	and		esp,-16
	sub		esp,12
	push	dword [__environ]
        push    dword [__argv]
	push	dword [__argc]
%ifdef DEBUG
        [extern monitor_init]
		call monitor_init
%endif
	call	_main
	add	esp,12
	mov		esp,[unalignesp]

; exit/abort comes here
;
__rexit:
	push	eax		; saving C return code
;
; Execute C++ class rundown routines
;
	mov	ecx,CpprStart
	mov	edx,CpprEnd
	call	sexproc
	cld
;
; Execute rundown routines
;
	mov	ecx,ExitStart
	mov	edx,ExitEnd
	call	sexproc
exitpos:
	pop	eax
__rexita:
;
;release our stack
;
%ifdef XXXXX
		lss	esp,[stackpos]  ; their stack
        push    eax
		mov 	si,[stackhandhi]; free ours
		mov	di,[stackhandlo]
		mov	ax,502h
		int	31h
%else
        push eax
%endif
;
; unlock region
;
    mov ecx,TextStart
    mov esi,BssEnd
    sub esi,ecx
    call unlockregion
;
; release our FS selector
;
                mov     ax,ds
                mov     fs,ax
                mov     bx,[fsbase]
                mov     ax,1
                int     31h
;
; finish up
;
        pop     eax
	mov	ah,4ch
	int	21h
;
; Handle startup/rundown routines
;
sexproc:
		cmp	ecx,edx		
		jz	short sexpdone	
		mov	edi,ecx
		sub	ebx,ebx
		sub	eax,eax
spl2:
		cmp	edi,edx
		jz	short spo
		test	dword [edi+4],-1
		jz	short spl3
		cmp	eax,[edi+4]
		jnc	short spl3
		mov	ebx,edi
		mov	eax,[edi+4]
spl3:
		add	edi,8
		jmp	spl2
spo:
		or	ebx,ebx
		jz	short sexpdone
		mov	dword [ebx+4],0
		push	edx
		push	ecx
		call	dword [ebx]
		pop	ecx
		pop	edx
		jmp	sexproc
sexpdone:
		ret

; This is called as the first thing from the C++ main routine
cpproutine:
		ret
