/*
	Software License Agreement (BSD License)
	
	Copyright (c) 1997-2008, David Lindauer, (LADSoft).
	All rights reserved.
	
	Redistribution and use of this software in source and binary forms, with or without modification, are
	permitted provided that the following conditions are met:
	
	* Redistributions of source code must retain the above
	  copyright notice, this list of conditions and the
	  following disclaimer.
	
	* Redistributions in binary form must reproduce the above
	  copyright notice, this list of conditions and the
	  following disclaimer in the documentation and/or other
	  materials provided with the distribution.
	
	* Neither the name of LADSoft nor the names of its
	  contributors may be used to endorse or promote products
	  derived from this software without specific prior
	  written permission of LADSoft.
	
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <locale.h>
#include <wchar.h>
#include "libp.h"

int _RTL_FUNC vfprintf(FILE *restrict stream, const char *restrict format, 
        va_list arglist)
{
	int written=0;
	char buffer[8192],*p;
	int i = 0;
	if (stream->token != FILTOK) {
		errno = _dos_errno = ENOENT;
		return 0;
	}
    if (stream->orient == __or_wide) {
        errno = EINVAL;
        return 0;
    }
    stream->orient = __or_narrow;
	while (*format) {
        p = buffer;
		while (*format != '%' && *format != 0 && p < buffer + sizeof(buffer))
			*p++ = *format++;
      	if (fwrite(buffer,1,p-buffer,stream) != p-buffer)
		    return EOF;
        written += p-buffer;
		if (*format == '%') {
            if  (*(format+1)) {
                p = buffer;
                format = __onetostr(buffer,&p,format+1,((char **)arglist+i),&i, &written);
                if (fwrite(buffer,1,p-buffer,stream) != p-buffer)
		            return EOF;
                written += p-buffer;
            } else
                format++;
        }
	}
	return written;
}
int _RTL_FUNC fprintf(FILE *restrict stream, const char *restrict format, ...)
{
	return vfprintf(stream,format,((char *)&format+sizeof(char *)));
}