/* 
   mmsfunc.h

   Base definitions

   Copyright (C) 1996 Free Software Foundation, Inc.

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, 
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   -----------
   DAL 2003 - this file modified extensively for my compiler.  New
   definitionswnwn added as well.
*/ 
#ifdef __cplusplus
extern "C" {
#endif

UINT PASCAL mmsystemGetVersion(void);
LRESULT   PASCAL CloseDriver(HDRVR hDriver, LONG lParam1, LONG lParam2);
HDRVR     PASCAL OpenDriver(LPCWSTR szDriverName, LPCWSTR szSectionName, LONG lParam2);
LRESULT   PASCAL SendDriverMessage(HDRVR hDriver, UINT message, LONG lParam1, LONG lParam2);
HMODULE   PASCAL DrvGetModuleHandle(HDRVR hDriver);
HMODULE   PASCAL GetDriverModuleHandle(HDRVR hDriver);
LRESULT   PASCAL DefDriverProc(DWORD dwDriverIdentifier, HDRVR hdrvr, UINT uMsg, LPARAM lParam1, LPARAM lParam2);
UINT PASCAL waveOutGetNumDevs(void);
UINT PASCAL waveOutGetVolume(HWAVEOUT hwo, LPDWORD pdwVolume);
UINT PASCAL waveOutSetVolume(HWAVEOUT hwo, DWORD dwVolume);
UINT PASCAL waveOutOpen(LPHWAVEOUT phwo, UINT uDeviceID,
    LPCWAVEFORMATEX pwfx, DWORD dwCallback, DWORD dwInstance, DWORD fdwOpen);
UINT PASCAL waveOutClose(HWAVEOUT hwo);
UINT PASCAL waveOutPrepareHeader(HWAVEOUT hwo, LPWAVEHDR pwh, UINT cbwh);
UINT PASCAL waveOutUnprepareHeader(HWAVEOUT hwo, LPWAVEHDR pwh, UINT cbwh);
UINT PASCAL waveOutWrite(HWAVEOUT hwo, LPWAVEHDR pwh, UINT cbwh);
UINT PASCAL waveOutPause(HWAVEOUT hwo);
UINT PASCAL waveOutRestart(HWAVEOUT hwo);
UINT PASCAL waveOutReset(HWAVEOUT hwo);
UINT PASCAL waveOutBreakLoop(HWAVEOUT hwo);
UINT PASCAL waveOutGetPosition(HWAVEOUT hwo, LPMMTIME pmmt, UINT cbmmt);
UINT PASCAL waveOutGetPitch(HWAVEOUT hwo, LPDWORD pdwPitch);
UINT PASCAL waveOutSetPitch(HWAVEOUT hwo, DWORD dwPitch);
UINT PASCAL waveOutGetPlaybackRate(HWAVEOUT hwo, LPDWORD pdwRate);
UINT PASCAL waveOutSetPlaybackRate(HWAVEOUT hwo, DWORD dwRate);
UINT PASCAL waveOutGetID(HWAVEOUT hwo, LPUINT puDeviceID);
UINT PASCAL waveOutMessage(HWAVEOUT hwo, UINT uMsg, DWORD dw1, DWORD dw2);
UINT PASCAL waveInGetNumDevs(void);
UINT PASCAL waveInOpen(LPHWAVEIN phwi, UINT uDeviceID,
    LPCWAVEFORMATEX pwfx, DWORD dwCallback, DWORD dwInstance, DWORD fdwOpen);
UINT PASCAL waveInClose(HWAVEIN hwi);
UINT PASCAL waveInPrepareHeader(HWAVEIN hwi, LPWAVEHDR pwh, UINT cbwh);
UINT PASCAL waveInUnprepareHeader(HWAVEIN hwi, LPWAVEHDR pwh, UINT cbwh);
UINT PASCAL waveInAddBuffer(HWAVEIN hwi, LPWAVEHDR pwh, UINT cbwh);
UINT PASCAL waveInStart(HWAVEIN hwi);
UINT PASCAL waveInStop(HWAVEIN hwi);
UINT PASCAL waveInReset(HWAVEIN hwi);
UINT PASCAL waveInGetPosition(HWAVEIN hwi, LPMMTIME pmmt, UINT cbmmt);
UINT PASCAL waveInGetID(HWAVEIN hwi, LPUINT puDeviceID);
UINT PASCAL waveInMessage(HWAVEIN hwi, UINT uMsg, DWORD dw1, DWORD dw2);
UINT PASCAL midiOutGetNumDevs(void);
UINT PASCAL midiStreamOpen(LPHMIDISTRM phms, LPUINT puDeviceID, DWORD cMidi, DWORD dwCallback, DWORD dwInstance, DWORD fdwOpen);
UINT PASCAL midiStreamClose(HMIDISTRM hms);
UINT PASCAL midiStreamProperty(HMIDISTRM hms, LPBYTE lppropdata, DWORD dwProperty);
UINT PASCAL midiStreamPosition(HMIDISTRM hms, LPMMTIME lpmmt, UINT cbmmt);
UINT PASCAL midiStreamOut(HMIDISTRM hms, LPMIDIHDR pmh, UINT cbmh);
UINT PASCAL midiStreamPause(HMIDISTRM hms);
UINT PASCAL midiStreamRestart(HMIDISTRM hms);
UINT PASCAL midiStreamStop(HMIDISTRM hms);
UINT PASCAL midiConnect(HMIDI hmi, HMIDIOUT hmo, LPVOID pReserved);
UINT PASCAL midiDisconnect(HMIDI hmi, HMIDIOUT hmo, LPVOID pReserved);
UINT PASCAL midiOutGetVolume(HMIDIOUT hmo, LPDWORD pdwVolume);
UINT PASCAL midiOutSetVolume(HMIDIOUT hmo, DWORD dwVolume);
UINT PASCAL midiOutOpen(LPHMIDIOUT phmo, UINT uDeviceID,
    DWORD dwCallback, DWORD dwInstance, DWORD fdwOpen);
UINT PASCAL midiOutClose(HMIDIOUT hmo);
UINT PASCAL midiOutPrepareHeader(HMIDIOUT hmo, LPMIDIHDR pmh, UINT cbmh);
UINT PASCAL midiOutUnprepareHeader(HMIDIOUT hmo, LPMIDIHDR pmh, UINT cbmh);
UINT PASCAL midiOutShortMsg(HMIDIOUT hmo, DWORD dwMsg);
UINT PASCAL midiOutLongMsg(HMIDIOUT hmo, LPMIDIHDR pmh, UINT cbmh);
UINT PASCAL midiOutReset(HMIDIOUT hmo);
UINT PASCAL midiOutCachePatches(HMIDIOUT hmo, UINT uBank, LPWORD pwpa, UINT fuCache);
UINT PASCAL midiOutCacheDrumPatches(HMIDIOUT hmo, UINT uPatch, LPWORD pwkya, UINT fuCache);
UINT PASCAL midiOutGetID(HMIDIOUT hmo, LPUINT puDeviceID);
UINT PASCAL midiOutMessage(HMIDIOUT hmo, UINT uMsg, DWORD dw1, DWORD dw2);
UINT PASCAL midiInGetNumDevs(void);
UINT PASCAL midiInOpen(LPHMIDIIN phmi, UINT uDeviceID,
	DWORD dwCallback, DWORD dwInstance, DWORD fdwOpen);
UINT PASCAL midiInClose(HMIDIIN hmi);
UINT PASCAL midiInPrepareHeader(HMIDIIN hmi, LPMIDIHDR pmh, UINT cbmh);
UINT PASCAL midiInUnprepareHeader(HMIDIIN hmi, LPMIDIHDR pmh, UINT cbmh);
UINT PASCAL midiInAddBuffer(HMIDIIN hmi, LPMIDIHDR pmh, UINT cbmh);
UINT PASCAL midiInStart(HMIDIIN hmi);
UINT PASCAL midiInStop(HMIDIIN hmi);
UINT PASCAL midiInReset(HMIDIIN hmi);
UINT PASCAL midiInGetID(HMIDIIN hmi, LPUINT puDeviceID);
UINT PASCAL midiInMessage(HMIDIIN hmi, UINT uMsg, DWORD dw1, DWORD dw2);
UINT PASCAL auxGetNumDevs(void);
UINT PASCAL auxSetVolume(UINT uDeviceID, DWORD dwVolume);
UINT PASCAL auxGetVolume(UINT uDeviceID, LPDWORD pdwVolume);
UINT PASCAL auxOutMessage(UINT uDeviceID, UINT uMsg, DWORD dw1, DWORD dw2);
UINT PASCAL mixerOpen(LPHMIXER phmx, UINT uMxId, DWORD dwCallback, DWORD dwInstance, DWORD fdwOpen);
UINT PASCAL mixerClose(HMIXER hmx);
DWORD PASCAL mixerMessage(HMIXER hmx, UINT uMsg, DWORD dwParam1, DWORD dwParam2);
UINT PASCAL mixerGetID(HMIXEROBJ hmxobj, UINT FAR *puMxId, DWORD fdwId);
UINT PASCAL mixerSetControlDetails(HMIXEROBJ hmxobj, LPMIXERCONTROLDETAILS pmxcd, DWORD fdwDetails);
UINT PASCAL timeGetSystemTime(LPMMTIME pmmt, UINT cbmmt);
DWORD PASCAL timeGetTime(void);
UINT PASCAL timeSetEvent(UINT uDelay, UINT uResolution,
    LPTIMECALLBACK fptc, DWORD dwUser, UINT fuEvent);
UINT PASCAL timeKillEvent(UINT uTimerID);
UINT PASCAL timeGetDevCaps(LPTIMECAPS ptc, UINT cbtc);
UINT PASCAL timeBeginPeriod(UINT uPeriod);
UINT PASCAL timeEndPeriod(UINT uPeriod);
UINT PASCAL joyGetNumDevs(void);
UINT PASCAL joyGetPosEx(UINT uJoyID, LPJOYINFOEX pji);
UINT PASCAL joyGetThreshold(UINT uJoyID, LPUINT puThreshold);
UINT PASCAL joyReleaseCapture(UINT uJoyID);
UINT PASCAL joySetCapture(HWND hwnd, UINT uJoyID, UINT uPeriod,
    WINBOOL fChanged);
UINT PASCAL joySetThreshold(UINT uJoyID, UINT uThreshold);
UINT PASCAL mmioClose(HMMIO hmmio, UINT fuClose);
LONG PASCAL mmioRead(HMMIO hmmio, HPSTR pch, LONG cch);
LONG PASCAL mmioWrite(HMMIO hmmio, const char * pch, LONG cch);
LONG PASCAL mmioSeek(HMMIO hmmio, LONG lOffset, int iOrigin);
UINT PASCAL mmioGetInfo(HMMIO hmmio, LPMMIOINFO pmmioinfo, UINT fuInfo);
UINT PASCAL mmioSetInfo(HMMIO hmmio, LPCMMIOINFO pmmioinfo, UINT fuInfo);
UINT PASCAL mmioSetBuffer(HMMIO hmmio, LPSTR pchBuffer, LONG cchBuffer,
    UINT fuBuffer);
UINT PASCAL mmioFlush(HMMIO hmmio, UINT fuFlush);
UINT PASCAL mmioAdvance(HMMIO hmmio, LPMMIOINFO pmmioinfo, UINT fuAdvance);
LRESULT PASCAL mmioSendMessage(HMMIO hmmio, UINT uMsg,
    LPARAM lParam1, LPARAM lParam2);
UINT PASCAL mmioDescend(HMMIO hmmio, LPMMCKINFO pmmcki,
    const MMCKINFO FAR* pmmckiParent, UINT fuDescend);
UINT PASCAL mmioAscend(HMMIO hmmio, LPMMCKINFO pmmcki, UINT fuAscend);
UINT PASCAL mmioCreateChunk(HMMIO hmmio, LPMMCKINFO pmmcki, UINT fuCreate);
WINBOOL PASCAL mciSetYieldProc(MCIDEVICEID mciId, YIELDPROC fpYieldProc,
    DWORD dwYieldData);
HTASK PASCAL mciGetCreatorTask(MCIDEVICEID mciId);
YIELDPROC PASCAL mciGetYieldProc(MCIDEVICEID mciId, LPDWORD pdwYieldData);
WINBOOL PASCAL mciExecute(LPCSTR pszCommand);

#ifdef UNICODE
WINBOOL PASCAL sndPlaySoundW(LPCWSTR pszSound, UINT fuSound);
WINBOOL PASCAL PlaySoundW(LPCWSTR pszSound, HMODULE hmod, DWORD fdwSound);
UINT PASCAL waveOutGetDevCapsW(UINT uDeviceID, LPWAVEOUTCAPS pwoc, UINT cbwoc);
UINT PASCAL waveOutGetErrorTextW(UINT mmrError, LPWSTR pszText, UINT cchText);
UINT PASCAL waveInGetDevCapsW(UINT uDeviceID, LPWAVEINCAPS pwic, UINT cbwic);
UINT PASCAL waveInGetErrorTextW(UINT mmrError, LPWSTR pszText, UINT cchText);
UINT PASCAL midiOutGetDevCapsW(UINT uDeviceID, LPMIDIOUTCAPS pmoc, UINT cbmoc);
UINT PASCAL midiOutGetErrorTextW(UINT mmrError, LPWSTR pszText, UINT cchText);
UINT PASCAL midiInGetDevCapsW(UINT uDeviceID, LPMIDIINCAPS pmic, UINT cbmic);
UINT PASCAL midiInGetErrorTextW(UINT mmrError, LPWSTR pszText, UINT cchText);
UINT PASCAL auxGetDevCapsW(UINT uDeviceID, LPAUXCAPS pac, UINT cbac);
UINT PASCAL mixerGetDevCapsW(UINT uMxId, LPMIXERCAPS pmxcaps, UINT cbmxcaps);
UINT PASCAL mixerGetLineInfoW(HMIXEROBJ hmxobj, LPMIXERLINE pmxl, DWORD fdwInfo);
UINT PASCAL mixerGetLineControlsW(HMIXEROBJ hmxobj, LPMIXERLINECONTROLS pmxlc, DWORD fdwControls);
UINT PASCAL mixerGetControlDetailsW(HMIXEROBJ hmxobj, LPMIXERCONTROLDETAILS pmxcd, DWORD fdwDetails);
UINT PASCAL joyGetDevCapsW(UINT uJoyID, LPJOYCAPS pjc, UINT cbjc);
FOURCC PASCAL mmioStringToFOURCCW(LPCWSTR sz, UINT uFlags);
LPMMIOPROC PASCAL mmioInstallIOProcW(FOURCC fccIOProc, LPMMIOPROC pIOProc, DWORD dwFlags);
HMMIO PASCAL mmioOpenW(LPWSTR pszFileName, LPMMIOINFO pmmioinfo, DWORD fdwOpen);
UINT PASCAL mmioRenameW(LPCWSTR pszFileName, LPCWSTR pszNewFileName, LPCMMIOINFO pmmioinfo, DWORD fdwRename);
MCIERROR PASCAL mciSendCommandW(MCIDEVICEID mciId, UINT uMsg, DWORD dwParam1, DWORD dwParam2);
MCIERROR  PASCAL mciSendStringW(LPCWSTR lpstrCommand, LPWSTR lpstrReturnString, UINT uReturnLength, HWND hwndCallback);
MCIDEVICEID PASCAL mciGetDeviceIDW(LPCWSTR pszDevice);
MCIDEVICEID PASCAL mciGetDeviceIDFromElementIDW(DWORD dwElementID, LPCWSTR lpstrType );
WINBOOL PASCAL mciGetErrorStringW(MCIERROR mcierr, LPWSTR pszText, UINT cchText);
#define sndPlaySound  sndPlaySoundW
#define PlaySound  PlaySoundW
#define waveOutGetDevCaps  waveOutGetDevCapsW
#define waveOutGetErrorText  waveOutGetErrorTextW
#define waveInGetDevCaps  waveInGetDevCapsW
#define waveInGetErrorText  waveInGetErrorTextW
#define midiOutGetDevCaps  midiOutGetDevCapsW
#define midiOutGetErrorText  midiOutGetErrorTextW
#define midiInGetDevCaps  midiInGetDevCapsW
#define midiInGetErrorText  midiInGetErrorTextW
#define auxGetDevCaps  auxGetDevCapsW
#define mixerGetDevCaps  mixerGetDevCapsW
#define mixerGetLineInfo  mixerGetLineInfoW
#define mixerGetControlDetails  mixerGetControlDetailsW
#define joyGetDevCaps  joyGetDevCapsW
#define mmioStringToFOURCC  mmioStringToFOURCCW
#define mmioInstallIOProc  mmioInstallIOProcW
#define mmioOpen  mmioOpenW
#define mmioRename  mmioRenameW
#define mciSendCommand  mciSendCommandW
#define mciSendString  mciSendStringW
#define mciGetDeviceID  mciGetDeviceIDW
#define mciGetDeviceIDFromElementID  mciGetDeviceIDFromElementIDW
#define mciGetErrorString  mciGetErrorStringW

#else
WINBOOL PASCAL sndPlaySoundA(LPCSTR pszSound, UINT fuSound);
WINBOOL PASCAL PlaySoundA(LPCSTR pszSound, HMODULE hmod, DWORD fdwSound);
UINT PASCAL waveOutGetDevCapsA(UINT uDeviceID, LPWAVEOUTCAPS pwoc, UINT cbwoc);
UINT PASCAL waveOutGetErrorTextA(UINT mmrError, LPSTR pszText, UINT cchText);
UINT PASCAL waveInGetDevCapsA(UINT uDeviceID, LPWAVEINCAPS pwic, UINT cbwic);
UINT PASCAL waveInGetErrorTextA(UINT mmrError, LPSTR pszText, UINT cchText);
UINT PASCAL midiOutGetDevCapsA(UINT uDeviceID, LPMIDIOUTCAPS pmoc, UINT cbmoc);
UINT PASCAL midiOutGetErrorTextA(UINT mmrError, LPSTR pszText, UINT cchText);
UINT PASCAL midiInGetDevCapsA(UINT uDeviceID, LPMIDIINCAPS pmic, UINT cbmic);
UINT PASCAL midiInGetErrorTextA(UINT mmrError, LPSTR pszText, UINT cchText);
UINT PASCAL auxGetDevCapsA(UINT uDeviceID, LPAUXCAPS pac, UINT cbac);
UINT PASCAL mixerGetDevCapsA(UINT uMxId, LPMIXERCAPS pmxcaps, UINT cbmxcaps);
UINT PASCAL mixerGetLineInfoA(HMIXEROBJ hmxobj, LPMIXERLINE pmxl, DWORD fdwInfo);
UINT PASCAL mixerGetLineControlsA(HMIXEROBJ hmxobj, LPMIXERLINECONTROLS pmxlc, DWORD fdwControls);
UINT PASCAL mixerGetControlDetailsA(HMIXEROBJ hmxobj, LPMIXERCONTROLDETAILS pmxcd, DWORD fdwDetails);
UINT PASCAL joyGetDevCapsA(UINT uJoyID, LPJOYCAPS pjc, UINT cbjc);
FOURCC PASCAL mmioStringToFOURCCA(LPCSTR sz, UINT uFlags);
LPMMIOPROC PASCAL mmioInstallIOProcA(FOURCC fccIOProc, LPMMIOPROC pIOProc, DWORD dwFlags);
HMMIO PASCAL mmioOpenA(LPSTR pszFileName, LPMMIOINFO pmmioinfo, DWORD fdwOpen);
UINT PASCAL mmioRenameA(LPCSTR pszFileName, LPCSTR pszNewFileName, LPCMMIOINFO pmmioinfo, DWORD fdwRename);
MCIERROR PASCAL mciSendCommandA(MCIDEVICEID mciId, UINT uMsg, DWORD dwParam1, DWORD dwParam2);
MCIERROR  PASCAL mciSendStringA(LPCSTR lpstrCommand, LPSTR lpstrReturnString, UINT uReturnLength, HWND hwndCallback);
MCIDEVICEID PASCAL mciGetDeviceIDA(LPCSTR pszDevice);
MCIDEVICEID PASCAL mciGetDeviceIDFromElementIDA(DWORD dwElementID, LPCSTR lpstrType );
WINBOOL PASCAL mciGetErrorStringA(MCIERROR mcierr, LPSTR pszText, UINT cchText);
#define sndPlaySound  sndPlaySoundA
#define PlaySound  PlaySoundA
#define waveOutGetDevCaps  waveOutGetDevCapsA
#define waveOutGetErrorText  waveOutGetErrorTextA
#define waveInGetDevCaps  waveInGetDevCapsA
#define waveInGetErrorText  waveInGetErrorTextA
#define midiOutGetDevCaps  midiOutGetDevCapsA
#define midiOutGetErrorText  midiOutGetErrorTextA
#define midiInGetDevCaps  midiInGetDevCapsA
#define midiInGetErrorText  midiInGetErrorTextA
#define auxGetDevCaps  auxGetDevCapsA
#define mixerGetDevCaps  mixerGetDevCapsA
#define mixerGetLineInfo  mixerGetLineInfoA
#define mixerGetControlDetails  mixerGetControlDetailsA
#define joyGetDevCaps  joyGetDevCapsA
#define mmioStringToFOURCC  mmioStringToFOURCCA
#define mmioInstallIOProc  mmioInstallIOProcA
#define mmioOpen  mmioOpenA
#define mmioRename  mmioRenameA
#define mciSendCommand  mciSendCommandA
#define mciSendString  mciSendStringA
#define mciGetDeviceID  mciGetDeviceIDA
#define mciGetDeviceIDFromElementID  mciGetDeviceIDFromElementIDA
#define mciGetErrorString  mciGetErrorStringA

#endif
#ifdef __cplusplus
} ;
#endif

