	SECTION _TEXT align=1 CLASS=CODE USE32
	SECTION _DATA align=16 CLASS=DATA USE32
	SECTION _BSS align=16 CLASS=BSS USE32
	SECTION _CONST align=16 CLASS=CONST USE32
	SECTION _STRING align=4 CLASS=STRING USE32
	SECTION cstartup align=4 CLASS=INITDATA USE32
	SECTION crundown align=4 CLASS=EXITDATA USE32
	SECTION cppinit  align=4 CLASS=CPPINIT USE32
	SECTION cppexit  align=4 CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
;
; Line 63:	static void _interrupt newkeyboard(void)
;
_newkeyboard:
	PUSH	ES
	PUSH	FS
	PUSH	GS
	PUSHA
L_2:
;
; Line 64:	{
;
;
; Line 65:	asm push ds
;
	PUSH	DS
;
; Line 66:	asm push es
;
	PUSH	ES
;
; Line 67:	asm mov ds, cs:[dsSel]
;
	MOV	DS,WORD [CS:_dsSel]
;
; Line 68:	asm mov es, cs:[dsSel]
;
	MOV	ES,WORD [CS:_dsSel]
;
; Line 69:	keyportvalue = inp(KEYBOARDPORT);
;
	PUSH	BYTE 060H
	CALL	_inp
	POP	ECX
	MOV	DWORD [_keyportvalue],EAX
;
; Line 70:	asm pushfd
;
	PUSHFD
;
; Line 71:	asm call fword [keyboardLast];
;
	CALL	DWORD FAR [_keyboardLast]
;
; Line 72:	asm pop es
;
	POP	ES
;
; Line 73:	asm pop ds
;
	POP	DS
;
; Line 74:	}
;
L_1:
	POPA
	POP	GS
	POP	FS
	POP	ES
	IRET
;
; Line 77:	static void _interrupt newtimer(void)
;
_newtimer:
	PUSH	ES
	PUSH	FS
	PUSH	GS
	PUSHA
L_4:
;
; Line 78:	{
;
;
; Line 79:	asm push ds
;
	PUSH	DS
;
; Line 80:	asm push es
;
	PUSH	ES
;
; Line 81:	asm mov ax,cs:[dsSel] ;
;
	MOV	AX,WORD [CS:_dsSel]
;
; Line 82:	asm mov ds,ax
;
	MOV	DS,AX
;
; Line 83:	asm mov es,ax
;
	MOV	ES,AX
;
; Line 84:	asm mov ecx,[stackbot] ;
;
	MOV	ECX,DWORD [_stackbot]
;
; Line 85:	asm add	ecx,TIMERSTACKSIZE-4 ;
;
	ADD	ECX,DWORD 0FFFCH
;
; Line 86:	asm mov	[oldss],ss
;
	MOV	WORD [_oldss],SS
;
; Line 87:	asm mov	[oldsp],esp
;
	MOV	DWORD [_oldsp],ESP
;
; Line 88:	asm mov	ss,ax ;
;
	MOV	SS,AX
;
; Line 89:	asm mov	esp,ecx
;
	MOV	ESP,ECX
;
; Line 91:	if (timer_running(doubletimer))
;
	CMP	DWORD [_doubletimer],BYTE 00H
	JLE	SHORT	L_5
;
; Line 92:	countdown(doubletimer);
;
	DEC	DWORD [_doubletimer]
L_5:
;
; Line 93:	if (timer_running(delaytimer))
;
	CMP	DWORD [_delaytimer],BYTE 00H
	JLE	SHORT	L_7
;
; Line 94:	countdown(delaytimer);
;
	DEC	DWORD [_delaytimer]
L_7:
;
; Line 95:	if (timer_running(clocktimer))
;
	CMP	DWORD [_clocktimer],BYTE 00H
	JLE	SHORT	L_9
;
; Line 96:	countdown(clocktimer);
;
	DEC	DWORD [_clocktimer]
L_9:
;
; Line 97:	asm pushfd
;
	PUSHFD
;
; Line 98:	asm call fword [timerLast];
;
	CALL	DWORD FAR [_timerLast]
;
; Line 99:	asm mov ss,[oldss]
;
	MOV	SS,WORD [_oldss]
;
; Line 100:	asm mov esp,[oldsp]
;
	MOV	ESP,DWORD [_oldsp]
;
; Line 101:	asm pop es
;
	POP	ES
;
; Line 102:	asm pop ds
;
	POP	DS
;
; Line 103:	}
;
L_3:
	POPA
	POP	GS
	POP	FS
	POP	ES
	IRET
[GLOBAL	_TestCriticalError]
;
; Line 108:	int TestCriticalError(void)
;
_TestCriticalError:
	PUSH	EBX
L_15:
;
; Line 109:	{
;
;
; Line 110:	int rtn = 0;
;
	MOV	EBX,00H
;
; Line 111:	if (CriticalError)    {
;
	CMP	DWORD [_CriticalError],BYTE 00H
	JE	SHORT	L_16
;
; Line 112:	rtn = 1;
;
	MOV	EBX,01H
;
; Line 113:	CriticalError = FALSE;
;
	MOV	DWORD [_CriticalError],00H
;
; Line 114:	if (TestErrorMessage(ermsg) == FALSE)
;
	PUSH	BYTE 01H
	PUSH	BYTE 032H
	PUSH	BYTE 031H
	PUSH	DWORD L_13
	PUSH	DWORD L_12
	PUSH	DWORD _ErrorBoxProc
	PUSH	BYTE 02H
	PUSH	DWORD _ermsg
	PUSH	DWORD L_11
	PUSH	BYTE 00H
	CALL	_GenericMessage
	ADD	ESP,BYTE 028H
	TEST	EAX,EAX
	JNE	SHORT	L_18
;
; Line 115:	rtn = 2;
;
	MOV	EBX,02H
L_18:
L_16:
;
; Line 117:	return rtn;
;
	MOV	EAX,EBX
L_14:
	POP	EBX
	RET
;
; Line 121:	static void _interrupt newcrit(IREGS ir)
;
_newcrit:
	PUSH	ES
	PUSH	FS
	PUSH	GS
	PUSHA
	MOV	EBP,ESP
	LEA	ESI,[EBP+00H]
L_21:
;
; Line 122:	{
;
;
; Line 123:	if (!(ir.ax & 0x8000))     {
;
	MOV	EAX,DWORD [SS:ESI+020H]
	AND	EAX,08000H
	JNE	SHORT	L_22
;
; Line 124:	ermsg[sizeof(ermsg) - 2] = (ir.ax & 0xff) + 'A';
;
	MOVZX	EAX,BYTE [SS:ESI+020H]
	ADD	EAX,BYTE 041H
	MOV	BYTE [_ermsg+016H],AL
;
; Line 125:	CriticalError = TRUE;
;
	MOV	DWORD [_CriticalError],01H
L_22:
;
; Line 127:	ir.ax = 0;
;
	MOV	DWORD [SS:ESI+020H],00H
;
; Line 128:	}
;
L_20:
	POPA
	POP	GS
	POP	FS
	POP	ES
	IRET
;
; Line 130:	static void StopMsg(void)
;
_StopMsg:
L_25:
;
; Line 131:	{
;
;
; Line 132:	if (hasints)
;
	CMP	DWORD [_hasints],BYTE 00H
	JE	SHORT	L_26
;
; Line 134:	dpmi_set_protected_interrupt(8,*(SELECTOR *)((unsigned char *)&timerLast + 4),*(ULONG *)&timerLast) ;
;
	PUSH	DWORD [_timerLast]
	MOV	EAX,DWORD 04H+_timerLast
	MOVZX	EAX,WORD [EAX+00H]
	PUSH	EAX
	PUSH	BYTE 08H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 135:	dpmi_free_memory(timerMemhand) ;
;
	PUSH	DWORD [_timerMemhand]
	CALL	_dpmi_free_memory
	POP	ECX
;
; Line 136:	dpmi_set_protected_interrupt(9,*(SELECTOR *)((unsigned char *)&keyboardLast + 4),*(ULONG *)&keyboardLast) ;
;
	PUSH	DWORD [_keyboardLast]
	MOV	EAX,DWORD 04H+_keyboardLast
	MOVZX	EAX,WORD [EAX+00H]
	PUSH	EAX
	PUSH	BYTE 09H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 137:	hasints = FALSE;
;
	MOV	DWORD [_hasints],00H
L_26:
;
; Line 139:	ClearClipboard();
;
	CALL	_ClearClipboard
;
; Line 140:	ClearDialogBoxes();
;
	CALL	_ClearDialogBoxes
;
; Line 141:	ConsoleRundown();
;
	CALL	_ConsoleRundown
;
; Line 142:	hide_mousecursor();
;
	CALL	_hide_mousecursor
;
; Line 143:	}
;
L_24:
	RET
[GLOBAL	_init_messages]
;
; Line 146:	BOOL init_messages(void)
;
_init_messages:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
L_29:
;
; Line 147:	{
;
;
; Line 148:	asm mov [dsSel],ds
;
	MOV	WORD [_dsSel],DS
;
; Line 149:	AllocTesting = TRUE;
;
	MOV	DWORD [_AllocTesting],01H
;
; Line 150:	if (setjmp(AllocError) != 0)	{
;
	PUSH	DWORD _AllocError
	CALL	_setjmp
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_30
;
; Line 151:	StopMsg();
;
	CALL	_StopMsg
;
; Line 152:	return FALSE;
;
	MOV	EAX,00H
	JMP	NEAR	L_28
L_30:
;
; Line 154:	resetmouse();
;
	CALL	_resetmouse
;
; Line 155:	set_mousetravel(0, SCREENWIDTH-1, 0, SCREENHEIGHT-1);
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_34
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_32
L_34:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_33
L_32:
	MOV	EAX,019H
L_33:
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 156:	ConsoleInit();
;
	CALL	_ConsoleInit
;
; Line 157:	px = py = -1;
;
	MOV	EAX,01H
	NEG	EAX
	MOV	DWORD [_py],EAX
	MOV	DWORD [_px],EAX
;
; Line 158:	pmx = pmy = -1;
;
	MOV	EAX,01H
	NEG	EAX
	MOV	DWORD [_pmy],EAX
	MOV	DWORD [_pmx],EAX
;
; Line 159:	mx = my = 0;
;
	MOV	DWORD [_my],00H
	MOV	DWORD [_mx],00H
;
; Line 160:	CaptureMouse = CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
	MOV	DWORD [_CaptureMouse],00H
;
; Line 161:	NoChildCaptureMouse = FALSE;
;
	MOV	DWORD [_NoChildCaptureMouse],00H
;
; Line 162:	NoChildCaptureKeyboard = FALSE;
;
	MOV	DWORD [_NoChildCaptureKeyboard],00H
;
; Line 163:	MsgQueueOnCtr = MsgQueueOffCtr = MsgQueueCtr = 0;
;
	MOV	DWORD [_MsgQueueCtr],00H
	MOV	DWORD [_MsgQueueOffCtr],00H
	MOV	DWORD [_MsgQueueOnCtr],00H
;
; Line 164:	EventQueueOnCtr = EventQueueOffCtr = EventQueueCtr = 0;
;
	MOV	DWORD [_EventQueueCtr],00H
	MOV	DWORD [_EventQueueOffCtr],00H
	MOV	DWORD [_EventQueueOnCtr],00H
;
; Line 165:	if (!hasints)    {
;
	CMP	DWORD [_hasints],BYTE 00H
	JNE	NEAR	L_35
;
; Line 168:	asm mov [cssel],cs
;
	MOV	WORD [EBP-08H],CS
;
; Line 169:	asm mov [dssel],ds
;
	MOV	WORD [EBP-06H],DS
;
; Line 170:	dpmi_get_memory(&stackbot,&timerMemhand, TIMERSTACKSIZE) ;
;
	PUSH	DWORD 010000H
	PUSH	DWORD _timerMemhand
	PUSH	DWORD _stackbot
	CALL	_dpmi_get_memory
	ADD	ESP,BYTE 0CH
;
; Line 171:	dpmi_get_sel_base(&linear, dssel);
;
	MOVZX	EAX,WORD [EBP-06H]
	PUSH	EAX
	LEA	EAX,[EBP-04H]
	PUSH	EAX
	CALL	_dpmi_get_sel_base
	ADD	ESP,BYTE 08H
;
; Line 172:	stackbot -= linear;
;
	MOV	EAX,DWORD [EBP-04H]
	IMUL	EAX,BYTE 01H
	SUB	DWORD [_stackbot],EAX
;
; Line 173:	dpmi_get_protected_interrupt(((unsigned char *)&timerLast + 4), &timerLast, 8) ;
;
	PUSH	BYTE 08H
	PUSH	DWORD _timerLast
	MOV	EAX,DWORD 04H+_timerLast
	PUSH	EAX
	CALL	_dpmi_get_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 174:	dpmi_set_protected_interrupt(8,cssel,(ULONG)newtimer) ;
;
	PUSH	DWORD _newtimer
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 08H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 176:	dpmi_get_protected_interrupt(((unsigned char *)&keyboardLast + 4), &keyboardLast, 9) ;
;
	PUSH	BYTE 09H
	PUSH	DWORD _keyboardLast
	MOV	EAX,DWORD 04H+_keyboardLast
	PUSH	EAX
	CALL	_dpmi_get_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 177:	dpmi_set_protected_interrupt(9,cssel,(ULONG)newkeyboard) ;
;
	PUSH	DWORD _newkeyboard
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 09H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
L_35:
;
; Line 179:	setvect(CRIT, (void _interrupt (*)(...))newcrit);
;
	PUSH	DWORD _newcrit
	PUSH	BYTE 024H
	CALL	_setvect
	ADD	ESP,BYTE 08H
;
; Line 180:	PostMessage(NULL,START,0,0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	CALL	_PostMessage
	ADD	ESP,BYTE 010H
;
; Line 181:	lagdelay = FIRSTDELAY;
;
	MOV	DWORD [_lagdelay],07H
;
; Line 182:	return TRUE;
;
	MOV	EAX,01H
L_28:
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 186:	static void PostEvent(MESSAGE event, int p1, int p2)
;
_PostEvent:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _EventQueueOnCtr
	MOV	EDI,DWORD _EventQueue
L_38:
;
; Line 187:	{
;
;
; Line 188:	if (EventQueueCtr != MAXMESSAGES)    {
;
	CMP	DWORD [_EventQueueCtr],BYTE 064H
	JE	SHORT	L_39
;
; Line 189:	EventQueue[EventQueueOnCtr].event = event;
;
	MOV	EAX,DWORD [ESI+00H]
	IMUL	EAX,BYTE 0CH
	MOV	ECX,DWORD [EBP+08H]
	MOV	DWORD [EDI+EAX+00H],ECX
;
; Line 190:	EventQueue[EventQueueOnCtr].mx = p1;
;
	MOV	EAX,DWORD [ESI+00H]
	IMUL	EAX,BYTE 0CH
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+0CH]
	MOV	DWORD [EAX+04H],ECX
;
; Line 191:	EventQueue[EventQueueOnCtr].my = p2;
;
	MOV	EAX,DWORD [ESI+00H]
	IMUL	EAX,BYTE 0CH
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+010H]
	MOV	DWORD [EAX+08H],ECX
;
; Line 192:	if (++EventQueueOnCtr == MAXMESSAGES)
;
	INC	DWORD [ESI+00H]
	CMP	DWORD [ESI+00H],BYTE 064H
	JNE	SHORT	L_41
;
; Line 193:	EventQueueOnCtr = 0;
;
	MOV	DWORD [ESI+00H],00H
L_41:
;
; Line 194:	EventQueueCtr++;
;
	INC	DWORD [_EventQueueCtr]
L_39:
;
; Line 196:	}
;
L_37:
	POP	EDI
	POP	ESI
	POP	EBP
	RET
;
; Line 199:	static void near collect_events(void)
;
_collect_events:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 010H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD _lagdelay
L_50:
;
; Line 200:	{
;
;
; Line 208:	if (timed_out(clocktimer))    {
;
	CMP	DWORD [_clocktimer],BYTE 00H
	JNE	NEAR	L_51
;
; Line 210:	time_t t = time(NULL);
;
	PUSH	BYTE 00H
	CALL	_time
	POP	ECX
	MOV	DWORD [EBP-010H],EAX
;
; Line 211:	now = localtime(&t);
;
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_localtime
	POP	ECX
	MOV	DWORD [EBP-08H],EAX
;
; Line 212:	hr = now->tm_hour > 12 ?
;
	MOV	EAX,DWORD [EBP-08H]
	CMP	DWORD [EAX+08H],BYTE 0CH
	JLE	SHORT	L_53
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
	SUB	EAX,BYTE 0CH
	JMP	SHORT	L_54
L_53:
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
L_54:
	MOV	DWORD [EBP-04H],EAX
;
; Line 215:	if (hr == 0)
;
	CMP	DWORD [EBP-04H],BYTE 00H
	JNE	SHORT	L_55
;
; Line 216:	hr = 12;
;
	MOV	DWORD [EBP-04H],0CH
L_55:
;
; Line 217:	sprintf(time_string, "%2d:%02d", hr, now->tm_min);
;
	MOV	EAX,DWORD [EBP-08H]
	PUSH	DWORD [EAX+04H]
	PUSH	DWORD [EBP-04H]
	PUSH	DWORD L_45
	PUSH	DWORD _time_string
	CALL	_sprintf
	ADD	ESP,BYTE 010H
;
; Line 218:	strcpy(time_string+5, now->tm_hour > 11 ? "pm " : "am ");
;
	MOV	EAX,DWORD [EBP-08H]
	CMP	DWORD [EAX+08H],BYTE 0BH
	JLE	SHORT	L_57
	MOV	EAX,DWORD L_46
	JMP	SHORT	L_58
L_57:
	MOV	EAX,DWORD L_47
L_58:
	PUSH	EAX
	MOV	EAX,DWORD 05H+_time_string
	PUSH	EAX
	CALL	_strcpy
	ADD	ESP,BYTE 08H
;
; Line 220:	if (flipflop)
;
	CMP	DWORD [L_44],BYTE 00H
	JE	SHORT	L_59
;
; Line 221:	*(time_string+2) = ' ';
;
	MOV	BYTE [_time_string+02H],020H
L_59:
;
; Line 222:	flipflop ^= TRUE;
;
	BTC	DWORD [L_44],00H
;
; Line 224:	set_timer(clocktimer, 1);
;
	MOV	DWORD [_clocktimer],013H
;
; Line 226:	PostEvent(CLOCKTICK, FP_SEG(time_string), FP_OFF(time_string));
;
	PUSH	DWORD _time_string
	PUSH	DWORD _time_string
	PUSH	BYTE 010H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_51:
;
; Line 230:	if ((sk = getshift()) != ShiftKeys)    {
;
	CALL	_getshift
	MOV	ESI,EAX
	CMP	EAX,DWORD [L_43]
	JE	SHORT	L_61
;
; Line 231:	ShiftKeys = sk;
;
	MOV	DWORD [L_43],ESI
;
; Line 233:	PostEvent(SHIFT_CHANGED, sk, 0);
;
	PUSH	BYTE 00H
	PUSH	ESI
	PUSH	BYTE 01CH
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 234:	if (sk & ALTKEY)
;
	MOV	EAX,ESI
	AND	EAX,BYTE 08H
	JE	SHORT	L_63
;
; Line 235:	AltDown = TRUE;
;
	MOV	DWORD [_AltDown],01H
L_63:
L_61:
;
; Line 240:	if (sk & ALTKEY)	{
;
	MOV	EAX,ESI
	AND	EAX,BYTE 08H
	JE	NEAR	L_65
;
; Line 241:	if (keyportvalue == 14)    {
;
	CMP	DWORD [_keyportvalue],BYTE 0EH
	JNE	SHORT	L_67
;
; Line 242:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
	JMP	SHORT	L_69
L_71:
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
L_69:
;
; Line 243:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_71
L_70:
;
; Line 244:	PostEvent(KEYBOARD, ALT_BS, sk);
;
	PUSH	ESI
	PUSH	DWORD 010C5H
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_67:
;
; Line 246:	if (keyportvalue == 83)    {
;
	CMP	DWORD [_keyportvalue],BYTE 053H
	JNE	SHORT	L_72
;
; Line 247:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
	JMP	SHORT	L_74
L_76:
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
L_74:
;
; Line 248:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_76
L_75:
;
; Line 249:	PostEvent(KEYBOARD, ALT_DEL, sk);
;
	PUSH	ESI
	PUSH	DWORD 010B8H
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_72:
L_65:
;
; Line 252:	if (sk & CTRLKEY)	{
;
	MOV	EAX,ESI
	AND	EAX,BYTE 04H
	JE	SHORT	L_77
;
; Line 253:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 254:	if (keyportvalue == 82)    {
;
	CMP	DWORD [_keyportvalue],BYTE 052H
	JNE	SHORT	L_79
	JMP	SHORT	L_81
L_83:
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
L_81:
;
; Line 255:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_83
L_82:
;
; Line 256:	PostEvent(KEYBOARD, CTRL_INS, sk);
;
	PUSH	ESI
	PUSH	DWORD 010BAH
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_79:
L_77:
;
; Line 260:	if (keyhit())    {
;
	CALL	_kbhit
	TEST	EAX,EAX
	JE	NEAR	L_84
;
; Line 263:	int c = getkey();
;
	CALL	_getkey
	MOV	EBX,EAX
;
; Line 264:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 266:	if (sk & (LEFTSHIFT | RIGHTSHIFT))    {
;
	MOV	EAX,ESI
	AND	EAX,BYTE 03H
	JE	SHORT	L_86
;
; Line 267:	if (c >= '0' && c <= '9')
;
	CMP	EBX,BYTE 030H
	JL	SHORT	L_88
	CMP	EBX,BYTE 039H
	JG	SHORT	L_88
;
; Line 268:	c = cvt[c-'0'];
;
	MOV	EAX,EBX
	SUB	EAX,BYTE 030H
	MOV	EBX,DWORD [EAX*4+L_48+00H]
	JMP	SHORT	L_89
L_88:
;
; Line 269:	else if (c == '.' || c == DEL)
;
	CMP	EBX,BYTE 02EH
	JE	SHORT	L_92
	CMP	EBX,010D3H
	JNE	SHORT	L_90
L_92:
;
; Line 270:	c = SHIFT_DEL;
;
	MOV	EBX,010C6H
	JMP	SHORT	L_91
L_90:
;
; Line 271:	else if (c == INS)
;
	CMP	EBX,010D2H
	JNE	SHORT	L_93
;
; Line 272:	c = SHIFT_INS;
;
	MOV	EBX,010B9H
L_93:
L_91:
L_89:
L_86:
;
; Line 274:	if (c != '\r' && (c < ' ' || c > 127))
;
	CMP	EBX,BYTE 0DH
	JE	SHORT	L_95
	CMP	EBX,BYTE 020H
	JL	SHORT	L_97
	CMP	EBX,BYTE 07FH
	JLE	SHORT	L_95
L_97:
;
; Line 275:	clearBIOSbuffer();
;
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
L_95:
;
; Line 277:	PostEvent(KEYBOARD, c, sk);
;
	PUSH	ESI
	PUSH	EBX
	PUSH	BYTE 013H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_84:
;
; Line 280:	if (button_releases())    {
;
	CALL	_button_releases
	TEST	EAX,EAX
	JE	SHORT	L_98
;
; Line 282:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 283:	doubletimer = DOUBLETICKS;
;
	MOV	DWORD [_doubletimer],05H
;
; Line 284:	PostEvent(BUTTON_RELEASED, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 025H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 285:	disable_timer(delaytimer);
;
	MOV	DWORD [_delaytimer],0FFFFFFFFH
L_98:
;
; Line 287:	get_mouseposition(&mx, &my);
;
	PUSH	DWORD _my
	PUSH	DWORD _mx
	CALL	_get_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 288:	if (mx != px || my != py)  {
;
	MOV	EAX,DWORD [_mx]
	CMP	EAX,DWORD [_px]
	JNE	SHORT	L_102
	MOV	EAX,DWORD [_my]
	CMP	EAX,DWORD [_py]
	JE	SHORT	L_100
L_102:
;
; Line 289:	px = mx;
;
	MOV	EAX,DWORD [_mx]
	MOV	DWORD [_px],EAX
;
; Line 290:	py = my;
;
	MOV	EAX,DWORD [_my]
	MOV	DWORD [_py],EAX
;
; Line 291:	PostEvent(MOUSE_MOVED, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 024H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_100:
;
; Line 293:	if (rightbutton())	{
;
	CALL	_mousebuttons
	AND	EAX,BYTE 02H
	JE	SHORT	L_103
;
; Line 294:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 295:	PostEvent(RIGHT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 021H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_103:
;
; Line 297:	if (leftbutton())    {
;
	CALL	_mousebuttons
	AND	EAX,BYTE 01H
	JE	NEAR	L_105
;
; Line 298:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 299:	if (mx == pmx && my == pmy)    {
;
	MOV	EAX,DWORD [_mx]
	CMP	EAX,DWORD [_pmx]
	JNE	SHORT	L_107
	MOV	EAX,DWORD [_my]
	CMP	EAX,DWORD [_pmy]
	JNE	SHORT	L_107
;
; Line 301:	if (timer_running(doubletimer))    {
;
	CMP	DWORD [_doubletimer],BYTE 00H
	JLE	SHORT	L_109
;
; Line 303:	disable_timer(doubletimer);
;
	MOV	DWORD [_doubletimer],0FFFFFFFFH
;
; Line 304:	PostEvent(DOUBLE_CLICK, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 023H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
	JMP	SHORT	L_110
L_109:
;
; Line 306:	else if (!timer_running(delaytimer))    {
;
	CMP	DWORD [_delaytimer],BYTE 00H
	JG	SHORT	L_111
;
; Line 308:	delaytimer = lagdelay;
;
	MOV	EAX,DWORD [EDI+00H]
	MOV	DWORD [_delaytimer],EAX
;
; Line 309:	lagdelay = DELAYTICKS;
;
	MOV	DWORD [EDI+00H],01H
;
; Line 311:	PostEvent(LEFT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 022H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_111:
L_110:
	JMP	SHORT	L_108
L_107:
;
; Line 316:	disable_timer(doubletimer);
;
	MOV	DWORD [_doubletimer],0FFFFFFFFH
;
; Line 317:	delaytimer = FIRSTDELAY;
;
	MOV	DWORD [_delaytimer],07H
;
; Line 318:	lagdelay = DELAYTICKS;
;
	MOV	DWORD [EDI+00H],01H
;
; Line 319:	PostEvent(LEFT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 022H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 320:	pmx = mx;
;
	MOV	EAX,DWORD [_mx]
	MOV	DWORD [_pmx],EAX
;
; Line 321:	pmy = my;
;
	MOV	EAX,DWORD [_my]
	MOV	DWORD [_pmy],EAX
L_108:
	JMP	SHORT	L_106
L_105:
;
; Line 325:	lagdelay = FIRSTDELAY;
;
	MOV	DWORD [EDI+00H],07H
L_106:
;
; Line 326:	}
;
L_49:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_PostMessage]
;
; Line 329:	void PostMessage(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
;
_PostMessage:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _MsgQueueOnCtr
	MOV	EDI,DWORD _MsgQueue
L_114:
;
; Line 330:	{
;
;
; Line 331:	if (MsgQueueCtr != MAXMESSAGES)    {
;
	CMP	DWORD [_MsgQueueCtr],BYTE 064H
	JE	SHORT	L_115
;
; Line 332:	MsgQueue[MsgQueueOnCtr].wnd = wnd;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	MOV	ECX,DWORD [EBP+08H]
	MOV	DWORD [EDI+EAX+00H],ECX
;
; Line 333:	MsgQueue[MsgQueueOnCtr].msg = msg;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+0CH]
	MOV	DWORD [EAX+04H],ECX
;
; Line 334:	MsgQueue[MsgQueueOnCtr].p1 = p1;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+010H]
	MOV	DWORD [EAX+08H],ECX
;
; Line 335:	MsgQueue[MsgQueueOnCtr].p2 = p2;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+014H]
	MOV	DWORD [EAX+0CH],ECX
;
; Line 336:	if (++MsgQueueOnCtr == MAXMESSAGES)
;
	INC	DWORD [ESI+00H]
	CMP	DWORD [ESI+00H],BYTE 064H
	JNE	SHORT	L_117
;
; Line 337:	MsgQueueOnCtr = 0;
;
	MOV	DWORD [ESI+00H],00H
L_117:
;
; Line 338:	MsgQueueCtr++;
;
	INC	DWORD [_MsgQueueCtr]
L_115:
;
; Line 340:	}
;
L_113:
	POP	EDI
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_SendMessage]
;
; Line 343:	int SendMessage(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
;
_SendMessage:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 024H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD [EBP+010H]
L_120:
;
; Line 344:	{
;
;
; Line 345:	int rtn = TRUE, x, y;
;
	MOV	DWORD [EBP-0CH],01H
;
; Line 350:	if (wnd != NULL)
;
	TEST	ESI,ESI
	JE	NEAR	L_121
;
; Line 351:	switch (msg)    {
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,BYTE 021H
	JE	SHORT	L_127
	JA	SHORT	L_133
	CMP	EAX,BYTE 013H
	JE	SHORT	L_131
	JA	SHORT	L_134
	CMP	EAX,BYTE 0AH
	JE	SHORT	L_126
	JA	NEAR	L_124
	CMP	EAX,BYTE 09H
	JE	SHORT	L_125
	JMP	SHORT	L_124
L_134:
	CMP	EAX,BYTE 01CH
	JE	SHORT	L_132
	JMP	SHORT	L_124
L_133:
	CMP	EAX,BYTE 023H
	JE	SHORT	L_129
	JA	SHORT	L_135
	CMP	EAX,BYTE 022H
	JE	SHORT	L_128
	JMP	SHORT	L_124
L_135:
	CMP	EAX,BYTE 025H
	JE	SHORT	L_130
	JMP	SHORT	L_124
L_125:
;
; Line 353:	case BORDER:
;
L_126:
;
; Line 356:	if (isVisible(wnd))
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_136
;
; Line 357:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
L_136:
;
; Line 358:	break;
;
	JMP	SHORT	L_123
L_127:
;
; Line 360:	case LEFT_BUTTON:
;
L_128:
;
; Line 361:	case DOUBLE_CLICK:
;
L_129:
;
; Line 362:	case BUTTON_RELEASED:
;
L_130:
;
; Line 365:	if (isVisible(wnd) || wnd == CaptureMouse)
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JNE	SHORT	L_140
	CMP	ESI,DWORD [_CaptureMouse]
	JNE	SHORT	L_138
L_140:
;
; Line 366:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
L_138:
;
; Line 367:	break;
;
	JMP	SHORT	L_123
L_131:
;
; Line 369:	case SHIFT_CHANGED:
;
L_132:
;
; Line 372:	if (!(isVisible(wnd) || wnd == CaptureKeyboard))
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JNE	SHORT	L_141
	CMP	ESI,DWORD [_CaptureKeyboard]
	JNE	SHORT	L_123
;
; Line 373:	break;
;
L_141:
;
; Line 374:	default:
;
L_124:
;
; Line 375:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
;
; Line 376:	break;
;
	JMP	SHORT	L_123
L_123:
L_121:
;
; Line 380:	if (rtn != FALSE)    {
;
	CMP	DWORD [EBP-0CH],BYTE 00H
	JE	NEAR	L_143
;
; Line 383:	switch (msg)    {
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,BYTE 01DH
	JE	NEAR	L_158
	JA	NEAR	L_170
	CMP	EAX,BYTE 016H
	JE	NEAR	L_150
	JA	SHORT	L_171
	CMP	EAX,BYTE 012H
	JE	NEAR	L_149
	JA	SHORT	L_172
	CMP	EAX,BYTE 011H
	JE	NEAR	L_148
	JA	NEAR	L_146
	CMP	EAX,BYTE 01H
	JE	NEAR	L_147
	JMP	NEAR	L_146
L_172:
	CMP	EAX,BYTE 015H
	JE	NEAR	L_152
	JA	NEAR	L_146
	CMP	EAX,BYTE 014H
	JE	NEAR	L_151
	JMP	NEAR	L_146
L_171:
	CMP	EAX,BYTE 019H
	JE	NEAR	L_157
	JA	SHORT	L_173
	CMP	EAX,BYTE 018H
	JE	NEAR	L_156
	JA	NEAR	L_146
	CMP	EAX,BYTE 017H
	JE	NEAR	L_153
	JMP	NEAR	L_146
L_173:
	CMP	EAX,BYTE 01BH
	JE	NEAR	L_155
	JA	NEAR	L_146
	CMP	EAX,BYTE 01AH
	JE	NEAR	L_154
	JMP	NEAR	L_146
L_170:
	CMP	EAX,BYTE 028H
	JE	NEAR	L_162
	JA	SHORT	L_174
	CMP	EAX,BYTE 020H
	JE	NEAR	L_160
	JA	SHORT	L_175
	CMP	EAX,BYTE 01FH
	JE	NEAR	L_161
	JA	NEAR	L_146
	CMP	EAX,BYTE 01EH
	JE	NEAR	L_159
	JMP	NEAR	L_146
L_175:
	CMP	EAX,BYTE 027H
	JE	NEAR	L_164
	JA	NEAR	L_146
	CMP	EAX,BYTE 026H
	JE	NEAR	L_165
	JMP	NEAR	L_146
L_174:
	CMP	EAX,BYTE 02BH
	JE	NEAR	L_167
	JA	SHORT	L_176
	CMP	EAX,BYTE 02AH
	JE	NEAR	L_166
	JA	NEAR	L_146
	CMP	EAX,BYTE 029H
	JE	NEAR	L_163
	JMP	NEAR	L_146
L_176:
	CMP	EAX,BYTE 02DH
	JE	NEAR	L_169
	JA	NEAR	L_146
	CMP	EAX,BYTE 02CH
	JE	NEAR	L_168
	JMP	NEAR	L_146
L_147:
;
; Line 385:	StopMsg();
;
	CALL	_StopMsg
;
; Line 386:	break;
;
	JMP	NEAR	L_145
L_148:
;
; Line 389:	if (Cwnd == NULL)
;
	CMP	DWORD [_Cwnd],BYTE 00H
	JNE	SHORT	L_177
;
; Line 390:	set_timer(clocktimer, 0);
;
	MOV	DWORD [_clocktimer],01H
L_177:
;
; Line 391:	wnd->PrevClock = Cwnd;
;
	MOV	EAX,DWORD [_Cwnd]
	MOV	DWORD [ESI+07CH],EAX
;
; Line 392:	Cwnd = wnd;
;
	MOV	DWORD [_Cwnd],ESI
;
; Line 393:	break;
;
	JMP	NEAR	L_145
L_149:
;
; Line 395:	Cwnd = wnd->PrevClock;
;
	MOV	EAX,DWORD [ESI+07CH]
	MOV	DWORD [_Cwnd],EAX
;
; Line 396:	if (Cwnd == NULL)
;
	CMP	DWORD [_Cwnd],BYTE 00H
	JNE	SHORT	L_179
;
; Line 397:	disable_timer(clocktimer);
;
	MOV	DWORD [_clocktimer],0FFFFFFFFH
L_179:
;
; Line 398:	break;
;
	JMP	NEAR	L_145
L_150:
;
; Line 401:	if (wnd == NULL)
;
	TEST	ESI,ESI
	JNE	SHORT	L_181
;
; Line 402:	cursor((int)p1, (int)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_cursor
	ADD	ESP,BYTE 08H
	JMP	NEAR	L_182
L_181:
;
; Line 403:	else if (wnd == inFocus)
;
	CMP	ESI,DWORD [_inFocus]
	JNE	NEAR	L_183
;
; Line 404:	cursor(GetClientLeft(wnd)+(int)p1,
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_185
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_185
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_185
	MOV	EAX,03H
	JMP	SHORT	L_186
L_185:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_190
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_189
L_190:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_187
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_187
L_189:
	MOV	EAX,02H
	JMP	SHORT	L_188
L_187:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_191
	MOV	EAX,01H
	JMP	SHORT	L_192
L_191:
	MOV	EAX,00H
L_192:
L_188:
L_186:
	ADD	EAX,DWORD [ESI+010H]
	ADD	EAX,DWORD [EBP+014H]
	PUSH	EAX
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_193
	MOV	EAX,01H
	JMP	SHORT	L_194
L_193:
	MOV	EAX,00H
L_194:
	ADD	EAX,DWORD [ESI+0CH]
	ADD	EAX,EBX
	PUSH	EAX
	CALL	_cursor
	ADD	ESP,BYTE 08H
L_183:
L_182:
;
; Line 406:	break;
;
	JMP	NEAR	L_145
L_151:
;
; Line 408:	if (p2)
;
	CMP	DWORD [EBP+014H],BYTE 00H
	JE	SHORT	L_195
;
; Line 409:	((WINDOW)p2)->PrevKeyboard=CaptureKeyboard;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	ECX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EAX+078H],ECX
	JMP	SHORT	L_196
L_195:
;
; Line 411:	wnd->PrevKeyboard = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [ESI+078H],EAX
L_196:
;
; Line 412:	CaptureKeyboard = wnd;
;
	MOV	DWORD [_CaptureKeyboard],ESI
;
; Line 413:	NoChildCaptureKeyboard = (int)p1;
;
	MOV	DWORD [_NoChildCaptureKeyboard],EBX
;
; Line 414:	break;
;
	JMP	NEAR	L_145
L_152:
;
; Line 416:	if (wnd != NULL)	{
;
	TEST	ESI,ESI
	JE	SHORT	L_197
;
; Line 417:	if (CaptureKeyboard == wnd || (int)p1)
;
	CMP	DWORD [_CaptureKeyboard],ESI
	JE	SHORT	L_201
	TEST	EBX,EBX
	JE	SHORT	L_199
L_201:
;
; Line 418:	CaptureKeyboard = wnd->PrevKeyboard;
;
	MOV	EAX,DWORD [ESI+078H]
	MOV	DWORD [_CaptureKeyboard],EAX
	JMP	SHORT	L_200
L_199:
;
; Line 420:	WINDOW twnd = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EBP-024H],EAX
	JMP	SHORT	L_202
L_204:
;
; Line 422:	if (twnd->PrevKeyboard == wnd)	{
;
	MOV	EAX,DWORD [EBP-024H]
	CMP	DWORD [EAX+078H],ESI
	JNE	SHORT	L_205
;
; Line 423:	twnd->PrevKeyboard = wnd->PrevKeyboard;
;
	MOV	EAX,DWORD [EBP-024H]
	MOV	ECX,DWORD [ESI+078H]
	MOV	DWORD [EAX+078H],ECX
;
; Line 424:	break;
;
	JMP	SHORT	L_203
L_205:
;
; Line 426:	twnd = twnd->PrevKeyboard;
;
	MOV	EAX,DWORD [EBP-024H]
	MOV	EAX,DWORD [EAX+078H]
	MOV	DWORD [EBP-024H],EAX
L_202:
;
; Line 421:	while (twnd != NULL)	{
;
	CMP	DWORD [EBP-024H],BYTE 00H
	JNE	SHORT	L_204
L_203:
;
; Line 428:	if (twnd == NULL)
;
	CMP	DWORD [EBP-024H],BYTE 00H
	JNE	SHORT	L_207
;
; Line 429:	CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
L_207:
L_200:
;
; Line 431:	wnd->PrevKeyboard = NULL;
;
	MOV	DWORD [ESI+078H],00H
	JMP	SHORT	L_198
L_197:
;
; Line 434:	CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
L_198:
;
; Line 435:	NoChildCaptureKeyboard = FALSE;
;
	MOV	DWORD [_NoChildCaptureKeyboard],00H
;
; Line 436:	break;
;
	JMP	NEAR	L_145
L_153:
;
; Line 438:	curr_cursor(&x, &y);
;
	LEA	EAX,[EBP-04H]
	PUSH	EAX
	LEA	EAX,[EBP-08H]
	PUSH	EAX
	CALL	_curr_cursor
	ADD	ESP,BYTE 08H
;
; Line 439:	*(int*)p1 = x;
;
	MOV	EAX,DWORD [EBP-08H]
	MOV	DWORD [EBX+00H],EAX
;
; Line 440:	*(int*)p2 = y;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	ECX,DWORD [EBP-04H]
	MOV	DWORD [EAX+00H],ECX
;
; Line 441:	break;
;
	JMP	NEAR	L_145
L_154:
;
; Line 443:	savecursor();
;
	CALL	_savecursor
;
; Line 444:	break;
;
	JMP	NEAR	L_145
L_155:
;
; Line 446:	restorecursor();
;
	CALL	_restorecursor
;
; Line 447:	break;
;
	JMP	NEAR	L_145
L_156:
;
; Line 449:	normalcursor();
;
	CALL	_normalcursor
;
; Line 450:	hidecursor();
;
	CALL	_hidecursor
;
; Line 451:	break;
;
	JMP	NEAR	L_145
L_157:
;
; Line 453:	if (p1)
;
	TEST	EBX,EBX
	JE	SHORT	L_209
;
; Line 454:	set_cursor_type(0x0607);
;
	PUSH	DWORD 0607H
	CALL	_set_cursor_type
	POP	ECX
	JMP	SHORT	L_210
L_209:
;
; Line 456:	set_cursor_type(0x0106);
;
	PUSH	DWORD 0106H
	CALL	_set_cursor_type
	POP	ECX
L_210:
;
; Line 457:	unhidecursor();
;
	CALL	_unhidecursor
;
; Line 458:	break;
;
	JMP	NEAR	L_145
L_158:
	JMP	SHORT	L_211
L_213:
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
L_211:
;
; Line 460:	waitforkeyboard();
;
	MOV	EAX,DWORD [_keyportvalue]
	AND	EAX,080H
	JE	SHORT	L_213
L_212:
;
; Line 461:	break;
;
	JMP	NEAR	L_145
L_159:
;
; Line 464:	resetmouse();
;
	CALL	_resetmouse
;
; Line 465:	set_mousetravel(0, SCREENWIDTH-1, 0, SCREENHEIGHT-1);
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_216
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_214
L_216:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_215
L_214:
	MOV	EAX,019H
L_215:
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 466:	break;
;
	JMP	NEAR	L_145
L_160:
;
; Line 468:	rtn = mouse_installed();
;
	CALL	_mouse_installed
	MOV	DWORD [EBP-0CH],EAX
;
; Line 469:	break;
;
	JMP	NEAR	L_145
L_161:
;
; Line 472:	if (!p1)	{
;
	TEST	EBX,EBX
	JNE	SHORT	L_217
;
; Line 473:	rc.lf = rc.tp = 0;
;
	MOV	DWORD [EBP-01CH],00H
	MOV	DWORD [EBP-020H],00H
;
; Line 474:	rc.rt = SCREENWIDTH-1;
;
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	MOV	DWORD [EBP-018H],EAX
;
; Line 475:	rc.bt = SCREENHEIGHT-1;
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_221
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_219
L_221:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_220
L_219:
	MOV	EAX,019H
L_220:
	DEC	EAX
	MOV	DWORD [EBP-014H],EAX
	JMP	SHORT	L_218
L_217:
;
; Line 478:	rc = *(RECT *)p1;
;
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBX+00H]
	LEA	EDI,[EBP-020H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
L_218:
;
; Line 479:	set_mousetravel(rc.lf, rc.rt, rc.tp, rc.bt);
;
	PUSH	DWORD [EBP-014H]
	PUSH	DWORD [EBP-01CH]
	PUSH	DWORD [EBP-018H]
	PUSH	DWORD [EBP-020H]
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 480:	break;
;
	JMP	NEAR	L_145
L_162:
;
; Line 483:	show_mousecursor();
;
	CALL	_show_mousecursor
;
; Line 484:	break;
;
	JMP	NEAR	L_145
L_163:
;
; Line 486:	hide_mousecursor();
;
	CALL	_hide_mousecursor
;
; Line 487:	break;
;
	JMP	NEAR	L_145
L_164:
;
; Line 489:	set_mouseposition((int)p1, (int)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_set_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 490:	break;
;
	JMP	NEAR	L_145
L_165:
;
; Line 492:	get_mouseposition((int*)p1,(int*)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_get_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 493:	break;
;
	JMP	NEAR	L_145
L_166:
;
; Line 495:	waitformouse();
;
L_222:
	CALL	_mousebuttons
	TEST	EAX,EAX
	JNE	SHORT	L_222
;
; Line 496:	break;
;
	JMP	NEAR	L_145
L_167:
;
; Line 498:	rtn = mousebuttons();
;
	CALL	_mousebuttons
	MOV	DWORD [EBP-0CH],EAX
;
; Line 499:	break;
;
	JMP	NEAR	L_145
L_168:
;
; Line 501:	if (p2)
;
	CMP	DWORD [EBP+014H],BYTE 00H
	JE	SHORT	L_223
;
; Line 502:	((WINDOW)p2)->PrevMouse = CaptureMouse;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	ECX,DWORD [_CaptureMouse]
	MOV	DWORD [EAX+074H],ECX
	JMP	SHORT	L_224
L_223:
;
; Line 504:	wnd->PrevMouse = CaptureMouse;
;
	MOV	EAX,DWORD [_CaptureMouse]
	MOV	DWORD [ESI+074H],EAX
L_224:
;
; Line 505:	CaptureMouse = wnd;
;
	MOV	DWORD [_CaptureMouse],ESI
;
; Line 506:	NoChildCaptureMouse = (int)p1;
;
	MOV	DWORD [_NoChildCaptureMouse],EBX
;
; Line 507:	break;
;
	JMP	SHORT	L_145
L_169:
;
; Line 509:	if (wnd != NULL)	{
;
	TEST	ESI,ESI
	JE	SHORT	L_225
;
; Line 510:	if (CaptureMouse == wnd || (int)p1)
;
	CMP	DWORD [_CaptureMouse],ESI
	JE	SHORT	L_229
	TEST	EBX,EBX
	JE	SHORT	L_227
L_229:
;
; Line 511:	CaptureMouse = wnd->PrevMouse;
;
	MOV	EAX,DWORD [ESI+074H]
	MOV	DWORD [_CaptureMouse],EAX
	JMP	SHORT	L_228
L_227:
;
; Line 513:	WINDOW twnd = CaptureMouse;
;
	MOV	EDI,DWORD [_CaptureMouse]
	JMP	SHORT	L_230
L_232:
;
; Line 515:	if (twnd->PrevMouse == wnd)	{
;
	CMP	DWORD [EDI+074H],ESI
	JNE	SHORT	L_233
;
; Line 516:	twnd->PrevMouse = wnd->PrevMouse;
;
	MOV	EAX,DWORD [ESI+074H]
	MOV	DWORD [EDI+074H],EAX
;
; Line 517:	break;
;
	JMP	SHORT	L_231
L_233:
;
; Line 519:	twnd = twnd->PrevMouse;
;
	MOV	EDI,DWORD [EDI+074H]
L_230:
;
; Line 514:	while (twnd != NULL)	{
;
	TEST	EDI,EDI
	JNE	SHORT	L_232
L_231:
;
; Line 521:	if (twnd == NULL)
;
	TEST	EDI,EDI
	JNE	SHORT	L_235
;
; Line 522:	CaptureMouse = NULL;
;
	MOV	DWORD [_CaptureMouse],00H
L_235:
L_228:
;
; Line 524:	wnd->PrevMouse = NULL;
;
	MOV	DWORD [ESI+074H],00H
	JMP	SHORT	L_226
L_225:
;
; Line 527:	CaptureMouse = NULL;
;
	MOV	DWORD [_CaptureMouse],00H
L_226:
;
; Line 528:	NoChildCaptureMouse = FALSE;
;
	MOV	DWORD [_NoChildCaptureMouse],00H
;
; Line 529:	break;
;
	JMP	SHORT	L_145
L_146:
;
; Line 531:	break;
;
	JMP	SHORT	L_145
L_145:
L_143:
;
; Line 534:	return rtn;
;
	MOV	EAX,DWORD [EBP-0CH]
L_119:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 537:	static RECT VisibleRect(WINDOW wnd)
;
_VisibleRect:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 024H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	EDI,[EBP-010H]
	LEA	EBX,[EBP-024H]
L_238:
;
; Line 538:	{
;
;
; Line 539:	RECT rc = WindowRect(wnd);
;
	MOV	EAX,DWORD [EBP+0CH]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+0CH]
	PUSH	ES
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	ES
	POP	EDI
	POP	ESI
;
; Line 540:	if (!TestAttribute(wnd, NOCLIP))	{
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	EAX,DWORD [EAX+054H]
	AND	EAX,0800H
	JNE	SHORT	L_239
;
; Line 541:	WINDOW pwnd = GetParent(wnd);
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	ESI,DWORD [EAX+03CH]
;
; Line 543:	prc = ClientRect(pwnd);
;
	PUSH	ESI
	PUSH	EBX
	CALL	_ClientRect
	ADD	ESP,BYTE 08H
	JMP	SHORT	L_241
L_243:
;
; Line 545:	if (TestAttribute(pwnd, NOCLIP))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0800H
	JNE	SHORT	L_242
;
; Line 546:	break;
;
L_244:
;
; Line 547:	rc = subRectangle(rc, prc);
;
	PUSH	DWORD [SS:EBX+00H+0CH]
	PUSH	DWORD [SS:EBX+00H+08H]
	PUSH	DWORD [SS:EBX+00H+04H]
	PUSH	DWORD [SS:EBX+00H+00H]
	PUSH	DWORD [SS:EDI+00H+0CH]
	PUSH	DWORD [SS:EDI+00H+08H]
	PUSH	DWORD [SS:EDI+00H+04H]
	PUSH	DWORD [SS:EDI+00H+00H]
	PUSH	EDI
	CALL	_subRectangle
	ADD	ESP,BYTE 024H
;
; Line 548:	if (!ValidRect(rc))
;
	CMP	DWORD [SS:EDI+08H],BYTE 00H
	JNE	SHORT	L_246
	CMP	DWORD [SS:EDI+00H],BYTE 00H
	JNE	SHORT	L_246
	CMP	DWORD [SS:EDI+04H],BYTE 00H
	JNE	SHORT	L_246
	CMP	DWORD [SS:EDI+0CH],BYTE 00H
	JE	SHORT	L_242
;
; Line 549:	break;
;
L_246:
;
; Line 550:	if ((pwnd = GetParent(pwnd)) != NULL)
;
	MOV	ESI,DWORD [ESI+03CH]
	TEST	ESI,ESI
	JE	SHORT	L_248
;
; Line 551:	prc = ClientRect(pwnd);
;
	PUSH	ESI
	PUSH	EBX
	CALL	_ClientRect
	ADD	ESP,BYTE 08H
L_248:
L_241:
;
; Line 544:	while (pwnd != NULL)	{
;
	TEST	ESI,ESI
	JNE	SHORT	L_243
L_242:
L_239:
;
; Line 554:	return rc;
;
	MOV	EAX,DWORD [EBP+08H]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EDI+00H]
	LEA	EDI,[EAX+00H]
	PUSH	DS
	PUSH	SS
	PUSH	SS
	POP	ES
	POP	DS
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	DS
	POP	EDI
	POP	ESI
	MOV	EAX,DWORD [EBP+08H]
L_237:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 558:	static WINDOW inWindow(WINDOW wnd, int x, int y)
;
_inWindow:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 020H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
L_251:
;
; Line 559:	{
;
;
; Line 560:	WINDOW Hit = NULL;
;
	MOV	EBX,00H
	JMP	SHORT	L_252
L_254:
;
; Line 562:	if (isVisible(wnd))	{
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_255
;
; Line 564:	RECT rc = VisibleRect(wnd);
;
	PUSH	ESI
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_VisibleRect
	ADD	ESP,BYTE 08H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+00H]
	LEA	EDI,[EBP-020H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 565:	if (InsideRect(x, y, rc))
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,DWORD [EBP-020H]
	JL	SHORT	L_257
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,DWORD [EBP-018H]
	JG	SHORT	L_257
	MOV	EAX,DWORD [EBP+010H]
	CMP	EAX,DWORD [EBP-01CH]
	JL	SHORT	L_257
	MOV	EAX,DWORD [EBP+010H]
	CMP	EAX,DWORD [EBP-014H]
	JG	SHORT	L_257
;
; Line 566:	Hit = wnd;
;
	MOV	EBX,ESI
L_257:
;
; Line 567:	if ((wnd1 = inWindow(LastWindow(wnd), x, y)) != NULL)
;
	PUSH	DWORD [EBP+010H]
	PUSH	DWORD [EBP+0CH]
	PUSH	DWORD [ESI+044H]
	CALL	_inWindow
	ADD	ESP,BYTE 0CH
	MOV	EDI,EAX
	TEST	EAX,EAX
	JE	SHORT	L_259
;
; Line 568:	Hit = wnd1;
;
	MOV	EBX,EDI
L_259:
;
; Line 569:	if (Hit != NULL)
;
	TEST	EBX,EBX
	JNE	SHORT	L_253
;
; Line 570:	break;
;
L_261:
L_255:
;
; Line 572:	wnd = PrevWindow(wnd);
;
	MOV	ESI,DWORD [ESI+04CH]
L_252:
;
; Line 561:	while (wnd != NULL)	{
;
	TEST	ESI,ESI
	JNE	SHORT	L_254
L_253:
;
; Line 574:	return Hit;
;
	MOV	EAX,EBX
L_250:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 577:	static WINDOW MouseWindow(int x, int y)
;
_MouseWindow:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD _CaptureMouse
L_264:
;
; Line 578:	{
;
;
; Line 581:	WINDOW Mwnd = inWindow(ApplicationWindow, x, y);
;
	PUSH	DWORD [EBP+0CH]
	PUSH	DWORD [EBP+08H]
	PUSH	DWORD [_ApplicationWindow]
	CALL	_inWindow
	ADD	ESP,BYTE 0CH
	MOV	EBX,EAX
;
; Line 583:	if (CaptureMouse != NULL)	{
;
	CMP	DWORD [ESI+00H],BYTE 00H
	JE	SHORT	L_265
;
; Line 584:	if (NoChildCaptureMouse ||
;
	CMP	DWORD [_NoChildCaptureMouse],BYTE 00H
	JNE	SHORT	L_269
	TEST	EBX,EBX
	JE	SHORT	L_269
	PUSH	DWORD [ESI+00H]
	PUSH	EBX
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JNE	SHORT	L_267
L_269:
;
; Line 587:	Mwnd = CaptureMouse;
;
	MOV	EBX,DWORD [ESI+00H]
L_267:
L_265:
;
; Line 589:	return Mwnd;
;
	MOV	EAX,EBX
L_263:
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_handshake]
;
; Line 592:	void handshake(void)
;
_handshake:
L_271:
;
; Line 593:	{
;
;
; Line 594:	handshaking++;
;
	INC	DWORD [_handshaking]
;
; Line 595:	dispatch_message();
;
	CALL	_dispatch_message
;
; Line 596:	--handshaking;
;
	DEC	DWORD [_handshaking]
;
; Line 597:	}
;
L_270:
	RET
[GLOBAL	_dispatch_message]
;
; Line 600:	BOOL dispatch_message(void)
;
_dispatch_message:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 018H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP-014H]
	MOV	EDI,DWORD _MsgQueueOffCtr
L_273:
;
; Line 601:	{
;
;
; Line 604:	collect_events();
;
	CALL	_collect_events
	JMP	NEAR	L_274
L_276:
;
; Line 609:	ev = EventQueue[EventQueueOffCtr];
;
	MOV	EAX,DWORD [_EventQueueOffCtr]
	IMUL	EAX,BYTE 0CH
	MOV	ECX,DWORD [EAX+_EventQueue+00H]
	MOV	DWORD [SS:ESI+00H],ECX
	MOV	ECX,DWORD [EAX+_EventQueue+00H+04H]
	MOV	DWORD [SS:ESI+00H+04H],ECX
	MOV	ECX,DWORD [EAX+_EventQueue+00H+04H+04H]
	MOV	DWORD [SS:ESI+00H+04H+04H],ECX
;
; Line 610:	if (++EventQueueOffCtr == MAXMESSAGES)
;
	INC	DWORD [_EventQueueOffCtr]
	CMP	DWORD [_EventQueueOffCtr],BYTE 064H
	JNE	SHORT	L_277
;
; Line 611:	EventQueueOffCtr = 0;
;
	MOV	DWORD [_EventQueueOffCtr],00H
L_277:
;
; Line 612:	--EventQueueCtr;
;
	DEC	DWORD [_EventQueueCtr]
;
; Line 616:	Kwnd = inFocus;
;
	MOV	EAX,DWORD [_inFocus]
	MOV	DWORD [EBP-04H],EAX
;
; Line 619:	if (CaptureKeyboard != NULL)
;
	CMP	DWORD [_CaptureKeyboard],BYTE 00H
	JE	SHORT	L_279
;
; Line 620:	if (Kwnd == NULL ||
;
	CMP	DWORD [EBP-04H],BYTE 00H
	JE	SHORT	L_283
	CMP	DWORD [_NoChildCaptureKeyboard],BYTE 00H
	JNE	SHORT	L_283
	PUSH	DWORD [_CaptureKeyboard]
	PUSH	DWORD [EBP-04H]
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JNE	SHORT	L_281
L_283:
;
; Line 623:	Kwnd = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EBP-04H],EAX
L_281:
L_279:
;
; Line 627:	switch (ev.event)    {
;
	MOV	EAX,DWORD [SS:ESI+00H]
	CMP	EAX,BYTE 022H
	JE	NEAR	L_288
	JA	SHORT	L_294
	CMP	EAX,BYTE 01CH
	JE	SHORT	L_286
	JA	SHORT	L_295
	CMP	EAX,BYTE 013H
	JE	SHORT	L_287
	JA	NEAR	L_285
	CMP	EAX,BYTE 010H
	JE	NEAR	L_293
	JMP	NEAR	L_285
L_295:
	CMP	EAX,BYTE 021H
	JE	NEAR	L_291
	JMP	NEAR	L_285
L_294:
	CMP	EAX,BYTE 024H
	JE	NEAR	L_292
	JA	SHORT	L_296
	CMP	EAX,BYTE 023H
	JE	NEAR	L_290
	JMP	NEAR	L_285
L_296:
	CMP	EAX,BYTE 025H
	JE	NEAR	L_289
	JMP	NEAR	L_285
L_286:
;
; Line 629:	case KEYBOARD:
;
L_287:
;
; Line 630:	if (!handshaking)
;
	CMP	DWORD [_handshaking],BYTE 00H
	JNE	SHORT	L_297
;
; Line 631:	SendMessage(Kwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	MOVSX	EAX,WORD [SS:ESI+00H]
	PUSH	EAX
	PUSH	DWORD [EBP-04H]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_297:
;
; Line 632:	break;
;
	JMP	NEAR	L_284
L_288:
;
; Line 634:	if (!handshaking)	{
;
	CMP	DWORD [_handshaking],BYTE 00H
	JNE	SHORT	L_299
;
; Line 635:	Mwnd = MouseWindow(ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	CALL	_MouseWindow
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
;
; Line 636:	if (!CaptureMouse ||
;
	CMP	DWORD [_CaptureMouse],BYTE 00H
	JE	SHORT	L_303
	CMP	DWORD [_NoChildCaptureMouse],BYTE 00H
	JNE	SHORT	L_301
	PUSH	DWORD [_CaptureMouse]
	PUSH	EBX
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JE	SHORT	L_301
L_303:
;
; Line 639:	if (Mwnd != inFocus)
;
	CMP	EBX,DWORD [_inFocus]
	JE	SHORT	L_304
;
; Line 640:	SendMessage(Mwnd, SETFOCUS, TRUE, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 01H
	PUSH	BYTE 08H
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_304:
L_301:
;
; Line 641:	SendMessage(Mwnd, LEFT_BUTTON, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	PUSH	BYTE 022H
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_299:
;
; Line 643:	break;
;
	JMP	SHORT	L_284
L_289:
;
; Line 645:	case DOUBLE_CLICK:
;
L_290:
;
; Line 646:	case RIGHT_BUTTON:
;
L_291:
;
; Line 647:	if (handshaking)
;
	CMP	DWORD [_handshaking],BYTE 00H
	JNE	SHORT	L_284
;
; Line 648:	break;
;
L_306:
;
; Line 649:	case MOUSE_MOVED:
;
L_292:
;
; Line 650:	Mwnd = MouseWindow(ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	CALL	_MouseWindow
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
;
; Line 651:	SendMessage(Mwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	MOVSX	EAX,WORD [SS:ESI+00H]
	PUSH	EAX
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 652:	break;
;
	JMP	SHORT	L_284
L_293:
;
; Line 654:	SendMessage(Cwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	MOVSX	EAX,WORD [SS:ESI+00H]
	PUSH	EAX
	PUSH	DWORD [_Cwnd]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 655:	break;
;
	JMP	SHORT	L_284
L_285:
;
; Line 657:	break;
;
	JMP	SHORT	L_284
L_284:
L_274:
;
; Line 606:	while (EventQueueCtr > 0)  {
;
	CMP	DWORD [_EventQueueCtr],BYTE 00H
	JG	NEAR	L_276
L_275:
	JMP	SHORT	L_308
L_310:
;
; Line 664:	mq = MsgQueue[MsgQueueOffCtr];
;
	MOV	EAX,DWORD [EDI+00H]
	SHL	EAX,04H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+_MsgQueue+00H]
	LEA	EDI,[EBP-018H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 665:	if (++MsgQueueOffCtr == MAXMESSAGES)
;
	INC	DWORD [EDI+00H]
	CMP	DWORD [EDI+00H],BYTE 064H
	JNE	SHORT	L_311
;
; Line 666:	MsgQueueOffCtr = 0;
;
	MOV	DWORD [EDI+00H],00H
L_311:
;
; Line 667:	--MsgQueueCtr;
;
	DEC	DWORD [_MsgQueueCtr]
;
; Line 668:	SendMessage(mq.wnd, mq.msg, mq.p1, mq.p2);
;
	PUSH	DWORD [EBP-0CH]
	PUSH	DWORD [EBP-010H]
	MOVSX	EAX,WORD [EBP-014H]
	PUSH	EAX
	PUSH	DWORD [EBP-018H]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 669:	if (mq.msg == ENDDIALOG)
;
	CMP	DWORD [EBP-014H],BYTE 049H
	JNE	SHORT	L_313
;
; Line 670:	return FALSE;
;
	MOV	EAX,00H
	JMP	SHORT	L_272
L_313:
;
; Line 671:	if (mq.msg == STOP)	{
;
	CMP	DWORD [EBP-014H],BYTE 01H
	JNE	SHORT	L_315
;
; Line 672:	PostMessage(NULL, STOP, 0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 01H
	PUSH	BYTE 00H
	CALL	_PostMessage
	ADD	ESP,BYTE 010H
;
; Line 673:	return FALSE;
;
	MOV	EAX,00H
	JMP	SHORT	L_272
L_315:
L_308:
;
; Line 661:	while (MsgQueueCtr > 0)  {
;
	CMP	DWORD [_MsgQueueCtr],BYTE 00H
	JG	SHORT	L_310
L_309:
;
; Line 676:	return TRUE;
;
	MOV	EAX,01H
L_272:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
SECTION _STRING
L_47:
	DB	061H,06DH,020H,00H
L_46:
	DB	070H,06DH,020H,00H
L_45:
	DB	025H,032H,064H,03AH,025H,030H,032H,064H,00H
L_13:
	DB	020H,043H,061H,06EH,063H,065H,06CH,020H,00H
L_12:
	DB	020H,020H,020H,04FH,04BH,020H,020H,020H,00H
L_11:
	DB	045H,072H,072H,06FH,072H,00H
SECTION _DATA

_px	DD	0FFFFFFFFH

_py	DD	0FFFFFFFFH

_pmx	DD	0FFFFFFFFH

_pmy	DD	0FFFFFFFFH

_handshaking	DD	00H
[GLOBAL	_AllocTesting]

_AllocTesting	DD	00H
[GLOBAL	_AltDown]

_AltDown	DD	00H

_lagdelay	DD	07H

_doubletimer	DD	0FFFFFFFFH

_delaytimer	DD	0FFFFFFFFH

_clocktimer	DD	0FFFFFFFFH
[GLOBAL	_time_string]

_time_string	DB	020H,020H,020H,020H,020H,020H,020H,020H,020H,00H
	RESB	02H

_ermsg	DB	045H,072H,072H,06FH,072H,020H,061H,063H,063H,065H,073H,073H
	DB	069H,06EH,067H,020H,064H,072H,069H,076H,065H,020H,078H,00H

L_43	DD	00H

L_44	DD	00H

L_48	DD	010B9H,010CFH,010D0H,010D1H,010CBH
	DD	035H,010CDH,010C7H,010C8H,010C9H
SECTION _BSS

_mx	RESB	04H

_my	RESB	04H

_CriticalError	RESB	04H

_timerMemhand	RESB	04H

_dsSel	RESB	02H

_oldss	RESB	02H

_oldsp	RESB	04H

_hasints	RESB	04H

_timerLast	RESB	06H
	RESB	02H

_keyboardLast	RESB	06H
	RESB	02H

_stackbot	RESB	04H
[GLOBAL	_AllocError]

_AllocError	RESB	028H

_EventQueue	RESB	04B0H

_MsgQueue	RESB	0640H

_EventQueueOnCtr	RESB	04H

_EventQueueOffCtr	RESB	04H

_EventQueueCtr	RESB	04H

_MsgQueueOnCtr	RESB	04H

_MsgQueueOffCtr	RESB	04H

_MsgQueueCtr	RESB	04H

_keyportvalue	RESB	04H
[GLOBAL	_CaptureMouse]

_CaptureMouse	RESB	04H
[GLOBAL	_CaptureKeyboard]

_CaptureKeyboard	RESB	04H

_NoChildCaptureMouse	RESB	04H

_NoChildCaptureKeyboard	RESB	04H

_Cwnd	RESB	04H
SECTION _CONST

SECTION _TEXT
[EXTERN	_sprintf]
[EXTERN	_ConsoleInit]
[EXTERN	_ErrorBoxProc]
[EXTERN	_time]
[EXTERN	_GenericMessage]
[EXTERN	_ClientRect]
[EXTERN	_show_mousecursor]
[EXTERN	_unhidecursor]
[EXTERN	_inFocus]
[EXTERN	_set_mouseposition]
[EXTERN	_dpmi_set_protected_interrupt]
[EXTERN	_isVisible]
[EXTERN	_dpmi_get_sel_base]
[EXTERN	_hide_mousecursor]
[EXTERN	_mousebuttons]
[EXTERN	_restorecursor]
[EXTERN	_isEGA]
[EXTERN	_localtime]
[EXTERN	_kbhit]
[EXTERN	_hidecursor]
[EXTERN	_set_cursor_type]
[EXTERN	_set_mousetravel]
[EXTERN	_isAncestor]
[EXTERN	_setjmp]
[EXTERN	_normalcursor]
[EXTERN	_isVGA]
[EXTERN	_cursor]
[EXTERN	_ApplicationWindow]
[EXTERN	_getkey]
[EXTERN	_curr_cursor]
[EXTERN	_ClearDialogBoxes]
[EXTERN	_resetmouse]
[EXTERN	_getshift]
[EXTERN	_ClearClipboard]
[EXTERN	_subRectangle]
[EXTERN	_setvect]
[EXTERN	_inp]
[EXTERN	_get_mouseposition]
[EXTERN	___seg0040]
[EXTERN	_mouse_installed]
[EXTERN	_ConsoleRundown]
[EXTERN	_button_releases]
[EXTERN	_dpmi_get_memory]
[EXTERN	_savecursor]
[EXTERN	_dpmi_get_protected_interrupt]
[EXTERN	_dpmi_free_memory]
[EXTERN	_strcpy]
