/* 
CCIDE
Copyright 2001-2006 David Lindauer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

You may contact the author at:
	mailto::camille@bluegrass.net
 */
 
#pragma pack(1)
#define GRIPWIDTH 15

#define LCF_ADJUSTRECT WM_USER + 1
#define LCF_SETFLEX WM_USER + 2
#define LCF_SETVERTICAL WM_USER + 3
#define LCF_CONTAINER WM_USER + 4
#define LCF_SETACTIVE WM_USER + 5

#define TCF_SETHEADER (TV_FIRST + 120)
#define TCF_SETDIVIDER (TV_FIRST + 121)

#define TCN_PAINT (TV_FIRST + 150)
#define TCN_EDITDONE (TV_FIRST + 151)
#define TCN_EDITQUERY (TV_FIRST + 152) 

#define TCS_LINE 0x1000
#undef TV_FIRST
#undef HDM_FIRST
#define TV_FIRST 0x1100
#define HDM_FIRST 0x1200

#define DOCK_PRESENT 0x8000
#define DOCK_LEFT 1
#define DOCK_TOP 2
#define DOCK_RIGHT 4
#define DOCK_BOTTOM 8
#define DOCK_AMONG 16

#define FLEX_REQ 1
#define FLEX_UNREQ 2
#define FLEX_SMALL 4
#define FLEX_LARGE 8

typedef struct
{
    int flags;
    int oldflags;
    int hidden;
    int flexparams;
    int rowindex; // row for top & bottom, col for other
    int colindex; // col for top & bottom, row for other 
    int hiddenwidth; // adjusted width for top & bottom, height for other
    RECT oldsize;
    RECT position;
    RECT lastposition;
    RECT flexposition;
} CCD_params;

typedef struct
{
    char *colText1;
    char *colText2;
    HBITMAP colBmp1;
    HBITMAP colBmp2;
} TCHeader;

typedef struct
{
    char *col1Text;
    char *col2Text;
    DWORD col1Color;
    DWORD col2Color;
} TCData;

#define LSCONTROL 1
#define LSTOOLBAR 2
#define LSMENU 3
#define LSGRIP 4
#define LSBLANK 5
#define LSTBCONT 6

typedef struct
{
    int type;
    int id;
    int vertical;
    short container;
    short active;
    HWND self;
    char *title;
    HWND parent;
    union
    {
        struct 
        {
            RECT position;
            CCD_params *representative_dock;
        } bw;
        struct
        {
            int flexed;
            int disabled;
            HWND closebutton;
            HWND flexbutton;
            HWND containerclosebutton;
        } cw;
        struct
        {
            int width;
            int height;
            TBBUTTON *buttons;
            int btncount;
            char **hints;
            int bmpid;
            int bmpcount;
            int helpitem;
            HWND hWnd, vWnd;
            SIZE hsize, vsize;
            HWND notifyparent;
        } tb;
        struct
        {
            HWND child;
            HWND directchild;
        } gp;
    }
    u;
}

//-------------------------------------------------------------------------

CCW_params;

typedef struct
{
    int vertical;
    HWND self;
    RECT position;
} CFW_params;

#pragma pack()
