/* 
CC386 C Compiler
Copyright 1994-2006 David Lindauer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

This program is derived from the cc68k complier by 
Matthew Brandt (mailto::mattb@walkingdog.net) 

You may contact the author of this derivative at:

mailto::camille@bluegrass.net
 */

#include <stdio.h>
#include <stdlib.h>

void fatal(char *name)
{
    perror(name);
    exit(1);
}

//-------------------------------------------------------------------------

int main(int argc, char *argv[])
{
    int ch1, ch2;
    FILE *f;

    if (argc != 2)
        printf("Correct in header of .EXE file MaxMemory == MinMemory\n"
            "Usage : MAXeqMIN.EXE filename\n");
    else
    {

        f = fopen(argv[1], "r+b");

        if (!f)
            fatal(argv[1]);

        if (fseek(f, 0x0, SEEK_SET) ==  - 1L)
            fatal(argv[1]);

        ch1 = fgetc(f);
        ch2 = fgetc(f);

        if (!((ch1 == 'M' && ch2 == 'Z') || (ch1 == 'Z' && ch2 == 'M')))
            fatal("Error format .EXE file !");

        if (fseek(f, 0x0A, SEEK_SET) ==  - 1L)
            fatal(argv[1]);

        ch1 = fgetc(f);
        ch2 = fgetc(f);

        if (fseek(f, 0x0C, SEEK_SET) ==  - 1L)
            fatal(argv[1]);

        if (fputc(ch1, f) == EOF || fputc(ch2, f) == EOF)
            fatal("Error write to file !");

        fclose(f);
        printf("%s : Correct Ok!\n", argv[1]);
    }
    return 0;
}
