/* 
Browse Linker
Copyright 2003-2006 David Lindauer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

You may contact the author at:
	mailto::camille@bluegrass.net
 */
#include <stdio.h>
#include "cmdline.h"
#include "browse.h"
#include "umem.h"
#include "dict.h"

extern int dictpages;
extern HASHREC **symhash;

extern char **filelist;
extern int filelistcount;

static char blankbuf[512];

static int pad(FILE *fil, int ofs, int size)
{
    int len = size - (ofs % size);
    if (len == size)
        return ofs;
    fwrite(blankbuf, 1, len, fil);
    return ofs + len;
}

//-------------------------------------------------------------------------

static int putlinedata(FILE *fil, struct linedata *l)
{
    char buf[256];
    int len;
    memset(buf, 0, 256);
    len = 17+strlen(l->hint);
    if (len % 2)
        len += 2-(len % 2);
    *(short*)buf = len;
    *(int*)(buf + 2) = l->startline;
    *(int*)(buf + 6) = l->endline;
    *(int*)(buf + 10) = l->filenum;
    *(short*)(buf + 14) = l->charpos;
    buf[16] = strlen(l->hint);
    strcpy(buf + 17, l->hint);
    fwrite(buf, 1, len, fil);
    return len;
} void GenerateOutput(char *name)
{
    FILE *fil;
    char buf[32];
    int ofs = 32, i;
    if (!symhash)
        return ;
    fil = fopen(name, "wb");
    memset(buf, 0, 32);
    if (!fil)
        fatal("could not open output file %s", name);
    fprintf(fil, "$BRW");
    fwrite(buf, 28, 1, fil);
    fputc(filelistcount, fil);
    fputc(filelistcount >> 8, fil);
    ofs += 2;
    for (i = 0; i < filelistcount; i++)
    {
        fputc(strlen(filelist[i]), fil);
        fprintf(fil, "%s", filelist[i]);
        ofs += strlen(filelist[i]) + 1;
    }
    ofs = pad(fil, ofs, 16);
    for (i = 0; i < HASH_TABLE_SIZE; i++)
    {
        struct symdata *s = symhash[i];
        while (s)
        {
            struct linedata *l = s->values;
            s->fileoffs = ofs;
            while (l)
            {
                if (!l->external || !s->globalcount)
                    ofs += putlinedata(fil, l);
                l = l->link;
            } fputc(0, fil);
            fputc(0, fil);
            ofs += 2;
            ofs = pad(fil, ofs, 2);
            s = s->link;
        }
    }
    ofs = pad(fil, ofs, 512);

    CalculateDictionary();
    *(int*)buf = WriteDictionary(fil, ofs);
    fseek(fil, 4, SEEK_SET);
    fwrite(buf, 4, 1, fil);
    fclose(fil);
}
