/*
	Software License Agreement (BSD License)
	
	Copyright (c) 1997-2008, David Lindauer, (LADSoft).
	All rights reserved.
	
	Redistribution and use of this software in source and binary forms, with or without modification, are
	permitted provided that the following conditions are met:
	
	* Redistributions of source code must retain the above
	  copyright notice, this list of conditions and the
	  following disclaimer.
	
	* Redistributions in binary form must reproduce the above
	  copyright notice, this list of conditions and the
	  following disclaimer in the documentation and/or other
	  materials provided with the distribution.
	
	* Neither the name of LADSoft nor the names of its
	  contributors may be used to endorse or promote products
	  derived from this software without specific prior
	  written permission of LADSoft.
	
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <stdio.h>
#include <errno.h>
#include <io.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"

int _fmode = O_TEXT;
int __uihandles[HANDLE_MAX], __uimodes[HANDLE_MAX],__uiflags[HANDLE_MAX] ;
char __uinames[HANDLE_MAX][256], __uidrives[HANDLE_MAX] ;

#pragma startup uio_init 138
#pragma rundown __uio_rundown 49 /* 11 */

static void uio_init(void)
{
   int i ;
   __ll_uioinit() ; /* sets first three handles */
   for (i=0; i < 3; i++) {
      __uimodes[i] = _fmode ;
   }
   for (i=3; i < HANDLE_MAX; i++)
      __uihandles[i] = -1 ;
}
void __uio_rundown(void)
{
   int i ;
   for (i=3; i < HANDLE_MAX; i++)
      if (__uihandles[i] != -1) {
         __ll_close(__uihandles[i]) ;
         __uihandles[i] = -1 ;
      }
}
int __uiohandle(int __handle)
{
   if (__handle >= HANDLE_MAX || __handle < 0) {
      errno = EBADF ;
      return -1 ;
   }
   if (__uihandles[__handle] == -1)
      errno = EBADF ;
   return __uihandles[__handle] ;
}
int __uinewhandpos(void)
{
   int i;
   for (i=0; i < HANDLE_MAX; i++)
      if (__uihandles[i] == -1)
         return i ;
   errno = EMFILE ;
   return -1 ;
}