/* 
   wspfunc.h

   Base definitions

   Copyright (C) 1996 Free Software Foundation, Inc.

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, 
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   -----------
   DAL 2003 - this file modified extensively for my compiler.  New
   definitionswnwn added as well.
*/ 
#ifdef __cplusplus
extern "C" {
#endif

HANDLE WINAPI DeletePrinter(
   HANDLE   hPrinter
);
BOOL WINAPI StartPagePrinter(
    HANDLE  hPrinter
);
BOOL WINAPI WritePrinter(
    HANDLE  hPrinter,
    LPVOID  pBuf,
    DWORD   cbBuf,
    LPDWORD pcWritten
);
BOOL WINAPI FlushPrinter(
    HANDLE   hPrinter,
    LPVOID   pBuf,
    DWORD    cbBuf,
    LPDWORD pcWritten,
    DWORD    cSleep
);
BOOL WINAPI EndPagePrinter(
   HANDLE   hPrinter
);
BOOL WINAPI AbortPrinter(
   HANDLE   hPrinter
);
BOOL WINAPI ReadPrinter(
    HANDLE  hPrinter,
    LPVOID  pBuf,
    DWORD   cbBuf,
    LPDWORD pNoBytesRead
);
BOOL WINAPI EndDocPrinter(
   HANDLE   hPrinter
);
BOOL WINAPI ScheduleJob(
    HANDLE  hPrinter,
    DWORD   JobId
);
BOOL WINAPI PrinterProperties(
    HWND    hWnd,
    HANDLE  hPrinter
);
DWORD WINAPI WaitForPrinterChange(
    HANDLE  hPrinter,
    DWORD   Flags
);
HANDLE WINAPI FindFirstPrinterChangeNotification(
    HANDLE  hPrinter,
    DWORD   fdwFlags,
    DWORD   fdwOptions,
    LPVOID  pPrinterNotifyOptions
);
BOOL WINAPI FindNextPrinterChangeNotification(
    HANDLE hChange,
    PDWORD pdwChange,
    LPVOID pvReserved,
    LPVOID *ppPrinterNotifyInfo
);
BOOL WINAPI FreePrinterNotifyInfo(
    PPRINTER_NOTIFY_INFO pPrinterNotifyInfo
);
BOOL WINAPI FindClosePrinterChangeNotification(
    HANDLE hChange
);
BOOL WINAPI ClosePrinter(
    HANDLE hPrinter
);
HANDLE WINAPI ConnectToPrinterDlg(
    HWND    hwnd,
    DWORD   Flags
);

#ifdef UNICODE
BOOL WINAPI EnumPrintersW(
    DWORD   Flags,
    LPWSTR Name,
    DWORD   Level,
    LPBYTE  pPrinterEnum,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI OpenPrinterW(
   LPWSTR    pPrinterName,
   LPHANDLE phPrinter,
   LPPRINTER_DEFAULTS pDefault
);
BOOL WINAPI ResetPrinterW(
   HANDLE   hPrinter,
   LPPRINTER_DEFAULTS pDefault
);
BOOL WINAPI SetJobW(
    HANDLE  hPrinter,
    DWORD   JobId,
    DWORD   Level,
    LPBYTE  pJob,
    DWORD   Command
);
BOOL WINAPI GetJobW(
   HANDLE   hPrinter,
   DWORD    JobId,
   DWORD    Level,
   LPBYTE   pJob,
   DWORD    cbBuf,
   LPDWORD  pcbNeeded
);
BOOL WINAPI EnumJobsW(
    HANDLE  hPrinter,
    DWORD   FirstJob,
    DWORD   NoJobs,
    DWORD   Level,
    LPBYTE  pJob,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
HANDLE WINAPI AddPrinterW(
    LPWSTR   pName,
    DWORD   Level,
    LPBYTE  pPrinter
);
BOOL WINAPI SetPrinterW(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pPrinter,
    DWORD   Command
);
BOOL WINAPI GetPrinterW(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pPrinter,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI AddPrinterDriverW(
    LPWSTR   pName,
     DWORD   Level,
    LPBYTE  pDriverInfo
);
BOOL WINAPI AddPrinterDriverExW(
    LPWSTR   pName,
    DWORD     Level,
    LPBYTE pDriverInfo,
    DWORD     dwFileCopyFlags
);
BOOL WINAPI EnumPrinterDriversW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pDriverInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI GetPrinterDriverW(
    HANDLE  hPrinter,
    LPWSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pDriverInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI GetPrinterDriverDirectoryW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pDriverDirectory,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI DeletePrinterDriverW(
   LPWSTR    pName,
   LPWSTR    pEnvironment,
   LPWSTR    pDriverName
);
BOOL WINAPI DeletePrinterDriverExW(
   LPWSTR    pName,
   LPWSTR    pEnvironment,
   LPWSTR    pDriverName,
   DWORD      dwDeleteFlag,
   DWORD      dwVersionFlag
);
BOOL WINAPI AddPrintProcessorW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    LPWSTR   pPathName,
    LPWSTR   pPrintProcessorName
);
BOOL WINAPI EnumPrintProcessorsW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pPrintProcessorInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI GetPrintProcessorDirectoryW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pPrintProcessorInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI EnumPrintProcessorDatatypesW(
    LPWSTR   pName,
    LPWSTR   pPrintProcessorName,
    DWORD   Level,
    LPBYTE  pDatatypes,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI DeletePrintProcessorW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    LPWSTR   pPrintProcessorName
);
DWORD WINAPI StartDocPrinterW(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pDocInfo
);
BOOL WINAPI AddJobW(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pData,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
LONG WINAPI DocumentPropertiesW(
    HWND      hWnd,
    HANDLE    hPrinter,
    LPWSTR   pDeviceName,
    PDEVMODE pDevModeOutput,
    PDEVMODE pDevModeInput,
    DWORD     fMode
);
LONG WINAPI AdvancedDocumentPropertiesW(
    HWND    hWnd,
    HANDLE  hPrinter,
    LPWSTR   pDeviceName,
    PDEVMODE pDevModeOutput,
    PDEVMODE pDevModeInput
);
DWORD WINAPI GetPrinterDataW(
    HANDLE   hPrinter,
    LPWSTR  pValueName,
    LPDWORD  pType,
    LPBYTE   pData,
    DWORD    nSize,
    LPDWORD  pcbNeeded
);
DWORD WINAPI GetPrinterDataExW(
    HANDLE   hPrinter,
    LPCWSTR pKeyName,
    LPCWSTR pValueName,
    LPDWORD  pType,
    LPBYTE   pData,
    DWORD    nSize,
    LPDWORD  pcbNeeded
);
DWORD WINAPI EnumPrinterDataW(
    HANDLE   hPrinter,
    DWORD    dwIndex,
    LPWSTR  pValueName,
    DWORD    cbValueName,
    LPDWORD  pcbValueName,
    LPDWORD  pType,
    LPBYTE   pData,
    DWORD    cbData,
    LPDWORD  pcbData
);
DWORD WINAPI EnumPrinterDataExW(
    HANDLE   hPrinter,
    LPCWSTR pKeyName,
    LPBYTE   pEnumValues,
    DWORD    cbEnumValues,
    LPDWORD  pcbEnumValues,
    LPDWORD  pnEnumValues
);
DWORD WINAPI EnumPrinterKeyW(
    HANDLE   hPrinter,
    LPCWSTR pKeyName,
    LPWSTR  pSubkey,
    DWORD    cbSubkey,
    LPDWORD  pcbSubkey
);
DWORD WINAPI SetPrinterDataW(
    HANDLE  hPrinter,
    LPWSTR pValueName,
    DWORD   Type,
    LPBYTE  pData,
    DWORD   cbData
);
DWORD WINAPI SetPrinterDataExW(
    HANDLE   hPrinter,
    LPCWSTR pKeyName,
    LPCWSTR pValueName,
    DWORD    Type,
    LPBYTE   pData,
    DWORD    cbData
);
DWORD WINAPI DeletePrinterDataW(
    HANDLE  hPrinter,
    LPWSTR pValueName
);
DWORD WINAPI DeletePrinterDataExW(
    HANDLE   hPrinter,
    LPCWSTR pKeyName,
    LPCWSTR pValueName
);
DWORD WINAPI DeletePrinterKeyW(
    HANDLE   hPrinter,
    LPCWSTR pKeyName
);
DWORD WINAPI PrinterMessageBoxW(
    HANDLE  hPrinter,
    DWORD   Error,
    HWND    hWnd,
    LPWSTR   pText,
    LPWSTR   pCaption,
    DWORD   dwType
);
BOOL WINAPI AddFormW(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pForm
);
BOOL WINAPI DeleteFormW(
    HANDLE  hPrinter,
    LPWSTR   pFormName
);
BOOL WINAPI GetFormW(
    HANDLE  hPrinter,
    LPWSTR   pFormName,
    DWORD   Level,
    LPBYTE  pForm,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI SetFormW(
    HANDLE  hPrinter,
    LPWSTR   pFormName,
    DWORD   Level,
    LPBYTE  pForm
);
BOOL WINAPI EnumFormsW(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pForm,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI EnumMonitorsW(
    LPWSTR   pName,
    DWORD   Level,
    LPBYTE  pMonitors,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI AddMonitorW(
    LPWSTR   pName,
    DWORD   Level,
    LPBYTE  pMonitors
);
BOOL WINAPI DeleteMonitorW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    LPWSTR   pMonitorName
);
BOOL WINAPI EnumPortsW(
    LPWSTR   pName,
    DWORD   Level,
    LPBYTE  pPorts,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI AddPortW(
    LPWSTR   pName,
    HWND    hWnd,
    LPWSTR   pMonitorName
);
BOOL WINAPI ConfigurePortW(
    LPWSTR   pName,
    HWND    hWnd,
    LPWSTR   pPortName
);
BOOL WINAPI DeletePortW(
    LPWSTR pName,
    HWND    hWnd,
    LPWSTR pPortName
);
BOOL WINAPI XcvDataW(
    HANDLE  hXcv,
    PCWSTR  pszDataName,
    PBYTE   pInputData,
    DWORD   cbInputData,
    PBYTE   pOutputData,
    DWORD   cbOutputData,
    PDWORD  pcbOutputNeeded,
    PDWORD  pdwStatus
);
BOOL WINAPI GetDefaultPrinterW(
    LPWSTR   pszBuffer,
    LPDWORD  pcchBuffer
    );
BOOL WINAPI SetDefaultPrinterW(
    LPCWSTR pszPrinter
    );
BOOL WINAPI SetPortW(
    LPWSTR     pName,
    LPWSTR     pPortName,
    DWORD       dwLevel,
    LPBYTE      pPortInfo
);
BOOL WINAPI AddPrinterConnectionW(
    LPWSTR   pName
);
BOOL WINAPI DeletePrinterConnectionW(
    LPWSTR   pName
);
BOOL WINAPI AddPrintProvidorW(
    LPWSTR  pName,
    DWORD    level,
    LPBYTE   pProvidorInfo
);
BOOL WINAPI DeletePrintProvidorW(
    LPWSTR   pName,
    LPWSTR   pEnvironment,
    LPWSTR   pPrintProvidorName
);

#define AddForm AddFormW
#define AddJob AddJobW
#define AddMonitor AddMonitorW
#define AddPort AddPortW
#define AddPrintProcessor AddPrintProcessorW
#define AddPrintProvidor AddPrintProvidorW
#define AddPrinter AddPrinterW
#define AddPrinterConnection AddPrinterConnectionW
#define AddPrinterDriver AddPrinterDriverW
#define AddPrinterDriverEx AddPrinterDriverExW
#define AdvancedDocumentProperties AdvancedDocumentPropertiesW
#define ConfigurePort ConfigurePortW
#define DeleteForm DeleteFormW
#define DeleteMonitor DeleteMonitorW
#define DeletePort DeletePortW
#define DeletePrintProcessor DeletePrintProcessorW
#define DeletePrintProvidor DeletePrintProvidorW
#define DeletePrinterConnection DeletePrinterConnectionW
#define DeletePrinterData DeletePrinterDataW
#define DeletePrinterDataEx DeletePrinterDataExW
#define DeletePrinterDriver DeletePrinterDriverW
#define DeletePrinterDriverEx DeletePrinterDriverExW
#define DeletePrinterKey DeletePrinterKeyW
#define DocumentProperties DocumentPropertiesW
#define EnumForms EnumFormsW
#define EnumJobs EnumJobsW
#define EnumMonitors EnumMonitorsW
#define EnumPorts EnumPortsW
#define EnumPrintProcessorDatatypes EnumPrintProcessorDatatypesW
#define EnumPrintProcessors EnumPrintProcessorsW
#define EnumPrinterData EnumPrinterDataW
#define EnumPrinterDataEx EnumPrinterDataExW
#define EnumPrinterDrivers EnumPrinterDriversW
#define EnumPrinterKey EnumPrinterKeyW
#define EnumPrinters EnumPrintersW
#define GetDefaultPrinter GetDefaultPrinterW
#define GetForm GetFormW
#define GetJob GetJobW
#define GetPrintProcessorDirectory GetPrintProcessorDirectoryW
#define GetPrinter GetPrinterW
#define GetPrinterData GetPrinterDataW
#define GetPrinterDataEx GetPrinterDataExW
#define GetPrinterDriver GetPrinterDriverW
#define GetPrinterDriverDirectory GetPrinterDriverDirectoryW
#define OpenPrinter OpenPrinterW
#define PrinterMessageBox PrinterMessageBoxW
#define ResetPrinter ResetPrinterW
#define SetDefaultPrinter SetDefaultPrinterW
#define SetForm SetFormW
#define SetJob SetJobW
#define SetPort SetPortW
#define SetPrinter SetPrinterW
#define SetPrinterData SetPrinterDataW
#define SetPrinterDataEx SetPrinterDataExW
#define StartDocPrinter StartDocPrinterW

#else
BOOL WINAPI EnumPrintersA(
    DWORD   Flags,
    LPSTR Name,
    DWORD   Level,
    LPBYTE  pPrinterEnum,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI OpenPrinterA(
   LPSTR    pPrinterName,
   LPHANDLE phPrinter,
   LPPRINTER_DEFAULTS pDefault
);
BOOL WINAPI ResetPrinterA(
   HANDLE   hPrinter,
   LPPRINTER_DEFAULTS pDefault
);
BOOL WINAPI SetJobA(
    HANDLE  hPrinter,
    DWORD   JobId,
    DWORD   Level,
    LPBYTE  pJob,
    DWORD   Command
);
BOOL WINAPI GetJobA(
   HANDLE   hPrinter,
   DWORD    JobId,
   DWORD    Level,
   LPBYTE   pJob,
   DWORD    cbBuf,
   LPDWORD  pcbNeeded
);
BOOL WINAPI EnumJobsA(
    HANDLE  hPrinter,
    DWORD   FirstJob,
    DWORD   NoJobs,
    DWORD   Level,
    LPBYTE  pJob,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
HANDLE WINAPI AddPrinterA(
    LPSTR   pName,
    DWORD   Level,
    LPBYTE  pPrinter
);
BOOL WINAPI SetPrinterA(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pPrinter,
    DWORD   Command
);
BOOL WINAPI GetPrinterA(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pPrinter,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI AddPrinterDriverA(
    LPSTR   pName,
     DWORD   Level,
    LPBYTE  pDriverInfo
);
BOOL WINAPI AddPrinterDriverExA(
    LPSTR   pName,
    DWORD     Level,
    LPBYTE pDriverInfo,
    DWORD     dwFileCopyFlags
);
BOOL WINAPI EnumPrinterDriversA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pDriverInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI GetPrinterDriverA(
    HANDLE  hPrinter,
    LPSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pDriverInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI GetPrinterDriverDirectoryA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pDriverDirectory,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI DeletePrinterDriverA(
   LPSTR    pName,
   LPSTR    pEnvironment,
   LPSTR    pDriverName
);
BOOL WINAPI DeletePrinterDriverExA(
   LPSTR    pName,
   LPSTR    pEnvironment,
   LPSTR    pDriverName,
   DWORD      dwDeleteFlag,
   DWORD      dwVersionFlag
);
BOOL WINAPI AddPrintProcessorA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    LPSTR   pPathName,
    LPSTR   pPrintProcessorName
);
BOOL WINAPI EnumPrintProcessorsA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pPrintProcessorInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI GetPrintProcessorDirectoryA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    DWORD   Level,
    LPBYTE  pPrintProcessorInfo,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI EnumPrintProcessorDatatypesA(
    LPSTR   pName,
    LPSTR   pPrintProcessorName,
    DWORD   Level,
    LPBYTE  pDatatypes,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI DeletePrintProcessorA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    LPSTR   pPrintProcessorName
);
DWORD WINAPI StartDocPrinterA(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pDocInfo
);
BOOL WINAPI AddJobA(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pData,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
LONG WINAPI DocumentPropertiesA(
    HWND      hWnd,
    HANDLE    hPrinter,
    LPSTR   pDeviceName,
    PDEVMODE pDevModeOutput,
    PDEVMODE pDevModeInput,
    DWORD     fMode
);
LONG WINAPI AdvancedDocumentPropertiesA(
    HWND    hWnd,
    HANDLE  hPrinter,
    LPSTR   pDeviceName,
    PDEVMODE pDevModeOutput,
    PDEVMODE pDevModeInput
);
DWORD WINAPI GetPrinterDataA(
    HANDLE   hPrinter,
    LPSTR  pValueName,
    LPDWORD  pType,
    LPBYTE   pData,
    DWORD    nSize,
    LPDWORD  pcbNeeded
);
DWORD WINAPI GetPrinterDataExA(
    HANDLE   hPrinter,
    LPCSTR pKeyName,
    LPCSTR pValueName,
    LPDWORD  pType,
    LPBYTE   pData,
    DWORD    nSize,
    LPDWORD  pcbNeeded
);
DWORD WINAPI EnumPrinterDataA(
    HANDLE   hPrinter,
    DWORD    dwIndex,
    LPSTR  pValueName,
    DWORD    cbValueName,
    LPDWORD  pcbValueName,
    LPDWORD  pType,
    LPBYTE   pData,
    DWORD    cbData,
    LPDWORD  pcbData
);
DWORD WINAPI EnumPrinterDataExA(
    HANDLE   hPrinter,
    LPCSTR pKeyName,
    LPBYTE   pEnumValues,
    DWORD    cbEnumValues,
    LPDWORD  pcbEnumValues,
    LPDWORD  pnEnumValues
);
DWORD WINAPI EnumPrinterKeyA(
    HANDLE   hPrinter,
    LPCSTR pKeyName,
    LPSTR  pSubkey,
    DWORD    cbSubkey,
    LPDWORD  pcbSubkey
);
DWORD WINAPI SetPrinterDataA(
    HANDLE  hPrinter,
    LPSTR pValueName,
    DWORD   Type,
    LPBYTE  pData,
    DWORD   cbData
);
DWORD WINAPI SetPrinterDataExA(
    HANDLE   hPrinter,
    LPCSTR pKeyName,
    LPCSTR pValueName,
    DWORD    Type,
    LPBYTE   pData,
    DWORD    cbData
);
DWORD WINAPI DeletePrinterDataA(
    HANDLE  hPrinter,
    LPSTR pValueName
);
DWORD WINAPI DeletePrinterDataExA(
    HANDLE   hPrinter,
    LPCSTR pKeyName,
    LPCSTR pValueName
);
DWORD WINAPI DeletePrinterKeyA(
    HANDLE   hPrinter,
    LPCSTR pKeyName
);
DWORD WINAPI PrinterMessageBoxA(
    HANDLE  hPrinter,
    DWORD   Error,
    HWND    hWnd,
    LPSTR   pText,
    LPSTR   pCaption,
    DWORD   dwType
);
BOOL WINAPI AddFormA(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pForm
);
BOOL WINAPI DeleteFormA(
    HANDLE  hPrinter,
    LPSTR   pFormName
);
BOOL WINAPI GetFormA(
    HANDLE  hPrinter,
    LPSTR   pFormName,
    DWORD   Level,
    LPBYTE  pForm,
    DWORD   cbBuf,
    LPDWORD pcbNeeded
);
BOOL WINAPI SetFormA(
    HANDLE  hPrinter,
    LPSTR   pFormName,
    DWORD   Level,
    LPBYTE  pForm
);
BOOL WINAPI EnumFormsA(
    HANDLE  hPrinter,
    DWORD   Level,
    LPBYTE  pForm,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI EnumMonitorsA(
    LPSTR   pName,
    DWORD   Level,
    LPBYTE  pMonitors,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI AddMonitorA(
    LPSTR   pName,
    DWORD   Level,
    LPBYTE  pMonitors
);
BOOL WINAPI DeleteMonitorA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    LPSTR   pMonitorName
);
BOOL WINAPI EnumPortsA(
    LPSTR   pName,
    DWORD   Level,
    LPBYTE  pPorts,
    DWORD   cbBuf,
    LPDWORD pcbNeeded,
    LPDWORD pcReturned
);
BOOL WINAPI AddPortA(
    LPSTR   pName,
    HWND    hWnd,
    LPSTR   pMonitorName
);
BOOL WINAPI ConfigurePortA(
    LPSTR   pName,
    HWND    hWnd,
    LPSTR   pPortName
);
BOOL WINAPI DeletePortA(
    LPSTR pName,
    HWND    hWnd,
    LPSTR pPortName
);
BOOL WINAPI GetDefaultPrinterA(
    LPSTR   pszBuffer,
    LPDWORD  pcchBuffer
    );
BOOL WINAPI SetDefaultPrinterA(
    LPCSTR pszPrinter
    );
BOOL WINAPI SetPortA(
    LPSTR     pName,
    LPSTR     pPortName,
    DWORD       dwLevel,
    LPBYTE      pPortInfo
);
BOOL WINAPI AddPrinterConnectionA(
    LPSTR   pName
);
BOOL WINAPI DeletePrinterConnectionA(
    LPSTR   pName
);
BOOL WINAPI AddPrintProvidorA(
    LPSTR  pName,
    DWORD    level,
    LPBYTE   pProvidorInfo
);
BOOL WINAPI DeletePrintProvidorA(
    LPSTR   pName,
    LPSTR   pEnvironment,
    LPSTR   pPrintProvidorName
);
#define AddForm AddFormA
#define AddJob AddJobA
#define AddMonitor AddMonitorA
#define AddPort AddPortA
#define AddPrintProcessor AddPrintProcessorA
#define AddPrintProvidor AddPrintProvidorA
#define AddPrinter AddPrinterA
#define AddPrinterConnection AddPrinterConnectionA
#define AddPrinterDriver AddPrinterDriverA
#define AddPrinterDriverEx AddPrinterDriverExA
#define AdvancedDocumentProperties AdvancedDocumentPropertiesA
#define ConfigurePort ConfigurePortA
#define DeleteForm DeleteFormA
#define DeleteMonitor DeleteMonitorA
#define DeletePort DeletePortA
#define DeletePrintProcessor DeletePrintProcessorA
#define DeletePrintProvidor DeletePrintProvidorA
#define DeletePrinterConnection DeletePrinterConnectionA
#define DeletePrinterData DeletePrinterDataA
#define DeletePrinterDataEx DeletePrinterDataExA
#define DeletePrinterDriver DeletePrinterDriverA
#define DeletePrinterDriverEx DeletePrinterDriverExA
#define DeletePrinterKey DeletePrinterKeyA
#define DocumentProperties DocumentPropertiesA
#define EnumForms EnumFormsA
#define EnumJobs EnumJobsA
#define EnumMonitors EnumMonitorsA
#define EnumPorts EnumPortsA
#define EnumPrintProcessorDatatypes EnumPrintProcessorDatatypesA
#define EnumPrintProcessors EnumPrintProcessorsA
#define EnumPrinterData EnumPrinterDataA
#define EnumPrinterDataEx EnumPrinterDataExA
#define EnumPrinterDrivers EnumPrinterDriversA
#define EnumPrinterKey EnumPrinterKeyA
#define EnumPrinters EnumPrintersA
#define GetDefaultPrinter GetDefaultPrinterA
#define GetForm GetFormA
#define GetJob GetJobA
#define GetPrintProcessorDirectory GetPrintProcessorDirectoryA
#define GetPrinter GetPrinterA
#define GetPrinterData GetPrinterDataA
#define GetPrinterDataEx GetPrinterDataExA
#define GetPrinterDriver GetPrinterDriverA
#define GetPrinterDriverDirectory GetPrinterDriverDirectoryA
#define OpenPrinter OpenPrinterA
#define PrinterMessageBox PrinterMessageBoxA
#define ResetPrinter ResetPrinterA
#define SetDefaultPrinter SetDefaultPrinterA
#define SetForm SetFormA
#define SetJob SetJobA
#define SetPort SetPortA
#define SetPrinter SetPrinterA
#define SetPrinterData SetPrinterDataA
#define SetPrinterDataEx SetPrinterDataExA
#define StartDocPrinter StartDocPrinterA

#define XcvData XcvDataW
#endif

#ifdef __cplusplus
}
#endif
