#ifndef __DIRECT_H
#define __DIRECT_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif


#ifdef __cplusplus
namespace std {
extern "C" {
#endif
struct _diskfree_t
{
    unsigned total_clusters;
    unsigned avail_clusters;
    unsigned sectors_per_cluster;
    unsigned bytes_per_sector;
};

int     _RTL_FUNC _chdrive(int __drive);
char *  _RTL_FUNC _getdcwd(int __drive, char *__buf, int __len);
unsigned _RTL_FUNC _getdiskfree(unsigned, struct _diskfree_t *);
int     _RTL_FUNC _getdrive(void);
unsigned long _RTL_FUNC _getdrives(void);

int _RTL_FUNC chdir(const char *);
char * _RTL_FUNC getcwd(char *, int);
int _RTL_FUNC mkdir(const char *);
int _RTL_FUNC rmdir(const char *);

int _RTL_FUNC _chdir(const char *);
char * _RTL_FUNC _getcwd(char *, int);
int _RTL_FUNC _mkdir(const char *);
int _RTL_FUNC _rmdir(const char *);


#ifdef __cplusplus
} ;
};
#endif

#endif /* __DIRECT_H */
#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__DIRECT_H_USING_LIST)
#define __DIRECT_H_USING_LIST
	using std::_chdrive;
	using std::_getdcwd;
	using std::_getdrive;
	using std::_getdrives;
	using std::_getdiskfree;
	using std::chdir;
	using std::_chdir;
	using std::getcwd;
	using std::_getcwd;
	using std::mkdir;
	using std::_mkdir;
	using std::rmdir;
	using std::_rmdir;
	
#endif
