#ifndef __SIGNAL_H
#define __SIGNAL_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#ifdef __cplusplus
namespace std {
extern "C" {
#endif

typedef int sig_atomic_t;   /* Atomic entity type (ANSI) */

typedef void (* _CatcherPTR)();

#define SIG_DFL ((_CatcherPTR)0)   /* Default action   */
#define SIG_IGN ((_CatcherPTR)1)   /* Ignore action    */
#define SIG_ERR ((_CatcherPTR)-1)  /* Error return     */

#define SIGABRT         22
#define SIGFPE           8              /* Floating point trap  */
#define SIGILL           4              /* Illegal instruction  */
#define SIGINT           2
#define SIGSEGV         11              /* Memory access violation */
#define SIGTERM         15
#define SIGUSR1         16              /* User-defined signal 1 */
#define SIGUSR2         17              /* User-defined signal 2 */
#define SIGUSR3         20              /* User-defined signal 3 */
#define SIGBREAK        21              /* Control-Break interrupt */


typedef void (* sighandler_t)(int);

int  _RTL_FUNC raise(int __sig);
sighandler_t _RTL_FUNC signal(int __sig, sighandler_t __func);

#define NSIG   23      /* highest defined signal no. + 1 */

#ifdef __cplusplus
};
};
#endif

#endif  /* __SIGNAL_H */
#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__SIGNAL_H_USING_LIST)
#define __SIGNAL_H_USING_LIST
using std::sighandler_t;
using std::sig_atomic_t;
using std::_CatcherPTR;
using std::raise;
using std::signal;
#endif
