/*  memory.h

    Memory manipulation functions

*/

#if !defined(__MEM_H)
#define __MEM_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#ifdef __cplusplus
namespace std {
extern "C" {
#endif

void *    _RTL_FUNC memccpy(void *__dest, const void *__src,
                                        int __c, size_t __n);
int       _RTL_FUNC memcmp(const void *__s1, const void *__s2,
                                       size_t __n);
void *    _RTL_FUNC memcpy(void *__dest, const void *__src,
                                       size_t __n);
int       _RTL_FUNC memicmp(const void *__s1, const void *__s2,
                                        size_t __n);
void *    _RTL_FUNC memmove(void *__dest, const void *__src,
                                        size_t __n);
void *    _RTL_FUNC memset(void *__s, int __c, size_t __n);

void *    _RTL_FUNC memchr(const void *__s, int __c, size_t __n);

int    		 _RTL_FUNC _memicmp(const void *, const void *, unsigned int);
void *       _RTL_FUNC _memccpy(void *, const void *, int, unsigned int);

#ifdef __cplusplus
};
};
#endif

#endif  /* __MEM_H */
#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__MEMORY_H_USING_LIST)
#define __MEMORY_H_USING_LIST
	using std::memccpy;
	using std::memcmp;
	using std::memcpy;
	using std::memicmp;
	using std::memmove;
	using std::memset;
	using std::memchr;
#endif
