/*  locale.h

*/

#ifndef __LOCALE_H
#define __LOCALE_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#define LC_ALL      0
#define LC_COLLATE  1
#define LC_CTYPE    2
#define LC_MONETARY 3
#define LC_NUMERIC  4
#define LC_TIME     5
#define LC_MESSAGES 6
#define LC_userdef  7
#define LC_LAST     LC_userdef

#ifdef __cplusplus
namespace std {
extern "C" {
#endif

struct lconv {

   char *decimal_point;
   char *thousands_sep;
   char *grouping;
   char *int_curr_symbol;
   char *currency_symbol;
   char *mon_decimal_point;
   char *mon_thousands_sep;
   char *mon_grouping;
   char *positive_sign;
   char *negative_sign;
   char int_frac_digits;
   char frac_digits;
   char p_cs_precedes;
   char p_sep_by_space;
   char n_cs_precedes;
   char n_sep_by_space;
   char p_sign_posn;
   char n_sign_posn;
   char int_p_cs_precedes; /* CHAR_MAX */
   char int_n_cs_precedes; /* CHAR_MAX */
   char int_p_sep_by_space; /* CHAR_MAX */
   char int_n_sep_by_space; /* CHAR_MAX */
   char int_p_sign_posn; /* CHAR_MAX */
   char int_n_sign_posn; /* CHAR_MAX */
} ;

char *          _RTL_FUNC setlocale( int __category, const char *__locale );
char *          _RTL_FUNC _lsetlocale( int __category, const char *__locale );
struct lconv *  _RTL_FUNC localeconv( void );
struct lconv *  _RTL_FUNC _llocaleconv( void );
#ifdef __cplusplus
};
};
#endif

#endif  /* __LOCALE_H */
#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__LOCALE_H_USING_LIST)
#define __LOCALE_H_USING_LIST
    using std::lconv ;
	using std::setlocale;
	using std::_lsetlocale;
	using std::localeconv;
	using std::_llocaleconv;
#endif
