
#ifndef __DIR_H
#define __DIR_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#define WILDCARDS 0x01
#define EXTENSION 0x02
#define FILENAME  0x04
#define DIRECTORY 0x08
#define DRIVE     0x10

#define MAXDRIVE  3

#define _A_NORMAL   0x00        /* Normal file, no attributes */
#define _A_RDONLY   0x01        /* Read only attribute */
#define _A_HIDDEN   0x02        /* Hidden file */
#define _A_SYSTEM   0x04        /* System file */
#define _A_VOLID    0x08        /* Volume label */
#define _A_SUBDIR   0x10        /* Directory */
#define _A_ARCH     0x20        /* Archive */

#ifdef __cplusplus
namespace std {
extern "C" {
#endif

#ifndef _FFBLK_DEF
#define _FFBLK_DEF
struct  ffblk   {
    unsigned char   ff_reserved[21];
    unsigned char   ff_attrib;            /* attribute byte for matched file */
    unsigned short  ff_ftime;           /* time of last write to file */
    unsigned short  ff_fdate;           /* date of last write to file */
    unsigned long   ff_fsize;           /* size of file */
    char            ff_name[13];         /* asciiz name of matched file */
    char	    ff_uu[256];
};
#endif

#define MAXPATH   260
#define MAXDIR    256
#define MAXFILE   256
#define MAXEXT    256


int         _RTL_FUNC    chdir( const char  *__path );
int         _RTL_FUNC    findfirst( const char  *__path,
                                    struct ffblk  *__ffblk,
                                    int __attrib );
int         _RTL_FUNC    findnext( struct ffblk  *__ffblk );
void        _RTL_FUNC    fnmerge( char  *__path,
                                    const char  *__drive,
                                    const char  *__dir,
                                    const char  *__name,
                                    const char  *__ext );
int         _RTL_FUNC    fnsplit(const char  *__path,
                                    char  *__drive,
                                    char  *__dir,
                                    char  *__name,
                                    char  *__ext );
int         _RTL_FUNC    getcurdir( int __drive, char  *__directory );
char  *     _RTL_FUNC    getcwd( char  *__buf, int __buflen );
int         _RTL_FUNC    getdisk( void );
int         _RTL_FUNC    mkdir( const char  *__path );
char  *     _RTL_FUNC    mktemp( char  *__template );
int         _RTL_FUNC    rmdir( const char  *__path );
char  *     _RTL_FUNC    searchpath( const char  *__file );
int         _RTL_FUNC    setdisk( int __drive );

int _RTL_FUNC _chdir(const char *);
char * _RTL_FUNC _getcwd(char *, int);
int _RTL_FUNC _mkdir(const char *);
int _RTL_FUNC _rmdir(const char *);

#ifdef __cplusplus
} ;
} ;
#endif

#endif  /* __DIR_H */

#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__DIR_H_USING_LIST)
#define __DIR_H_USING_LIST
	using std::chdir;
	using std::_chdir;
	using std::findfirst;
	using std::findnext;
	using std::fnmerge;
	using std::fnsplit;
	using std::getcurdir;
	using std::getcwd;
	using std::_getcwd;
	using std::getdisk;
	using std::mkdir;
	using std::_mkdir;
	using std::mktemp;
	using std::rmdir;
	using std::_rmdir;
	using std::searchpath;
	using std::setdisk;
    using std::ffblk;
#endif
