/*  ctype.h

    Defines the locale aware ctype macros.

*/


#ifndef __CTYPE_H
#define __CTYPE_H

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#ifdef __cplusplus
namespace std {
extern "C" {
#endif

extern unsigned char const _RTL_DATA * const _ctype;

/* character classes */

#ifndef _IS_CONSTANTS
#define _IS_CONSTANTS
#define _IS_SP     1           /* space */
#define _IS_DIG    2           /* digit */
#define _IS_UPP    4           /* upper case */
#define _IS_LOW    8           /* lower case */
#define _IS_HEX   16           /* [0..9] or [A-F] or [a-f] */
#define _IS_CTL   32           /* control */
#define _IS_PUN   64           /* punctuation */
#define _IS_BLK  128           /* blank */
#define _IS_GPH  256            /* graphic */

#define _IS_ALPHA    (_IS_UPP | _IS_LOW)
#define _IS_ALNUM    (_IS_DIG | _IS_ALPHA)
#define _IS_GRAPH    (_IS_ALNUM | _IS_HEX | _IS_PUN)
#define _IS_PRINT    (_IS_GRAPH | _IS_BLK | _IS_SP)
#endif

int      _RTL_FUNC isalnum (int __c);
int      _RTL_FUNC isalpha (int __c);
int      _RTL_FUNC iscntrl (int __c);
int      _RTL_FUNC isdigit (int __c);
int      _RTL_FUNC isgraph (int __c);
int      _RTL_FUNC islower (int __c);
int      _RTL_FUNC isprint (int __c);
int      _RTL_FUNC ispunct (int __c);
int      _RTL_FUNC isspace (int __c);
int      _RTL_FUNC isupper (int __c);
int      _RTL_FUNC isxdigit(int __c);
int      _RTL_FUNC isascii (int __c);
int 	 _RTL_FUNC toascii(int);
int		 _RTL_FUNC __isascii(int);
int		 _RTL_FUNC __toascii(int);

int      _RTL_FUNC tolower(int __ch);
int      _RTL_FUNC _ltolower(int __ch);
int      _RTL_FUNC toupper(int __ch);
int      _RTL_FUNC _ltoupper(int __ch);

int		 _RTL_FUNC _isctype(int, int);
int		 _RTL_FUNC __iscsymf(int);
int		 _RTL_FUNC __iscsym(int);
#ifdef __cplusplus
};
};
#endif

#define isalnum(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_ALNUM))
                     
#define isalpha(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_ALPHA))
                     
#define iscntrl(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_CTL))
                     
#define isdigit(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_DIG))
                     
#define isgraph(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_GRAPH))
                     
#define islower(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_LOW))
                     
#define isprint(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_PRINT))
                     
#define ispunct(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_PUN))
                     
#define isspace(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_SP))
                     
#define isupper(c)   ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_UPP))
                     
#define isxdigit(c)  ( __STD_NS_QUALIFIER _ctype[ (c) ] & (_IS_HEX))


#define _toupper(c) ((c) + 'A' - 'a')
#define _tolower(c) ((c) + 'a' - 'A')
#define isascii(c)  ((unsigned)(c) < 128)
#define toascii(c)  ((c) & 0x7f)


#endif 

#if defined(__cplusplus) && !defined(__USING_CNAME__) && !defined(__CTYPE_H_USING_LIST)
#define __CTYPE_H_USING_LIST
	using std::isalnum;
	using std::isalpha;
	using std::iscntrl;
	using std::isdigit;
	using std::isgraph;
	using std::islower;
	using std::isprint;
	using std::ispunct;
	using std::isspace;
	using std::isupper;
	using std::isxdigit;
	using std::isascii;
	using std::toascii;
	using std::__isascii;
	using std::__toascii;
	using std::tolower;
	using std::_ltolower;
	using std::toupper;
	using std::_ltoupper;
    using std::_ctype;
	using std::_isctype;
	using std::__iscsymf;
	using std::__iscsym;
#endif

