/*
    assert.h
*/

#if !defined( __ASSERT_H__ )
#define __ASSERT_H__

#ifndef __STDDEF_H
#include <stddef.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

void _RTL_FUNC __assertfail( const char *__who, const char *__file, 
							int __line, const char *__func, const char *__msg );
#ifdef __cplusplus
};
#endif


#undef assert
#if !defined( NDEBUG )
#if  __STDC_VERSION__ >= 199901L
#  define assert(p) ( (p) ? (void)0 : (void)__assertfail( \
                    "Assertion failed", __FILE__, __LINE__, __func__, #p ) )
#else
#  define assert(p) ( (p) ? (void)0 : (void)__assertfail( \
                    "Assertion failed", __FILE__, __LINE__, 0, #p ) )
#endif
#else
#  define assert(p) ((void)0)
#endif

#endif /* __ASSERT_H__ */
