	SECTION _TEXT align=1 CLASS=CODE USE32
	SECTION _DATA align=16 CLASS=DATA USE32
	SECTION _BSS align=16 CLASS=BSS USE32
	SECTION _CONST align=16 CLASS=CONST USE32
	SECTION _STRING align=4 CLASS=STRING USE32
	SECTION cstartup align=4 CLASS=INITDATA USE32
	SECTION crundown align=4 CLASS=EXITDATA USE32
	SECTION cppinit  align=4 CLASS=CPPINIT USE32
	SECTION cppexit  align=4 CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
[GLOBAL	_CreateWindow]
;
; Line 13:	CLASS Class,               
;
_CreateWindow:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD [EBP+024H]
L_2:
;
; Line 21:	{
;
;
; Line 22:	WINDOW wnd = DFcalloc(1, sizeof(struct window));
;
	PUSH	DWORD 0128H
	PUSH	BYTE 01H
	CALL	_DFcalloc
	ADD	ESP,BYTE 08H
	MOV	ESI,EAX
;
; Line 23:	get_videomode();
;
	CALL	_get_videomode
;
; Line 24:	if (wnd != NULL)    {
;
	TEST	ESI,ESI
	JE	NEAR	L_3
;
; Line 27:	if (height == -1)
;
	CMP	DWORD [EBP+018H],BYTE 0FFFFFFFFH
	JNE	SHORT	L_5
;
; Line 28:	height = SCREENHEIGHT;
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_9
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_7
L_9:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_8
L_7:
	MOV	EAX,019H
L_8:
	MOV	DWORD [EBP+018H],EAX
L_5:
;
; Line 29:	if (width == -1)
;
	CMP	DWORD [EBP+01CH],BYTE 0FFFFFFFFH
	JNE	SHORT	L_10
;
; Line 30:	width = SCREENWIDTH;
;
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	MOV	DWORD [EBP+01CH],EAX
L_10:
;
; Line 32:	if (left == -1)
;
	CMP	DWORD [EBP+010H],BYTE 0FFFFFFFFH
	JNE	SHORT	L_12
;
; Line 33:	wnd->rc.lf = (SCREENWIDTH-width)/2;
;
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	SUB	EAX,DWORD [EBP+01CH]
	SAR	EAX,01H
	JNS	SHORT	L_14
	ADC	EAX,BYTE 00H
L_14:
	MOV	DWORD [ESI+0CH],EAX
	JMP	SHORT	L_13
L_12:
;
; Line 35:	wnd->rc.lf = left;
;
	MOV	EAX,DWORD [EBP+010H]
	MOV	DWORD [ESI+0CH],EAX
L_13:
;
; Line 36:	if (top == -1)
;
	CMP	DWORD [EBP+014H],BYTE 0FFFFFFFFH
	JNE	SHORT	L_15
;
; Line 37:	wnd->rc.tp = (SCREENHEIGHT-height)/2;
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_19
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_17
L_19:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_18
L_17:
	MOV	EAX,019H
L_18:
	SUB	EAX,DWORD [EBP+018H]
	SAR	EAX,01H
	JNS	SHORT	L_20
	ADC	EAX,BYTE 00H
L_20:
	MOV	DWORD [ESI+010H],EAX
	JMP	SHORT	L_16
L_15:
;
; Line 39:	wnd->rc.tp = top;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	DWORD [ESI+010H],EAX
L_16:
;
; Line 40:	wnd->attrib = attrib;
;
	MOV	EAX,DWORD [EBP+02CH]
	MOV	DWORD [ESI+054H],EAX
;
; Line 41:	if (ttl != NULL)
;
	CMP	DWORD [EBP+0CH],BYTE 00H
	JE	SHORT	L_21
;
; Line 42:	if (*ttl != '\0')
;
	MOV	EAX,DWORD [EBP+0CH]
	MOVSX	EAX,BYTE [EAX+00H]
	TEST	EAX,EAX
	JE	SHORT	L_23
;
; Line 43:	AddAttribute(wnd, HASTITLEBAR);
;
	BTS	DWORD [ESI+054H],08H
L_23:
L_21:
;
; Line 44:	if (wndproc == NULL)
;
	CMP	DWORD [EBP+028H],BYTE 00H
	JNE	SHORT	L_25
;
; Line 45:	wnd->wndproc = classdefs[Class].wndproc;
;
	MOV	EAX,DWORD [EBP+08H]
	IMUL	EAX,BYTE 0CH
	MOV	EAX,DWORD [EAX+04H+_classdefs+00H]
	MOV	DWORD [ESI+08H],EAX
	JMP	SHORT	L_26
L_25:
;
; Line 47:	wnd->wndproc = wndproc;
;
	MOV	EAX,DWORD [EBP+028H]
	MOV	DWORD [ESI+08H],EAX
L_26:
;
; Line 49:	base = Class;
;
	MOV	EBX,DWORD [EBP+08H]
	JMP	SHORT	L_27
L_29:
;
; Line 51:	AddAttribute(wnd, classdefs[base].attrib);
;
	MOV	EAX,EBX
	IMUL	EAX,BYTE 0CH
	MOV	EAX,DWORD [EAX+08H+_classdefs+00H]
	OR	DWORD [ESI+054H],EAX
;
; Line 52:	base = classdefs[base].base;
;
	MOV	EAX,EBX
	IMUL	EAX,BYTE 0CH
	MOV	EBX,DWORD [EAX+_classdefs+00H]
L_27:
;
; Line 50:	while (base != -1)    {
;
	CMP	EBX,BYTE 0FFFFFFFFH
	JNE	SHORT	L_29
L_28:
;
; Line 54:	if (parent)	{
;
	TEST	EDI,EDI
	JE	NEAR	L_30
;
; Line 55:	if (!TestAttribute(wnd, NOCLIP))    {
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0800H
	JNE	NEAR	L_32
;
; Line 57:	wnd->rc.lf = max(wnd->rc.lf,GetClientLeft(parent));
;
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,04000H
	JE	SHORT	L_36
	MOV	EAX,01H
	JMP	SHORT	L_37
L_36:
	MOV	EAX,00H
L_37:
	ADD	EAX,DWORD [EDI+0CH]
	CMP	DWORD [ESI+0CH],EAX
	JLE	SHORT	L_34
	MOV	EAX,DWORD [ESI+0CH]
	JMP	SHORT	L_35
L_34:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,04000H
	JE	SHORT	L_38
	MOV	EAX,01H
	JMP	SHORT	L_39
L_38:
	MOV	EAX,00H
L_39:
	ADD	EAX,DWORD [EDI+0CH]
L_35:
	MOV	DWORD [ESI+0CH],EAX
;
; Line 58:	wnd->rc.tp = max(wnd->rc.tp,GetClientTop(parent));
;
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,0100H
	JE	SHORT	L_42
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_42
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,010000H
	JE	SHORT	L_42
	MOV	EAX,03H
	JMP	SHORT	L_43
L_42:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,0100H
	JE	SHORT	L_47
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_46
L_47:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,0100H
	JE	SHORT	L_44
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,010000H
	JE	SHORT	L_44
L_46:
	MOV	EAX,02H
	JMP	SHORT	L_45
L_44:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,014108H
	JE	SHORT	L_48
	MOV	EAX,01H
	JMP	SHORT	L_49
L_48:
	MOV	EAX,00H
L_49:
L_45:
L_43:
	ADD	EAX,DWORD [EDI+010H]
	CMP	DWORD [ESI+010H],EAX
	JLE	SHORT	L_40
	MOV	EAX,DWORD [ESI+010H]
	JMP	SHORT	L_41
L_40:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,0100H
	JE	SHORT	L_50
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_50
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,010000H
	JE	SHORT	L_50
	MOV	EAX,03H
	JMP	SHORT	L_51
L_50:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,0100H
	JE	SHORT	L_55
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_54
L_55:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,0100H
	JE	SHORT	L_52
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,010000H
	JE	SHORT	L_52
L_54:
	MOV	EAX,02H
	JMP	SHORT	L_53
L_52:
	MOV	EAX,DWORD [EDI+054H]
	AND	EAX,014108H
	JE	SHORT	L_56
	MOV	EAX,01H
	JMP	SHORT	L_57
L_56:
	MOV	EAX,00H
L_57:
L_53:
L_51:
	ADD	EAX,DWORD [EDI+010H]
L_41:
	MOV	DWORD [ESI+010H],EAX
L_32:
	JMP	SHORT	L_31
L_30:
;
; Line 62:	parent = ApplicationWindow;
;
	MOV	EDI,DWORD [_ApplicationWindow]
L_31:
;
; Line 63:	wnd->Class = Class;
;
	MOV	EAX,DWORD [EBP+08H]
	MOV	DWORD [ESI+00H],EAX
;
; Line 64:	wnd->extension = extension;
;
	MOV	EAX,DWORD [EBP+020H]
	MOV	DWORD [ESI+06CH],EAX
;
; Line 65:	wnd->rc.rt = GetLeft(wnd)+width-1;
;
	MOV	EAX,DWORD [ESI+0CH]
	ADD	EAX,DWORD [EBP+01CH]
	DEC	EAX
	MOV	DWORD [ESI+014H],EAX
;
; Line 66:	wnd->rc.bt = GetTop(wnd)+height-1;
;
	MOV	EAX,DWORD [ESI+010H]
	ADD	EAX,DWORD [EBP+018H]
	DEC	EAX
	MOV	DWORD [ESI+018H],EAX
;
; Line 67:	wnd->ht = height;
;
	MOV	EAX,DWORD [EBP+018H]
	MOV	DWORD [ESI+01CH],EAX
;
; Line 68:	wnd->wd = width;
;
	MOV	EAX,DWORD [EBP+01CH]
	MOV	DWORD [ESI+020H],EAX
;
; Line 69:	if (ttl != NULL)
;
	CMP	DWORD [EBP+0CH],BYTE 00H
	JE	SHORT	L_58
;
; Line 70:	InsertTitle(wnd, ttl);
;
	PUSH	DWORD [EBP+0CH]
	PUSH	ESI
	CALL	_InsertTitle
	ADD	ESP,BYTE 08H
L_58:
;
; Line 71:	wnd->parent = parent;
;
	MOV	DWORD [ESI+03CH],EDI
;
; Line 72:	wnd->oldcondition = wnd->condition = ISRESTORED;
;
	MOV	DWORD [ESI+05CH],00H
	MOV	DWORD [ESI+060H],00H
;
; Line 73:	wnd->RestoredRC = wnd->rc;
;
	LEA	EAX,[ESI+024H]
	PUSH	ESI
	PUSH	EDI
	ADD	ESI,BYTE 0CH
	MOV	EDI,EAX
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 74:	InitWindowColors(wnd);
;
	PUSH	ESI
	CALL	_InitWindowColors
	POP	ECX
;
; Line 75:	SendMessage(wnd, CREATE_WINDOW, 0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 03H
	PUSH	ESI
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 76:	if (isVisible(wnd))
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_60
;
; Line 77:	SendMessage(wnd, SHOW_WINDOW, 0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 05H
	PUSH	ESI
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_60:
L_3:
;
; Line 79:	return wnd;
;
	MOV	EAX,ESI
L_1:
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_AddTitle]
;
; Line 83:	void AddTitle(WINDOW wnd, const char *ttl)
;
_AddTitle:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	MOV	EBX,DWORD [EBP+08H]
L_63:
;
; Line 84:	{
;
;
; Line 85:	InsertTitle(wnd, ttl);
;
	PUSH	DWORD [EBP+0CH]
	PUSH	EBX
	CALL	_InsertTitle
	ADD	ESP,BYTE 08H
;
; Line 86:	SendMessage(wnd, BORDER, 0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 0AH
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 87:	}
;
L_62:
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_InsertTitle]
;
; Line 90:	void InsertTitle(WINDOW wnd, const char *ttl)
;
_InsertTitle:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD [EBP+0CH]
L_65:
;
; Line 91:	{
;
;
; Line 92:	wnd->title=DFrealloc(wnd->title,strlen(ttl)+1);
;
	PUSH	EBX
	CALL	_strlen
	POP	ECX
	INC	EAX
	PUSH	EAX
	PUSH	DWORD [ESI+04H]
	CALL	_DFrealloc
	ADD	ESP,BYTE 08H
	MOV	DWORD [ESI+04H],EAX
;
; Line 93:	strcpy(wnd->title, ttl);
;
	PUSH	EBX
	PUSH	DWORD [ESI+04H]
	CALL	_strcpy
	ADD	ESP,BYTE 08H
;
; Line 94:	}
;
L_64:
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_writeline]
;
; Line 99:	void writeline(WINDOW wnd, char *str, int x, int y, BOOL pad)
;
_writeline:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,0D8H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD [EBP+0CH]
	MOV	EDI,DWORD [EBP+010H]
L_67:
;
; Line 100:	{
;
;
; Line 106:	memset(wline, 0, 200);
;
	PUSH	DWORD 0C8H
	PUSH	BYTE 00H
	LEA	EAX,[EBP-0C8H]
	PUSH	EAX
	CALL	_memset
	ADD	ESP,BYTE 0CH
;
; Line 107:	len = LineLength(str);
;
	PUSH	EBX
	CALL	_LineLength
	POP	ECX
	MOV	DWORD [EBP-0D0H],EAX
;
; Line 108:	dif = strlen(str) - len;
;
	PUSH	EBX
	CALL	_strlen
	POP	ECX
	SUB	EAX,DWORD [EBP-0D0H]
	MOV	DWORD [EBP-0CCH],EAX
;
; Line 109:	strncpy(wline, str, ClientWidth(wnd) + dif);
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_68
	MOV	EAX,01H
	JMP	SHORT	L_69
L_68:
	MOV	EAX,00H
L_69:
	SHL	EAX,01H
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	ADD	ECX,DWORD [EBP-0CCH]
	PUSH	ECX
	PUSH	EBX
	LEA	EAX,[EBP-0C8H]
	PUSH	EAX
	CALL	_strncpy
	ADD	ESP,BYTE 0CH
;
; Line 110:	if (pad)    {
;
	CMP	DWORD [EBP+018H],BYTE 00H
	JE	SHORT	L_70
;
; Line 111:	cp = wline+strlen(wline);
;
	LEA	EAX,[EBP-0C8H]
	PUSH	EAX
	LEA	EAX,[EBP-0C8H]
	PUSH	EAX
	CALL	_strlen
	POP	ECX
	MOV	ECX,EAX
	POP	EAX
	ADD	EAX,ECX
	MOV	DWORD [EBP-0D4H],EAX
	JMP	SHORT	L_72
L_74:
;
; Line 113:	*cp++ = ' ';
;
	MOV	EAX,DWORD [EBP-0D4H]
	INC	DWORD [EBP-0D4H]
	MOV	BYTE [EAX+00H],020H
L_72:
;
; Line 112:	while (len++ < ClientWidth(wnd)-x)
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_75
	MOV	EAX,01H
	JMP	SHORT	L_76
L_75:
	MOV	EAX,00H
L_76:
	SHL	EAX,01H
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	SUB	ECX,EDI
	MOV	EAX,DWORD [EBP-0D0H]
	INC	DWORD [EBP-0D0H]
	CMP	EAX,ECX
	JL	SHORT	L_74
L_73:
L_70:
;
; Line 115:	wputs(wnd, wline, x, y);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EDI
	LEA	EAX,[EBP-0C8H]
	PUSH	EAX
	PUSH	ESI
	CALL	_wputs
	ADD	ESP,BYTE 010H
;
; Line 116:	}
;
L_66:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_twriteline]
;
; Line 118:	void twriteline(WINDOW wnd, ATTRCHR *str, int x, int y, BOOL pad)
;
_twriteline:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,019CH
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD [EBP+010H]
L_78:
;
; Line 119:	{
;
;
; Line 124:	memset(wline, 0, sizeof(wline));
;
	PUSH	DWORD 0190H
	PUSH	BYTE 00H
	LEA	EAX,[EBP-0190H]
	PUSH	EAX
	CALL	_memset
	ADD	ESP,BYTE 0CH
;
; Line 125:	len = tstrlen(str);
;
	PUSH	DWORD [EBP+0CH]
	CALL	_tstrlen
	POP	ECX
	MOV	DWORD [EBP-0198H],EAX
;
; Line 126:	memcpy(wline, str, ClientWidth(wnd) * sizeof(ATTRCHR));
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_79
	MOV	EAX,01H
	JMP	SHORT	L_80
L_79:
	MOV	EAX,00H
L_80:
	SHL	EAX,01H
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	SHL	ECX,01H
	PUSH	ECX
	PUSH	DWORD [EBP+0CH]
	LEA	EAX,[EBP-0190H]
	PUSH	EAX
	CALL	_memcpy
	ADD	ESP,BYTE 0CH
;
; Line 127:	if (pad)    {
;
	CMP	DWORD [EBP+018H],BYTE 00H
	JE	SHORT	L_81
;
; Line 128:	cp = wline+tstrlen(wline);
;
	LEA	EAX,[EBP-0190H]
	PUSH	EAX
	LEA	EAX,[EBP-0190H]
	PUSH	EAX
	CALL	_tstrlen
	POP	ECX
	MOV	ECX,EAX
	POP	EAX
	SHL	ECX,01H
	ADD	EAX,ECX
	MOV	EDI,EAX
	JMP	SHORT	L_83
L_85:
;
; Line 131:	cp->ch = ' ';
;
	MOV	BYTE [EDI+00H],020H
;
; Line 132:	cp->attrib = WndForeground(wnd) + (WndBackground(wnd) << 4);
;
	MOVSX	EAX,BYTE [ESI+035H]
	SAL	EAX,04H
	MOVSX	ECX,BYTE [ESI+034H]
	ADD	ECX,EAX
	MOV	BYTE [EDI+01H],CL
;
; Line 133:	cp++;
;
	ADD	EDI,BYTE 02H
L_83:
;
; Line 129:	while (len++ < ClientWidth(wnd)-x)
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_86
	MOV	EAX,01H
	JMP	SHORT	L_87
L_86:
	MOV	EAX,00H
L_87:
	SHL	EAX,01H
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	SUB	ECX,EBX
	MOV	EAX,DWORD [EBP-0198H]
	INC	DWORD [EBP-0198H]
	CMP	EAX,ECX
	JL	SHORT	L_85
L_84:
L_81:
;
; Line 136:	twputs(wnd, wline, x, y);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	LEA	EAX,[EBP-0190H]
	PUSH	EAX
	PUSH	ESI
	CALL	_twputs
	ADD	ESP,BYTE 010H
;
; Line 137:	}
;
L_77:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_AdjustRectangle]
;
; Line 139:	RECT AdjustRectangle(WINDOW wnd, RECT rc)
;
_AdjustRectangle:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+0CH]
	LEA	EDI,[EBP+010H]
L_89:
;
; Line 140:	{
;
;
; Line 142:	if (TestAttribute(wnd, HASBORDER))    {
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_90
;
; Line 143:	if (RectLeft(rc) == 0)
;
	CMP	DWORD [SS:EDI+00H],BYTE 00H
	JNE	SHORT	L_92
;
; Line 144:	--rc.rt;
;
	DEC	DWORD [SS:EDI+08H]
	JMP	SHORT	L_93
L_92:
;
; Line 145:	else if (RectLeft(rc) < RectRight(rc) &&
;
	MOV	EAX,DWORD [SS:EDI+00H]
	CMP	EAX,DWORD [SS:EDI+08H]
	JGE	SHORT	L_94
	MOV	EAX,DWORD [ESI+020H]
	INC	EAX
	CMP	DWORD [SS:EDI+00H],EAX
	JGE	SHORT	L_94
;
; Line 147:	--rc.lf;
;
	DEC	DWORD [SS:EDI+00H]
L_94:
L_93:
L_90:
;
; Line 149:	if (TestAttribute(wnd, HASBORDER | HASTITLEBAR))    {
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04100H
	JE	SHORT	L_96
;
; Line 150:	if (RectTop(rc) == 0)
;
	CMP	DWORD [SS:EDI+04H],BYTE 00H
	JNE	SHORT	L_98
;
; Line 151:	--rc.bt;
;
	DEC	DWORD [SS:EDI+0CH]
	JMP	SHORT	L_99
L_98:
;
; Line 152:	else if (RectTop(rc) < RectBottom(rc) &&
;
	MOV	EAX,DWORD [SS:EDI+04H]
	CMP	EAX,DWORD [SS:EDI+0CH]
	JGE	SHORT	L_100
	MOV	EAX,DWORD [ESI+01CH]
	INC	EAX
	CMP	DWORD [SS:EDI+04H],EAX
	JGE	SHORT	L_100
;
; Line 154:	--rc.tp;
;
	DEC	DWORD [SS:EDI+04H]
L_100:
L_99:
L_96:
;
; Line 157:	RectRight(rc) = max(RectLeft(rc),                         min(RectRight(rc),WindowWidth(wnd)));
;
	MOV	EAX,DWORD [SS:EDI+08H]
	CMP	EAX,DWORD [ESI+020H]
	JGE	SHORT	L_104
	MOV	EAX,DWORD [SS:EDI+08H]
	JMP	SHORT	L_105
L_104:
	MOV	EAX,DWORD [ESI+020H]
L_105:
	CMP	DWORD [SS:EDI+00H],EAX
	JLE	SHORT	L_102
	MOV	EAX,DWORD [SS:EDI+00H]
	JMP	SHORT	L_103
L_102:
	MOV	EAX,DWORD [SS:EDI+08H]
	CMP	EAX,DWORD [ESI+020H]
	JGE	SHORT	L_106
	MOV	EAX,DWORD [SS:EDI+08H]
	JMP	SHORT	L_107
L_106:
	MOV	EAX,DWORD [ESI+020H]
L_107:
L_103:
	MOV	DWORD [SS:EDI+08H],EAX
;
; Line 159:	RectBottom(rc) = max(RectTop(rc),                         min(RectBottom(rc),WindowHeight(wnd)));
;
	MOV	EAX,DWORD [SS:EDI+0CH]
	CMP	EAX,DWORD [ESI+01CH]
	JGE	SHORT	L_110
	MOV	EAX,DWORD [SS:EDI+0CH]
	JMP	SHORT	L_111
L_110:
	MOV	EAX,DWORD [ESI+01CH]
L_111:
	CMP	DWORD [SS:EDI+04H],EAX
	JLE	SHORT	L_108
	MOV	EAX,DWORD [SS:EDI+04H]
	JMP	SHORT	L_109
L_108:
	MOV	EAX,DWORD [SS:EDI+0CH]
	CMP	EAX,DWORD [ESI+01CH]
	JGE	SHORT	L_112
	MOV	EAX,DWORD [SS:EDI+0CH]
	JMP	SHORT	L_113
L_112:
	MOV	EAX,DWORD [ESI+01CH]
L_113:
L_109:
	MOV	DWORD [SS:EDI+0CH],EAX
;
; Line 160:	return rc;
;
	MOV	EAX,DWORD [EBP+08H]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EDI+00H]
	LEA	EDI,[EAX+00H]
	PUSH	DS
	PUSH	SS
	PUSH	SS
	POP	ES
	POP	DS
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	DS
	POP	EDI
	POP	ESI
	MOV	EAX,DWORD [EBP+08H]
L_88:
	POP	EDI
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_DisplayTitle]
;
; Line 164:	void DisplayTitle(WINDOW wnd, RECT *rcc)
;
_DisplayTitle:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 014H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD _line
L_115:
;
; Line 165:	{
;
;
; Line 166:	if (GetTitle(wnd) != NULL)	{
;
	CMP	DWORD [ESI+04H],BYTE 00H
	JE	NEAR	L_116
;
; Line 167:	int tlen = min(strlen(GetTitle(wnd)), WindowWidth(wnd)-3);
;
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 03H
	PUSH	EAX
	PUSH	DWORD [ESI+04H]
	CALL	_strlen
	POP	ECX
	MOV	ECX,EAX
	POP	EAX
	CMP	ECX,EAX
	JNC	SHORT	L_118
	PUSH	DWORD [ESI+04H]
	CALL	_strlen
	POP	ECX
	JMP	SHORT	L_119
L_118:
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 03H
L_119:
	MOV	DWORD [EBP-014H],EAX
;
; Line 168:	int tend = WindowWidth(wnd)-3-BorderAdj(wnd);
;
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 03H
	MOV	ECX,DWORD [ESI+054H]
	AND	ECX,04000H
	JE	SHORT	L_120
	MOV	ECX,01H
	JMP	SHORT	L_121
L_120:
	MOV	ECX,00H
L_121:
	SUB	EAX,ECX
	MOV	EDI,EAX
;
; Line 171:	if (rcc == NULL)
;
	CMP	DWORD [EBP+0CH],BYTE 00H
	JNE	SHORT	L_122
;
; Line 172:	rc = RelativeWindowRect(wnd, WindowRect(wnd));
;
	PUSH	DWORD [ESI+0CH+0CH]
	PUSH	DWORD [ESI+0CH+08H]
	PUSH	DWORD [ESI+0CH+04H]
	PUSH	DWORD [ESI+0CH+00H]
	PUSH	ESI
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_RelativeWindowRect
	ADD	ESP,BYTE 018H
	JMP	SHORT	L_123
L_122:
;
; Line 174:	rc = *rcc;
;
	MOV	EAX,DWORD [EBP+0CH]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+00H]
	LEA	EDI,[EBP-010H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
L_123:
;
; Line 175:	rc = AdjustRectangle(wnd, rc);
;
	PUSH	DWORD [EBP-010H+0CH]
	PUSH	DWORD [EBP-010H+08H]
	PUSH	DWORD [EBP-010H+04H]
	PUSH	DWORD [EBP-010H+00H]
	PUSH	ESI
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_AdjustRectangle
	ADD	ESP,BYTE 018H
;
; Line 177:	if (SendMessage(wnd, TITLE, (PARAM) rcc, 0))    {
;
	PUSH	BYTE 00H
	PUSH	DWORD [EBP+0CH]
	PUSH	BYTE 0BH
	PUSH	ESI
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
	TEST	EAX,EAX
	JE	NEAR	L_124
;
; Line 178:	if (wnd == inFocus)    {
;
	CMP	ESI,DWORD [_inFocus]
	JNE	SHORT	L_126
;
; Line 179:	foreground = cfg.clr[TITLEBAR] [HILITE_COLOR] [FG];
;
	MOVZX	EAX,BYTE [010BH+_cfg]
	MOV	DWORD [_foreground],EAX
;
; Line 180:	background = cfg.clr[TITLEBAR] [HILITE_COLOR] [BG];
;
	MOVZX	EAX,BYTE [_cfg+010CH]
	MOV	DWORD [_background],EAX
	JMP	SHORT	L_127
L_126:
;
; Line 183:	foreground = cfg.clr[TITLEBAR] [STD_COLOR] [FG];
;
	MOVZX	EAX,BYTE [0105H+_cfg]
	MOV	DWORD [_foreground],EAX
;
; Line 184:	background = cfg.clr[TITLEBAR] [STD_COLOR] [BG];
;
	MOVZX	EAX,BYTE [0106H+_cfg]
	MOV	DWORD [_background],EAX
L_127:
;
; Line 186:	memset(line,' ',WindowWidth(wnd));
;
	PUSH	DWORD [ESI+020H]
	PUSH	BYTE 020H
	PUSH	EBX
	CALL	_memset
	ADD	ESP,BYTE 0CH
;
; Line 188:	if (wnd->condition != ISMINIMIZED)
;
	CMP	DWORD [ESI+05CH],BYTE 01H
	JE	SHORT	L_128
;
; Line 191:	strncpy(line + ((WindowWidth(wnd)-2 - tlen) / 2),
;
	PUSH	DWORD [EBP-014H]
	PUSH	DWORD [ESI+04H]
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 02H
	SUB	EAX,DWORD [EBP-014H]
	SAR	EAX,01H
	JNS	SHORT	L_130
	ADC	EAX,BYTE 00H
L_130:
	ADD	EAX,EBX
	PUSH	EAX
	CALL	_strncpy
	ADD	ESP,BYTE 0CH
;
; Line 193:	if (wnd->TextChanged)
;
	CMP	DWORD [ESI+0E4H],BYTE 00H
	JE	SHORT	L_131
;
; Line 195:	line[((WindowWidth(wnd) - 2 - tlen) / 2) + tlen] = '*';
;
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 02H
	SUB	EAX,DWORD [EBP-014H]
	SAR	EAX,01H
	JNS	SHORT	L_133
	ADC	EAX,BYTE 00H
L_133:
	MOV	ECX,DWORD [EBP-014H]
	LEA	EAX,[EAX+ECX+00H]
	MOV	BYTE [EBX+EAX+00H],02AH
;
; Line 196:	tlen++;
;
	INC	DWORD [EBP-014H]
L_131:
L_128:
;
; Line 199:	if (TestAttribute(wnd, CONTROLBOX))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0200H
	JE	SHORT	L_134
;
; Line 200:	line[2-BorderAdj(wnd)] = CONTROLBOXCHAR;
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_136
	MOV	EAX,01H
	JMP	SHORT	L_137
L_136:
	MOV	EAX,00H
L_137:
	MOV	ECX,02H
	SUB	ECX,EAX
	MOV	BYTE [EBX+ECX+00H],0F0H
L_134:
;
; Line 201:	if (TestAttribute(wnd, MINMAXBOX))    {
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0400H
	JE	SHORT	L_138
;
; Line 202:	switch (wnd->condition)    {
;
	MOV	EAX,DWORD [ESI+05CH]
	CMP	EAX,BYTE 00H
	JE	SHORT	L_142
	CMP	EAX,BYTE 01H
	JE	SHORT	L_143
	CMP	EAX,BYTE 02H
	JE	SHORT	L_144
	JMP	SHORT	L_141
L_142:
;
; Line 205:	line[tend+1] = MAXPOINTER;
;
	MOV	BYTE [EBX+EDI+01H],018H
;
; Line 208:	line[tend]   = MINPOINTER;
;
	MOV	BYTE [EBX+EDI+00H],019H
;
; Line 210:	break;
;
	JMP	SHORT	L_140
L_143:
;
; Line 213:	line[tend+1] = MAXPOINTER;
;
	MOV	BYTE [EBX+EDI+01H],018H
;
; Line 214:	break;
;
	JMP	SHORT	L_140
L_144:
;
; Line 219:	line[tend]   = MINPOINTER;
;
	MOV	BYTE [EBX+EDI+00H],019H
;
; Line 222:	line[tend+1] = RESTOREPOINTER;
;
	MOV	BYTE [EBX+EDI+01H],012H
;
; Line 224:	break;
;
	JMP	SHORT	L_140
L_141:
;
; Line 227:	break;
;
	JMP	SHORT	L_140
L_140:
L_138:
;
; Line 230:	line[RectRight(rc)+1] = line[tend+3] = '\0';
;
	MOV	BYTE [EBX+EDI+03H],00H
	MOV	EAX,DWORD [EBP-08H]
	MOV	BYTE [EBX+EAX+01H],00H
;
; Line 231:	if (wnd != inFocus)
;
	CMP	ESI,DWORD [_inFocus]
	JE	SHORT	L_145
;
; Line 232:	ClipString++;
;
	INC	DWORD [_ClipString]
L_145:
;
; Line 233:	writeline(wnd, line+RectLeft(rc),
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_147
	MOV	EAX,01H
	JMP	SHORT	L_148
L_147:
	MOV	EAX,00H
L_148:
	ADD	EAX,DWORD [EBP-010H]
	PUSH	EAX
	MOV	EAX,EBX
	ADD	EAX,DWORD [EBP-010H]
	PUSH	EAX
	PUSH	ESI
	CALL	_writeline
	ADD	ESP,BYTE 014H
;
; Line 237:	ClipString = 0;
;
	MOV	DWORD [_ClipString],00H
L_124:
L_116:
;
; Line 240:	}
;
L_114:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 261:	static void near shadow_char(WINDOW wnd, int y)
;
_shadow_char:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 010H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EDI,DWORD [EBP+0CH]
L_150:
;
; Line 262:	{
;
;
; Line 263:	int fg = foreground;
;
	MOV	EAX,DWORD [_foreground]
	MOV	DWORD [EBP-0CH],EAX
;
; Line 264:	int bg = background;
;
	MOV	EAX,DWORD [_background]
	MOV	DWORD [EBP-08H],EAX
;
; Line 265:	int x = WindowWidth(wnd);
;
	MOV	EBX,DWORD [ESI+020H]
;
; Line 266:	int c = videochar(GetLeft(wnd)+x, GetTop(wnd)+y);
;
	MOV	EAX,DWORD [ESI+010H]
	ADD	EAX,EDI
	PUSH	EAX
	MOV	EAX,DWORD [ESI+0CH]
	ADD	EAX,EBX
	PUSH	EAX
	CALL	_GetVideoChar
	ADD	ESP,BYTE 08H
	MOVZX	EAX,AL
	MOV	DWORD [EBP-04H],EAX
;
; Line 268:	if (NoShadow(wnd))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 01H
	JE	SHORT	L_153
	CMP	DWORD [ESI+05CH],BYTE 01H
	JE	SHORT	L_153
	CMP	DWORD [ESI+05CH],BYTE 02H
	JE	SHORT	L_153
	CMP	BYTE [0BH+_cfg],BYTE 00H
	JE	SHORT	L_151
L_153:
;
; Line 269:	return;
;
	JMP	SHORT	L_149
L_151:
;
; Line 270:	foreground = DARKGRAY;
;
	MOV	DWORD [_foreground],08H
;
; Line 271:	background = BLACK;
;
	MOV	DWORD [_background],00H
;
; Line 272:	wputch(wnd, c, x, y);
;
	PUSH	EDI
	PUSH	EBX
	PUSH	DWORD [EBP-04H]
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
;
; Line 273:	foreground = fg;
;
	MOV	EAX,DWORD [EBP-0CH]
	MOV	DWORD [_foreground],EAX
;
; Line 274:	background = bg;
;
	MOV	EAX,DWORD [EBP-08H]
	MOV	DWORD [_background],EAX
;
; Line 275:	}
;
L_149:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 278:	static void near shadowline(WINDOW wnd, RECT rc)
;
_shadowline:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 010H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD _line
L_155:
;
; Line 279:	{
;
;
; Line 281:	int y = GetBottom(wnd)+1;
;
	MOV	EAX,DWORD [ESI+018H]
	INC	EAX
	MOV	DWORD [EBP-0CH],EAX
;
; Line 282:	int fg = foreground;
;
	MOV	EAX,DWORD [_foreground]
	MOV	DWORD [EBP-08H],EAX
;
; Line 283:	int bg = background;
;
	MOV	EAX,DWORD [_background]
	MOV	DWORD [EBP-04H],EAX
;
; Line 285:	if (NoShadow(wnd))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 01H
	JE	SHORT	L_158
	CMP	DWORD [ESI+05CH],BYTE 01H
	JE	SHORT	L_158
	CMP	DWORD [ESI+05CH],BYTE 02H
	JE	SHORT	L_158
	CMP	BYTE [0BH+_cfg],BYTE 00H
	JE	SHORT	L_156
L_158:
;
; Line 286:	return;
;
	JMP	NEAR	L_154
L_156:
	MOV	EDI,00H
	JMP	SHORT	L_161
L_159:
;
; Line 288:	line[i] = videochar(GetLeft(wnd)+i, y);
;
	PUSH	DWORD [EBP-0CH]
	MOV	EAX,DWORD [ESI+0CH]
	ADD	EAX,EDI
	PUSH	EAX
	CALL	_GetVideoChar
	ADD	ESP,BYTE 08H
	MOVZX	EAX,AL
	MOV	BYTE [EBX+EDI+00H],AL
;
; Line 287:	for (i = 0; i < WindowWidth(wnd)+1; i++)
;
L_160:
	INC	EDI
L_161:
	MOV	EAX,DWORD [ESI+020H]
	INC	EAX
	CMP	EDI,EAX
	JL	SHORT	L_159
L_162:
;
; Line 289:	line[i] = '\0';
;
	MOV	BYTE [EBX+EDI+00H],00H
;
; Line 290:	foreground = DARKGRAY;
;
	MOV	DWORD [_foreground],08H
;
; Line 291:	background = BLACK;
;
	MOV	DWORD [_background],00H
;
; Line 292:	line[RectRight(rc)+1] = '\0';
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	BYTE [EBX+EAX+01H],00H
;
; Line 293:	if (RectLeft(rc) == 0)
;
	CMP	DWORD [EBP+0CH],BYTE 00H
	JNE	SHORT	L_163
;
; Line 294:	rc.lf++;
;
	INC	DWORD [EBP+0CH]
L_163:
;
; Line 295:	ClipString++;
;
	INC	DWORD [_ClipString]
;
; Line 296:	wputs(wnd, line+RectLeft(rc), RectLeft(rc),
;
	PUSH	DWORD [ESI+01CH]
	PUSH	DWORD [EBP+0CH]
	MOV	EAX,EBX
	ADD	EAX,DWORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	_wputs
	ADD	ESP,BYTE 010H
;
; Line 298:	--ClipString;
;
	DEC	DWORD [_ClipString]
;
; Line 299:	foreground = fg;
;
	MOV	EAX,DWORD [EBP-08H]
	MOV	DWORD [_foreground],EAX
;
; Line 300:	background = bg;
;
	MOV	EAX,DWORD [EBP-04H]
	MOV	DWORD [_background],EAX
;
; Line 301:	}
;
L_154:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 303:	static RECT ParamRect(WINDOW wnd, RECT *rcc)
;
_ParamRect:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 014H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+0CH]
	LEA	EDI,[EBP-010H]
	MOV	EBX,DWORD [EBP+010H]
L_166:
;
; Line 304:	{
;
;
; Line 306:	if (rcc == NULL)    {
;
	TEST	EBX,EBX
	JNE	SHORT	L_167
;
; Line 307:	rc = RelativeWindowRect(wnd, WindowRect(wnd));
;
	PUSH	DWORD [ESI+0CH+0CH]
	PUSH	DWORD [ESI+0CH+08H]
	PUSH	DWORD [ESI+0CH+04H]
	PUSH	DWORD [ESI+0CH+00H]
	PUSH	ESI
	PUSH	EDI
	CALL	_RelativeWindowRect
	ADD	ESP,BYTE 018H
;
; Line 308:	if (TestAttribute(wnd, SHADOW))    {
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 01H
	JE	SHORT	L_169
;
; Line 309:	rc.rt++;
;
	INC	DWORD [SS:EDI+08H]
;
; Line 310:	rc.bt++;
;
	INC	DWORD [SS:EDI+0CH]
L_169:
	JMP	SHORT	L_168
L_167:
;
; Line 314:	rc = *rcc;
;
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBX+00H]
	PUSH	ES
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	ES
	POP	EDI
	POP	ESI
L_168:
;
; Line 315:	return rc;
;
	MOV	EAX,DWORD [EBP+08H]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EDI+00H]
	LEA	EDI,[EAX+00H]
	PUSH	DS
	PUSH	SS
	PUSH	SS
	POP	ES
	POP	DS
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	DS
	POP	EDI
	POP	ESI
	MOV	EAX,DWORD [EBP+08H]
L_165:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_PaintShadow]
;
; Line 318:	void PaintShadow(WINDOW wnd)
;
_PaintShadow:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 024H
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD [EBP+08H]
L_172:
;
; Line 319:	{
;
;
; Line 321:	RECT rc = ParamRect(wnd, NULL);
;
	PUSH	BYTE 00H
	PUSH	ESI
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_ParamRect
	ADD	ESP,BYTE 0CH
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+00H]
	LEA	EDI,[EBP-020H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
	MOV	EBX,01H
	JMP	SHORT	L_175
L_173:
;
; Line 323:	shadow_char(wnd, y);
;
	PUSH	EBX
	PUSH	ESI
	CALL	_shadow_char
	ADD	ESP,BYTE 08H
;
; Line 322:	for (y = 1; y < WindowHeight(wnd); y++)
;
L_174:
	INC	EBX
L_175:
	CMP	EBX,DWORD [ESI+01CH]
	JL	SHORT	L_173
L_176:
;
; Line 324:	shadowline(wnd, rc);
;
	PUSH	DWORD [EBP-020H+0CH]
	PUSH	DWORD [EBP-020H+08H]
	PUSH	DWORD [EBP-020H+04H]
	PUSH	DWORD [EBP-020H+00H]
	PUSH	ESI
	CALL	_shadowline
	ADD	ESP,BYTE 014H
;
; Line 325:	}
;
L_171:
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 327:	static unsigned int SeCorner(WINDOW wnd, unsigned int stdse)
;
_SeCorner:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	MOV	ESI,DWORD [EBP+08H]
L_178:
;
; Line 328:	{
;
;
; Line 329:	if (TestAttribute(wnd, SIZEABLE) && wnd->condition == ISRESTORED)
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 04H
	JE	SHORT	L_179
	CMP	DWORD [ESI+05CH],BYTE 00H
	JNE	SHORT	L_179
;
; Line 330:	return SIZETOKEN;
;
	MOV	EAX,04H
	JMP	SHORT	L_177
L_179:
;
; Line 331:	return stdse;
;
	MOV	EAX,DWORD [EBP+0CH]
L_177:
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_RepaintBorder]
;
; Line 335:	void RepaintBorder(WINDOW wnd, RECT *rcc)
;
_RepaintBorder:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 03CH
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
L_182:
;
; Line 336:	{
;
;
; Line 341:	if (!TestAttribute(wnd, HASBORDER))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	NEAR	L_181
;
; Line 342:	return;
;
L_183:
;
; Line 343:	rc = ParamRect(wnd, rcc);
;
	PUSH	DWORD [EBP+0CH]
	PUSH	ESI
	LEA	EAX,[EBP-020H]
	PUSH	EAX
	CALL	_ParamRect
	ADD	ESP,BYTE 0CH
;
; Line 344:	clrc = AdjustRectangle(wnd, rc);
;
	PUSH	DWORD [EBP-020H+0CH]
	PUSH	DWORD [EBP-020H+08H]
	PUSH	DWORD [EBP-020H+04H]
	PUSH	DWORD [EBP-020H+00H]
	PUSH	ESI
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_AdjustRectangle
	ADD	ESP,BYTE 018H
;
; Line 346:	if (wnd == inFocus)    {
;
	CMP	ESI,DWORD [_inFocus]
	JNE	SHORT	L_185
;
; Line 347:	lin  = FOCUS_LINE;
;
	MOV	DWORD [EBP-038H],0CDH
;
; Line 348:	side = FOCUS_SIDE;
;
	MOV	DWORD [EBP-034H],0BAH
;
; Line 349:	ne   = FOCUS_NE;
;
	MOV	DWORD [EBP-030H],0BBH
;
; Line 350:	nw   = FOCUS_NW;
;
	MOV	DWORD [EBP-02CH],0C9H
;
; Line 351:	se   = SeCorner(wnd, FOCUS_SE);
;
	PUSH	DWORD 0BCH
	PUSH	ESI
	CALL	_SeCorner
	ADD	ESP,BYTE 08H
	MOV	DWORD [EBP-028H],EAX
;
; Line 352:	sw   = FOCUS_SW;
;
	MOV	DWORD [EBP-024H],0C8H
	JMP	SHORT	L_186
L_185:
;
; Line 355:	lin  = LINE;
;
	MOV	DWORD [EBP-038H],0C4H
;
; Line 356:	side = SIDE;
;
	MOV	DWORD [EBP-034H],0B3H
;
; Line 357:	ne   = NE;
;
	MOV	DWORD [EBP-030H],0BFH
;
; Line 358:	nw   = NW;
;
	MOV	DWORD [EBP-02CH],0DAH
;
; Line 359:	se   = SeCorner(wnd, SE);
;
	PUSH	DWORD 0D9H
	PUSH	ESI
	CALL	_SeCorner
	ADD	ESP,BYTE 08H
	MOV	DWORD [EBP-028H],EAX
;
; Line 360:	sw   = SW;
;
	MOV	DWORD [EBP-024H],0C0H
L_186:
;
; Line 362:	line[WindowWidth(wnd)] = '\0';
;
	MOV	EAX,DWORD [ESI+020H]
	MOV	BYTE [EAX+_line+00H],00H
;
; Line 364:	if (TestAttribute(wnd, HASTITLEBAR))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_187
;
; Line 365:	if (RectTop(rc) == 0)
;
	CMP	DWORD [EBP-01CH],BYTE 00H
	JNE	SHORT	L_189
;
; Line 366:	if (RectLeft(rc) < WindowWidth(wnd)-BorderAdj(wnd))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_193
	MOV	EAX,01H
	JMP	SHORT	L_194
L_193:
	MOV	EAX,00H
L_194:
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	CMP	DWORD [EBP-020H],ECX
	JGE	SHORT	L_191
;
; Line 367:	DisplayTitle(wnd, &rc);
;
	LEA	EAX,[EBP-020H]
	PUSH	EAX
	PUSH	ESI
	CALL	_DisplayTitle
	ADD	ESP,BYTE 08H
L_191:
L_189:
L_187:
;
; Line 368:	foreground = FrameForeground(wnd);
;
	MOVSX	EAX,BYTE [ESI+038H]
	MOV	DWORD [_foreground],EAX
;
; Line 369:	background = FrameBackground(wnd);
;
	MOVSX	EAX,BYTE [ESI+039H]
	MOV	DWORD [_background],EAX
;
; Line 371:	if (RectTop(rc) == 0)    {
;
	CMP	DWORD [EBP-01CH],BYTE 00H
	JNE	SHORT	L_195
;
; Line 372:	if (RectLeft(rc) == 0)
;
	CMP	DWORD [EBP-020H],BYTE 00H
	JNE	SHORT	L_197
;
; Line 373:	wputch(wnd, nw, 0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	DWORD [EBP-02CH]
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
L_197:
;
; Line 374:	if (RectLeft(rc) < WindowWidth(wnd))    {
;
	MOV	EAX,DWORD [EBP-020H]
	CMP	EAX,DWORD [ESI+020H]
	JGE	SHORT	L_199
;
; Line 375:	if (RectRight(rc) >= WindowWidth(wnd)-1)
;
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	CMP	DWORD [EBP-018H],EAX
	JL	SHORT	L_201
;
; Line 376:	wputch(wnd, ne, WindowWidth(wnd)-1, 0);
;
	PUSH	BYTE 00H
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	PUSH	EAX
	PUSH	DWORD [EBP-030H]
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
L_201:
;
; Line 377:	TopLine(wnd, lin, clrc);
;
	PUSH	DWORD [EBP-010H+0CH]
	PUSH	DWORD [EBP-010H+08H]
	PUSH	DWORD [EBP-010H+04H]
	PUSH	DWORD [EBP-010H+00H]
	PUSH	DWORD [EBP-038H]
	PUSH	ESI
	CALL	_TopLine
	ADD	ESP,BYTE 018H
L_199:
L_195:
	MOV	EBX,DWORD [EBP-01CH]
	JMP	NEAR	L_205
L_203:
;
; Line 384:	if (y == 0 || y >= WindowHeight(wnd)-1)
;
	TEST	EBX,EBX
	JE	SHORT	L_209
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	CMP	EBX,EAX
	JL	SHORT	L_207
L_209:
;
; Line 385:	continue;
;
	JMP	NEAR	L_204
L_207:
;
; Line 386:	if (RectLeft(rc) == 0)
;
	CMP	DWORD [EBP-020H],BYTE 00H
	JNE	SHORT	L_210
;
; Line 387:	wputch(wnd, side, 0, y);
;
	PUSH	EBX
	PUSH	BYTE 00H
	PUSH	DWORD [EBP-034H]
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
L_210:
;
; Line 388:	if (RectLeft(rc) < WindowWidth(wnd) &&
;
	MOV	EAX,DWORD [EBP-020H]
	CMP	EAX,DWORD [ESI+020H]
	JGE	SHORT	L_212
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	CMP	DWORD [EBP-018H],EAX
	JL	SHORT	L_212
;
; Line 390:	if (TestAttribute(wnd, VSCROLLBAR))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 010H
	JE	SHORT	L_214
;
; Line 391:	ch = (    y == 1 ? UPSCROLLBOX      :
;
	CMP	EBX,BYTE 01H
	JNE	SHORT	L_216
	MOV	EAX,01EH
	JMP	SHORT	L_217
L_216:
	MOV	EAX,DWORD [ESI+01CH]
	SUB	EAX,BYTE 02H
	CMP	EBX,EAX
	JNE	SHORT	L_218
	MOV	EAX,01FH
	JMP	SHORT	L_219
L_218:
	MOV	EAX,EBX
	DEC	EAX
	CMP	EAX,DWORD [ESI+0C0H]
	JNE	SHORT	L_220
	MOV	EAX,0B2H
	JMP	SHORT	L_221
L_220:
	MOV	EAX,0B0H
L_221:
L_219:
L_217:
	MOV	EDI,EAX
	JMP	SHORT	L_215
L_214:
;
; Line 398:	ch = side;
;
	MOV	EDI,DWORD [EBP-034H]
L_215:
;
; Line 399:	wputch(wnd, ch, WindowWidth(wnd)-1, y);
;
	PUSH	EBX
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	PUSH	EAX
	PUSH	EDI
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
L_212:
;
; Line 401:	if (RectRight(rc) == WindowWidth(wnd))
;
	MOV	EAX,DWORD [EBP-018H]
	CMP	EAX,DWORD [ESI+020H]
	JNE	SHORT	L_222
;
; Line 402:	shadow_char(wnd, y);
;
	PUSH	EBX
	PUSH	ESI
	CALL	_shadow_char
	ADD	ESP,BYTE 08H
L_222:
;
; Line 382:	for (y = RectTop(rc); y <= RectBottom(rc); y++)    {
;
L_204:
	INC	EBX
L_205:
	CMP	EBX,DWORD [EBP-014H]
	JLE	NEAR	L_203
L_206:
;
; Line 405:	if (RectTop(rc) <= WindowHeight(wnd)-1 &&
;
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	CMP	DWORD [EBP-01CH],EAX
	JG	NEAR	L_224
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	CMP	DWORD [EBP-014H],EAX
	JL	NEAR	L_224
;
; Line 408:	if (RectLeft(rc) == 0)
;
	CMP	DWORD [EBP-020H],BYTE 00H
	JNE	SHORT	L_226
;
; Line 409:	wputch(wnd, sw, 0, WindowHeight(wnd)-1);
;
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	PUSH	DWORD [EBP-024H]
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
L_226:
;
; Line 410:	if (RectLeft(rc) < WindowWidth(wnd) &&
;
	MOV	EAX,DWORD [EBP-020H]
	CMP	EAX,DWORD [ESI+020H]
	JGE	SHORT	L_228
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	CMP	DWORD [EBP-018H],EAX
	JL	SHORT	L_228
;
; Line 412:	wputch(wnd, se, WindowWidth(wnd)-1,
;
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	PUSH	EAX
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	PUSH	EAX
	PUSH	DWORD [EBP-028H]
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
L_228:
;
; Line 416:	if (wnd->StatusBar == NULL)	{
;
	CMP	DWORD [ESI+084H],BYTE 00H
	JNE	NEAR	L_230
;
; Line 418:	memset(line,lin,WindowWidth(wnd)-1);
;
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	PUSH	EAX
	PUSH	DWORD [EBP-038H]
	PUSH	DWORD _line
	CALL	_memset
	ADD	ESP,BYTE 0CH
;
; Line 419:	if (TestAttribute(wnd, HSCROLLBAR))    {
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 020H
	JE	SHORT	L_232
;
; Line 420:	line[0] = LEFTSCROLLBOX;
;
	MOV	BYTE [_line],011H
;
; Line 421:	line[WindowWidth(wnd)-3] = RIGHTSCROLLBOX;
;
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 03H
	MOV	BYTE [EAX+_line+00H],010H
;
; Line 422:	memset(line+1, SCROLLBARCHAR, WindowWidth(wnd)-4);
;
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 04H
	PUSH	EAX
	PUSH	DWORD 0B0H
	MOV	EAX,DWORD 01H+_line
	PUSH	EAX
	CALL	_memset
	ADD	ESP,BYTE 0CH
;
; Line 423:	line[wnd->HScrollBox] = SCROLLBOXCHAR;
;
	MOV	EAX,DWORD [ESI+0BCH]
	MOV	BYTE [EAX+_line+00H],0B2H
L_232:
;
; Line 425:	line[WindowWidth(wnd)-2] = line[RectRight(rc)] = '\0';
;
	MOV	EAX,DWORD [EBP-018H]
	MOV	BYTE [EAX+_line+00H],00H
	MOV	EAX,DWORD [ESI+020H]
	SUB	EAX,BYTE 02H
	MOV	BYTE [EAX+_line+00H],00H
;
; Line 426:	if (RectLeft(rc) != RectRight(rc) ||
;
	MOV	EAX,DWORD [EBP-020H]
	CMP	EAX,DWORD [EBP-018H]
	JNE	SHORT	L_236
	CMP	DWORD [EBP-020H],BYTE 00H
	JE	SHORT	L_234
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	CMP	DWORD [EBP-020H],EAX
	JGE	SHORT	L_234
L_236:
;
; Line 428:	if (wnd != inFocus)
;
	CMP	ESI,DWORD [_inFocus]
	JE	SHORT	L_237
;
; Line 429:	ClipString++;
;
	INC	DWORD [_ClipString]
L_237:
;
; Line 430:	writeline(wnd,
;
	PUSH	BYTE 00H
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	PUSH	EAX
	MOV	EAX,DWORD [EBP-010H]
	INC	EAX
	PUSH	EAX
	MOV	EAX,DWORD [EBP-010H]
	ADD	EAX,DWORD _line
	PUSH	EAX
	PUSH	ESI
	CALL	_writeline
	ADD	ESP,BYTE 014H
;
; Line 435:	ClipString = 0;
;
	MOV	DWORD [_ClipString],00H
L_234:
L_230:
;
; Line 438:	if (RectRight(rc) == WindowWidth(wnd))
;
	MOV	EAX,DWORD [EBP-018H]
	CMP	EAX,DWORD [ESI+020H]
	JNE	SHORT	L_239
;
; Line 439:	shadow_char(wnd, WindowHeight(wnd)-1);
;
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	PUSH	EAX
	PUSH	ESI
	CALL	_shadow_char
	ADD	ESP,BYTE 08H
L_239:
L_224:
;
; Line 441:	if (RectBottom(rc) == WindowHeight(wnd))
;
	MOV	EAX,DWORD [EBP-014H]
	CMP	EAX,DWORD [ESI+01CH]
	JNE	SHORT	L_241
;
; Line 443:	shadowline(wnd, rc);
;
	PUSH	DWORD [EBP-020H+0CH]
	PUSH	DWORD [EBP-020H+08H]
	PUSH	DWORD [EBP-020H+04H]
	PUSH	DWORD [EBP-020H+00H]
	PUSH	ESI
	CALL	_shadowline
	ADD	ESP,BYTE 014H
L_241:
;
; Line 444:	}
;
L_181:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 446:	static void TopLine(WINDOW wnd, int lin, RECT rc)
;
_TopLine:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EDI,DWORD _line
	LEA	EBX,[EBP+010H]
L_245:
;
; Line 447:	{
;
;
; Line 448:	if (TestAttribute(wnd, HASMENUBAR) || TestAttribute(wnd, HASTABBAR))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_248
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_246
L_248:
;
; Line 449:	return;
;
	JMP	NEAR	L_244
L_246:
;
; Line 450:	if (TestAttribute(wnd, HASTITLEBAR) && GetTitle(wnd))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_249
	CMP	DWORD [ESI+04H],BYTE 00H
	JNE	NEAR	L_244
;
; Line 451:	return;
;
L_249:
;
; Line 452:	if (RectLeft(rc) == 0)	{
;
	CMP	DWORD [SS:EBX+00H],BYTE 00H
	JNE	SHORT	L_251
;
; Line 453:	RectLeft(rc) += BorderAdj(wnd);
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_253
	MOV	EAX,01H
	JMP	SHORT	L_254
L_253:
	MOV	EAX,00H
L_254:
	ADD	DWORD [SS:EBX+00H],EAX
;
; Line 454:	RectRight(rc) += BorderAdj(wnd);
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_255
	MOV	EAX,01H
	JMP	SHORT	L_256
L_255:
	MOV	EAX,00H
L_256:
	ADD	DWORD [SS:EBX+08H],EAX
L_251:
;
; Line 456:	if (RectRight(rc) < WindowWidth(wnd)-1)
;
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	CMP	DWORD [SS:EBX+08H],EAX
	JGE	SHORT	L_257
;
; Line 457:	RectRight(rc)++;
;
	INC	DWORD [SS:EBX+08H]
L_257:
;
; Line 459:	if (RectLeft(rc) < RectRight(rc))    {
;
	MOV	EAX,DWORD [SS:EBX+00H]
	CMP	EAX,DWORD [SS:EBX+08H]
	JGE	SHORT	L_259
;
; Line 461:	memset(line,lin,WindowWidth(wnd)-1);
;
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	PUSH	EAX
	PUSH	DWORD [EBP+0CH]
	PUSH	EDI
	CALL	_memset
	ADD	ESP,BYTE 0CH
;
; Line 462:	if (TestAttribute(wnd, CONTROLBOX))	{
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0200H
	JE	SHORT	L_261
;
; Line 463:	strncpy(line+1, "   ", 3);
;
	PUSH	BYTE 03H
	PUSH	DWORD L_243
	MOV	EAX,EDI
	INC	EAX
	PUSH	EAX
	CALL	_strncpy
	ADD	ESP,BYTE 0CH
;
; Line 464:	*(line+2) = CONTROLBOXCHAR;
;
	MOV	BYTE [EDI+02H],0F0H
L_261:
;
; Line 466:	line[RectRight(rc)] = '\0';
;
	MOV	EAX,DWORD [SS:EBX+08H]
	MOV	BYTE [SS:EDI+EAX+00H],00H
;
; Line 467:	writeline(wnd, line+RectLeft(rc),
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	DWORD [SS:EBX+00H]
	MOV	EAX,EDI
	ADD	EAX,DWORD [SS:EBX+00H]
	PUSH	EAX
	PUSH	ESI
	CALL	_writeline
	ADD	ESP,BYTE 014H
L_259:
;
; Line 470:	}
;
L_244:
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_ClearWindow]
;
; Line 473:	void ClearWindow(WINDOW wnd, RECT *rcc, int clrchar)
;
_ClearWindow:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 028H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	LEA	EDI,[EBP-028H]
L_264:
;
; Line 474:	{
;
;
; Line 475:	if (isVisible(wnd))    {
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	NEAR	L_265
;
; Line 477:	RECT rc = rcc ? *rcc : RelativeWindowRect(wnd, WindowRect(wnd));
;
	CMP	DWORD [EBP+0CH],BYTE 00H
	JE	SHORT	L_267
	MOV	EAX,DWORD [EBP+0CH]
	JMP	SHORT	L_268
L_267:
	PUSH	DWORD [ESI+0CH+0CH]
	PUSH	DWORD [ESI+0CH+08H]
	PUSH	DWORD [ESI+0CH+04H]
	PUSH	DWORD [ESI+0CH+00H]
	PUSH	ESI
	LEA	EAX,[EBP-018H]
	PUSH	EAX
	CALL	_RelativeWindowRect
	ADD	ESP,BYTE 018H
L_268:
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+00H]
	PUSH	ES
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	ES
	POP	EDI
	POP	ESI
;
; Line 479:	int top = TopBorderAdj(wnd);
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_269
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_269
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_269
	MOV	EAX,03H
	JMP	SHORT	L_270
L_269:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_274
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_273
L_274:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_271
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_271
L_273:
	MOV	EAX,02H
	JMP	SHORT	L_272
L_271:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_275
	MOV	EAX,01H
	JMP	SHORT	L_276
L_275:
	MOV	EAX,00H
L_276:
L_272:
L_270:
	MOV	DWORD [EBP-08H],EAX
;
; Line 480:	int bot = WindowHeight(wnd)-1-BottomBorderAdj(wnd);
;
	MOV	EAX,DWORD [ESI+01CH]
	DEC	EAX
	MOV	ECX,DWORD [ESI+054H]
	AND	ECX,08000H
	JE	SHORT	L_277
	MOV	ECX,01H
	JMP	SHORT	L_278
L_277:
	MOV	ECX,DWORD [ESI+054H]
	AND	ECX,04000H
	JE	SHORT	L_279
	MOV	ECX,01H
	JMP	SHORT	L_280
L_279:
	MOV	ECX,00H
L_280:
L_278:
	SUB	EAX,ECX
	MOV	DWORD [EBP-04H],EAX
;
; Line 482:	if (RectLeft(rc) == 0)
;
	CMP	DWORD [SS:EDI+00H],BYTE 00H
	JNE	SHORT	L_281
;
; Line 483:	RectLeft(rc) = BorderAdj(wnd);
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_283
	MOV	EAX,01H
	JMP	SHORT	L_284
L_283:
	MOV	EAX,00H
L_284:
	MOV	DWORD [SS:EDI+00H],EAX
L_281:
;
; Line 484:	if (RectRight(rc) > WindowWidth(wnd)-1)
;
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	CMP	DWORD [SS:EDI+08H],EAX
	JLE	SHORT	L_285
;
; Line 485:	RectRight(rc) = WindowWidth(wnd)-1;
;
	MOV	EAX,DWORD [ESI+020H]
	DEC	EAX
	MOV	DWORD [SS:EDI+08H],EAX
L_285:
;
; Line 486:	SetStandardColor(wnd);
;
	PUSH	ESI
	CALL	_SetStandardColor
	POP	ECX
;
; Line 487:	memset(line, clrchar, sizeof line);
;
	PUSH	DWORD 012CH
	PUSH	DWORD [EBP+010H]
	PUSH	DWORD _line
	CALL	_memset
	ADD	ESP,BYTE 0CH
;
; Line 488:	line[RectRight(rc)+1] = '\0';
;
	MOV	EAX,DWORD [SS:EDI+08H]
	MOV	BYTE [SS:EAX+_line+01H],00H
	MOV	EBX,DWORD [SS:EDI+04H]
	JMP	SHORT	L_289
L_287:
;
; Line 490:	if (y < top || y > bot)
;
	CMP	EBX,DWORD [EBP-08H]
	JL	SHORT	L_293
	CMP	EBX,DWORD [EBP-04H]
	JLE	SHORT	L_291
L_293:
;
; Line 491:	continue;
;
	JMP	SHORT	L_288
L_291:
;
; Line 492:	writeline(wnd,
;
	PUSH	BYTE 00H
	PUSH	EBX
	PUSH	DWORD [SS:EDI+00H]
	MOV	EAX,DWORD [SS:EDI+00H]
	ADD	EAX,DWORD _line
	PUSH	EAX
	PUSH	ESI
	CALL	_writeline
	ADD	ESP,BYTE 014H
;
; Line 489:	for (y = RectTop(rc); y <= RectBottom(rc); y++)    {
;
L_288:
	INC	EBX
L_289:
	CMP	EBX,DWORD [SS:EDI+0CH]
	JLE	SHORT	L_287
L_290:
L_265:
;
; Line 499:	}
;
L_263:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_LineLength]
;
; Line 502:	int LineLength(char *ln)
;
_LineLength:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD [EBP+08H]
L_295:
;
; Line 503:	{
;
;
; Line 504:	int len = strlen(ln);
;
	PUSH	EDI
	CALL	_strlen
	POP	ECX
	MOV	ESI,EAX
;
; Line 505:	char *cp = ln;
;
	MOV	EBX,EDI
	JMP	SHORT	L_296
L_298:
;
; Line 507:	cp++;
;
	INC	EBX
;
; Line 508:	len -= 3;
;
	SUB	ESI,BYTE 03H
L_296:
;
; Line 506:	while ((cp = strchr(cp, CHANGECOLOR)) != NULL)    {
;
	PUSH	DWORD 0FCH
	PUSH	EBX
	CALL	_strchr
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
	TEST	EAX,EAX
	JNE	SHORT	L_298
L_297:
;
; Line 510:	cp = ln;
;
	MOV	EBX,EDI
	JMP	SHORT	L_299
L_301:
;
; Line 512:	cp++;
;
	INC	EBX
;
; Line 513:	--len;
;
	DEC	ESI
L_299:
;
; Line 511:	while ((cp = strchr(cp, RESETCOLOR)) != NULL)    {
;
	PUSH	DWORD 0FDH
	PUSH	EBX
	CALL	_strchr
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
	TEST	EAX,EAX
	JNE	SHORT	L_301
L_300:
;
; Line 515:	return len;
;
	MOV	EAX,ESI
L_294:
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_InitWindowColors]
;
; Line 518:	void InitWindowColors(WINDOW wnd)
;
_InitWindowColors:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD [EBP+08H]
L_303:
;
; Line 519:	{
;
;
; Line 521:	int cls = GetClass(wnd);
;
	MOV	EAX,DWORD [EDI+00H]
	MOV	DWORD [EBP-04H],EAX
;
; Line 523:	if (cfg.clr[cls][0][0] == 0xff && GetParent(wnd) != NULL)
;
	MOV	EAX,DWORD [EBP-04H]
	MOVZX	EAX,BYTE [EAX*8+055H+_cfg+00H]
	CMP	EAX,0FFH
	JNE	SHORT	L_304
	CMP	DWORD [EDI+03CH],BYTE 00H
	JE	SHORT	L_304
;
; Line 524:	cls = GetClass(GetParent(wnd));
;
	MOV	EAX,DWORD [EDI+03CH]
	MOV	EAX,DWORD [EAX+00H]
	MOV	DWORD [EBP-04H],EAX
L_304:
	MOV	ESI,00H
	JMP	SHORT	L_308
L_306:
	MOV	EBX,00H
	JMP	SHORT	L_312
L_310:
;
; Line 528:	wnd->WindowColors[col][fbg] = cfg.clr[cls][col][fbg];
;
	MOV	EAX,DWORD [EBP-04H]
	LEA	ECX,[EBX*2+00H]
	LEA	ECX,[ECX+EAX*8+055H+_cfg+00H]
	MOV	CL,BYTE [ECX+ESI+00H]
	LEA	EAX,[EDI+EBX*2+034H]
	MOV	BYTE [EAX+ESI+00H],CL
;
; Line 527:	for (col = 0; col < 4; col++)
;
L_311:
	INC	EBX
L_312:
	CMP	EBX,BYTE 04H
	JL	SHORT	L_310
L_313:
;
; Line 526:	for (fbg = 0; fbg < 2; fbg++)
;
L_307:
	INC	ESI
L_308:
	CMP	ESI,BYTE 02H
	JL	SHORT	L_306
L_309:
;
; Line 529:	}
;
L_302:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_PutWindowChar]
;
; Line 531:	void PutWindowChar(WINDOW wnd, int c, int x, int y)
;
_PutWindowChar:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD [EBP+014H]
	MOV	EDI,DWORD [EBP+010H]
L_315:
;
; Line 532:	{
;
;
; Line 533:	if (x < ClientWidth(wnd) && y < ClientHeight(wnd))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_318
	MOV	EAX,01H
	JMP	SHORT	L_319
L_318:
	MOV	EAX,00H
L_319:
	SHL	EAX,01H
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	CMP	EDI,ECX
	JGE	NEAR	L_316
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_320
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_320
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_320
	MOV	EAX,03H
	JMP	SHORT	L_321
L_320:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_325
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_324
L_325:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_322
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_322
L_324:
	MOV	EAX,02H
	JMP	SHORT	L_323
L_322:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_326
	MOV	EAX,01H
	JMP	SHORT	L_327
L_326:
	MOV	EAX,00H
L_327:
L_323:
L_321:
	MOV	ECX,DWORD [ESI+01CH]
	SUB	ECX,EAX
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,08000H
	JE	SHORT	L_328
	MOV	EAX,01H
	JMP	SHORT	L_329
L_328:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_330
	MOV	EAX,01H
	JMP	SHORT	L_331
L_330:
	MOV	EAX,00H
L_331:
L_329:
	SUB	ECX,EAX
	CMP	EBX,ECX
	JGE	NEAR	L_316
;
; Line 534:	wputch(wnd, c, x+BorderAdj(wnd), y+TopBorderAdj(wnd));
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_332
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_332
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_332
	MOV	EAX,03H
	JMP	SHORT	L_333
L_332:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_337
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_336
L_337:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_334
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_334
L_336:
	MOV	EAX,02H
	JMP	SHORT	L_335
L_334:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_338
	MOV	EAX,01H
	JMP	SHORT	L_339
L_338:
	MOV	EAX,00H
L_339:
L_335:
L_333:
	ADD	EAX,EBX
	PUSH	EAX
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_340
	MOV	EAX,01H
	JMP	SHORT	L_341
L_340:
	MOV	EAX,00H
L_341:
	ADD	EAX,EDI
	PUSH	EAX
	PUSH	DWORD [EBP+0CH]
	PUSH	ESI
	CALL	_wputch
	ADD	ESP,BYTE 010H
L_316:
;
; Line 535:	}
;
L_314:
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_PutWindowLine]
;
; Line 537:	void PutWindowLine(WINDOW wnd, void *s, int x, int y)
;
_PutWindowLine:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
L_343:
;
; Line 538:	{
;
;
; Line 539:	int saved = FALSE, sv;
;
	MOV	DWORD [EBP-04H],00H
;
; Line 540:	if (x < ClientWidth(wnd) && y < ClientHeight(wnd))	{
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_346
	MOV	EAX,01H
	JMP	SHORT	L_347
L_346:
	MOV	EAX,00H
L_347:
	SHL	EAX,01H
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	CMP	DWORD [EBP+010H],ECX
	JGE	NEAR	L_344
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_348
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_348
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_348
	MOV	EAX,03H
	JMP	SHORT	L_349
L_348:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_353
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_352
L_353:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_350
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_350
L_352:
	MOV	EAX,02H
	JMP	SHORT	L_351
L_350:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_354
	MOV	EAX,01H
	JMP	SHORT	L_355
L_354:
	MOV	EAX,00H
L_355:
L_351:
L_349:
	MOV	ECX,DWORD [ESI+01CH]
	SUB	ECX,EAX
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,08000H
	JE	SHORT	L_356
	MOV	EAX,01H
	JMP	SHORT	L_357
L_356:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_358
	MOV	EAX,01H
	JMP	SHORT	L_359
L_358:
	MOV	EAX,00H
L_359:
L_357:
	SUB	ECX,EAX
	CMP	DWORD [EBP+014H],ECX
	JGE	NEAR	L_344
;
; Line 541:	char *en = (char *)s+ClientWidth(wnd)-x;
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_360
	MOV	EAX,01H
	JMP	SHORT	L_361
L_360:
	MOV	EAX,00H
L_361:
	SHL	EAX,01H
	MOV	EDI,DWORD [ESI+020H]
	SUB	EDI,EAX
	ADD	EDI,DWORD [EBP+0CH]
	SUB	EDI,DWORD [EBP+010H]
;
; Line 542:	if (strlen(s)+x > ClientWidth(wnd))	{
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_364
	MOV	EAX,01H
	JMP	SHORT	L_365
L_364:
	MOV	EAX,00H
L_365:
	SHL	EAX,01H
	MOV	ECX,DWORD [ESI+020H]
	SUB	ECX,EAX
	PUSH	ECX
	PUSH	DWORD [EBP+0CH]
	CALL	_strlen
	POP	ECX
	POP	ECX
	ADD	EAX,DWORD [EBP+010H]
	CMP	EAX,ECX
	JBE	SHORT	L_362
;
; Line 543:	sv = *en;
;
	MOVSX	EAX,BYTE [EDI+00H]
	MOV	EBX,EAX
;
; Line 544:	*en = '\0';
;
	MOV	BYTE [EDI+00H],00H
;
; Line 545:	saved = TRUE;
;
	MOV	DWORD [EBP-04H],01H
L_362:
;
; Line 547:	ClipString++;
;
	INC	DWORD [_ClipString]
;
; Line 548:	wputs(wnd, s, x+BorderAdj(wnd), y+TopBorderAdj(wnd));
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_366
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_366
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_366
	MOV	EAX,03H
	JMP	SHORT	L_367
L_366:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_371
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_370
L_371:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_368
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_368
L_370:
	MOV	EAX,02H
	JMP	SHORT	L_369
L_368:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_372
	MOV	EAX,01H
	JMP	SHORT	L_373
L_372:
	MOV	EAX,00H
L_373:
L_369:
L_367:
	ADD	EAX,DWORD [EBP+014H]
	PUSH	EAX
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_374
	MOV	EAX,01H
	JMP	SHORT	L_375
L_374:
	MOV	EAX,00H
L_375:
	ADD	EAX,DWORD [EBP+010H]
	PUSH	EAX
	PUSH	DWORD [EBP+0CH]
	PUSH	ESI
	CALL	_wputs
	ADD	ESP,BYTE 010H
;
; Line 549:	--ClipString;
;
	DEC	DWORD [_ClipString]
;
; Line 550:	if (saved)
;
	CMP	DWORD [EBP-04H],BYTE 00H
	JE	SHORT	L_376
;
; Line 551:	*en = sv;
;
	MOV	BYTE [EDI+00H],BL
L_376:
L_344:
;
; Line 553:	}
;
L_342:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_tstrlen]
;
; Line 555:	int tstrlen(ATTRCHR *cp)
;
_tstrlen:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD [EBP+08H]
L_379:
;
; Line 556:	{
;
;
; Line 557:	ATTRCHR *q = cp;
;
	MOV	EBX,ESI
	JMP	SHORT	L_380
L_382:
;
; Line 559:	q++;
;
	ADD	EBX,BYTE 02H
L_380:
;
; Line 558:	while (q->ch)
;
	CMP	BYTE [EBX+00H],BYTE 00H
	JNE	SHORT	L_382
L_381:
;
; Line 560:	return q - cp;
;
	MOV	EAX,EBX
	SUB	EAX,ESI
	SHR	EAX,01H
L_378:
	POP	ESI
	POP	EBX
	POP	EBP
	RET
SECTION _STRING
L_243:
	DB	020H,020H,020H,00H
SECTION _DATA
[GLOBAL	_inFocus]

_inFocus	DD	00H
SECTION _BSS
[GLOBAL	_foreground]

_foreground	RESB	04H
[GLOBAL	_background]

_background	RESB	04H

_line	RESB	012CH
SECTION _CONST

SECTION _TEXT
[EXTERN	_RelativeWindowRect]
[EXTERN	_wputch]
[EXTERN	_DFrealloc]
[EXTERN	_DFcalloc]
[EXTERN	_isVisible]
[EXTERN	_strncpy]
[EXTERN	_strlen]
[EXTERN	_get_videomode]
[EXTERN	_isEGA]
[EXTERN	_ClipString]
[EXTERN	_memcpy]
[EXTERN	_cfg]
[EXTERN	_twputs]
[EXTERN	_GetVideoChar]
[EXTERN	_isVGA]
[EXTERN	_SetStandardColor]
[EXTERN	_ApplicationWindow]
[EXTERN	_classdefs]
[EXTERN	_memset]
[EXTERN	_SendMessage]
[EXTERN	___seg0040]
[EXTERN	_strchr]
[EXTERN	_wputs]
[EXTERN	_strcpy]
