	SECTION _TEXT align=1 CLASS=CODE USE32
	SECTION _DATA align=16 CLASS=DATA USE32
	SECTION _BSS align=16 CLASS=BSS USE32
	SECTION _CONST align=16 CLASS=CONST USE32
	SECTION _STRING align=4 CLASS=STRING USE32
	SECTION cstartup align=4 CLASS=INITDATA USE32
	SECTION crundown align=4 CLASS=EXITDATA USE32
	SECTION cppinit  align=4 CLASS=CPPINIT USE32
	SECTION cppexit  align=4 CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
;
; Line 62:	static void _interrupt newkeyboard(void)
;
_newkeyboard:
	PUSH	ES
	PUSH	FS
	PUSH	GS
	PUSHA
L_2:
;
; Line 63:	{
;
;
; Line 64:	asm push ds
;
	PUSH	DS
;
; Line 65:	asm push es
;
	PUSH	ES
;
; Line 66:	asm mov ds, cs:[dsSel]
;
	MOV	DS,WORD [CS:_dsSel]
;
; Line 67:	asm mov es, cs:[dsSel]
;
	MOV	ES,WORD [CS:_dsSel]
;
; Line 68:	keyportvalue = inp(KEYBOARDPORT);
;
	PUSH	BYTE 060H
	CALL	_inp
	POP	ECX
	MOV	DWORD [_keyportvalue],EAX
;
; Line 69:	dpmi_simulate_proc_int_frame(&keyboardRegs) ;
;
	PUSH	DWORD _keyboardRegs
	CALL	_dpmi_simulate_proc_int_frame
	POP	ECX
;
; Line 70:	asm pop es
;
	POP	ES
;
; Line 71:	asm pop ds
;
	POP	DS
;
; Line 72:	}
;
L_1:
	POPA
	POP	GS
	POP	FS
	POP	ES
	IRET
;
; Line 75:	static void _interrupt newtimer(void)
;
_newtimer:
	PUSH	ES
	PUSH	FS
	PUSH	GS
	PUSHA
L_4:
;
; Line 76:	{
;
;
; Line 77:	asm push ds
;
	PUSH	DS
;
; Line 78:	asm push es
;
	PUSH	ES
;
; Line 79:	asm mov ax,cs:[dsSel] ;
;
	MOV	AX,WORD [CS:_dsSel]
;
; Line 80:	asm mov ds,ax
;
	MOV	DS,AX
;
; Line 81:	asm mov es,ax
;
	MOV	ES,AX
;
; Line 82:	asm mov ecx,[stackbot] ;
;
	MOV	ECX,DWORD [_stackbot]
;
; Line 83:	asm add	ecx,TIMERSTACKSIZE-4 ;
;
	ADD	ECX,DWORD 0FFFCH
;
; Line 84:	asm mov	[oldss],ss
;
	MOV	WORD [_oldss],SS
;
; Line 85:	asm mov	[oldsp],esp
;
	MOV	DWORD [_oldsp],ESP
;
; Line 86:	asm mov	ss,ax ;
;
	MOV	SS,AX
;
; Line 87:	asm mov	esp,ecx
;
	MOV	ESP,ECX
;
; Line 89:	if (timer_running(doubletimer))
;
	CMP	DWORD [_doubletimer],BYTE 00H
	JLE	SHORT	L_5
;
; Line 90:	countdown(doubletimer);
;
	DEC	DWORD [_doubletimer]
L_5:
;
; Line 91:	if (timer_running(delaytimer))
;
	CMP	DWORD [_delaytimer],BYTE 00H
	JLE	SHORT	L_7
;
; Line 92:	countdown(delaytimer);
;
	DEC	DWORD [_delaytimer]
L_7:
;
; Line 93:	if (timer_running(clocktimer))
;
	CMP	DWORD [_clocktimer],BYTE 00H
	JLE	SHORT	L_9
;
; Line 94:	countdown(clocktimer);
;
	DEC	DWORD [_clocktimer]
L_9:
;
; Line 95:	dpmi_simulate_proc_int_frame(&timerRegs) ;
;
	PUSH	DWORD _timerRegs
	CALL	_dpmi_simulate_proc_int_frame
	POP	ECX
;
; Line 96:	asm mov ss,[oldss]
;
	MOV	SS,WORD [_oldss]
;
; Line 97:	asm mov esp,[oldsp]
;
	MOV	ESP,DWORD [_oldsp]
;
; Line 98:	asm pop es
;
	POP	ES
;
; Line 99:	asm pop ds
;
	POP	DS
;
; Line 100:	}
;
L_3:
	POPA
	POP	GS
	POP	FS
	POP	ES
	IRET
[GLOBAL	_TestCriticalError]
;
; Line 105:	int TestCriticalError(void)
;
_TestCriticalError:
	PUSH	EBX
L_15:
;
; Line 106:	{
;
;
; Line 107:	int rtn = 0;
;
	MOV	EBX,00H
;
; Line 108:	if (CriticalError)    {
;
	CMP	DWORD [_CriticalError],BYTE 00H
	JE	SHORT	L_16
;
; Line 109:	rtn = 1;
;
	MOV	EBX,01H
;
; Line 110:	CriticalError = FALSE;
;
	MOV	DWORD [_CriticalError],00H
;
; Line 111:	if (TestErrorMessage(ermsg) == FALSE)
;
	PUSH	BYTE 01H
	PUSH	BYTE 035H
	PUSH	BYTE 034H
	PUSH	DWORD L_13
	PUSH	DWORD L_12
	PUSH	DWORD _ErrorBoxProc
	PUSH	BYTE 02H
	PUSH	DWORD _ermsg
	PUSH	DWORD L_11
	PUSH	BYTE 00H
	CALL	_GenericMessage
	ADD	ESP,BYTE 028H
	TEST	EAX,EAX
	JNE	SHORT	L_18
;
; Line 112:	rtn = 2;
;
	MOV	EBX,02H
L_18:
L_16:
;
; Line 114:	return rtn;
;
	MOV	EAX,EBX
L_14:
	POP	EBX
	RET
;
; Line 118:	static void _interrupt newcrit(IREGS ir)
;
_newcrit:
	PUSH	ES
	PUSH	FS
	PUSH	GS
	PUSHA
	MOV	EBP,ESP
	LEA	ESI,[EBP+00H]
L_21:
;
; Line 119:	{
;
;
; Line 120:	if (!(ir.ax & 0x8000))     {
;
	MOV	EAX,DWORD [SS:ESI+020H]
	AND	EAX,08000H
	JNE	SHORT	L_22
;
; Line 121:	ermsg[sizeof(ermsg) - 2] = (ir.ax & 0xff) + 'A';
;
	MOVZX	EAX,BYTE [SS:ESI+020H]
	ADD	EAX,BYTE 041H
	MOV	BYTE [_ermsg+016H],AL
;
; Line 122:	CriticalError = TRUE;
;
	MOV	DWORD [_CriticalError],01H
L_22:
;
; Line 124:	ir.ax = 0;
;
	MOV	DWORD [SS:ESI+020H],00H
;
; Line 125:	}
;
L_20:
	POPA
	POP	GS
	POP	FS
	POP	ES
	IRET
;
; Line 127:	static void StopMsg(void)
;
_StopMsg:
L_25:
;
; Line 128:	{
;
;
; Line 129:	if (hasints)
;
	CMP	DWORD [_hasints],BYTE 00H
	JE	SHORT	L_26
;
; Line 131:	dpmi_set_protected_interrupt(8,OldTimerCS,(ULONG)OldTimerIP) ;
;
	PUSH	DWORD [_OldTimerIP]
	MOVZX	EAX,WORD [_OldTimerCS]
	PUSH	EAX
	PUSH	BYTE 08H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 132:	dpmi_free_memory(timerMemhand) ;
;
	PUSH	DWORD [_timerMemhand]
	CALL	_dpmi_free_memory
	POP	ECX
;
; Line 133:	dpmi_set_protected_interrupt(9,OldKeyboardCS,(ULONG)OldKeyboardIP) ;
;
	PUSH	DWORD [_OldKeyboardIP]
	MOVZX	EAX,WORD [_OldKeyboardCS]
	PUSH	EAX
	PUSH	BYTE 09H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 134:	hasints = FALSE;
;
	MOV	DWORD [_hasints],00H
L_26:
;
; Line 136:	ClearClipboard();
;
	CALL	_ClearClipboard
;
; Line 137:	ClearDialogBoxes();
;
	CALL	_ClearDialogBoxes
;
; Line 138:	ConsoleRundown();
;
	CALL	_ConsoleRundown
;
; Line 139:	hide_mousecursor();
;
	CALL	_hide_mousecursor
;
; Line 140:	}
;
L_24:
	RET
[GLOBAL	_init_messages]
;
; Line 143:	BOOL init_messages(void)
;
_init_messages:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 08H
L_29:
;
; Line 144:	{
;
;
; Line 145:	asm mov [dsSel],ds
;
	MOV	WORD [_dsSel],DS
;
; Line 146:	AllocTesting = TRUE;
;
	MOV	DWORD [_AllocTesting],01H
;
; Line 147:	if (setjmp(AllocError) != 0)	{
;
	PUSH	DWORD _AllocError
	CALL	_setjmp
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_30
;
; Line 148:	StopMsg();
;
	CALL	_StopMsg
;
; Line 149:	return FALSE;
;
	MOV	EAX,00H
	JMP	NEAR	L_28
L_30:
;
; Line 151:	resetmouse();
;
	CALL	_resetmouse
;
; Line 152:	set_mousetravel(0, SCREENWIDTH-1, 0, SCREENHEIGHT-1);
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_34
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_32
L_34:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_33
L_32:
	MOV	EAX,019H
L_33:
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 153:	ConsoleInit();
;
	CALL	_ConsoleInit
;
; Line 154:	px = py = -1;
;
	MOV	EAX,01H
	NEG	EAX
	MOV	DWORD [_py],EAX
	MOV	DWORD [_px],EAX
;
; Line 155:	pmx = pmy = -1;
;
	MOV	EAX,01H
	NEG	EAX
	MOV	DWORD [_pmy],EAX
	MOV	DWORD [_pmx],EAX
;
; Line 156:	mx = my = 0;
;
	MOV	DWORD [_my],00H
	MOV	DWORD [_mx],00H
;
; Line 157:	CaptureMouse = CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
	MOV	DWORD [_CaptureMouse],00H
;
; Line 158:	NoChildCaptureMouse = FALSE;
;
	MOV	DWORD [_NoChildCaptureMouse],00H
;
; Line 159:	NoChildCaptureKeyboard = FALSE;
;
	MOV	DWORD [_NoChildCaptureKeyboard],00H
;
; Line 160:	MsgQueueOnCtr = MsgQueueOffCtr = MsgQueueCtr = 0;
;
	MOV	DWORD [_MsgQueueCtr],00H
	MOV	DWORD [_MsgQueueOffCtr],00H
	MOV	DWORD [_MsgQueueOnCtr],00H
;
; Line 161:	EventQueueOnCtr = EventQueueOffCtr = EventQueueCtr = 0;
;
	MOV	DWORD [_EventQueueCtr],00H
	MOV	DWORD [_EventQueueOffCtr],00H
	MOV	DWORD [_EventQueueOnCtr],00H
;
; Line 162:	if (!hasints)    {
;
	CMP	DWORD [_hasints],BYTE 00H
	JNE	NEAR	L_35
;
; Line 165:	asm mov [cssel],cs
;
	MOV	WORD [EBP-08H],CS
;
; Line 166:	asm mov [dssel],ds
;
	MOV	WORD [EBP-06H],DS
;
; Line 167:	timerRegs.h.flags = 0x246 ;
;
	MOV	WORD [020H+00H+_timerRegs],0246H
;
; Line 168:	timerRegs.h.ip = *(short far *)MK_FP(__seg0000, 8 *4) ;
;
	MOV	EAX,04H
	IMUL	EAX,BYTE 08H
	MOVZX	ECX,WORD [___seg0000]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [02AH+00H+_timerRegs],AX
;
; Line 169:	timerRegs.h.cs = *(short far *)MK_FP(__seg0000, 8 * 4 + 2) ;
;
	MOV	EAX,04H
	IMUL	EAX,BYTE 08H
	ADD	EAX,BYTE 02H
	MOVZX	ECX,WORD [___seg0000]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [02CH+00H+_timerRegs],AX
;
; Line 170:	dpmi_get_memory(&stackbot,&timerMemhand, TIMERSTACKSIZE) ;
;
	PUSH	DWORD 010000H
	PUSH	DWORD _timerMemhand
	PUSH	DWORD _stackbot
	CALL	_dpmi_get_memory
	ADD	ESP,BYTE 0CH
;
; Line 171:	dpmi_get_sel_base(&linear, dssel);
;
	MOVZX	EAX,WORD [EBP-06H]
	PUSH	EAX
	LEA	EAX,[EBP-04H]
	PUSH	EAX
	CALL	_dpmi_get_sel_base
	ADD	ESP,BYTE 08H
;
; Line 172:	stackbot -= linear;
;
	MOV	EAX,DWORD [EBP-04H]
	IMUL	EAX,BYTE 01H
	SUB	DWORD [_stackbot],EAX
;
; Line 173:	dpmi_get_protected_interrupt(&OldTimerCS, &OldTimerIP, 8) ;
;
	PUSH	BYTE 08H
	PUSH	DWORD _OldTimerIP
	PUSH	DWORD _OldTimerCS
	CALL	_dpmi_get_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 174:	dpmi_set_protected_interrupt(8,cssel,(ULONG)newtimer) ;
;
	PUSH	DWORD _newtimer
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 08H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 177:	keyboardRegs.h.flags = 0x246 ;
;
	MOV	WORD [020H+00H+_keyboardRegs],0246H
;
; Line 178:	keyboardRegs.h.ip = *(short far *)MK_FP(__seg0000, 9 * 4) ;
;
	MOV	EAX,04H
	IMUL	EAX,BYTE 09H
	MOVZX	ECX,WORD [___seg0000]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [02AH+00H+_keyboardRegs],AX
;
; Line 179:	keyboardRegs.h.cs = *(short far *)MK_FP(__seg0000, 9 * 4 + 2) ;
;
	MOV	EAX,04H
	IMUL	EAX,BYTE 09H
	ADD	EAX,BYTE 02H
	MOVZX	ECX,WORD [___seg0000]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [02CH+00H+_keyboardRegs],AX
;
; Line 180:	dpmi_get_protected_interrupt(&OldKeyboardCS, &OldKeyboardIP, 9) ;
;
	PUSH	BYTE 09H
	PUSH	DWORD _OldKeyboardIP
	PUSH	DWORD _OldKeyboardCS
	CALL	_dpmi_get_protected_interrupt
	ADD	ESP,BYTE 0CH
;
; Line 181:	dpmi_set_protected_interrupt(9,cssel,(ULONG)newkeyboard) ;
;
	PUSH	DWORD _newkeyboard
	MOVZX	EAX,WORD [EBP-08H]
	PUSH	EAX
	PUSH	BYTE 09H
	CALL	_dpmi_set_protected_interrupt
	ADD	ESP,BYTE 0CH
L_35:
;
; Line 183:	setvect(CRIT, (void _interrupt (*)(...))newcrit);
;
	PUSH	DWORD _newcrit
	PUSH	BYTE 024H
	CALL	_setvect
	ADD	ESP,BYTE 08H
;
; Line 184:	PostMessage(NULL,START,0,0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	CALL	_PostMessage
	ADD	ESP,BYTE 010H
;
; Line 185:	lagdelay = FIRSTDELAY;
;
	MOV	DWORD [_lagdelay],07H
;
; Line 186:	return TRUE;
;
	MOV	EAX,01H
L_28:
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 190:	static void PostEvent(MESSAGE event, int p1, int p2)
;
_PostEvent:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _EventQueueOnCtr
	MOV	EDI,DWORD _EventQueue
L_38:
;
; Line 191:	{
;
;
; Line 192:	if (EventQueueCtr != MAXMESSAGES)    {
;
	CMP	DWORD [_EventQueueCtr],BYTE 064H
	JE	SHORT	L_39
;
; Line 193:	EventQueue[EventQueueOnCtr].event = event;
;
	MOV	EAX,DWORD [ESI+00H]
	IMUL	EAX,BYTE 0CH
	MOV	ECX,DWORD [EBP+08H]
	MOV	DWORD [EDI+EAX+00H],ECX
;
; Line 194:	EventQueue[EventQueueOnCtr].mx = p1;
;
	MOV	EAX,DWORD [ESI+00H]
	IMUL	EAX,BYTE 0CH
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+0CH]
	MOV	DWORD [EAX+04H],ECX
;
; Line 195:	EventQueue[EventQueueOnCtr].my = p2;
;
	MOV	EAX,DWORD [ESI+00H]
	IMUL	EAX,BYTE 0CH
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+010H]
	MOV	DWORD [EAX+08H],ECX
;
; Line 196:	if (++EventQueueOnCtr == MAXMESSAGES)
;
	INC	DWORD [ESI+00H]
	CMP	DWORD [ESI+00H],BYTE 064H
	JNE	SHORT	L_41
;
; Line 197:	EventQueueOnCtr = 0;
;
	MOV	DWORD [ESI+00H],00H
L_41:
;
; Line 198:	EventQueueCtr++;
;
	INC	DWORD [_EventQueueCtr]
L_39:
;
; Line 200:	}
;
L_37:
	POP	EDI
	POP	ESI
	POP	EBP
	RET
;
; Line 203:	static void near collect_events(void)
;
_collect_events:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 010H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EDI,DWORD _lagdelay
L_50:
;
; Line 204:	{
;
;
; Line 212:	if (timed_out(clocktimer))    {
;
	CMP	DWORD [_clocktimer],BYTE 00H
	JNE	NEAR	L_51
;
; Line 214:	time_t t = time(NULL);
;
	PUSH	BYTE 00H
	CALL	_time
	POP	ECX
	MOV	DWORD [EBP-010H],EAX
;
; Line 215:	now = localtime(&t);
;
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_localtime
	POP	ECX
	MOV	DWORD [EBP-08H],EAX
;
; Line 216:	hr = now->tm_hour > 12 ?
;
	MOV	EAX,DWORD [EBP-08H]
	CMP	DWORD [EAX+08H],BYTE 0CH
	JLE	SHORT	L_53
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
	SUB	EAX,BYTE 0CH
	JMP	SHORT	L_54
L_53:
	MOV	EAX,DWORD [EBP-08H]
	MOV	EAX,DWORD [EAX+08H]
L_54:
	MOV	DWORD [EBP-04H],EAX
;
; Line 219:	if (hr == 0)
;
	CMP	DWORD [EBP-04H],BYTE 00H
	JNE	SHORT	L_55
;
; Line 220:	hr = 12;
;
	MOV	DWORD [EBP-04H],0CH
L_55:
;
; Line 221:	sprintf(time_string, "%2d:%02d", hr, now->tm_min);
;
	MOV	EAX,DWORD [EBP-08H]
	PUSH	DWORD [EAX+04H]
	PUSH	DWORD [EBP-04H]
	PUSH	DWORD L_45
	PUSH	DWORD _time_string
	CALL	_sprintf
	ADD	ESP,BYTE 010H
;
; Line 222:	strcpy(time_string+5, now->tm_hour > 11 ? "pm " : "am ");
;
	MOV	EAX,DWORD [EBP-08H]
	CMP	DWORD [EAX+08H],BYTE 0BH
	JLE	SHORT	L_57
	MOV	EAX,DWORD L_46
	JMP	SHORT	L_58
L_57:
	MOV	EAX,DWORD L_47
L_58:
	PUSH	EAX
	MOV	EAX,DWORD 05H+_time_string
	PUSH	EAX
	CALL	_strcpy
	ADD	ESP,BYTE 08H
;
; Line 224:	if (flipflop)
;
	CMP	DWORD [L_44],BYTE 00H
	JE	SHORT	L_59
;
; Line 225:	*(time_string+2) = ' ';
;
	MOV	BYTE [_time_string+02H],020H
L_59:
;
; Line 226:	flipflop ^= TRUE;
;
	BTC	DWORD [L_44],00H
;
; Line 228:	set_timer(clocktimer, 1);
;
	MOV	DWORD [_clocktimer],013H
;
; Line 230:	PostEvent(CLOCKTICK, FP_SEG(time_string), FP_OFF(time_string));
;
	PUSH	DWORD _time_string
	PUSH	DWORD _time_string
	PUSH	BYTE 012H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_51:
;
; Line 234:	if ((sk = getshift()) != ShiftKeys)    {
;
	CALL	_getshift
	MOV	ESI,EAX
	CMP	EAX,DWORD [L_43]
	JE	SHORT	L_61
;
; Line 235:	ShiftKeys = sk;
;
	MOV	DWORD [L_43],ESI
;
; Line 237:	PostEvent(SHIFT_CHANGED, sk, 0);
;
	PUSH	BYTE 00H
	PUSH	ESI
	PUSH	BYTE 01EH
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 238:	if (sk & ALTKEY)
;
	MOV	EAX,ESI
	AND	EAX,BYTE 08H
	JE	SHORT	L_63
;
; Line 239:	AltDown = TRUE;
;
	MOV	DWORD [_AltDown],01H
L_63:
L_61:
;
; Line 244:	if (sk & ALTKEY)	{
;
	MOV	EAX,ESI
	AND	EAX,BYTE 08H
	JE	NEAR	L_65
;
; Line 245:	if (keyportvalue == 14)    {
;
	CMP	DWORD [_keyportvalue],BYTE 0EH
	JNE	SHORT	L_67
;
; Line 246:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 247:	waitforkeyboard();
;
	PUSH	BYTE 00H
	CALL	_bioskey
	POP	ECX
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
;
; Line 248:	PostEvent(KEYBOARD, ALT_BS, sk);
;
	PUSH	ESI
	PUSH	DWORD 010C5H
	PUSH	BYTE 015H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_67:
;
; Line 250:	if (keyportvalue == 83)    {
;
	CMP	DWORD [_keyportvalue],BYTE 053H
	JNE	SHORT	L_69
;
; Line 251:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 252:	waitforkeyboard();
;
	PUSH	BYTE 00H
	CALL	_bioskey
	POP	ECX
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
;
; Line 253:	PostEvent(KEYBOARD, ALT_DEL, sk);
;
	PUSH	ESI
	PUSH	DWORD 010B8H
	PUSH	BYTE 015H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_69:
L_65:
;
; Line 256:	if (sk & CTRLKEY)	{
;
	MOV	EAX,ESI
	AND	EAX,BYTE 04H
	JE	SHORT	L_71
;
; Line 257:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 258:	if (keyportvalue == 82)    {
;
	CMP	DWORD [_keyportvalue],BYTE 052H
	JNE	SHORT	L_73
;
; Line 259:	waitforkeyboard();
;
	PUSH	BYTE 00H
	CALL	_bioskey
	POP	ECX
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
;
; Line 260:	PostEvent(KEYBOARD, CTRL_INS, sk);
;
	PUSH	ESI
	PUSH	DWORD 010BAH
	PUSH	BYTE 015H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_73:
L_71:
;
; Line 264:	if (keyhit())    {
;
	CALL	_keyhit
	TEST	EAX,EAX
	JE	NEAR	L_75
;
; Line 267:	int c = getkey();
;
	CALL	_getkey
	MOV	EBX,EAX
;
; Line 268:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 270:	if (sk & (LEFTSHIFT | RIGHTSHIFT))    {
;
	MOV	EAX,ESI
	AND	EAX,BYTE 03H
	JE	SHORT	L_77
;
; Line 271:	if (c >= '0' && c <= '9')
;
	CMP	EBX,BYTE 030H
	JL	SHORT	L_79
	CMP	EBX,BYTE 039H
	JG	SHORT	L_79
;
; Line 272:	c = cvt[c-'0'];
;
	MOV	EAX,EBX
	SUB	EAX,BYTE 030H
	MOV	EBX,DWORD [EAX*4+L_48+00H]
	JMP	SHORT	L_80
L_79:
;
; Line 273:	else if (c == '.' || c == DEL)
;
	CMP	EBX,BYTE 02EH
	JE	SHORT	L_83
	CMP	EBX,010D3H
	JNE	SHORT	L_81
L_83:
;
; Line 274:	c = SHIFT_DEL;
;
	MOV	EBX,010C6H
	JMP	SHORT	L_82
L_81:
;
; Line 275:	else if (c == INS)
;
	CMP	EBX,010D2H
	JNE	SHORT	L_84
;
; Line 276:	c = SHIFT_INS;
;
	MOV	EBX,010B9H
L_84:
L_82:
L_80:
L_77:
;
; Line 278:	if (c != '\r' && (c < ' ' || c > 127))
;
	CMP	EBX,BYTE 0DH
	JE	SHORT	L_86
	CMP	EBX,BYTE 020H
	JL	SHORT	L_88
	CMP	EBX,BYTE 07FH
	JLE	SHORT	L_86
L_88:
;
; Line 279:	clearBIOSbuffer();
;
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
L_86:
;
; Line 281:	PostEvent(KEYBOARD, c, sk);
;
	PUSH	ESI
	PUSH	EBX
	PUSH	BYTE 015H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_75:
;
; Line 284:	if (button_releases())    {
;
	CALL	_button_releases
	TEST	EAX,EAX
	JE	SHORT	L_89
;
; Line 286:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 287:	doubletimer = DOUBLETICKS;
;
	MOV	DWORD [_doubletimer],05H
;
; Line 288:	PostEvent(BUTTON_RELEASED, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 027H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 289:	disable_timer(delaytimer);
;
	MOV	DWORD [_delaytimer],0FFFFFFFFH
L_89:
;
; Line 291:	get_mouseposition(&mx, &my);
;
	PUSH	DWORD _my
	PUSH	DWORD _mx
	CALL	_get_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 292:	if (mx != px || my != py)  {
;
	MOV	EAX,DWORD [_mx]
	CMP	EAX,DWORD [_px]
	JNE	SHORT	L_93
	MOV	EAX,DWORD [_my]
	CMP	EAX,DWORD [_py]
	JE	SHORT	L_91
L_93:
;
; Line 293:	px = mx;
;
	MOV	EAX,DWORD [_mx]
	MOV	DWORD [_px],EAX
;
; Line 294:	py = my;
;
	MOV	EAX,DWORD [_my]
	MOV	DWORD [_py],EAX
;
; Line 295:	PostEvent(MOUSE_MOVED, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 026H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_91:
;
; Line 297:	if (rightbutton())	{
;
	CALL	_mousebuttons
	AND	EAX,BYTE 02H
	JE	SHORT	L_94
;
; Line 298:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 299:	PostEvent(RIGHT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 023H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_94:
;
; Line 301:	if (leftbutton())    {
;
	CALL	_mousebuttons
	AND	EAX,BYTE 01H
	JE	NEAR	L_96
;
; Line 302:	AltDown = FALSE;
;
	MOV	DWORD [_AltDown],00H
;
; Line 303:	if (mx == pmx && my == pmy)    {
;
	MOV	EAX,DWORD [_mx]
	CMP	EAX,DWORD [_pmx]
	JNE	SHORT	L_98
	MOV	EAX,DWORD [_my]
	CMP	EAX,DWORD [_pmy]
	JNE	SHORT	L_98
;
; Line 305:	if (timer_running(doubletimer))    {
;
	CMP	DWORD [_doubletimer],BYTE 00H
	JLE	SHORT	L_100
;
; Line 307:	disable_timer(doubletimer);
;
	MOV	DWORD [_doubletimer],0FFFFFFFFH
;
; Line 308:	PostEvent(DOUBLE_CLICK, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 025H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
	JMP	SHORT	L_101
L_100:
;
; Line 310:	else if (!timer_running(delaytimer))    {
;
	CMP	DWORD [_delaytimer],BYTE 00H
	JG	SHORT	L_102
;
; Line 312:	delaytimer = lagdelay;
;
	MOV	EAX,DWORD [EDI+00H]
	MOV	DWORD [_delaytimer],EAX
;
; Line 313:	lagdelay = DELAYTICKS;
;
	MOV	DWORD [EDI+00H],01H
;
; Line 315:	PostEvent(LEFT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 024H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
L_102:
L_101:
	JMP	SHORT	L_99
L_98:
;
; Line 320:	disable_timer(doubletimer);
;
	MOV	DWORD [_doubletimer],0FFFFFFFFH
;
; Line 321:	delaytimer = FIRSTDELAY;
;
	MOV	DWORD [_delaytimer],07H
;
; Line 322:	lagdelay = DELAYTICKS;
;
	MOV	DWORD [EDI+00H],01H
;
; Line 323:	PostEvent(LEFT_BUTTON, mx, my);
;
	PUSH	DWORD [_my]
	PUSH	DWORD [_mx]
	PUSH	BYTE 024H
	CALL	_PostEvent
	ADD	ESP,BYTE 0CH
;
; Line 324:	pmx = mx;
;
	MOV	EAX,DWORD [_mx]
	MOV	DWORD [_pmx],EAX
;
; Line 325:	pmy = my;
;
	MOV	EAX,DWORD [_my]
	MOV	DWORD [_pmy],EAX
L_99:
	JMP	SHORT	L_97
L_96:
;
; Line 329:	lagdelay = FIRSTDELAY;
;
	MOV	DWORD [EDI+00H],07H
L_97:
;
; Line 330:	}
;
L_49:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_PostMessage]
;
; Line 333:	void PostMessage(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
;
_PostMessage:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _MsgQueueOnCtr
	MOV	EDI,DWORD _MsgQueue
L_105:
;
; Line 334:	{
;
;
; Line 335:	if (MsgQueueCtr != MAXMESSAGES)    {
;
	CMP	DWORD [_MsgQueueCtr],BYTE 064H
	JE	SHORT	L_106
;
; Line 336:	MsgQueue[MsgQueueOnCtr].wnd = wnd;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	MOV	ECX,DWORD [EBP+08H]
	MOV	DWORD [EDI+EAX+00H],ECX
;
; Line 337:	MsgQueue[MsgQueueOnCtr].msg = msg;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+0CH]
	MOV	DWORD [EAX+04H],ECX
;
; Line 338:	MsgQueue[MsgQueueOnCtr].p1 = p1;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+010H]
	MOV	DWORD [EAX+08H],ECX
;
; Line 339:	MsgQueue[MsgQueueOnCtr].p2 = p2;
;
	MOV	EAX,DWORD [ESI+00H]
	SHL	EAX,04H
	LEA	EAX,[EDI+EAX+00H]
	MOV	ECX,DWORD [EBP+014H]
	MOV	DWORD [EAX+0CH],ECX
;
; Line 340:	if (++MsgQueueOnCtr == MAXMESSAGES)
;
	INC	DWORD [ESI+00H]
	CMP	DWORD [ESI+00H],BYTE 064H
	JNE	SHORT	L_108
;
; Line 341:	MsgQueueOnCtr = 0;
;
	MOV	DWORD [ESI+00H],00H
L_108:
;
; Line 342:	MsgQueueCtr++;
;
	INC	DWORD [_MsgQueueCtr]
L_106:
;
; Line 344:	}
;
L_104:
	POP	EDI
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_SendMessage]
;
; Line 347:	int SendMessage(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
;
_SendMessage:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 024H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EBX,DWORD [EBP+010H]
L_111:
;
; Line 348:	{
;
;
; Line 349:	int rtn = TRUE, x, y;
;
	MOV	DWORD [EBP-0CH],01H
;
; Line 352:	LogMessages(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	_LogMessages
	ADD	ESP,BYTE 010H
;
; Line 354:	if (wnd != NULL)
;
	TEST	ESI,ESI
	JE	NEAR	L_112
;
; Line 355:	switch (msg)    {
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,BYTE 023H
	JE	SHORT	L_118
	JA	SHORT	L_124
	CMP	EAX,BYTE 015H
	JE	SHORT	L_122
	JA	SHORT	L_125
	CMP	EAX,BYTE 0AH
	JE	SHORT	L_117
	JA	NEAR	L_115
	CMP	EAX,BYTE 09H
	JE	SHORT	L_116
	JMP	SHORT	L_115
L_125:
	CMP	EAX,BYTE 01EH
	JE	SHORT	L_123
	JMP	SHORT	L_115
L_124:
	CMP	EAX,BYTE 025H
	JE	SHORT	L_120
	JA	SHORT	L_126
	CMP	EAX,BYTE 024H
	JE	SHORT	L_119
	JMP	SHORT	L_115
L_126:
	CMP	EAX,BYTE 027H
	JE	SHORT	L_121
	JMP	SHORT	L_115
L_116:
;
; Line 357:	case BORDER:
;
L_117:
;
; Line 360:	if (isVisible(wnd))
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_127
;
; Line 361:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
L_127:
;
; Line 362:	break;
;
	JMP	SHORT	L_114
L_118:
;
; Line 364:	case LEFT_BUTTON:
;
L_119:
;
; Line 365:	case DOUBLE_CLICK:
;
L_120:
;
; Line 366:	case BUTTON_RELEASED:
;
L_121:
;
; Line 369:	if (isVisible(wnd) || wnd == CaptureMouse)
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JNE	SHORT	L_131
	CMP	ESI,DWORD [_CaptureMouse]
	JNE	SHORT	L_129
L_131:
;
; Line 370:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
L_129:
;
; Line 371:	break;
;
	JMP	SHORT	L_114
L_122:
;
; Line 373:	case SHIFT_CHANGED:
;
L_123:
;
; Line 376:	if (!(isVisible(wnd) || wnd == CaptureKeyboard))
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JNE	SHORT	L_132
	CMP	ESI,DWORD [_CaptureKeyboard]
	JNE	SHORT	L_114
;
; Line 377:	break;
;
L_132:
;
; Line 378:	default:
;
L_115:
;
; Line 379:	rtn = (*wnd->wndproc)(wnd, msg, p1, p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	MOVSX	EAX,WORD [EBP+0CH]
	PUSH	EAX
	PUSH	ESI
	CALL	DWORD [ESI+08H]
	ADD	ESP,BYTE 010H
	MOV	DWORD [EBP-0CH],EAX
;
; Line 380:	break;
;
	JMP	SHORT	L_114
L_114:
L_112:
;
; Line 384:	if (rtn != FALSE)    {
;
	CMP	DWORD [EBP-0CH],BYTE 00H
	JE	NEAR	L_134
;
; Line 387:	switch (msg)    {
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,BYTE 01FH
	JE	NEAR	L_149
	JA	NEAR	L_161
	CMP	EAX,BYTE 018H
	JE	NEAR	L_141
	JA	SHORT	L_162
	CMP	EAX,BYTE 014H
	JE	NEAR	L_140
	JA	SHORT	L_163
	CMP	EAX,BYTE 013H
	JE	NEAR	L_139
	JA	NEAR	L_137
	CMP	EAX,BYTE 01H
	JE	NEAR	L_138
	JMP	NEAR	L_137
L_163:
	CMP	EAX,BYTE 017H
	JE	NEAR	L_143
	JA	NEAR	L_137
	CMP	EAX,BYTE 016H
	JE	NEAR	L_142
	JMP	NEAR	L_137
L_162:
	CMP	EAX,BYTE 01BH
	JE	NEAR	L_148
	JA	SHORT	L_164
	CMP	EAX,BYTE 01AH
	JE	NEAR	L_147
	JA	NEAR	L_137
	CMP	EAX,BYTE 019H
	JE	NEAR	L_144
	JMP	NEAR	L_137
L_164:
	CMP	EAX,BYTE 01DH
	JE	NEAR	L_146
	JA	NEAR	L_137
	CMP	EAX,BYTE 01CH
	JE	NEAR	L_145
	JMP	NEAR	L_137
L_161:
	CMP	EAX,BYTE 02AH
	JE	NEAR	L_153
	JA	SHORT	L_165
	CMP	EAX,BYTE 022H
	JE	NEAR	L_151
	JA	SHORT	L_166
	CMP	EAX,BYTE 021H
	JE	NEAR	L_152
	JA	NEAR	L_137
	CMP	EAX,BYTE 020H
	JE	NEAR	L_150
	JMP	NEAR	L_137
L_166:
	CMP	EAX,BYTE 029H
	JE	NEAR	L_155
	JA	NEAR	L_137
	CMP	EAX,BYTE 028H
	JE	NEAR	L_156
	JMP	NEAR	L_137
L_165:
	CMP	EAX,BYTE 02DH
	JE	NEAR	L_158
	JA	SHORT	L_167
	CMP	EAX,BYTE 02CH
	JE	NEAR	L_157
	JA	NEAR	L_137
	CMP	EAX,BYTE 02BH
	JE	NEAR	L_154
	JMP	NEAR	L_137
L_167:
	CMP	EAX,BYTE 02FH
	JE	NEAR	L_160
	JA	NEAR	L_137
	CMP	EAX,BYTE 02EH
	JE	NEAR	L_159
	JMP	NEAR	L_137
L_138:
;
; Line 389:	StopMsg();
;
	CALL	_StopMsg
;
; Line 390:	break;
;
	JMP	NEAR	L_136
L_139:
;
; Line 393:	if (Cwnd == NULL)
;
	CMP	DWORD [_Cwnd],BYTE 00H
	JNE	SHORT	L_168
;
; Line 394:	set_timer(clocktimer, 0);
;
	MOV	DWORD [_clocktimer],01H
L_168:
;
; Line 395:	wnd->PrevClock = Cwnd;
;
	MOV	EAX,DWORD [_Cwnd]
	MOV	DWORD [ESI+07CH],EAX
;
; Line 396:	Cwnd = wnd;
;
	MOV	DWORD [_Cwnd],ESI
;
; Line 397:	break;
;
	JMP	NEAR	L_136
L_140:
;
; Line 399:	Cwnd = wnd->PrevClock;
;
	MOV	EAX,DWORD [ESI+07CH]
	MOV	DWORD [_Cwnd],EAX
;
; Line 400:	if (Cwnd == NULL)
;
	CMP	DWORD [_Cwnd],BYTE 00H
	JNE	SHORT	L_170
;
; Line 401:	disable_timer(clocktimer);
;
	MOV	DWORD [_clocktimer],0FFFFFFFFH
L_170:
;
; Line 402:	break;
;
	JMP	NEAR	L_136
L_141:
;
; Line 405:	if (wnd == NULL)
;
	TEST	ESI,ESI
	JNE	SHORT	L_172
;
; Line 406:	cursor((int)p1, (int)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_cursor
	ADD	ESP,BYTE 08H
	JMP	NEAR	L_173
L_172:
;
; Line 407:	else if (wnd == inFocus)
;
	CMP	ESI,DWORD [_inFocus]
	JNE	NEAR	L_174
;
; Line 408:	cursor(GetClientLeft(wnd)+(int)p1,
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_176
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JE	SHORT	L_176
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_176
	MOV	EAX,03H
	JMP	SHORT	L_177
L_176:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_181
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,BYTE 08H
	JNE	SHORT	L_180
L_181:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0100H
	JE	SHORT	L_178
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,010000H
	JE	SHORT	L_178
L_180:
	MOV	EAX,02H
	JMP	SHORT	L_179
L_178:
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,014108H
	JE	SHORT	L_182
	MOV	EAX,01H
	JMP	SHORT	L_183
L_182:
	MOV	EAX,00H
L_183:
L_179:
L_177:
	ADD	EAX,DWORD [ESI+010H]
	ADD	EAX,DWORD [EBP+014H]
	PUSH	EAX
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,04000H
	JE	SHORT	L_184
	MOV	EAX,01H
	JMP	SHORT	L_185
L_184:
	MOV	EAX,00H
L_185:
	ADD	EAX,DWORD [ESI+0CH]
	ADD	EAX,EBX
	PUSH	EAX
	CALL	_cursor
	ADD	ESP,BYTE 08H
L_174:
L_173:
;
; Line 410:	break;
;
	JMP	NEAR	L_136
L_142:
;
; Line 412:	if (p2)
;
	CMP	DWORD [EBP+014H],BYTE 00H
	JE	SHORT	L_186
;
; Line 413:	((WINDOW)p2)->PrevKeyboard=CaptureKeyboard;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	ECX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EAX+078H],ECX
	JMP	SHORT	L_187
L_186:
;
; Line 415:	wnd->PrevKeyboard = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [ESI+078H],EAX
L_187:
;
; Line 416:	CaptureKeyboard = wnd;
;
	MOV	DWORD [_CaptureKeyboard],ESI
;
; Line 417:	NoChildCaptureKeyboard = (int)p1;
;
	MOV	DWORD [_NoChildCaptureKeyboard],EBX
;
; Line 418:	break;
;
	JMP	NEAR	L_136
L_143:
;
; Line 420:	if (wnd != NULL)	{
;
	TEST	ESI,ESI
	JE	SHORT	L_188
;
; Line 421:	if (CaptureKeyboard == wnd || (int)p1)
;
	CMP	DWORD [_CaptureKeyboard],ESI
	JE	SHORT	L_192
	TEST	EBX,EBX
	JE	SHORT	L_190
L_192:
;
; Line 422:	CaptureKeyboard = wnd->PrevKeyboard;
;
	MOV	EAX,DWORD [ESI+078H]
	MOV	DWORD [_CaptureKeyboard],EAX
	JMP	SHORT	L_191
L_190:
;
; Line 424:	WINDOW twnd = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EBP-024H],EAX
	JMP	SHORT	L_193
L_195:
;
; Line 426:	if (twnd->PrevKeyboard == wnd)	{
;
	MOV	EAX,DWORD [EBP-024H]
	CMP	DWORD [EAX+078H],ESI
	JNE	SHORT	L_196
;
; Line 427:	twnd->PrevKeyboard = wnd->PrevKeyboard;
;
	MOV	EAX,DWORD [EBP-024H]
	MOV	ECX,DWORD [ESI+078H]
	MOV	DWORD [EAX+078H],ECX
;
; Line 428:	break;
;
	JMP	SHORT	L_194
L_196:
;
; Line 430:	twnd = twnd->PrevKeyboard;
;
	MOV	EAX,DWORD [EBP-024H]
	MOV	EAX,DWORD [EAX+078H]
	MOV	DWORD [EBP-024H],EAX
L_193:
;
; Line 425:	while (twnd != NULL)	{
;
	CMP	DWORD [EBP-024H],BYTE 00H
	JNE	SHORT	L_195
L_194:
;
; Line 432:	if (twnd == NULL)
;
	CMP	DWORD [EBP-024H],BYTE 00H
	JNE	SHORT	L_198
;
; Line 433:	CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
L_198:
L_191:
;
; Line 435:	wnd->PrevKeyboard = NULL;
;
	MOV	DWORD [ESI+078H],00H
	JMP	SHORT	L_189
L_188:
;
; Line 438:	CaptureKeyboard = NULL;
;
	MOV	DWORD [_CaptureKeyboard],00H
L_189:
;
; Line 439:	NoChildCaptureKeyboard = FALSE;
;
	MOV	DWORD [_NoChildCaptureKeyboard],00H
;
; Line 440:	break;
;
	JMP	NEAR	L_136
L_144:
;
; Line 442:	curr_cursor(&x, &y);
;
	LEA	EAX,[EBP-04H]
	PUSH	EAX
	LEA	EAX,[EBP-08H]
	PUSH	EAX
	CALL	_curr_cursor
	ADD	ESP,BYTE 08H
;
; Line 443:	*(int*)p1 = x;
;
	MOV	EAX,DWORD [EBP-08H]
	MOV	DWORD [EBX+00H],EAX
;
; Line 444:	*(int*)p2 = y;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	ECX,DWORD [EBP-04H]
	MOV	DWORD [EAX+00H],ECX
;
; Line 445:	break;
;
	JMP	NEAR	L_136
L_145:
;
; Line 447:	savecursor();
;
	CALL	_savecursor
;
; Line 448:	break;
;
	JMP	NEAR	L_136
L_146:
;
; Line 450:	restorecursor();
;
	CALL	_restorecursor
;
; Line 451:	break;
;
	JMP	NEAR	L_136
L_147:
;
; Line 453:	normalcursor();
;
	CALL	_normalcursor
;
; Line 454:	hidecursor();
;
	CALL	_hidecursor
;
; Line 455:	break;
;
	JMP	NEAR	L_136
L_148:
;
; Line 457:	if (p1)
;
	TEST	EBX,EBX
	JE	SHORT	L_200
;
; Line 458:	set_cursor_type(0x0607);
;
	PUSH	DWORD 0607H
	CALL	_set_cursor_type
	POP	ECX
	JMP	SHORT	L_201
L_200:
;
; Line 460:	set_cursor_type(0x0106);
;
	PUSH	DWORD 0106H
	CALL	_set_cursor_type
	POP	ECX
L_201:
;
; Line 461:	unhidecursor();
;
	CALL	_unhidecursor
;
; Line 462:	break;
;
	JMP	NEAR	L_136
L_149:
;
; Line 464:	waitforkeyboard();
;
	PUSH	BYTE 00H
	CALL	_bioskey
	POP	ECX
	MOV	EAX,01CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOV	ECX,01AH
	MOVZX	EDX,WORD [___seg0040]
	MOV	GS,DX
	MOV	AX,WORD [FS:EAX+00H]
	MOV	WORD [GS:ECX+00H],AX
;
; Line 465:	break;
;
	JMP	NEAR	L_136
L_150:
;
; Line 468:	resetmouse();
;
	CALL	_resetmouse
;
; Line 469:	set_mousetravel(0, SCREENWIDTH-1, 0, SCREENHEIGHT-1);
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_204
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_202
L_204:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_203
L_202:
	MOV	EAX,019H
L_203:
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	PUSH	EAX
	PUSH	BYTE 00H
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 470:	break;
;
	JMP	NEAR	L_136
L_151:
;
; Line 472:	rtn = mouse_installed();
;
	CALL	_mouse_installed
	MOV	DWORD [EBP-0CH],EAX
;
; Line 473:	break;
;
	JMP	NEAR	L_136
L_152:
;
; Line 476:	if (!p1)	{
;
	TEST	EBX,EBX
	JNE	SHORT	L_205
;
; Line 477:	rc.lf = rc.tp = 0;
;
	MOV	DWORD [EBP-01CH],00H
	MOV	DWORD [EBP-020H],00H
;
; Line 478:	rc.rt = SCREENWIDTH-1;
;
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	DEC	EAX
	MOV	DWORD [EBP-018H],EAX
;
; Line 479:	rc.bt = SCREENHEIGHT-1;
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_209
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_207
L_209:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_208
L_207:
	MOV	EAX,019H
L_208:
	DEC	EAX
	MOV	DWORD [EBP-014H],EAX
	JMP	SHORT	L_206
L_205:
;
; Line 482:	rc = *(RECT *)p1;
;
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBX+00H]
	LEA	EDI,[EBP-020H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
L_206:
;
; Line 483:	set_mousetravel(rc.lf, rc.rt, rc.tp, rc.bt);
;
	PUSH	DWORD [EBP-014H]
	PUSH	DWORD [EBP-01CH]
	PUSH	DWORD [EBP-018H]
	PUSH	DWORD [EBP-020H]
	CALL	_set_mousetravel
	ADD	ESP,BYTE 010H
;
; Line 484:	break;
;
	JMP	NEAR	L_136
L_153:
;
; Line 487:	show_mousecursor();
;
	CALL	_show_mousecursor
;
; Line 488:	break;
;
	JMP	NEAR	L_136
L_154:
;
; Line 490:	hide_mousecursor();
;
	CALL	_hide_mousecursor
;
; Line 491:	break;
;
	JMP	NEAR	L_136
L_155:
;
; Line 493:	set_mouseposition((int)p1, (int)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_set_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 494:	break;
;
	JMP	NEAR	L_136
L_156:
;
; Line 496:	get_mouseposition((int*)p1,(int*)p2);
;
	PUSH	DWORD [EBP+014H]
	PUSH	EBX
	CALL	_get_mouseposition
	ADD	ESP,BYTE 08H
;
; Line 497:	break;
;
	JMP	NEAR	L_136
L_157:
;
; Line 499:	waitformouse();
;
L_210:
	CALL	_mousebuttons
	TEST	EAX,EAX
	JNE	SHORT	L_210
;
; Line 500:	break;
;
	JMP	NEAR	L_136
L_158:
;
; Line 502:	rtn = mousebuttons();
;
	CALL	_mousebuttons
	MOV	DWORD [EBP-0CH],EAX
;
; Line 503:	break;
;
	JMP	NEAR	L_136
L_159:
;
; Line 505:	if (p2)
;
	CMP	DWORD [EBP+014H],BYTE 00H
	JE	SHORT	L_211
;
; Line 506:	((WINDOW)p2)->PrevMouse = CaptureMouse;
;
	MOV	EAX,DWORD [EBP+014H]
	MOV	ECX,DWORD [_CaptureMouse]
	MOV	DWORD [EAX+074H],ECX
	JMP	SHORT	L_212
L_211:
;
; Line 508:	wnd->PrevMouse = CaptureMouse;
;
	MOV	EAX,DWORD [_CaptureMouse]
	MOV	DWORD [ESI+074H],EAX
L_212:
;
; Line 509:	CaptureMouse = wnd;
;
	MOV	DWORD [_CaptureMouse],ESI
;
; Line 510:	NoChildCaptureMouse = (int)p1;
;
	MOV	DWORD [_NoChildCaptureMouse],EBX
;
; Line 511:	break;
;
	JMP	SHORT	L_136
L_160:
;
; Line 513:	if (wnd != NULL)	{
;
	TEST	ESI,ESI
	JE	SHORT	L_213
;
; Line 514:	if (CaptureMouse == wnd || (int)p1)
;
	CMP	DWORD [_CaptureMouse],ESI
	JE	SHORT	L_217
	TEST	EBX,EBX
	JE	SHORT	L_215
L_217:
;
; Line 515:	CaptureMouse = wnd->PrevMouse;
;
	MOV	EAX,DWORD [ESI+074H]
	MOV	DWORD [_CaptureMouse],EAX
	JMP	SHORT	L_216
L_215:
;
; Line 517:	WINDOW twnd = CaptureMouse;
;
	MOV	EDI,DWORD [_CaptureMouse]
	JMP	SHORT	L_218
L_220:
;
; Line 519:	if (twnd->PrevMouse == wnd)	{
;
	CMP	DWORD [EDI+074H],ESI
	JNE	SHORT	L_221
;
; Line 520:	twnd->PrevMouse = wnd->PrevMouse;
;
	MOV	EAX,DWORD [ESI+074H]
	MOV	DWORD [EDI+074H],EAX
;
; Line 521:	break;
;
	JMP	SHORT	L_219
L_221:
;
; Line 523:	twnd = twnd->PrevMouse;
;
	MOV	EDI,DWORD [EDI+074H]
L_218:
;
; Line 518:	while (twnd != NULL)	{
;
	TEST	EDI,EDI
	JNE	SHORT	L_220
L_219:
;
; Line 525:	if (twnd == NULL)
;
	TEST	EDI,EDI
	JNE	SHORT	L_223
;
; Line 526:	CaptureMouse = NULL;
;
	MOV	DWORD [_CaptureMouse],00H
L_223:
L_216:
;
; Line 528:	wnd->PrevMouse = NULL;
;
	MOV	DWORD [ESI+074H],00H
	JMP	SHORT	L_214
L_213:
;
; Line 531:	CaptureMouse = NULL;
;
	MOV	DWORD [_CaptureMouse],00H
L_214:
;
; Line 532:	NoChildCaptureMouse = FALSE;
;
	MOV	DWORD [_NoChildCaptureMouse],00H
;
; Line 533:	break;
;
	JMP	SHORT	L_136
L_137:
;
; Line 535:	break;
;
	JMP	SHORT	L_136
L_136:
L_134:
;
; Line 538:	return rtn;
;
	MOV	EAX,DWORD [EBP-0CH]
L_110:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 541:	static RECT VisibleRect(WINDOW wnd)
;
_VisibleRect:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 024H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	EDI,[EBP-010H]
	LEA	EBX,[EBP-024H]
L_226:
;
; Line 542:	{
;
;
; Line 543:	RECT rc = WindowRect(wnd);
;
	MOV	EAX,DWORD [EBP+0CH]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+0CH]
	PUSH	ES
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	ES
	POP	EDI
	POP	ESI
;
; Line 544:	if (!TestAttribute(wnd, NOCLIP))	{
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	EAX,DWORD [EAX+054H]
	AND	EAX,0800H
	JNE	SHORT	L_227
;
; Line 545:	WINDOW pwnd = GetParent(wnd);
;
	MOV	EAX,DWORD [EBP+0CH]
	MOV	ESI,DWORD [EAX+03CH]
;
; Line 547:	prc = ClientRect(pwnd);
;
	PUSH	ESI
	PUSH	EBX
	CALL	_ClientRect
	ADD	ESP,BYTE 08H
	JMP	SHORT	L_229
L_231:
;
; Line 549:	if (TestAttribute(pwnd, NOCLIP))
;
	MOV	EAX,DWORD [ESI+054H]
	AND	EAX,0800H
	JNE	SHORT	L_230
;
; Line 550:	break;
;
L_232:
;
; Line 551:	rc = subRectangle(rc, prc);
;
	PUSH	DWORD [SS:EBX+00H+0CH]
	PUSH	DWORD [SS:EBX+00H+08H]
	PUSH	DWORD [SS:EBX+00H+04H]
	PUSH	DWORD [SS:EBX+00H+00H]
	PUSH	DWORD [SS:EDI+00H+0CH]
	PUSH	DWORD [SS:EDI+00H+08H]
	PUSH	DWORD [SS:EDI+00H+04H]
	PUSH	DWORD [SS:EDI+00H+00H]
	PUSH	EDI
	CALL	_subRectangle
	ADD	ESP,BYTE 024H
;
; Line 552:	if (!ValidRect(rc))
;
	CMP	DWORD [SS:EDI+08H],BYTE 00H
	JNE	SHORT	L_234
	CMP	DWORD [SS:EDI+00H],BYTE 00H
	JNE	SHORT	L_234
	CMP	DWORD [SS:EDI+04H],BYTE 00H
	JNE	SHORT	L_234
	CMP	DWORD [SS:EDI+0CH],BYTE 00H
	JE	SHORT	L_230
;
; Line 553:	break;
;
L_234:
;
; Line 554:	if ((pwnd = GetParent(pwnd)) != NULL)
;
	MOV	ESI,DWORD [ESI+03CH]
	TEST	ESI,ESI
	JE	SHORT	L_236
;
; Line 555:	prc = ClientRect(pwnd);
;
	PUSH	ESI
	PUSH	EBX
	CALL	_ClientRect
	ADD	ESP,BYTE 08H
L_236:
L_229:
;
; Line 548:	while (pwnd != NULL)	{
;
	TEST	ESI,ESI
	JNE	SHORT	L_231
L_230:
L_227:
;
; Line 558:	return rc;
;
	MOV	EAX,DWORD [EBP+08H]
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EDI+00H]
	LEA	EDI,[EAX+00H]
	PUSH	DS
	PUSH	SS
	PUSH	SS
	POP	ES
	POP	DS
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	DS
	POP	EDI
	POP	ESI
	MOV	EAX,DWORD [EBP+08H]
L_225:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 562:	static WINDOW inWindow(WINDOW wnd, int x, int y)
;
_inWindow:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 020H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
L_239:
;
; Line 563:	{
;
;
; Line 564:	WINDOW Hit = NULL;
;
	MOV	EBX,00H
	JMP	SHORT	L_240
L_242:
;
; Line 566:	if (isVisible(wnd))	{
;
	PUSH	ESI
	CALL	_isVisible
	POP	ECX
	TEST	EAX,EAX
	JE	SHORT	L_243
;
; Line 568:	RECT rc = VisibleRect(wnd);
;
	PUSH	ESI
	LEA	EAX,[EBP-010H]
	PUSH	EAX
	CALL	_VisibleRect
	ADD	ESP,BYTE 08H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+00H]
	LEA	EDI,[EBP-020H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 569:	if (InsideRect(x, y, rc))
;
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,DWORD [EBP-020H]
	JL	SHORT	L_245
	MOV	EAX,DWORD [EBP+0CH]
	CMP	EAX,DWORD [EBP-018H]
	JG	SHORT	L_245
	MOV	EAX,DWORD [EBP+010H]
	CMP	EAX,DWORD [EBP-01CH]
	JL	SHORT	L_245
	MOV	EAX,DWORD [EBP+010H]
	CMP	EAX,DWORD [EBP-014H]
	JG	SHORT	L_245
;
; Line 570:	Hit = wnd;
;
	MOV	EBX,ESI
L_245:
;
; Line 571:	if ((wnd1 = inWindow(LastWindow(wnd), x, y)) != NULL)
;
	PUSH	DWORD [EBP+010H]
	PUSH	DWORD [EBP+0CH]
	PUSH	DWORD [ESI+044H]
	CALL	_inWindow
	ADD	ESP,BYTE 0CH
	MOV	EDI,EAX
	TEST	EAX,EAX
	JE	SHORT	L_247
;
; Line 572:	Hit = wnd1;
;
	MOV	EBX,EDI
L_247:
;
; Line 573:	if (Hit != NULL)
;
	TEST	EBX,EBX
	JNE	SHORT	L_241
;
; Line 574:	break;
;
L_249:
L_243:
;
; Line 576:	wnd = PrevWindow(wnd);
;
	MOV	ESI,DWORD [ESI+04CH]
L_240:
;
; Line 565:	while (wnd != NULL)	{
;
	TEST	ESI,ESI
	JNE	SHORT	L_242
L_241:
;
; Line 578:	return Hit;
;
	MOV	EAX,EBX
L_238:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
;
; Line 581:	static WINDOW MouseWindow(int x, int y)
;
_MouseWindow:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	MOV	ESI,DWORD _CaptureMouse
L_252:
;
; Line 582:	{
;
;
; Line 585:	WINDOW Mwnd = inWindow(ApplicationWindow, x, y);
;
	PUSH	DWORD [EBP+0CH]
	PUSH	DWORD [EBP+08H]
	PUSH	DWORD [_ApplicationWindow]
	CALL	_inWindow
	ADD	ESP,BYTE 0CH
	MOV	EBX,EAX
;
; Line 587:	if (CaptureMouse != NULL)	{
;
	CMP	DWORD [ESI+00H],BYTE 00H
	JE	SHORT	L_253
;
; Line 588:	if (NoChildCaptureMouse ||
;
	CMP	DWORD [_NoChildCaptureMouse],BYTE 00H
	JNE	SHORT	L_257
	TEST	EBX,EBX
	JE	SHORT	L_257
	PUSH	DWORD [ESI+00H]
	PUSH	EBX
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JNE	SHORT	L_255
L_257:
;
; Line 591:	Mwnd = CaptureMouse;
;
	MOV	EBX,DWORD [ESI+00H]
L_255:
L_253:
;
; Line 593:	return Mwnd;
;
	MOV	EAX,EBX
L_251:
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_handshake]
;
; Line 596:	void handshake(void)
;
_handshake:
L_259:
;
; Line 597:	{
;
;
; Line 598:	handshaking++;
;
	INC	DWORD [_handshaking]
;
; Line 599:	dispatch_message();
;
	CALL	_dispatch_message
;
; Line 600:	--handshaking;
;
	DEC	DWORD [_handshaking]
;
; Line 601:	}
;
L_258:
	RET
[GLOBAL	_dispatch_message]
;
; Line 604:	BOOL dispatch_message(void)
;
_dispatch_message:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 018H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP-014H]
	MOV	EDI,DWORD _MsgQueueOffCtr
L_261:
;
; Line 605:	{
;
;
; Line 608:	collect_events();
;
	CALL	_collect_events
	JMP	NEAR	L_262
L_264:
;
; Line 613:	ev = EventQueue[EventQueueOffCtr];
;
	MOV	EAX,DWORD [_EventQueueOffCtr]
	IMUL	EAX,BYTE 0CH
	MOV	ECX,DWORD [EAX+_EventQueue+00H]
	MOV	DWORD [SS:ESI+00H],ECX
	MOV	ECX,DWORD [EAX+_EventQueue+00H+04H]
	MOV	DWORD [SS:ESI+00H+04H],ECX
	MOV	ECX,DWORD [EAX+_EventQueue+00H+04H+04H]
	MOV	DWORD [SS:ESI+00H+04H+04H],ECX
;
; Line 614:	if (++EventQueueOffCtr == MAXMESSAGES)
;
	INC	DWORD [_EventQueueOffCtr]
	CMP	DWORD [_EventQueueOffCtr],BYTE 064H
	JNE	SHORT	L_265
;
; Line 615:	EventQueueOffCtr = 0;
;
	MOV	DWORD [_EventQueueOffCtr],00H
L_265:
;
; Line 616:	--EventQueueCtr;
;
	DEC	DWORD [_EventQueueCtr]
;
; Line 620:	Kwnd = inFocus;
;
	MOV	EAX,DWORD [_inFocus]
	MOV	DWORD [EBP-04H],EAX
;
; Line 623:	if (CaptureKeyboard != NULL)
;
	CMP	DWORD [_CaptureKeyboard],BYTE 00H
	JE	SHORT	L_267
;
; Line 624:	if (Kwnd == NULL ||
;
	CMP	DWORD [EBP-04H],BYTE 00H
	JE	SHORT	L_271
	CMP	DWORD [_NoChildCaptureKeyboard],BYTE 00H
	JNE	SHORT	L_271
	PUSH	DWORD [_CaptureKeyboard]
	PUSH	DWORD [EBP-04H]
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JNE	SHORT	L_269
L_271:
;
; Line 627:	Kwnd = CaptureKeyboard;
;
	MOV	EAX,DWORD [_CaptureKeyboard]
	MOV	DWORD [EBP-04H],EAX
L_269:
L_267:
;
; Line 631:	switch (ev.event)    {
;
	MOV	EAX,DWORD [SS:ESI+00H]
	CMP	EAX,BYTE 024H
	JE	NEAR	L_276
	JA	SHORT	L_282
	CMP	EAX,BYTE 01EH
	JE	SHORT	L_274
	JA	SHORT	L_283
	CMP	EAX,BYTE 015H
	JE	SHORT	L_275
	JA	NEAR	L_273
	CMP	EAX,BYTE 012H
	JE	NEAR	L_281
	JMP	NEAR	L_273
L_283:
	CMP	EAX,BYTE 023H
	JE	NEAR	L_279
	JMP	NEAR	L_273
L_282:
	CMP	EAX,BYTE 026H
	JE	NEAR	L_280
	JA	SHORT	L_284
	CMP	EAX,BYTE 025H
	JE	NEAR	L_278
	JMP	NEAR	L_273
L_284:
	CMP	EAX,BYTE 027H
	JE	NEAR	L_277
	JMP	NEAR	L_273
L_274:
;
; Line 633:	case KEYBOARD:
;
L_275:
;
; Line 634:	if (!handshaking)
;
	CMP	DWORD [_handshaking],BYTE 00H
	JNE	SHORT	L_285
;
; Line 635:	SendMessage(Kwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	MOVSX	EAX,WORD [SS:ESI+00H]
	PUSH	EAX
	PUSH	DWORD [EBP-04H]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_285:
;
; Line 636:	break;
;
	JMP	NEAR	L_272
L_276:
;
; Line 638:	if (!handshaking)	{
;
	CMP	DWORD [_handshaking],BYTE 00H
	JNE	SHORT	L_287
;
; Line 639:	Mwnd = MouseWindow(ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	CALL	_MouseWindow
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
;
; Line 640:	if (!CaptureMouse ||
;
	CMP	DWORD [_CaptureMouse],BYTE 00H
	JE	SHORT	L_291
	CMP	DWORD [_NoChildCaptureMouse],BYTE 00H
	JNE	SHORT	L_289
	PUSH	DWORD [_CaptureMouse]
	PUSH	EBX
	CALL	_isAncestor
	ADD	ESP,BYTE 08H
	TEST	EAX,EAX
	JE	SHORT	L_289
L_291:
;
; Line 643:	if (Mwnd != inFocus)
;
	CMP	EBX,DWORD [_inFocus]
	JE	SHORT	L_292
;
; Line 644:	SendMessage(Mwnd, SETFOCUS, TRUE, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 01H
	PUSH	BYTE 08H
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_292:
L_289:
;
; Line 645:	SendMessage(Mwnd, LEFT_BUTTON, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	PUSH	BYTE 024H
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
L_287:
;
; Line 647:	break;
;
	JMP	SHORT	L_272
L_277:
;
; Line 649:	case DOUBLE_CLICK:
;
L_278:
;
; Line 650:	case RIGHT_BUTTON:
;
L_279:
;
; Line 651:	if (handshaking)
;
	CMP	DWORD [_handshaking],BYTE 00H
	JNE	SHORT	L_272
;
; Line 652:	break;
;
L_294:
;
; Line 653:	case MOUSE_MOVED:
;
L_280:
;
; Line 654:	Mwnd = MouseWindow(ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	CALL	_MouseWindow
	ADD	ESP,BYTE 08H
	MOV	EBX,EAX
;
; Line 655:	SendMessage(Mwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	MOVSX	EAX,WORD [SS:ESI+00H]
	PUSH	EAX
	PUSH	EBX
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 656:	break;
;
	JMP	SHORT	L_272
L_281:
;
; Line 658:	SendMessage(Cwnd, ev.event, ev.mx, ev.my);
;
	PUSH	DWORD [SS:ESI+08H]
	PUSH	DWORD [SS:ESI+04H]
	MOVSX	EAX,WORD [SS:ESI+00H]
	PUSH	EAX
	PUSH	DWORD [_Cwnd]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 659:	break;
;
	JMP	SHORT	L_272
L_273:
;
; Line 661:	break;
;
	JMP	SHORT	L_272
L_272:
L_262:
;
; Line 610:	while (EventQueueCtr > 0)  {
;
	CMP	DWORD [_EventQueueCtr],BYTE 00H
	JG	NEAR	L_264
L_263:
	JMP	SHORT	L_296
L_298:
;
; Line 668:	mq = MsgQueue[MsgQueueOffCtr];
;
	MOV	EAX,DWORD [EDI+00H]
	SHL	EAX,04H
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EAX+_MsgQueue+00H]
	LEA	EDI,[EBP-018H]
	PUSH	SS
	POP	ES
	CLD
	MOV	ECX,04H
	REP	MOVSD
	POP	EDI
	POP	ESI
;
; Line 669:	if (++MsgQueueOffCtr == MAXMESSAGES)
;
	INC	DWORD [EDI+00H]
	CMP	DWORD [EDI+00H],BYTE 064H
	JNE	SHORT	L_299
;
; Line 670:	MsgQueueOffCtr = 0;
;
	MOV	DWORD [EDI+00H],00H
L_299:
;
; Line 671:	--MsgQueueCtr;
;
	DEC	DWORD [_MsgQueueCtr]
;
; Line 672:	SendMessage(mq.wnd, mq.msg, mq.p1, mq.p2);
;
	PUSH	DWORD [EBP-0CH]
	PUSH	DWORD [EBP-010H]
	MOVSX	EAX,WORD [EBP-014H]
	PUSH	EAX
	PUSH	DWORD [EBP-018H]
	CALL	_SendMessage
	ADD	ESP,BYTE 010H
;
; Line 673:	if (mq.msg == ENDDIALOG)
;
	CMP	DWORD [EBP-014H],BYTE 04BH
	JNE	SHORT	L_301
;
; Line 674:	return FALSE;
;
	MOV	EAX,00H
	JMP	SHORT	L_260
L_301:
;
; Line 675:	if (mq.msg == STOP)	{
;
	CMP	DWORD [EBP-014H],BYTE 01H
	JNE	SHORT	L_303
;
; Line 676:	PostMessage(NULL, STOP, 0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	PUSH	BYTE 01H
	PUSH	BYTE 00H
	CALL	_PostMessage
	ADD	ESP,BYTE 010H
;
; Line 677:	return FALSE;
;
	MOV	EAX,00H
	JMP	SHORT	L_260
L_303:
L_296:
;
; Line 665:	while (MsgQueueCtr > 0)  {
;
	CMP	DWORD [_MsgQueueCtr],BYTE 00H
	JG	SHORT	L_298
L_297:
;
; Line 680:	return TRUE;
;
	MOV	EAX,01H
L_260:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
SECTION _STRING
L_47:
	DB	061H,06DH,020H,00H
L_46:
	DB	070H,06DH,020H,00H
L_45:
	DB	025H,032H,064H,03AH,025H,030H,032H,064H,00H
L_13:
	DB	020H,043H,061H,06EH,063H,065H,06CH,020H,00H
L_12:
	DB	020H,020H,020H,04FH,04BH,020H,020H,020H,00H
L_11:
	DB	045H,072H,072H,06FH,072H,00H
SECTION _DATA

_px	DD	0FFFFFFFFH

_py	DD	0FFFFFFFFH

_pmx	DD	0FFFFFFFFH

_pmy	DD	0FFFFFFFFH

_handshaking	DD	00H
[GLOBAL	_AllocTesting]

_AllocTesting	DD	00H
[GLOBAL	_AltDown]

_AltDown	DD	00H

_lagdelay	DD	07H

_doubletimer	DD	0FFFFFFFFH

_delaytimer	DD	0FFFFFFFFH

_clocktimer	DD	0FFFFFFFFH
[GLOBAL	_time_string]

_time_string	DB	020H,020H,020H,020H,020H,020H,020H,020H,020H,00H
	RESB	02H

_ermsg	DB	045H,072H,072H,06FH,072H,020H,061H,063H,063H,065H,073H,073H
	DB	069H,06EH,067H,020H,064H,072H,069H,076H,065H,020H,078H,00H

L_43	DD	00H

L_44	DD	00H

L_48	DD	010B9H,010CFH,010D0H,010D1H,010CBH
	DD	035H,010CDH,010C7H,010C8H,010C9H
SECTION _BSS

_mx	RESB	04H

_my	RESB	04H

_CriticalError	RESB	04H

_timerMemhand	RESB	04H

_dsSel	RESB	02H

_OldTimerCS	RESB	02H

_oldss	RESB	02H

_OldKeyboardCS	RESB	02H

_OldTimerIP	RESB	04H

_oldsp	RESB	04H

_OldKeyboardIP	RESB	04H

_hasints	RESB	04H

_timerRegs	RESB	032H

_keyboardRegs	RESB	032H

_stackbot	RESB	04H
[GLOBAL	_AllocError]

_AllocError	RESB	028H

_EventQueue	RESB	04B0H

_MsgQueue	RESB	0640H

_EventQueueOnCtr	RESB	04H

_EventQueueOffCtr	RESB	04H

_EventQueueCtr	RESB	04H

_MsgQueueOnCtr	RESB	04H

_MsgQueueOffCtr	RESB	04H

_MsgQueueCtr	RESB	04H

_keyportvalue	RESB	04H
[GLOBAL	_CaptureMouse]

_CaptureMouse	RESB	04H
[GLOBAL	_CaptureKeyboard]

_CaptureKeyboard	RESB	04H

_NoChildCaptureMouse	RESB	04H

_NoChildCaptureKeyboard	RESB	04H

_Cwnd	RESB	04H
SECTION _CONST

SECTION _TEXT
[EXTERN	_sprintf]
[EXTERN	_ConsoleInit]
[EXTERN	_ErrorBoxProc]
[EXTERN	_time]
[EXTERN	_GenericMessage]
[EXTERN	_ClientRect]
[EXTERN	_show_mousecursor]
[EXTERN	_unhidecursor]
[EXTERN	_inFocus]
[EXTERN	_set_mouseposition]
[EXTERN	_dpmi_set_protected_interrupt]
[EXTERN	_isVisible]
[EXTERN	_dpmi_get_sel_base]
[EXTERN	_hide_mousecursor]
[EXTERN	_mousebuttons]
[EXTERN	_restorecursor]
[EXTERN	_isEGA]
[EXTERN	_localtime]
[EXTERN	_dpmi_simulate_proc_int_frame]
[EXTERN	_hidecursor]
[EXTERN	_set_cursor_type]
[EXTERN	_set_mousetravel]
[EXTERN	_isAncestor]
[EXTERN	_setjmp]
[EXTERN	_normalcursor]
[EXTERN	_isVGA]
[EXTERN	_cursor]
[EXTERN	_ApplicationWindow]
[EXTERN	_getkey]
[EXTERN	_bioskey]
[EXTERN	_curr_cursor]
[EXTERN	_ClearDialogBoxes]
[EXTERN	_resetmouse]
[EXTERN	_getshift]
[EXTERN	_ClearClipboard]
[EXTERN	___seg0000]
[EXTERN	_subRectangle]
[EXTERN	_setvect]
[EXTERN	_inp]
[EXTERN	_get_mouseposition]
[EXTERN	_keyhit]
[EXTERN	___seg0040]
[EXTERN	_mouse_installed]
[EXTERN	_ConsoleRundown]
[EXTERN	_button_releases]
[EXTERN	_dpmi_get_memory]
[EXTERN	_savecursor]
[EXTERN	_LogMessages]
[EXTERN	_dpmi_get_protected_interrupt]
[EXTERN	_dpmi_free_memory]
[EXTERN	_strcpy]
