	SECTION _TEXT align=1 CLASS=CODE USE32
	SECTION _DATA align=16 CLASS=DATA USE32
	SECTION _BSS align=16 CLASS=BSS USE32
	SECTION _CONST align=16 CLASS=CONST USE32
	SECTION _STRING align=4 CLASS=STRING USE32
	SECTION cstartup align=4 CLASS=INITDATA USE32
	SECTION crundown align=4 CLASS=EXITDATA USE32
	SECTION cppinit  align=4 CLASS=CPPINIT USE32
	SECTION cppexit  align=4 CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
[GLOBAL	_clearscreen]
;
; Line 24:	void clearscreen(void)
;
_clearscreen:
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _regs
L_2:
;
; Line 25:	{
;
;
; Line 26:	int ht = SCREENHEIGHT;
;
	CALL	_isVGA
	TEST	EAX,EAX
	JNE	SHORT	L_5
	CALL	_isEGA
	TEST	EAX,EAX
	JE	SHORT	L_3
L_5:
	MOV	EAX,084H
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	INC	EAX
	JMP	SHORT	L_4
L_3:
	MOV	EAX,019H
L_4:
	MOV	EDI,EAX
;
; Line 27:	int wd = SCREENWIDTH;
;
	MOV	EAX,04AH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	FS,DX
	MOVSX	EAX,BYTE [FS:EAX+00H]
	MOVZX	EAX,AL
	MOV	EBX,EAX
;
; Line 28:	cursor(0, 0);
;
	PUSH	BYTE 00H
	PUSH	BYTE 00H
	CALL	_cursor
	ADD	ESP,BYTE 08H
;
; Line 29:	regs.h.al = ' ';
;
	MOV	BYTE [ESI+00H],020H
;
; Line 30:	regs.h.ah = 9;
;
	MOV	BYTE [ESI+01H],09H
;
; Line 31:	regs.w.bx = 7;
;
	MOV	WORD [ESI+04H],07H
;
; Line 32:	regs.w.cx = ht * wd;
;
	MOV	EAX,EDI
	IMUL	EAX,EBX
	MOV	WORD [ESI+08H],AX
;
; Line 33:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 34:	}
;
L_1:
	POP	EDI
	POP	ESI
	POP	EBX
	RET
[GLOBAL	_SwapCursorStack]
;
; Line 36:	void SwapCursorStack(void)
;
_SwapCursorStack:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 04H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _cs
	MOV	EDI,DWORD _cursorshape
L_7:
;
; Line 37:	{
;
;
; Line 38:	if (cs > 1)	{
;
	CMP	DWORD [ESI+00H],BYTE 01H
	JLE	SHORT	L_8
;
; Line 39:	swap(cursorpos[cs-2], cursorpos[cs-1]);
;
	MOV	EAX,DWORD [ESI+00H]
	SUB	EAX,BYTE 02H
	MOV	EAX,DWORD [EAX*4+_cursorpos+00H]
	MOV	DWORD [EBP-04H],EAX
	MOV	EAX,DWORD [ESI+00H]
	DEC	EAX
	MOV	EAX,DWORD [EAX*4+_cursorpos+00H]
	MOV	ECX,DWORD [ESI+00H]
	SUB	ECX,BYTE 02H
	MOV	DWORD [ECX*4+_cursorpos+00H],EAX
	MOV	EAX,DWORD [ESI+00H]
	DEC	EAX
	MOV	ECX,DWORD [EBP-04H]
	MOV	DWORD [EAX*4+_cursorpos+00H],ECX
;
; Line 40:	swap(cursorshape[cs-2], cursorshape[cs-1]);
;
	MOV	EAX,DWORD [ESI+00H]
	SUB	EAX,BYTE 02H
	MOV	EBX,DWORD [EDI+EAX*4+00H]
	MOV	EAX,DWORD [ESI+00H]
	DEC	EAX
	MOV	EAX,DWORD [EDI+EAX*4+00H]
	MOV	ECX,DWORD [ESI+00H]
	SUB	ECX,BYTE 02H
	MOV	DWORD [EDI+ECX*4+00H],EAX
	MOV	EAX,DWORD [ESI+00H]
	DEC	EAX
	MOV	DWORD [EDI+EAX*4+00H],EBX
L_8:
;
; Line 42:	}
;
L_6:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_ConsoleBackgroundMode]
;
; Line 44:	void ConsoleBackgroundMode(BOOL intensity)
;
_ConsoleBackgroundMode:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_11:
;
; Line 45:	{
;
;
; Line 46:	regs.w.ax = 0x1003 ;
;
	MOV	WORD [ESI+00H],01003H
;
; Line 47:	if (intensity && cfg.Intense)
;
	CMP	DWORD [EBP+08H],BYTE 00H
	JE	SHORT	L_12
	CMP	DWORD [0CH+_cfg],BYTE 00H
	JE	SHORT	L_12
;
; Line 48:	regs.w.bx = 0;  
;
	MOV	WORD [ESI+04H],00H
	JMP	SHORT	L_13
L_12:
;
; Line 50:	regs.w.bx = 1;  
;
	MOV	WORD [ESI+04H],01H
L_13:
;
; Line 51:	_int386( VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 52:	}
;
L_10:
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_ConsoleInit]
;
; Line 53:	void ConsoleInit(void)
;
_ConsoleInit:
L_15:
;
; Line 54:	{
;
;
; Line 55:	ConsoleBackgroundMode(TRUE);
;
	PUSH	BYTE 01H
	CALL	_ConsoleBackgroundMode
	POP	ECX
;
; Line 56:	savecursor();
;
	CALL	_savecursor
;
; Line 57:	hidecursor();
;
	CALL	_hidecursor
;
; Line 58:	}
;
L_14:
	RET
[GLOBAL	_ConsoleRundown]
;
; Line 59:	void ConsoleRundown(void)
;
_ConsoleRundown:
L_17:
;
; Line 60:	{
;
;
; Line 61:	ConsoleBackgroundMode(FALSE);
;
	PUSH	BYTE 00H
	CALL	_ConsoleBackgroundMode
	POP	ECX
;
; Line 62:	restorecursor();
;
	CALL	_restorecursor
;
; Line 63:	unhidecursor();
;
	CALL	_unhidecursor
;
; Line 64:	}
;
L_16:
	RET
[GLOBAL	_keyhit]
;
; Line 69:	BOOL keyhit(void)
;
_keyhit:
L_19:
;
; Line 70:	{
;
;
; Line 71:	asm mov ah,1
;
	MOV	AH,01H
;
; Line 72:	geninterrupt(KEYBRD);
;
	DB	0CDH
	DB	016H
;
; Line 73:	asm {
;
	SETNZ	AL
;
; Line 75:	movzx eax,al
;
	MOVZX	EAX,AL
;
; Line 77:	}
;
;
; Line 79:	}
;
L_18:
	RET
[GLOBAL	_getkey]
;
; Line 83:	int getkey(void)
;
_getkey:
	PUSH	EBX
L_21:
;
; Line 84:	{
;
;
; Line 86:	while (keyhit() == FALSE)
;
L_22:
	CALL	_keyhit
	TEST	EAX,EAX
	JE	SHORT	L_22
;
; Line 88:	if (((c = bioskey(0)) & 0xff) == 0)
;
	PUSH	BYTE 00H
	CALL	_bioskey
	POP	ECX
	MOV	EBX,EAX
	MOVZX	EAX,AL
	TEST	EAX,EAX
	JNE	SHORT	L_23
;
; Line 89:	c = (c >> 8) | 0x1080;
;
	MOV	EAX,EBX
	SAR	EAX,08H
	OR	EAX,01080H
	MOV	EBX,EAX
	JMP	SHORT	L_24
L_23:
;
; Line 91:	c &= 0xff;
;
	MOVZX	EBX,BL
L_24:
;
; Line 92:	return c & 0x10ff;
;
	MOV	EAX,EBX
	AND	EAX,010FFH
L_20:
	POP	EBX
	RET
[GLOBAL	_getshift]
;
; Line 96:	int getshift(void)
;
_getshift:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_26:
;
; Line 97:	{
;
;
; Line 98:	regs.h.ah = 2;
;
	MOV	BYTE [ESI+01H],02H
;
; Line 99:	_int386(KEYBRD, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 016H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 100:	return regs.h.al;
;
	MOVZX	EAX,BYTE [ESI+00H]
L_25:
	POP	ESI
	RET
[GLOBAL	_beep]
;
; Line 112:	void beep(void)
;
_beep:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 0CH
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	LEA	ESI,[EBP-08H]
L_28:
;
; Line 113:	{
;
;
; Line 114:	int far *clk = MK_FP(__seg0040,0x6c);
;
	MOV	EAX,06CH
	MOVZX	ECX,WORD [___seg0040]
	MOV	EDX,ECX
	MOV	DWORD [SS:ESI+00H],EAX
	MOV	WORD [SS:ESI+00H+04H],DX
;
; Line 115:	wait();
;
	LFS	EAX,[SS:ESI+00H]
	MOV	EDI,DWORD [FS:EAX+00H]
L_29:
	LFS	EAX,[SS:ESI+00H]
	CMP	EDI,DWORD [FS:EAX+00H]
	JE	SHORT	L_29
;
; Line 116:	outp(0x43, 0xb6);                
;
	PUSH	DWORD 0B6H
	PUSH	BYTE 043H
	CALL	_outp
	ADD	ESP,BYTE 08H
;
; Line 117:	outp(0x42, (int) (COUNT % 256));
;
	PUSH	DWORD 09CH
	PUSH	BYTE 042H
	CALL	_outp
	ADD	ESP,BYTE 08H
;
; Line 118:	outp(0x42, (int) (COUNT / 256));
;
	PUSH	BYTE 02EH
	PUSH	BYTE 042H
	CALL	_outp
	ADD	ESP,BYTE 08H
;
; Line 119:	outp(0x61, inp(0x61) | 3);       
;
	PUSH	BYTE 061H
	CALL	_inp
	POP	ECX
	OR	EAX,BYTE 03H
	PUSH	EAX
	PUSH	BYTE 061H
	CALL	_outp
	ADD	ESP,BYTE 08H
;
; Line 120:	wait();
;
	LFS	EAX,[SS:ESI+00H]
	MOV	EBX,DWORD [FS:EAX+00H]
L_30:
	LFS	EAX,[SS:ESI+00H]
	CMP	EBX,DWORD [FS:EAX+00H]
	JE	SHORT	L_30
;
; Line 121:	outp(0x61, inp(0x61) & ~3);      
;
	PUSH	BYTE 061H
	CALL	_inp
	POP	ECX
	AND	EAX,BYTE 0FFFFFFFCH
	PUSH	EAX
	PUSH	BYTE 061H
	CALL	_outp
	ADD	ESP,BYTE 08H
;
; Line 122:	}
;
L_27:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_videomode]
;
; Line 125:	void videomode(void)
;
_videomode:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_32:
;
; Line 126:	{
;
;
; Line 127:	regs.h.ah = 15;
;
	MOV	BYTE [ESI+01H],0FH
;
; Line 128:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 129:	video_mode = regs.h.al;
;
	MOVZX	EAX,BYTE [ESI+00H]
	MOV	DWORD [_video_mode],EAX
;
; Line 130:	video_page = regs.w.bx;
;
	MOVZX	EAX,WORD [ESI+04H]
	MOV	DWORD [_video_page],EAX
;
; Line 131:	video_page &= 0xff00;
;
	AND	DWORD [_video_page],0FF00H
;
; Line 132:	video_mode &= 0x7f;
;
	AND	DWORD [_video_mode],BYTE 07FH
;
; Line 133:	}
;
L_31:
	POP	ESI
	RET
[GLOBAL	_cursor]
;
; Line 136:	void cursor(int x, int y)
;
_cursor:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_34:
;
; Line 137:	{
;
;
; Line 138:	videomode();
;
	CALL	_videomode
;
; Line 139:	regs.w.dx = ((y << 8) & 0xff00) + x;
;
	MOV	EAX,DWORD [EBP+0CH]
	SAL	EAX,08H
	AND	EAX,0FF00H
	ADD	EAX,DWORD [EBP+08H]
	MOV	WORD [ESI+0CH],AX
;
; Line 140:	regs.h.ah = SETCURSOR;
;
	MOV	BYTE [ESI+01H],02H
;
; Line 141:	regs.w.bx = video_page;
;
	MOV	EAX,DWORD [_video_page]
	MOV	WORD [ESI+04H],AX
;
; Line 142:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 143:	}
;
L_33:
	POP	ESI
	POP	EBP
	RET
;
; Line 146:	static void near getcursor(void)
;
_getcursor:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_36:
;
; Line 147:	{
;
;
; Line 148:	videomode();
;
	CALL	_videomode
;
; Line 149:	regs.h.ah = READCURSOR;
;
	MOV	BYTE [ESI+01H],03H
;
; Line 150:	regs.w.bx = video_page;
;
	MOV	EAX,DWORD [_video_page]
	MOV	WORD [ESI+04H],AX
;
; Line 151:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 152:	}
;
L_35:
	POP	ESI
	RET
[GLOBAL	_curr_cursor]
;
; Line 155:	void curr_cursor(int *x, int *y)
;
_curr_cursor:
	PUSH	EBP
	MOV	EBP,ESP
L_38:
;
; Line 156:	{
;
;
; Line 157:	getcursor();
;
	CALL	_getcursor
;
; Line 158:	*x = regs.h.dl;
;
	MOV	EAX,DWORD [EBP+08H]
	MOVZX	ECX,BYTE [_regs+0CH]
	MOV	DWORD [EAX+00H],ECX
;
; Line 159:	*y = regs.h.dh;
;
	MOV	EAX,DWORD [EBP+0CH]
	MOVZX	ECX,BYTE [_regs+0DH]
	MOV	DWORD [EAX+00H],ECX
;
; Line 160:	}
;
L_37:
	POP	EBP
	RET
[GLOBAL	_savecursor]
;
; Line 163:	void savecursor(void)
;
_savecursor:
	PUSH	ESI
	MOV	ESI,DWORD _cs
L_40:
;
; Line 164:	{
;
;
; Line 165:	if (cs < MAXSAVES)    {
;
	CMP	DWORD [ESI+00H],BYTE 032H
	JGE	SHORT	L_41
;
; Line 166:	getcursor();
;
	CALL	_getcursor
;
; Line 167:	cursorshape[cs] = regs.w.cx;
;
	MOV	EAX,DWORD [ESI+00H]
	MOVZX	ECX,WORD [_regs+08H]
	MOV	DWORD [EAX*4+_cursorshape+00H],ECX
;
; Line 168:	cursorpos[cs] = regs.w.dx;
;
	MOV	EAX,DWORD [ESI+00H]
	MOVZX	ECX,WORD [_regs+0CH]
	MOV	DWORD [EAX*4+_cursorpos+00H],ECX
;
; Line 169:	cs++;
;
	INC	DWORD [ESI+00H]
L_41:
;
; Line 171:	}
;
L_39:
	POP	ESI
	RET
[GLOBAL	_restorecursor]
;
; Line 174:	void restorecursor(void)
;
_restorecursor:
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD _regs
	MOV	EDI,DWORD _cs
L_44:
;
; Line 175:	{
;
;
; Line 176:	if (cs)    {
;
	CMP	DWORD [EDI+00H],BYTE 00H
	JE	SHORT	L_45
;
; Line 177:	--cs;
;
	DEC	DWORD [EDI+00H]
;
; Line 178:	videomode();
;
	CALL	_videomode
;
; Line 179:	regs.w.dx = cursorpos[cs];
;
	MOV	EAX,DWORD [EDI+00H]
	MOV	EAX,DWORD [EAX*4+_cursorpos+00H]
	MOV	WORD [ESI+0CH],AX
;
; Line 180:	regs.h.ah = SETCURSOR;
;
	MOV	BYTE [ESI+01H],02H
;
; Line 181:	regs.w.bx = video_page;
;
	MOV	EAX,DWORD [_video_page]
	MOV	WORD [ESI+04H],AX
;
; Line 182:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 183:	set_cursor_type(cursorshape[cs]);
;
	MOV	EAX,DWORD [EDI+00H]
	PUSH	DWORD [EAX*4+_cursorshape+00H]
	CALL	_set_cursor_type
	POP	ECX
L_45:
;
; Line 185:	}
;
L_43:
	POP	EDI
	POP	ESI
	RET
[GLOBAL	_normalcursor]
;
; Line 188:	void normalcursor(void)
;
_normalcursor:
L_48:
;
; Line 189:	{
;
;
; Line 190:	set_cursor_type(0x0607);
;
	PUSH	DWORD 0607H
	CALL	_set_cursor_type
	POP	ECX
;
; Line 191:	}
;
L_47:
	RET
[GLOBAL	_hidecursor]
;
; Line 194:	void hidecursor(void)
;
_hidecursor:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_50:
;
; Line 195:	{
;
;
; Line 196:	getcursor();
;
	CALL	_getcursor
;
; Line 197:	regs.h.ch |= HIDECURSOR;
;
	BTS	DWORD [ESI+09H],05H
;
; Line 198:	regs.h.ah = SETCURSORTYPE;
;
	MOV	BYTE [ESI+01H],01H
;
; Line 199:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 200:	}
;
L_49:
	POP	ESI
	RET
[GLOBAL	_unhidecursor]
;
; Line 203:	void unhidecursor(void)
;
_unhidecursor:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_52:
;
; Line 204:	{
;
;
; Line 205:	getcursor();
;
	CALL	_getcursor
;
; Line 206:	regs.h.ch &= ~HIDECURSOR;
;
	AND	BYTE [ESI+09H],BYTE 0DFH
;
; Line 207:	regs.h.ah = SETCURSORTYPE;
;
	MOV	BYTE [ESI+01H],01H
;
; Line 208:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 209:	}
;
L_51:
	POP	ESI
	RET
[GLOBAL	_set_cursor_type]
;
; Line 212:	void set_cursor_type(unsigned t)
;
_set_cursor_type:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_54:
;
; Line 213:	{
;
;
; Line 214:	videomode();
;
	CALL	_videomode
;
; Line 215:	regs.h.ah = SETCURSORTYPE;
;
	MOV	BYTE [ESI+01H],01H
;
; Line 216:	regs.w.bx = video_page;
;
	MOV	EAX,DWORD [_video_page]
	MOV	WORD [ESI+04H],AX
;
; Line 217:	regs.w.cx = t ;
;
	MOV	EAX,DWORD [EBP+08H]
	MOV	WORD [ESI+08H],AX
;
; Line 218:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 219:	}
;
L_53:
	POP	ESI
	POP	EBP
	RET
[GLOBAL	_isEGA]
;
; Line 222:	BOOL isEGA(void)
;
_isEGA:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_56:
;
; Line 223:	{
;
;
; Line 224:	if (isVGA())
;
	CALL	_isVGA
	TEST	EAX,EAX
	JE	SHORT	L_57
;
; Line 225:	return FALSE;
;
	MOV	EAX,00H
	JMP	SHORT	L_55
L_57:
;
; Line 226:	regs.h.ah = 0x12;
;
	MOV	BYTE [ESI+01H],012H
;
; Line 227:	regs.h.bl = 0x10;
;
	MOV	BYTE [ESI+04H],010H
;
; Line 228:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 229:	return regs.h.bl != 0x10;
;
	MOVZX	EAX,BYTE [ESI+04H]
	CMP	EAX,BYTE 010H
	SETNE	AL
	MOVZX	EAX,AL
L_55:
	POP	ESI
	RET
[GLOBAL	_isVGA]
;
; Line 233:	BOOL isVGA(void)
;
_isVGA:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_60:
;
; Line 234:	{
;
;
; Line 235:	regs.w.ax = 0x1a00;
;
	MOV	WORD [ESI+00H],01A00H
;
; Line 236:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 237:	return regs.h.al == 0x1a && regs.h.bl > 6;
;
	MOVZX	EAX,BYTE [ESI+00H]
	CMP	EAX,BYTE 01AH
	JNE	SHORT	L_62
	MOVZX	EAX,BYTE [ESI+04H]
	CMP	EAX,BYTE 06H
	JA	SHORT	L_61
L_62:
	SUB	EAX,EAX
; TEST EAX,IMMED (branches around next four bytes of code)
	DB	0A9H
L_61:
	SUB	EAX,EAX
	INC	EAX
	NOP
L_59:
	POP	ESI
	RET
;
; Line 240:	static void Scan350(void)
;
_Scan350:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_64:
;
; Line 241:	{
;
;
; Line 242:	regs.w.ax = 0x1201;
;
	MOV	WORD [ESI+00H],01201H
;
; Line 243:	regs.h.bl = 0x30;
;
	MOV	BYTE [ESI+04H],030H
;
; Line 244:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 245:	regs.h.ah = 0x0f;
;
	MOV	BYTE [ESI+01H],0FH
;
; Line 246:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 247:	regs.h.ah = 0x00;
;
	MOV	BYTE [ESI+01H],00H
;
; Line 248:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 249:	}
;
L_63:
	POP	ESI
	RET
;
; Line 251:	static void Scan400(void)
;
_Scan400:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_66:
;
; Line 252:	{
;
;
; Line 253:	regs.w.ax = 0x1202;
;
	MOV	WORD [ESI+00H],01202H
;
; Line 254:	regs.h.bl = 0x30;
;
	MOV	BYTE [ESI+04H],030H
;
; Line 255:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 256:	regs.h.ah = 0x0f;
;
	MOV	BYTE [ESI+01H],0FH
;
; Line 257:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 258:	regs.h.ah = 0x00;
;
	MOV	BYTE [ESI+01H],00H
;
; Line 259:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 260:	}
;
L_65:
	POP	ESI
	RET
[GLOBAL	_Set25]
;
; Line 263:	void Set25(void)
;
_Set25:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_68:
;
; Line 264:	{
;
;
; Line 265:	if (isVGA())	{
;
	CALL	_isVGA
	TEST	EAX,EAX
	JE	SHORT	L_69
;
; Line 266:	Scan400();
;
	CALL	_Scan400
;
; Line 267:	regs.w.ax = 0x1114;
;
	MOV	WORD [ESI+00H],01114H
	JMP	SHORT	L_70
L_69:
;
; Line 270:	regs.w.ax = 0x1111;
;
	MOV	WORD [ESI+00H],01111H
L_70:
;
; Line 271:	regs.h.bl = 0;
;
	MOV	BYTE [ESI+04H],00H
;
; Line 272:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 273:	ConsoleBackgroundMode(TRUE);
;
	PUSH	BYTE 01H
	CALL	_ConsoleBackgroundMode
	POP	ECX
;
; Line 274:	}
;
L_67:
	POP	ESI
	RET
[GLOBAL	_Set43]
;
; Line 277:	void Set43(void)
;
_Set43:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_72:
;
; Line 278:	{
;
;
; Line 279:	if (isVGA())
;
	CALL	_isVGA
	TEST	EAX,EAX
	JE	SHORT	L_73
;
; Line 280:	Scan350();
;
	CALL	_Scan350
L_73:
;
; Line 281:	regs.w.ax = 0x1112;
;
	MOV	WORD [ESI+00H],01112H
;
; Line 282:	regs.h.bl = 0;
;
	MOV	BYTE [ESI+04H],00H
;
; Line 283:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 284:	ConsoleBackgroundMode(TRUE);
;
	PUSH	BYTE 01H
	CALL	_ConsoleBackgroundMode
	POP	ECX
;
; Line 285:	}
;
L_71:
	POP	ESI
	RET
[GLOBAL	_Set50]
;
; Line 288:	void Set50(void)
;
_Set50:
	PUSH	ESI
	MOV	ESI,DWORD _regs
L_76:
;
; Line 289:	{
;
;
; Line 290:	if (isVGA())
;
	CALL	_isVGA
	TEST	EAX,EAX
	JE	SHORT	L_77
;
; Line 291:	Scan400();
;
	CALL	_Scan400
L_77:
;
; Line 292:	regs.w.ax = 0x1112;
;
	MOV	WORD [ESI+00H],01112H
;
; Line 293:	regs.h.bl = 0;
;
	MOV	BYTE [ESI+04H],00H
;
; Line 294:	_int386(VIDEO, &regs, &regs);
;
	PUSH	ESI
	PUSH	ESI
	PUSH	BYTE 010H
	CALL	__int386
	ADD	ESP,BYTE 0CH
;
; Line 295:	ConsoleBackgroundMode(TRUE);
;
	PUSH	BYTE 01H
	CALL	_ConsoleBackgroundMode
	POP	ECX
;
; Line 296:	}
;
L_75:
	POP	ESI
	RET
[GLOBAL	_AltConvert]
;
; Line 299:	int AltConvert(int c)
;
_AltConvert:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
L_80:
;
; Line 300:	{
;
;
; Line 301:	int i, a = 0;
;
	MOV	ESI,00H
	MOV	EBX,00H
	JMP	SHORT	L_83
L_81:
;
; Line 303:	if (c == altconvert[i])
;
	MOV	EAX,DWORD [EBX*4+_altconvert+00H]
	CMP	DWORD [EBP+08H],EAX
	JE	SHORT	L_84
;
; Line 304:	break;
;
L_85:
;
; Line 302:	for (i = 0; i < 36; i++)
;
L_82:
	INC	EBX
L_83:
	CMP	EBX,BYTE 024H
	JL	SHORT	L_81
L_84:
;
; Line 305:	if (i < 26)
;
	CMP	EBX,BYTE 01AH
	JGE	SHORT	L_87
;
; Line 306:	a = 'a' + i;
;
	MOV	ESI,EBX
	ADD	ESI,BYTE 061H
	JMP	SHORT	L_88
L_87:
;
; Line 307:	else if (i < 36)
;
	CMP	EBX,BYTE 024H
	JGE	SHORT	L_89
;
; Line 308:	a = '0' + i - 26;
;
	MOV	ESI,EBX
	ADD	ESI,BYTE 016H
L_89:
L_88:
;
; Line 309:	return a;
;
	MOV	EAX,ESI
L_79:
	POP	ESI
	POP	EBX
	POP	EBP
	RET
SECTION _DATA

_altconvert	DD	0109EH,010B0H,010AEH,010A0H,01092H
	DD	010A1H,010A2H,010A3H,01097H,010A4H
	DD	010A5H,010A6H,010B2H,010B1H,01098H
	DD	01099H,01090H,01093H,0109FH,01094H
	DD	01096H,010AFH,01091H,010ADH,01095H
	DD	010ACH,01081H,010F8H,010F9H,010FAH
	DD	010FBH,010FCH,010FDH,010FEH,010FFH
	DD	01080H
SECTION _BSS
[GLOBAL	_video_mode]

_video_mode	RESB	04H
[GLOBAL	_video_page]

_video_page	RESB	04H

_cursorpos	RESB	0C8H

_cursorshape	RESB	0C8H

_cs	RESB	04H

_regs	RESB	01CH
SECTION _CONST

SECTION _TEXT
[EXTERN	_cfg]
[EXTERN	_bioskey]
[EXTERN	_outp]
[EXTERN	_inp]
[EXTERN	___seg0040]
[EXTERN	__int386]
