	SECTION _TEXT align=1 CLASS=CODE USE32
	SECTION _DATA align=16 CLASS=DATA USE32
	SECTION _BSS align=16 CLASS=BSS USE32
	SECTION _CONST align=16 CLASS=CONST USE32
	SECTION _STRING align=4 CLASS=STRING USE32
	SECTION cstartup align=4 CLASS=INITDATA USE32
	SECTION crundown align=4 CLASS=EXITDATA USE32
	SECTION cppinit  align=4 CLASS=CPPINIT USE32
	SECTION cppexit  align=4 CLASS=CPPEXIT USE32
	GROUP DGROUP _DATA _BSS _CONST _STRING

SECTION _TEXT
[GLOBAL	_CopyTextToClipboard]
;
; Line 7:	void CopyTextToClipboard(ATTRCHR *text)
;
_CopyTextToClipboard:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	EBX,DWORD [EBP+08H]
	MOV	ESI,DWORD _Clipboard
	MOV	EDI,DWORD _ClipboardLength
L_2:
;
; Line 8:	{
;
;
; Line 9:	ClipboardLength = tstrlen(text);
;
	PUSH	EBX
	CALL	_tstrlen
	POP	ECX
	MOV	DWORD [EDI+00H],EAX
;
; Line 10:	Clipboard = DFrealloc(Clipboard, ClipboardLength * sizeof(ATTRCHR));
;
	MOV	EAX,DWORD [EDI+00H]
	SHL	EAX,01H
	PUSH	EAX
	PUSH	DWORD [ESI+00H]
	CALL	_DFrealloc
	ADD	ESP,BYTE 08H
	MOV	DWORD [ESI+00H],EAX
;
; Line 11:	memmove(Clipboard, text, ClipboardLength * sizeof(ATTRCHR));
;
	MOV	EAX,DWORD [EDI+00H]
	SHL	EAX,01H
	PUSH	EAX
	PUSH	EBX
	PUSH	DWORD [ESI+00H]
	CALL	_memmove
	ADD	ESP,BYTE 0CH
;
; Line 12:	}
;
L_1:
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
[GLOBAL	_CopyToClipboard]
;
; Line 14:	void CopyToClipboard(WINDOW wnd)
;
_CopyToClipboard:
	PUSH	EBP
	MOV	EBP,ESP
	SUB	ESP,BYTE 04H
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EDI,DWORD _Clipboard
L_4:
;
; Line 15:	{
;
;
; Line 16:	if (TextBlockMarked(wnd))    {
;
	CMP	DWORD [ESI+0ACH],BYTE 00H
	JNE	SHORT	L_7
	CMP	DWORD [ESI+0B4H],BYTE 00H
	JNE	SHORT	L_7
	CMP	DWORD [ESI+0B0H],BYTE 00H
	JNE	SHORT	L_7
	CMP	DWORD [ESI+0B8H],BYTE 00H
	JE	SHORT	L_5
L_7:
;
; Line 17:	ATTRCHR *bbl=TextLine(wnd,wnd->BlkBegLine)+wnd->BlkBegCol;
;
	MOV	EAX,DWORD [ESI+0C4H]
	MOV	ECX,DWORD [ESI+0ACH]
	MOV	ECX,DWORD [EAX+ECX*4+00H]
	SHL	ECX,01H
	ADD	ECX,DWORD [ESI+098H]
	MOV	EAX,DWORD [ESI+0B0H]
	SHL	EAX,01H
	ADD	ECX,EAX
	MOV	EBX,ECX
;
; Line 18:	ATTRCHR *bel=TextLine(wnd,wnd->BlkEndLine)+wnd->BlkEndCol;
;
	MOV	EAX,DWORD [ESI+0C4H]
	MOV	ECX,DWORD [ESI+0B4H]
	MOV	ECX,DWORD [EAX+ECX*4+00H]
	SHL	ECX,01H
	ADD	ECX,DWORD [ESI+098H]
	MOV	EAX,DWORD [ESI+0B8H]
	SHL	EAX,01H
	ADD	ECX,EAX
	MOV	DWORD [EBP-04H],ECX
;
; Line 19:	ClipboardLength = (int) (bel - bbl);
;
	MOV	EAX,DWORD [EBP-04H]
	SUB	EAX,EBX
	SHR	EAX,01H
	MOV	DWORD [_ClipboardLength],EAX
;
; Line 20:	Clipboard = DFrealloc(Clipboard, ClipboardLength * sizeof(ATTRCHR));
;
	MOV	EAX,DWORD [_ClipboardLength]
	SHL	EAX,01H
	PUSH	EAX
	PUSH	DWORD [EDI+00H]
	CALL	_DFrealloc
	ADD	ESP,BYTE 08H
	MOV	DWORD [EDI+00H],EAX
;
; Line 21:	memmove(Clipboard, bbl, ClipboardLength * sizeof(ATTRCHR));
;
	MOV	EAX,DWORD [_ClipboardLength]
	SHL	EAX,01H
	PUSH	EAX
	PUSH	EBX
	PUSH	DWORD [EDI+00H]
	CALL	_memmove
	ADD	ESP,BYTE 0CH
L_5:
;
; Line 23:	}
;
L_3:
	POP	EDI
	POP	ESI
	POP	EBX
	MOV	ESP,EBP
	POP	EBP
	RET
[GLOBAL	_ClearClipboard]
;
; Line 25:	void ClearClipboard(void)
;
_ClearClipboard:
	PUSH	ESI
	MOV	ESI,DWORD _Clipboard
L_9:
;
; Line 26:	{
;
;
; Line 27:	if (Clipboard != NULL)  {
;
	CMP	DWORD [ESI+00H],BYTE 00H
	JE	SHORT	L_10
;
; Line 28:	free(Clipboard);
;
	PUSH	DWORD [ESI+00H]
	CALL	_free
	POP	ECX
;
; Line 29:	ClipboardLength = 0;
;
	MOV	DWORD [_ClipboardLength],00H
;
; Line 30:	Clipboard = NULL;
;
	MOV	DWORD [ESI+00H],00H
L_10:
;
; Line 32:	}
;
L_8:
	POP	ESI
	RET
[GLOBAL	_PasteText]
;
; Line 35:	BOOL PasteText(WINDOW wnd, ATTRCHR *SaveTo, unsigned len)
;
_PasteText:
	PUSH	EBP
	MOV	EBP,ESP
	PUSH	EBX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,DWORD [EBP+08H]
	MOV	EDI,DWORD [EBP+010H]
L_13:
;
; Line 36:	{
;
;
; Line 37:	if (SaveTo != NULL && len > 0)    {
;
	CMP	DWORD [EBP+0CH],BYTE 00H
	JE	NEAR	L_14
	TEST	EDI,EDI
	JZ	NEAR	L_14
;
; Line 38:	unsigned plen = wnd->textlen + len;
;
	MOV	EBX,DWORD [ESI+09CH]
	ADD	EBX,EDI
;
; Line 40:	if (plen <= wnd->MaxTextLength)	{
;
	CMP	EBX,DWORD [ESI+0FCH]
	JA	NEAR	L_16
;
; Line 41:	if (plen+1 > wnd->textalloc)    {
;
	MOV	EAX,EBX
	INC	EAX
	CMP	EAX,DWORD [ESI+0A0H]
	JBE	SHORT	L_18
;
; Line 42:	wnd->textalloc = plen + 3 + GROWLENGTH;
;
	MOV	EAX,EBX
	ADD	EAX,BYTE 043H
	MOV	DWORD [ESI+0A0H],EAX
;
; Line 43:	wnd->text = DFrealloc(wnd->text, wnd->textalloc * sizeof(ATTRCHR));
;
	MOV	EAX,DWORD [ESI+0A0H]
	SHL	EAX,01H
	PUSH	EAX
	PUSH	DWORD [ESI+098H]
	CALL	_DFrealloc
	ADD	ESP,BYTE 08H
	MOV	DWORD [ESI+098H],EAX
L_18:
;
; Line 45:	memmove(CurrChar+len, CurrChar, (wnd->textlen - (CurrChar - wnd->text) +1) * sizeof(ATTRCHR));
;
	MOV	EAX,DWORD [ESI+0C4H]
	MOV	ECX,DWORD [ESI+0DCH]
	MOV	ECX,DWORD [EAX+ECX*4+00H]
	SHL	ECX,01H
	ADD	ECX,DWORD [ESI+098H]
	MOV	EAX,DWORD [ESI+0D8H]
	SHL	EAX,01H
	ADD	ECX,EAX
	SUB	ECX,DWORD [ESI+098H]
	SHR	ECX,01H
	MOV	EAX,DWORD [ESI+09CH]
	SUB	EAX,ECX
	INC	EAX
	SHL	EAX,01H
	PUSH	EAX
	MOV	EAX,DWORD [ESI+0C4H]
	MOV	ECX,DWORD [ESI+0DCH]
	MOV	ECX,DWORD [EAX+ECX*4+00H]
	SHL	ECX,01H
	ADD	ECX,DWORD [ESI+098H]
	MOV	EAX,DWORD [ESI+0D8H]
	SHL	EAX,01H
	ADD	ECX,EAX
	PUSH	ECX
	MOV	EAX,DWORD [ESI+0C4H]
	MOV	ECX,DWORD [ESI+0DCH]
	MOV	ECX,DWORD [EAX+ECX*4+00H]
	SHL	ECX,01H
	ADD	ECX,DWORD [ESI+098H]
	MOV	EAX,DWORD [ESI+0D8H]
	SHL	EAX,01H
	ADD	ECX,EAX
	MOV	EAX,EDI
	SHL	EAX,01H
	ADD	ECX,EAX
	PUSH	ECX
	CALL	_memmove
	ADD	ESP,BYTE 0CH
;
; Line 46:	memmove(CurrChar, SaveTo, len * sizeof(ATTRCHR));
;
	MOV	EAX,EDI
	SHL	EAX,01H
	PUSH	EAX
	PUSH	DWORD [EBP+0CH]
	MOV	EAX,DWORD [ESI+0C4H]
	MOV	ECX,DWORD [ESI+0DCH]
	MOV	ECX,DWORD [EAX+ECX*4+00H]
	SHL	ECX,01H
	ADD	ECX,DWORD [ESI+098H]
	MOV	EAX,DWORD [ESI+0D8H]
	SHL	EAX,01H
	ADD	ECX,EAX
	PUSH	ECX
	CALL	_memmove
	ADD	ESP,BYTE 0CH
;
; Line 47:	wnd->textlen = plen;
;
	MOV	DWORD [ESI+09CH],EBX
;
; Line 48:	BuildTextPointers(wnd);
;
	PUSH	ESI
	CALL	_BuildTextPointers
	POP	ECX
;
; Line 49:	ChangedText(wnd, TRUE);
;
	PUSH	BYTE 01H
	PUSH	ESI
	CALL	_ChangedText
	ADD	ESP,BYTE 08H
;
; Line 50:	return TRUE;
;
	MOV	EAX,01H
	JMP	SHORT	L_12
L_16:
L_14:
;
; Line 53:	return FALSE;
;
	MOV	EAX,00H
L_12:
	POP	EDI
	POP	ESI
	POP	EBX
	POP	EBP
	RET
SECTION _BSS
[GLOBAL	_Clipboard]

_Clipboard	RESB	04H
[GLOBAL	_ClipboardLength]

_ClipboardLength	RESB	04H
SECTION _CONST

SECTION _TEXT
[EXTERN	_ChangedText]
[EXTERN	_DFrealloc]
[EXTERN	_tstrlen]
[EXTERN	_memmove]
[EXTERN	_free]
[EXTERN	_BuildTextPointers]
