/* 
CCIDE
Copyright 2001-2006 David Lindauer.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

You may contact the author at:
	mailto::camille@bluegrass.net
 */
#define STRICT 
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <richedit.h>
#include <stdio.h>
#include "header.h"

#ifndef __CCDL__
    #ifndef TCIF_STATE
        #define TCIF_STATE              0x0010
        #define TCIS_BUTTONPRESSED      0x0001
        #define TCIS_HIGHLIGHTED        0x0002
        #define dwState     lpReserved1
        #define dwStateMask lpReserved2
    #endif 
#endif 

extern HANDLE hInstance;
extern HWND hwndWatch, hwndClient, hwndFrame, hwndTab;
extern int numberofdrawwindows;
extern HANDLE children[MAX_CHILDREN];

HWND hwndSourceTab;
static char szSourceTabClassName[] = "xccSourceTabClass";
static WNDPROC oldproc;
static HWND hwndTabCtrl;
static char *nameTags[MAX_CHILDREN + 50];
static int tagCount;
static LOGFONT Boldfontdata = 
{
    -12, 0, 0, 0, FW_BOLD, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS,
        CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_MODERN | FF_DONTCARE, "Arial"
};
static LOGFONT Normalfontdata = 
{
    -12, 0, 0, 0, FW_NORMAL, FALSE, FALSE, FALSE, ANSI_CHARSET,
        OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FF_MODERN |
        FF_DONTCARE, "Arial"
};
static HFONT tabBoldFont, tabNormalFont;
BOOL CALLBACK stEnumProc(HWND wnd, LPARAM param)
{
    TC_ITEM tie;
    if (GetParent(wnd) != hwndClient)
        return TRUE;
    if (!IsWindowVisible(wnd))
        return TRUE;
    nameTags[tagCount] = calloc(1,256);
    if (nameTags[tagCount])
    {
        GetWindowText(wnd, nameTags[tagCount], 256);
        tie.mask = TCIF_TEXT | TCIF_PARAM;
        tie.iImage =  - 1;
        tie.pszText = nameTags[tagCount];
        tie.lParam = (LPARAM)wnd;
        TabCtrl_InsertItem((HWND)param, 0, &tie);
        tagCount++;
    }
    return TRUE;
}

//-------------------------------------------------------------------------

void SetTabs(HWND hwnd)
{
    int width = 0;
    SIZE size;
    int i;
    TC_ITEM tie;
    HDC dc = GetDC(hwnd);
    HFONT of = SelectObject(dc, tabBoldFont);
	ShowWindow(hwnd, SW_HIDE);
    TabCtrl_DeleteAllItems(hwnd);
    for (i = 0; i < MAX_CHILDREN + 50; i++)
        if (nameTags[i])
            free(nameTags[i]);
    memset(nameTags, 0, sizeof(nameTags));
    tagCount = 0;
    EnumChildWindows(hwndClient, stEnumProc, (LPARAM)hwnd);
    for (i = 0; i < tagCount; i++)
    {
        GetTextExtentPoint32(dc, nameTags[i], strlen(nameTags[i]), &size);
        if (size.cx > width)
            width = size.cx;
    }
    //   width += 16 ;
    i = TabCtrl_SetItemSize(hwnd, width, 10);
    TabCtrl_SetItemSize(hwnd, width, HIWORD(i));
    SelectObject(dc, of);
    ReleaseDC(hwnd, dc);
	ShowWindow(hwnd, SW_SHOW);
}

//-------------------------------------------------------------------------

LRESULT CALLBACK _export SourceTabProc(HWND hwnd, UINT iMessage, WPARAM wParam,
    LPARAM lParam)
{
    static int index;
    static HFONT tabBoldFont, tabNormalFont;
    static int height;
    static int holdoff;
    TC_ITEM tie;
    NMHDR *h;
    DRAWITEMSTRUCT *dr;
    HFONT font;
    RECT r, r1,  *pr;
    LPTOOLTIPTEXT lpt;
    DWINFO *p;
    int i, ic;
    switch (iMessage)
    {
        case WM_SYSCOMMAND:
            if (wParam == SC_CLOSE)
            {
                SendMessage(hwnd, WM_CLOSE, 0, 0);
            }
            break;
        case WM_GETHEIGHT:
            return height;
        case WM_NOTIFY:
            h = (NMHDR*)lParam;
            switch (h->code)
            {
            case TTN_NEEDTEXT:
                lpt = (LPTOOLTIPTEXT)lParam;
                if (IsWindow(children[lpt->hdr.idFrom]))
                {
                    p = (DWINFO*)GetWindowLong(children[lpt->hdr.idFrom], 0);
                    lpt->lpszText = p->dwName;
                }
                break;
            case TCN_SELCHANGING:
                index = TabCtrl_GetCurSel(hwndTabCtrl);
                tie.mask = TCIF_STATE;
                tie.dwState = 0;
                tie.dwStateMask = TCIS_BUTTONPRESSED;
                //               TabCtrl_SetItem(hwndTabCtrl,index,&tie) ;
                break;
            case TCN_SELCHANGE:
                index = TabCtrl_GetCurSel(hwndTabCtrl);
                tie.mask = TCIF_STATE;
                tie.dwState = TCIS_BUTTONPRESSED;
                tie.dwStateMask = TCIS_BUTTONPRESSED;
                //               TabCtrl_SetItem(hwndTabCtrl,index,&tie) ;
                tie.mask = TCIF_PARAM;
                TabCtrl_GetItem(hwndTabCtrl, index, &tie);
                SendMessage(hwndClient, WM_MDIACTIVATE, (WPARAM)tie.lParam, 0);
                break;
            }
            break;
        case WM_COMMAND:
            //			switch(LOWORD(wParam)) {
            //			}
            break;
        case WM_DRAWITEM:
            dr = (DRAWITEMSTRUCT*)lParam;
            if (dr->itemState &ODS_SELECTED)
                font = tabBoldFont;
            else
                font = tabNormalFont;
            i = tagCount - 1-dr->itemID;
            if (i < 0 || i >= tagCount)
                break;
            if (nameTags[i])
            {
                font = SelectObject(dr->hDC, font);
                TextOut(dr->hDC, dr->rcItem.left + 4, dr->rcItem.top,
                    nameTags[i], strlen(nameTags[i]));
                font = SelectObject(dr->hDC, font);
            }
            break;
        case WM_SETFOCUS:
            break;
        case WM_CREATE:
            hwndSourceTab = hwnd;
            GetClientRect(hwnd, &r);
            tabBoldFont = CreateFontIndirect(&Boldfontdata);
            tabNormalFont = CreateFontIndirect(&Normalfontdata);
            #ifndef __CCDL__
                #ifndef TCS_BOTTOM
                    #define TCS_BOTTOM 2
                #endif 
            #endif 
            hwndTabCtrl = CreateWindow(WC_TABCONTROL, 0, WS_CHILD +
                WS_CLIPSIBLINGS + WS_VISIBLE + WS_DLGFRAME /*+ TCS_OWNERDRAWFIXED */
                + TCS_FOCUSNEVER + /* TCS_MULTILINE +*/ /*TCS_FIXEDWIDTH + */TCS_TOOLTIPS, r.left, r.top,
                r.right - r.left, r.bottom - r.top, hwnd, 0, hInstance, 0);
            SendMessage(hwndTabCtrl, WM_SETFONT, (WPARAM)tabNormalFont, 0);
//			SendMessage(hwndTabCtrl, TCM_SETITEMSIZE, 0, MAKELPARAM(90,16));
            // fall through
        case WM_RESETTABS:
            if (lParam == 1)
                holdoff = TRUE;
            else if (lParam == 2)
                holdoff = FALSE;
            if (holdoff)
                break;
            SetTabs(hwndTabCtrl);
            r.left = 0;
            r.top = 0;
            r.right = 400;
            r.bottom = 400;
            TabCtrl_AdjustRect(hwndTabCtrl, FALSE, &r);
            height = r.top;
            if (height < 10)
                height = 0;
            CalculateLayout( - 1, FALSE);
            return 0;
        case WM_SETACTIVETAB:
            ic = TabCtrl_GetItemCount(hwndTabCtrl);
            for (i = 0; i < ic; i++)
            {
                tie.mask = TCIF_PARAM;
                TabCtrl_GetItem(hwndTabCtrl, i, &tie);
                if (tie.lParam == lParam)
                {
                    TabCtrl_SetCurSel(hwndTabCtrl, i);
                    break;
                }
            }
            break;
        case WM_CLOSE:
            return 0;
        case WM_DESTROY:
            DestroyWindow(hwndTabCtrl);
            break;

        case WM_SIZE:
            r.left = 0;
            r.right = LOWORD(lParam);
            r.top = 0;
            r.bottom = HIWORD(lParam);
            MoveWindow(hwndTabCtrl, r.left, r.top, r.right - r.left, r.bottom -
                r.top, TRUE);
            break;
        default:
            break;
    }
    return DefMDIChildProc(hwnd, iMessage, wParam, lParam);
}

//-------------------------------------------------------------------------

void RegisterSourceTabWindow(void)
{
    WNDCLASS wc;
    memset(&wc, 0, sizeof(wc));
    wc.style = 0;
    wc.lpfnWndProc = &SourceTabProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(0, IDI_APPLICATION);
    wc.hCursor = LoadCursor(0, IDC_ARROW);
    wc.hbrBackground = CreateSolidBrush(GetSysColor(COLOR_3DFACE));
//    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName = 0;
    wc.lpszClassName = szSourceTabClassName;
    RegisterClass(&wc);

}

//-------------------------------------------------------------------------

void CreateSourceTabWindow(void)
{
    MDICREATESTRUCT mc;
    RECT r;
    if (hwndSourceTab)
        return ;
    hwndSourceTab = CreateWindow(szSourceTabClassName, "", WS_CHILD,
        CW_USEDEFAULT, CW_USEDEFAULT, 200, 200, hwndFrame, 0, hInstance, 0);
}
