/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <errno.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <stdio.h>
#include <wchar.h>
#include <locale.h>
#include "libp.h"
#include <sys\stat.h>

static void ConvertBrokendownTime(FILETIME *ft, struct tm *mt)
{
	SYSTEMTIME syst;
	FILETIME ift;
	memset(&syst, 0, sizeof(syst));
	syst.wYear = mt->tm_year + 1900;
	syst.wMonth = mt->tm_mon + 1;
	syst.wDay = mt->tm_mday;
	syst.wHour = mt->tm_hour;
	syst.wMinute = mt->tm_min;
	syst.wSecond = mt->tm_sec;
	SystemTimeToFileTime(&syst, &ift);
	LocalFileTimeToFileTime(&ift, ft);
}
int __ll_utime(int handle, struct tm *access, struct tm * modify)
{
	FILETIME timea, timem ;
	ConvertBrokendownTime(&timea, access);
	ConvertBrokendownTime(&timem, modify);
   return SetFileTime((HANDLE)handle,0,&timea,&timem) ? 0 : -1 ;
}
